/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: netx50regs.h 1892 2014-10-08 06:50:54Z stephans $:

  Description:
    netX50 Register Definitons

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-24  File created.

**************************************************************************************/


// ******************************************************************
// from regdef.v by regdef2h auto-generated C-header file            
// please see the regdef.html file for detailed register description 
// ******************************************************************

#ifndef __regdef_h
#define __regdef_h


// =====================================================================
//
// Area of ARMiTCM_hidden_memarea
//
// =====================================================================

#define NETX_MEM_INSTRUCTION_TCM_AREA	0x00000000U

// =====================================================================
//
// Area of sram0_ahbls0_mirror_nitcm
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM0_MIRROR_NITCM_AREA	0x00000000U

// =====================================================================
//
// Area of iTCM
//
// =====================================================================

#define NETX_MEM_ITCM_AREA	0x00000000U

// ---------------------------------------------------------------------
// Register iTCM_base
// =>  ARM instruction Tightly Coupled Memory start address
//     Area size: 8kB
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_ITCM_BASE 0x00000000U
#define NETX_MEM_ITCM_BASE     0x00000000U

// ---------------------------------------------------------------------
// Register iTCM_end
// =>  ARM instruction Tightly Coupled Memory end address
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_MEM_ITCM_END 0x00001FFCU
#define NETX_MEM_ITCM_END     0x00001FFCU


// =====================================================================
//
// Area of sram1_ahbls1_mirror_nitcm
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM1_MIRROR_NITCM_AREA	0x00008000U

// =====================================================================
//
// Area of sram2_ahbls2_mirror_nitcm
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM2_MIRROR_NITCM_AREA	0x00010000U

// =====================================================================
//
// Area of ahbls4_mirror_nitcm
//
// =====================================================================

#define NETX_MEM_AHBLS4_MIRROR_NITCM_AREA	0x00200000U

// =====================================================================
//
// Area of boot_rom_mirror_nitcm
//
// =====================================================================

#define NETX_MEM_BOOT_ROM_MIRROR_NITCM_AREA	0x00200000U

// =====================================================================
//
// Area of ARMdTCM_hidden_memarea
//
// =====================================================================

#define NETX_MEM_DATA_TCM_AREA	0x04000000U

// =====================================================================
//
// Area of dTCM
//
// =====================================================================

#define NETX_MEM_DATA_TCM_AREA	0x04000000U

// ---------------------------------------------------------------------
// Register dTCM_base
// =>  ARM data Tightly Coupled Memory start address
//     Area size: 4kB
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_DATA_TCM_BASE 0x00000000U
#define NETX_MEM_DATA_TCM_BASE     0x04000000U

// ---------------------------------------------------------------------
// Register dTCM_end
// =>  ARM data Tightly Coupled Memory end address
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_MEM_DATA_TCM_END 0x00000FFCU
#define NETX_MEM_DATA_TCM_END     0x04000FFCU


// =====================================================================
//
// Area of ARM_buf_memarea
//
// =====================================================================

#define NETX_MEM_ARM_BUF_AREA	0x08000000U

// =====================================================================
//
// Area of sram0_ahbls0
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM0_AREA	0x08000000U

// ---------------------------------------------------------------------
// Register intram0_base
// =>  internal SRAM AHBL slave 0 start address
//     Area size: 32kB
//     Read accesses in this memory area: 0WS, byte accessable
//     Write accesses in this memory area: 0WS, byte accessable
//     Offset 0x0 is ROM Boot-vector
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_INTRN_SRAM0_BASE 0x00000000U
#define NETX_MEM_INTRN_SRAM0_BASE     0x08000000U

// ---------------------------------------------------------------------
// Register intram0_end
// =>  internal SRAM AHBL slave 0 end address
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_INTRN_SRAM0_END 0x00007FFCU
#define NETX_MEM_INTRN_SRAM0_END     0x08007FFCU


// =====================================================================
//
// Area of sram1_ahbls1
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM1_AREA	0x08008000U

// ---------------------------------------------------------------------
// Register intram1_base
// =>  internal SRAM AHBL slave 1 start address
//     Area size: 32kB
//     Read accesses in this memory area: 0WS, byte accessable
//     Write accesses in this memory area: 0WS, byte accessable
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_INTRN_SRAM1_BASE 0x00000000U
#define NETX_MEM_INTRN_SRAM1_BASE     0x08008000U

// ---------------------------------------------------------------------
// Register intram1_end
// =>  internal SRAM AHBL slave 1 end address
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_INTRN_SRAM1_END 0x00007FFCU
#define NETX_MEM_INTRN_SRAM1_END     0x0800FFFCU


// =====================================================================
//
// Area of sram2_ahbls2
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM2_AREA	0x08010000U

// ---------------------------------------------------------------------
// Register intram2_base
// =>  internal SRAM AHBL slave 2 start address
//     Area size: 32kB
//     Read accesses in this memory area: 0WS, byte accessable
//     Write accesses in this memory area: 0WS, byte accessable
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_INTRN_SRAM2_BASE 0x00000000U
#define NETX_MEM_INTRN_SRAM2_BASE     0x08010000U

// ---------------------------------------------------------------------
// Register intram2_end
// =>  internal SRAM AHBL slave 2 end address
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_INTRN_SRAM2_END 0x00007FFCU
#define NETX_MEM_INTRN_SRAM2_END     0x08017FFCU


// =====================================================================
//
// Area of ahbls4
//
// =====================================================================

#define NETX_MEM_AHBLS4_AREA	0x08200000U

// =====================================================================
//
// Area of boot_rom
//
// =====================================================================

#define NETX_MEM_BOOT_ROM_AREA	0x08200000U

// ---------------------------------------------------------------------
// Register boot_rom_base
// =>  internal ROM start address
//     Area size: 64kB
//     Read accesses in this memory area: 0WS, byte accessable
//     ROM-content will be mirrored any 32kb between 0x00200000 and 0x002ffffc
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_MEM_BOOT_ROM_BASE 0x00000000U
#define NETX_MEM_BOOT_ROM_BASE     0x08200000U

// ---------------------------------------------------------------------
// Register boot_rom_end
// =>  internal ROM end address
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_MEM_BOOT_ROM_END 0x0000FFFCU
#define NETX_MEM_BOOT_ROM_END     0x0820FFFCU


// =====================================================================
//
// Area of intlogic_ahbls5_mirror_buf
//
// =====================================================================

#define NETX_MEM_INTLOGIC_MIRROR_BUF_AREA	0x0C000000U

// =====================================================================
//
// Area of ARM_nbuf_memarea
//
// =====================================================================

#define NETX_MEM_ARM_NBUF_AREA	0x10000000U

// =====================================================================
//
// Area of sram0_ahbls0_mirror_nbuf
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM0_MIRROR_NBUF_AREA	0x10000000U

// =====================================================================
//
// Area of sram1_ahbls1_mirror_nbuf
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM1_MIRROR_NBUF_AREA	0x10008000U

// =====================================================================
//
// Area of sram2_ahbls2_mirror_nbuf
//
// =====================================================================

#define NETX_MEM_INTRN_SRAM2_MIRROR_NBUF_AREA	0x10010000U

// =====================================================================
//
// Area of ahbls4_mirror_nbuf
//
// =====================================================================

#define NETX_MEM_AHBLS4_MIRROR_NBUF_AREA	0x10200000U

// =====================================================================
//
// Area of boot_rom_mirror_nbuf
//
// =====================================================================

#define NETX_MEM_BOOT_ROM_MIRROR_NBUF_AREA	0x10200000U

// =====================================================================
//
// Area of ARM_nbuf_regarea
//
// =====================================================================

#define NETX_MEM_ARM_NBUF_REG_AREA	0x18000000U

// =====================================================================
//
// Area of intlogic_ahbls5
//
// =====================================================================

#define NETX_MEM_INTLOGIC_AREA	0x1C000000U

// =====================================================================
//
// Area of asic_ctrl
//
// =====================================================================

#define NETX_CTRL_AREA	0x1C000000U

// ---------------------------------------------------------------------
// Register io_status
// =>  IO bondout status registers
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_BOO_STAT 0x00000000U
#define NETX_BOO_STAT     0x1C000000U

#define MSK_NETX_BOO_STAT_bond_option0 0x00000007U // [2:0]
#define SRT_NETX_BOO_STAT_bond_option0 0
#define MSK_NETX_BOO_STAT_quick_count  0x00000008U // [3]
#define SRT_NETX_BOO_STAT_quick_count  3
#define MSK_NETX_BOO_STAT_arm100       0x00000010U // [4]
#define SRT_NETX_BOO_STAT_arm100       4
#define MSK_NETX_BOO_STAT_pll_bypass   0x00000020U // [5]
#define SRT_NETX_BOO_STAT_pll_bypass   5
#define MSK_NETX_BOO_STAT_sim_reserve0 0x00000040U // [6]
#define SRT_NETX_BOO_STAT_sim_reserve0 6
#define MSK_NETX_BOO_STAT_TEST         0x00000080U // [7]
#define SRT_NETX_BOO_STAT_TEST         7

enum {
	BFW_NETX_BOO_STAT_bond_option0 = 3,  // [2:0]
	BFW_NETX_BOO_STAT_quick_count  = 1,  // [3]
	BFW_NETX_BOO_STAT_arm100       = 1,  // [4]
	BFW_NETX_BOO_STAT_pll_bypass   = 1,  // [5]
	BFW_NETX_BOO_STAT_sim_reserve0 = 1,  // [6]
	BFW_NETX_BOO_STAT_TEST         = 1,  // [7]
	BFW_NETX_BOO_STAT_reserved1    = 24  // [31:8]
};

typedef struct IO_STATUS_BIT_Ttag {
	unsigned int bond_option0 : BFW_NETX_BOO_STAT_bond_option0; // Value of Bond-Option Pin2 - Pin0
	                                                        // BO2 BO1 BO0  Function
	                                                        //  0   0   0   BOOT_BONDOUT_NETX500PCI
	                                                        //  0   0   1   BOOT_BONDOUT_NETX500_PLC
	                                                        //  0   1   0   BOOT_BONDOUT_NETX500_MASTER
	                                                        //  0   1   1   BOOT_BONDOUT_NETX500
	                                                        //  1   0   0   BOOT_BONDOUT_NETX100_MASTER
	                                                        //  1   0   1   BOOT_BONDOUT_NETX100
	                                                        //  1   1   0   BOOT_BONDOUT_NETX50
	                                                        //  1   1   1   BOOT_BONDOUT_BACKDOOR
	unsigned int quick_count  : BFW_NETX_BOO_STAT_quick_count;  // Testmode 'quick_count' is activated by external pins
	                                                        // -> diverse internal counters count faster (RTC-clock-divider, PLL-stby-controller,...)
	unsigned int arm100       : BFW_NETX_BOO_STAT_arm100;       // Testmode 'arm100' is activated by external pins
	                                                        // -> ARM926 runs on system frequency (100MHz) instead of double system frequency (200MHz)
	unsigned int pll_bypass   : BFW_NETX_BOO_STAT_pll_bypass;   // Testmode 'pll_bypass' is activated by external pins
	                                                        // -> 400MHz-PLL is bypassed, PLL output is unused, 400MHz-Clocks (clk400, clk400_2sdram) is directly connected to XTALIN
	unsigned int sim_reserve0 : BFW_NETX_BOO_STAT_sim_reserve0; // arm_crashdetect_cpclken (netX50 only). For HSoCT Simulation purpose only!!!
	unsigned int TEST         : BFW_NETX_BOO_STAT_TEST;         // sampled netx TEST input for Productiontest purpose
	unsigned int reserved1    : BFW_NETX_BOO_STAT_reserved1;    // reserved
} IO_STATUS_BIT_T;

typedef union {
	unsigned int    val;
	IO_STATUS_BIT_T bf;
} IO_STATUS_T;

// ---------------------------------------------------------------------
// Register io_config
// =>  IO config registers
//     Selects of output pin multiplexing.
//     See Excel pinning sheet for details.
//     Selects can only be activated, if appropriate bit of io_config_mask is set.
//     Bits will be reset according to the io_config_mask-register register if a new mask is correctly written (netX locking algorithm).
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_IO_CFG 0x00000004U
#define NETX_IO_CFG     0x1C000004U

#define MSK_NETX_IO_CFG_sel_xm0_tx    0x00000001U // [0]
#define SRT_NETX_IO_CFG_sel_xm0_tx    0
#define MSK_NETX_IO_CFG_sel_xm1_tx    0x00000002U // [1]
#define SRT_NETX_IO_CFG_sel_xm1_tx    1
#define MSK_NETX_IO_CFG_sel_fb0_clk_a 0x00000004U // [2]
#define SRT_NETX_IO_CFG_sel_fb0_clk_a 2
#define MSK_NETX_IO_CFG_sel_fb0_clk_b 0x00000008U // [3]
#define SRT_NETX_IO_CFG_sel_fb0_clk_b 3
#define MSK_NETX_IO_CFG_sel_fb1_clk_a 0x00000010U // [4]
#define SRT_NETX_IO_CFG_sel_fb1_clk_a 4
#define MSK_NETX_IO_CFG_sel_fb1_clk_b 0x00000020U // [5]
#define SRT_NETX_IO_CFG_sel_fb1_clk_b 5
#define MSK_NETX_IO_CFG_sel_fo0       0x00000040U // [6]
#define SRT_NETX_IO_CFG_sel_fo0       6
#define MSK_NETX_IO_CFG_sel_fo1       0x00000080U // [7]
#define SRT_NETX_IO_CFG_sel_fo1       7
#define MSK_NETX_IO_CFG_sel_xm0_eclk  0x00000100U // [8]
#define SRT_NETX_IO_CFG_sel_xm0_eclk  8
#define MSK_NETX_IO_CFG_sel_xm1_eclk  0x00000200U // [9]
#define SRT_NETX_IO_CFG_sel_xm1_eclk  9
#define MSK_NETX_IO_CFG_sel_i2c_mmio  0x00000400U // [10]
#define SRT_NETX_IO_CFG_sel_i2c_mmio  10
#define MSK_NETX_IO_CFG_sel_etm       0x00800000U // [23]
#define SRT_NETX_IO_CFG_sel_etm       23
#define MSK_NETX_IO_CFG_sel_ext_phy0  0x20000000U // [29]
#define SRT_NETX_IO_CFG_sel_ext_phy0  29
#define MSK_NETX_IO_CFG_sel_ext_phy1  0x40000000U // [30]
#define SRT_NETX_IO_CFG_sel_ext_phy1  30
#define MSK_NETX_IO_CFG_if_select_n   0x80000000U // [31]
#define SRT_NETX_IO_CFG_if_select_n   31

enum {
	BFW_NETX_IO_CFG_sel_xm0_tx    = 1,  // [0]
	BFW_NETX_IO_CFG_sel_xm1_tx    = 1,  // [1]
	BFW_NETX_IO_CFG_sel_fb0_clk_a = 1,  // [2]
	BFW_NETX_IO_CFG_sel_fb0_clk_b = 1,  // [3]
	BFW_NETX_IO_CFG_sel_fb1_clk_a = 1,  // [4]
	BFW_NETX_IO_CFG_sel_fb1_clk_b = 1,  // [5]
	BFW_NETX_IO_CFG_sel_fo0       = 1,  // [6]
	BFW_NETX_IO_CFG_sel_fo1       = 1,  // [7]
	BFW_NETX_IO_CFG_sel_xm0_eclk  = 1,  // [8]
	BFW_NETX_IO_CFG_sel_xm1_eclk  = 1,  // [9]
	BFW_NETX_IO_CFG_sel_i2c_mmio  = 1,  // [10]
	BFW_NETX_IO_CFG_reserved1     = 12, // [22:11]
	BFW_NETX_IO_CFG_sel_etm       = 1,  // [23]
	BFW_NETX_IO_CFG_reserved2     = 5,  // [28:24]
	BFW_NETX_IO_CFG_sel_ext_phy0  = 1,  // [29]
	BFW_NETX_IO_CFG_sel_ext_phy1  = 1,  // [30]
	BFW_NETX_IO_CFG_if_select_n   = 1   // [31]
};

typedef struct IO_CONFIG_BIT_Ttag {
	unsigned int sel_xm0_tx    : BFW_NETX_IO_CFG_sel_xm0_tx;    // select pad for xMAC0 tx-bitstream direct output (s. pinning.xls)
	unsigned int sel_xm1_tx    : BFW_NETX_IO_CFG_sel_xm1_tx;    // select pad for xMAC1 tx-bitstream direct output (s. pinning.xls)
	unsigned int sel_fb0_clk_a : BFW_NETX_IO_CFG_sel_fb0_clk_a; // select pad for fieldbus-clk0 at position a (s. pinning.xls)
	unsigned int sel_fb0_clk_b : BFW_NETX_IO_CFG_sel_fb0_clk_b; // select pad for fieldbus-clk0 at position b (s. pinning.xls)
	unsigned int sel_fb1_clk_a : BFW_NETX_IO_CFG_sel_fb1_clk_a; // select pad for fieldbus-clk1 at position a (s. pinning.xls)
	unsigned int sel_fb1_clk_b : BFW_NETX_IO_CFG_sel_fb1_clk_b; // select pad for fieldbus-clk1 at position b (s. pinning.xls)
	unsigned int sel_fo0       : BFW_NETX_IO_CFG_sel_fo0;       // select outputs for Fiber Optics of Phy0
	unsigned int sel_fo1       : BFW_NETX_IO_CFG_sel_fo1;       // select outputs for Fiber Optics of Phy1
	unsigned int sel_xm0_eclk  : BFW_NETX_IO_CFG_sel_xm0_eclk;  // select pad for xMAC0 eclk (s. pinning.xls)
	unsigned int sel_xm1_eclk  : BFW_NETX_IO_CFG_sel_xm1_eclk;  // select pad for xMAC1 eclk (s. pinning.xls)
	unsigned int sel_i2c_mmio  : BFW_NETX_IO_CFG_sel_i2c_mmio;  // select I2C via MMIOs instead of dedicated I2C_SDA/I2C_SCL-pads
	unsigned int reserved1     : BFW_NETX_IO_CFG_reserved1;     // reserved
	unsigned int sel_etm       : BFW_NETX_IO_CFG_sel_etm;       // select pins for ETM9 of ARM926
	unsigned int reserved2     : BFW_NETX_IO_CFG_reserved2;     // reserved
	unsigned int sel_ext_phy0  : BFW_NETX_IO_CFG_sel_ext_phy0;  // select external instead of internal phy0
	unsigned int sel_ext_phy1  : BFW_NETX_IO_CFG_sel_ext_phy1;  // select external instead of internal phy1
	unsigned int if_select_n   : BFW_NETX_IO_CFG_if_select_n;   // inverted HIF if-select signal:
	                                                        // 1: PCI-Mode, 0: DPM/PIO-Mode
} IO_CONFIG_BIT_T;

typedef union {
	unsigned int    val;
	IO_CONFIG_BIT_T bf;
} IO_CONFIG_T;

// ---------------------------------------------------------------------
// Register io_config_mask
// =>  IO config mask registers
//     Masks of output pin multiplexing select signals.
//     This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres.
//     The io_config-register will change according to this register if a new mask is correctly written (netX locking algorithm).
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_IO_CFG_MSK 0x00000008U
#define NETX_IO_CFG_MSK     0x1C000008U

#define MSK_NETX_IO_CFG_MSK_sel_xm0_tx    0x00000001U // [0]
#define SRT_NETX_IO_CFG_MSK_sel_xm0_tx    0
#define MSK_NETX_IO_CFG_MSK_sel_xm1_tx    0x00000002U // [1]
#define SRT_NETX_IO_CFG_MSK_sel_xm1_tx    1
#define MSK_NETX_IO_CFG_MSK_sel_fb0_clk_a 0x00000004U // [2]
#define SRT_NETX_IO_CFG_MSK_sel_fb0_clk_a 2
#define MSK_NETX_IO_CFG_MSK_sel_fb0_clk_b 0x00000008U // [3]
#define SRT_NETX_IO_CFG_MSK_sel_fb0_clk_b 3
#define MSK_NETX_IO_CFG_MSK_sel_fb1_clk_a 0x00000010U // [4]
#define SRT_NETX_IO_CFG_MSK_sel_fb1_clk_a 4
#define MSK_NETX_IO_CFG_MSK_sel_fb1_clk_b 0x00000020U // [5]
#define SRT_NETX_IO_CFG_MSK_sel_fb1_clk_b 5
#define MSK_NETX_IO_CFG_MSK_sel_fo0       0x00000040U // [6]
#define SRT_NETX_IO_CFG_MSK_sel_fo0       6
#define MSK_NETX_IO_CFG_MSK_sel_fo1       0x00000080U // [7]
#define SRT_NETX_IO_CFG_MSK_sel_fo1       7
#define MSK_NETX_IO_CFG_MSK_sel_xm0_eclk  0x00000100U // [8]
#define SRT_NETX_IO_CFG_MSK_sel_xm0_eclk  8
#define MSK_NETX_IO_CFG_MSK_sel_xm1_eclk  0x00000200U // [9]
#define SRT_NETX_IO_CFG_MSK_sel_xm1_eclk  9
#define MSK_NETX_IO_CFG_MSK_sel_i2c_mmio  0x00000400U // [10]
#define SRT_NETX_IO_CFG_MSK_sel_i2c_mmio  10
#define MSK_NETX_IO_CFG_MSK_sel_etm       0x00800000U // [23]
#define SRT_NETX_IO_CFG_MSK_sel_etm       23
#define MSK_NETX_IO_CFG_MSK_sel_ext_phy0  0x20000000U // [29]
#define SRT_NETX_IO_CFG_MSK_sel_ext_phy0  29
#define MSK_NETX_IO_CFG_MSK_sel_ext_phy1  0x40000000U // [30]
#define SRT_NETX_IO_CFG_MSK_sel_ext_phy1  30
#define MSK_NETX_IO_CFG_MSK_if_select_n   0x80000000U // [31]
#define SRT_NETX_IO_CFG_MSK_if_select_n   31

enum {
	BFW_NETX_IO_CFG_MSK_sel_xm0_tx    = 1,  // [0]
	BFW_NETX_IO_CFG_MSK_sel_xm1_tx    = 1,  // [1]
	BFW_NETX_IO_CFG_MSK_sel_fb0_clk_a = 1,  // [2]
	BFW_NETX_IO_CFG_MSK_sel_fb0_clk_b = 1,  // [3]
	BFW_NETX_IO_CFG_MSK_sel_fb1_clk_a = 1,  // [4]
	BFW_NETX_IO_CFG_MSK_sel_fb1_clk_b = 1,  // [5]
	BFW_NETX_IO_CFG_MSK_sel_fo0       = 1,  // [6]
	BFW_NETX_IO_CFG_MSK_sel_fo1       = 1,  // [7]
	BFW_NETX_IO_CFG_MSK_sel_xm0_eclk  = 1,  // [8]
	BFW_NETX_IO_CFG_MSK_sel_xm1_eclk  = 1,  // [9]
	BFW_NETX_IO_CFG_MSK_sel_i2c_mmio  = 1,  // [10]
	BFW_NETX_IO_CFG_MSK_reserved1     = 12, // [22:11]
	BFW_NETX_IO_CFG_MSK_sel_etm       = 1,  // [23]
	BFW_NETX_IO_CFG_MSK_reserved2     = 5,  // [28:24]
	BFW_NETX_IO_CFG_MSK_sel_ext_phy0  = 1,  // [29]
	BFW_NETX_IO_CFG_MSK_sel_ext_phy1  = 1,  // [30]
	BFW_NETX_IO_CFG_MSK_if_select_n   = 1   // [31]
};

typedef struct IO_CONFIG_MASK_BIT_Ttag {
	unsigned int sel_xm0_tx    : BFW_NETX_IO_CFG_MSK_sel_xm0_tx;    // select pad for xMAC0 tx-bitstream direct output (s. pinning.xls)
	unsigned int sel_xm1_tx    : BFW_NETX_IO_CFG_MSK_sel_xm1_tx;    // select pad for xMAC1 tx-bitstream direct output (s. pinning.xls)
	unsigned int sel_fb0_clk_a : BFW_NETX_IO_CFG_MSK_sel_fb0_clk_a; // select pad for fieldbus-clk0 at position a (s. pinning.xls)
	unsigned int sel_fb0_clk_b : BFW_NETX_IO_CFG_MSK_sel_fb0_clk_b; // select pad for fieldbus-clk0 at position b (s. pinning.xls)
	unsigned int sel_fb1_clk_a : BFW_NETX_IO_CFG_MSK_sel_fb1_clk_a; // select pad for fieldbus-clk1 at position a (s. pinning.xls)
	unsigned int sel_fb1_clk_b : BFW_NETX_IO_CFG_MSK_sel_fb1_clk_b; // select pad for fieldbus-clk1 at position b (s. pinning.xls)
	unsigned int sel_fo0       : BFW_NETX_IO_CFG_MSK_sel_fo0;       // select outputs for Fiber Optics of Phy0
	unsigned int sel_fo1       : BFW_NETX_IO_CFG_MSK_sel_fo1;       // select outputs for Fiber Optics of Phy1
	unsigned int sel_xm0_eclk  : BFW_NETX_IO_CFG_MSK_sel_xm0_eclk;  // select pad for xMAC0 eclk (s. pinning.xls)
	unsigned int sel_xm1_eclk  : BFW_NETX_IO_CFG_MSK_sel_xm1_eclk;  // select pad for xMAC1 eclk (s. pinning.xls)
	unsigned int sel_i2c_mmio  : BFW_NETX_IO_CFG_MSK_sel_i2c_mmio;  // select I2C via MMIOs instead of dedicated I2C_SDA/I2C_SCL-pads
	unsigned int reserved1     : BFW_NETX_IO_CFG_MSK_reserved1;     // reserved
	unsigned int sel_etm       : BFW_NETX_IO_CFG_MSK_sel_etm;       // mask of select pins for ETM9 of ARM926
	unsigned int reserved2     : BFW_NETX_IO_CFG_MSK_reserved2;     // reserved
	unsigned int sel_ext_phy0  : BFW_NETX_IO_CFG_MSK_sel_ext_phy0;  // select external instead of internal phy0
	unsigned int sel_ext_phy1  : BFW_NETX_IO_CFG_MSK_sel_ext_phy1;  // select external instead of internal phy1
	unsigned int if_select_n   : BFW_NETX_IO_CFG_MSK_if_select_n;   // inverted HIF if-select signal:
	                                                        // 1: PCI-Mode, 0: DPM/PIO-Mode
} IO_CONFIG_MASK_BIT_T;

typedef union {
	unsigned int         val;
	IO_CONFIG_MASK_BIT_T bf;
} IO_CONFIG_MASK_T;

// ---------------------------------------------------------------------
// Register reset_ctrl
// =>  Reset Control Register
//     register for reading the reset state of all resets, and to set two different Software Resets
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_RESET_CTRL 0x0000000CU
#define NETX_RESET_CTRL     0x1C00000CU

#define MSK_NETX_RESET_CTRL_RES_IN           0x00000001U // [0]
#define SRT_NETX_RESET_CTRL_RES_IN           0
#define MSK_NETX_RESET_CTRL_RES_WDOG         0x00000002U // [1]
#define SRT_NETX_RESET_CTRL_RES_WDOG         1
#define MSK_NETX_RESET_CTRL_RES_HOST         0x00000004U // [2]
#define SRT_NETX_RESET_CTRL_RES_HOST         2
#define MSK_NETX_RESET_CTRL_RES_FIRMWARE     0x00000008U // [3]
#define SRT_NETX_RESET_CTRL_RES_FIRMWARE     3
#define MSK_NETX_RESET_CTRL_RES_XPEC0        0x00000010U // [4]
#define SRT_NETX_RESET_CTRL_RES_XPEC0        4
#define MSK_NETX_RESET_CTRL_RES_XPEC1        0x00000020U // [5]
#define SRT_NETX_RESET_CTRL_RES_XPEC1        5
#define MSK_NETX_RESET_CTRL_DIS_RES_XPEC0    0x00010000U // [16]
#define SRT_NETX_RESET_CTRL_DIS_RES_XPEC0    16
#define MSK_NETX_RESET_CTRL_DIS_RES_XPEC1    0x00020000U // [17]
#define SRT_NETX_RESET_CTRL_DIS_RES_XPEC1    17
#define MSK_NETX_RESET_CTRL_FIRMWARE_STATUS0 0x00100000U // [20]
#define SRT_NETX_RESET_CTRL_FIRMWARE_STATUS0 20
#define MSK_NETX_RESET_CTRL_FIRMWARE_STATUS1 0x00200000U // [21]
#define SRT_NETX_RESET_CTRL_FIRMWARE_STATUS1 21
#define MSK_NETX_RESET_CTRL_FIRMWARE_STATUS2 0x00400000U // [22]
#define SRT_NETX_RESET_CTRL_FIRMWARE_STATUS2 22
#define MSK_NETX_RESET_CTRL_FIRMWARE_STATUS3 0x00800000U // [23]
#define SRT_NETX_RESET_CTRL_FIRMWARE_STATUS3 23
#define MSK_NETX_RESET_CTRL_RES_REQ_FIRMWARE 0x01000000U // [24]
#define SRT_NETX_RESET_CTRL_RES_REQ_FIRMWARE 24
#define MSK_NETX_RESET_CTRL_RES_REQ_OUT      0x02000000U // [25]
#define SRT_NETX_RESET_CTRL_RES_REQ_OUT      25
#define MSK_NETX_RESET_CTRL_EN_RES_REQ_OUT   0x04000000U // [26]
#define SRT_NETX_RESET_CTRL_EN_RES_REQ_OUT   26

enum {
	BFW_NETX_RESET_CTRL_RES_IN           = 1,  // [0]
	BFW_NETX_RESET_CTRL_RES_WDOG         = 1,  // [1]
	BFW_NETX_RESET_CTRL_RES_HOST         = 1,  // [2]
	BFW_NETX_RESET_CTRL_RES_FIRMWARE     = 1,  // [3]
	BFW_NETX_RESET_CTRL_RES_XPEC0        = 1,  // [4]
	BFW_NETX_RESET_CTRL_RES_XPEC1        = 1,  // [5]
	BFW_NETX_RESET_CTRL_reserved1        = 10, // [15:6]
	BFW_NETX_RESET_CTRL_DIS_RES_XPEC0    = 1,  // [16]
	BFW_NETX_RESET_CTRL_DIS_RES_XPEC1    = 1,  // [17]
	BFW_NETX_RESET_CTRL_reserved2        = 2,  // [19:18]
	BFW_NETX_RESET_CTRL_FIRMWARE_STATUS0 = 1,  // [20]
	BFW_NETX_RESET_CTRL_FIRMWARE_STATUS1 = 1,  // [21]
	BFW_NETX_RESET_CTRL_FIRMWARE_STATUS2 = 1,  // [22]
	BFW_NETX_RESET_CTRL_FIRMWARE_STATUS3 = 1,  // [23]
	BFW_NETX_RESET_CTRL_RES_REQ_FIRMWARE = 1,  // [24]
	BFW_NETX_RESET_CTRL_RES_REQ_OUT      = 1,  // [25]
	BFW_NETX_RESET_CTRL_EN_RES_REQ_OUT   = 1,  // [26]
	BFW_NETX_RESET_CTRL_reserved3        = 5   // [31:27]
};

typedef struct RESET_CTRL_BIT_Ttag {
	unsigned int RES_IN           : BFW_NETX_RESET_CTRL_RES_IN;           // reset from external pin, after reading write back a "1" to clear the status bit
	unsigned int RES_WDOG         : BFW_NETX_RESET_CTRL_RES_WDOG;         // reset from System WDG, after reading write back a "1" to clear the status bit
	unsigned int RES_HOST         : BFW_NETX_RESET_CTRL_RES_HOST;         // reset from Hostinterface, after reading write back a "1" to clear the status bit
	unsigned int RES_FIRMWARE     : BFW_NETX_RESET_CTRL_RES_FIRMWARE;     // reset from FIRMWARE (software reset), after reading write back a "1" to clear the status bit
	unsigned int RES_XPEC0        : BFW_NETX_RESET_CTRL_RES_XPEC0;        // reset from RES_XPEC0, after reading write back a "1" to clear the status bit
	unsigned int RES_XPEC1        : BFW_NETX_RESET_CTRL_RES_XPEC1;        // reset from RES_XPEC1, after reading write back a "1" to clear the status bit
	unsigned int reserved1        : BFW_NETX_RESET_CTRL_reserved1;        // reserved
	unsigned int DIS_RES_XPEC0    : BFW_NETX_RESET_CTRL_DIS_RES_XPEC0;    // reset from RES_XPEC0 is disabled (read only)
	unsigned int DIS_RES_XPEC1    : BFW_NETX_RESET_CTRL_DIS_RES_XPEC1;    // reset from RES_XPEC1 is disabled (read only)
	unsigned int reserved2        : BFW_NETX_RESET_CTRL_reserved2;        // reserved
	unsigned int FIRMWARE_STATUS0 : BFW_NETX_RESET_CTRL_FIRMWARE_STATUS0; // readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit
	unsigned int FIRMWARE_STATUS1 : BFW_NETX_RESET_CTRL_FIRMWARE_STATUS1; // readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit
	unsigned int FIRMWARE_STATUS2 : BFW_NETX_RESET_CTRL_FIRMWARE_STATUS2; // readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit
	unsigned int FIRMWARE_STATUS3 : BFW_NETX_RESET_CTRL_FIRMWARE_STATUS3; // readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit
	unsigned int RES_REQ_FIRMWARE : BFW_NETX_RESET_CTRL_RES_REQ_FIRMWARE; // (software reset) writing a "1" sets the reset request to reset the hole system (write only)
	unsigned int RES_REQ_OUT      : BFW_NETX_RESET_CTRL_RES_REQ_OUT;      // (software reset) programmable reset sets the reset on the external pin
	unsigned int EN_RES_REQ_OUT   : BFW_NETX_RESET_CTRL_EN_RES_REQ_OUT;   // this bit enables the programmable reset
	unsigned int reserved3        : BFW_NETX_RESET_CTRL_reserved3;        // reserved
} RESET_CTRL_BIT_T;

typedef union {
	unsigned int     val;
	RESET_CTRL_BIT_T bf;
} RESET_CTRL_T;

// ---------------------------------------------------------------------
// Register phy_control
// =>  Phy Controll Register
//     This register contains all static connectors of the NEC Ethernet Phy.
//     Usually the Phy read these values only during reset, which can be controlled by Bit31.
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     In total the programming sequence should be:
//     a: read access key, write access key, write new value with bit phy_reset=1
//     b: wait for synchronization(~16cc) and proper reset of phy(~40cc ? better check NEC document)
//     c: read access key, write access key, write new value with bit phy_reset=0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_PHY_CTRL 0x00000010U
#define NETX_PHY_CTRL     0x1C000010U

#define MSK_NETX_PHY_CTRL_phy_address      0x0000000fU // [3:0]
#define SRT_NETX_PHY_CTRL_phy_address      0
#define MSK_NETX_PHY_CTRL_phy1_mode        0x00000070U // [6:4]
#define SRT_NETX_PHY_CTRL_phy1_mode        4
#define MSK_NETX_PHY_CTRL_phy1_fxmode      0x00000080U // [7]
#define SRT_NETX_PHY_CTRL_phy1_fxmode      7
#define MSK_NETX_PHY_CTRL_phy1_automdix    0x00000100U // [8]
#define SRT_NETX_PHY_CTRL_phy1_automdix    8
#define MSK_NETX_PHY_CTRL_phy1_np_msg_code 0x00000e00U // [11:9]
#define SRT_NETX_PHY_CTRL_phy1_np_msg_code 9
#define MSK_NETX_PHY_CTRL_phy1_enable      0x00001000U // [12]
#define SRT_NETX_PHY_CTRL_phy1_enable      12
#define MSK_NETX_PHY_CTRL_phy2_mode        0x0000e000U // [15:13]
#define SRT_NETX_PHY_CTRL_phy2_mode        13
#define MSK_NETX_PHY_CTRL_phy2_fxmode      0x00010000U // [16]
#define SRT_NETX_PHY_CTRL_phy2_fxmode      16
#define MSK_NETX_PHY_CTRL_phy2_automdix    0x00020000U // [17]
#define SRT_NETX_PHY_CTRL_phy2_automdix    17
#define MSK_NETX_PHY_CTRL_phy2_np_msg_code 0x001c0000U // [20:18]
#define SRT_NETX_PHY_CTRL_phy2_np_msg_code 18
#define MSK_NETX_PHY_CTRL_phy2_enable      0x00200000U // [21]
#define SRT_NETX_PHY_CTRL_phy2_enable      21
#define MSK_NETX_PHY_CTRL_phy_clk_xlatin   0x20000000U // [29]
#define SRT_NETX_PHY_CTRL_phy_clk_xlatin   29
#define MSK_NETX_PHY_CTRL_phy_sim_byp      0x40000000U // [30]
#define SRT_NETX_PHY_CTRL_phy_sim_byp      30
#define MSK_NETX_PHY_CTRL_phy_reset        0x80000000U // [31]
#define SRT_NETX_PHY_CTRL_phy_reset        31

enum {
	BFW_NETX_PHY_CTRL_phy_address      = 4, // [3:0]
	BFW_NETX_PHY_CTRL_phy1_mode        = 3, // [6:4]
	BFW_NETX_PHY_CTRL_phy1_fxmode      = 1, // [7]
	BFW_NETX_PHY_CTRL_phy1_automdix    = 1, // [8]
	BFW_NETX_PHY_CTRL_phy1_np_msg_code = 3, // [11:9]
	BFW_NETX_PHY_CTRL_phy1_enable      = 1, // [12]
	BFW_NETX_PHY_CTRL_phy2_mode        = 3, // [15:13]
	BFW_NETX_PHY_CTRL_phy2_fxmode      = 1, // [16]
	BFW_NETX_PHY_CTRL_phy2_automdix    = 1, // [17]
	BFW_NETX_PHY_CTRL_phy2_np_msg_code = 3, // [20:18]
	BFW_NETX_PHY_CTRL_phy2_enable      = 1, // [21]
	BFW_NETX_PHY_CTRL_reserved1        = 7, // [28:22]
	BFW_NETX_PHY_CTRL_phy_clk_xlatin   = 1, // [29]
	BFW_NETX_PHY_CTRL_phy_sim_byp      = 1, // [30]
	BFW_NETX_PHY_CTRL_phy_reset        = 1  // [31]
};

typedef struct PHY_CONTROL_BIT_Ttag {
	unsigned int phy_address      : BFW_NETX_PHY_CTRL_phy_address;      // Bits 4:1 of phy mdio-address.
	                                                        // Bit0 defines 1st or 2nd internal phy
	unsigned int phy1_mode        : BFW_NETX_PHY_CTRL_phy1_mode;        // Phy1 Mode:
	                                                        // 000: 10BASE-T Half Duplex, Auto Negotiation disabled.
	                                                        // 001: 10BASE-T Full Duplex. Auto-Negotiation disabled.
	                                                        // 010: 100BASE-TX/FX Half Duplex. Auto-Negotiation disabled. CRS is active during Transmit & Receive.
	                                                        // 011: 100BASE-TX/FX Full Duplex. Auto-Negotiation disabled. CRS is active during Receive.
	                                                        // 100: 100BASE-TX Half Duplex is advertised. Auto-Negotiation enabled. CRS is active during Transmit & Receive.
	                                                        // 101: Repeater mode. Auto-Negotiation enabled. 100BASETX Half Duplex is advertised. CRS is active during Receive.
	                                                        // 110: Power Down mode. In this mode the PHY wake-up in Power-Down mode.
	                                                        // 111: All capable. Auto-Negotiation enabled. AutoMDIX enabled.
	unsigned int phy1_fxmode      : BFW_NETX_PHY_CTRL_phy1_fxmode;      // Phy1 100BASE-FX mode (phy_mode must be 01x)
	unsigned int phy1_automdix    : BFW_NETX_PHY_CTRL_phy1_automdix;    // Phy1 Enables AutoMDIX state machine
	unsigned int phy1_np_msg_code : BFW_NETX_PHY_CTRL_phy1_np_msg_code; // Phy1 Next Page Message Code (auto negotiation)
	unsigned int phy1_enable      : BFW_NETX_PHY_CTRL_phy1_enable;      // Phy1 enable
	unsigned int phy2_mode        : BFW_NETX_PHY_CTRL_phy2_mode;        // Phy2 Mode:
	                                                        // 000: 10BASE-T Half Duplex, Auto Negotiation disabled.
	                                                        // 001: 10BASE-T Full Duplex. Auto-Negotiation disabled.
	                                                        // 010: 100BASE-TX/FX Half Duplex. Auto-Negotiation disabled. CRS is active during Transmit & Receive.
	                                                        // 011: 100BASE-TX/FX Full Duplex. Auto-Negotiation disabled. CRS is active during Receive.
	                                                        // 100: 100BASE-TX Half Duplex is advertised. Auto-Negotiation enabled. CRS is active during Transmit & Receive.
	                                                        // 101: Repeater mode. Auto-Negotiation enabled. 100BASETX Half Duplex is advertised. CRS is active during Receive.
	                                                        // 110: Power Down mode. In this mode the PHY wake-up in Power-Down mode.
	                                                        // 111: All capable. Auto-Negotiation enabled. AutoMDIX enabled.
	unsigned int phy2_fxmode      : BFW_NETX_PHY_CTRL_phy2_fxmode;      // Phy2 100BASE-FX mode (phy_mode must be 01x)
	unsigned int phy2_automdix    : BFW_NETX_PHY_CTRL_phy2_automdix;    // Phy2 Enables AutoMDIX state machine
	unsigned int phy2_np_msg_code : BFW_NETX_PHY_CTRL_phy2_np_msg_code; // Phy2 Next Page Message Code (auto negotiation)
	unsigned int phy2_enable      : BFW_NETX_PHY_CTRL_phy2_enable;      // Phy2 enable
	unsigned int reserved1        : BFW_NETX_PHY_CTRL_reserved1;        // reserved
	unsigned int phy_clk_xlatin   : BFW_NETX_PHY_CTRL_phy_clk_xlatin;   // 1: use the external oscillator input (25MHz) to clock ethernet Phy # defautl 1
	                                                        // 0: use phyclk_rate_mul_add (further down) to clock ethernet Phy
	unsigned int phy_sim_byp      : BFW_NETX_PHY_CTRL_phy_sim_byp;      // Phy Power up Bypass: 0=normal | 1=bypass, # defautl 0
	                                                        // Only used for simulation issues.
	                                                        // Bit is synchronized to phyclk and drives pwruprstbyp pin of PHY,
	                                                        // which bypasses Power Up Reset of Phy for faster simulation.
	unsigned int phy_reset        : BFW_NETX_PHY_CTRL_phy_reset;        // Hardware reset for PHY: 1=reset
} PHY_CONTROL_BIT_T;

typedef union {
	unsigned int      val;
	PHY_CONTROL_BIT_T bf;
} PHY_CONTROL_T;

// ---------------------------------------------------------------------
// Register armclk_rate_mul_add
// =>  Rate Multiplier Add Value
//     This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres.
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_ARM_CLK_RATE_MUL_ADD 0x00000014U
#define NETX_ARM_CLK_RATE_MUL_ADD     0x1C000014U

#define MSK_NETX_ARM_CLK_RATE_MUL_ADD_armclk_rate_mul_add 0x000001ffU // [8:0]
#define SRT_NETX_ARM_CLK_RATE_MUL_ADD_armclk_rate_mul_add 0

enum {
	BFW_NETX_ARM_CLK_RATE_MUL_ADD_armclk_rate_mul_add = 9,  // [8:0]
	BFW_NETX_ARM_CLK_RATE_MUL_ADD_reserved1           = 23  // [31:9]
};

typedef struct ARMCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int armclk_rate_mul_add : BFW_NETX_ARM_CLK_RATE_MUL_ADD_armclk_rate_mul_add; // This value is added each clk400 cycle to armclk_rate_mul to generate armclk.
	                                                        // Change value according to formula: armclk_rate_mul_add = [freq in MHz] / 400 * 2^9
	unsigned int reserved1           : BFW_NETX_ARM_CLK_RATE_MUL_ADD_reserved1;           // reserved
} ARMCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int              val;
	ARMCLK_RATE_MUL_ADD_BIT_T bf;
} ARMCLK_RATE_MUL_ADD_T;

// ---------------------------------------------------------------------
// Register usbclk_rate_mul_add
// =>  Rate Multiplier Add Value
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_USB_CLK_RATE_MUL_ADD 0x00000018U
#define NETX_USB_CLK_RATE_MUL_ADD     0x1C000018U

#define MSK_NETX_USB_CLK_RATE_MUL_ADD_unused              0x0000ffffU // [15:0]
#define SRT_NETX_USB_CLK_RATE_MUL_ADD_unused              0
#define MSK_NETX_USB_CLK_RATE_MUL_ADD_usbclk_rate_mul_add 0xffff0000U // [31:16]
#define SRT_NETX_USB_CLK_RATE_MUL_ADD_usbclk_rate_mul_add 16

enum {
	BFW_NETX_USB_CLK_RATE_MUL_ADD_unused              = 16, // [15:0]
	BFW_NETX_USB_CLK_RATE_MUL_ADD_usbclk_rate_mul_add = 16  // [31:16]
};

typedef struct USBCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int unused              : BFW_NETX_USB_CLK_RATE_MUL_ADD_unused;              // unused
	unsigned int usbclk_rate_mul_add : BFW_NETX_USB_CLK_RATE_MUL_ADD_usbclk_rate_mul_add; // This value is added each clk400 cycle to usbclk_rate_mul to generate usbclk.
	                                                        // Change value according to formula: usbclk_rate_mul_add = [freq in MHz] / 400 * 2^16
} USBCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int              val;
	USBCLK_RATE_MUL_ADD_BIT_T bf;
} USBCLK_RATE_MUL_ADD_T;

// ---------------------------------------------------------------------
// Register fb0clk_rate_mul_add
// =>  Rate Multiplier Add Value
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     ------------------------------------
//     netX100/netX500 usage of this address: adcclk_rate_mul_add
//     ------------------------------------
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_FB0_CLK_RATE_MUL_ADD 0x0000001CU
#define NETX_FB0_CLK_RATE_MUL_ADD     0x1C00001CU

#define MSK_NETX_FB0_CLK_RATE_MUL_ADD_fb0clk_rate_mul_add 0xffffffffU // [31:0]
#define SRT_NETX_FB0_CLK_RATE_MUL_ADD_fb0clk_rate_mul_add 0

enum {
	BFW_NETX_FB0_CLK_RATE_MUL_ADD_fb0clk_rate_mul_add = 32  // [31:0]
};

typedef struct FB0CLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int fb0clk_rate_mul_add : BFW_NETX_FB0_CLK_RATE_MUL_ADD_fb0clk_rate_mul_add; // This value is added each clk400 cycle to fb0clk_rate_mul to generate fb0clk.
	                                                        // Change value according to formula: fb0clk_rate_mul_add = [freq in MHz] / 400 * 2^32
} FB0CLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int              val;
	FB0CLK_RATE_MUL_ADD_BIT_T bf;
} FB0CLK_RATE_MUL_ADD_T;

// ---------------------------------------------------------------------
// Register fb1clk_rate_mul_add
// =>  Rate Multiplier Add Value
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     ------------------------------------
//     netX100/netX500 usage of this address: phyclk_rate_mul_add
//     ------------------------------------
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_FB1_CLK_RATE_MUL_ADD 0x00000020U
#define NETX_FB1_CLK_RATE_MUL_ADD     0x1C000020U

#define MSK_NETX_FB1_CLK_RATE_MUL_ADD_fb1clk_rate_mul_add 0xffffffffU // [31:0]
#define SRT_NETX_FB1_CLK_RATE_MUL_ADD_fb1clk_rate_mul_add 0

enum {
	BFW_NETX_FB1_CLK_RATE_MUL_ADD_fb1clk_rate_mul_add = 32  // [31:0]
};

typedef struct FB1CLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int fb1clk_rate_mul_add : BFW_NETX_FB1_CLK_RATE_MUL_ADD_fb1clk_rate_mul_add; // This value is added each clk400 cycle to fb1clk_rate_mul to generate fb1clk.
	                                                        // Change value according to formula: fb1clk_rate_mul_add = [freq in MHz] / 400 * 2^32
} FB1CLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int              val;
	FB1CLK_RATE_MUL_ADD_BIT_T bf;
} FB1CLK_RATE_MUL_ADD_T;

// ---------------------------------------------------------------------
// Register clock_enable
// =>  Global Clock Enable register
//     Allows to disable modules completely for power saving purpose.
//     Changes will only have effect if according bit in clock_enable_mask-register is set.
//     Bits will be reset according to the clock_enable_mask-register register if a new mask is correctly written (netX locking algorithm).
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CLK_EN 0x00000024U
#define NETX_CLK_EN     0x1C000024U

#define MSK_NETX_CLK_EN_xpec0 0x00000001U // [0]
#define SRT_NETX_CLK_EN_xpec0 0
#define MSK_NETX_CLK_EN_xpec1 0x00000002U // [1]
#define SRT_NETX_CLK_EN_xpec1 1
#define MSK_NETX_CLK_EN_xmac0 0x00000010U // [4]
#define SRT_NETX_CLK_EN_xmac0 4
#define MSK_NETX_CLK_EN_xmac1 0x00000020U // [5]
#define SRT_NETX_CLK_EN_xmac1 5
#define MSK_NETX_CLK_EN_hif   0x00000100U // [8]
#define SRT_NETX_CLK_EN_hif   8
#define MSK_NETX_CLK_EN_fb0   0x00000400U // [10]
#define SRT_NETX_CLK_EN_fb0   10
#define MSK_NETX_CLK_EN_fb1   0x00000800U // [11]
#define SRT_NETX_CLK_EN_fb1   11

enum {
	BFW_NETX_CLK_EN_xpec0     = 1,  // [0]
	BFW_NETX_CLK_EN_xpec1     = 1,  // [1]
	BFW_NETX_CLK_EN_reserved1 = 2,  // [3:2]
	BFW_NETX_CLK_EN_xmac0     = 1,  // [4]
	BFW_NETX_CLK_EN_xmac1     = 1,  // [5]
	BFW_NETX_CLK_EN_reserved2 = 2,  // [7:6]
	BFW_NETX_CLK_EN_hif       = 1,  // [8]
	BFW_NETX_CLK_EN_reserved3 = 1,  // [9]
	BFW_NETX_CLK_EN_fb0       = 1,  // [10]
	BFW_NETX_CLK_EN_fb1       = 1,  // [11]
	BFW_NETX_CLK_EN_reserved4 = 20  // [31:12]
};

typedef struct CLOCK_ENABLE_BIT_Ttag {
	unsigned int xpec0     : BFW_NETX_CLK_EN_xpec0;     // enables clock for xPEC0
	unsigned int xpec1     : BFW_NETX_CLK_EN_xpec1;     // enables clock for xPEC1
	unsigned int reserved1 : BFW_NETX_CLK_EN_reserved1; // reserved
	unsigned int xmac0     : BFW_NETX_CLK_EN_xmac0;     // enables clock for xMAC0
	unsigned int xmac1     : BFW_NETX_CLK_EN_xmac1;     // enables clock for xMAC1
	unsigned int reserved2 : BFW_NETX_CLK_EN_reserved2; // reserved
	unsigned int hif       : BFW_NETX_CLK_EN_hif;       // enables clock for HIF
	unsigned int reserved3 : BFW_NETX_CLK_EN_reserved3; // reserved
	unsigned int fb0       : BFW_NETX_CLK_EN_fb0;       // enables clock for fieldbus0
	unsigned int fb1       : BFW_NETX_CLK_EN_fb1;       // enables clock for fieldbus1
	unsigned int reserved4 : BFW_NETX_CLK_EN_reserved4; // reserved
} CLOCK_ENABLE_BIT_T;

typedef union {
	unsigned int       val;
	CLOCK_ENABLE_BIT_T bf;
} CLOCK_ENABLE_T;

// ---------------------------------------------------------------------
// Register clock_enable_mask
// =>  Global Clock Enable register
//     allows to disable modules for different netX-versions
//     This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres.
//     The clock_enable-register will change according to this register if a new mask is correctly written (netX locking algorithm).
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CLK_EN_MSK 0x00000028U
#define NETX_CLK_EN_MSK     0x1C000028U

#define MSK_NETX_CLK_EN_MSK_NETX_XP0_BASE 0x00000001U // [0]
#define SRT_NETX_CLK_EN_MSK_NETX_XP0_BASE 0
#define MSK_NETX_CLK_EN_MSK_NETX_XP1_BASE 0x00000002U // [1]
#define SRT_NETX_CLK_EN_MSK_NETX_XP1_BASE 1
#define MSK_NETX_CLK_EN_MSK_NETX_XM0_BASE 0x00000010U // [4]
#define SRT_NETX_CLK_EN_MSK_NETX_XM0_BASE 4
#define MSK_NETX_CLK_EN_MSK_NETX_XM1_BASE 0x00000020U // [5]
#define SRT_NETX_CLK_EN_MSK_NETX_XM1_BASE 5
#define MSK_NETX_CLK_EN_MSK_NETX_HIF_AREA   0x00000100U // [8]
#define SRT_NETX_CLK_EN_MSK_NETX_HIF_AREA   8
#define MSK_NETX_CLK_EN_MSK_fb0   0x00000400U // [10]
#define SRT_NETX_CLK_EN_MSK_fb0   10
#define MSK_NETX_CLK_EN_MSK_fb1   0x00000800U // [11]
#define SRT_NETX_CLK_EN_MSK_fb1   11

enum {
	BFW_NETX_CLK_EN_MSK_NETX_XP0_BASE     = 1,  // [0]
	BFW_NETX_CLK_EN_MSK_NETX_XP1_BASE     = 1,  // [1]
	BFW_NETX_CLK_EN_MSK_reserved1 = 2,  // [3:2]
	BFW_NETX_CLK_EN_MSK_NETX_XM0_BASE     = 1,  // [4]
	BFW_NETX_CLK_EN_MSK_NETX_XM1_BASE     = 1,  // [5]
	BFW_NETX_CLK_EN_MSK_reserved2 = 2,  // [7:6]
	BFW_NETX_CLK_EN_MSK_NETX_HIF_AREA       = 1,  // [8]
	BFW_NETX_CLK_EN_MSK_reserved3 = 1,  // [9]
	BFW_NETX_CLK_EN_MSK_fb0       = 1,  // [10]
	BFW_NETX_CLK_EN_MSK_fb1       = 1,  // [11]
	BFW_NETX_CLK_EN_MSK_reserved4 = 20  // [31:12]
};

typedef struct CLOCK_ENABLE_MASK_BIT_Ttag {
	unsigned int xpec0     : BFW_NETX_CLK_EN_MSK_NETX_XP0_BASE;     // 0: xPEC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC0
	unsigned int xpec1     : BFW_NETX_CLK_EN_MSK_NETX_XP1_BASE;     // 0: xPEC1 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC1
	unsigned int reserved1 : BFW_NETX_CLK_EN_MSK_reserved1; // reserved
	unsigned int xmac0     : BFW_NETX_CLK_EN_MSK_NETX_XM0_BASE;     // 0: xMAC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC0
	unsigned int xmac1     : BFW_NETX_CLK_EN_MSK_NETX_XM1_BASE;     // 0: xMAC1 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC1
	unsigned int reserved2 : BFW_NETX_CLK_EN_MSK_reserved2; // reserved
	unsigned int hif       : BFW_NETX_CLK_EN_MSK_NETX_HIF_AREA;       // 0: HIF is disabled  1: clock can be enabled/disabled by clock_enable-register for HIF
	unsigned int reserved3 : BFW_NETX_CLK_EN_MSK_reserved3; // reserved
	unsigned int fb0       : BFW_NETX_CLK_EN_MSK_fb0;       // 0: fieldbus0 clock is disabled  1: clock can be enabled/disabled by clock_enable-register for fieldbus0
	unsigned int fb1       : BFW_NETX_CLK_EN_MSK_fb1;       // 0: fieldbus1 clock is disabled  1: clock can be enabled/disabled by clock_enable-register for fieldbus1
	unsigned int reserved4 : BFW_NETX_CLK_EN_MSK_reserved4; // reserved
} CLOCK_ENABLE_MASK_BIT_T;

typedef union {
	unsigned int            val;
	CLOCK_ENABLE_MASK_BIT_T bf;
} CLOCK_ENABLE_MASK_T;

// ---------------------------------------------------------------------
// Register misc_asic_ctrl
// =>  miscellaneous ASIC controll register
//     This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres.
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MISC_CTRL 0x0000002CU
#define NETX_MISC_CTRL     0x1C00002CU

#define MSK_NETX_MISC_CTRL_arm_dbgen 0x00000001U // [0]
#define SRT_NETX_MISC_CTRL_arm_dbgen 0

enum {
	BFW_NETX_MISC_CTRL_arm_dbgen = 1,  // [0]
	BFW_NETX_MISC_CTRL_reserved1 = 31  // [31:1]
};

typedef struct MISC_ASIC_CTRL_BIT_Ttag {
	unsigned int arm_dbgen : BFW_NETX_MISC_CTRL_arm_dbgen; // 1: ARM debug features are enabled
	                                                        // 0: ARM debug features are disabled
	unsigned int reserved1 : BFW_NETX_MISC_CTRL_reserved1; // reserved
} MISC_ASIC_CTRL_BIT_T;

typedef union {
	unsigned int         val;
	MISC_ASIC_CTRL_BIT_T bf;
} MISC_ASIC_CTRL_T;

// ---------------------------------------------------------------------
// Register exmem_priority_lock
// =>  Global exmemory priority controlling mask register
//     Set bits to lock the registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl
//     in address area extmem_priority_ctrl.
//     allows to disable modules completely for power saving reasons
//     This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres.
//     Changing this register is only possible by the following sequence:
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_LOCK_MEM_PRIO_CTRL 0x00000030U
#define NETX_LOCK_MEM_PRIO_CTRL     0x1C000030U

#define MSK_NETX_LOCK_MEM_PRIO_CTRL_lock_HIF_priority 0x00000001U // [0]
#define SRT_NETX_LOCK_MEM_PRIO_CTRL_lock_HIF_priority 0
#define MSK_NETX_LOCK_MEM_PRIO_CTRL_lock_XC_priority  0x00000002U // [1]
#define SRT_NETX_LOCK_MEM_PRIO_CTRL_lock_XC_priority  1
#define MSK_NETX_LOCK_MEM_PRIO_CTRL_lock_DMA_priority 0x00000020U // [5]
#define SRT_NETX_LOCK_MEM_PRIO_CTRL_lock_DMA_priority 5
#define MSK_NETX_LOCK_MEM_PRIO_CTRL_lock_ARM_priority 0x00000040U // [6]
#define SRT_NETX_LOCK_MEM_PRIO_CTRL_lock_ARM_priority 6

enum {
	BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_HIF_priority = 1,  // [0]
	BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_XC_priority  = 1,  // [1]
	BFW_NETX_LOCK_MEM_PRIO_CTRL_reserved1         = 3,  // [4:2]
	BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_DMA_priority = 1,  // [5]
	BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_ARM_priority = 1,  // [6]
	BFW_NETX_LOCK_MEM_PRIO_CTRL_reserved2         = 25  // [31:7]
};

typedef struct EXMEM_PRIORITY_LOCK_BIT_Ttag {
	unsigned int lock_HIF_priority : BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_HIF_priority; // 1 HIF settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked
	unsigned int lock_XC_priority  : BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_XC_priority;  // 1 XC settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked
	unsigned int reserved1         : BFW_NETX_LOCK_MEM_PRIO_CTRL_reserved1;         // reserved
	unsigned int lock_DMA_priority : BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_DMA_priority; // 1 LCD settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked
	unsigned int lock_ARM_priority : BFW_NETX_LOCK_MEM_PRIO_CTRL_lock_ARM_priority; // 1 ARM settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked
	unsigned int reserved2         : BFW_NETX_LOCK_MEM_PRIO_CTRL_reserved2;         // reserved
} EXMEM_PRIORITY_LOCK_BIT_T;

typedef union {
	unsigned int              val;
	EXMEM_PRIORITY_LOCK_BIT_T bf;
} EXMEM_PRIORITY_LOCK_T;

// ---------------------------------------------------------------------
// Register netx_version
// =>  netX Version register
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_NETX_REV 0x00000034U
#define NETX_NETX_REV     0x1C000034U

#define MSK_NETX_NETX_REV_netx_version 0xffffffffU // [31:0]
#define SRT_NETX_NETX_REV_netx_version 0

enum {
	BFW_NETX_NETX_REV_netx_version = 32  // [31:0]
};

typedef struct NETX_VERSION_BIT_Ttag {
	unsigned int netx_version : BFW_NETX_NETX_REV_netx_version; // netX Version number
} NETX_VERSION_BIT_T;

typedef union {
	unsigned int       val;
	NETX_VERSION_BIT_T bf;
} NETX_VERSION_T;

// ---------------------------------------------------------------------
// Register rom_wdg
// =>  netX Version register
//     write to this register to reset rom-hide-watchdog, no access-key-protection
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_ROM_WDG 0x00000038U
#define NETX_ROM_WDG     0x1C000038U

#define MSK_NETX_ROM_WDG_rst_wdg 0xffffffffU // [31:0]
#define SRT_NETX_ROM_WDG_rst_wdg 0

enum {
	BFW_NETX_ROM_WDG_rst_wdg = 32  // [31:0]
};

typedef struct ROM_WDG_BIT_Ttag {
	unsigned int rst_wdg : BFW_NETX_ROM_WDG_rst_wdg; // write here to reset rom-watchdog to 0x1ff
	                                                        // The watchdog will dectrement with each positiv clk (100MHz) edge.
	                                                        // If watchdog reachead onc 0x0, highest 4kB ROM will be hidden. 4kB-block below will be seen by any master.
	                                                        // The watchdog will be only reset at power-on-reset.
} ROM_WDG_BIT_T;

typedef union {
	unsigned int  val;
	ROM_WDG_BIT_T bf;
} ROM_WDG_T;

// ---------------------------------------------------------------------
// Register asic_ctrl_access_key
// =>  ASIC Controll Access Key Register
//     Writing to any register in the asic_ctrl - address area is only possible after
//     setting the correct key here to avoid unmeant changes eg. by crashed software.
//     ----
//     Changing a controll register in the asic_ctrl - address area is only possible by the following sequence:
//     1.: Read out the access key from this register.
//     2.: Write back this access key to this register.
//     3.: Write desired value to the controll register.
//     ----
//     The access key will become unvalid after each access to any register in the asic_ctrl - address area
//     and has to be read out and set again for sequent accesses.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_IO_CFG_ACCESS_KEY 0x00000070U
#define NETX_IO_CFG_ACCESS_KEY     0x1C000070U

#define MSK_NETX_IO_CFG_ACCESS_KEY_access_key 0x0000ffffU // [15:0]
#define SRT_NETX_IO_CFG_ACCESS_KEY_access_key 0

enum {
	BFW_NETX_IO_CFG_ACCESS_KEY_access_key = 16, // [15:0]
	BFW_NETX_IO_CFG_ACCESS_KEY_reserved1  = 16  // [31:16]
};

typedef struct ASIC_CTRL_ACCESS_KEY_BIT_Ttag {
	unsigned int access_key : BFW_NETX_IO_CFG_ACCESS_KEY_access_key; // access key for next write access.
	unsigned int reserved1  : BFW_NETX_IO_CFG_ACCESS_KEY_reserved1;  // reserved
} ASIC_CTRL_ACCESS_KEY_BIT_T;

typedef union {
	unsigned int               val;
	ASIC_CTRL_ACCESS_KEY_BIT_T bf;
} ASIC_CTRL_ACCESS_KEY_T;

// ---------------------------------------------------------------------
// Register netx_lock_reserved00
// =>  reserved address for netX locking purpose
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_LOCK_RESERVED_00 0x00000074U
#define NETX_LOCK_RESERVED_00     0x1C000074U

#define MSK_NETX_LOCK_RESERVED_00_lock 0xffffffffU // [31:0]
#define SRT_NETX_LOCK_RESERVED_00_lock 0

enum {
	BFW_NETX_LOCK_RESERVED_00_lock = 32  // [31:0]
};

typedef struct NETX_LOCK_RESERVED00_BIT_Ttag {
	unsigned int lock : BFW_NETX_LOCK_RESERVED_00_lock; // locking purpose
} NETX_LOCK_RESERVED00_BIT_T;

typedef union {
	unsigned int               val;
	NETX_LOCK_RESERVED00_BIT_T bf;
} NETX_LOCK_RESERVED00_T;

// ---------------------------------------------------------------------
// Register netx_lock_reserved01
// =>  reserved address for netX locking purpose
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_LOCK_RESERVED_01 0x00000078U
#define NETX_LOCK_RESERVED_01     0x1C000078U

#define MSK_NETX_LOCK_RESERVED_01_lock 0xffffffffU // [31:0]
#define SRT_NETX_LOCK_RESERVED_01_lock 0

enum {
	BFW_NETX_LOCK_RESERVED_01_lock = 32  // [31:0]
};

typedef struct NETX_LOCK_RESERVED01_BIT_Ttag {
	unsigned int lock : BFW_NETX_LOCK_RESERVED_01_lock; // locking purpose
} NETX_LOCK_RESERVED01_BIT_T;

typedef union {
	unsigned int               val;
	NETX_LOCK_RESERVED01_BIT_T bf;
} NETX_LOCK_RESERVED01_T;

// ---------------------------------------------------------------------
// Register netx_lock_reserved_start
// =>  reserved start address for netX locking purpose address area - don't implement other registers at 0x80 .. 0xfc!
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_LOCK_RESERVED_BASE 0x00000080U
#define NETX_LOCK_RESERVED_BASE     0x1C000080U

#define MSK_NETX_LOCK_RESERVED_BASE_lock 0xffffffffU // [31:0]
#define SRT_NETX_LOCK_RESERVED_BASE_lock 0

enum {
	BFW_NETX_LOCK_RESERVED_BASE_lock = 32  // [31:0]
};

typedef struct NETX_LOCK_RESERVED_START_BIT_Ttag {
	unsigned int lock : BFW_NETX_LOCK_RESERVED_BASE_lock; // locking purpose
} NETX_LOCK_RESERVED_START_BIT_T;

typedef union {
	unsigned int                   val;
	NETX_LOCK_RESERVED_START_BIT_T bf;
} NETX_LOCK_RESERVED_START_T;

// ---------------------------------------------------------------------
// Register netx_lock_reserved_end
// =>  reserved end address for netX locking purpose address area - don't implement other registers at 0x80 .. 0xfc!
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_LOCK_RESERVED_END 0x000000FCU
#define NETX_LOCK_RESERVED_END     0x1C0000FCU

#define MSK_NETX_LOCK_RESERVED_END_lock 0xffffffffU // [31:0]
#define SRT_NETX_LOCK_RESERVED_END_lock 0

enum {
	BFW_NETX_LOCK_RESERVED_END_lock = 32  // [31:0]
};

typedef struct NETX_LOCK_RESERVED_END_BIT_Ttag {
	unsigned int lock : BFW_NETX_LOCK_RESERVED_END_lock; // locking purpose
} NETX_LOCK_RESERVED_END_BIT_T;

typedef union {
	unsigned int                 val;
	NETX_LOCK_RESERVED_END_BIT_T bf;
} NETX_LOCK_RESERVED_END_T;


// =====================================================================
//
// Area of extmemctrl
//
// =====================================================================

#define NETX_MEM_SRAM_CTRL_AREA	0x1C000100U

// =====================================================================
//
// Area of ext_asyncmem_ctrl
//
// =====================================================================

#define NETX_MEM_SRAM_CTRL_AREA	0x1C000100U

// ---------------------------------------------------------------------
// Register extsram0_ctrl
// =>  Control Register for external bus interface and Waitstates for ExtMem0 chip select area
//     memory width coding like ARM-signals MAS / HSIZE[1:0]:
//         00=8bit
//         01=16bit
//         10=32bit
//         11=reserved
//     external addresses will be alligned (right shifted) according to the selected memory width
//         8 bit  -> no right shift of Aext
//         16 bit -> right shift Aext 1 bit
//         32 bit -> right shift Aext 2 bits
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SRAM0_CTRL 0x00000000U
#define NETX_MEM_SRAM0_CTRL     0x1C000100U

#define MSK_NETX_MEM_SRAM0_CTRL_WSExtMem0          0x0000003fU // [5:0]
#define SRT_NETX_MEM_SRAM0_CTRL_WSExtMem0          0
#define MSK_NETX_MEM_SRAM0_CTRL_WSPrePauseExtMem0  0x00000300U // [9:8]
#define SRT_NETX_MEM_SRAM0_CTRL_WSPrePauseExtMem0  8
#define MSK_NETX_MEM_SRAM0_CTRL_WSPostPauseExtMem0 0x00030000U // [17:16]
#define SRT_NETX_MEM_SRAM0_CTRL_WSPostPauseExtMem0 16
#define MSK_NETX_MEM_SRAM0_CTRL_WidthExtMem0       0x03000000U // [25:24]
#define SRT_NETX_MEM_SRAM0_CTRL_WidthExtMem0       24

enum {
	BFW_NETX_MEM_SRAM0_CTRL_WSExtMem0          = 6, // [5:0]
	BFW_NETX_MEM_SRAM0_CTRL_reserved1          = 2, // [7:6]
	BFW_NETX_MEM_SRAM0_CTRL_WSPrePauseExtMem0  = 2, // [9:8]
	BFW_NETX_MEM_SRAM0_CTRL_reserved2          = 6, // [15:10]
	BFW_NETX_MEM_SRAM0_CTRL_WSPostPauseExtMem0 = 2, // [17:16]
	BFW_NETX_MEM_SRAM0_CTRL_reserved3          = 6, // [23:18]
	BFW_NETX_MEM_SRAM0_CTRL_WidthExtMem0       = 2, // [25:24]
	BFW_NETX_MEM_SRAM0_CTRL_reserved4          = 6  // [31:26]
};

typedef struct EXTSRAM0_CTRL_BIT_Ttag {
	unsigned int WSExtMem0          : BFW_NETX_MEM_SRAM0_CTRL_WSExtMem0;          // Waitstates 0 - 63 cycles
	unsigned int reserved1          : BFW_NETX_MEM_SRAM0_CTRL_reserved1;          // reserved
	unsigned int WSPrePauseExtMem0  : BFW_NETX_MEM_SRAM0_CTRL_WSPrePauseExtMem0;  // additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles
	unsigned int reserved2          : BFW_NETX_MEM_SRAM0_CTRL_reserved2;          // reserved
	unsigned int WSPostPauseExtMem0 : BFW_NETX_MEM_SRAM0_CTRL_WSPostPauseExtMem0; // additional Waitstates after access 0 - 3 cycles
	unsigned int reserved3          : BFW_NETX_MEM_SRAM0_CTRL_reserved3;          // reserved
	unsigned int WidthExtMem0       : BFW_NETX_MEM_SRAM0_CTRL_WidthExtMem0;       // Datapath width of ExtMem0 area
	unsigned int reserved4          : BFW_NETX_MEM_SRAM0_CTRL_reserved4;          // reserved
} EXTSRAM0_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	EXTSRAM0_CTRL_BIT_T bf;
} EXTSRAM0_CTRL_T;

// ---------------------------------------------------------------------
// Register extsram1_ctrl
// =>  Control Register for external bus interface and Waitstates for ExtMem1 chip select area
//     memory width coding like ARM-signals MAS / HSIZE[1:0]:
//         00=8bit
//         01=16bit
//         10=32bit
//         11=reserved
//     external addresses will be alligned (right shifted) according to the selected memory width
//         8 bit  -> no right shift of Aext
//         16 bit -> right shift Aext 1 bit
//         32 bit -> right shift Aext 2 bits
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SRAM1_CTRL 0x00000004U
#define NETX_MEM_SRAM1_CTRL     0x1C000104U

#define MSK_NETX_MEM_SRAM1_CTRL_WSExtMem1          0x0000003fU // [5:0]
#define SRT_NETX_MEM_SRAM1_CTRL_WSExtMem1          0
#define MSK_NETX_MEM_SRAM1_CTRL_WSPrePauseExtMem1  0x00000300U // [9:8]
#define SRT_NETX_MEM_SRAM1_CTRL_WSPrePauseExtMem1  8
#define MSK_NETX_MEM_SRAM1_CTRL_WSPostPauseExtMem1 0x00030000U // [17:16]
#define SRT_NETX_MEM_SRAM1_CTRL_WSPostPauseExtMem1 16
#define MSK_NETX_MEM_SRAM1_CTRL_WidthExtMem1       0x03000000U // [25:24]
#define SRT_NETX_MEM_SRAM1_CTRL_WidthExtMem1       24

enum {
	BFW_NETX_MEM_SRAM1_CTRL_WSExtMem1          = 6, // [5:0]
	BFW_NETX_MEM_SRAM1_CTRL_reserved1          = 2, // [7:6]
	BFW_NETX_MEM_SRAM1_CTRL_WSPrePauseExtMem1  = 2, // [9:8]
	BFW_NETX_MEM_SRAM1_CTRL_reserved2          = 6, // [15:10]
	BFW_NETX_MEM_SRAM1_CTRL_WSPostPauseExtMem1 = 2, // [17:16]
	BFW_NETX_MEM_SRAM1_CTRL_reserved3          = 6, // [23:18]
	BFW_NETX_MEM_SRAM1_CTRL_WidthExtMem1       = 2, // [25:24]
	BFW_NETX_MEM_SRAM1_CTRL_reserved4          = 6  // [31:26]
};

typedef struct EXTSRAM1_CTRL_BIT_Ttag {
	unsigned int WSExtMem1          : BFW_NETX_MEM_SRAM1_CTRL_WSExtMem1;          // Waitstates 0 - 63 cycles
	unsigned int reserved1          : BFW_NETX_MEM_SRAM1_CTRL_reserved1;          // reserved
	unsigned int WSPrePauseExtMem1  : BFW_NETX_MEM_SRAM1_CTRL_WSPrePauseExtMem1;  // additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles
	unsigned int reserved2          : BFW_NETX_MEM_SRAM1_CTRL_reserved2;          // reserved
	unsigned int WSPostPauseExtMem1 : BFW_NETX_MEM_SRAM1_CTRL_WSPostPauseExtMem1; // additional Waitstates after access 0 - 3 cycles
	unsigned int reserved3          : BFW_NETX_MEM_SRAM1_CTRL_reserved3;          // reserved
	unsigned int WidthExtMem1       : BFW_NETX_MEM_SRAM1_CTRL_WidthExtMem1;       // Datapath width of ExtMem1 area
	unsigned int reserved4          : BFW_NETX_MEM_SRAM1_CTRL_reserved4;          // reserved
} EXTSRAM1_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	EXTSRAM1_CTRL_BIT_T bf;
} EXTSRAM1_CTRL_T;

// ---------------------------------------------------------------------
// Register extsram2_ctrl
// =>  Control Register for external bus interface and Waitstates for ExtMem2 chip select area
//     memory width coding like ARM-signals MAS / HSIZE[1:0]:
//         00=8bit
//         01=16bit
//         10=32bit
//         11=reserved
//     external addresses will be alligned (right shifted) according to the selected memory width
//         8 bit  -> no right shift of Aext
//         16 bit -> right shift Aext 1 bit
//         32 bit -> right shift Aext 2 bits
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SRAM2_CTRL 0x00000008U
#define NETX_MEM_SRAM2_CTRL     0x1C000108U

#define MSK_NETX_MEM_SRAM2_CTRL_WSExtMem2          0x0000003fU // [5:0]
#define SRT_NETX_MEM_SRAM2_CTRL_WSExtMem2          0
#define MSK_NETX_MEM_SRAM2_CTRL_WSPrePauseExtMem2  0x00000300U // [9:8]
#define SRT_NETX_MEM_SRAM2_CTRL_WSPrePauseExtMem2  8
#define MSK_NETX_MEM_SRAM2_CTRL_WSPostPauseExtMem2 0x00030000U // [17:16]
#define SRT_NETX_MEM_SRAM2_CTRL_WSPostPauseExtMem2 16
#define MSK_NETX_MEM_SRAM2_CTRL_WidthExtMem2       0x03000000U // [25:24]
#define SRT_NETX_MEM_SRAM2_CTRL_WidthExtMem2       24

enum {
	BFW_NETX_MEM_SRAM2_CTRL_WSExtMem2          = 6, // [5:0]
	BFW_NETX_MEM_SRAM2_CTRL_reserved1          = 2, // [7:6]
	BFW_NETX_MEM_SRAM2_CTRL_WSPrePauseExtMem2  = 2, // [9:8]
	BFW_NETX_MEM_SRAM2_CTRL_reserved2          = 6, // [15:10]
	BFW_NETX_MEM_SRAM2_CTRL_WSPostPauseExtMem2 = 2, // [17:16]
	BFW_NETX_MEM_SRAM2_CTRL_reserved3          = 6, // [23:18]
	BFW_NETX_MEM_SRAM2_CTRL_WidthExtMem2       = 2, // [25:24]
	BFW_NETX_MEM_SRAM2_CTRL_reserved4          = 6  // [31:26]
};

typedef struct EXTSRAM2_CTRL_BIT_Ttag {
	unsigned int WSExtMem2          : BFW_NETX_MEM_SRAM2_CTRL_WSExtMem2;          // Waitstates 0 - 63 cycles
	unsigned int reserved1          : BFW_NETX_MEM_SRAM2_CTRL_reserved1;          // reserved
	unsigned int WSPrePauseExtMem2  : BFW_NETX_MEM_SRAM2_CTRL_WSPrePauseExtMem2;  // additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles
	unsigned int reserved2          : BFW_NETX_MEM_SRAM2_CTRL_reserved2;          // reserved
	unsigned int WSPostPauseExtMem2 : BFW_NETX_MEM_SRAM2_CTRL_WSPostPauseExtMem2; // additional Waitstates after access 0 - 3 cycles
	unsigned int reserved3          : BFW_NETX_MEM_SRAM2_CTRL_reserved3;          // reserved
	unsigned int WidthExtMem2       : BFW_NETX_MEM_SRAM2_CTRL_WidthExtMem2;       // Datapath width of ExtMem2 area
	unsigned int reserved4          : BFW_NETX_MEM_SRAM2_CTRL_reserved4;          // reserved
} EXTSRAM2_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	EXTSRAM2_CTRL_BIT_T bf;
} EXTSRAM2_CTRL_T;

// ---------------------------------------------------------------------
// Register extsram3_ctrl
// =>  Control Register for external bus interface and Waitstates for ExtMem3 chip select area
//     memory width coding like ARM-signals MAS / HSIZE[1:0]:
//         00=8bit
//         01=16bit
//         10=32bit
//         11=reserved
//     external addresses will be alligned (right shifted) according to the selected memory width
//         8 bit  -> no right shift of Aext
//         16 bit -> right shift Aext 1 bit
//         32 bit -> right shift Aext 2 bits
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SRAM3_CTRL 0x0000000CU
#define NETX_MEM_SRAM3_CTRL     0x1C00010CU

#define MSK_NETX_MEM_SRAM3_CTRL_WSExtMem3          0x0000003fU // [5:0]
#define SRT_NETX_MEM_SRAM3_CTRL_WSExtMem3          0
#define MSK_NETX_MEM_SRAM3_CTRL_WSPrePauseExtMem3  0x00000300U // [9:8]
#define SRT_NETX_MEM_SRAM3_CTRL_WSPrePauseExtMem3  8
#define MSK_NETX_MEM_SRAM3_CTRL_WSPostPauseExtMem3 0x00030000U // [17:16]
#define SRT_NETX_MEM_SRAM3_CTRL_WSPostPauseExtMem3 16
#define MSK_NETX_MEM_SRAM3_CTRL_WidthExtMem3       0x03000000U // [25:24]
#define SRT_NETX_MEM_SRAM3_CTRL_WidthExtMem3       24

enum {
	BFW_NETX_MEM_SRAM3_CTRL_WSExtMem3          = 6, // [5:0]
	BFW_NETX_MEM_SRAM3_CTRL_reserved1          = 2, // [7:6]
	BFW_NETX_MEM_SRAM3_CTRL_WSPrePauseExtMem3  = 2, // [9:8]
	BFW_NETX_MEM_SRAM3_CTRL_reserved2          = 6, // [15:10]
	BFW_NETX_MEM_SRAM3_CTRL_WSPostPauseExtMem3 = 2, // [17:16]
	BFW_NETX_MEM_SRAM3_CTRL_reserved3          = 6, // [23:18]
	BFW_NETX_MEM_SRAM3_CTRL_WidthExtMem3       = 2, // [25:24]
	BFW_NETX_MEM_SRAM3_CTRL_reserved4          = 6  // [31:26]
};

typedef struct EXTSRAM3_CTRL_BIT_Ttag {
	unsigned int WSExtMem3          : BFW_NETX_MEM_SRAM3_CTRL_WSExtMem3;          // Waitstates 0 - 63 cycles
	unsigned int reserved1          : BFW_NETX_MEM_SRAM3_CTRL_reserved1;          // reserved
	unsigned int WSPrePauseExtMem3  : BFW_NETX_MEM_SRAM3_CTRL_WSPrePauseExtMem3;  // additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles
	unsigned int reserved2          : BFW_NETX_MEM_SRAM3_CTRL_reserved2;          // reserved
	unsigned int WSPostPauseExtMem3 : BFW_NETX_MEM_SRAM3_CTRL_WSPostPauseExtMem3; // additional Waitstates after access 0 - 3 cycles
	unsigned int reserved3          : BFW_NETX_MEM_SRAM3_CTRL_reserved3;          // reserved
	unsigned int WidthExtMem3       : BFW_NETX_MEM_SRAM3_CTRL_WidthExtMem3;       // Datapath width of ExtMem3 area
	unsigned int reserved4          : BFW_NETX_MEM_SRAM3_CTRL_reserved4;          // reserved
} EXTSRAM3_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	EXTSRAM3_CTRL_BIT_T bf;
} EXTSRAM3_CTRL_T;


// =====================================================================
//
// Area of ext_sdram_ctrl
//
// =====================================================================

#define NETX_MEM_SDRAM_CTRL_AREA	0x1C000140U

// ---------------------------------------------------------------------
// Register sdram_general_ctrl
// =>  Control Register for external SDRAM access.
//     ----------------------------------------------------------
//     No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options
//     ----------------------------------------------------------
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SDRAM_CFG_CTRL 0x00000000U
#define NETX_MEM_SDRAM_CFG_CTRL     0x1C000140U

#define MSK_NETX_MEM_SDRAM_CFG_CTRL_banks         0x00000003U // [1:0]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_banks         0
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_rows          0x00000070U // [6:4]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_rows          4
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_columns       0x00000700U // [10:8]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_columns       8
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_dbus32        0x00010000U // [16]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_dbus32        16
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_sdram_pwdn    0x00020000U // [17]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_sdram_pwdn    17
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_extclk_en     0x00040000U // [18]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_extclk_en     18
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_ctrl_en       0x00080000U // [19]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_ctrl_en       19
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_refresh_mode  0x03000000U // [25:24]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_refresh_mode  24
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_sdram_ready   0x40000000U // [30]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_sdram_ready   30
#define MSK_NETX_MEM_SDRAM_CFG_CTRL_refresh_error 0x80000000U // [31]
#define SRT_NETX_MEM_SDRAM_CFG_CTRL_refresh_error 31

enum {
	BFW_NETX_MEM_SDRAM_CFG_CTRL_banks         = 2, // [1:0]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved1     = 2, // [3:2]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_rows          = 3, // [6:4]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved2     = 1, // [7]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_columns       = 3, // [10:8]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved3     = 5, // [15:11]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_dbus32        = 1, // [16]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_sdram_pwdn    = 1, // [17]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_extclk_en     = 1, // [18]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_ctrl_en       = 1, // [19]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved4     = 4, // [23:20]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_refresh_mode  = 2, // [25:24]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved5     = 4, // [29:26]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_sdram_ready   = 1, // [30]
	BFW_NETX_MEM_SDRAM_CFG_CTRL_refresh_error = 1  // [31]
};

typedef struct SDRAM_GENERAL_CTRL_BIT_Ttag {
	unsigned int banks         : BFW_NETX_MEM_SDRAM_CFG_CTRL_banks;         // bank address coding.
	                                                        // 00 : 2
	                                                        // 01 : 4 (default)
	                                                        // 10 : 8
	                                                        // 11 : reserved
	                                                        // bank addresses are always mapped on A18 (=BA2), A17 (=BA1) and A16(BA0).
	unsigned int reserved1     : BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved1;     // reserved
	unsigned int rows          : BFW_NETX_MEM_SDRAM_CFG_CTRL_rows;          // row address coding.
	                                                        // 000 : 2k  (A0..A10) (default)
	                                                        // 001 : 4k  (A0..A11)
	                                                        // 010 : 8k  (A0..A12)
	                                                        // 011 : 16k (A0..A13)
	                                                        // 100 : 32k (A0..A14) (no devices today)
	                                                        // 101 : 64k (A0..A15) (no devices today)
	                                                        // 110 : reserved
	                                                        // 111 : reserved
	unsigned int reserved2     : BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved2;     // reserved
	unsigned int columns       : BFW_NETX_MEM_SDRAM_CFG_CTRL_columns;       // column address coding.
	                                                        // 000 : 256 (A0..A7) (default)
	                                                        // 001 : 512 (A0..A8)
	                                                        // 010 : 1k  (A0..A9)
	                                                        // 011 : 2k  (A0..A9,A11)
	                                                        // 100 : 4k  (A0..A9,A11,A12)
	                                                        // 101 : 8k  (A0..A9,A11..A13) (no devices today)
	                                                        // 110 : 16k (A0..A9,A11..A14) (no devices today)
	                                                        // 111 : reserved
	unsigned int reserved3     : BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved3;     // reserved
	unsigned int dbus32        : BFW_NETX_MEM_SDRAM_CFG_CTRL_dbus32;        // SDRAM data bus width
	                                                        // 0: SDRAM Data bus is 16 bit wide.  (default)
	                                                        // 1: SDRAM data bus is 32 bit wide.
	unsigned int sdram_pwdn    : BFW_NETX_MEM_SDRAM_CFG_CTRL_sdram_pwdn;    // SDRAM Power Down
	                                                        // If this bit is set, the Controller will move SDRAM to power down self refresh mode (no data loss)
	                                                        // and stop the external SDRAM clock. After resetting this bit, for DDR and DDR2 device types
	                                                        // a 200 clk DLLs startup pause will be done.
	unsigned int extclk_en     : BFW_NETX_MEM_SDRAM_CFG_CTRL_extclk_en;     // external SDRAM clock enable
	unsigned int ctrl_en       : BFW_NETX_MEM_SDRAM_CFG_CTRL_ctrl_en;       // SDRAM controller enable
	                                                        // The sdram_timing_ctrl-register can only be changed while this bit is 0.
	                                                        // ------------------------------------
	                                                        // After enable, the controller will run the following SDRAM initialisation procedure (100MHz, t_clk = 10ns).
	                                                        //    NOP (200us = 20,000t_clk, running sd_clk (if extclk_en), n_cs low, cke high)
	                                                        //    PRECHARGE ALL
	                                                        //    NOP (160ns = 16t_clk)
	                                                        //    7x (AUTO REFRESH, NOP (310ns = 31t_clk))
	                                                        //    AUTO REFRESH
	                                                        //    NOP (220ns = 22t_clk)
	                                                        //    LOAD MODE REGISTER (with settings done by these config registers)
	                                                        //    NOP (40ns = 4t_clk)
	                                                        //    ACTIVATE (for first access, if requested, sdram_ready will be set to 1 here)
	                                                        // ------------------------------------
	                                                        // Accesses requested before sdram_ready is 1 will be blocked (no ready).
	                                                        // The external SDRAM-clk will not run if the controller is disabled.
	unsigned int reserved4     : BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved4;     // reserved
	unsigned int refresh_mode  : BFW_NETX_MEM_SDRAM_CFG_CTRL_refresh_mode;  // Refresh priortity mode
	                                                        // If refresh has not highest priority and , it was not possible to generate the Refresh command in cause
	                                                        // of to much data accesses, refresh will become highest priority for no data loss.
	                                                        // In this case, the bit sdram_ctrl_general,refresh_error will be set to 1.
	                                                        // if it was not possible to generate the Refresh command in cause of to much data accesses.
	                                                        // 00 : fix intervall any t_REFI us (refresh has highest priority)
	                                                        // 01 : collect up to 8 refreshes (for DDR, DDR2, data access has higher priority than refresh, default)
	                                                        // 10 : collect up to 16 refreshes (data access has higher priority than refresh)
	                                                        // 11 : collect up to 2047 refreshes (for SDR only, data access has higher priority than refresh)
	unsigned int reserved5     : BFW_NETX_MEM_SDRAM_CFG_CTRL_reserved5;     // reserved
	unsigned int sdram_ready   : BFW_NETX_MEM_SDRAM_CFG_CTRL_sdram_ready;   // SDRAM Ready.
	                                                        // This bit is set to 1 if SDRAM is ready for access. If sdram_general_ctrl.ctrl_en == 0 or
	                                                        // sdram_general_ctrl.sdram_pwdn == 0, sdram_ready will be low. It will be set to 1 after
	                                                        // SDRAM has been initialized or after power down wake up.
	unsigned int refresh_error : BFW_NETX_MEM_SDRAM_CFG_CTRL_refresh_error; // Refresh not achieved for debug purpose
	                                                        // If refresh has not highest priority, (sdram_ctrl_timing.refresh_mode), this bit will be set to 1
	                                                        // when it was not possible to generate the Refresh command in cause of to much data accesses.
	                                                        // The SDRAM-Controller will only set this bit. It can be resetted by writing '0' to it.
} SDRAM_GENERAL_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	SDRAM_GENERAL_CTRL_BIT_T bf;
} SDRAM_GENERAL_CTRL_T;

// ---------------------------------------------------------------------
// Register sdram_timing_ctrl
// =>  Control Register for external SDRAM access.
//     Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0)
//     to avoid configuration problems.
//     ----------------------------------------------------------
//     No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options
//     ----------------------------------------------------------
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SDRAM_TIMING_CTRL 0x00000004U
#define NETX_MEM_SDRAM_TIMING_CTRL     0x1C000144U

#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_t_RCD             0x00000003U // [1:0]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_t_RCD             0
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_t_WR              0x00000030U // [5:4]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_t_WR              4
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_t_RP              0x000000c0U // [7:6]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_t_RP              6
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_t_RAS             0x00000700U // [10:8]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_t_RAS             8
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_t_RFC             0x0000f000U // [15:12]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_t_RFC             12
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_t_REFI            0x00030000U // [17:16]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_t_REFI            16
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_phase   0x00700000U // [22:20]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_phase   20
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_ssneg   0x00800000U // [23]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_ssneg   23
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_data_sample_phase 0x07000000U // [26:24]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_data_sample_phase 24
#define MSK_NETX_MEM_SDRAM_TIMING_CTRL_bypass_neg_delay  0x10000000U // [28]
#define SRT_NETX_MEM_SDRAM_TIMING_CTRL_bypass_neg_delay  28

enum {
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RCD             = 2, // [1:0]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved1         = 2, // [3:2]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_WR              = 2, // [5:4]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RP              = 2, // [7:6]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RAS             = 3, // [10:8]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved2         = 1, // [11]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RFC             = 4, // [15:12]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_REFI            = 2, // [17:16]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved3         = 2, // [19:18]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_phase   = 3, // [22:20]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_ssneg   = 1, // [23]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_data_sample_phase = 3, // [26:24]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved4         = 1, // [27]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_bypass_neg_delay  = 1, // [28]
	BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved5         = 3  // [31:29]
};

typedef struct SDRAM_TIMING_CTRL_BIT_Ttag {
	unsigned int t_RCD             : BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RCD;             // Active to Read or Write time (RAS to CAS, clk = t_RCD)
	                                                        // This value will be also taken as t_RRD (Active bank A to Active bank B time)
	                                                        // 00 : 1 clk
	                                                        // 01 : 2 clks
	                                                        // 10 : 3 clks (default)
	                                                        // 11 : reserved
	unsigned int reserved1         : BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved1;         // reserved
	unsigned int t_WR              : BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_WR;              // Write recovery time (last write data to Precharge)
	                                                        // 00 : 1 clk
	                                                        // 01 : 2 clks
	                                                        // 10 : 3 clks (default)
	                                                        // 11 : reserved
	unsigned int t_RP              : BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RP;              // Precharge command period time (Precharge to command)
	                                                        // 00 : 1 clk
	                                                        // 01 : 2 clks
	                                                        // 10 : 3 clks (default)
	                                                        // 11 : reserved
	unsigned int t_RAS             : BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RAS;             // Active to Precharge command time (clk = t_RAS + 3)
	                                                        // 000 :  3 clks
	                                                        // 001 :  4 clks
	                                                        // and so on
	                                                        // 111 : 10 clks (default)
	unsigned int reserved2         : BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved2;         // reserved
	unsigned int t_RFC             : BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_RFC;             // Refresh to Command time (clk = tRFC + 4)
	                                                        // 0000 :  4 clks
	                                                        // 0001 :  5 clks
	                                                        // and so on
	                                                        // 1111 :  19 clks (default)
	unsigned int t_REFI            : BFW_NETX_MEM_SDRAM_TIMING_CTRL_t_REFI;            // Average Periodic refresh interval (3.90 us * 2^t_REFI
	                                                        // 00 :   3.90 us
	                                                        // 01 :   7.80 us (default)
	                                                        // 10 :  15.60 us
	                                                        // 11 :  31.20 us
	unsigned int reserved3         : BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved3;         // reserved
	unsigned int mem_sdclk_phase   : BFW_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_phase;   // 0..5: adjustable phase-shift for external SDRAM clock depending on external capacitive
	                                                        // load on mem_sdclk-signal to match SDRAM ctrl-signal setup times. The phase can be shiftet in 1.25ns steps.
	                                                        // mem_sdlk will internally rise at the mem_sdclk_phase+2nd clk400 edge after internal changes of
	                                                        // SDRAM ctrl-signals (mem_sd*-signals, driven by clk_memsig), where the 1st egde is defined by the
	                                                        // mem_sdclk_ssneg-bit.
	                                                        // For correct settings, delays depending on external capacitive have to be respected.
	unsigned int mem_sdclk_ssneg   : BFW_NETX_MEM_SDRAM_TIMING_CTRL_mem_sdclk_ssneg;   // 1: clk_memsig will be sampled for mem_sdclk-generation internally first on negedge of clk400
	                                                        // 0: clk_memsig will be sampled for mem_sdclk-generation internally first on posedge of clk400. Evaluation purpose only - don't use this setting!
	unsigned int data_sample_phase : BFW_NETX_MEM_SDRAM_TIMING_CTRL_data_sample_phase; // 0..5: adjustable phase-shift for data sampling SDRAM loopback clock (clk_sdloopback)
	                                                        // depending external capacitive load and SDRAM access time (t_AC). The phase can be shiftet in 1.25ns steps.
	                                                        // clk_sdloopback will internally rise (sample SDRAM read data) at the data_sample_phase+4th clk400 edge
	                                                        // after rise of external mem_sdclk (including external capacitive load).
	                                                        // For correct settings, the delays depending on external capacitive have to be respected.
	                                                        // Data sampling has to be done at least 8ns after internal changes of SDRAM ctrl-signals (mem_sd*-signals,
	                                                        // driven by clk_memsig) .
	unsigned int reserved4         : BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved4;         // reserved
	unsigned int bypass_neg_delay  : BFW_NETX_MEM_SDRAM_TIMING_CTRL_bypass_neg_delay;  // 0: use phase shifted (negative delayed) SDRAM loopback clock for data sampling.
	                                                        // 1: bypass phase shift logic for SDRAM data sampling use SDRAM loopback clock for data sampling.
	                                                        //    Bypass must be used for system clock frequenzies <= 80MHz (rate_mull_add <= 0xC0)
	unsigned int reserved5         : BFW_NETX_MEM_SDRAM_TIMING_CTRL_reserved5;         // reserved
} SDRAM_TIMING_CTRL_BIT_T;

typedef union {
	unsigned int            val;
	SDRAM_TIMING_CTRL_BIT_T bf;
} SDRAM_TIMING_CTRL_T;

// ---------------------------------------------------------------------
// Register sdram_mr
// =>  Moder Register for all SDRAM-devicetypes and Extended Mode Register for DDR/DDR2-SDRAM-devices.
//     Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0)
//     to avoid configuration problems.
//     The SDRAM Mode Registers will be set after enabling the SDRAM Controller in the 200us
//     SDRAM memory initialisation procedure.
//     ----------------------------------------------------------
//     No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options
//     ----------------------------------------------------------
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SDRAM_MODE 0x00000008U
#define NETX_MEM_SDRAM_MODE     0x1C000148U

#define MSK_NETX_MEM_SDRAM_MODE_MR  0x00003fffU // [13:0]
#define SRT_NETX_MEM_SDRAM_MODE_MR  0
#define MSK_NETX_MEM_SDRAM_MODE_EMR 0x3fff0000U // [29:16]
#define SRT_NETX_MEM_SDRAM_MODE_EMR 16

enum {
	BFW_NETX_MEM_SDRAM_MODE_MR        = 14, // [13:0]
	BFW_NETX_MEM_SDRAM_MODE_reserved1 = 2,  // [15:14]
	BFW_NETX_MEM_SDRAM_MODE_EMR       = 14, // [29:16]
	BFW_NETX_MEM_SDRAM_MODE_reserved2 = 2   // [31:30]
};

typedef struct SDRAM_MR_BIT_Ttag {
	unsigned int MR        : BFW_NETX_MEM_SDRAM_MODE_MR;        // SDRAM Mode Register.
	                                                        // CAS latency bits in modereg[6:4], only CL2 and CL3 are supported, not CL1; default is CL3
	                                                        // The controller supports only Burst Length 8 on dq16 an 4 on dq32 (default)
	                                                        // SDRAM DLL reset on initiaisation procedure is done by modereg[8]
	unsigned int reserved1 : BFW_NETX_MEM_SDRAM_MODE_reserved1; // reserved
	unsigned int EMR       : BFW_NETX_MEM_SDRAM_MODE_EMR;       // Extended Mode Register for DDR/DDR2 - SDRAM devices
	                                                        // The following settings must not be changed because tey are not supported by the Controller:
	                                                        // Additive Latency (EMR[5:3]) - fix to AL 0
	                                                        // nDQS (EMR[10]) - always disabled
	                                                        // RDQS (EMR[12]) - always disabled
	unsigned int reserved2 : BFW_NETX_MEM_SDRAM_MODE_reserved2; // reserved
} SDRAM_MR_BIT_T;

typedef union {
	unsigned int   val;
	SDRAM_MR_BIT_T bf;
} SDRAM_MR_T;

// ---------------------------------------------------------------------
// Register sdram_emr2
// =>  Extended Mode Registers EMR2 and EMR3 for DDR2 - SDRAM devices.
//     Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0)
//     to avoid configuration problems.
//     The SDRAM Mode Registers will be set after enabling the SDRAM Controller in the 200us
//     SDRAM memory initialisation procedure.
//     ----------------------------------------------------------
//     No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options
//     ----------------------------------------------------------
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_SDRAM_EXT_MODE 0x0000000CU
#define NETX_MEM_SDRAM_EXT_MODE     0x1C00014CU

#define MSK_NETX_MEM_SDRAM_EXT_MODE_EMR2 0x00003fffU // [13:0]
#define SRT_NETX_MEM_SDRAM_EXT_MODE_EMR2 0
#define MSK_NETX_MEM_SDRAM_EXT_MODE_EMR3 0x3fff0000U // [29:16]
#define SRT_NETX_MEM_SDRAM_EXT_MODE_EMR3 16

enum {
	BFW_NETX_MEM_SDRAM_EXT_MODE_EMR2      = 14, // [13:0]
	BFW_NETX_MEM_SDRAM_EXT_MODE_reserved1 = 2,  // [15:14]
	BFW_NETX_MEM_SDRAM_EXT_MODE_EMR3      = 14, // [29:16]
	BFW_NETX_MEM_SDRAM_EXT_MODE_reserved2 = 2   // [31:30]
};

typedef struct SDRAM_EMR2_BIT_Ttag {
	unsigned int EMR2      : BFW_NETX_MEM_SDRAM_EXT_MODE_EMR2;      // Extended Mode Register 2 for DDR2 - SDRAM devices
	                                                        // For further extensions. No Settings must be done, which affect non supported
	                                                        // SDRAM-Controller features.
	unsigned int reserved1 : BFW_NETX_MEM_SDRAM_EXT_MODE_reserved1; // reserved
	unsigned int EMR3      : BFW_NETX_MEM_SDRAM_EXT_MODE_EMR3;      // Extended Mode Register 3 for DDR2 - SDRAM devices
	                                                        // For further extensions. No Settings must be done, which affect non supported
	                                                        // SDRAM-Controller features.
	unsigned int reserved2 : BFW_NETX_MEM_SDRAM_EXT_MODE_reserved2; // reserved
} SDRAM_EMR2_BIT_T;

typedef union {
	unsigned int     val;
	SDRAM_EMR2_BIT_T bf;
} SDRAM_EMR2_T;


// =====================================================================
//
// Area of extmem_priority_ctrl
//
// =====================================================================

#define NETX_MEM_PRIO_CTRL_AREA	0x1C000180U

// ---------------------------------------------------------------------
// Register extmem_prio_timslot_ctrl
// =>  Memory interface master timeslot priority control register.
//     This register may be partially locked by the exmem_priority_lock-register in asic_ctrl-address area.
//     Note:
//     Any master can access in one timeslot ((ts_accessrate_mX*ts_length_mX)/64) + 1 times (i.e. at
//     maximum (ts_accessrate_mX)/64 bandwidth on external memory bus, ts_accessrate_mX is programmed
//     by extmem_prio_accesstime_ctrl-register).
//     Priority control will watch data accesses on external memory data bus (SDRAM and non SDRAM),
//     including pauses on non SDRAM-accesses, not including control commands to SDRAM.
//     Any master requesting more accesses will be forced to wait for the remaining timeslot.
//    --------------------------------------------------------
//     Programmable timeslots are:
//        ts_length =  0 :             64 systen clock cycles (i.e  0.64us at 100MHz)
//        ts_length =  1 :            128 systen clock cycles (i.e  1.28us at 100MHz)
//        ts_length =  2 :            256 systen clock cycles (i.e  2.56us at 100MHz)
//        ts_length =  3 :            512 systen clock cycles (i.e  5.12us at 100MHz)
//        ts_length =  4 :           1024 systen clock cycles (i.e 10.24us at 100MHz)
//        ts_length =  5 :           2048 systen clock cycles (i.e 20.48us at 100MHz)
//        ts_length =  6 :           4096 systen clock cycles (i.e 40.96us at 100MHz)
//        ts_length =  7 :           8192 systen clock cycles (i.e 81.92us at 100MHz)
//    --------------------------------------------------------
//     master channel m0: Host Bus Interface  (highest priority)
//     master channel m1: XC
//     master channel m2: DMA-Controller
//     master channel m3: ARM  channel (instruction and data) (lowest priority)
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_PRIO_TIMESLOT_CTRL 0x00000000U
#define NETX_MEM_PRIO_TIMESLOT_CTRL     0x1C000180U

#define MSK_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_HIF_mi 0x00000007U // [2:0]
#define SRT_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_HIF_mi 0
#define MSK_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_XC_mi  0x00000070U // [6:4]
#define SRT_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_XC_mi  4
#define MSK_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_DMA_mi 0x00000700U // [10:8]
#define SRT_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_DMA_mi 8
#define MSK_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_ARM_mi 0x00007000U // [14:12]
#define SRT_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_ARM_mi 12

enum {
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_HIF_mi = 3,  // [2:0]
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved1        = 1,  // [3]
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_XC_mi  = 3,  // [6:4]
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved2        = 1,  // [7]
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_DMA_mi = 3,  // [10:8]
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved3        = 1,  // [11]
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_ARM_mi = 3,  // [14:12]
	BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved4        = 17  // [31:15]
};

typedef struct EXTMEM_PRIO_TIMSLOT_CTRL_BIT_Ttag {
	unsigned int ts_length_HIF_mi : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_HIF_mi; // 0..7: the timeslot of master m0 is on external memory interface 64*2^ts_length_HIF_mi systen clock cycles
	unsigned int reserved1        : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved1;        // reserved
	unsigned int ts_length_XC_mi  : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_XC_mi;  // 0..7: the timeslot of master m1 is on external memory interface 64*2^ts_length_XC_mi systen clock cycles
	unsigned int reserved2        : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved2;        // reserved
	unsigned int ts_length_DMA_mi : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_DMA_mi; // 0..7: the timeslot of master m2 is on external memory interface 64*2^ts_length_DMA_mi systen clock cycles
	unsigned int reserved3        : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved3;        // reserved
	unsigned int ts_length_ARM_mi : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_ts_length_ARM_mi; // 0..7: the timeslot of master m3 is on external memory interface 64*2^ts_length_ARM_mi systen clock cycles
	unsigned int reserved4        : BFW_NETX_MEM_PRIO_TIMESLOT_CTRL_reserved4;        // reserved
} EXTMEM_PRIO_TIMSLOT_CTRL_BIT_T;

typedef union {
	unsigned int                   val;
	EXTMEM_PRIO_TIMSLOT_CTRL_BIT_T bf;
} EXTMEM_PRIO_TIMSLOT_CTRL_T;

// ---------------------------------------------------------------------
// Register extmem_prio_accesstime_ctrl
// =>  Control Register for master channel accesses per timeslot on external meory interface.
//     This register may be partially locked by the exmem_priority_lock-register in asic_ctrl-address area.
//     For detailed priority controlling read note at extmem_prio_timslot_ctrl-register description.
//    --------------------------------------------------------
//     master channel m0: Host Bus Interface  (highest priority)
//     master channel m1: XC
//     master channel m2: DMA-Controller
//     master channel m3: ARM channel (instruction and data) (lowest priority)
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MEM_PRIO_ACCESS_CTRL 0x00000004U
#define NETX_MEM_PRIO_ACCESS_CTRL     0x1C000184U

#define MSK_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_HIF_mi 0x0000003fU // [5:0]
#define SRT_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_HIF_mi 0
#define MSK_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_XC_mi  0x00000fc0U // [11:6]
#define SRT_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_XC_mi  6
#define MSK_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_DMA_mi 0x0003f000U // [17:12]
#define SRT_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_DMA_mi 12
#define MSK_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_ARM_mi 0x00fc0000U // [23:18]
#define SRT_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_ARM_mi 18

enum {
	BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_HIF_mi = 6, // [5:0]
	BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_XC_mi  = 6, // [11:6]
	BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_DMA_mi = 6, // [17:12]
	BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_ARM_mi = 6, // [23:18]
	BFW_NETX_MEM_PRIO_ACCESS_CTRL_reserved1            = 8  // [31:24]
};

typedef struct EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_Ttag {
	unsigned int ts_accessrate_HIF_mi : BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_HIF_mi; // 0..63: master m0 is alowed to request ((ts_accessrate_HIF_mi*ts_length_HIF_mi)/64) + 1 accesses on external memory
	unsigned int ts_accessrate_XC_mi  : BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_XC_mi;  // 0..63: master m1 is alowed to request ((ts_accessrate_XC_mi*ts_length_XC_mi)/64) + 1 accesses on external memory
	unsigned int ts_accessrate_DMA_mi : BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_DMA_mi; // 0..63: master m2 is alowed to request ((ts_accessrate_DMA_mi*ts_length_DMA_mi)/64) + 1 accesses on external memory
	unsigned int ts_accessrate_ARM_mi : BFW_NETX_MEM_PRIO_ACCESS_CTRL_ts_accessrate_ARM_mi; // 0..63: master m3 is alowed to request ((ts_accessrate_ARM_mi*ts_length_ARM_mi)/64) + 1 accesses on external memory
	unsigned int reserved1            : BFW_NETX_MEM_PRIO_ACCESS_CTRL_reserved1;            // reserved
} EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_T;

typedef union {
	unsigned int                      val;
	EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_T bf;
} EXTMEM_PRIO_ACCESSTIME_CTRL_T;


// =====================================================================
//
// Area of watchdog
//
// =====================================================================

#define NETX_WDG_AREA	0x1C000200U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl
// =>  netX System Watchdog Trigger Register.
//     The watchdog access code is generated by a pseudo random generator.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG 0x00000000U
#define NETX_WDG_TRIG     0x1C000200U

#define MSK_NETX_WDG_TRIG_wdg_access_code       0x000fffffU // [19:0]
#define SRT_NETX_WDG_TRIG_wdg_access_code       0
#define MSK_NETX_WDG_TRIG_irq_req_watchdog      0x01000000U // [24]
#define SRT_NETX_WDG_TRIG_irq_req_watchdog      24
#define MSK_NETX_WDG_TRIG_wdg_counter_trigger_w 0x10000000U // [28]
#define SRT_NETX_WDG_TRIG_wdg_counter_trigger_w 28
#define MSK_NETX_WDG_TRIG_wdg_active_enable_w   0x20000000U // [29]
#define SRT_NETX_WDG_TRIG_wdg_active_enable_w   29
#define MSK_NETX_WDG_TRIG_write_enable          0x80000000U // [31]
#define SRT_NETX_WDG_TRIG_write_enable          31

enum {
	BFW_NETX_WDG_TRIG_wdg_access_code       = 20, // [19:0]
	BFW_NETX_WDG_TRIG_reserved1             = 4,  // [23:20]
	BFW_NETX_WDG_TRIG_irq_req_watchdog      = 1,  // [24]
	BFW_NETX_WDG_TRIG_reserved2             = 3,  // [27:25]
	BFW_NETX_WDG_TRIG_wdg_counter_trigger_w = 1,  // [28]
	BFW_NETX_WDG_TRIG_wdg_active_enable_w   = 1,  // [29]
	BFW_NETX_WDG_TRIG_reserved3             = 1,  // [30]
	BFW_NETX_WDG_TRIG_write_enable          = 1   // [31]
};

typedef struct NETX_SYS_WDG_CTRL_BIT_Ttag {
	unsigned int wdg_access_code       : BFW_NETX_WDG_TRIG_wdg_access_code;       // Watchdog access code for triggering. A read access gives the next 16 bit code for trigger.
	                                                        // A write access with correct access code will trigger the watchdog counter.
	unsigned int reserved1             : BFW_NETX_WDG_TRIG_reserved1;             // reserved
	unsigned int irq_req_watchdog      : BFW_NETX_WDG_TRIG_irq_req_watchdog;      // IRQ request of watchdog, writing 1 deletes IRQ
	unsigned int reserved2             : BFW_NETX_WDG_TRIG_reserved2;             // reserved
	unsigned int wdg_counter_trigger_w : BFW_NETX_WDG_TRIG_wdg_counter_trigger_w; // ???, write only register bit
	unsigned int wdg_active_enable_w   : BFW_NETX_WDG_TRIG_wdg_active_enable_w;   // ???, write only register bit
	unsigned int reserved3             : BFW_NETX_WDG_TRIG_reserved3;             // reserved
	unsigned int write_enable          : BFW_NETX_WDG_TRIG_write_enable;          // ???
} NETX_SYS_WDG_CTRL_BIT_T;

typedef union {
	unsigned int            val;
	NETX_SYS_WDG_CTRL_BIT_T bf;
} NETX_SYS_WDG_CTRL_T;

// ---------------------------------------------------------------------
// Register netx_sys_wdg
// =>  netX System Watchdog Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR 0x00000004U
#define NETX_WDG_CNTR     0x1C000204U

#define MSK_NETX_WDG_CNTR_wdg_counter 0x0001ffffU // [16:0]
#define SRT_NETX_WDG_CNTR_wdg_counter 0

enum {
	BFW_NETX_WDG_CNTR_wdg_counter = 17, // [16:0]
	BFW_NETX_WDG_CNTR_reserved1   = 15  // [31:17]
};

typedef struct NETX_SYS_WDG_BIT_Ttag {
	unsigned int wdg_counter : BFW_NETX_WDG_CNTR_wdg_counter; // Actual watchdog counter value
	unsigned int reserved1   : BFW_NETX_WDG_CNTR_reserved1;   // reserved
} NETX_SYS_WDG_BIT_T;

typedef union {
	unsigned int       val;
	NETX_SYS_WDG_BIT_T bf;
} NETX_SYS_WDG_T;

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout
// =>  netX System Wachtdog Interrupt Timout Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT 0x00000008U
#define NETX_WDG_IRQ_TIMEOUT     0x1C000208U

#define MSK_NETX_WDG_IRQ_TIMEOUT_wdg_irq_timeout 0x0000ffffU // [15:0]
#define SRT_NETX_WDG_IRQ_TIMEOUT_wdg_irq_timeout 0

enum {
	BFW_NETX_WDG_IRQ_TIMEOUT_wdg_irq_timeout = 16, // [15:0]
	BFW_NETX_WDG_IRQ_TIMEOUT_reserved1       = 16  // [31:16]
};

typedef struct NETX_SYS_WDG_IRQ_TIMEOUT_BIT_Ttag {
	unsigned int wdg_irq_timeout : BFW_NETX_WDG_IRQ_TIMEOUT_wdg_irq_timeout; // Watchdog interrupt timeout
	unsigned int reserved1       : BFW_NETX_WDG_IRQ_TIMEOUT_reserved1;       // reserved
} NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T;

typedef union {
	unsigned int                   val;
	NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T bf;
} NETX_SYS_WDG_IRQ_TIMEOUT_T;

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout
// =>  netX System Watchdog Reset Timeout Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT 0x0000000CU
#define NETX_WDG_RESET_TIMEOUT     0x1C00020CU

#define MSK_NETX_WDG_RESET_TIMEOUT_wdg_res_timeout 0x0000ffffU // [15:0]
#define SRT_NETX_WDG_RESET_TIMEOUT_wdg_res_timeout 0

enum {
	BFW_NETX_WDG_RESET_TIMEOUT_wdg_res_timeout = 16, // [15:0]
	BFW_NETX_WDG_RESET_TIMEOUT_reserved1       = 16  // [31:16]
};

typedef struct NETX_SYS_WDG_RES_TIMEOUT_BIT_Ttag {
	unsigned int wdg_res_timeout : BFW_NETX_WDG_RESET_TIMEOUT_wdg_res_timeout; // Watchdog Reset Request Timeout
	unsigned int reserved1       : BFW_NETX_WDG_RESET_TIMEOUT_reserved1;       // reserved
} NETX_SYS_WDG_RES_TIMEOUT_BIT_T;

typedef union {
	unsigned int                   val;
	NETX_SYS_WDG_RES_TIMEOUT_BIT_T bf;
} NETX_SYS_WDG_RES_TIMEOUT_T;

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror1
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror1 0x00000010U
#define NETX_WDG_TRIG_mirror1     0x1C000210U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror1
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror1 0x00000014U
#define NETX_WDG_CNTR_mirror1     0x1C000214U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror1
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror1 0x00000018U
#define NETX_WDG_IRQ_TIMEOUT_mirror1     0x1C000218U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror1
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror1 0x0000001CU
#define NETX_WDG_RESET_TIMEOUT_mirror1     0x1C00021CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror2
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror2 0x00000020U
#define NETX_WDG_TRIG_mirror2     0x1C000220U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror2
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror2 0x00000024U
#define NETX_WDG_CNTR_mirror2     0x1C000224U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror2
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror2 0x00000028U
#define NETX_WDG_IRQ_TIMEOUT_mirror2     0x1C000228U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror2
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror2 0x0000002CU
#define NETX_WDG_RESET_TIMEOUT_mirror2     0x1C00022CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror3
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror3 0x00000030U
#define NETX_WDG_TRIG_mirror3     0x1C000230U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror3
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror3 0x00000034U
#define NETX_WDG_CNTR_mirror3     0x1C000234U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror3
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror3 0x00000038U
#define NETX_WDG_IRQ_TIMEOUT_mirror3     0x1C000238U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror3
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror3 0x0000003CU
#define NETX_WDG_RESET_TIMEOUT_mirror3     0x1C00023CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror4
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror4 0x00000040U
#define NETX_WDG_TRIG_mirror4     0x1C000240U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror4
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror4 0x00000044U
#define NETX_WDG_CNTR_mirror4     0x1C000244U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror4
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror4 0x00000048U
#define NETX_WDG_IRQ_TIMEOUT_mirror4     0x1C000248U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror4
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror4 0x0000004CU
#define NETX_WDG_RESET_TIMEOUT_mirror4     0x1C00024CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror5
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror5 0x00000050U
#define NETX_WDG_TRIG_mirror5     0x1C000250U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror5
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror5 0x00000054U
#define NETX_WDG_CNTR_mirror5     0x1C000254U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror5
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror5 0x00000058U
#define NETX_WDG_IRQ_TIMEOUT_mirror5     0x1C000258U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror5
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror5 0x0000005CU
#define NETX_WDG_RESET_TIMEOUT_mirror5     0x1C00025CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror6
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror6 0x00000060U
#define NETX_WDG_TRIG_mirror6     0x1C000260U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror6
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror6 0x00000064U
#define NETX_WDG_CNTR_mirror6     0x1C000264U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror6
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror6 0x00000068U
#define NETX_WDG_IRQ_TIMEOUT_mirror6     0x1C000268U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror6
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror6 0x0000006CU
#define NETX_WDG_RESET_TIMEOUT_mirror6     0x1C00026CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror7
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror7 0x00000070U
#define NETX_WDG_TRIG_mirror7     0x1C000270U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror7
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror7 0x00000074U
#define NETX_WDG_CNTR_mirror7     0x1C000274U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror7
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror7 0x00000078U
#define NETX_WDG_IRQ_TIMEOUT_mirror7     0x1C000278U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror7
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror7 0x0000007CU
#define NETX_WDG_RESET_TIMEOUT_mirror7     0x1C00027CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror8
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror8 0x00000080U
#define NETX_WDG_TRIG_mirror8     0x1C000280U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror8
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror8 0x00000084U
#define NETX_WDG_CNTR_mirror8     0x1C000284U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror8
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror8 0x00000088U
#define NETX_WDG_IRQ_TIMEOUT_mirror8     0x1C000288U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror8
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror8 0x0000008CU
#define NETX_WDG_RESET_TIMEOUT_mirror8     0x1C00028CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror9
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror9 0x00000090U
#define NETX_WDG_TRIG_mirror9     0x1C000290U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror9
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror9 0x00000094U
#define NETX_WDG_CNTR_mirror9     0x1C000294U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror9
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror9 0x00000098U
#define NETX_WDG_IRQ_TIMEOUT_mirror9     0x1C000298U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror9
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror9 0x0000009CU
#define NETX_WDG_RESET_TIMEOUT_mirror9     0x1C00029CU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror10
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror10 0x000000A0U
#define NETX_WDG_TRIG_mirror10     0x1C0002A0U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror10
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror10 0x000000A4U
#define NETX_WDG_CNTR_mirror10     0x1C0002A4U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror10
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror10 0x000000A8U
#define NETX_WDG_IRQ_TIMEOUT_mirror10     0x1C0002A8U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror10
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror10 0x000000ACU
#define NETX_WDG_RESET_TIMEOUT_mirror10     0x1C0002ACU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror11
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror11 0x000000B0U
#define NETX_WDG_TRIG_mirror11     0x1C0002B0U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror11
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror11 0x000000B4U
#define NETX_WDG_CNTR_mirror11     0x1C0002B4U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror11
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror11 0x000000B8U
#define NETX_WDG_IRQ_TIMEOUT_mirror11     0x1C0002B8U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror11
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror11 0x000000BCU
#define NETX_WDG_RESET_TIMEOUT_mirror11     0x1C0002BCU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror12
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror12 0x000000C0U
#define NETX_WDG_TRIG_mirror12     0x1C0002C0U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror12
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror12 0x000000C4U
#define NETX_WDG_CNTR_mirror12     0x1C0002C4U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror12
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror12 0x000000C8U
#define NETX_WDG_IRQ_TIMEOUT_mirror12     0x1C0002C8U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror12
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror12 0x000000CCU
#define NETX_WDG_RESET_TIMEOUT_mirror12     0x1C0002CCU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror13
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror13 0x000000D0U
#define NETX_WDG_TRIG_mirror13     0x1C0002D0U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror13
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror13 0x000000D4U
#define NETX_WDG_CNTR_mirror13     0x1C0002D4U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror13
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror13 0x000000D8U
#define NETX_WDG_IRQ_TIMEOUT_mirror13     0x1C0002D8U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror13
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror13 0x000000DCU
#define NETX_WDG_RESET_TIMEOUT_mirror13     0x1C0002DCU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror14
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror14 0x000000E0U
#define NETX_WDG_TRIG_mirror14     0x1C0002E0U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror14
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror14 0x000000E4U
#define NETX_WDG_CNTR_mirror14     0x1C0002E4U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror14
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror14 0x000000E8U
#define NETX_WDG_IRQ_TIMEOUT_mirror14     0x1C0002E8U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror14
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror14 0x000000ECU
#define NETX_WDG_RESET_TIMEOUT_mirror14     0x1C0002ECU

// ---------------------------------------------------------------------
// Register netx_sys_wdg_ctrl_mirror15
// =>  mirror of netx_sys_wdg_ctrl, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_TRIG_mirror15 0x000000F0U
#define NETX_WDG_TRIG_mirror15     0x1C0002F0U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_mirror15
// =>  mirror of netx_sys_wdg, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_CNTR_mirror15 0x000000F4U
#define NETX_WDG_CNTR_mirror15     0x1C0002F4U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_irq_timeout_mirror15
// =>  mirror of netx_sys_wdg_irq_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_IRQ_TIMEOUT_mirror15 0x000000F8U
#define NETX_WDG_IRQ_TIMEOUT_mirror15     0x1C0002F8U

// ---------------------------------------------------------------------
// Register netx_sys_wdg_res_timeout_mirror15
// =>  mirror of netx_sys_wdg_res_timeout, DO NOT USE !
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_WDG_RESET_TIMEOUT_mirror15 0x000000FCU
#define NETX_WDG_RESET_TIMEOUT_mirror15     0x1C0002FCU


// =====================================================================
//
// Area of abort
//
// =====================================================================

#define NETX_ABORT_AREA	0x1C000300U

// =====================================================================
//
// Area of gpio
//
// =====================================================================

#define NETX_GPIO_AREA	0x1C000800U

// ---------------------------------------------------------------------
// Register gpio_cfg0
// =>  GPIO pin 0 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG0 0x00000000U
#define NETX_GPIO_CFG0     0x1C000800U

#define MSK_NETX_GPIO_CFG0_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG0_mode      0
#define MSK_NETX_GPIO_CFG0_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG0_inv       4
#define MSK_NETX_GPIO_CFG0_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG0_count_ref 5

enum {
	BFW_NETX_GPIO_CFG0_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG0_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG0_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG0_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG0_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG0_mode;      // defines the gp input or output mode - depends on iocfg
	                                                        // Input modi :
	                                                        //  0000: read mode
	                                                        //  0001: capture continued at rising edge (allows gpio_irq on each capture)
	                                                        //  0010: capture once at rising edge (reset gpio_irq to capture again)
	                                                        //  0011: capture once at high level (reset gpio_irq to capture again)
	                                                        // Output modi:
	                                                        //  0100: set to 0
	                                                        //  0101: set to 1
	                                                        //  0110: set to gpio_line[0]
	                                                        //  0111: pwm mode, direct treshold update (might cause hazards on output)
	                                                        // Multi pin modi:
	                                                        //  1000: IO-Link mode (always uses 4 sequential GPIOs, e.g. [0123], [4567],...)
	                                                        //  1111: pwm2-mode with treshold update at counter=0 from gpio_tc[(n+16)%32] register (hazard-free)
	unsigned int inv       : BFW_NETX_GPIO_CFG0_inv;       // 1: invert input/output value
	                                                        // 0: don't invert input/output
	unsigned int count_ref : BFW_NETX_GPIO_CFG0_count_ref; // counter reference
	                                                        //  000: counter 0
	                                                        //  001: counter 1
	                                                        //  010: counter 2
	                                                        //  011: counter 3
	                                                        //  100: counter 4
	                                                        //  111: system time
	unsigned int reserved1 : BFW_NETX_GPIO_CFG0_reserved1; // reserved
} GPIO_CFG0_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG0_BIT_T bf;
} GPIO_CFG0_T;

// ---------------------------------------------------------------------
// Register gpio_cfg1
// =>  GPIO pin 1 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG1 0x00000004U
#define NETX_GPIO_CFG1     0x1C000804U

#define MSK_NETX_GPIO_CFG1_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG1_mode      0
#define MSK_NETX_GPIO_CFG1_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG1_inv       4
#define MSK_NETX_GPIO_CFG1_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG1_count_ref 5

enum {
	BFW_NETX_GPIO_CFG1_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG1_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG1_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG1_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG1_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG1_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG1_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG1_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG1_reserved1; // reserved
} GPIO_CFG1_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG1_BIT_T bf;
} GPIO_CFG1_T;

// ---------------------------------------------------------------------
// Register gpio_cfg2
// =>  GPIO pin 2 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG2 0x00000008U
#define NETX_GPIO_CFG2     0x1C000808U

#define MSK_NETX_GPIO_CFG2_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG2_mode      0
#define MSK_NETX_GPIO_CFG2_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG2_inv       4
#define MSK_NETX_GPIO_CFG2_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG2_count_ref 5

enum {
	BFW_NETX_GPIO_CFG2_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG2_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG2_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG2_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG2_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG2_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG2_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG2_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG2_reserved1; // reserved
} GPIO_CFG2_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG2_BIT_T bf;
} GPIO_CFG2_T;

// ---------------------------------------------------------------------
// Register gpio_cfg3
// =>  GPIO pin 3 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG3 0x0000000CU
#define NETX_GPIO_CFG3     0x1C00080CU

#define MSK_NETX_GPIO_CFG3_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG3_mode      0
#define MSK_NETX_GPIO_CFG3_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG3_inv       4
#define MSK_NETX_GPIO_CFG3_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG3_count_ref 5

enum {
	BFW_NETX_GPIO_CFG3_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG3_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG3_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG3_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG3_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG3_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG3_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG3_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG3_reserved1; // reserved
} GPIO_CFG3_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG3_BIT_T bf;
} GPIO_CFG3_T;

// ---------------------------------------------------------------------
// Register gpio_cfg4
// =>  GPIO pin 4 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG4 0x00000010U
#define NETX_GPIO_CFG4     0x1C000810U

#define MSK_NETX_GPIO_CFG4_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG4_mode      0
#define MSK_NETX_GPIO_CFG4_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG4_inv       4
#define MSK_NETX_GPIO_CFG4_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG4_count_ref 5

enum {
	BFW_NETX_GPIO_CFG4_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG4_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG4_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG4_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG4_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG4_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG4_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG4_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG4_reserved1; // reserved
} GPIO_CFG4_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG4_BIT_T bf;
} GPIO_CFG4_T;

// ---------------------------------------------------------------------
// Register gpio_cfg5
// =>  GPIO pin 5 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG5 0x00000014U
#define NETX_GPIO_CFG5     0x1C000814U

#define MSK_NETX_GPIO_CFG5_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG5_mode      0
#define MSK_NETX_GPIO_CFG5_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG5_inv       4
#define MSK_NETX_GPIO_CFG5_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG5_count_ref 5

enum {
	BFW_NETX_GPIO_CFG5_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG5_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG5_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG5_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG5_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG5_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG5_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG5_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG5_reserved1; // reserved
} GPIO_CFG5_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG5_BIT_T bf;
} GPIO_CFG5_T;

// ---------------------------------------------------------------------
// Register gpio_cfg6
// =>  GPIO pin 6 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG6 0x00000018U
#define NETX_GPIO_CFG6     0x1C000818U

#define MSK_NETX_GPIO_CFG6_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG6_mode      0
#define MSK_NETX_GPIO_CFG6_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG6_inv       4
#define MSK_NETX_GPIO_CFG6_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG6_count_ref 5

enum {
	BFW_NETX_GPIO_CFG6_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG6_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG6_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG6_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG6_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG6_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG6_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG6_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG6_reserved1; // reserved
} GPIO_CFG6_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG6_BIT_T bf;
} GPIO_CFG6_T;

// ---------------------------------------------------------------------
// Register gpio_cfg7
// =>  GPIO pin 7 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG7 0x0000001CU
#define NETX_GPIO_CFG7     0x1C00081CU

#define MSK_NETX_GPIO_CFG7_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG7_mode      0
#define MSK_NETX_GPIO_CFG7_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG7_inv       4
#define MSK_NETX_GPIO_CFG7_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG7_count_ref 5

enum {
	BFW_NETX_GPIO_CFG7_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG7_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG7_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG7_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG7_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG7_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG7_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG7_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG7_reserved1; // reserved
} GPIO_CFG7_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG7_BIT_T bf;
} GPIO_CFG7_T;

// ---------------------------------------------------------------------
// Register gpio_cfg8
// =>  GPIO pin 8 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG8 0x00000020U
#define NETX_GPIO_CFG8     0x1C000820U

#define MSK_NETX_GPIO_CFG8_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG8_mode      0
#define MSK_NETX_GPIO_CFG8_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG8_inv       4
#define MSK_NETX_GPIO_CFG8_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG8_count_ref 5

enum {
	BFW_NETX_GPIO_CFG8_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG8_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG8_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG8_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG8_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG8_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG8_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG8_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG8_reserved1; // reserved
} GPIO_CFG8_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG8_BIT_T bf;
} GPIO_CFG8_T;

// ---------------------------------------------------------------------
// Register gpio_cfg9
// =>  GPIO pin 9 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG9 0x00000024U
#define NETX_GPIO_CFG9     0x1C000824U

#define MSK_NETX_GPIO_CFG9_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG9_mode      0
#define MSK_NETX_GPIO_CFG9_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG9_inv       4
#define MSK_NETX_GPIO_CFG9_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG9_count_ref 5

enum {
	BFW_NETX_GPIO_CFG9_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG9_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG9_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG9_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG9_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG9_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG9_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG9_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG9_reserved1; // reserved
} GPIO_CFG9_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_CFG9_BIT_T bf;
} GPIO_CFG9_T;

// ---------------------------------------------------------------------
// Register gpio_cfg10
// =>  GPIO pin 10 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG10 0x00000028U
#define NETX_GPIO_CFG10     0x1C000828U

#define MSK_NETX_GPIO_CFG10_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG10_mode      0
#define MSK_NETX_GPIO_CFG10_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG10_inv       4
#define MSK_NETX_GPIO_CFG10_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG10_count_ref 5

enum {
	BFW_NETX_GPIO_CFG10_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG10_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG10_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG10_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG10_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG10_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG10_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG10_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG10_reserved1; // reserved
} GPIO_CFG10_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG10_BIT_T bf;
} GPIO_CFG10_T;

// ---------------------------------------------------------------------
// Register gpio_cfg11
// =>  GPIO pin 11 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG11 0x0000002CU
#define NETX_GPIO_CFG11     0x1C00082CU

#define MSK_NETX_GPIO_CFG11_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG11_mode      0
#define MSK_NETX_GPIO_CFG11_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG11_inv       4
#define MSK_NETX_GPIO_CFG11_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG11_count_ref 5

enum {
	BFW_NETX_GPIO_CFG11_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG11_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG11_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG11_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG11_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG11_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG11_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG11_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG11_reserved1; // reserved
} GPIO_CFG11_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG11_BIT_T bf;
} GPIO_CFG11_T;

// ---------------------------------------------------------------------
// Register gpio_cfg12
// =>  GPIO pin 12 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG12 0x00000030U
#define NETX_GPIO_CFG12     0x1C000830U

#define MSK_NETX_GPIO_CFG12_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG12_mode      0
#define MSK_NETX_GPIO_CFG12_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG12_inv       4
#define MSK_NETX_GPIO_CFG12_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG12_count_ref 5

enum {
	BFW_NETX_GPIO_CFG12_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG12_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG12_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG12_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG12_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG12_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG12_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG12_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG12_reserved1; // reserved
} GPIO_CFG12_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG12_BIT_T bf;
} GPIO_CFG12_T;

// ---------------------------------------------------------------------
// Register gpio_cfg13
// =>  GPIO pin 13 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG13 0x00000034U
#define NETX_GPIO_CFG13     0x1C000834U

#define MSK_NETX_GPIO_CFG13_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG13_mode      0
#define MSK_NETX_GPIO_CFG13_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG13_inv       4
#define MSK_NETX_GPIO_CFG13_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG13_count_ref 5

enum {
	BFW_NETX_GPIO_CFG13_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG13_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG13_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG13_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG13_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG13_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG13_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG13_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG13_reserved1; // reserved
} GPIO_CFG13_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG13_BIT_T bf;
} GPIO_CFG13_T;

// ---------------------------------------------------------------------
// Register gpio_cfg14
// =>  GPIO pin 14 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG14 0x00000038U
#define NETX_GPIO_CFG14     0x1C000838U

#define MSK_NETX_GPIO_CFG14_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG14_mode      0
#define MSK_NETX_GPIO_CFG14_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG14_inv       4
#define MSK_NETX_GPIO_CFG14_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG14_count_ref 5

enum {
	BFW_NETX_GPIO_CFG14_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG14_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG14_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG14_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG14_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG14_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG14_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG14_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG14_reserved1; // reserved
} GPIO_CFG14_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG14_BIT_T bf;
} GPIO_CFG14_T;

// ---------------------------------------------------------------------
// Register gpio_cfg15
// =>  GPIO pin 15 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG15 0x0000003CU
#define NETX_GPIO_CFG15     0x1C00083CU

#define MSK_NETX_GPIO_CFG15_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG15_mode      0
#define MSK_NETX_GPIO_CFG15_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG15_inv       4
#define MSK_NETX_GPIO_CFG15_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG15_count_ref 5

enum {
	BFW_NETX_GPIO_CFG15_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG15_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG15_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG15_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG15_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG15_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG15_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG15_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG15_reserved1; // reserved
} GPIO_CFG15_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG15_BIT_T bf;
} GPIO_CFG15_T;

// ---------------------------------------------------------------------
// Register gpio_cfg16
// =>  GPIO pin 16 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG16 0x00000040U
#define NETX_GPIO_CFG16     0x1C000840U

#define MSK_NETX_GPIO_CFG16_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG16_mode      0
#define MSK_NETX_GPIO_CFG16_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG16_inv       4
#define MSK_NETX_GPIO_CFG16_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG16_count_ref 5

enum {
	BFW_NETX_GPIO_CFG16_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG16_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG16_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG16_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG16_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG16_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG16_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG16_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG16_reserved1; // reserved
} GPIO_CFG16_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG16_BIT_T bf;
} GPIO_CFG16_T;

// ---------------------------------------------------------------------
// Register gpio_cfg17
// =>  GPIO pin 17 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG17 0x00000044U
#define NETX_GPIO_CFG17     0x1C000844U

#define MSK_NETX_GPIO_CFG17_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG17_mode      0
#define MSK_NETX_GPIO_CFG17_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG17_inv       4
#define MSK_NETX_GPIO_CFG17_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG17_count_ref 5

enum {
	BFW_NETX_GPIO_CFG17_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG17_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG17_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG17_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG17_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG17_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG17_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG17_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG17_reserved1; // reserved
} GPIO_CFG17_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG17_BIT_T bf;
} GPIO_CFG17_T;

// ---------------------------------------------------------------------
// Register gpio_cfg18
// =>  GPIO pin 18 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG18 0x00000048U
#define NETX_GPIO_CFG18     0x1C000848U

#define MSK_NETX_GPIO_CFG18_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG18_mode      0
#define MSK_NETX_GPIO_CFG18_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG18_inv       4
#define MSK_NETX_GPIO_CFG18_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG18_count_ref 5

enum {
	BFW_NETX_GPIO_CFG18_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG18_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG18_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG18_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG18_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG18_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG18_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG18_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG18_reserved1; // reserved
} GPIO_CFG18_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG18_BIT_T bf;
} GPIO_CFG18_T;

// ---------------------------------------------------------------------
// Register gpio_cfg19
// =>  GPIO pin 19 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG19 0x0000004CU
#define NETX_GPIO_CFG19     0x1C00084CU

#define MSK_NETX_GPIO_CFG19_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG19_mode      0
#define MSK_NETX_GPIO_CFG19_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG19_inv       4
#define MSK_NETX_GPIO_CFG19_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG19_count_ref 5

enum {
	BFW_NETX_GPIO_CFG19_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG19_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG19_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG19_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG19_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG19_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG19_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG19_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG19_reserved1; // reserved
} GPIO_CFG19_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG19_BIT_T bf;
} GPIO_CFG19_T;

// ---------------------------------------------------------------------
// Register gpio_cfg20
// =>  GPIO pin 20 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG20 0x00000050U
#define NETX_GPIO_CFG20     0x1C000850U

#define MSK_NETX_GPIO_CFG20_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG20_mode      0
#define MSK_NETX_GPIO_CFG20_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG20_inv       4
#define MSK_NETX_GPIO_CFG20_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG20_count_ref 5

enum {
	BFW_NETX_GPIO_CFG20_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG20_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG20_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG20_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG20_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG20_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG20_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG20_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG20_reserved1; // reserved
} GPIO_CFG20_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG20_BIT_T bf;
} GPIO_CFG20_T;

// ---------------------------------------------------------------------
// Register gpio_cfg21
// =>  GPIO pin 21 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG21 0x00000054U
#define NETX_GPIO_CFG21     0x1C000854U

#define MSK_NETX_GPIO_CFG21_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG21_mode      0
#define MSK_NETX_GPIO_CFG21_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG21_inv       4
#define MSK_NETX_GPIO_CFG21_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG21_count_ref 5

enum {
	BFW_NETX_GPIO_CFG21_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG21_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG21_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG21_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG21_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG21_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG21_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG21_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG21_reserved1; // reserved
} GPIO_CFG21_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG21_BIT_T bf;
} GPIO_CFG21_T;

// ---------------------------------------------------------------------
// Register gpio_cfg22
// =>  GPIO pin 22 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG22 0x00000058U
#define NETX_GPIO_CFG22     0x1C000858U

#define MSK_NETX_GPIO_CFG22_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG22_mode      0
#define MSK_NETX_GPIO_CFG22_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG22_inv       4
#define MSK_NETX_GPIO_CFG22_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG22_count_ref 5

enum {
	BFW_NETX_GPIO_CFG22_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG22_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG22_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG22_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG22_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG22_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG22_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG22_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG22_reserved1; // reserved
} GPIO_CFG22_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG22_BIT_T bf;
} GPIO_CFG22_T;

// ---------------------------------------------------------------------
// Register gpio_cfg23
// =>  GPIO pin 23 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG23 0x0000005CU
#define NETX_GPIO_CFG23     0x1C00085CU

#define MSK_NETX_GPIO_CFG23_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG23_mode      0
#define MSK_NETX_GPIO_CFG23_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG23_inv       4
#define MSK_NETX_GPIO_CFG23_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG23_count_ref 5

enum {
	BFW_NETX_GPIO_CFG23_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG23_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG23_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG23_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG23_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG23_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG23_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG23_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG23_reserved1; // reserved
} GPIO_CFG23_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG23_BIT_T bf;
} GPIO_CFG23_T;

// ---------------------------------------------------------------------
// Register gpio_cfg24
// =>  GPIO pin 24 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG24 0x00000060U
#define NETX_GPIO_CFG24     0x1C000860U

#define MSK_NETX_GPIO_CFG24_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG24_mode      0
#define MSK_NETX_GPIO_CFG24_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG24_inv       4
#define MSK_NETX_GPIO_CFG24_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG24_count_ref 5

enum {
	BFW_NETX_GPIO_CFG24_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG24_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG24_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG24_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG24_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG24_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG24_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG24_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG24_reserved1; // reserved
} GPIO_CFG24_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG24_BIT_T bf;
} GPIO_CFG24_T;

// ---------------------------------------------------------------------
// Register gpio_cfg25
// =>  GPIO pin 25 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG25 0x00000064U
#define NETX_GPIO_CFG25     0x1C000864U

#define MSK_NETX_GPIO_CFG25_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG25_mode      0
#define MSK_NETX_GPIO_CFG25_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG25_inv       4
#define MSK_NETX_GPIO_CFG25_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG25_count_ref 5

enum {
	BFW_NETX_GPIO_CFG25_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG25_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG25_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG25_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG25_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG25_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG25_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG25_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG25_reserved1; // reserved
} GPIO_CFG25_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG25_BIT_T bf;
} GPIO_CFG25_T;

// ---------------------------------------------------------------------
// Register gpio_cfg26
// =>  GPIO pin 26 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG26 0x00000068U
#define NETX_GPIO_CFG26     0x1C000868U

#define MSK_NETX_GPIO_CFG26_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG26_mode      0
#define MSK_NETX_GPIO_CFG26_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG26_inv       4
#define MSK_NETX_GPIO_CFG26_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG26_count_ref 5

enum {
	BFW_NETX_GPIO_CFG26_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG26_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG26_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG26_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG26_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG26_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG26_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG26_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG26_reserved1; // reserved
} GPIO_CFG26_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG26_BIT_T bf;
} GPIO_CFG26_T;

// ---------------------------------------------------------------------
// Register gpio_cfg27
// =>  GPIO pin 27 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG27 0x0000006CU
#define NETX_GPIO_CFG27     0x1C00086CU

#define MSK_NETX_GPIO_CFG27_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG27_mode      0
#define MSK_NETX_GPIO_CFG27_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG27_inv       4
#define MSK_NETX_GPIO_CFG27_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG27_count_ref 5

enum {
	BFW_NETX_GPIO_CFG27_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG27_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG27_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG27_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG27_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG27_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG27_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG27_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG27_reserved1; // reserved
} GPIO_CFG27_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG27_BIT_T bf;
} GPIO_CFG27_T;

// ---------------------------------------------------------------------
// Register gpio_cfg28
// =>  GPIO pin 28 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG28 0x00000070U
#define NETX_GPIO_CFG28     0x1C000870U

#define MSK_NETX_GPIO_CFG28_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG28_mode      0
#define MSK_NETX_GPIO_CFG28_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG28_inv       4
#define MSK_NETX_GPIO_CFG28_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG28_count_ref 5

enum {
	BFW_NETX_GPIO_CFG28_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG28_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG28_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG28_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG28_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG28_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG28_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG28_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG28_reserved1; // reserved
} GPIO_CFG28_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG28_BIT_T bf;
} GPIO_CFG28_T;

// ---------------------------------------------------------------------
// Register gpio_cfg29
// =>  GPIO pin 29 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG29 0x00000074U
#define NETX_GPIO_CFG29     0x1C000874U

#define MSK_NETX_GPIO_CFG29_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG29_mode      0
#define MSK_NETX_GPIO_CFG29_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG29_inv       4
#define MSK_NETX_GPIO_CFG29_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG29_count_ref 5

enum {
	BFW_NETX_GPIO_CFG29_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG29_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG29_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG29_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG29_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG29_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG29_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG29_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG29_reserved1; // reserved
} GPIO_CFG29_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG29_BIT_T bf;
} GPIO_CFG29_T;

// ---------------------------------------------------------------------
// Register gpio_cfg30
// =>  GPIO pin 30 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG30 0x00000078U
#define NETX_GPIO_CFG30     0x1C000878U

#define MSK_NETX_GPIO_CFG30_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG30_mode      0
#define MSK_NETX_GPIO_CFG30_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG30_inv       4
#define MSK_NETX_GPIO_CFG30_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG30_count_ref 5

enum {
	BFW_NETX_GPIO_CFG30_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG30_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG30_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG30_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG30_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG30_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG30_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG30_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG30_reserved1; // reserved
} GPIO_CFG30_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG30_BIT_T bf;
} GPIO_CFG30_T;

// ---------------------------------------------------------------------
// Register gpio_cfg31
// =>  GPIO pin 31 config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CFG31 0x0000007CU
#define NETX_GPIO_CFG31     0x1C00087CU

#define MSK_NETX_GPIO_CFG31_mode      0x0000000fU // [3:0]
#define SRT_NETX_GPIO_CFG31_mode      0
#define MSK_NETX_GPIO_CFG31_inv       0x00000010U // [4]
#define SRT_NETX_GPIO_CFG31_inv       4
#define MSK_NETX_GPIO_CFG31_count_ref 0x000000e0U // [7:5]
#define SRT_NETX_GPIO_CFG31_count_ref 5

enum {
	BFW_NETX_GPIO_CFG31_mode      = 4,  // [3:0]
	BFW_NETX_GPIO_CFG31_inv       = 1,  // [4]
	BFW_NETX_GPIO_CFG31_count_ref = 3,  // [7:5]
	BFW_NETX_GPIO_CFG31_reserved1 = 24  // [31:8]
};

typedef struct GPIO_CFG31_BIT_Ttag {
	unsigned int mode      : BFW_NETX_GPIO_CFG31_mode;      // analog to gpio_cfg0
	unsigned int inv       : BFW_NETX_GPIO_CFG31_inv;       // analog to gpio_cfg0
	unsigned int count_ref : BFW_NETX_GPIO_CFG31_count_ref; // analog to gpio_cfg0
	unsigned int reserved1 : BFW_NETX_GPIO_CFG31_reserved1; // reserved
} GPIO_CFG31_BIT_T;

typedef union {
	unsigned int     val;
	GPIO_CFG31_BIT_T bf;
} GPIO_CFG31_T;

// ---------------------------------------------------------------------
// Register gpio_tc0
// =>  GPIO pin 0 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT0 0x00000080U
#define NETX_GPIO_THRSH_CAPT0     0x1C000880U

#define MSK_NETX_GPIO_THRSH_CAPT0_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT0_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT0_val = 32  // [31:0]
};

typedef struct GPIO_TC0_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT0_val; // Treshold/Capture register:
	                                                        // PWM mode (treshold):
	                                                        //   The counter threshold value equals the number of inactive clockcylces per period (cycles with pwm=0).
	                                                        //   Therefore it is interpreted different in symmetrical and asymmetrical counter mode:
	                                                        //   Asymmetrical mode (sawtooth): pwm = (counter >= gpio_tc)
	                                                        //   Symmetrical mode (triangle) : counter is compared with gpio_tc[31:1], gpio_tc[0] prolonges the inactive phase
	                                                        //     by 1 cc only while upcounting. This allows running 10ns resolution even in symmetrical mode.
	                                                        // Capture mode (capture register)
	                                                        //   In capture mode this register holds the captured counter value.
} GPIO_TC0_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC0_BIT_T bf;
} GPIO_TC0_T;

// ---------------------------------------------------------------------
// Register gpio_tc1
// =>  GPIO pin 1 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT1 0x00000084U
#define NETX_GPIO_THRSH_CAPT1     0x1C000884U

#define MSK_NETX_GPIO_THRSH_CAPT1_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT1_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT1_val = 32  // [31:0]
};

typedef struct GPIO_TC1_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT1_val; // analog to gpio_tc0
} GPIO_TC1_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC1_BIT_T bf;
} GPIO_TC1_T;

// ---------------------------------------------------------------------
// Register gpio_tc2
// =>  GPIO pin 2 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT2 0x00000088U
#define NETX_GPIO_THRSH_CAPT2     0x1C000888U

#define MSK_NETX_GPIO_THRSH_CAPT2_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT2_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT2_val = 32  // [31:0]
};

typedef struct GPIO_TC2_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT2_val; // analog to gpio_tc0
} GPIO_TC2_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC2_BIT_T bf;
} GPIO_TC2_T;

// ---------------------------------------------------------------------
// Register gpio_tc3
// =>  GPIO pin 3 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT3 0x0000008CU
#define NETX_GPIO_THRSH_CAPT3     0x1C00088CU

#define MSK_NETX_GPIO_THRSH_CAPT3_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT3_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT3_val = 32  // [31:0]
};

typedef struct GPIO_TC3_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT3_val; // analog to gpio_tc0
} GPIO_TC3_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC3_BIT_T bf;
} GPIO_TC3_T;

// ---------------------------------------------------------------------
// Register gpio_tc4
// =>  GPIO pin 4 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT4 0x00000090U
#define NETX_GPIO_THRSH_CAPT4     0x1C000890U

#define MSK_NETX_GPIO_THRSH_CAPT4_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT4_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT4_val = 32  // [31:0]
};

typedef struct GPIO_TC4_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT4_val; // analog to gpio_tc0
} GPIO_TC4_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC4_BIT_T bf;
} GPIO_TC4_T;

// ---------------------------------------------------------------------
// Register gpio_tc5
// =>  GPIO pin 5 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT5 0x00000094U
#define NETX_GPIO_THRSH_CAPT5     0x1C000894U

#define MSK_NETX_GPIO_THRSH_CAPT5_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT5_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT5_val = 32  // [31:0]
};

typedef struct GPIO_TC5_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT5_val; // analog to gpio_tc0
} GPIO_TC5_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC5_BIT_T bf;
} GPIO_TC5_T;

// ---------------------------------------------------------------------
// Register gpio_tc6
// =>  GPIO pin 6 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT6 0x00000098U
#define NETX_GPIO_THRSH_CAPT6     0x1C000898U

#define MSK_NETX_GPIO_THRSH_CAPT6_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT6_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT6_val = 32  // [31:0]
};

typedef struct GPIO_TC6_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT6_val; // analog to gpio_tc0
} GPIO_TC6_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC6_BIT_T bf;
} GPIO_TC6_T;

// ---------------------------------------------------------------------
// Register gpio_tc7
// =>  GPIO pin 7 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT7 0x0000009CU
#define NETX_GPIO_THRSH_CAPT7     0x1C00089CU

#define MSK_NETX_GPIO_THRSH_CAPT7_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT7_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT7_val = 32  // [31:0]
};

typedef struct GPIO_TC7_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT7_val; // analog to gpio_tc0
} GPIO_TC7_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC7_BIT_T bf;
} GPIO_TC7_T;

// ---------------------------------------------------------------------
// Register gpio_tc8
// =>  GPIO pin 8 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT8 0x000000A0U
#define NETX_GPIO_THRSH_CAPT8     0x1C0008A0U

#define MSK_NETX_GPIO_THRSH_CAPT8_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT8_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT8_val = 32  // [31:0]
};

typedef struct GPIO_TC8_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT8_val; // analog to gpio_tc0
} GPIO_TC8_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC8_BIT_T bf;
} GPIO_TC8_T;

// ---------------------------------------------------------------------
// Register gpio_tc9
// =>  GPIO pin 9 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT9 0x000000A4U
#define NETX_GPIO_THRSH_CAPT9     0x1C0008A4U

#define MSK_NETX_GPIO_THRSH_CAPT9_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT9_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT9_val = 32  // [31:0]
};

typedef struct GPIO_TC9_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT9_val; // analog to gpio_tc0
} GPIO_TC9_BIT_T;

typedef union {
	unsigned int   val;
	GPIO_TC9_BIT_T bf;
} GPIO_TC9_T;

// ---------------------------------------------------------------------
// Register gpio_tc10
// =>  GPIO pin 10 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT10 0x000000A8U
#define NETX_GPIO_THRSH_CAPT10     0x1C0008A8U

#define MSK_NETX_GPIO_THRSH_CAPT10_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT10_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT10_val = 32  // [31:0]
};

typedef struct GPIO_TC10_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT10_val; // analog to gpio_tc0
} GPIO_TC10_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC10_BIT_T bf;
} GPIO_TC10_T;

// ---------------------------------------------------------------------
// Register gpio_tc11
// =>  GPIO pin 11 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT11 0x000000ACU
#define NETX_GPIO_THRSH_CAPT11     0x1C0008ACU

#define MSK_NETX_GPIO_THRSH_CAPT11_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT11_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT11_val = 32  // [31:0]
};

typedef struct GPIO_TC11_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT11_val; // analog to gpio_tc0
} GPIO_TC11_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC11_BIT_T bf;
} GPIO_TC11_T;

// ---------------------------------------------------------------------
// Register gpio_tc12
// =>  GPIO pin 12 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT12 0x000000B0U
#define NETX_GPIO_THRSH_CAPT12     0x1C0008B0U

#define MSK_NETX_GPIO_THRSH_CAPT12_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT12_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT12_val = 32  // [31:0]
};

typedef struct GPIO_TC12_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT12_val; // analog to gpio_tc0
} GPIO_TC12_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC12_BIT_T bf;
} GPIO_TC12_T;

// ---------------------------------------------------------------------
// Register gpio_tc13
// =>  GPIO pin 13 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT13 0x000000B4U
#define NETX_GPIO_THRSH_CAPT13     0x1C0008B4U

#define MSK_NETX_GPIO_THRSH_CAPT13_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT13_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT13_val = 32  // [31:0]
};

typedef struct GPIO_TC13_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT13_val; // analog to gpio_tc0
} GPIO_TC13_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC13_BIT_T bf;
} GPIO_TC13_T;

// ---------------------------------------------------------------------
// Register gpio_tc14
// =>  GPIO pin 14 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT14 0x000000B8U
#define NETX_GPIO_THRSH_CAPT14     0x1C0008B8U

#define MSK_NETX_GPIO_THRSH_CAPT14_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT14_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT14_val = 32  // [31:0]
};

typedef struct GPIO_TC14_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT14_val; // analog to gpio_tc0
} GPIO_TC14_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC14_BIT_T bf;
} GPIO_TC14_T;

// ---------------------------------------------------------------------
// Register gpio_tc15
// =>  GPIO pin 15 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT15 0x000000BCU
#define NETX_GPIO_THRSH_CAPT15     0x1C0008BCU

#define MSK_NETX_GPIO_THRSH_CAPT15_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT15_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT15_val = 32  // [31:0]
};

typedef struct GPIO_TC15_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT15_val; // analog to gpio_tc0
} GPIO_TC15_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC15_BIT_T bf;
} GPIO_TC15_T;

// ---------------------------------------------------------------------
// Register gpio_tc16
// =>  GPIO pin 16 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT16 0x000000C0U
#define NETX_GPIO_THRSH_CAPT16     0x1C0008C0U

#define MSK_NETX_GPIO_THRSH_CAPT16_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT16_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT16_val = 32  // [31:0]
};

typedef struct GPIO_TC16_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT16_val; // analog to gpio_tc0
} GPIO_TC16_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC16_BIT_T bf;
} GPIO_TC16_T;

// ---------------------------------------------------------------------
// Register gpio_tc17
// =>  GPIO pin 17 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT17 0x000000C4U
#define NETX_GPIO_THRSH_CAPT17     0x1C0008C4U

#define MSK_NETX_GPIO_THRSH_CAPT17_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT17_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT17_val = 32  // [31:0]
};

typedef struct GPIO_TC17_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT17_val; // analog to gpio_tc0
} GPIO_TC17_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC17_BIT_T bf;
} GPIO_TC17_T;

// ---------------------------------------------------------------------
// Register gpio_tc18
// =>  GPIO pin 18 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT18 0x000000C8U
#define NETX_GPIO_THRSH_CAPT18     0x1C0008C8U

#define MSK_NETX_GPIO_THRSH_CAPT18_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT18_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT18_val = 32  // [31:0]
};

typedef struct GPIO_TC18_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT18_val; // analog to gpio_tc0
} GPIO_TC18_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC18_BIT_T bf;
} GPIO_TC18_T;

// ---------------------------------------------------------------------
// Register gpio_tc19
// =>  GPIO pin 19 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT19 0x000000CCU
#define NETX_GPIO_THRSH_CAPT19     0x1C0008CCU

#define MSK_NETX_GPIO_THRSH_CAPT19_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT19_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT19_val = 32  // [31:0]
};

typedef struct GPIO_TC19_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT19_val; // analog to gpio_tc0
} GPIO_TC19_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC19_BIT_T bf;
} GPIO_TC19_T;

// ---------------------------------------------------------------------
// Register gpio_tc20
// =>  GPIO pin 20 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT20 0x000000D0U
#define NETX_GPIO_THRSH_CAPT20     0x1C0008D0U

#define MSK_NETX_GPIO_THRSH_CAPT20_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT20_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT20_val = 32  // [31:0]
};

typedef struct GPIO_TC20_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT20_val; // analog to gpio_tc0
} GPIO_TC20_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC20_BIT_T bf;
} GPIO_TC20_T;

// ---------------------------------------------------------------------
// Register gpio_tc21
// =>  GPIO pin 21 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT21 0x000000D4U
#define NETX_GPIO_THRSH_CAPT21     0x1C0008D4U

#define MSK_NETX_GPIO_THRSH_CAPT21_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT21_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT21_val = 32  // [31:0]
};

typedef struct GPIO_TC21_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT21_val; // analog to gpio_tc0
} GPIO_TC21_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC21_BIT_T bf;
} GPIO_TC21_T;

// ---------------------------------------------------------------------
// Register gpio_tc22
// =>  GPIO pin 22 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT22 0x000000D8U
#define NETX_GPIO_THRSH_CAPT22     0x1C0008D8U

#define MSK_NETX_GPIO_THRSH_CAPT22_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT22_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT22_val = 32  // [31:0]
};

typedef struct GPIO_TC22_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT22_val; // analog to gpio_tc0
} GPIO_TC22_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC22_BIT_T bf;
} GPIO_TC22_T;

// ---------------------------------------------------------------------
// Register gpio_tc23
// =>  GPIO pin 23 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT23 0x000000DCU
#define NETX_GPIO_THRSH_CAPT23     0x1C0008DCU

#define MSK_NETX_GPIO_THRSH_CAPT23_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT23_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT23_val = 32  // [31:0]
};

typedef struct GPIO_TC23_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT23_val; // analog to gpio_tc0
} GPIO_TC23_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC23_BIT_T bf;
} GPIO_TC23_T;

// ---------------------------------------------------------------------
// Register gpio_tc24
// =>  GPIO pin 24 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT24 0x000000E0U
#define NETX_GPIO_THRSH_CAPT24     0x1C0008E0U

#define MSK_NETX_GPIO_THRSH_CAPT24_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT24_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT24_val = 32  // [31:0]
};

typedef struct GPIO_TC24_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT24_val; // analog to gpio_tc0
} GPIO_TC24_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC24_BIT_T bf;
} GPIO_TC24_T;

// ---------------------------------------------------------------------
// Register gpio_tc25
// =>  GPIO pin 25 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT25 0x000000E4U
#define NETX_GPIO_THRSH_CAPT25     0x1C0008E4U

#define MSK_NETX_GPIO_THRSH_CAPT25_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT25_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT25_val = 32  // [31:0]
};

typedef struct GPIO_TC25_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT25_val; // analog to gpio_tc0
} GPIO_TC25_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC25_BIT_T bf;
} GPIO_TC25_T;

// ---------------------------------------------------------------------
// Register gpio_tc26
// =>  GPIO pin 26 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT26 0x000000E8U
#define NETX_GPIO_THRSH_CAPT26     0x1C0008E8U

#define MSK_NETX_GPIO_THRSH_CAPT26_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT26_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT26_val = 32  // [31:0]
};

typedef struct GPIO_TC26_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT26_val; // analog to gpio_tc0
} GPIO_TC26_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC26_BIT_T bf;
} GPIO_TC26_T;

// ---------------------------------------------------------------------
// Register gpio_tc27
// =>  GPIO pin 27 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT27 0x000000ECU
#define NETX_GPIO_THRSH_CAPT27     0x1C0008ECU

#define MSK_NETX_GPIO_THRSH_CAPT27_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT27_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT27_val = 32  // [31:0]
};

typedef struct GPIO_TC27_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT27_val; // analog to gpio_tc0
} GPIO_TC27_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC27_BIT_T bf;
} GPIO_TC27_T;

// ---------------------------------------------------------------------
// Register gpio_tc28
// =>  GPIO pin 28 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT28 0x000000F0U
#define NETX_GPIO_THRSH_CAPT28     0x1C0008F0U

#define MSK_NETX_GPIO_THRSH_CAPT28_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT28_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT28_val = 32  // [31:0]
};

typedef struct GPIO_TC28_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT28_val; // analog to gpio_tc0
} GPIO_TC28_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC28_BIT_T bf;
} GPIO_TC28_T;

// ---------------------------------------------------------------------
// Register gpio_tc29
// =>  GPIO pin 29 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT29 0x000000F4U
#define NETX_GPIO_THRSH_CAPT29     0x1C0008F4U

#define MSK_NETX_GPIO_THRSH_CAPT29_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT29_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT29_val = 32  // [31:0]
};

typedef struct GPIO_TC29_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT29_val; // analog to gpio_tc0
} GPIO_TC29_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC29_BIT_T bf;
} GPIO_TC29_T;

// ---------------------------------------------------------------------
// Register gpio_tc30
// =>  GPIO pin 30 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT30 0x000000F8U
#define NETX_GPIO_THRSH_CAPT30     0x1C0008F8U

#define MSK_NETX_GPIO_THRSH_CAPT30_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT30_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT30_val = 32  // [31:0]
};

typedef struct GPIO_TC30_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT30_val; // analog to gpio_tc0
} GPIO_TC30_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC30_BIT_T bf;
} GPIO_TC30_T;

// ---------------------------------------------------------------------
// Register gpio_tc31
// =>  GPIO pin 31 threshold or capture register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_THRSH_CAPT31 0x000000FCU
#define NETX_GPIO_THRSH_CAPT31     0x1C0008FCU

#define MSK_NETX_GPIO_THRSH_CAPT31_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_THRSH_CAPT31_val 0

enum {
	BFW_NETX_GPIO_THRSH_CAPT31_val = 32  // [31:0]
};

typedef struct GPIO_TC31_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_THRSH_CAPT31_val; // analog to gpio_tc0
} GPIO_TC31_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_TC31_BIT_T bf;
} GPIO_TC31_T;

// ---------------------------------------------------------------------
// Register gpio_counter0_ctrl
// =>  GPIO counter0 control register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR0_CTRL 0x00000100U
#define NETX_GPIO_CNTR0_CTRL     0x1C000900U

#define MSK_NETX_GPIO_CNTR0_CTRL_run       0x00000001U // [0]
#define SRT_NETX_GPIO_CNTR0_CTRL_run       0
#define MSK_NETX_GPIO_CNTR0_CTRL_sym_nasym 0x00000002U // [1]
#define SRT_NETX_GPIO_CNTR0_CTRL_sym_nasym 1
#define MSK_NETX_GPIO_CNTR0_CTRL_irq_en    0x00000004U // [2]
#define SRT_NETX_GPIO_CNTR0_CTRL_irq_en    2
#define MSK_NETX_GPIO_CNTR0_CTRL_sel_event 0x00000008U // [3]
#define SRT_NETX_GPIO_CNTR0_CTRL_sel_event 3
#define MSK_NETX_GPIO_CNTR0_CTRL_once      0x00000010U // [4]
#define SRT_NETX_GPIO_CNTR0_CTRL_once      4
#define MSK_NETX_GPIO_CNTR0_CTRL_event_act 0x00000060U // [6:5]
#define SRT_NETX_GPIO_CNTR0_CTRL_event_act 5
#define MSK_NETX_GPIO_CNTR0_CTRL_gpio_ref  0x00000f80U // [11:7]
#define SRT_NETX_GPIO_CNTR0_CTRL_gpio_ref  7

enum {
	BFW_NETX_GPIO_CNTR0_CTRL_run       = 1,  // [0]
	BFW_NETX_GPIO_CNTR0_CTRL_sym_nasym = 1,  // [1]
	BFW_NETX_GPIO_CNTR0_CTRL_irq_en    = 1,  // [2]
	BFW_NETX_GPIO_CNTR0_CTRL_sel_event = 1,  // [3]
	BFW_NETX_GPIO_CNTR0_CTRL_once      = 1,  // [4]
	BFW_NETX_GPIO_CNTR0_CTRL_event_act = 2,  // [6:5]
	BFW_NETX_GPIO_CNTR0_CTRL_gpio_ref  = 5,  // [11:7]
	BFW_NETX_GPIO_CNTR0_CTRL_reserved1 = 20  // [31:12]
};

typedef struct GPIO_COUNTER0_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NETX_GPIO_CNTR0_CTRL_run;       // 1: start counter, counter is running
	                                                        // 0: stop counter
	unsigned int sym_nasym : BFW_NETX_GPIO_CNTR0_CTRL_sym_nasym; // 1: symmetric mode (triangle)
	                                                        // 0: asymmetric mode (sawtooth)
	unsigned int irq_en    : BFW_NETX_GPIO_CNTR0_CTRL_irq_en;    // 1: enable interrupt request on sel_event
	                                                        // 0: disable interrupt request
	unsigned int sel_event : BFW_NETX_GPIO_CNTR0_CTRL_sel_event; // select external event
	                                                        // 0: high level, invert gpio in gpio_cfg register to select low level
	                                                        // 1: pos. edge, invert gpio in gpio_cfg register to select neg. edge
	unsigned int once      : BFW_NETX_GPIO_CNTR0_CTRL_once;      // 1: count once (reset run bit after 1 period)
	                                                        // 0: count continue
	unsigned int event_act : BFW_NETX_GPIO_CNTR0_CTRL_event_act; // Define action of selected external event (dependant on sel_event, gpio_ref)
	                                                        // 00: count every clock cycle, ignore external events
	                                                        // 01: count only on external event (edge or level according to sel_event bit)
	                                                        // 10: enable watchdog mode of counter (external event resets without IRQ, overflow generates IRQ).
	                                                        // 11: enable automatic run by external event (set run bit at external event, used for DC-DC PWM in once mode)
	unsigned int gpio_ref  : BFW_NETX_GPIO_CNTR0_CTRL_gpio_ref;  // gpio reference (0 - 31)
	unsigned int reserved1 : BFW_NETX_GPIO_CNTR0_CTRL_reserved1; // reserved
} GPIO_COUNTER0_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	GPIO_COUNTER0_CTRL_BIT_T bf;
} GPIO_COUNTER0_CTRL_T;

// ---------------------------------------------------------------------
// Register gpio_counter1_ctrl
// =>  GPIO counter1 control register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR1_CTRL 0x00000104U
#define NETX_GPIO_CNTR1_CTRL     0x1C000904U

#define MSK_NETX_GPIO_CNTR1_CTRL_run       0x00000001U // [0]
#define SRT_NETX_GPIO_CNTR1_CTRL_run       0
#define MSK_NETX_GPIO_CNTR1_CTRL_sym_nasym 0x00000002U // [1]
#define SRT_NETX_GPIO_CNTR1_CTRL_sym_nasym 1
#define MSK_NETX_GPIO_CNTR1_CTRL_irq_en    0x00000004U // [2]
#define SRT_NETX_GPIO_CNTR1_CTRL_irq_en    2
#define MSK_NETX_GPIO_CNTR1_CTRL_sel_event 0x00000008U // [3]
#define SRT_NETX_GPIO_CNTR1_CTRL_sel_event 3
#define MSK_NETX_GPIO_CNTR1_CTRL_once      0x00000010U // [4]
#define SRT_NETX_GPIO_CNTR1_CTRL_once      4
#define MSK_NETX_GPIO_CNTR1_CTRL_event_act 0x00000060U // [6:5]
#define SRT_NETX_GPIO_CNTR1_CTRL_event_act 5
#define MSK_NETX_GPIO_CNTR1_CTRL_gpio_ref  0x00000f80U // [11:7]
#define SRT_NETX_GPIO_CNTR1_CTRL_gpio_ref  7

enum {
	BFW_NETX_GPIO_CNTR1_CTRL_run       = 1,  // [0]
	BFW_NETX_GPIO_CNTR1_CTRL_sym_nasym = 1,  // [1]
	BFW_NETX_GPIO_CNTR1_CTRL_irq_en    = 1,  // [2]
	BFW_NETX_GPIO_CNTR1_CTRL_sel_event = 1,  // [3]
	BFW_NETX_GPIO_CNTR1_CTRL_once      = 1,  // [4]
	BFW_NETX_GPIO_CNTR1_CTRL_event_act = 2,  // [6:5]
	BFW_NETX_GPIO_CNTR1_CTRL_gpio_ref  = 5,  // [11:7]
	BFW_NETX_GPIO_CNTR1_CTRL_reserved1 = 20  // [31:12]
};

typedef struct GPIO_COUNTER1_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NETX_GPIO_CNTR1_CTRL_run;       // analog to gpio_counter0_ctrl
	unsigned int sym_nasym : BFW_NETX_GPIO_CNTR1_CTRL_sym_nasym; // analog to gpio_counter0_ctrl
	unsigned int irq_en    : BFW_NETX_GPIO_CNTR1_CTRL_irq_en;    // analog to gpio_counter0_ctrl
	unsigned int sel_event : BFW_NETX_GPIO_CNTR1_CTRL_sel_event; // analog to gpio_counter0_ctrl
	unsigned int once      : BFW_NETX_GPIO_CNTR1_CTRL_once;      // analog to gpio_counter0_ctrl
	unsigned int event_act : BFW_NETX_GPIO_CNTR1_CTRL_event_act; // analog to gpio_counter0_ctrl
	unsigned int gpio_ref  : BFW_NETX_GPIO_CNTR1_CTRL_gpio_ref;  // analog to gpio_counter0_ctrl
	unsigned int reserved1 : BFW_NETX_GPIO_CNTR1_CTRL_reserved1; // reserved
} GPIO_COUNTER1_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	GPIO_COUNTER1_CTRL_BIT_T bf;
} GPIO_COUNTER1_CTRL_T;

// ---------------------------------------------------------------------
// Register gpio_counter2_ctrl
// =>  GPIO counter2 control register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR2_CTRL 0x00000108U
#define NETX_GPIO_CNTR2_CTRL     0x1C000908U

#define MSK_NETX_GPIO_CNTR2_CTRL_run       0x00000001U // [0]
#define SRT_NETX_GPIO_CNTR2_CTRL_run       0
#define MSK_NETX_GPIO_CNTR2_CTRL_sym_nasym 0x00000002U // [1]
#define SRT_NETX_GPIO_CNTR2_CTRL_sym_nasym 1
#define MSK_NETX_GPIO_CNTR2_CTRL_irq_en    0x00000004U // [2]
#define SRT_NETX_GPIO_CNTR2_CTRL_irq_en    2
#define MSK_NETX_GPIO_CNTR2_CTRL_sel_event 0x00000008U // [3]
#define SRT_NETX_GPIO_CNTR2_CTRL_sel_event 3
#define MSK_NETX_GPIO_CNTR2_CTRL_once      0x00000010U // [4]
#define SRT_NETX_GPIO_CNTR2_CTRL_once      4
#define MSK_NETX_GPIO_CNTR2_CTRL_event_act 0x00000060U // [6:5]
#define SRT_NETX_GPIO_CNTR2_CTRL_event_act 5
#define MSK_NETX_GPIO_CNTR2_CTRL_gpio_ref  0x00000f80U // [11:7]
#define SRT_NETX_GPIO_CNTR2_CTRL_gpio_ref  7

enum {
	BFW_NETX_GPIO_CNTR2_CTRL_run       = 1,  // [0]
	BFW_NETX_GPIO_CNTR2_CTRL_sym_nasym = 1,  // [1]
	BFW_NETX_GPIO_CNTR2_CTRL_irq_en    = 1,  // [2]
	BFW_NETX_GPIO_CNTR2_CTRL_sel_event = 1,  // [3]
	BFW_NETX_GPIO_CNTR2_CTRL_once      = 1,  // [4]
	BFW_NETX_GPIO_CNTR2_CTRL_event_act = 2,  // [6:5]
	BFW_NETX_GPIO_CNTR2_CTRL_gpio_ref  = 5,  // [11:7]
	BFW_NETX_GPIO_CNTR2_CTRL_reserved1 = 20  // [31:12]
};

typedef struct GPIO_COUNTER2_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NETX_GPIO_CNTR2_CTRL_run;       // analog to gpio_counter0_ctrl
	unsigned int sym_nasym : BFW_NETX_GPIO_CNTR2_CTRL_sym_nasym; // analog to gpio_counter0_ctrl
	unsigned int irq_en    : BFW_NETX_GPIO_CNTR2_CTRL_irq_en;    // analog to gpio_counter0_ctrl
	unsigned int sel_event : BFW_NETX_GPIO_CNTR2_CTRL_sel_event; // analog to gpio_counter0_ctrl
	unsigned int once      : BFW_NETX_GPIO_CNTR2_CTRL_once;      // analog to gpio_counter0_ctrl
	unsigned int event_act : BFW_NETX_GPIO_CNTR2_CTRL_event_act; // analog to gpio_counter0_ctrl
	unsigned int gpio_ref  : BFW_NETX_GPIO_CNTR2_CTRL_gpio_ref;  // analog to gpio_counter0_ctrl
	unsigned int reserved1 : BFW_NETX_GPIO_CNTR2_CTRL_reserved1; // reserved
} GPIO_COUNTER2_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	GPIO_COUNTER2_CTRL_BIT_T bf;
} GPIO_COUNTER2_CTRL_T;

// ---------------------------------------------------------------------
// Register gpio_counter3_ctrl
// =>  GPIO counter3 control register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR3_CTRL 0x0000010CU
#define NETX_GPIO_CNTR3_CTRL     0x1C00090CU

#define MSK_NETX_GPIO_CNTR3_CTRL_run       0x00000001U // [0]
#define SRT_NETX_GPIO_CNTR3_CTRL_run       0
#define MSK_NETX_GPIO_CNTR3_CTRL_sym_nasym 0x00000002U // [1]
#define SRT_NETX_GPIO_CNTR3_CTRL_sym_nasym 1
#define MSK_NETX_GPIO_CNTR3_CTRL_irq_en    0x00000004U // [2]
#define SRT_NETX_GPIO_CNTR3_CTRL_irq_en    2
#define MSK_NETX_GPIO_CNTR3_CTRL_sel_event 0x00000008U // [3]
#define SRT_NETX_GPIO_CNTR3_CTRL_sel_event 3
#define MSK_NETX_GPIO_CNTR3_CTRL_once      0x00000010U // [4]
#define SRT_NETX_GPIO_CNTR3_CTRL_once      4
#define MSK_NETX_GPIO_CNTR3_CTRL_event_act 0x00000060U // [6:5]
#define SRT_NETX_GPIO_CNTR3_CTRL_event_act 5
#define MSK_NETX_GPIO_CNTR3_CTRL_gpio_ref  0x00000f80U // [11:7]
#define SRT_NETX_GPIO_CNTR3_CTRL_gpio_ref  7

enum {
	BFW_NETX_GPIO_CNTR3_CTRL_run       = 1,  // [0]
	BFW_NETX_GPIO_CNTR3_CTRL_sym_nasym = 1,  // [1]
	BFW_NETX_GPIO_CNTR3_CTRL_irq_en    = 1,  // [2]
	BFW_NETX_GPIO_CNTR3_CTRL_sel_event = 1,  // [3]
	BFW_NETX_GPIO_CNTR3_CTRL_once      = 1,  // [4]
	BFW_NETX_GPIO_CNTR3_CTRL_event_act = 2,  // [6:5]
	BFW_NETX_GPIO_CNTR3_CTRL_gpio_ref  = 5,  // [11:7]
	BFW_NETX_GPIO_CNTR3_CTRL_reserved1 = 20  // [31:12]
};

typedef struct GPIO_COUNTER3_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NETX_GPIO_CNTR3_CTRL_run;       // analog to gpio_counter0_ctrl
	unsigned int sym_nasym : BFW_NETX_GPIO_CNTR3_CTRL_sym_nasym; // analog to gpio_counter0_ctrl
	unsigned int irq_en    : BFW_NETX_GPIO_CNTR3_CTRL_irq_en;    // analog to gpio_counter0_ctrl
	unsigned int sel_event : BFW_NETX_GPIO_CNTR3_CTRL_sel_event; // analog to gpio_counter0_ctrl
	unsigned int once      : BFW_NETX_GPIO_CNTR3_CTRL_once;      // analog to gpio_counter0_ctrl
	unsigned int event_act : BFW_NETX_GPIO_CNTR3_CTRL_event_act; // analog to gpio_counter0_ctrl
	unsigned int gpio_ref  : BFW_NETX_GPIO_CNTR3_CTRL_gpio_ref;  // analog to gpio_counter0_ctrl
	unsigned int reserved1 : BFW_NETX_GPIO_CNTR3_CTRL_reserved1; // reserved
} GPIO_COUNTER3_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	GPIO_COUNTER3_CTRL_BIT_T bf;
} GPIO_COUNTER3_CTRL_T;

// ---------------------------------------------------------------------
// Register gpio_counter4_ctrl
// =>  GPIO counter4 control register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR4_CTRL 0x00000110U
#define NETX_GPIO_CNTR4_CTRL     0x1C000910U

#define MSK_NETX_GPIO_CNTR4_CTRL_run       0x00000001U // [0]
#define SRT_NETX_GPIO_CNTR4_CTRL_run       0
#define MSK_NETX_GPIO_CNTR4_CTRL_sym_nasym 0x00000002U // [1]
#define SRT_NETX_GPIO_CNTR4_CTRL_sym_nasym 1
#define MSK_NETX_GPIO_CNTR4_CTRL_irq_en    0x00000004U // [2]
#define SRT_NETX_GPIO_CNTR4_CTRL_irq_en    2
#define MSK_NETX_GPIO_CNTR4_CTRL_sel_event 0x00000008U // [3]
#define SRT_NETX_GPIO_CNTR4_CTRL_sel_event 3
#define MSK_NETX_GPIO_CNTR4_CTRL_once      0x00000010U // [4]
#define SRT_NETX_GPIO_CNTR4_CTRL_once      4
#define MSK_NETX_GPIO_CNTR4_CTRL_event_act 0x00000060U // [6:5]
#define SRT_NETX_GPIO_CNTR4_CTRL_event_act 5
#define MSK_NETX_GPIO_CNTR4_CTRL_gpio_ref  0x00000f80U // [11:7]
#define SRT_NETX_GPIO_CNTR4_CTRL_gpio_ref  7

enum {
	BFW_NETX_GPIO_CNTR4_CTRL_run       = 1,  // [0]
	BFW_NETX_GPIO_CNTR4_CTRL_sym_nasym = 1,  // [1]
	BFW_NETX_GPIO_CNTR4_CTRL_irq_en    = 1,  // [2]
	BFW_NETX_GPIO_CNTR4_CTRL_sel_event = 1,  // [3]
	BFW_NETX_GPIO_CNTR4_CTRL_once      = 1,  // [4]
	BFW_NETX_GPIO_CNTR4_CTRL_event_act = 2,  // [6:5]
	BFW_NETX_GPIO_CNTR4_CTRL_gpio_ref  = 5,  // [11:7]
	BFW_NETX_GPIO_CNTR4_CTRL_reserved1 = 20  // [31:12]
};

typedef struct GPIO_COUNTER4_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NETX_GPIO_CNTR4_CTRL_run;       // analog to gpio_counter0_ctrl
	unsigned int sym_nasym : BFW_NETX_GPIO_CNTR4_CTRL_sym_nasym; // analog to gpio_counter0_ctrl
	unsigned int irq_en    : BFW_NETX_GPIO_CNTR4_CTRL_irq_en;    // analog to gpio_counter0_ctrl
	unsigned int sel_event : BFW_NETX_GPIO_CNTR4_CTRL_sel_event; // analog to gpio_counter0_ctrl
	unsigned int once      : BFW_NETX_GPIO_CNTR4_CTRL_once;      // analog to gpio_counter0_ctrl
	unsigned int event_act : BFW_NETX_GPIO_CNTR4_CTRL_event_act; // analog to gpio_counter0_ctrl
	unsigned int gpio_ref  : BFW_NETX_GPIO_CNTR4_CTRL_gpio_ref;  // analog to gpio_counter0_ctrl
	unsigned int reserved1 : BFW_NETX_GPIO_CNTR4_CTRL_reserved1; // reserved
} GPIO_COUNTER4_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	GPIO_COUNTER4_CTRL_BIT_T bf;
} GPIO_COUNTER4_CTRL_T;

// ---------------------------------------------------------------------
// Register gpio_counter0_max
// =>  GPIO counter0 max value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR0_MAX 0x00000114U
#define NETX_GPIO_CNTR0_MAX     0x1C000914U

#define MSK_NETX_GPIO_CNTR0_MAX_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR0_MAX_val 0

enum {
	BFW_NETX_GPIO_CNTR0_MAX_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER0_MAX_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR0_MAX_val; // Asymmetric mode: counting period in cc + 1
	                                                        // Symmetric mode: counting period in cc
} GPIO_COUNTER0_MAX_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER0_MAX_BIT_T bf;
} GPIO_COUNTER0_MAX_T;

// ---------------------------------------------------------------------
// Register gpio_counter1_max
// =>  GPIO counter1 max value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR1_MAX 0x00000118U
#define NETX_GPIO_CNTR1_MAX     0x1C000918U

#define MSK_NETX_GPIO_CNTR1_MAX_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR1_MAX_val 0

enum {
	BFW_NETX_GPIO_CNTR1_MAX_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER1_MAX_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR1_MAX_val; // Asymmetric mode: counting period in cc + 1
	                                                        // Symmetric mode: counting period in cc
} GPIO_COUNTER1_MAX_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER1_MAX_BIT_T bf;
} GPIO_COUNTER1_MAX_T;

// ---------------------------------------------------------------------
// Register gpio_counter2_max
// =>  GPIO counter2 max value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR2_MAX 0x0000011CU
#define NETX_GPIO_CNTR2_MAX     0x1C00091CU

#define MSK_NETX_GPIO_CNTR2_MAX_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR2_MAX_val 0

enum {
	BFW_NETX_GPIO_CNTR2_MAX_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER2_MAX_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR2_MAX_val; // Asymmetric mode: counting period in cc + 1
	                                                        // Symmetric mode: counting period in cc
} GPIO_COUNTER2_MAX_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER2_MAX_BIT_T bf;
} GPIO_COUNTER2_MAX_T;

// ---------------------------------------------------------------------
// Register gpio_counter3_max
// =>  GPIO counter3 max value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR3_MAX 0x00000120U
#define NETX_GPIO_CNTR3_MAX     0x1C000920U

#define MSK_NETX_GPIO_CNTR3_MAX_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR3_MAX_val 0

enum {
	BFW_NETX_GPIO_CNTR3_MAX_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER3_MAX_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR3_MAX_val; // Asymmetric mode: counting period in cc + 1
	                                                        // Symmetric mode: counting period in cc
} GPIO_COUNTER3_MAX_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER3_MAX_BIT_T bf;
} GPIO_COUNTER3_MAX_T;

// ---------------------------------------------------------------------
// Register gpio_counter4_max
// =>  GPIO counter4 max value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR4_MAX 0x00000124U
#define NETX_GPIO_CNTR4_MAX     0x1C000924U

#define MSK_NETX_GPIO_CNTR4_MAX_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR4_MAX_val 0

enum {
	BFW_NETX_GPIO_CNTR4_MAX_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER4_MAX_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR4_MAX_val; // Asymmetric mode: counting period in cc + 1
	                                                        // Symmetric mode: counting period in cc
} GPIO_COUNTER4_MAX_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER4_MAX_BIT_T bf;
} GPIO_COUNTER4_MAX_T;

// ---------------------------------------------------------------------
// Register gpio_counter0_cnt
// =>  GPIO counter0 current value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR0_CNT 0x00000128U
#define NETX_GPIO_CNTR0_CNT     0x1C000928U

#define MSK_NETX_GPIO_CNTR0_CNT_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR0_CNT_val 0

enum {
	BFW_NETX_GPIO_CNTR0_CNT_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER0_CNT_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR0_CNT_val; // curent counter value
} GPIO_COUNTER0_CNT_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER0_CNT_BIT_T bf;
} GPIO_COUNTER0_CNT_T;

// ---------------------------------------------------------------------
// Register gpio_counter1_cnt
// =>  GPIO counter1 current value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR1_CNT 0x0000012CU
#define NETX_GPIO_CNTR1_CNT     0x1C00092CU

#define MSK_NETX_GPIO_CNTR1_CNT_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR1_CNT_val 0

enum {
	BFW_NETX_GPIO_CNTR1_CNT_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER1_CNT_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR1_CNT_val; // curent counter value
} GPIO_COUNTER1_CNT_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER1_CNT_BIT_T bf;
} GPIO_COUNTER1_CNT_T;

// ---------------------------------------------------------------------
// Register gpio_counter2_cnt
// =>  GPIO counter2 current value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR2_CNT 0x00000130U
#define NETX_GPIO_CNTR2_CNT     0x1C000930U

#define MSK_NETX_GPIO_CNTR2_CNT_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR2_CNT_val 0

enum {
	BFW_NETX_GPIO_CNTR2_CNT_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER2_CNT_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR2_CNT_val; // curent counter value
} GPIO_COUNTER2_CNT_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER2_CNT_BIT_T bf;
} GPIO_COUNTER2_CNT_T;

// ---------------------------------------------------------------------
// Register gpio_counter3_cnt
// =>  GPIO counter3 current value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR3_CNT 0x00000134U
#define NETX_GPIO_CNTR3_CNT     0x1C000934U

#define MSK_NETX_GPIO_CNTR3_CNT_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR3_CNT_val 0

enum {
	BFW_NETX_GPIO_CNTR3_CNT_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER3_CNT_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR3_CNT_val; // curent counter value
} GPIO_COUNTER3_CNT_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER3_CNT_BIT_T bf;
} GPIO_COUNTER3_CNT_T;

// ---------------------------------------------------------------------
// Register gpio_counter4_cnt
// =>  GPIO counter4 current value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_CNTR4_CNT 0x00000138U
#define NETX_GPIO_CNTR4_CNT     0x1C000938U

#define MSK_NETX_GPIO_CNTR4_CNT_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_CNTR4_CNT_val 0

enum {
	BFW_NETX_GPIO_CNTR4_CNT_val = 32  // [31:0]
};

typedef struct GPIO_COUNTER4_CNT_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_CNTR4_CNT_val; // curent counter value
} GPIO_COUNTER4_CNT_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_COUNTER4_CNT_BIT_T bf;
} GPIO_COUNTER4_CNT_T;

// ---------------------------------------------------------------------
// Register gpio_systime_cmp
// =>  GPIO sys_time compare value
//     compares this value with systime_ns considering incontinous behaviour of systime_ns
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_SYSTIME_NS_CMP 0x0000013CU
#define NETX_GPIO_SYSTIME_NS_CMP     0x1C00093CU

#define MSK_NETX_GPIO_SYSTIME_NS_CMP_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_SYSTIME_NS_CMP_val 0

enum {
	BFW_NETX_GPIO_SYSTIME_NS_CMP_val = 32  // [31:0]
};

typedef struct GPIO_SYSTIME_CMP_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_SYSTIME_NS_CMP_val; // compare value for systime
} GPIO_SYSTIME_CMP_BIT_T;

typedef union {
	unsigned int           val;
	GPIO_SYSTIME_CMP_BIT_T bf;
} GPIO_SYSTIME_CMP_T;

// ---------------------------------------------------------------------
// Register gpio_line
// =>  GPIO line register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_OUT 0x00000140U
#define NETX_GPIO_OUT     0x1C000940U

#define MSK_NETX_GPIO_OUT_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_OUT_val 0

enum {
	BFW_NETX_GPIO_OUT_val = 32  // [31:0]
};

typedef struct GPIO_LINE_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_OUT_val; // gpio output values
} GPIO_LINE_BIT_T;

typedef union {
	unsigned int    val;
	GPIO_LINE_BIT_T bf;
} GPIO_LINE_T;

// ---------------------------------------------------------------------
// Register gpio_in
// =>  GPIO latched register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_IN 0x00000144U
#define NETX_GPIO_IN     0x1C000944U

#define MSK_NETX_GPIO_IN_val 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_IN_val 0

enum {
	BFW_NETX_GPIO_IN_val = 32  // [31:0]
};

typedef struct GPIO_IN_BIT_Ttag {
	unsigned int val : BFW_NETX_GPIO_IN_val; // gpio input values
} GPIO_IN_BIT_T;

typedef union {
	unsigned int  val;
	GPIO_IN_BIT_T bf;
} GPIO_IN_T;

// ---------------------------------------------------------------------
// Register gpio_irq_raw
// =>  GPIO Raw IRQ register
//     Write access with '1' resets the appropriate IRQ
//     Write access with '0' does not influence this bit
//     Read access shows status of unmasked IRQs
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_IRQ_RAW 0x00000148U
#define NETX_GPIO_IRQ_RAW     0x1C000948U

#define MSK_NETX_GPIO_IRQ_RAW_gpio0  0x00000001U // [0]
#define SRT_NETX_GPIO_IRQ_RAW_gpio0  0
#define MSK_NETX_GPIO_IRQ_RAW_gpio1  0x00000002U // [1]
#define SRT_NETX_GPIO_IRQ_RAW_gpio1  1
#define MSK_NETX_GPIO_IRQ_RAW_gpio2  0x00000004U // [2]
#define SRT_NETX_GPIO_IRQ_RAW_gpio2  2
#define MSK_NETX_GPIO_IRQ_RAW_gpio3  0x00000008U // [3]
#define SRT_NETX_GPIO_IRQ_RAW_gpio3  3
#define MSK_NETX_GPIO_IRQ_RAW_gpio4  0x00000010U // [4]
#define SRT_NETX_GPIO_IRQ_RAW_gpio4  4
#define MSK_NETX_GPIO_IRQ_RAW_gpio5  0x00000020U // [5]
#define SRT_NETX_GPIO_IRQ_RAW_gpio5  5
#define MSK_NETX_GPIO_IRQ_RAW_gpio6  0x00000040U // [6]
#define SRT_NETX_GPIO_IRQ_RAW_gpio6  6
#define MSK_NETX_GPIO_IRQ_RAW_gpio7  0x00000080U // [7]
#define SRT_NETX_GPIO_IRQ_RAW_gpio7  7
#define MSK_NETX_GPIO_IRQ_RAW_gpio8  0x00000100U // [8]
#define SRT_NETX_GPIO_IRQ_RAW_gpio8  8
#define MSK_NETX_GPIO_IRQ_RAW_gpio9  0x00000200U // [9]
#define SRT_NETX_GPIO_IRQ_RAW_gpio9  9
#define MSK_NETX_GPIO_IRQ_RAW_gpio10 0x00000400U // [10]
#define SRT_NETX_GPIO_IRQ_RAW_gpio10 10
#define MSK_NETX_GPIO_IRQ_RAW_gpio11 0x00000800U // [11]
#define SRT_NETX_GPIO_IRQ_RAW_gpio11 11
#define MSK_NETX_GPIO_IRQ_RAW_gpio12 0x00001000U // [12]
#define SRT_NETX_GPIO_IRQ_RAW_gpio12 12
#define MSK_NETX_GPIO_IRQ_RAW_gpio13 0x00002000U // [13]
#define SRT_NETX_GPIO_IRQ_RAW_gpio13 13
#define MSK_NETX_GPIO_IRQ_RAW_gpio14 0x00004000U // [14]
#define SRT_NETX_GPIO_IRQ_RAW_gpio14 14
#define MSK_NETX_GPIO_IRQ_RAW_gpio15 0x00008000U // [15]
#define SRT_NETX_GPIO_IRQ_RAW_gpio15 15
#define MSK_NETX_GPIO_IRQ_RAW_gpio16 0x00010000U // [16]
#define SRT_NETX_GPIO_IRQ_RAW_gpio16 16
#define MSK_NETX_GPIO_IRQ_RAW_gpio17 0x00020000U // [17]
#define SRT_NETX_GPIO_IRQ_RAW_gpio17 17
#define MSK_NETX_GPIO_IRQ_RAW_gpio18 0x00040000U // [18]
#define SRT_NETX_GPIO_IRQ_RAW_gpio18 18
#define MSK_NETX_GPIO_IRQ_RAW_gpio19 0x00080000U // [19]
#define SRT_NETX_GPIO_IRQ_RAW_gpio19 19
#define MSK_NETX_GPIO_IRQ_RAW_gpio20 0x00100000U // [20]
#define SRT_NETX_GPIO_IRQ_RAW_gpio20 20
#define MSK_NETX_GPIO_IRQ_RAW_gpio21 0x00200000U // [21]
#define SRT_NETX_GPIO_IRQ_RAW_gpio21 21
#define MSK_NETX_GPIO_IRQ_RAW_gpio22 0x00400000U // [22]
#define SRT_NETX_GPIO_IRQ_RAW_gpio22 22
#define MSK_NETX_GPIO_IRQ_RAW_gpio23 0x00800000U // [23]
#define SRT_NETX_GPIO_IRQ_RAW_gpio23 23
#define MSK_NETX_GPIO_IRQ_RAW_gpio24 0x01000000U // [24]
#define SRT_NETX_GPIO_IRQ_RAW_gpio24 24
#define MSK_NETX_GPIO_IRQ_RAW_gpio25 0x02000000U // [25]
#define SRT_NETX_GPIO_IRQ_RAW_gpio25 25
#define MSK_NETX_GPIO_IRQ_RAW_gpio26 0x04000000U // [26]
#define SRT_NETX_GPIO_IRQ_RAW_gpio26 26
#define MSK_NETX_GPIO_IRQ_RAW_gpio27 0x08000000U // [27]
#define SRT_NETX_GPIO_IRQ_RAW_gpio27 27
#define MSK_NETX_GPIO_IRQ_RAW_gpio28 0x10000000U // [28]
#define SRT_NETX_GPIO_IRQ_RAW_gpio28 28
#define MSK_NETX_GPIO_IRQ_RAW_gpio29 0x20000000U // [29]
#define SRT_NETX_GPIO_IRQ_RAW_gpio29 29
#define MSK_NETX_GPIO_IRQ_RAW_gpio30 0x40000000U // [30]
#define SRT_NETX_GPIO_IRQ_RAW_gpio30 30
#define MSK_NETX_GPIO_IRQ_RAW_gpio31 0x80000000U // [31]
#define SRT_NETX_GPIO_IRQ_RAW_gpio31 31

enum {
	BFW_NETX_GPIO_IRQ_RAW_gpio0  = 1, // [0]
	BFW_NETX_GPIO_IRQ_RAW_gpio1  = 1, // [1]
	BFW_NETX_GPIO_IRQ_RAW_gpio2  = 1, // [2]
	BFW_NETX_GPIO_IRQ_RAW_gpio3  = 1, // [3]
	BFW_NETX_GPIO_IRQ_RAW_gpio4  = 1, // [4]
	BFW_NETX_GPIO_IRQ_RAW_gpio5  = 1, // [5]
	BFW_NETX_GPIO_IRQ_RAW_gpio6  = 1, // [6]
	BFW_NETX_GPIO_IRQ_RAW_gpio7  = 1, // [7]
	BFW_NETX_GPIO_IRQ_RAW_gpio8  = 1, // [8]
	BFW_NETX_GPIO_IRQ_RAW_gpio9  = 1, // [9]
	BFW_NETX_GPIO_IRQ_RAW_gpio10 = 1, // [10]
	BFW_NETX_GPIO_IRQ_RAW_gpio11 = 1, // [11]
	BFW_NETX_GPIO_IRQ_RAW_gpio12 = 1, // [12]
	BFW_NETX_GPIO_IRQ_RAW_gpio13 = 1, // [13]
	BFW_NETX_GPIO_IRQ_RAW_gpio14 = 1, // [14]
	BFW_NETX_GPIO_IRQ_RAW_gpio15 = 1, // [15]
	BFW_NETX_GPIO_IRQ_RAW_gpio16 = 1, // [16]
	BFW_NETX_GPIO_IRQ_RAW_gpio17 = 1, // [17]
	BFW_NETX_GPIO_IRQ_RAW_gpio18 = 1, // [18]
	BFW_NETX_GPIO_IRQ_RAW_gpio19 = 1, // [19]
	BFW_NETX_GPIO_IRQ_RAW_gpio20 = 1, // [20]
	BFW_NETX_GPIO_IRQ_RAW_gpio21 = 1, // [21]
	BFW_NETX_GPIO_IRQ_RAW_gpio22 = 1, // [22]
	BFW_NETX_GPIO_IRQ_RAW_gpio23 = 1, // [23]
	BFW_NETX_GPIO_IRQ_RAW_gpio24 = 1, // [24]
	BFW_NETX_GPIO_IRQ_RAW_gpio25 = 1, // [25]
	BFW_NETX_GPIO_IRQ_RAW_gpio26 = 1, // [26]
	BFW_NETX_GPIO_IRQ_RAW_gpio27 = 1, // [27]
	BFW_NETX_GPIO_IRQ_RAW_gpio28 = 1, // [28]
	BFW_NETX_GPIO_IRQ_RAW_gpio29 = 1, // [29]
	BFW_NETX_GPIO_IRQ_RAW_gpio30 = 1, // [30]
	BFW_NETX_GPIO_IRQ_RAW_gpio31 = 1  // [31]
};

typedef struct GPIO_IRQ_RAW_BIT_Ttag {
	unsigned int gpio0  : BFW_NETX_GPIO_IRQ_RAW_gpio0;  // interrupt bit for GPIO0   or IO-Link0-cycle timer interrupt
	unsigned int gpio1  : BFW_NETX_GPIO_IRQ_RAW_gpio1;  // interrupt bit for GPIO1   or IO-Link0-tx_interrupt
	unsigned int gpio2  : BFW_NETX_GPIO_IRQ_RAW_gpio2;  // interrupt bit for GPIO2   or IO-Link0-rx_interrupt
	unsigned int gpio3  : BFW_NETX_GPIO_IRQ_RAW_gpio3;  // interrupt bit for GPIO3   or IO-Link0-wakeup_interrupt
	unsigned int gpio4  : BFW_NETX_GPIO_IRQ_RAW_gpio4;  // interrupt bit for GPIO4   or IO-Link1-cycle timer interrupt
	unsigned int gpio5  : BFW_NETX_GPIO_IRQ_RAW_gpio5;  // interrupt bit for GPIO5   or IO-Link1-tx_interrupt  # default 0        lt 0
	unsigned int gpio6  : BFW_NETX_GPIO_IRQ_RAW_gpio6;  // interrupt bit for GPIO6   or IO-Link1-rx_interrupt
	unsigned int gpio7  : BFW_NETX_GPIO_IRQ_RAW_gpio7;  // interrupt bit for GPIO7   or IO-Link1-wakeup_interrupt
	unsigned int gpio8  : BFW_NETX_GPIO_IRQ_RAW_gpio8;  // interrupt bit for GPIO8   or IO-Link2-cycle timer interrupt
	unsigned int gpio9  : BFW_NETX_GPIO_IRQ_RAW_gpio9;  // interrupt bit for GPIO9   or IO-Link2-tx_interrupt
	unsigned int gpio10 : BFW_NETX_GPIO_IRQ_RAW_gpio10; // interrupt bit for GPIO10  or IO-Link2-rx_interrupt
	unsigned int gpio11 : BFW_NETX_GPIO_IRQ_RAW_gpio11; // interrupt bit for GPIO11  or IO-Link2-wakeup_interrupt
	unsigned int gpio12 : BFW_NETX_GPIO_IRQ_RAW_gpio12; // interrupt bit for GPIO12  or IO-Link3-cycle timer interrupt
	unsigned int gpio13 : BFW_NETX_GPIO_IRQ_RAW_gpio13; // interrupt bit for GPIO13  or IO-Link3-tx_interrupt
	unsigned int gpio14 : BFW_NETX_GPIO_IRQ_RAW_gpio14; // interrupt bit for GPIO14  or IO-Link3-rx_interrupt
	unsigned int gpio15 : BFW_NETX_GPIO_IRQ_RAW_gpio15; // interrupt bit for GPIO15  or IO-Link3-wakeup_interrupt
	unsigned int gpio16 : BFW_NETX_GPIO_IRQ_RAW_gpio16; // interrupt bit for GPIO16  or IO-Link4-cycle timer interrupt
	unsigned int gpio17 : BFW_NETX_GPIO_IRQ_RAW_gpio17; // interrupt bit for GPIO17  or IO-Link4-tx_interrupt
	unsigned int gpio18 : BFW_NETX_GPIO_IRQ_RAW_gpio18; // interrupt bit for GPIO18  or IO-Link4-rx_interrupt
	unsigned int gpio19 : BFW_NETX_GPIO_IRQ_RAW_gpio19; // interrupt bit for GPIO19  or IO-Link4-wakeup_interrupt
	unsigned int gpio20 : BFW_NETX_GPIO_IRQ_RAW_gpio20; // interrupt bit for GPIO20  or IO-Link5-cycle timer interrupt
	unsigned int gpio21 : BFW_NETX_GPIO_IRQ_RAW_gpio21; // interrupt bit for GPIO21  or IO-Link5-tx_interrupt
	unsigned int gpio22 : BFW_NETX_GPIO_IRQ_RAW_gpio22; // interrupt bit for GPIO22  or IO-Link5-rx_interrupt
	unsigned int gpio23 : BFW_NETX_GPIO_IRQ_RAW_gpio23; // interrupt bit for GPIO23  or IO-Link5-wakeup_interrupt
	unsigned int gpio24 : BFW_NETX_GPIO_IRQ_RAW_gpio24; // interrupt bit for GPIO24  or IO-Link6-cycle timer interrupt
	unsigned int gpio25 : BFW_NETX_GPIO_IRQ_RAW_gpio25; // interrupt bit for GPIO25  or IO-Link6-tx_interrupt
	unsigned int gpio26 : BFW_NETX_GPIO_IRQ_RAW_gpio26; // interrupt bit for GPIO26  or IO-Link6-rx_interrupt
	unsigned int gpio27 : BFW_NETX_GPIO_IRQ_RAW_gpio27; // interrupt bit for GPIO27  or IO-Link6-wakeup_interrupt
	unsigned int gpio28 : BFW_NETX_GPIO_IRQ_RAW_gpio28; // interrupt bit for GPIO28  or IO-Link7-cycle timer interrupt
	unsigned int gpio29 : BFW_NETX_GPIO_IRQ_RAW_gpio29; // interrupt bit for GPIO29  or IO-Link7-tx_interrupt
	unsigned int gpio30 : BFW_NETX_GPIO_IRQ_RAW_gpio30; // interrupt bit for GPIO30  or IO-Link7-rx_interrupt
	unsigned int gpio31 : BFW_NETX_GPIO_IRQ_RAW_gpio31; // interrupt bit for GPIO31  or IO-Link7-wakeup_interrupt
} GPIO_IRQ_RAW_BIT_T;

typedef union {
	unsigned int       val;
	GPIO_IRQ_RAW_BIT_T bf;
} GPIO_IRQ_RAW_T;

// ---------------------------------------------------------------------
// Register gpio_irq_masked
// =>  GPIO Masked IRQ register
//     Read access shows status of masked IRQs (as connected to VIC/ARM)
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_IRQ_MSK 0x0000014CU
#define NETX_GPIO_IRQ_MSK     0x1C00094CU

#define MSK_NETX_GPIO_IRQ_MSK_NETX_GPIO_AREA 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_IRQ_MSK_NETX_GPIO_AREA 0

enum {
	BFW_NETX_GPIO_IRQ_MSK_NETX_GPIO_AREA = 32  // [31:0]
};

typedef struct GPIO_IRQ_MASKED_BIT_Ttag {
	unsigned int gpio : BFW_NETX_GPIO_IRQ_MSK_NETX_GPIO_AREA; // One bit per GPIO
} GPIO_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int          val;
	GPIO_IRQ_MASKED_BIT_T bf;
} GPIO_IRQ_MASKED_T;

// ---------------------------------------------------------------------
// Register gpio_irq_mask_set
// =>  GPIO interrupt mask enable:
//     Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding GPIO)
//     Write access with '0' does not influence this bit
//     Read access shows actual interrupt mask
//     Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_gpio_irq_raw
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_IRQ_MSK_SET 0x00000150U
#define NETX_GPIO_IRQ_MSK_SET     0x1C000950U

#define MSK_NETX_GPIO_IRQ_MSK_SET_gpio 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_IRQ_MSK_SET_gpio 0

enum {
	BFW_NETX_GPIO_IRQ_MSK_SET_gpio = 32  // [31:0]
};

typedef struct GPIO_IRQ_MASK_SET_BIT_Ttag {
	unsigned int gpio : BFW_NETX_GPIO_IRQ_MSK_SET_gpio; // One bit per GPIO
} GPIO_IRQ_MASK_SET_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_IRQ_MASK_SET_BIT_T bf;
} GPIO_IRQ_MASK_SET_T;

// ---------------------------------------------------------------------
// Register gpio_irq_mask_rst
// =>  GPIO interrupt mask disable:
//     Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding GPIO)
//     Write access with '0' does not influence this bit
//     Read access shows actual interrupt mask
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_GPIO_IRQ_MSK_RESET 0x00000154U
#define NETX_GPIO_IRQ_MSK_RESET     0x1C000954U

#define MSK_NETX_GPIO_IRQ_MSK_RESET_gpio 0xffffffffU // [31:0]
#define SRT_NETX_GPIO_IRQ_MSK_RESET_gpio 0

enum {
	BFW_NETX_GPIO_IRQ_MSK_RESET_gpio = 32  // [31:0]
};

typedef struct GPIO_IRQ_MASK_RST_BIT_Ttag {
	unsigned int gpio : BFW_NETX_GPIO_IRQ_MSK_RESET_gpio; // One bit per GPIO
} GPIO_IRQ_MASK_RST_BIT_T;

typedef union {
	unsigned int            val;
	GPIO_IRQ_MASK_RST_BIT_T bf;
} GPIO_IRQ_MASK_RST_T;

// ---------------------------------------------------------------------
// Register cnt_irq_raw
// =>  Counter Raw IRQ register
//     Write access with '1' resets the appropriate IRQ
//     Write access with '0' does not influence this bit
//     Read access shows status of unmasked IRQs
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CNTR_IRQ_RAW 0x00000158U
#define NETX_CNTR_IRQ_RAW     0x1C000958U

#define MSK_NETX_CNTR_IRQ_RAW_cnt0     0x00000001U // [0]
#define SRT_NETX_CNTR_IRQ_RAW_cnt0     0
#define MSK_NETX_CNTR_IRQ_RAW_cnt1     0x00000002U // [1]
#define SRT_NETX_CNTR_IRQ_RAW_cnt1     1
#define MSK_NETX_CNTR_IRQ_RAW_cnt2     0x00000004U // [2]
#define SRT_NETX_CNTR_IRQ_RAW_cnt2     2
#define MSK_NETX_CNTR_IRQ_RAW_cnt3     0x00000008U // [3]
#define SRT_NETX_CNTR_IRQ_RAW_cnt3     3
#define MSK_NETX_CNTR_IRQ_RAW_cnt4     0x00000010U // [4]
#define SRT_NETX_CNTR_IRQ_RAW_cnt4     4
#define MSK_NETX_CNTR_IRQ_RAW_sys_time 0x00000020U // [5]
#define SRT_NETX_CNTR_IRQ_RAW_sys_time 5

enum {
	BFW_NETX_CNTR_IRQ_RAW_cnt0      = 1,  // [0]
	BFW_NETX_CNTR_IRQ_RAW_cnt1      = 1,  // [1]
	BFW_NETX_CNTR_IRQ_RAW_cnt2      = 1,  // [2]
	BFW_NETX_CNTR_IRQ_RAW_cnt3      = 1,  // [3]
	BFW_NETX_CNTR_IRQ_RAW_cnt4      = 1,  // [4]
	BFW_NETX_CNTR_IRQ_RAW_sys_time  = 1,  // [5]
	BFW_NETX_CNTR_IRQ_RAW_reserved1 = 26  // [31:6]
};

typedef struct CNT_IRQ_RAW_BIT_Ttag {
	unsigned int cnt0      : BFW_NETX_CNTR_IRQ_RAW_cnt0;      // interrupt bit for counter0
	unsigned int cnt1      : BFW_NETX_CNTR_IRQ_RAW_cnt1;      // interrupt bit for counter1
	unsigned int cnt2      : BFW_NETX_CNTR_IRQ_RAW_cnt2;      // interrupt bit for counter2
	unsigned int cnt3      : BFW_NETX_CNTR_IRQ_RAW_cnt3;      // interrupt bit for counter3
	unsigned int cnt4      : BFW_NETX_CNTR_IRQ_RAW_cnt4;      // interrupt bit for counter4
	unsigned int sys_time  : BFW_NETX_CNTR_IRQ_RAW_sys_time;  // interrupt bit for sys_time (if sys_time = gpio_systime_cmp)
	unsigned int reserved1 : BFW_NETX_CNTR_IRQ_RAW_reserved1; // reserved
} CNT_IRQ_RAW_BIT_T;

typedef union {
	unsigned int      val;
	CNT_IRQ_RAW_BIT_T bf;
} CNT_IRQ_RAW_T;

// ---------------------------------------------------------------------
// Register cnt_irq_masked
// =>  Counter Masked IRQ register
//     Read access shows status of masked IRQs (as connected to VIC/ARM)
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_CNTR_IRQ_MSK 0x0000015CU
#define NETX_CNTR_IRQ_MSK     0x1C00095CU

#define MSK_NETX_CNTR_IRQ_MSK_cnt0     0x00000001U // [0]
#define SRT_NETX_CNTR_IRQ_MSK_cnt0     0
#define MSK_NETX_CNTR_IRQ_MSK_cnt1     0x00000002U // [1]
#define SRT_NETX_CNTR_IRQ_MSK_cnt1     1
#define MSK_NETX_CNTR_IRQ_MSK_cnt2     0x00000004U // [2]
#define SRT_NETX_CNTR_IRQ_MSK_cnt2     2
#define MSK_NETX_CNTR_IRQ_MSK_cnt3     0x00000008U // [3]
#define SRT_NETX_CNTR_IRQ_MSK_cnt3     3
#define MSK_NETX_CNTR_IRQ_MSK_cnt4     0x00000010U // [4]
#define SRT_NETX_CNTR_IRQ_MSK_cnt4     4
#define MSK_NETX_CNTR_IRQ_MSK_sys_time 0x00000020U // [5]
#define SRT_NETX_CNTR_IRQ_MSK_sys_time 5

enum {
	BFW_NETX_CNTR_IRQ_MSK_cnt0      = 1,  // [0]
	BFW_NETX_CNTR_IRQ_MSK_cnt1      = 1,  // [1]
	BFW_NETX_CNTR_IRQ_MSK_cnt2      = 1,  // [2]
	BFW_NETX_CNTR_IRQ_MSK_cnt3      = 1,  // [3]
	BFW_NETX_CNTR_IRQ_MSK_cnt4      = 1,  // [4]
	BFW_NETX_CNTR_IRQ_MSK_sys_time  = 1,  // [5]
	BFW_NETX_CNTR_IRQ_MSK_reserved1 = 26  // [31:6]
};

typedef struct CNT_IRQ_MASKED_BIT_Ttag {
	unsigned int cnt0      : BFW_NETX_CNTR_IRQ_MSK_cnt0;      // interrupt bit for counter0
	unsigned int cnt1      : BFW_NETX_CNTR_IRQ_MSK_cnt1;      // interrupt bit for counter1
	unsigned int cnt2      : BFW_NETX_CNTR_IRQ_MSK_cnt2;      // interrupt bit for counter2
	unsigned int cnt3      : BFW_NETX_CNTR_IRQ_MSK_cnt3;      // interrupt bit for counter3
	unsigned int cnt4      : BFW_NETX_CNTR_IRQ_MSK_cnt4;      // interrupt bit for counter4
	unsigned int sys_time  : BFW_NETX_CNTR_IRQ_MSK_sys_time;  // interrupt bit for sys_time (if sys_time = gpio_systime_cmp)
	unsigned int reserved1 : BFW_NETX_CNTR_IRQ_MSK_reserved1; // reserved
} CNT_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int         val;
	CNT_IRQ_MASKED_BIT_T bf;
} CNT_IRQ_MASKED_T;

// ---------------------------------------------------------------------
// Register cnt_irq_mask_set
// =>  Counter interrupt mask enable
//     Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding counter)
//     Write access with '0' does not influence this bit
//     Read access shows actual interrupt mask
//     Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_cnt_irq_raw
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CNTR_IRQ_MSK_SET 0x00000160U
#define NETX_CNTR_IRQ_MSK_SET     0x1C000960U

#define MSK_NETX_CNTR_IRQ_MSK_SET_cnt0    0x00000001U // [0]
#define SRT_NETX_CNTR_IRQ_MSK_SET_cnt0    0
#define MSK_NETX_CNTR_IRQ_MSK_SET_cnt1    0x00000002U // [1]
#define SRT_NETX_CNTR_IRQ_MSK_SET_cnt1    1
#define MSK_NETX_CNTR_IRQ_MSK_SET_cnt2    0x00000004U // [2]
#define SRT_NETX_CNTR_IRQ_MSK_SET_cnt2    2
#define MSK_NETX_CNTR_IRQ_MSK_SET_cnt3    0x00000008U // [3]
#define SRT_NETX_CNTR_IRQ_MSK_SET_cnt3    3
#define MSK_NETX_CNTR_IRQ_MSK_SET_cnt4    0x00000010U // [4]
#define SRT_NETX_CNTR_IRQ_MSK_SET_cnt4    4
#define MSK_NETX_CNTR_IRQ_MSK_SET_systime 0x00000020U // [5]
#define SRT_NETX_CNTR_IRQ_MSK_SET_systime 5

enum {
	BFW_NETX_CNTR_IRQ_MSK_SET_cnt0      = 1,  // [0]
	BFW_NETX_CNTR_IRQ_MSK_SET_cnt1      = 1,  // [1]
	BFW_NETX_CNTR_IRQ_MSK_SET_cnt2      = 1,  // [2]
	BFW_NETX_CNTR_IRQ_MSK_SET_cnt3      = 1,  // [3]
	BFW_NETX_CNTR_IRQ_MSK_SET_cnt4      = 1,  // [4]
	BFW_NETX_CNTR_IRQ_MSK_SET_systime   = 1,  // [5]
	BFW_NETX_CNTR_IRQ_MSK_SET_reserved1 = 26  // [31:6]
};

typedef struct CNT_IRQ_MASK_SET_BIT_Ttag {
	unsigned int cnt0      : BFW_NETX_CNTR_IRQ_MSK_SET_cnt0;      // counter0 interrupt mask bit
	unsigned int cnt1      : BFW_NETX_CNTR_IRQ_MSK_SET_cnt1;      // counter1 interrupt mask bit
	unsigned int cnt2      : BFW_NETX_CNTR_IRQ_MSK_SET_cnt2;      // counter2 interrupt mask bit
	unsigned int cnt3      : BFW_NETX_CNTR_IRQ_MSK_SET_cnt3;      // counter3 interrupt mask bit
	unsigned int cnt4      : BFW_NETX_CNTR_IRQ_MSK_SET_cnt4;      // counter4 interrupt mask bit
	unsigned int systime   : BFW_NETX_CNTR_IRQ_MSK_SET_systime;   // sys_time interrupt mask bit
	unsigned int reserved1 : BFW_NETX_CNTR_IRQ_MSK_SET_reserved1; // reserved
} CNT_IRQ_MASK_SET_BIT_T;

typedef union {
	unsigned int           val;
	CNT_IRQ_MASK_SET_BIT_T bf;
} CNT_IRQ_MASK_SET_T;

// ---------------------------------------------------------------------
// Register cnt_irq_mask_rst
// =>  Counter interrupt mask disable
//     Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding counter)
//     Write access with '0' does not influence this bit
//     Read access shows actual interrupt mask
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CNTR_IRQ_MSK_RESET 0x00000164U
#define NETX_CNTR_IRQ_MSK_RESET     0x1C000964U

#define MSK_NETX_CNTR_IRQ_MSK_RESET_cnt0    0x00000001U // [0]
#define SRT_NETX_CNTR_IRQ_MSK_RESET_cnt0    0
#define MSK_NETX_CNTR_IRQ_MSK_RESET_cnt1    0x00000002U // [1]
#define SRT_NETX_CNTR_IRQ_MSK_RESET_cnt1    1
#define MSK_NETX_CNTR_IRQ_MSK_RESET_cnt2    0x00000004U // [2]
#define SRT_NETX_CNTR_IRQ_MSK_RESET_cnt2    2
#define MSK_NETX_CNTR_IRQ_MSK_RESET_cnt3    0x00000008U // [3]
#define SRT_NETX_CNTR_IRQ_MSK_RESET_cnt3    3
#define MSK_NETX_CNTR_IRQ_MSK_RESET_cnt4    0x00000010U // [4]
#define SRT_NETX_CNTR_IRQ_MSK_RESET_cnt4    4
#define MSK_NETX_CNTR_IRQ_MSK_RESET_systime 0x00000020U // [5]
#define SRT_NETX_CNTR_IRQ_MSK_RESET_systime 5

enum {
	BFW_NETX_CNTR_IRQ_MSK_RESET_cnt0      = 1,  // [0]
	BFW_NETX_CNTR_IRQ_MSK_RESET_cnt1      = 1,  // [1]
	BFW_NETX_CNTR_IRQ_MSK_RESET_cnt2      = 1,  // [2]
	BFW_NETX_CNTR_IRQ_MSK_RESET_cnt3      = 1,  // [3]
	BFW_NETX_CNTR_IRQ_MSK_RESET_cnt4      = 1,  // [4]
	BFW_NETX_CNTR_IRQ_MSK_RESET_systime   = 1,  // [5]
	BFW_NETX_CNTR_IRQ_MSK_RESET_reserved1 = 26  // [31:6]
};

typedef struct CNT_IRQ_MASK_RST_BIT_Ttag {
	unsigned int cnt0      : BFW_NETX_CNTR_IRQ_MSK_RESET_cnt0;      // counter0 interrupt mask bit
	unsigned int cnt1      : BFW_NETX_CNTR_IRQ_MSK_RESET_cnt1;      // counter1 interrupt mask bit
	unsigned int cnt2      : BFW_NETX_CNTR_IRQ_MSK_RESET_cnt2;      // counter2 interrupt mask bit
	unsigned int cnt3      : BFW_NETX_CNTR_IRQ_MSK_RESET_cnt3;      // counter3 interrupt mask bit
	unsigned int cnt4      : BFW_NETX_CNTR_IRQ_MSK_RESET_cnt4;      // counter4 interrupt mask bit
	unsigned int systime   : BFW_NETX_CNTR_IRQ_MSK_RESET_systime;   // sys_time interrupt mask bit
	unsigned int reserved1 : BFW_NETX_CNTR_IRQ_MSK_RESET_reserved1; // reserved
} CNT_IRQ_MASK_RST_BIT_T;

typedef union {
	unsigned int           val;
	CNT_IRQ_MASK_RST_BIT_T bf;
} CNT_IRQ_MASK_RST_T;


// =====================================================================
//
// Area of iolink0, iolink1, iolink2, iolink3, iolink4, iolink5, iolink6, iolink7
//
// =====================================================================

#define NETX_IOLINK0	0x1C000880U
#define NETX_IOLINK1	0x1C000890U
#define NETX_IOLINK2	0x1C0008A0U
#define NETX_IOLINK3	0x1C0008B0U
#define NETX_IOLINK4	0x1C0008C0U
#define NETX_IOLINK5	0x1C0008D0U
#define NETX_IOLINK6	0x1C0008E0U
#define NETX_IOLINK7	0x1C0008F0U

// ---------------------------------------------------------------------
// Register iolink_cfg
// =>  IO-Link configuration register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_IOLINK_CFG     0x00000000U
#define NETX_IOLINK0_CFG 0x1C000880U
#define NETX_IOLINK1_CFG 0x1C000890U
#define NETX_IOLINK2_CFG 0x1C0008A0U
#define NETX_IOLINK3_CFG 0x1C0008B0U
#define NETX_IOLINK4_CFG 0x1C0008C0U
#define NETX_IOLINK5_CFG 0x1C0008D0U
#define NETX_IOLINK6_CFG 0x1C0008E0U
#define NETX_IOLINK7_CFG 0x1C0008F0U

#define MSK_NETX_IOLINK_CFG_frame_cycle      0x000000ffU // [7:0]
#define SRT_NETX_IOLINK_CFG_frame_cycle      0
#define MSK_NETX_IOLINK_CFG_freq_sel         0x00000300U // [9:8]
#define SRT_NETX_IOLINK_CFG_freq_sel         8
#define MSK_NETX_IOLINK_CFG_nr_tx_oct        0x00001c00U // [12:10]
#define SRT_NETX_IOLINK_CFG_nr_tx_oct        10
#define MSK_NETX_IOLINK_CFG_nr_rx_oct        0x00006000U // [14:13]
#define SRT_NETX_IOLINK_CFG_nr_rx_oct        13
#define MSK_NETX_IOLINK_CFG_sngl_trans       0x00010000U // [16]
#define SRT_NETX_IOLINK_CFG_sngl_trans       16
#define MSK_NETX_IOLINK_CFG_tx_lsb_first     0x00020000U // [17]
#define SRT_NETX_IOLINK_CFG_tx_lsb_first     17
#define MSK_NETX_IOLINK_CFG_tx_init          0x00040000U // [18]
#define SRT_NETX_IOLINK_CFG_tx_init          18
#define MSK_NETX_IOLINK_CFG_en_frame_timeout 0x00080000U // [19]
#define SRT_NETX_IOLINK_CFG_en_frame_timeout 19
#define MSK_NETX_IOLINK_CFG_tx_oe_dis        0x00100000U // [20]
#define SRT_NETX_IOLINK_CFG_tx_oe_dis        20
#define MSK_NETX_IOLINK_CFG_tx_loop          0x00200000U // [21]
#define SRT_NETX_IOLINK_CFG_tx_loop          21
#define MSK_NETX_IOLINK_CFG_en_delay         0x00400000U // [22]
#define SRT_NETX_IOLINK_CFG_en_delay         22
#define MSK_NETX_IOLINK_CFG_latch_dval       0x00800000U // [23]
#define SRT_NETX_IOLINK_CFG_latch_dval       23
#define MSK_NETX_IOLINK_CFG_enable_fm_intr   0x01000000U // [24]
#define SRT_NETX_IOLINK_CFG_enable_fm_intr   24
#define MSK_NETX_IOLINK_CFG_pio_tx_oe_active 0x02000000U // [25]
#define SRT_NETX_IOLINK_CFG_pio_tx_oe_active 25
#define MSK_NETX_IOLINK_CFG_gen_wake_up      0x04000000U // [26]
#define SRT_NETX_IOLINK_CFG_gen_wake_up      26
#define MSK_NETX_IOLINK_CFG_rx_lsb_first     0x08000000U // [27]
#define SRT_NETX_IOLINK_CFG_rx_lsb_first     27
#define MSK_NETX_IOLINK_CFG_debug_vec        0x70000000U // [30:28]
#define SRT_NETX_IOLINK_CFG_debug_vec        28
#define MSK_NETX_IOLINK_CFG_set_status       0x80000000U // [31]
#define SRT_NETX_IOLINK_CFG_set_status       31

enum {
	BFW_NETX_IOLINK_CFG_frame_cycle      = 8, // [7:0]
	BFW_NETX_IOLINK_CFG_freq_sel         = 2, // [9:8]
	BFW_NETX_IOLINK_CFG_nr_tx_oct        = 3, // [12:10]
	BFW_NETX_IOLINK_CFG_nr_rx_oct        = 2, // [14:13]
	BFW_NETX_IOLINK_CFG_reserved1        = 1, // [15]
	BFW_NETX_IOLINK_CFG_sngl_trans       = 1, // [16]
	BFW_NETX_IOLINK_CFG_tx_lsb_first     = 1, // [17]
	BFW_NETX_IOLINK_CFG_tx_init          = 1, // [18]
	BFW_NETX_IOLINK_CFG_en_frame_timeout = 1, // [19]
	BFW_NETX_IOLINK_CFG_tx_oe_dis        = 1, // [20]
	BFW_NETX_IOLINK_CFG_tx_loop          = 1, // [21]
	BFW_NETX_IOLINK_CFG_en_delay         = 1, // [22]
	BFW_NETX_IOLINK_CFG_latch_dval       = 1, // [23]
	BFW_NETX_IOLINK_CFG_enable_fm_intr   = 1, // [24]
	BFW_NETX_IOLINK_CFG_pio_tx_oe_active = 1, // [25]
	BFW_NETX_IOLINK_CFG_gen_wake_up      = 1, // [26]
	BFW_NETX_IOLINK_CFG_rx_lsb_first     = 1, // [27]
	BFW_NETX_IOLINK_CFG_debug_vec        = 3, // [30:28]
	BFW_NETX_IOLINK_CFG_set_status       = 1  // [31]
};

typedef struct IOLINK_CFG_BIT_Ttag {
	unsigned int frame_cycle      : BFW_NETX_IOLINK_CFG_frame_cycle;      // Half of number of T_clk cycles, this compare value is doubled by the hardware!
	unsigned int freq_sel         : BFW_NETX_IOLINK_CFG_freq_sel;         // set the baudrate  (T_clk):
	                                                        // 00 : 250ns  test only
	                                                        // 01 : 208,33 us, com1 - 4800 Baud
	                                                        // 10 : 26,04 us, com2 - 38400 Baud
	                                                        // 11 : 4,34 us, com3 - 230400 Baud
	unsigned int nr_tx_oct        : BFW_NETX_IOLINK_CFG_nr_tx_oct;        // Number for octets to transmit
	                                                        // _________________________
	                                                        // code| tx octets per frame
	                                                        // -------------------------
	                                                        // 000 | 1
	                                                        // 001 | 2
	                                                        // 010 | 3
	                                                        // 011 | 4
	                                                        // 100 | 5
	                                                        // 101 | reserved
	                                                        // 110 | reserved
	                                                        // 111 | reserved
	                                                        // -------------------------
	unsigned int nr_rx_oct        : BFW_NETX_IOLINK_CFG_nr_rx_oct;        // Number for octets to receive:
	                                                        // _________________________
	                                                        // code| rx octets per frame
	                                                        // -------------------------
	                                                        // 00  | 1
	                                                        // 01  | 2
	                                                        // 10  | 3
	                                                        // 11  | 4
	                                                        // -------------------------
	unsigned int reserved1        : BFW_NETX_IOLINK_CFG_reserved1;        // reserved
	unsigned int sngl_trans       : BFW_NETX_IOLINK_CFG_sngl_trans;       // Single frame transfer mode:
	                                                        // Reset and set this bit to activate the transfer.
	                                                        // In loop mode this bit used to reset parity error status.
	unsigned int tx_lsb_first     : BFW_NETX_IOLINK_CFG_tx_lsb_first;     // LSByte first for transmit process
	unsigned int tx_init          : BFW_NETX_IOLINK_CFG_tx_init;          // Default tx output level
	unsigned int en_frame_timeout : BFW_NETX_IOLINK_CFG_en_frame_timeout; // enable the frame timeout function
	unsigned int tx_oe_dis        : BFW_NETX_IOLINK_CFG_tx_oe_dis;        // - disable the tx_oe generation if wake up generation proceed
	unsigned int tx_loop          : BFW_NETX_IOLINK_CFG_tx_loop;          // Enable tx auto repeat transmission.
	unsigned int en_delay         : BFW_NETX_IOLINK_CFG_en_delay;         // Enable dalay function before transmitting the frame.
	                                                        // the delay value is the tx_octet8 byte of the adr_iolink_tx_frame_2nd register
	unsigned int latch_dval       : BFW_NETX_IOLINK_CFG_latch_dval;       // Latch the delay value (from frame_cycle_r).
	                                                        // Set this bit to write the delay value.
	unsigned int enable_fm_intr   : BFW_NETX_IOLINK_CFG_enable_fm_intr;   // Enable frame interrupt
	unsigned int pio_tx_oe_active : BFW_NETX_IOLINK_CFG_pio_tx_oe_active; // Activate the link output control
	unsigned int gen_wake_up      : BFW_NETX_IOLINK_CFG_gen_wake_up;      // Set this bit to generate one wake up pulse,
	                                                        // set the tx_init_r according to the WAKE_H/WAKE_L coding.
	                                                        // Reset and set this bit to generate a wake up pulse again.
	                                                        // Set the frequency to 4800 Baud first before activate the wake up generation.
	unsigned int rx_lsb_first     : BFW_NETX_IOLINK_CFG_rx_lsb_first;     // LSByte first for receive process
	unsigned int debug_vec        : BFW_NETX_IOLINK_CFG_debug_vec;        // Debug vector, must not be changed on operation
	unsigned int set_status       : BFW_NETX_IOLINK_CFG_set_status;       // If set, status vector will be mapped to this register address.
	                                                        // A read access to this register will then show the following information:
	                                                        // bit      0: txd_r, current status of tx port
	                                                        // bit      1: rxd_in, current status of rx port
	                                                        // bit      2: wake_up_r, current status of wake up port
	                                                        // bit      3: tx_oe_r, current status tx_oe port
	                                                        // bits   7:4: fsm_io_link_state, status of the IOLINK state machine
	                                                        // bit      8: rx_sum_parrity_error_r,  parrity error in last transmission
	                                                        // bit      9: stop_bit_error_r, stop bit error in last transmission
	                                                        // bits 12:10: tx_oct_cnt_r, lower bits of current tx transfer counter
	                                                        // bits 21:13: frame_cycle_cnt_r, current frame cycle counter
	                                                        // bits 24:22: ad_rx_oct_r, current rx transfer counter
	                                                        // bits 31:25: tclk_cnt_r, MSB of the baud rate counter
} IOLINK_CFG_BIT_T;

typedef union {
	unsigned int     val;
	IOLINK_CFG_BIT_T bf;
} IOLINK_CFG_T;

// ---------------------------------------------------------------------
// Register iolink_tx_frame_1st
// =>  IO-Link TX0 data register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_IOLINK_TX_FRM0     0x00000004U
#define NETX_IOLINK0_TX_FRM0 0x1C000884U
#define NETX_IOLINK1_TX_FRM0 0x1C000894U
#define NETX_IOLINK2_TX_FRM0 0x1C0008A4U
#define NETX_IOLINK3_TX_FRM0 0x1C0008B4U
#define NETX_IOLINK4_TX_FRM0 0x1C0008C4U
#define NETX_IOLINK5_TX_FRM0 0x1C0008D4U
#define NETX_IOLINK6_TX_FRM0 0x1C0008E4U
#define NETX_IOLINK7_TX_FRM0 0x1C0008F4U

#define MSK_NETX_IOLINK_TX_FRM0_tx_octet1 0x000000ffU // [7:0]
#define SRT_NETX_IOLINK_TX_FRM0_tx_octet1 0
#define MSK_NETX_IOLINK_TX_FRM0_tx_octet2 0x0000ff00U // [15:8]
#define SRT_NETX_IOLINK_TX_FRM0_tx_octet2 8
#define MSK_NETX_IOLINK_TX_FRM0_tx_octet3 0x00ff0000U // [23:16]
#define SRT_NETX_IOLINK_TX_FRM0_tx_octet3 16
#define MSK_NETX_IOLINK_TX_FRM0_tx_octet4 0xff000000U // [31:24]
#define SRT_NETX_IOLINK_TX_FRM0_tx_octet4 24

enum {
	BFW_NETX_IOLINK_TX_FRM0_tx_octet1 = 8, // [7:0]
	BFW_NETX_IOLINK_TX_FRM0_tx_octet2 = 8, // [15:8]
	BFW_NETX_IOLINK_TX_FRM0_tx_octet3 = 8, // [23:16]
	BFW_NETX_IOLINK_TX_FRM0_tx_octet4 = 8  // [31:24]
};

typedef struct IOLINK_TX_FRAME_1ST_BIT_Ttag {
	unsigned int tx_octet1 : BFW_NETX_IOLINK_TX_FRM0_tx_octet1; // octet 1(r/w)
	unsigned int tx_octet2 : BFW_NETX_IOLINK_TX_FRM0_tx_octet2; // octet 2(r/w)
	unsigned int tx_octet3 : BFW_NETX_IOLINK_TX_FRM0_tx_octet3; // octet 3(r/w)
	unsigned int tx_octet4 : BFW_NETX_IOLINK_TX_FRM0_tx_octet4; // octet 4(r/w)
} IOLINK_TX_FRAME_1ST_BIT_T;

typedef union {
	unsigned int              val;
	IOLINK_TX_FRAME_1ST_BIT_T bf;
} IOLINK_TX_FRAME_1ST_T;

// ---------------------------------------------------------------------
// Register iolink_tx_frame_2nd
// =>  IO-Link TX1 data register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_IOLINK_TX_FRM1     0x00000008U
#define NETX_IOLINK0_TX_FRM1 0x1C000888U
#define NETX_IOLINK1_TX_FRM1 0x1C000898U
#define NETX_IOLINK2_TX_FRM1 0x1C0008A8U
#define NETX_IOLINK3_TX_FRM1 0x1C0008B8U
#define NETX_IOLINK4_TX_FRM1 0x1C0008C8U
#define NETX_IOLINK5_TX_FRM1 0x1C0008D8U
#define NETX_IOLINK6_TX_FRM1 0x1C0008E8U
#define NETX_IOLINK7_TX_FRM1 0x1C0008F8U

#define MSK_NETX_IOLINK_TX_FRM1_tx_octet5 0x000000ffU // [7:0]
#define SRT_NETX_IOLINK_TX_FRM1_tx_octet5 0
#define MSK_NETX_IOLINK_TX_FRM1_tx_octet6 0x0000ff00U // [15:8]
#define SRT_NETX_IOLINK_TX_FRM1_tx_octet6 8
#define MSK_NETX_IOLINK_TX_FRM1_tx_octet7 0x00ff0000U // [23:16]
#define SRT_NETX_IOLINK_TX_FRM1_tx_octet7 16
#define MSK_NETX_IOLINK_TX_FRM1_tx_octet8 0xff000000U // [31:24]
#define SRT_NETX_IOLINK_TX_FRM1_tx_octet8 24

enum {
	BFW_NETX_IOLINK_TX_FRM1_tx_octet5 = 8, // [7:0]
	BFW_NETX_IOLINK_TX_FRM1_tx_octet6 = 8, // [15:8]
	BFW_NETX_IOLINK_TX_FRM1_tx_octet7 = 8, // [23:16]
	BFW_NETX_IOLINK_TX_FRM1_tx_octet8 = 8  // [31:24]
};

typedef struct IOLINK_TX_FRAME_2ND_BIT_Ttag {
	unsigned int tx_octet5 : BFW_NETX_IOLINK_TX_FRM1_tx_octet5; // octet 5(r/w)
	unsigned int tx_octet6 : BFW_NETX_IOLINK_TX_FRM1_tx_octet6; // octet 6(r/w) debug only!
	unsigned int tx_octet7 : BFW_NETX_IOLINK_TX_FRM1_tx_octet7; // octet 7(r/w) debug only!
	unsigned int tx_octet8 : BFW_NETX_IOLINK_TX_FRM1_tx_octet8; // octet 8(r/w) debug only!, if en_delay_r bit set, this value is a tx delay value
} IOLINK_TX_FRAME_2ND_BIT_T;

typedef union {
	unsigned int              val;
	IOLINK_TX_FRAME_2ND_BIT_T bf;
} IOLINK_TX_FRAME_2ND_T;

// ---------------------------------------------------------------------
// Register iolink_rx_frame_1st
// =>  IO-Link RX data register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_IOLINK_RX_FRM     0x0000000CU
#define NETX_IOLINK0_RX_FRM 0x1C00088CU
#define NETX_IOLINK1_RX_FRM 0x1C00089CU
#define NETX_IOLINK2_RX_FRM 0x1C0008ACU
#define NETX_IOLINK3_RX_FRM 0x1C0008BCU
#define NETX_IOLINK4_RX_FRM 0x1C0008CCU
#define NETX_IOLINK5_RX_FRM 0x1C0008DCU
#define NETX_IOLINK6_RX_FRM 0x1C0008ECU
#define NETX_IOLINK7_RX_FRM 0x1C0008FCU

#define MSK_NETX_IOLINK_RX_FRM_rx_octet1 0x000000ffU // [7:0]
#define SRT_NETX_IOLINK_RX_FRM_rx_octet1 0
#define MSK_NETX_IOLINK_RX_FRM_rx_octet2 0x0000ff00U // [15:8]
#define SRT_NETX_IOLINK_RX_FRM_rx_octet2 8
#define MSK_NETX_IOLINK_RX_FRM_rx_octet3 0x00ff0000U // [23:16]
#define SRT_NETX_IOLINK_RX_FRM_rx_octet3 16
#define MSK_NETX_IOLINK_RX_FRM_rx_octet4 0xff000000U // [31:24]
#define SRT_NETX_IOLINK_RX_FRM_rx_octet4 24

enum {
	BFW_NETX_IOLINK_RX_FRM_rx_octet1 = 8, // [7:0]
	BFW_NETX_IOLINK_RX_FRM_rx_octet2 = 8, // [15:8]
	BFW_NETX_IOLINK_RX_FRM_rx_octet3 = 8, // [23:16]
	BFW_NETX_IOLINK_RX_FRM_rx_octet4 = 8  // [31:24]
};

typedef struct IOLINK_RX_FRAME_1ST_BIT_Ttag {
	unsigned int rx_octet1 : BFW_NETX_IOLINK_RX_FRM_rx_octet1; // octet 1(r/w)
	unsigned int rx_octet2 : BFW_NETX_IOLINK_RX_FRM_rx_octet2; // octet 2(r/w)
	unsigned int rx_octet3 : BFW_NETX_IOLINK_RX_FRM_rx_octet3; // octet 3(r/w)
	unsigned int rx_octet4 : BFW_NETX_IOLINK_RX_FRM_rx_octet4; // octet 4(r/w)
} IOLINK_RX_FRAME_1ST_BIT_T;

typedef union {
	unsigned int              val;
	IOLINK_RX_FRAME_1ST_BIT_T bf;
} IOLINK_RX_FRAME_1ST_T;


// =====================================================================
//
// Area of pio
//
// =====================================================================

#define NETX_PIO_AREA	0x1C000A00U

// ---------------------------------------------------------------------
// Register pio_in
// =>  PIO input register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_PIO_IN 0x00000000U
#define NETX_PIO_IN     0x1C000A00U

#define MSK_NETX_PIO_IN_val 0x000000ffU // [7:0]
#define SRT_NETX_PIO_IN_val 0

enum {
	BFW_NETX_PIO_IN_val       = 8,  // [7:0]
	BFW_NETX_PIO_IN_reserved1 = 24  // [31:8]
};

typedef struct PIO_IN_BIT_Ttag {
	unsigned int val       : BFW_NETX_PIO_IN_val;       // pio input values
	unsigned int reserved1 : BFW_NETX_PIO_IN_reserved1; // reserved
} PIO_IN_BIT_T;

typedef union {
	unsigned int val;
	PIO_IN_BIT_T bf;
} PIO_IN_T;

// ---------------------------------------------------------------------
// Register pio_out
// =>  PIO output register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_PIO_OUT 0x00000004U
#define NETX_PIO_OUT     0x1C000A04U

#define MSK_NETX_PIO_OUT_val 0x000000ffU // [7:0]
#define SRT_NETX_PIO_OUT_val 0

enum {
	BFW_NETX_PIO_OUT_val       = 8,  // [7:0]
	BFW_NETX_PIO_OUT_reserved1 = 24  // [31:8]
};

typedef struct PIO_OUT_BIT_Ttag {
	unsigned int val       : BFW_NETX_PIO_OUT_val;       // pio output values
	unsigned int reserved1 : BFW_NETX_PIO_OUT_reserved1; // reserved
} PIO_OUT_BIT_T;

typedef union {
	unsigned int  val;
	PIO_OUT_BIT_T bf;
} PIO_OUT_T;

// ---------------------------------------------------------------------
// Register pio_oe
// =>  PIO output enable register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_PIO_OUT_EN 0x00000008U
#define NETX_PIO_OUT_EN     0x1C000A08U

#define MSK_NETX_PIO_OUT_EN_val 0x000000ffU // [7:0]
#define SRT_NETX_PIO_OUT_EN_val 0

enum {
	BFW_NETX_PIO_OUT_EN_val       = 8,  // [7:0]
	BFW_NETX_PIO_OUT_EN_reserved1 = 24  // [31:8]
};

typedef struct PIO_OE_BIT_Ttag {
	unsigned int val       : BFW_NETX_PIO_OUT_EN_val;       // pio output enables
	unsigned int reserved1 : BFW_NETX_PIO_OUT_EN_reserved1; // reserved
} PIO_OE_BIT_T;

typedef union {
	unsigned int val;
	PIO_OE_BIT_T bf;
} PIO_OE_T;


// =====================================================================
//
// Area of uart0, uart1, uart2
//
// =====================================================================

#define NETX_UART0_AREA	0x1C000B00U
#define NETX_UART1_AREA	0x1C000B40U
#define NETX_UART2_AREA	0x1C000B80U

// ---------------------------------------------------------------------
// Register uartdr
// =>  data read or written from the interface
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_DATA   0x00000000U
#define NETX_UART0_DATA 0x1C000B00U
#define NETX_UART1_DATA 0x1C000B40U
#define NETX_UART2_DATA 0x1C000B80U

#define MSK_NETX_UART_DATA_DATA 0x000000ffU // [7:0]
#define SRT_NETX_UART_DATA_DATA 0
#define MSK_NETX_UART_DATA_FE   0x00000100U // [8]
#define SRT_NETX_UART_DATA_FE   8
#define MSK_NETX_UART_DATA_PE   0x00000200U // [9]
#define SRT_NETX_UART_DATA_PE   9
#define MSK_NETX_UART_DATA_BE   0x00000400U // [10]
#define SRT_NETX_UART_DATA_BE   10

enum {
	BFW_NETX_UART_DATA_DATA      = 8,  // [7:0]
	BFW_NETX_UART_DATA_FE        = 1,  // [8]
	BFW_NETX_UART_DATA_PE        = 1,  // [9]
	BFW_NETX_UART_DATA_BE        = 1,  // [10]
	BFW_NETX_UART_DATA_reserved1 = 21  // [31:11]
};

typedef struct UARTDR_BIT_Ttag {
	unsigned int DATA      : BFW_NETX_UART_DATA_DATA;      // data read or written from the interface
	unsigned int FE        : BFW_NETX_UART_DATA_FE;        // Framing Error, read only, mirrored from uartrsr, to handle in DMA-read-out data
	unsigned int PE        : BFW_NETX_UART_DATA_PE;        // Parity Error, read only, mirrored from uartrsr, to handle in DMA-read-out data
	unsigned int BE        : BFW_NETX_UART_DATA_BE;        // Break Error, read only, mirrored from uartrsr, to handle in DMA-read-out data
	unsigned int reserved1 : BFW_NETX_UART_DATA_reserved1; // reserved
} UARTDR_BIT_T;

typedef union {
	unsigned int val;
	UARTDR_BIT_T bf;
} UARTDR_T;

// ---------------------------------------------------------------------
// Register uartrsr
// =>  receive status register (read) / Error Clear Register (write)
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_STAT   0x00000004U
#define NETX_UART0_STAT 0x1C000B04U
#define NETX_UART1_STAT 0x1C000B44U
#define NETX_UART2_STAT 0x1C000B84U

#define MSK_NETX_UART_STAT_FE 0x00000001U // [0]
#define SRT_NETX_UART_STAT_FE 0
#define MSK_NETX_UART_STAT_PE 0x00000002U // [1]
#define SRT_NETX_UART_STAT_PE 1
#define MSK_NETX_UART_STAT_BE 0x00000004U // [2]
#define SRT_NETX_UART_STAT_BE 2
#define MSK_NETX_UART_STAT_OE 0x00000008U // [3]
#define SRT_NETX_UART_STAT_OE 3

enum {
	BFW_NETX_UART_STAT_FE        = 1,  // [0]
	BFW_NETX_UART_STAT_PE        = 1,  // [1]
	BFW_NETX_UART_STAT_BE        = 1,  // [2]
	BFW_NETX_UART_STAT_OE        = 1,  // [3]
	BFW_NETX_UART_STAT_reserved1 = 28  // [31:4]
};

typedef struct UARTRSR_BIT_Ttag {
	unsigned int FE        : BFW_NETX_UART_STAT_FE;        // Framing Error
	unsigned int PE        : BFW_NETX_UART_STAT_PE;        // Parity Error
	unsigned int BE        : BFW_NETX_UART_STAT_BE;        // Break Error
	unsigned int OE        : BFW_NETX_UART_STAT_OE;        // Overrun Error
	unsigned int reserved1 : BFW_NETX_UART_STAT_reserved1; // reserved
} UARTRSR_BIT_T;

typedef union {
	unsigned int  val;
	UARTRSR_BIT_T bf;
} UARTRSR_T;

// ---------------------------------------------------------------------
// Register uartlcr_h
// =>  Line control Register, high byte
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_LINE_CTRL   0x00000008U
#define NETX_UART0_LINE_CTRL 0x1C000B08U
#define NETX_UART1_LINE_CTRL 0x1C000B48U
#define NETX_UART2_LINE_CTRL 0x1C000B88U

#define MSK_NETX_UART_LINE_CTRL_BRK  0x00000001U // [0]
#define SRT_NETX_UART_LINE_CTRL_BRK  0
#define MSK_NETX_UART_LINE_CTRL_PEN  0x00000002U // [1]
#define SRT_NETX_UART_LINE_CTRL_PEN  1
#define MSK_NETX_UART_LINE_CTRL_EPS  0x00000004U // [2]
#define SRT_NETX_UART_LINE_CTRL_EPS  2
#define MSK_NETX_UART_LINE_CTRL_STP2 0x00000008U // [3]
#define SRT_NETX_UART_LINE_CTRL_STP2 3
#define MSK_NETX_UART_LINE_CTRL_FEN  0x00000010U // [4]
#define SRT_NETX_UART_LINE_CTRL_FEN  4
#define MSK_NETX_UART_LINE_CTRL_WLEN 0x00000060U // [6:5]
#define SRT_NETX_UART_LINE_CTRL_WLEN 5

enum {
	BFW_NETX_UART_LINE_CTRL_BRK       = 1,  // [0]
	BFW_NETX_UART_LINE_CTRL_PEN       = 1,  // [1]
	BFW_NETX_UART_LINE_CTRL_EPS       = 1,  // [2]
	BFW_NETX_UART_LINE_CTRL_STP2      = 1,  // [3]
	BFW_NETX_UART_LINE_CTRL_FEN       = 1,  // [4]
	BFW_NETX_UART_LINE_CTRL_WLEN      = 2,  // [6:5]
	BFW_NETX_UART_LINE_CTRL_reserved1 = 25  // [31:7]
};

typedef struct UARTLCR_H_BIT_Ttag {
	unsigned int BRK       : BFW_NETX_UART_LINE_CTRL_BRK;       // Send Break
	unsigned int PEN       : BFW_NETX_UART_LINE_CTRL_PEN;       // Parity Enalble
	unsigned int EPS       : BFW_NETX_UART_LINE_CTRL_EPS;       // Even Parity Select
	unsigned int STP2      : BFW_NETX_UART_LINE_CTRL_STP2;      // 2 Stop Bits Select
	unsigned int FEN       : BFW_NETX_UART_LINE_CTRL_FEN;       // FIFO Enable
	unsigned int WLEN      : BFW_NETX_UART_LINE_CTRL_WLEN;      // Word Length
	                                                        //"00" 5 bits
	                                                        //"01" 6 bits
	                                                        //"10" 7 bits
	                                                        //"11" 8 bits
	unsigned int reserved1 : BFW_NETX_UART_LINE_CTRL_reserved1; // reserved
} UARTLCR_H_BIT_T;

typedef union {
	unsigned int    val;
	UARTLCR_H_BIT_T bf;
} UARTLCR_H_T;

// ---------------------------------------------------------------------
// Register uartlcr_m
// =>  Line control Register, middle byte
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_BAUD_DIV_MSB   0x0000000CU
#define NETX_UART0_BAUD_DIV_MSB 0x1C000B0CU
#define NETX_UART1_BAUD_DIV_MSB 0x1C000B4CU
#define NETX_UART2_BAUD_DIV_MSB 0x1C000B8CU

#define MSK_NETX_UART_BAUD_DIV_MSB_BAUDDIVMS 0x000000ffU // [7:0]
#define SRT_NETX_UART_BAUD_DIV_MSB_BAUDDIVMS 0

enum {
	BFW_NETX_UART_BAUD_DIV_MSB_BAUDDIVMS = 8,  // [7:0]
	BFW_NETX_UART_BAUD_DIV_MSB_reserved1 = 24  // [31:8]
};

typedef struct UARTLCR_M_BIT_Ttag {
	unsigned int BAUDDIVMS : BFW_NETX_UART_BAUD_DIV_MSB_BAUDDIVMS; // bauddiv : Baud Divisor Most Significant Byte
	                                                        // use higher byte of bauddiv = (system clk / (16 * baud rate)) - 1
	                                                        // if not alternative settings by register uartcr_2 are done
	unsigned int reserved1 : BFW_NETX_UART_BAUD_DIV_MSB_reserved1; // reserved
} UARTLCR_M_BIT_T;

typedef union {
	unsigned int    val;
	UARTLCR_M_BIT_T bf;
} UARTLCR_M_T;

// ---------------------------------------------------------------------
// Register uartlcr_l
// =>  Line control Register, low byte
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_BAUD_DIV_LSB   0x00000010U
#define NETX_UART0_BAUD_DIV_LSB 0x1C000B10U
#define NETX_UART1_BAUD_DIV_LSB 0x1C000B50U
#define NETX_UART2_BAUD_DIV_LSB 0x1C000B90U

#define MSK_NETX_UART_BAUD_DIV_LSB_BAUDDIVLS 0x000000ffU // [7:0]
#define SRT_NETX_UART_BAUD_DIV_LSB_BAUDDIVLS 0

enum {
	BFW_NETX_UART_BAUD_DIV_LSB_BAUDDIVLS = 8,  // [7:0]
	BFW_NETX_UART_BAUD_DIV_LSB_reserved1 = 24  // [31:8]
};

typedef struct UARTLCR_L_BIT_Ttag {
	unsigned int BAUDDIVLS : BFW_NETX_UART_BAUD_DIV_LSB_BAUDDIVLS; // Baud Divisor Least Significant Byte
	                                                        // use lower byte of bauddiv = (system clk / (16 * baud rate)) - 1
	                                                        // if not alternative settings by register uartcr_2 are done
	unsigned int reserved1 : BFW_NETX_UART_BAUD_DIV_LSB_reserved1; // reserved
} UARTLCR_L_BIT_T;

typedef union {
	unsigned int    val;
	UARTLCR_L_BIT_T bf;
} UARTLCR_L_T;

// ---------------------------------------------------------------------
// Register uartcr
// =>  uart control Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_CTRL   0x00000014U
#define NETX_UART0_CTRL 0x1C000B14U
#define NETX_UART1_CTRL 0x1C000B54U
#define NETX_UART2_CTRL 0x1C000B94U

#define MSK_NETX_UART_CTRL_uartEN     0x00000001U // [0]
#define SRT_NETX_UART_CTRL_uartEN     0
#define MSK_NETX_UART_CTRL_SIREN      0x00000002U // [1]
#define SRT_NETX_UART_CTRL_SIREN      1
#define MSK_NETX_UART_CTRL_SIRLP      0x00000004U // [2]
#define SRT_NETX_UART_CTRL_SIRLP      2
#define MSK_NETX_UART_CTRL_MSIE       0x00000008U // [3]
#define SRT_NETX_UART_CTRL_MSIE       3
#define MSK_NETX_UART_CTRL_RIE        0x00000010U // [4]
#define SRT_NETX_UART_CTRL_RIE        4
#define MSK_NETX_UART_CTRL_TIE        0x00000020U // [5]
#define SRT_NETX_UART_CTRL_TIE        5
#define MSK_NETX_UART_CTRL_RTIE       0x00000040U // [6]
#define SRT_NETX_UART_CTRL_RTIE       6
#define MSK_NETX_UART_CTRL_LBE        0x00000080U // [7]
#define SRT_NETX_UART_CTRL_LBE        7
#define MSK_NETX_UART_CTRL_TX_RX_LOOP 0x00000100U // [8]
#define SRT_NETX_UART_CTRL_TX_RX_LOOP 8

enum {
	BFW_NETX_UART_CTRL_uartEN     = 1,  // [0]
	BFW_NETX_UART_CTRL_SIREN      = 1,  // [1]
	BFW_NETX_UART_CTRL_SIRLP      = 1,  // [2]
	BFW_NETX_UART_CTRL_MSIE       = 1,  // [3]
	BFW_NETX_UART_CTRL_RIE        = 1,  // [4]
	BFW_NETX_UART_CTRL_TIE        = 1,  // [5]
	BFW_NETX_UART_CTRL_RTIE       = 1,  // [6]
	BFW_NETX_UART_CTRL_LBE        = 1,  // [7]
	BFW_NETX_UART_CTRL_TX_RX_LOOP = 1,  // [8]
	BFW_NETX_UART_CTRL_reserved1  = 23  // [31:9]
};

typedef struct UARTCR_BIT_Ttag {
	unsigned int uartEN     : BFW_NETX_UART_CTRL_uartEN;     // uart Enable
	unsigned int SIREN      : BFW_NETX_UART_CTRL_SIREN;      // SIR Enable
	unsigned int SIRLP      : BFW_NETX_UART_CTRL_SIRLP;      // IrDA SIR Low Power Mode
	unsigned int MSIE       : BFW_NETX_UART_CTRL_MSIE;       // Modem Status Interrupt Enable
	unsigned int RIE        : BFW_NETX_UART_CTRL_RIE;        // Receive Interrupt Enable
	unsigned int TIE        : BFW_NETX_UART_CTRL_TIE;        // Transmit Interrupt Enable
	unsigned int RTIE       : BFW_NETX_UART_CTRL_RTIE;       // Receive Timeout Interrupt Enable
	unsigned int LBE        : BFW_NETX_UART_CTRL_LBE;        // Loop Back Enable for IrDA mode
	unsigned int TX_RX_LOOP : BFW_NETX_UART_CTRL_TX_RX_LOOP; // internal loop (TX -> RX) (test purpose only)
	unsigned int reserved1  : BFW_NETX_UART_CTRL_reserved1;  // reserved
} UARTCR_BIT_T;

typedef union {
	unsigned int val;
	UARTCR_BIT_T bf;
} UARTCR_T;

// ---------------------------------------------------------------------
// Register uartfr
// =>  uart Flag Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_UART_FLAG   0x00000018U
#define NETX_UART0_FLAG 0x1C000B18U
#define NETX_UART1_FLAG 0x1C000B58U
#define NETX_UART2_FLAG 0x1C000B98U

#define MSK_NETX_UART_FLAG_CTS  0x00000001U // [0]
#define SRT_NETX_UART_FLAG_CTS  0
#define MSK_NETX_UART_FLAG_DSR  0x00000002U // [1]
#define SRT_NETX_UART_FLAG_DSR  1
#define MSK_NETX_UART_FLAG_DCD  0x00000004U // [2]
#define SRT_NETX_UART_FLAG_DCD  2
#define MSK_NETX_UART_FLAG_BUSY 0x00000008U // [3]
#define SRT_NETX_UART_FLAG_BUSY 3
#define MSK_NETX_UART_FLAG_RXFE 0x00000010U // [4]
#define SRT_NETX_UART_FLAG_RXFE 4
#define MSK_NETX_UART_FLAG_TXFF 0x00000020U // [5]
#define SRT_NETX_UART_FLAG_TXFF 5
#define MSK_NETX_UART_FLAG_RXFF 0x00000040U // [6]
#define SRT_NETX_UART_FLAG_RXFF 6
#define MSK_NETX_UART_FLAG_TXFE 0x00000080U // [7]
#define SRT_NETX_UART_FLAG_TXFE 7

enum {
	BFW_NETX_UART_FLAG_CTS       = 1,  // [0]
	BFW_NETX_UART_FLAG_DSR       = 1,  // [1]
	BFW_NETX_UART_FLAG_DCD       = 1,  // [2]
	BFW_NETX_UART_FLAG_BUSY      = 1,  // [3]
	BFW_NETX_UART_FLAG_RXFE      = 1,  // [4]
	BFW_NETX_UART_FLAG_TXFF      = 1,  // [5]
	BFW_NETX_UART_FLAG_RXFF      = 1,  // [6]
	BFW_NETX_UART_FLAG_TXFE      = 1,  // [7]
	BFW_NETX_UART_FLAG_reserved1 = 24  // [31:8]
};

typedef struct UARTFR_BIT_Ttag {
	unsigned int CTS       : BFW_NETX_UART_FLAG_CTS;       // Clear To Send
	unsigned int DSR       : BFW_NETX_UART_FLAG_DSR;       // Data Set Ready
	unsigned int DCD       : BFW_NETX_UART_FLAG_DCD;       // Data Carrier Detect
	unsigned int BUSY      : BFW_NETX_UART_FLAG_BUSY;      // uart BUSY
	unsigned int RXFE      : BFW_NETX_UART_FLAG_RXFE;      // Receive FIFO Empty
	unsigned int TXFF      : BFW_NETX_UART_FLAG_TXFF;      // Transmit FIFO Full
	unsigned int RXFF      : BFW_NETX_UART_FLAG_RXFF;      // Receive FIFO Full
	unsigned int TXFE      : BFW_NETX_UART_FLAG_TXFE;      // Transmit FIFO Empty
	unsigned int reserved1 : BFW_NETX_UART_FLAG_reserved1; // reserved
} UARTFR_BIT_T;

typedef union {
	unsigned int val;
	UARTFR_BIT_T bf;
} UARTFR_T;

// ---------------------------------------------------------------------
// Register uartiir
// =>  Interrupt Identification (read) / interrupt clear (write)
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_INT_ID   0x0000001CU
#define NETX_UART0_INT_ID 0x1C000B1CU
#define NETX_UART1_INT_ID 0x1C000B5CU
#define NETX_UART2_INT_ID 0x1C000B9CU

#define MSK_NETX_UART_INT_ID_MIS  0x00000001U // [0]
#define SRT_NETX_UART_INT_ID_MIS  0
#define MSK_NETX_UART_INT_ID_RIS  0x00000002U // [1]
#define SRT_NETX_UART_INT_ID_RIS  1
#define MSK_NETX_UART_INT_ID_TIS  0x00000004U // [2]
#define SRT_NETX_UART_INT_ID_TIS  2
#define MSK_NETX_UART_INT_ID_RTIS 0x00000008U // [3]
#define SRT_NETX_UART_INT_ID_RTIS 3

enum {
	BFW_NETX_UART_INT_ID_MIS       = 1,  // [0]
	BFW_NETX_UART_INT_ID_RIS       = 1,  // [1]
	BFW_NETX_UART_INT_ID_TIS       = 1,  // [2]
	BFW_NETX_UART_INT_ID_RTIS      = 1,  // [3]
	BFW_NETX_UART_INT_ID_reserved1 = 28  // [31:4]
};

typedef struct UARTIIR_BIT_Ttag {
	unsigned int MIS       : BFW_NETX_UART_INT_ID_MIS;       // Modem Interrupt Status
	unsigned int RIS       : BFW_NETX_UART_INT_ID_RIS;       // Receive Interrupt Status
	unsigned int TIS       : BFW_NETX_UART_INT_ID_TIS;       // Transmit Interrupt Status
	unsigned int RTIS      : BFW_NETX_UART_INT_ID_RTIS;      // Receive Timeout Interrupt Status
	unsigned int reserved1 : BFW_NETX_UART_INT_ID_reserved1; // reserved
} UARTIIR_BIT_T;

typedef union {
	unsigned int  val;
	UARTIIR_BIT_T bf;
} UARTIIR_T;

// ---------------------------------------------------------------------
// Register uartilpr
// =>  IrDA Low Power Counter Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_IRDA_LO_PWR_CNTR   0x00000020U
#define NETX_UART0_IRDA_LO_PWR_CNTR 0x1C000B20U
#define NETX_UART1_IRDA_LO_PWR_CNTR 0x1C000B60U
#define NETX_UART2_IRDA_LO_PWR_CNTR 0x1C000BA0U

#define MSK_NETX_UART_IRDA_LO_PWR_CNTR_ILPDVSR 0x000000ffU // [7:0]
#define SRT_NETX_UART_IRDA_LO_PWR_CNTR_ILPDVSR 0

enum {
	BFW_NETX_UART_IRDA_LO_PWR_CNTR_ILPDVSR   = 8,  // [7:0]
	BFW_NETX_UART_IRDA_LO_PWR_CNTR_reserved1 = 24  // [31:8]
};

typedef struct UARTILPR_BIT_Ttag {
	unsigned int ILPDVSR   : BFW_NETX_UART_IRDA_LO_PWR_CNTR_ILPDVSR;   // IrDA Low Power Divisor
	unsigned int reserved1 : BFW_NETX_UART_IRDA_LO_PWR_CNTR_reserved1; // reserved
} UARTILPR_BIT_T;

typedef union {
	unsigned int   val;
	UARTILPR_BIT_T bf;
} UARTILPR_T;

// ---------------------------------------------------------------------
// Register uartrts
// =>  RTS Control Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_RTS_CTRL   0x00000024U
#define NETX_UART0_RTS_CTRL 0x1C000B24U
#define NETX_UART1_RTS_CTRL 0x1C000B64U
#define NETX_UART2_RTS_CTRL 0x1C000BA4U

#define MSK_NETX_UART_RTS_CTRL_AUTO    0x00000001U // [0]
#define SRT_NETX_UART_RTS_CTRL_AUTO    0
#define MSK_NETX_UART_RTS_CTRL_RTS     0x00000002U // [1]
#define SRT_NETX_UART_RTS_CTRL_RTS     1
#define MSK_NETX_UART_RTS_CTRL_COUNT   0x00000004U // [2]
#define SRT_NETX_UART_RTS_CTRL_COUNT   2
#define MSK_NETX_UART_RTS_CTRL_MOD2    0x00000008U // [3]
#define SRT_NETX_UART_RTS_CTRL_MOD2    3
#define MSK_NETX_UART_RTS_CTRL_RTS_pol 0x00000010U // [4]
#define SRT_NETX_UART_RTS_CTRL_RTS_pol 4
#define MSK_NETX_UART_RTS_CTRL_CTS_ctr 0x00000020U // [5]
#define SRT_NETX_UART_RTS_CTRL_CTS_ctr 5
#define MSK_NETX_UART_RTS_CTRL_CTS_pol 0x00000040U // [6]
#define SRT_NETX_UART_RTS_CTRL_CTS_pol 6
#define MSK_NETX_UART_RTS_CTRL_STICK   0x00000080U // [7]
#define SRT_NETX_UART_RTS_CTRL_STICK   7

enum {
	BFW_NETX_UART_RTS_CTRL_AUTO      = 1,  // [0]
	BFW_NETX_UART_RTS_CTRL_RTS       = 1,  // [1]
	BFW_NETX_UART_RTS_CTRL_COUNT     = 1,  // [2]
	BFW_NETX_UART_RTS_CTRL_MOD2      = 1,  // [3]
	BFW_NETX_UART_RTS_CTRL_RTS_pol   = 1,  // [4]
	BFW_NETX_UART_RTS_CTRL_CTS_ctr   = 1,  // [5]
	BFW_NETX_UART_RTS_CTRL_CTS_pol   = 1,  // [6]
	BFW_NETX_UART_RTS_CTRL_STICK     = 1,  // [7]
	BFW_NETX_UART_RTS_CTRL_reserved1 = 24  // [31:8]
};

typedef struct UARTRTS_BIT_Ttag {
	unsigned int AUTO      : BFW_NETX_UART_RTS_CTRL_AUTO;      // automatic or controlled by the next bit (RTS)
	unsigned int RTS       : BFW_NETX_UART_RTS_CTRL_RTS;       // if AUTO=0: controlled by this bit
	unsigned int COUNT     : BFW_NETX_UART_RTS_CTRL_COUNT;     // count base: 1=system clocks, 0=time in bauds
	unsigned int MOD2      : BFW_NETX_UART_RTS_CTRL_MOD2;      // mode1/mode2
	unsigned int RTS_pol   : BFW_NETX_UART_RTS_CTRL_RTS_pol;   // RTS polarity: 1=active high
	unsigned int CTS_ctr   : BFW_NETX_UART_RTS_CTRL_CTS_ctr;   // nUARTCTS control
	unsigned int CTS_pol   : BFW_NETX_UART_RTS_CTRL_CTS_pol;   // nUARTCTS polarity: 1=active high
	unsigned int STICK     : BFW_NETX_UART_RTS_CTRL_STICK;     // stick parity
	unsigned int reserved1 : BFW_NETX_UART_RTS_CTRL_reserved1; // reserved
} UARTRTS_BIT_T;

typedef union {
	unsigned int  val;
	UARTRTS_BIT_T bf;
} UARTRTS_T;

// ---------------------------------------------------------------------
// Register uartforerun
// =>  RTS forerun cycles
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_RTS_LEAD_CYC   0x00000028U
#define NETX_UART0_RTS_LEAD_CYC 0x1C000B28U
#define NETX_UART1_RTS_LEAD_CYC 0x1C000B68U
#define NETX_UART2_RTS_LEAD_CYC 0x1C000BA8U

#define MSK_NETX_UART_RTS_LEAD_CYC_FORERUN 0x000000ffU // [7:0]
#define SRT_NETX_UART_RTS_LEAD_CYC_FORERUN 0

enum {
	BFW_NETX_UART_RTS_LEAD_CYC_FORERUN   = 8,  // [7:0]
	BFW_NETX_UART_RTS_LEAD_CYC_reserved1 = 24  // [31:8]
};

typedef struct UARTFORERUN_BIT_Ttag {
	unsigned int FORERUN   : BFW_NETX_UART_RTS_LEAD_CYC_FORERUN;   // number of forerun cycles in system clocks or bauds
	unsigned int reserved1 : BFW_NETX_UART_RTS_LEAD_CYC_reserved1; // reserved
} UARTFORERUN_BIT_T;

typedef union {
	unsigned int      val;
	UARTFORERUN_BIT_T bf;
} UARTFORERUN_T;

// ---------------------------------------------------------------------
// Register uarttrail
// =>  RTS trail cycles
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_RTS_TRAIL_CYC   0x0000002CU
#define NETX_UART0_RTS_TRAIL_CYC 0x1C000B2CU
#define NETX_UART1_RTS_TRAIL_CYC 0x1C000B6CU
#define NETX_UART2_RTS_TRAIL_CYC 0x1C000BACU

#define MSK_NETX_UART_RTS_TRAIL_CYC_TRAIL 0x000000ffU // [7:0]
#define SRT_NETX_UART_RTS_TRAIL_CYC_TRAIL 0

enum {
	BFW_NETX_UART_RTS_TRAIL_CYC_TRAIL     = 8,  // [7:0]
	BFW_NETX_UART_RTS_TRAIL_CYC_reserved1 = 24  // [31:8]
};

typedef struct UARTTRAIL_BIT_Ttag {
	unsigned int TRAIL     : BFW_NETX_UART_RTS_TRAIL_CYC_TRAIL;     // number of trail cycles in system clocks or bauds
	unsigned int reserved1 : BFW_NETX_UART_RTS_TRAIL_CYC_reserved1; // reserved
} UARTTRAIL_BIT_T;

typedef union {
	unsigned int    val;
	UARTTRAIL_BIT_T bf;
} UARTTRAIL_T;

// ---------------------------------------------------------------------
// Register uartdrvout
// =>  Drive Output
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_OUT_DRV_EN   0x00000030U
#define NETX_UART0_OUT_DRV_EN 0x1C000B30U
#define NETX_UART1_OUT_DRV_EN 0x1C000B70U
#define NETX_UART2_OUT_DRV_EN 0x1C000BB0U

#define MSK_NETX_UART_OUT_DRV_EN_DRVTX  0x00000001U // [0]
#define SRT_NETX_UART_OUT_DRV_EN_DRVTX  0
#define MSK_NETX_UART_OUT_DRV_EN_DRVRTS 0x00000002U // [1]
#define SRT_NETX_UART_OUT_DRV_EN_DRVRTS 1

enum {
	BFW_NETX_UART_OUT_DRV_EN_DRVTX     = 1,  // [0]
	BFW_NETX_UART_OUT_DRV_EN_DRVRTS    = 1,  // [1]
	BFW_NETX_UART_OUT_DRV_EN_reserved1 = 30  // [31:2]
};

typedef struct UARTDRVOUT_BIT_Ttag {
	unsigned int DRVTX     : BFW_NETX_UART_OUT_DRV_EN_DRVTX;     // enable driver for TX
	unsigned int DRVRTS    : BFW_NETX_UART_OUT_DRV_EN_DRVRTS;    // enable driver for RTS
	unsigned int reserved1 : BFW_NETX_UART_OUT_DRV_EN_reserved1; // reserved
} UARTDRVOUT_BIT_T;

typedef union {
	unsigned int     val;
	UARTDRVOUT_BIT_T bf;
} UARTDRVOUT_T;

// ---------------------------------------------------------------------
// Register uartcr_2
// =>  Control Register 2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_BAUD_MODE_CTRL   0x00000034U
#define NETX_UART0_BAUD_MODE_CTRL 0x1C000B34U
#define NETX_UART1_BAUD_MODE_CTRL 0x1C000B74U
#define NETX_UART2_BAUD_MODE_CTRL 0x1C000BB4U

#define MSK_NETX_UART_BAUD_MODE_CTRL_Baud_Rate_Mode 0x00000001U // [0]
#define SRT_NETX_UART_BAUD_MODE_CTRL_Baud_Rate_Mode 0

enum {
	BFW_NETX_UART_BAUD_MODE_CTRL_Baud_Rate_Mode = 1,  // [0]
	BFW_NETX_UART_BAUD_MODE_CTRL_reserved1      = 31  // [31:1]
};

typedef struct UARTCR_2_BIT_Ttag {
	unsigned int Baud_Rate_Mode : BFW_NETX_UART_BAUD_MODE_CTRL_Baud_Rate_Mode; // If this bit is set the baud rate is generated more exactly by the following formula:
	                                                        // value = ( (Baud Rate * 16) / System Frequency ) * 2^16  .
	                                                        // You have to write this 16-bit value in register uartlcr_l and uartlcr_m.
	unsigned int reserved1      : BFW_NETX_UART_BAUD_MODE_CTRL_reserved1;      // reserved
} UARTCR_2_BIT_T;

typedef union {
	unsigned int   val;
	UARTCR_2_BIT_T bf;
} UARTCR_2_T;

// ---------------------------------------------------------------------
// Register uartrxiflsel
// =>  RX FIFO trigger level and RX-DMA enable
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_RX_FIFO_IRQ_LVL   0x00000038U
#define NETX_UART0_RX_FIFO_IRQ_LVL 0x1C000B38U
#define NETX_UART1_RX_FIFO_IRQ_LVL 0x1C000B78U
#define NETX_UART2_RX_FIFO_IRQ_LVL 0x1C000BB8U

#define MSK_NETX_UART_RX_FIFO_IRQ_LVL_RXIFLSEL 0x0000001fU // [4:0]
#define SRT_NETX_UART_RX_FIFO_IRQ_LVL_RXIFLSEL 0
#define MSK_NETX_UART_RX_FIFO_IRQ_LVL_RXDMA    0x00000020U // [5]
#define SRT_NETX_UART_RX_FIFO_IRQ_LVL_RXDMA    5

enum {
	BFW_NETX_UART_RX_FIFO_IRQ_LVL_RXIFLSEL  = 5,  // [4:0]
	BFW_NETX_UART_RX_FIFO_IRQ_LVL_RXDMA     = 1,  // [5]
	BFW_NETX_UART_RX_FIFO_IRQ_LVL_reserved1 = 26  // [31:6]
};

typedef struct UARTRXIFLSEL_BIT_Ttag {
	unsigned int RXIFLSEL  : BFW_NETX_UART_RX_FIFO_IRQ_LVL_RXIFLSEL;  //   Choose a number between 1 and 16. It defines the IRQ trigger level of the receive fifo.
	                                                        //   The IRQ (UARTRXINTR) will be set if the number of received bytes in the receive fifo are greater than or equal RXIFLSEL.
	unsigned int RXDMA     : BFW_NETX_UART_RX_FIFO_IRQ_LVL_RXDMA;     //   Enable DMA-requests for RX-fifo-data.
	                                                        //   A request will be generated if RX-FIFO is not empty and uartcr.uartEN (module enable) is set.
	                                                        //   Burst request to DMA-Ctrl will be done if the RX-FIFO contains at least 4 words (set DMA-burst-size to 4)
	                                                        //   If this bit is reset or the module is disabled, DMA-request will also be reset.
	                                                        //   single transfer request: RX-FIFO contains 1 byte or more, burst request: 4 bytes or more
	                                                        //   note: set adr_dmac_chctrl.SBSize = 1 (i.e. burst size: 4) in the DMA module
	unsigned int reserved1 : BFW_NETX_UART_RX_FIFO_IRQ_LVL_reserved1; // reserved
} UARTRXIFLSEL_BIT_T;

typedef union {
	unsigned int       val;
	UARTRXIFLSEL_BIT_T bf;
} UARTRXIFLSEL_T;

// ---------------------------------------------------------------------
// Register uarttxiflsel
// =>  TX FIFO trigger level and TX-DMA enable
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_UART_TX_FIFO_IRQ_LVL   0x0000003CU
#define NETX_UART0_TX_FIFO_IRQ_LVL 0x1C000B3CU
#define NETX_UART1_TX_FIFO_IRQ_LVL 0x1C000B7CU
#define NETX_UART2_TX_FIFO_IRQ_LVL 0x1C000BBCU

#define MSK_NETX_UART_TX_FIFO_IRQ_LVL_TXIFLSEL 0x0000001fU // [4:0]
#define SRT_NETX_UART_TX_FIFO_IRQ_LVL_TXIFLSEL 0
#define MSK_NETX_UART_TX_FIFO_IRQ_LVL_TXDMA    0x00000020U // [5]
#define SRT_NETX_UART_TX_FIFO_IRQ_LVL_TXDMA    5

enum {
	BFW_NETX_UART_TX_FIFO_IRQ_LVL_TXIFLSEL  = 5,  // [4:0]
	BFW_NETX_UART_TX_FIFO_IRQ_LVL_TXDMA     = 1,  // [5]
	BFW_NETX_UART_TX_FIFO_IRQ_LVL_reserved1 = 26  // [31:6]
};

typedef struct UARTTXIFLSEL_BIT_Ttag {
	unsigned int TXIFLSEL  : BFW_NETX_UART_TX_FIFO_IRQ_LVL_TXIFLSEL;  //   Choose a number between 1 and 16. It defines the IRQ trigger level of the transmit fifo.
	                                                        //   The IRQ (UARTTXINTR) will be set if the number of transmitted bytes in the transmit fifo are less than TXIFLSEL.
	unsigned int TXDMA     : BFW_NETX_UART_TX_FIFO_IRQ_LVL_TXDMA;     //   Enable DMA-requests for TX-fifo-data.
	                                                        //   A request will be generated if TX-FIFO is not full and uartcr.uartEN (module enable) is set.
	                                                        //   Burst request to DMA-Ctrl will be done if at least 4 words are writable to the TX-FIFO (set DMA-burst-size to 4)
	                                                        //   If this bit is reset or the module is disabled, DMA-request will also be reset.
	                                                        //   note: set adr_dmac_chctrl.DBSize = 1 (i.e. burst size: 4) in the DMA module
	unsigned int reserved1 : BFW_NETX_UART_TX_FIFO_IRQ_LVL_reserved1; // reserved
} UARTTXIFLSEL_BIT_T;

typedef union {
	unsigned int       val;
	UARTTXIFLSEL_BIT_T bf;
} UARTTXIFLSEL_T;


// =====================================================================
//
// Area of miimu
//
// =====================================================================

#define NETX_MIIMU_AREA	0x1C000C00U

// ---------------------------------------------------------------------
// Register miimu_reg
// =>  MIIMU receive/transmit register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MIIMU_RXTX 0x00000000U
#define NETX_MIIMU_RXTX     0x1C000C00U

#define MSK_NETX_MIIMU_RXTX_miimu_snrdy      0x00000001U // [0]
#define SRT_NETX_MIIMU_RXTX_miimu_snrdy      0
#define MSK_NETX_MIIMU_RXTX_miimu_preamble   0x00000002U // [1]
#define SRT_NETX_MIIMU_RXTX_miimu_preamble   1
#define MSK_NETX_MIIMU_RXTX_miimu_opmode     0x00000004U // [2]
#define SRT_NETX_MIIMU_RXTX_miimu_opmode     2
#define MSK_NETX_MIIMU_RXTX_miimu_mdc_period 0x00000008U // [3]
#define SRT_NETX_MIIMU_RXTX_miimu_mdc_period 3
#define MSK_NETX_MIIMU_RXTX_phy_nres         0x00000010U // [4]
#define SRT_NETX_MIIMU_RXTX_phy_nres         4
#define MSK_NETX_MIIMU_RXTX_miimu_rta        0x00000020U // [5]
#define SRT_NETX_MIIMU_RXTX_miimu_rta        5
#define MSK_NETX_MIIMU_RXTX_miimu_regaddr    0x000007c0U // [10:6]
#define SRT_NETX_MIIMU_RXTX_miimu_regaddr    6
#define MSK_NETX_MIIMU_RXTX_miimu_phyaddr    0x0000f800U // [15:11]
#define SRT_NETX_MIIMU_RXTX_miimu_phyaddr    11
#define MSK_NETX_MIIMU_RXTX_miimu_data       0xffff0000U // [31:16]
#define SRT_NETX_MIIMU_RXTX_miimu_data       16

enum {
	BFW_NETX_MIIMU_RXTX_miimu_snrdy      = 1,  // [0]
	BFW_NETX_MIIMU_RXTX_miimu_preamble   = 1,  // [1]
	BFW_NETX_MIIMU_RXTX_miimu_opmode     = 1,  // [2]
	BFW_NETX_MIIMU_RXTX_miimu_mdc_period = 1,  // [3]
	BFW_NETX_MIIMU_RXTX_phy_nres         = 1,  // [4]
	BFW_NETX_MIIMU_RXTX_miimu_rta        = 1,  // [5]
	BFW_NETX_MIIMU_RXTX_miimu_regaddr    = 5,  // [10:6]
	BFW_NETX_MIIMU_RXTX_miimu_phyaddr    = 5,  // [15:11]
	BFW_NETX_MIIMU_RXTX_miimu_data       = 16  // [31:16]
};

typedef struct MIIMU_REG_BIT_Ttag {
	unsigned int miimu_snrdy      : BFW_NETX_MIIMU_RXTX_miimu_snrdy;      // start not ready
	unsigned int miimu_preamble   : BFW_NETX_MIIMU_RXTX_miimu_preamble;   // send preamble
	unsigned int miimu_opmode     : BFW_NETX_MIIMU_RXTX_miimu_opmode;     // operation mode
	                                                        // 1..write
	                                                        // 0..read
	unsigned int miimu_mdc_period : BFW_NETX_MIIMU_RXTX_miimu_mdc_period; // mdc period
	                                                        // 1..800ns
	                                                        // 0..400ns
	unsigned int phy_nres         : BFW_NETX_MIIMU_RXTX_phy_nres;         // phy hardware nReset (activ low!)
	                                                        // If this bit and the miimu_snrdy-bit ist set, the phys will be hardware-reseted.
	                                                        // No data will be transmitted in this case.
	                                                        // After reset the miimu-controller will set this bit to 1 again.
	unsigned int miimu_rta        : BFW_NETX_MIIMU_RXTX_miimu_rta;        // read turn around field
	                                                        // 0.. one bit
	                                                        // 1.. two bits
	unsigned int miimu_regaddr    : BFW_NETX_MIIMU_RXTX_miimu_regaddr;    // register address
	unsigned int miimu_phyaddr    : BFW_NETX_MIIMU_RXTX_miimu_phyaddr;    // phy address
	unsigned int miimu_data       : BFW_NETX_MIIMU_RXTX_miimu_data;       // data to or from phy register
} MIIMU_REG_BIT_T;

typedef union {
	unsigned int    val;
	MIIMU_REG_BIT_T bf;
} MIIMU_REG_T;

// ---------------------------------------------------------------------
// Register miimu_sw_en
// =>  MIIMU software mode enable register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MIIMU_MODE_EN 0x00000004U
#define NETX_MIIMU_MODE_EN     0x1C000C04U

#define MSK_NETX_MIIMU_MODE_EN_miimu_sw_en 0x00000001U // [0]
#define SRT_NETX_MIIMU_MODE_EN_miimu_sw_en 0

enum {
	BFW_NETX_MIIMU_MODE_EN_miimu_sw_en = 1,  // [0]
	BFW_NETX_MIIMU_MODE_EN_reserved1   = 31  // [31:1]
};

typedef struct MIIMU_SW_EN_BIT_Ttag {
	unsigned int miimu_sw_en : BFW_NETX_MIIMU_MODE_EN_miimu_sw_en; // enables software mode
	                                                        // mdc, mdo and mdoe have to set by software
	                                                        // the current md_in value can read from miimu_sw_mdi
	unsigned int reserved1   : BFW_NETX_MIIMU_MODE_EN_reserved1;   // reserved
} MIIMU_SW_EN_BIT_T;

typedef union {
	unsigned int      val;
	MIIMU_SW_EN_BIT_T bf;
} MIIMU_SW_EN_T;

// ---------------------------------------------------------------------
// Register miimu_sw_mdc
// =>  MIIMU software mode MDC register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MIIMU_MODE_MDC 0x00000008U
#define NETX_MIIMU_MODE_MDC     0x1C000C08U

#define MSK_NETX_MIIMU_MODE_MDC_miimu_sw_mdc 0x00000001U // [0]
#define SRT_NETX_MIIMU_MODE_MDC_miimu_sw_mdc 0

enum {
	BFW_NETX_MIIMU_MODE_MDC_miimu_sw_mdc = 1,  // [0]
	BFW_NETX_MIIMU_MODE_MDC_reserved1    = 31  // [31:1]
};

typedef struct MIIMU_SW_MDC_BIT_Ttag {
	unsigned int miimu_sw_mdc : BFW_NETX_MIIMU_MODE_MDC_miimu_sw_mdc; // MDC value for software mode
	unsigned int reserved1    : BFW_NETX_MIIMU_MODE_MDC_reserved1;    // reserved
} MIIMU_SW_MDC_BIT_T;

typedef union {
	unsigned int       val;
	MIIMU_SW_MDC_BIT_T bf;
} MIIMU_SW_MDC_T;

// ---------------------------------------------------------------------
// Register miimu_sw_mdo
// =>  MIIMU software mode MDO register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MIIMU_MODE_MDO 0x0000000CU
#define NETX_MIIMU_MODE_MDO     0x1C000C0CU

#define MSK_NETX_MIIMU_MODE_MDO_miimu_sw_mdo 0x00000001U // [0]
#define SRT_NETX_MIIMU_MODE_MDO_miimu_sw_mdo 0

enum {
	BFW_NETX_MIIMU_MODE_MDO_miimu_sw_mdo = 1,  // [0]
	BFW_NETX_MIIMU_MODE_MDO_reserved1    = 31  // [31:1]
};

typedef struct MIIMU_SW_MDO_BIT_Ttag {
	unsigned int miimu_sw_mdo : BFW_NETX_MIIMU_MODE_MDO_miimu_sw_mdo; // MDO value for software mode
	unsigned int reserved1    : BFW_NETX_MIIMU_MODE_MDO_reserved1;    // reserved
} MIIMU_SW_MDO_BIT_T;

typedef union {
	unsigned int       val;
	MIIMU_SW_MDO_BIT_T bf;
} MIIMU_SW_MDO_T;

// ---------------------------------------------------------------------
// Register miimu_sw_mdoe
// =>  MIIMU software mode MDOE register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MIIMU_MODE_MDOE 0x00000010U
#define NETX_MIIMU_MODE_MDOE     0x1C000C10U

#define MSK_NETX_MIIMU_MODE_MDOE_miimu_sw_mdoe 0x00000001U // [0]
#define SRT_NETX_MIIMU_MODE_MDOE_miimu_sw_mdoe 0

enum {
	BFW_NETX_MIIMU_MODE_MDOE_miimu_sw_mdoe = 1,  // [0]
	BFW_NETX_MIIMU_MODE_MDOE_reserved1     = 31  // [31:1]
};

typedef struct MIIMU_SW_MDOE_BIT_Ttag {
	unsigned int miimu_sw_mdoe : BFW_NETX_MIIMU_MODE_MDOE_miimu_sw_mdoe; // MDOE value for software mode
	unsigned int reserved1     : BFW_NETX_MIIMU_MODE_MDOE_reserved1;     // reserved
} MIIMU_SW_MDOE_BIT_T;

typedef union {
	unsigned int        val;
	MIIMU_SW_MDOE_BIT_T bf;
} MIIMU_SW_MDOE_T;

// ---------------------------------------------------------------------
// Register miimu_sw_mdi
// =>  MIIMU software mode MDI register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_MIIMU_MODE_MDI 0x00000014U
#define NETX_MIIMU_MODE_MDI     0x1C000C14U

#define MSK_NETX_MIIMU_MODE_MDI_miimu_sw_mdi 0x00000001U // [0]
#define SRT_NETX_MIIMU_MODE_MDI_miimu_sw_mdi 0

enum {
	BFW_NETX_MIIMU_MODE_MDI_miimu_sw_mdi = 1,  // [0]
	BFW_NETX_MIIMU_MODE_MDI_reserved1    = 31  // [31:1]
};

typedef struct MIIMU_SW_MDI_BIT_Ttag {
	unsigned int miimu_sw_mdi : BFW_NETX_MIIMU_MODE_MDI_miimu_sw_mdi; // current MDI value
	unsigned int reserved1    : BFW_NETX_MIIMU_MODE_MDI_reserved1;    // reserved
} MIIMU_SW_MDI_BIT_T;

typedef union {
	unsigned int       val;
	MIIMU_SW_MDI_BIT_T bf;
} MIIMU_SW_MDI_T;


// =====================================================================
//
// Area of spi0, spi1
//
// =====================================================================

#define NETX_SPI0_AREA	0x1C000D00U
#define NETX_SPI1_AREA	0x1C000D40U

// ---------------------------------------------------------------------
// Register spi_cr0
// =>  spi control register 0
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_CTRL0  0x00000000U
#define NETX_SPI0_CTRL0 0x1C000D00U
#define NETX_SPI1_CTRL0 0x1C000D40U

#define MSK_NETX_SPI_CTRL0_datasize        0x0000000fU // [3:0]
#define SRT_NETX_SPI_CTRL0_datasize        0
#define MSK_NETX_SPI_CTRL0_SPO             0x00000040U // [6]
#define SRT_NETX_SPI_CTRL0_SPO             6
#define MSK_NETX_SPI_CTRL0_SPH             0x00000080U // [7]
#define SRT_NETX_SPI_CTRL0_SPH             7
#define MSK_NETX_SPI_CTRL0_sck_muladd      0x000fff00U // [19:8]
#define SRT_NETX_SPI_CTRL0_sck_muladd      8
#define MSK_NETX_SPI_CTRL0_format          0x03000000U // [25:24]
#define SRT_NETX_SPI_CTRL0_format          24
#define MSK_NETX_SPI_CTRL0_filter_in       0x08000000U // [27]
#define SRT_NETX_SPI_CTRL0_filter_in       27
#define MSK_NETX_SPI_CTRL0_slave_sig_early 0x10000000U // [28]
#define SRT_NETX_SPI_CTRL0_slave_sig_early 28
#define MSK_NETX_SPI_CTRL0_netx100_comp    0x80000000U // [31]
#define SRT_NETX_SPI_CTRL0_netx100_comp    31

enum {
	BFW_NETX_SPI_CTRL0_datasize        = 4,  // [3:0]
	BFW_NETX_SPI_CTRL0_reserved1       = 2,  // [5:4]
	BFW_NETX_SPI_CTRL0_SPO             = 1,  // [6]
	BFW_NETX_SPI_CTRL0_SPH             = 1,  // [7]
	BFW_NETX_SPI_CTRL0_sck_muladd      = 12, // [19:8]
	BFW_NETX_SPI_CTRL0_reserved2       = 4,  // [23:20]
	BFW_NETX_SPI_CTRL0_format          = 2,  // [25:24]
	BFW_NETX_SPI_CTRL0_reserved3       = 1,  // [26]
	BFW_NETX_SPI_CTRL0_filter_in       = 1,  // [27]
	BFW_NETX_SPI_CTRL0_slave_sig_early = 1,  // [28]
	BFW_NETX_SPI_CTRL0_reserved4       = 2,  // [30:29]
	BFW_NETX_SPI_CTRL0_netx100_comp    = 1   // [31]
};

typedef struct SPI_CR0_BIT_Ttag {
	unsigned int datasize        : BFW_NETX_SPI_CTRL0_datasize;        // DSS: data size select (transfer size = datasize + 1 bits)
	                                                        // 0000...0010: reserved
	                                                        // 0011:  4 bit
	                                                        // 0100:  5 bit
	                                                        // ...
	                                                        // 0111:  8 bit
	                                                        // ...
	                                                        // 1111: 16 bit
	unsigned int reserved1       : BFW_NETX_SPI_CTRL0_reserved1;       // reserved
	unsigned int SPO             : BFW_NETX_SPI_CTRL0_SPO;             // serial clock polarity (netx500: CR_cpol)
	                                                        // 0: idle: clock is low, first edge is rising
	                                                        // 1: idle: clock is high, first edge is falling
	unsigned int SPH             : BFW_NETX_SPI_CTRL0_SPH;             // serial clock phase (netx500: CR_ncpha)
	                                                        // 1: sample data at second clock edge edge, data is generated half a clock phase before sampling
	                                                        // 0: sample data at first clock edge edge, data is generated half a clock phase before sampling
	unsigned int sck_muladd      : BFW_NETX_SPI_CTRL0_sck_muladd;      // serial clock rate multiply add value for master spi_sck generation
	                                                        // spi_sck-frequency: f_spi_sck = (sck_muladd * 100)/4096 [MHz]
	                                                        // in slave-mode SPI-clock must not exceed (system-frequency/4) if correct data sampling should be always guaranteed.
	unsigned int reserved2       : BFW_NETX_SPI_CTRL0_reserved2;       // reserved
	unsigned int format          : BFW_NETX_SPI_CTRL0_format;          // frame format
	                                                        // 00: Motorola SPI frame format
	                                                        // 01..11: reserved
	unsigned int reserved3       : BFW_NETX_SPI_CTRL0_reserved3;       // reserved
	unsigned int filter_in       : BFW_NETX_SPI_CTRL0_filter_in;       // Receive-data is sampled every 10ns (100MHz sysem clock). If this bit is set, the
	                                                        // stored receive value will be the result of a majority decision of the three sampling points
	                                                        // around a SPI-clock edge (if two or more '1s! were sampled a '1' will be stored, else a '0' will
	                                                        // be stored. In slave mode FSS and SPI-clock edges will also be detected by oversampling if this bit is set:
	                                                        // An edge will be detected if the majority-result of thre subsequent sampled values toggles.
	                                                        // Input filtering should be used for sck_muladd<=0x200 (i.e. below 12.5MHz). For higher frequencies
	                                                        // stable signal phases are too short.
	unsigned int slave_sig_early : BFW_NETX_SPI_CTRL0_slave_sig_early; // Generate MISO in slavemode 1 spi_sck clock edge earlier than Spec-defined.
	                                                        // This is to compensate Pad/sampling-delays on fast data rates.
	                                                        // If filter_in is enabled, it takes in worst case 3 system clocks to generate MISO after SCK.
	                                                        // If filter_in is disabled, it takes in worst case 2 system clocks to generate MISO after SCK.
	unsigned int reserved4       : BFW_NETX_SPI_CTRL0_reserved4;       // reserved
	unsigned int netx100_comp    : BFW_NETX_SPI_CTRL0_netx100_comp;    // use netx100/500-compatible SPI mode:
	                                                        // 0: start transfer after writing data
	                                                        // 1: start transfer after setting CR_write or CR_read
} SPI_CR0_BIT_T;

typedef union {
	unsigned int  val;
	SPI_CR0_BIT_T bf;
} SPI_CR0_T;

// ---------------------------------------------------------------------
// Register spi_cr1
// =>  spi control register 0
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_CTRL1  0x00000004U
#define NETX_SPI0_CTRL1 0x1C000D04U
#define NETX_SPI1_CTRL1 0x1C000D44U

#define MSK_NETX_SPI_CTRL1_LBM         0x00000001U // [0]
#define SRT_NETX_SPI_CTRL1_LBM         0
#define MSK_NETX_SPI_CTRL1_SSE         0x00000002U // [1]
#define SRT_NETX_SPI_CTRL1_SSE         1
#define MSK_NETX_SPI_CTRL1_MS          0x00000004U // [2]
#define SRT_NETX_SPI_CTRL1_MS          2
#define MSK_NETX_SPI_CTRL1_SOD         0x00000008U // [3]
#define SRT_NETX_SPI_CTRL1_SOD         3
#define MSK_NETX_SPI_CTRL1_fss         0x00000700U // [10:8]
#define SRT_NETX_SPI_CTRL1_fss         8
#define MSK_NETX_SPI_CTRL1_fss_static  0x00000800U // [11]
#define SRT_NETX_SPI_CTRL1_fss_static  11
#define MSK_NETX_SPI_CTRL1_tx_fifo_wm  0x000f0000U // [19:16]
#define SRT_NETX_SPI_CTRL1_tx_fifo_wm  16
#define MSK_NETX_SPI_CTRL1_tx_fifo_clr 0x00100000U // [20]
#define SRT_NETX_SPI_CTRL1_tx_fifo_clr 20
#define MSK_NETX_SPI_CTRL1_rx_fifo_wm  0x0f000000U // [27:24]
#define SRT_NETX_SPI_CTRL1_rx_fifo_wm  24
#define MSK_NETX_SPI_CTRL1_rx_fifo_clr 0x10000000U // [28]
#define SRT_NETX_SPI_CTRL1_rx_fifo_clr 28

enum {
	BFW_NETX_SPI_CTRL1_LBM         = 1, // [0]
	BFW_NETX_SPI_CTRL1_SSE         = 1, // [1]
	BFW_NETX_SPI_CTRL1_MS          = 1, // [2]
	BFW_NETX_SPI_CTRL1_SOD         = 1, // [3]
	BFW_NETX_SPI_CTRL1_reserved1   = 4, // [7:4]
	BFW_NETX_SPI_CTRL1_fss         = 3, // [10:8]
	BFW_NETX_SPI_CTRL1_fss_static  = 1, // [11]
	BFW_NETX_SPI_CTRL1_reserved2   = 4, // [15:12]
	BFW_NETX_SPI_CTRL1_tx_fifo_wm  = 4, // [19:16]
	BFW_NETX_SPI_CTRL1_tx_fifo_clr = 1, // [20]
	BFW_NETX_SPI_CTRL1_reserved3   = 3, // [23:21]
	BFW_NETX_SPI_CTRL1_rx_fifo_wm  = 4, // [27:24]
	BFW_NETX_SPI_CTRL1_rx_fifo_clr = 1, // [28]
	BFW_NETX_SPI_CTRL1_reserved4   = 3  // [31:29]
};

typedef struct SPI_CR1_BIT_Ttag {
	unsigned int LBM         : BFW_NETX_SPI_CTRL1_LBM;         // loop back mode
	                                                        // 0: internal loop back disabled
	                                                        // 1: internal loop back enabled, spi_cr0.filter_in must be set for loopback function
	unsigned int SSE         : BFW_NETX_SPI_CTRL1_SSE;         // SPI enable.
	                                                        // 0: interface disabled
	                                                        // 1: interface enabled
	unsigned int MS          : BFW_NETX_SPI_CTRL1_MS;          // mode select:
	                                                        // 0: device is configured as master
	                                                        // 1: device is configured as slave
	unsigned int SOD         : BFW_NETX_SPI_CTRL1_SOD;         // slave mode output disable (to connect multibe slaves to opne master)
	                                                        // 0: SPI-MISO can be driven in slave mode
	                                                        // 1: SPI-MISO is not driven in slave mode
	unsigned int reserved1   : BFW_NETX_SPI_CTRL1_reserved1;   // reserved
	unsigned int fss         : BFW_NETX_SPI_CTRL1_fss;         // extended: Frame or slave select (up to 3 devices can be assigned directly,
	                                                        // up to 8 devices can be assigned if an external demultiplexer is used if device is master.
	                                                        // For active low slave select (e.g. Motorola SPI frame format) the bits will be inverted before output.
	                                                        // If device is slave, the programmed value is a mask to selet which slave-fss-input should be considered.
	                                                        // e.g.: "010" : fss[1] is slave frame or select input.
	unsigned int fss_static  : BFW_NETX_SPI_CTRL1_fss_static;  // SPI static chipselect
	                                                        // 0: SPI-chipselect will be toggled automatically at data frame begin/end according to fss and FRF0
	                                                        // 1: SPI-chipselect will be set statically according to fss and FRF0
	                                                        // If fss is set to statically, fss must be toggled manually after each data frame in Motorola SPI mode when
	                                                        // SPH is 0 for spec compatibility!
	unsigned int reserved2   : BFW_NETX_SPI_CTRL1_reserved2;   // reserved
	unsigned int tx_fifo_wm  : BFW_NETX_SPI_CTRL1_tx_fifo_wm;  // transmit FIFO watermark for IRQ-generation
	unsigned int tx_fifo_clr : BFW_NETX_SPI_CTRL1_tx_fifo_clr; // extended: writing "1" to this bit will clear the transmit-FIFOs
	                                                        // There must be at least 1 system-clock idle after clear before writing new data to the FIFO.
	unsigned int reserved3   : BFW_NETX_SPI_CTRL1_reserved3;   // reserved
	unsigned int rx_fifo_wm  : BFW_NETX_SPI_CTRL1_rx_fifo_wm;  // receive FIFO watermark for IRQ-generation
	unsigned int rx_fifo_clr : BFW_NETX_SPI_CTRL1_rx_fifo_clr; // extended: writing "1" to this bit will clear the receive-FIFOs
	unsigned int reserved4   : BFW_NETX_SPI_CTRL1_reserved4;   // reserved
} SPI_CR1_BIT_T;

typedef union {
	unsigned int  val;
	SPI_CR1_BIT_T bf;
} SPI_CR1_T;

// ---------------------------------------------------------------------
// Register spi_dr
// =>  spi data register (DR)
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     read access: received data byte is delivered from receive FIFO
//     write access: send data byte is written to send FIFO
//     Both, receive and transmit FIFO have a depth of 16.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_DATA  0x00000008U
#define NETX_SPI0_DATA 0x1C000D08U
#define NETX_SPI1_DATA 0x1C000D48U

#define MSK_NETX_SPI_DATA_data 0x0001ffffU // [16:0]
#define SRT_NETX_SPI_DATA_data 0

enum {
	BFW_NETX_SPI_DATA_data      = 17, // [16:0]
	BFW_NETX_SPI_DATA_reserved1 = 15  // [31:17]
};

typedef struct SPI_DR_BIT_Ttag {
	unsigned int data      : BFW_NETX_SPI_DATA_data;      // Transmit data, must be right aligned on writing, only bits according to spi_cr0.DSS are considered
	                                                        // Receive data will be delivered right aligned, unused bits (spi_cr0.DSS < 0xF) will be "0".
	                                                        // In slavemode transmit data is requested from the FIFO when the last bit of the current
	                                                        // transfer-word ist set to spi_miso.
	                                                        // If no next transimt data could be read from the FIFO until current words last bit was transfered,
	                                                        // FIFO underrun will occure if FSS does not go inactive (last word was transfer end) at the next detected spi_sck-edge.
	unsigned int reserved1 : BFW_NETX_SPI_DATA_reserved1; // reserved
} SPI_DR_BIT_T;

typedef union {
	unsigned int val;
	SPI_DR_BIT_T bf;
} SPI_DR_T;

// ---------------------------------------------------------------------
// Register spi_sr
// =>  read only spi status register
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     SPI master mode: MISO-input-data will be stored in the receive FIFO, transmit FIFO generates MOSI-output-data
//     SPI slave mode: MOSI-input-data will be stored in the receive FIFO, transmit FIFO generates MISO-output-data
//     Shows the current status of the spi interface.
//     Both, receive and transmit FIFO have a depth of 16.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_SPI_STAT  0x0000000CU
#define NETX_SPI0_STAT 0x1C000D0CU
#define NETX_SPI1_STAT 0x1C000D4CU

#define MSK_NETX_SPI_STAT_TFE              0x00000001U // [0]
#define SRT_NETX_SPI_STAT_TFE              0
#define MSK_NETX_SPI_STAT_TNF              0x00000002U // [1]
#define SRT_NETX_SPI_STAT_TNF              1
#define MSK_NETX_SPI_STAT_RNE              0x00000004U // [2]
#define SRT_NETX_SPI_STAT_RNE              2
#define MSK_NETX_SPI_STAT_RFF              0x00000008U // [3]
#define SRT_NETX_SPI_STAT_RFF              3
#define MSK_NETX_SPI_STAT_BSY              0x00000010U // [4]
#define SRT_NETX_SPI_STAT_BSY              4
#define MSK_NETX_SPI_STAT_tx_fifo_level    0x001f0000U // [20:16]
#define SRT_NETX_SPI_STAT_tx_fifo_level    16
#define MSK_NETX_SPI_STAT_tx_fifo_err_ovfl 0x00400000U // [22]
#define SRT_NETX_SPI_STAT_tx_fifo_err_ovfl 22
#define MSK_NETX_SPI_STAT_tx_fifo_err_undr 0x00800000U // [23]
#define SRT_NETX_SPI_STAT_tx_fifo_err_undr 23
#define MSK_NETX_SPI_STAT_rx_fifo_level    0x1f000000U // [28:24]
#define SRT_NETX_SPI_STAT_rx_fifo_level    24
#define MSK_NETX_SPI_STAT_rx_fifo_err_ovfl 0x40000000U // [30]
#define SRT_NETX_SPI_STAT_rx_fifo_err_ovfl 30
#define MSK_NETX_SPI_STAT_rx_fifo_err_undr 0x80000000U // [31]
#define SRT_NETX_SPI_STAT_rx_fifo_err_undr 31

enum {
	BFW_NETX_SPI_STAT_TFE              = 1,  // [0]
	BFW_NETX_SPI_STAT_TNF              = 1,  // [1]
	BFW_NETX_SPI_STAT_RNE              = 1,  // [2]
	BFW_NETX_SPI_STAT_RFF              = 1,  // [3]
	BFW_NETX_SPI_STAT_BSY              = 1,  // [4]
	BFW_NETX_SPI_STAT_reserved1        = 11, // [15:5]
	BFW_NETX_SPI_STAT_tx_fifo_level    = 5,  // [20:16]
	BFW_NETX_SPI_STAT_reserved2        = 1,  // [21]
	BFW_NETX_SPI_STAT_tx_fifo_err_ovfl = 1,  // [22]
	BFW_NETX_SPI_STAT_tx_fifo_err_undr = 1,  // [23]
	BFW_NETX_SPI_STAT_rx_fifo_level    = 5,  // [28:24]
	BFW_NETX_SPI_STAT_reserved3        = 1,  // [29]
	BFW_NETX_SPI_STAT_rx_fifo_err_ovfl = 1,  // [30]
	BFW_NETX_SPI_STAT_rx_fifo_err_undr = 1   // [31]
};

typedef struct SPI_SR_BIT_Ttag {
	unsigned int TFE              : BFW_NETX_SPI_STAT_TFE;              // transmit FIFO is empty (1 if empty)
	unsigned int TNF              : BFW_NETX_SPI_STAT_TNF;              // transmit FIFO is not full (0 if full)
	unsigned int RNE              : BFW_NETX_SPI_STAT_RNE;              // receive FIFO is not empty (0 if empty)
	unsigned int RFF              : BFW_NETX_SPI_STAT_RFF;              // receive FIFO is full (1 if full)
	unsigned int BSY              : BFW_NETX_SPI_STAT_BSY;              // device busy (1 if data is currently transmitted/received or the transmit FIFO is not empty)
	unsigned int reserved1        : BFW_NETX_SPI_STAT_reserved1;        // reserved
	unsigned int tx_fifo_level    : BFW_NETX_SPI_STAT_tx_fifo_level;    // extended: transmit FIFO level (number of words to transmit are left in FIFO)
	unsigned int reserved2        : BFW_NETX_SPI_STAT_reserved2;        // reserved
	unsigned int tx_fifo_err_ovfl : BFW_NETX_SPI_STAT_tx_fifo_err_ovfl; // extended: transmit FIFO overflow error occured, data is lost
	unsigned int tx_fifo_err_undr : BFW_NETX_SPI_STAT_tx_fifo_err_undr; // extended: transmit FIFO underrun error occured, data is lost
	unsigned int rx_fifo_level    : BFW_NETX_SPI_STAT_rx_fifo_level;    // extended: receive FIFO level (number of received words to read out are left in FIFO)
	unsigned int reserved3        : BFW_NETX_SPI_STAT_reserved3;        // reserved
	unsigned int rx_fifo_err_ovfl : BFW_NETX_SPI_STAT_rx_fifo_err_ovfl; // extended: receive FIFO overflow error occured, data is lost
	unsigned int rx_fifo_err_undr : BFW_NETX_SPI_STAT_rx_fifo_err_undr; // extended: receive FIFO underrun error occured, data is lost
} SPI_SR_BIT_T;

typedef union {
	unsigned int val;
	SPI_SR_BIT_T bf;
} SPI_SR_T;

// ---------------------------------------------------------------------
// Register spi_cpsr
// =>  Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     spi clock prescale register
//     No clock predeviding is done.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_CLK_PRE_SCL  0x00000010U
#define NETX_SPI0_CLK_PRE_SCL 0x1C000D10U
#define NETX_SPI1_CLK_PRE_SCL 0x1C000D50U

#define MSK_NETX_SPI_CLK_PRE_SCL_CPSDVSR 0x000000ffU // [7:0]
#define SRT_NETX_SPI_CLK_PRE_SCL_CPSDVSR 0

enum {
	BFW_NETX_SPI_CLK_PRE_SCL_CPSDVSR   = 8,  // [7:0]
	BFW_NETX_SPI_CLK_PRE_SCL_reserved1 = 24  // [31:8]
};

typedef struct SPI_CPSR_BIT_Ttag {
	unsigned int CPSDVSR   : BFW_NETX_SPI_CLK_PRE_SCL_CPSDVSR;   // obsolet
	unsigned int reserved1 : BFW_NETX_SPI_CLK_PRE_SCL_reserved1; // reserved
} SPI_CPSR_BIT_T;

typedef union {
	unsigned int   val;
	SPI_CPSR_BIT_T bf;
} SPI_CPSR_T;

// ---------------------------------------------------------------------
// Register spi_imsc
// =>  spi interrupt mask set or clear register
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     AND-mask
//     Both, receive and transmit FIFO have a depth of 16.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_INT_MSK_SET_CLR  0x00000014U
#define NETX_SPI0_INT_MSK_SET_CLR 0x1C000D14U
#define NETX_SPI1_INT_MSK_SET_CLR 0x1C000D54U

#define MSK_NETX_SPI_INT_MSK_SET_CLR_RORIM  0x00000001U // [0]
#define SRT_NETX_SPI_INT_MSK_SET_CLR_RORIM  0
#define MSK_NETX_SPI_INT_MSK_SET_CLR_RTIM   0x00000002U // [1]
#define SRT_NETX_SPI_INT_MSK_SET_CLR_RTIM   1
#define MSK_NETX_SPI_INT_MSK_SET_CLR_RXIM   0x00000004U // [2]
#define SRT_NETX_SPI_INT_MSK_SET_CLR_RXIM   2
#define MSK_NETX_SPI_INT_MSK_SET_CLR_TXIM   0x00000008U // [3]
#define SRT_NETX_SPI_INT_MSK_SET_CLR_TXIM   3
#define MSK_NETX_SPI_INT_MSK_SET_CLR_rxneim 0x00000010U // [4]
#define SRT_NETX_SPI_INT_MSK_SET_CLR_rxneim 4
#define MSK_NETX_SPI_INT_MSK_SET_CLR_rxfim  0x00000020U // [5]
#define SRT_NETX_SPI_INT_MSK_SET_CLR_rxfim  5
#define MSK_NETX_SPI_INT_MSK_SET_CLR_txeim  0x00000040U // [6]
#define SRT_NETX_SPI_INT_MSK_SET_CLR_txeim  6

enum {
	BFW_NETX_SPI_INT_MSK_SET_CLR_RORIM     = 1,  // [0]
	BFW_NETX_SPI_INT_MSK_SET_CLR_RTIM      = 1,  // [1]
	BFW_NETX_SPI_INT_MSK_SET_CLR_RXIM      = 1,  // [2]
	BFW_NETX_SPI_INT_MSK_SET_CLR_TXIM      = 1,  // [3]
	BFW_NETX_SPI_INT_MSK_SET_CLR_rxneim    = 1,  // [4]
	BFW_NETX_SPI_INT_MSK_SET_CLR_rxfim     = 1,  // [5]
	BFW_NETX_SPI_INT_MSK_SET_CLR_txeim     = 1,  // [6]
	BFW_NETX_SPI_INT_MSK_SET_CLR_reserved1 = 25  // [31:7]
};

typedef struct SPI_IMSC_BIT_Ttag {
	unsigned int RORIM     : BFW_NETX_SPI_INT_MSK_SET_CLR_RORIM;     // receive FIFO overrun interrupt mask
	unsigned int RTIM      : BFW_NETX_SPI_INT_MSK_SET_CLR_RTIM;      // receive timeout interrupt mask
	unsigned int RXIM      : BFW_NETX_SPI_INT_MSK_SET_CLR_RXIM;      // receive FIFO interrupt mask
	unsigned int TXIM      : BFW_NETX_SPI_INT_MSK_SET_CLR_TXIM;      // transmit FIFO interrupt mask
	unsigned int rxneim    : BFW_NETX_SPI_INT_MSK_SET_CLR_rxneim;    // receive FIFO not empty interrupt mask (for netx100/500 compliance)
	unsigned int rxfim     : BFW_NETX_SPI_INT_MSK_SET_CLR_rxfim;     // receive FIFO full interrupt mask (for netx100/500 compliance)
	unsigned int txeim     : BFW_NETX_SPI_INT_MSK_SET_CLR_txeim;     // transmit FIFO empty interrupt mask (for netx100/500 compliance)
	unsigned int reserved1 : BFW_NETX_SPI_INT_MSK_SET_CLR_reserved1; // reserved
} SPI_IMSC_BIT_T;

typedef union {
	unsigned int   val;
	SPI_IMSC_BIT_T bf;
} SPI_IMSC_T;

// ---------------------------------------------------------------------
// Register spi_ris
// =>  spi interrupt state before masking register (raw interrupt)
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     Both, receive and transmit FIFO have a depth of 16.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_SPI_RAW_INT_STAT  0x00000018U
#define NETX_SPI0_RAW_INT_STAT 0x1C000D18U
#define NETX_SPI1_RAW_INT_STAT 0x1C000D58U

#define MSK_NETX_SPI_RAW_INT_STAT_RORRIS  0x00000001U // [0]
#define SRT_NETX_SPI_RAW_INT_STAT_RORRIS  0
#define MSK_NETX_SPI_RAW_INT_STAT_RTRIS   0x00000002U // [1]
#define SRT_NETX_SPI_RAW_INT_STAT_RTRIS   1
#define MSK_NETX_SPI_RAW_INT_STAT_RXRIS   0x00000004U // [2]
#define SRT_NETX_SPI_RAW_INT_STAT_RXRIS   2
#define MSK_NETX_SPI_RAW_INT_STAT_TXRIS   0x00000008U // [3]
#define SRT_NETX_SPI_RAW_INT_STAT_TXRIS   3
#define MSK_NETX_SPI_RAW_INT_STAT_rxneris 0x00000010U // [4]
#define SRT_NETX_SPI_RAW_INT_STAT_rxneris 4
#define MSK_NETX_SPI_RAW_INT_STAT_rxfris  0x00000020U // [5]
#define SRT_NETX_SPI_RAW_INT_STAT_rxfris  5
#define MSK_NETX_SPI_RAW_INT_STAT_txeris  0x00000040U // [6]
#define SRT_NETX_SPI_RAW_INT_STAT_txeris  6

enum {
	BFW_NETX_SPI_RAW_INT_STAT_RORRIS    = 1,  // [0]
	BFW_NETX_SPI_RAW_INT_STAT_RTRIS     = 1,  // [1]
	BFW_NETX_SPI_RAW_INT_STAT_RXRIS     = 1,  // [2]
	BFW_NETX_SPI_RAW_INT_STAT_TXRIS     = 1,  // [3]
	BFW_NETX_SPI_RAW_INT_STAT_rxneris   = 1,  // [4]
	BFW_NETX_SPI_RAW_INT_STAT_rxfris    = 1,  // [5]
	BFW_NETX_SPI_RAW_INT_STAT_txeris    = 1,  // [6]
	BFW_NETX_SPI_RAW_INT_STAT_reserved1 = 25  // [31:7]
};

typedef struct SPI_RIS_BIT_Ttag {
	unsigned int RORRIS    : BFW_NETX_SPI_RAW_INT_STAT_RORRIS;    // unmasked receive FIFO overrun interrupt state
	                                                        // 1: receive FIFO overun error ocuured
	                                                        // 0: no receive FIFO overrun error occured
	unsigned int RTRIS     : BFW_NETX_SPI_RAW_INT_STAT_RTRIS;     // unmasked receive timeout interrupt state
	                                                        // timeout period are 32 SPI-clock periods depending on adr_spi_cr0.SCR
	                                                        // 1: receive FIFO is not empty and not read out in the passed timeout period
	                                                        // 0: receive FIFO is empty or read during the last timout period
	unsigned int RXRIS     : BFW_NETX_SPI_RAW_INT_STAT_RXRIS;     // unmasked receive FIFO interrupt state
	                                                        // 1: receive FIFO is higher than spi_cr1.rx_fifo_wm
	                                                        // 0: receive FIFO is equals or is below spi_cr1.rx_fifo_wm
	unsigned int TXRIS     : BFW_NETX_SPI_RAW_INT_STAT_TXRIS;     // unmasked transmit FIFO interrupt state
	                                                        // 1: transmit FIFO level is below spi_cr1.tx_fifo_wm
	                                                        // 0: transmit FIFO equals or is higher than spi_cr1.tx_fifo_wm
	unsigned int rxneris   : BFW_NETX_SPI_RAW_INT_STAT_rxneris;   // unmasked receive FIFO not empty interrupt state (for netx100/500 compliance)
	                                                        // 1: receive FIFO is not empty
	                                                        // 0: receive FIFO is empty
	unsigned int rxfris    : BFW_NETX_SPI_RAW_INT_STAT_rxfris;    // unmasked receive FIFO full interrupt state (for netx100/500 compliance)
	                                                        // 1: receive FIFO is full
	                                                        // 0: receive FIFO is not full
	unsigned int txeris    : BFW_NETX_SPI_RAW_INT_STAT_txeris;    // unmasked transmit FIFO empty interrupt state (for netx100/500 compliance)
	                                                        // 1: transmit FIFO is empty
	                                                        // 0: transmit FIFO is not empty
	unsigned int reserved1 : BFW_NETX_SPI_RAW_INT_STAT_reserved1; // reserved
} SPI_RIS_BIT_T;

typedef union {
	unsigned int  val;
	SPI_RIS_BIT_T bf;
} SPI_RIS_T;

// ---------------------------------------------------------------------
// Register spi_mis
// =>  spi interrupt status register
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     Both, receive and transmit FIFO have a depth of 16.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_SPI_MSK_INT_STAT  0x0000001CU
#define NETX_SPI0_MSK_INT_STAT 0x1C000D1CU
#define NETX_SPI1_MSK_INT_STAT 0x1C000D5CU

#define MSK_NETX_SPI_MSK_INT_STAT_RORMIS  0x00000001U // [0]
#define SRT_NETX_SPI_MSK_INT_STAT_RORMIS  0
#define MSK_NETX_SPI_MSK_INT_STAT_RTMIS   0x00000002U // [1]
#define SRT_NETX_SPI_MSK_INT_STAT_RTMIS   1
#define MSK_NETX_SPI_MSK_INT_STAT_RXMIS   0x00000004U // [2]
#define SRT_NETX_SPI_MSK_INT_STAT_RXMIS   2
#define MSK_NETX_SPI_MSK_INT_STAT_TXMIS   0x00000008U // [3]
#define SRT_NETX_SPI_MSK_INT_STAT_TXMIS   3
#define MSK_NETX_SPI_MSK_INT_STAT_rxnemis 0x00000010U // [4]
#define SRT_NETX_SPI_MSK_INT_STAT_rxnemis 4
#define MSK_NETX_SPI_MSK_INT_STAT_rxfmis  0x00000020U // [5]
#define SRT_NETX_SPI_MSK_INT_STAT_rxfmis  5
#define MSK_NETX_SPI_MSK_INT_STAT_txemis  0x00000040U // [6]
#define SRT_NETX_SPI_MSK_INT_STAT_txemis  6

enum {
	BFW_NETX_SPI_MSK_INT_STAT_RORMIS    = 1,  // [0]
	BFW_NETX_SPI_MSK_INT_STAT_RTMIS     = 1,  // [1]
	BFW_NETX_SPI_MSK_INT_STAT_RXMIS     = 1,  // [2]
	BFW_NETX_SPI_MSK_INT_STAT_TXMIS     = 1,  // [3]
	BFW_NETX_SPI_MSK_INT_STAT_rxnemis   = 1,  // [4]
	BFW_NETX_SPI_MSK_INT_STAT_rxfmis    = 1,  // [5]
	BFW_NETX_SPI_MSK_INT_STAT_txemis    = 1,  // [6]
	BFW_NETX_SPI_MSK_INT_STAT_reserved1 = 25  // [31:7]
};

typedef struct SPI_MIS_BIT_Ttag {
	unsigned int RORMIS    : BFW_NETX_SPI_MSK_INT_STAT_RORMIS;    // masked receive FIFO overrun interrupt state
	unsigned int RTMIS     : BFW_NETX_SPI_MSK_INT_STAT_RTMIS;     // masked receive timeout interrupt state
	unsigned int RXMIS     : BFW_NETX_SPI_MSK_INT_STAT_RXMIS;     // masked receive FIFO interrupt state
	unsigned int TXMIS     : BFW_NETX_SPI_MSK_INT_STAT_TXMIS;     // masked transmit FIFO interrupt state
	unsigned int rxnemis   : BFW_NETX_SPI_MSK_INT_STAT_rxnemis;   // masked receive FIFO not empty interrupt state (for netx100/500 compliance)
	unsigned int rxfmis    : BFW_NETX_SPI_MSK_INT_STAT_rxfmis;    // masked receive FIFO full interrupt state (for netx100/500 compliance)
	unsigned int txemis    : BFW_NETX_SPI_MSK_INT_STAT_txemis;    // masked transmit FIFO empty interrupt state (for netx100/500 compliance)
	unsigned int reserved1 : BFW_NETX_SPI_MSK_INT_STAT_reserved1; // reserved
} SPI_MIS_BIT_T;

typedef union {
	unsigned int  val;
	SPI_MIS_BIT_T bf;
} SPI_MIS_T;

// ---------------------------------------------------------------------
// Register spi_icr
// =>  spi interrupt clear register
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     interrupt is cleard by writing "1" to the according bit
//     FIFO-state interrupts are cleared automatically if interupt criteria is no longer thrue.
//     Both, receive and transmit FIFO have a depth of 16.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_INT_CLR  0x00000020U
#define NETX_SPI0_INT_CLR 0x1C000D20U
#define NETX_SPI1_INT_CLR 0x1C000D60U

#define MSK_NETX_SPI_INT_CLR_RORIC  0x00000001U // [0]
#define SRT_NETX_SPI_INT_CLR_RORIC  0
#define MSK_NETX_SPI_INT_CLR_RTIC   0x00000002U // [1]
#define SRT_NETX_SPI_INT_CLR_RTIC   1
#define MSK_NETX_SPI_INT_CLR_RXIC   0x00000004U // [2]
#define SRT_NETX_SPI_INT_CLR_RXIC   2
#define MSK_NETX_SPI_INT_CLR_TXIC   0x00000008U // [3]
#define SRT_NETX_SPI_INT_CLR_TXIC   3
#define MSK_NETX_SPI_INT_CLR_rxneic 0x00000010U // [4]
#define SRT_NETX_SPI_INT_CLR_rxneic 4
#define MSK_NETX_SPI_INT_CLR_rxfic  0x00000020U // [5]
#define SRT_NETX_SPI_INT_CLR_rxfic  5
#define MSK_NETX_SPI_INT_CLR_txeic  0x00000040U // [6]
#define SRT_NETX_SPI_INT_CLR_txeic  6

enum {
	BFW_NETX_SPI_INT_CLR_RORIC     = 1,  // [0]
	BFW_NETX_SPI_INT_CLR_RTIC      = 1,  // [1]
	BFW_NETX_SPI_INT_CLR_RXIC      = 1,  // [2]
	BFW_NETX_SPI_INT_CLR_TXIC      = 1,  // [3]
	BFW_NETX_SPI_INT_CLR_rxneic    = 1,  // [4]
	BFW_NETX_SPI_INT_CLR_rxfic     = 1,  // [5]
	BFW_NETX_SPI_INT_CLR_txeic     = 1,  // [6]
	BFW_NETX_SPI_INT_CLR_reserved1 = 25  // [31:7]
};

typedef struct SPI_ICR_BIT_Ttag {
	unsigned int RORIC     : BFW_NETX_SPI_INT_CLR_RORIC;     // clear receive FIFO overrun interrupt
	                                                        // writing '1' here will clear the receive FIFO
	unsigned int RTIC      : BFW_NETX_SPI_INT_CLR_RTIC;      // clear receive FIFO overrun interrupt
	unsigned int RXIC      : BFW_NETX_SPI_INT_CLR_RXIC;      // PL022 extention: clear receive FIFO interrupt
	unsigned int TXIC      : BFW_NETX_SPI_INT_CLR_TXIC;      // PL022 extention: clear transmit FIFO interrupt
	unsigned int rxneic    : BFW_NETX_SPI_INT_CLR_rxneic;    // clear receive FIFO not empty interrupt (for netx100/500 compliance)
	unsigned int rxfic     : BFW_NETX_SPI_INT_CLR_rxfic;     // clear receive FIFO full interrupt (for netx100/500 compliance)
	unsigned int txeic     : BFW_NETX_SPI_INT_CLR_txeic;     // clear transmit FIFO empty interrupt (for netx100/500 compliance)
	unsigned int reserved1 : BFW_NETX_SPI_INT_CLR_reserved1; // reserved
} SPI_ICR_BIT_T;

typedef union {
	unsigned int  val;
	SPI_ICR_BIT_T bf;
} SPI_ICR_T;

// ---------------------------------------------------------------------
// Register spi_dmacr
// =>  spi DMA control register
//     Only single transfer requests will be generated by this module.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_DMA_CTRL  0x00000024U
#define NETX_SPI0_DMA_CTRL 0x1C000D24U
#define NETX_SPI1_DMA_CTRL 0x1C000D64U

#define MSK_NETX_SPI_DMA_CTRL_RXDMAE 0x00000001U // [0]
#define SRT_NETX_SPI_DMA_CTRL_RXDMAE 0
#define MSK_NETX_SPI_DMA_CTRL_TXDMAE 0x00000002U // [1]
#define SRT_NETX_SPI_DMA_CTRL_TXDMAE 1

enum {
	BFW_NETX_SPI_DMA_CTRL_RXDMAE    = 1,  // [0]
	BFW_NETX_SPI_DMA_CTRL_TXDMAE    = 1,  // [1]
	BFW_NETX_SPI_DMA_CTRL_reserved1 = 30  // [31:2]
};

typedef struct SPI_DMACR_BIT_Ttag {
	unsigned int RXDMAE    : BFW_NETX_SPI_DMA_CTRL_RXDMAE;    // enable DMA for SPI-receive data
	                                                        // A request will be generated if RX-FIFO is not empty and spi_cr1.SSE (module enable) is set.
	                                                        // Burst request to DMA-Ctrl will be done if the RX-FIFO contains at least 4 words (set DMA-burst-size to 4)
	                                                        // If this bit is reset or the module is disabled, DMA-request will also be reset.
	                                                        // note: set adr_dmac_chctrl.SBSize = 1 (i.e. burst size: 4) in the DMA module
	unsigned int TXDMAE    : BFW_NETX_SPI_DMA_CTRL_TXDMAE;    // enable DMA for SPI-transmit data
	                                                        // A request will be generated if TX-FIFO is not full and spi_cr1.SSE (module enable) is set.
	                                                        // Burst request to DMA-Ctrl will be done if at least 4 words are writable to the TX-FIFO (set DMA-burst-size to 4)
	                                                        // If this bit is reset or the module is disabled, DMA-request will also be reset.
	                                                        // note: set adr_dmac_chctrl.SBSize = 1 (i.e. burst size: 4) in the DMA module
	unsigned int reserved1 : BFW_NETX_SPI_DMA_CTRL_reserved1; // reserved
} SPI_DMACR_BIT_T;

typedef union {
	unsigned int    val;
	SPI_DMACR_BIT_T bf;
} SPI_DMACR_T;

// ---------------------------------------------------------------------
// Register spi_data_register
// =>  netx100/500 compliant spi data register (DR)
//     Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500
//     2 data bytes with valid bits
//     During write-access data_byte_1 and dr_valid1 must not be used. dr_valid0 must be set.
//     In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software
//     compatible, not more than 8 bytes should be in netx100/500-FIFOs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_COMPATIBLE_DATA  0x00000030U
#define NETX_SPI0_COMPATIBLE_DATA 0x1C000D30U
#define NETX_SPI1_COMPATIBLE_DATA 0x1C000D70U

#define MSK_NETX_SPI_COMPATIBLE_DATA_data_byte_0 0x000000ffU // [7:0]
#define SRT_NETX_SPI_COMPATIBLE_DATA_data_byte_0 0
#define MSK_NETX_SPI_COMPATIBLE_DATA_data_byte_1 0x0000ff00U // [15:8]
#define SRT_NETX_SPI_COMPATIBLE_DATA_data_byte_1 8
#define MSK_NETX_SPI_COMPATIBLE_DATA_dr_valid0   0x00010000U // [16]
#define SRT_NETX_SPI_COMPATIBLE_DATA_dr_valid0   16
#define MSK_NETX_SPI_COMPATIBLE_DATA_dr_valid1   0x00020000U // [17]
#define SRT_NETX_SPI_COMPATIBLE_DATA_dr_valid1   17

enum {
	BFW_NETX_SPI_COMPATIBLE_DATA_data_byte_0 = 8,  // [7:0]
	BFW_NETX_SPI_COMPATIBLE_DATA_data_byte_1 = 8,  // [15:8]
	BFW_NETX_SPI_COMPATIBLE_DATA_dr_valid0   = 1,  // [16]
	BFW_NETX_SPI_COMPATIBLE_DATA_dr_valid1   = 1,  // [17]
	BFW_NETX_SPI_COMPATIBLE_DATA_reserved1   = 14  // [31:18]
};

typedef struct SPI_DATA_REGISTER_BIT_Ttag {
	unsigned int data_byte_0 : BFW_NETX_SPI_COMPATIBLE_DATA_data_byte_0; // data byte 0
	unsigned int data_byte_1 : BFW_NETX_SPI_COMPATIBLE_DATA_data_byte_1; // obsolet, don't use
	unsigned int dr_valid0   : BFW_NETX_SPI_COMPATIBLE_DATA_dr_valid0;   // valid bit for data_byte_0
	                                                        // This bit shows if data_byte_0 Is valid and must be set during FIFO write access
	unsigned int dr_valid1   : BFW_NETX_SPI_COMPATIBLE_DATA_dr_valid1;   // obsolet, always 0
	unsigned int reserved1   : BFW_NETX_SPI_COMPATIBLE_DATA_reserved1;   // reserved
} SPI_DATA_REGISTER_BIT_T;

typedef union {
	unsigned int            val;
	SPI_DATA_REGISTER_BIT_T bf;
} SPI_DATA_REGISTER_T;

// ---------------------------------------------------------------------
// Register spi_status_register
// =>  netx100/500 compliant spi status register (SR):
//     Shows the actual status of the spi interface.
//     Bits 24..18 show occured interrupts,
//     writing ones into these bits deletes the interrupts.
//     Writing into other bits has no effect.
//     In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software
//     compatible, not more than 8 bytes should be in netx100/500-FIFOs.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_SPI_COMPATIBLE_STAT  0x00000034U
#define NETX_SPI0_COMPATIBLE_STAT 0x1C000D34U
#define NETX_SPI1_COMPATIBLE_STAT 0x1C000D74U

#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel_val  0x000001ffU // [8:0]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel_val  0
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel_val 0x0003fe00U // [17:9]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel_val 9
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel      0x00040000U // [18]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel      18
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_in_recdata   0x00080000U // [19]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_in_recdata   19
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_in_full      0x00100000U // [20]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_in_full      20
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel     0x00200000U // [21]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel     21
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_out_fw       0x00400000U // [22]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_out_fw       22
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_out_empty    0x00800000U // [23]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_out_empty    23
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_out_full     0x01000000U // [24]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_out_full     24
#define MSK_NETX_SPI_COMPATIBLE_STAT_SR_selected     0x02000000U // [25]
#define SRT_NETX_SPI_COMPATIBLE_STAT_SR_selected     25

enum {
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel_val  = 9, // [8:0]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel_val = 9, // [17:9]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel      = 1, // [18]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_recdata   = 1, // [19]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_full      = 1, // [20]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel     = 1, // [21]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_fw       = 1, // [22]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_empty    = 1, // [23]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_full     = 1, // [24]
	BFW_NETX_SPI_COMPATIBLE_STAT_SR_selected     = 1, // [25]
	BFW_NETX_SPI_COMPATIBLE_STAT_reserved1       = 6  // [31:26]
};

typedef struct SPI_STATUS_REGISTER_BIT_Ttag {
	unsigned int SR_in_fuel_val  : BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel_val;  // input FIFO fill value (number of bytes)
	unsigned int SR_out_fuel_val : BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel_val; // output FIFO fill vlaue (number of bytes)
	unsigned int SR_in_fuel      : BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_fuel;      // adjustable fill value of input FIFO reached (equals adr_spi_ris.RXRIS in netx50 and later versions)
	unsigned int SR_in_recdata   : BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_recdata;   // valid data bytes in input FIFO (equals adr_spi_ris.rxneris in netx50 and later versions)
	unsigned int SR_in_full      : BFW_NETX_SPI_COMPATIBLE_STAT_SR_in_full;      // input FIFO is full (equals adr_spi_ris.rxfris in netx50 and later versions)
	unsigned int SR_out_fuel     : BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_fuel;     // adjustable fill value of output FIFO reached (equals adr_spi_ris.TXRIS in netx50 and later versions)
	unsigned int SR_out_fw       : BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_fw;       // netx is writing data to fast into output FIFO. This is only with netx100/500 an IRQ.
	                                                        // (equals adr_spi_sr.tx_fifo_err_ovfl in netx50 and later versions)
	unsigned int SR_out_empty    : BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_empty;    // output FIFO is empty in slave mode. (equals adr_spi_ris.txeris in netx50 and later versions)
	unsigned int SR_out_full     : BFW_NETX_SPI_COMPATIBLE_STAT_SR_out_full;     // output FIFO is full
	unsigned int SR_selected     : BFW_NETX_SPI_COMPATIBLE_STAT_SR_selected;     // external master has access to spi-interface
	unsigned int reserved1       : BFW_NETX_SPI_COMPATIBLE_STAT_reserved1;       // reserved
} SPI_STATUS_REGISTER_BIT_T;

typedef union {
	unsigned int              val;
	SPI_STATUS_REGISTER_BIT_T bf;
} SPI_STATUS_REGISTER_T;

// ---------------------------------------------------------------------
// Register spi_control_register
// =>  netx100/500 compliant spi control register (CR)
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_COMPATIBLE_CTRL  0x00000038U
#define NETX_SPI0_COMPATIBLE_CTRL 0x1C000D38U
#define NETX_SPI1_COMPATIBLE_CTRL 0x1C000D78U

#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_softreset   0x00000001U // [0]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_softreset   0
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_speed       0x0000001eU // [4:1]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_speed       1
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_read        0x00000040U // [6]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_read        6
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_write       0x00000080U // [7]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_write       7
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_ss          0x00000700U // [10:8]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_ss          8
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CS_mode        0x00000800U // [11]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CS_mode        11
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_clr_infifo  0x00100000U // [20]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_clr_infifo  20
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_clr_outfifo 0x00200000U // [21]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_clr_outfifo 21
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_burstdelay  0x01c00000U // [24:22]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_burstdelay  22
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_burst       0x0e000000U // [27:25]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_burst       25
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_ncpha       0x10000000U // [28]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_ncpha       28
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_cpol        0x20000000U // [29]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_cpol        29
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_ms          0x40000000U // [30]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_ms          30
#define MSK_NETX_SPI_COMPATIBLE_CTRL_CR_en          0x80000000U // [31]
#define SRT_NETX_SPI_COMPATIBLE_CTRL_CR_en          31

enum {
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_softreset   = 1, // [0]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_speed       = 4, // [4:1]
	BFW_NETX_SPI_COMPATIBLE_CTRL_reserved1      = 1, // [5]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_read        = 1, // [6]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_write       = 1, // [7]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_ss          = 3, // [10:8]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CS_mode        = 1, // [11]
	BFW_NETX_SPI_COMPATIBLE_CTRL_reserved2      = 8, // [19:12]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_clr_infifo  = 1, // [20]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_clr_outfifo = 1, // [21]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_burstdelay  = 3, // [24:22]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_burst       = 3, // [27:25]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_ncpha       = 1, // [28]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_cpol        = 1, // [29]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_ms          = 1, // [30]
	BFW_NETX_SPI_COMPATIBLE_CTRL_CR_en          = 1  // [31]
};

typedef struct SPI_CONTROL_REGISTER_BIT_Ttag {
	unsigned int CR_softreset   : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_softreset;   // write only: no function in netx100/netx500; later Versions: clears IRQs and FIFOs
	unsigned int CR_speed       : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_speed;       // clock devider for SPI clock (2 - 2^16)
	                                                        // If SPI Clock-rate is changed by adr_spi_cr0.SCR, this value will not be updated an may be incorrect
	                                                        // There are 15 different SPI Clocks to choose:
	                                                        // 0001: 0,05 MHz  netx100/netx500 only, later Versions: system-frequency/512 (i.e: 0,195MHz)
	                                                        // 0010: 0,1 MHz   netx100/netx500 only, later Versions: system-frequency/512 (i.e: 0,195MHz)
	                                                        // 0011: 0,2 MHz
	                                                        // 0100: 0,5 MHz
	                                                        // 0101: 1 MHz
	                                                        // 0110: 1,25 MHz
	                                                        // 0111: 2 MHz
	                                                        // 1000: 2,5 MHz
	                                                        // 1001: 3,3333 MHz
	                                                        // 1010: 5 MHz
	                                                        // 1011:10 MHz
	                                                        // 1100:12,5 MHz
	                                                        // 1101:16,6666 MHz
	                                                        // 1110:25 MHz
	                                                        // 1111:50 MHz
	unsigned int reserved1      : BFW_NETX_SPI_COMPATIBLE_CTRL_reserved1;      // reserved
	unsigned int CR_read        : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_read;        // netx100/netx500 only, in later versions always "1":  1: enable spi interface read data
	unsigned int CR_write       : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_write;       // netx100/netx500 only, in later versions always "1":  1: enable spi interface write data
	unsigned int CR_ss          : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_ss;          // external slave select
	unsigned int CS_mode        : BFW_NETX_SPI_COMPATIBLE_CTRL_CS_mode;        // 1: chip select is generated automatically by the internal state machine
	                                                        // 0: chip select is directly controlled by software (see bits CR_ss).
	unsigned int reserved2      : BFW_NETX_SPI_COMPATIBLE_CTRL_reserved2;      // reserved
	unsigned int CR_clr_infifo  : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_clr_infifo;  // clear input FIFO
	unsigned int CR_clr_outfifo : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_clr_outfifo; // clear output FIFO
	unsigned int CR_burstdelay  : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_burstdelay;  // netx100/netx500 only, obsolet in later versions: delay between transmittion of 2 data bytes
	                                                        // (0 to 7 SCK cycles)
	unsigned int CR_burst       : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_burst;       // netx100/netx500 only, obsolet in later versions: burst lenght = 2^CR_burst
	unsigned int CR_ncpha       : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_ncpha;       // relative to CR_cpol
	                                                        // 1:change data to primary spi_sck edge
	                                                        //   data are active to secondary spi_sck edge
	                                                        // 1:change data to secondary spi_sck edge
	                                                        //   data are active to primary spi_sck edge
	unsigned int CR_cpol        : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_cpol;        // 1:falling edge of spi_sck is primary
	                                                        // 0:rising edge of spi_sck is primary
	unsigned int CR_ms          : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_ms;          // 1:master mode 0:slave mode
	unsigned int CR_en          : BFW_NETX_SPI_COMPATIBLE_CTRL_CR_en;          // 1:enable 0:disable spi interface
} SPI_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int               val;
	SPI_CONTROL_REGISTER_BIT_T bf;
} SPI_CONTROL_REGISTER_T;

// ---------------------------------------------------------------------
// Register spi_interrupt_control_register
// =>  netx100/500 compliant spi interrupt control register (IR)
//     In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software
//     compatible, not more than 8 bytes should be in netx100/500-FIFOs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SPI_COMPATIBLE_INT_CTRL  0x0000003CU
#define NETX_SPI0_COMPATIBLE_INT_CTRL 0x1C000D3CU
#define NETX_SPI1_COMPATIBLE_INT_CTRL 0x1C000D7CU

#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel       0x000001ffU // [8:0]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel       0
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel      0x0003fe00U // [17:9]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel      9
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel_en    0x00040000U // [18]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel_en    18
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_recdata_en 0x00080000U // [19]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_recdata_en 19
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_full_en    0x00100000U // [20]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_full_en    20
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel_en   0x00200000U // [21]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel_en   21
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fw_en     0x00400000U // [22]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fw_en     22
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_empty_en  0x00800000U // [23]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_empty_en  23
#define MSK_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_full_en   0x01000000U // [24]
#define SRT_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_full_en   24

enum {
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel       = 9, // [8:0]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel      = 9, // [17:9]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel_en    = 1, // [18]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_recdata_en = 1, // [19]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_full_en    = 1, // [20]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel_en   = 1, // [21]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fw_en     = 1, // [22]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_empty_en  = 1, // [23]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_full_en   = 1, // [24]
	BFW_NETX_SPI_COMPATIBLE_INT_CTRL_reserved1        = 7  // [31:25]
};

typedef struct SPI_INTERRUPT_CONTROL_REGISTER_BIT_Ttag {
	unsigned int IR_in_fuel       : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel;       // netx100/netx500 only: adjustable fill value of input FIFO, fix to 4 in later versions
	unsigned int IR_out_fuel      : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel;      // netx100/netx500 only: adjustable fill value of output FIFO, fix to 4 in later versions
	unsigned int IR_in_fuel_en    : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_fuel_en;    // IRQ enable for irq_spi(0)  (equals adr_spi_imsc.RXIM in netx50 and later versions)
	unsigned int IR_in_recdata_en : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_recdata_en; // IRQ enable for irq_spi(1)  (equals adr_spi_imsc.txneim in netx50 and later versions)
	unsigned int IR_in_full_en    : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_in_full_en;    // IRQ enable for irq_spi(2)  (equals adr_spi_imsc.txfim in netx50 and later versions)
	unsigned int IR_out_fuel_en   : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fuel_en;   // IRQ enable for irq_spi(3)  (equals adr_spi_imsc.TXIM in netx50 and later versions)
	unsigned int IR_out_fw_en     : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_fw_en;     // IRQ enable for irq_spi(4), netx100/netx500 only, always "0" in later versions
	unsigned int IR_out_empty_en  : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_empty_en;  // IRQ enable for irq_spi(5)  (equals adr_spi_imsc.rxeim in netx50 and later versions)
	unsigned int IR_out_full_en   : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_IR_out_full_en;   // IRQ enable for irq_spi(6), netx100/netx500 only, always "0" in later versions
	unsigned int reserved1        : BFW_NETX_SPI_COMPATIBLE_INT_CTRL_reserved1;        // reserved
} SPI_INTERRUPT_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int                         val;
	SPI_INTERRUPT_CONTROL_REGISTER_BIT_T bf;
} SPI_INTERRUPT_CONTROL_REGISTER_T;


// =====================================================================
//
// Area of i2c
//
// =====================================================================

#define NETX_I2C_AREA	0x1C000E00U

// ---------------------------------------------------------------------
// Register i2c_mcr
// =>  i2c master control register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_MASTER_CTRL 0x00000000U
#define NETX_I2C_MASTER_CTRL     0x1C000E00U

#define MSK_NETX_I2C_MASTER_CTRL_en_i2c 0x00000001U // [0]
#define SRT_NETX_I2C_MASTER_CTRL_en_i2c 0
#define MSK_NETX_I2C_MASTER_CTRL_mode   0x0000000eU // [3:1]
#define SRT_NETX_I2C_MASTER_CTRL_mode   1
#define MSK_NETX_I2C_MASTER_CTRL_sadr   0x000007f0U // [10:4]
#define SRT_NETX_I2C_MASTER_CTRL_sadr   4

enum {
	BFW_NETX_I2C_MASTER_CTRL_en_i2c    = 1,  // [0]
	BFW_NETX_I2C_MASTER_CTRL_mode      = 3,  // [3:1]
	BFW_NETX_I2C_MASTER_CTRL_sadr      = 7,  // [10:4]
	BFW_NETX_I2C_MASTER_CTRL_reserved1 = 21  // [31:11]
};

typedef struct I2C_MCR_BIT_Ttag {
	unsigned int en_i2c    : BFW_NETX_I2C_MASTER_CTRL_en_i2c;    // 0: disable I2C-controller, 1: enable controller 1
	unsigned int mode      : BFW_NETX_I2C_MASTER_CTRL_mode;      // selects I2C-speed-mode
	                                                        // If this device is used only as slave, mode should be set to the maximum data rate generated by the fastes master on the bus.
	                                                        //  000: Fast/Standard-mode, 50kbit/s
	                                                        //  001: Fast/Standard-mode, 100kbit/s
	                                                        //  010: Fast/Standard-mode, 200kbit/s
	                                                        //  011: Fast/Standard-mode, 400kbit/s
	                                                        //  100: Fast/Standard-mode, 800kbit/s
	                                                        //  101: Fast/Standard-mode, 1.2Mbit/s
	                                                        //  110: High-speed-mode, 1.7Mbit/s
	                                                        //  111: High-speed-mode, 3.4Mbit/s)
	unsigned int sadr      : BFW_NETX_I2C_MASTER_CTRL_sadr;      // Slave address send after (r)START.
	                                                        // For 10bit addressing transmit slave address LSBs via data register, 10bit-start "11110", MSB[9:8] here.
	                                                        // Must be rewritten even if value does not change, if another 10bit-slave shall be addressed.
	                                                        // Must not be rewritten before repeated START on same 10bit-slave (e.g. write to read change)
	unsigned int reserved1 : BFW_NETX_I2C_MASTER_CTRL_reserved1; // reserved
} I2C_MCR_BIT_T;

typedef union {
	unsigned int  val;
	I2C_MCR_BIT_T bf;
} I2C_MCR_T;

// ---------------------------------------------------------------------
// Register i2c_scr
// =>  i2c slave control register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_SLAVE_CTRL 0x00000004U
#define NETX_I2C_SLAVE_CTRL     0x1C000E04U

#define MSK_NETX_I2C_SLAVE_CTRL_sid      0x000003ffU // [9:0]
#define SRT_NETX_I2C_SLAVE_CTRL_sid      0
#define MSK_NETX_I2C_SLAVE_CTRL_sid10    0x00000400U // [10]
#define SRT_NETX_I2C_SLAVE_CTRL_sid10    10
#define MSK_NETX_I2C_SLAVE_CTRL_ac_srx   0x00010000U // [16]
#define SRT_NETX_I2C_SLAVE_CTRL_ac_srx   16
#define MSK_NETX_I2C_SLAVE_CTRL_ac_start 0x00020000U // [17]
#define SRT_NETX_I2C_SLAVE_CTRL_ac_start 17
#define MSK_NETX_I2C_SLAVE_CTRL_ac_gcall 0x00040000U // [18]
#define SRT_NETX_I2C_SLAVE_CTRL_ac_gcall 18

enum {
	BFW_NETX_I2C_SLAVE_CTRL_sid       = 10, // [9:0]
	BFW_NETX_I2C_SLAVE_CTRL_sid10     = 1,  // [10]
	BFW_NETX_I2C_SLAVE_CTRL_reserved1 = 5,  // [15:11]
	BFW_NETX_I2C_SLAVE_CTRL_ac_srx    = 1,  // [16]
	BFW_NETX_I2C_SLAVE_CTRL_ac_start  = 1,  // [17]
	BFW_NETX_I2C_SLAVE_CTRL_ac_gcall  = 1,  // [18]
	BFW_NETX_I2C_SLAVE_CTRL_reserved2 = 13  // [31:19]
};

typedef struct I2C_SCR_BIT_Ttag {
	unsigned int sid       : BFW_NETX_I2C_SLAVE_CTRL_sid;       // Slave device ID
	                                                        // External masters can address this device by this address.
	unsigned int sid10     : BFW_NETX_I2C_SLAVE_CTRL_sid10;     // 10bit Slave device ID
	                                                        //  0: listen for 7bit slave address after (r)START
	                                                        //  1: listen for 10bit slave address after (r)START
	unsigned int reserved1 : BFW_NETX_I2C_SLAVE_CTRL_reserved1; // reserved
	unsigned int ac_srx    : BFW_NETX_I2C_SLAVE_CTRL_ac_srx;    // enable on slave-recieving data AC
	                                                        //  0: do not generate an AC on write transfers to this slave device
	                                                        //  1: generate an AC on write transfers to this slave device
	                                                        // No AC will be generated on recieving data if slave-FIFO is full.
	unsigned int ac_start  : BFW_NETX_I2C_SLAVE_CTRL_ac_start;  // enable AC during START sequenze:
	                                                        //  7bit-address (sid10==0): AC 1st byte,
	                                                        //  10bit-address (sid10==1): AC 2nd byte, 1st byte always ACed # default 0x0
	                                                        //  If master requests a read transfer, slave-FIFO read access is done imideately after AC, so
	                                                        //  valid data must be present in slave-FIFO bevore AC on (r)START+read.
	                                                        //  0: do not generate an AC after (r)START
	                                                        //  1: generate an AC after (r)START
	unsigned int ac_gcall  : BFW_NETX_I2C_SLAVE_CTRL_ac_gcall;  // General Call AC
	                                                        //  0: do not generate an AC after General Call by another master
	                                                        //  1: generate an AC after General Call by another master
	unsigned int reserved2 : BFW_NETX_I2C_SLAVE_CTRL_reserved2; // reserved
} I2C_SCR_BIT_T;

typedef union {
	unsigned int  val;
	I2C_SCR_BIT_T bf;
} I2C_SCR_T;

// ---------------------------------------------------------------------
// Register i2c_cmd
// =>  i2c master command register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_MASTER_CMD 0x00000008U
#define NETX_I2C_MASTER_CMD     0x1C000E08U

#define MSK_NETX_I2C_MASTER_CMD_nwr       0x00000001U // [0]
#define SRT_NETX_I2C_MASTER_CMD_nwr       0
#define MSK_NETX_I2C_MASTER_CMD_cmd       0x0000000eU // [3:1]
#define SRT_NETX_I2C_MASTER_CMD_cmd       1
#define MSK_NETX_I2C_MASTER_CMD_tsize     0x0003ff00U // [17:8]
#define SRT_NETX_I2C_MASTER_CMD_tsize     8
#define MSK_NETX_I2C_MASTER_CMD_acpollmax 0x0ff00000U // [27:20]
#define SRT_NETX_I2C_MASTER_CMD_acpollmax 20

enum {
	BFW_NETX_I2C_MASTER_CMD_nwr       = 1,  // [0]
	BFW_NETX_I2C_MASTER_CMD_cmd       = 3,  // [3:1]
	BFW_NETX_I2C_MASTER_CMD_reserved1 = 4,  // [7:4]
	BFW_NETX_I2C_MASTER_CMD_tsize     = 10, // [17:8]
	BFW_NETX_I2C_MASTER_CMD_reserved2 = 2,  // [19:18]
	BFW_NETX_I2C_MASTER_CMD_acpollmax = 8,  // [27:20]
	BFW_NETX_I2C_MASTER_CMD_reserved3 = 4   // [31:28]
};

typedef struct I2C_CMD_BIT_Ttag {
	unsigned int nwr       : BFW_NETX_I2C_MASTER_CMD_nwr;       // 0: cmd will be done as write; 1: cmd will be done as read
	                                                        // Master FIFO-requests (IRQ and DMA) are generated depending this direction flag.
	unsigned int cmd       : BFW_NETX_I2C_MASTER_CMD_cmd;       // I2C Command. All commands except IDLE will either generate IRQ cmd_ok or IRQ cmd_err.
	                                                        // For 10bit-addressed slaves, the second address-byte (LSBs) must be top of the mdata-FIFO. This byte must not be reguarded by tsize.
	                                                        // Some commands are handled as sequences (i.e after setting S_AC_T, first S_AC, later CT will be seen when read out).
	                                                        // 000: START:    generate START-condition
	                                                        // 001: S_AC:     AC-polling: generate START-sequence (START-condition + address byte(s)) on sadr until AC received from slave or STOP or IDLE
	                                                        //                In case of slave-address-changing, rather STOP->START should be done than reSTART.
	                                                        // 010: S_AC_T:   AC. poll. and transfer: S_AC, then transfer tsize bytes from FIFO. Break (no STOP/rSTART) if slave does not send AC.
	                                                        //                in read-mopde, no AC will be generated after last transfer byte. Transfer ends.
	                                                        // 011: S_AC_TC:  AC. poll. and transfer: S_AC, then transfer tsize bytes from FIFO. Break (no STOP/rSTART) if slave does not send AC.
	                                                        //                in read-mopde, AC will be generated after last transfer byte. Transfer must be continued.
	                                                        // 100: CT:       Continued transfer of tsize bytes. Break if slave does not send AC in master write mode.
	                                                        //                in read-mopde, no AC will be generated after last transfer byte. Transfer ends.
	                                                        // 101: CTC:      Continued transfer of tsize bytes. Break if slave does not send AC in master write mode.
	                                                        //                in read-mopde, AC will be generated after last transfer byte. Transfer must be continued.
	                                                        // 110: STOP      must always be done by Software to free the bus (never done automatically by this device).
	                                                        // 111: IDLE      nothing to do, last command finished.
	unsigned int reserved1 : BFW_NETX_I2C_MASTER_CMD_reserved1; // reserved
	unsigned int tsize     : BFW_NETX_I2C_MASTER_CMD_tsize;     // Transfer tsize+1 of bytes (1..1024). This value will count down during transfers
	                                                        // If Slave does not acknowledge all write transfers, IRQ cmd_err will be generated.
	                                                        // For 10bit-addressed slaves, the second address-byte (LSBs) must be top of the mdata-FIFO. This byte must not be reguarded by tsize.
	unsigned int reserved2 : BFW_NETX_I2C_MASTER_CMD_reserved2; // reserved
	unsigned int acpollmax : BFW_NETX_I2C_MASTER_CMD_acpollmax; // acpollmax+1 (1...256) tryes for Acknowledge polling. this value will count down during AC polling
	                                                        // If no AC after acpollmax+1 tryes, IRQ cmd_err will be generated.
	                                                        // For 10bit-addressed slaves, the second address-byte (LSBs) must be top of the mdata-FIFO. This byte must not be reguarded by tsize.
	unsigned int reserved3 : BFW_NETX_I2C_MASTER_CMD_reserved3; // reserved
} I2C_CMD_BIT_T;

typedef union {
	unsigned int  val;
	I2C_CMD_BIT_T bf;
} I2C_CMD_T;

// ---------------------------------------------------------------------
// Register i2c_mdr
// =>  i2c master data register
//     Ther is only one FIFO for both, receive and transmit data with a depth of 16 bytes.
//     In case of imminent tranfer data failure (read transfer and FIFO is full or write transfer and FIFO is empty), cmd_err will occure after the last
//     byte that could be transmitted. No FIFO-underrun or overflow will happen. spi_cmd.tsize+1 will show amount of untransmitted data.
//     In case of master write transfer direction, the command may either be finished by (CTC optional) CT or be broken by STOP.
//     In case of master read transfer direction, the command be finished by (CTC optional) CT to show slave read data end (no AC at last byte).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_MASTER_DATA 0x0000000CU
#define NETX_I2C_MASTER_DATA     0x1C000E0CU

#define MSK_NETX_I2C_MASTER_DATA_mdata 0x000000ffU // [7:0]
#define SRT_NETX_I2C_MASTER_DATA_mdata 0

enum {
	BFW_NETX_I2C_MASTER_DATA_mdata     = 8,  // [7:0]
	BFW_NETX_I2C_MASTER_DATA_reserved1 = 24  // [31:8]
};

typedef struct I2C_MDR_BIT_Ttag {
	unsigned int mdata     : BFW_NETX_I2C_MASTER_DATA_mdata;     // i2c data to send or received in master mode
	                                                        // send data wil be removed from FIFO after recieving slave has acknowleged
	unsigned int reserved1 : BFW_NETX_I2C_MASTER_DATA_reserved1; // reserved
} I2C_MDR_BIT_T;

typedef union {
	unsigned int  val;
	I2C_MDR_BIT_T bf;
} I2C_MDR_T;

// ---------------------------------------------------------------------
// Register i2c_sdr
// =>  i2c slave data register
//     read access: in slave-mode received data byte is deliverd from receive FIFO
//     write access: data byte to send in slave mode is written to send FIFO
//     A transfer is initiated after detection of i2c-start-sequence with device address programmed in i2c_scr.sid.
//     Ther is only one FIFO for both, receive and transmit data with a depth of 16 bytes.
//     In case of master read transfer and slave transmit-FIFO underrun, corrupted data will be send to the master and fifo_err-IRQ occures.
//     In case of master write transfer and slave receive-FIFO full, no AC will be generated for the last received byte. No FIFO overflow will occure but
//     the last transfered byte will be lost and has to be send again.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_SLAVE_DATA 0x00000010U
#define NETX_I2C_SLAVE_DATA     0x1C000E10U

#define MSK_NETX_I2C_SLAVE_DATA_sdata 0x000000ffU // [7:0]
#define SRT_NETX_I2C_SLAVE_DATA_sdata 0

enum {
	BFW_NETX_I2C_SLAVE_DATA_sdata     = 8,  // [7:0]
	BFW_NETX_I2C_SLAVE_DATA_reserved1 = 24  // [31:8]
};

typedef struct I2C_SDR_BIT_Ttag {
	unsigned int sdata     : BFW_NETX_I2C_SLAVE_DATA_sdata;     // i2c data to send or received in master mode
	unsigned int reserved1 : BFW_NETX_I2C_SLAVE_DATA_reserved1; // reserved
} I2C_SDR_BIT_T;

typedef union {
	unsigned int  val;
	I2C_SDR_BIT_T bf;
} I2C_SDR_T;

// ---------------------------------------------------------------------
// Register i2c_mfifo_cr
// =>  i2c master FIFO controll register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_MASTER_FIFO_CTRL 0x00000014U
#define NETX_I2C_MASTER_FIFO_CTRL     0x1C000E14U

#define MSK_NETX_I2C_MASTER_FIFO_CTRL_mfifo_wm  0x0000000fU // [3:0]
#define SRT_NETX_I2C_MASTER_FIFO_CTRL_mfifo_wm  0
#define MSK_NETX_I2C_MASTER_FIFO_CTRL_mfifo_clr 0x00000100U // [8]
#define SRT_NETX_I2C_MASTER_FIFO_CTRL_mfifo_clr 8

enum {
	BFW_NETX_I2C_MASTER_FIFO_CTRL_mfifo_wm  = 4,  // [3:0]
	BFW_NETX_I2C_MASTER_FIFO_CTRL_reserved1 = 4,  // [7:4]
	BFW_NETX_I2C_MASTER_FIFO_CTRL_mfifo_clr = 1,  // [8]
	BFW_NETX_I2C_MASTER_FIFO_CTRL_reserved2 = 23  // [31:9]
};

typedef struct I2C_MFIFO_CR_BIT_Ttag {
	unsigned int mfifo_wm  : BFW_NETX_I2C_MASTER_FIFO_CTRL_mfifo_wm;  // Master FIFO Watermark for IRQ generation
	                                                        // if master is transmitter (nwr==0-command), mfifo_req-IRQ is generated if mfifo_level<=mfifo_wm and mfifo_level<=decrementing i2c_cmd.tsize
	                                                        // if master is receiver (nwr==1-command), mfifo_req-IRQ is generated if mfifo_level>mfifo_wm
	unsigned int reserved1 : BFW_NETX_I2C_MASTER_FIFO_CTRL_reserved1; // reserved
	unsigned int mfifo_clr : BFW_NETX_I2C_MASTER_FIFO_CTRL_mfifo_clr; // write only bit, clear master data FIFO
	unsigned int reserved2 : BFW_NETX_I2C_MASTER_FIFO_CTRL_reserved2; // reserved
} I2C_MFIFO_CR_BIT_T;

typedef union {
	unsigned int       val;
	I2C_MFIFO_CR_BIT_T bf;
} I2C_MFIFO_CR_T;

// ---------------------------------------------------------------------
// Register i2c_sfifo_cr
// =>  i2c slave FIFO controll register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_SLAVE_FIFO_CTRL 0x00000018U
#define NETX_I2C_SLAVE_FIFO_CTRL     0x1C000E18U

#define MSK_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_wm  0x0000000fU // [3:0]
#define SRT_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_wm  0
#define MSK_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_clr 0x00000100U // [8]
#define SRT_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_clr 8

enum {
	BFW_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_wm  = 4,  // [3:0]
	BFW_NETX_I2C_SLAVE_FIFO_CTRL_reserved1 = 4,  // [7:4]
	BFW_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_clr = 1,  // [8]
	BFW_NETX_I2C_SLAVE_FIFO_CTRL_reserved2 = 23  // [31:9]
};

typedef struct I2C_SFIFO_CR_BIT_Ttag {
	unsigned int sfifo_wm  : BFW_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_wm;  // slave FIFO Watermark for IRQ generation
	                                                        // if slave is transmitter (nwr==0-command), sfifo_req-IRQ is generated if sfifo_level<=sfifo_wm
	                                                        // if slave is receiver (nwr==1-command), sfifo_req-IRQ is generated if sfifo_level>sfifo_wm
	unsigned int reserved1 : BFW_NETX_I2C_SLAVE_FIFO_CTRL_reserved1; // reserved
	unsigned int sfifo_clr : BFW_NETX_I2C_SLAVE_FIFO_CTRL_sfifo_clr; // write only bit, clear slave data FIFO
	unsigned int reserved2 : BFW_NETX_I2C_SLAVE_FIFO_CTRL_reserved2; // reserved
} I2C_SFIFO_CR_BIT_T;

typedef union {
	unsigned int       val;
	I2C_SFIFO_CR_BIT_T bf;
} I2C_SFIFO_CR_T;

// ---------------------------------------------------------------------
// Register i2c_sr
// =>  read only i2c status register
//     Both, master and slave FIFO have a depth of 16.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_I2C_STAT 0x0000001CU
#define NETX_I2C_STAT     0x1C000E1CU

#define MSK_NETX_I2C_STAT_mfifo_level    0x0000001fU // [4:0]
#define SRT_NETX_I2C_STAT_mfifo_level    0
#define MSK_NETX_I2C_STAT_mfifo_empty    0x00000040U // [6]
#define SRT_NETX_I2C_STAT_mfifo_empty    6
#define MSK_NETX_I2C_STAT_mfifo_full     0x00000080U // [7]
#define SRT_NETX_I2C_STAT_mfifo_full     7
#define MSK_NETX_I2C_STAT_mfifo_err_ovfl 0x00000100U // [8]
#define SRT_NETX_I2C_STAT_mfifo_err_ovfl 8
#define MSK_NETX_I2C_STAT_mfifo_err_undr 0x00000200U // [9]
#define SRT_NETX_I2C_STAT_mfifo_err_undr 9
#define MSK_NETX_I2C_STAT_sfifo_level    0x00007c00U // [14:10]
#define SRT_NETX_I2C_STAT_sfifo_level    10
#define MSK_NETX_I2C_STAT_sfifo_empty    0x00010000U // [16]
#define SRT_NETX_I2C_STAT_sfifo_empty    16
#define MSK_NETX_I2C_STAT_sfifo_full     0x00020000U // [17]
#define SRT_NETX_I2C_STAT_sfifo_full     17
#define MSK_NETX_I2C_STAT_sfifo_err_ovfl 0x00040000U // [18]
#define SRT_NETX_I2C_STAT_sfifo_err_ovfl 18
#define MSK_NETX_I2C_STAT_sfifo_err_undr 0x00080000U // [19]
#define SRT_NETX_I2C_STAT_sfifo_err_undr 19
#define MSK_NETX_I2C_STAT_bus_master     0x00100000U // [20]
#define SRT_NETX_I2C_STAT_bus_master     20
#define MSK_NETX_I2C_STAT_nwr            0x00200000U // [21]
#define SRT_NETX_I2C_STAT_nwr            21
#define MSK_NETX_I2C_STAT_started        0x00400000U // [22]
#define SRT_NETX_I2C_STAT_started        22
#define MSK_NETX_I2C_STAT_slave_access   0x00800000U // [23]
#define SRT_NETX_I2C_STAT_slave_access   23
#define MSK_NETX_I2C_STAT_last_ac        0x01000000U // [24]
#define SRT_NETX_I2C_STAT_last_ac        24
#define MSK_NETX_I2C_STAT_nwr_aced       0x02000000U // [25]
#define SRT_NETX_I2C_STAT_nwr_aced       25
#define MSK_NETX_I2C_STAT_gcall_aced     0x04000000U // [26]
#define SRT_NETX_I2C_STAT_gcall_aced     26
#define MSK_NETX_I2C_STAT_sid10_aced     0x08000000U // [27]
#define SRT_NETX_I2C_STAT_sid10_aced     27
#define MSK_NETX_I2C_STAT_scl_state      0x40000000U // [30]
#define SRT_NETX_I2C_STAT_scl_state      30
#define MSK_NETX_I2C_STAT_sda_state      0x80000000U // [31]
#define SRT_NETX_I2C_STAT_sda_state      31

enum {
	BFW_NETX_I2C_STAT_mfifo_level    = 5, // [4:0]
	BFW_NETX_I2C_STAT_reserved1      = 1, // [5]
	BFW_NETX_I2C_STAT_mfifo_empty    = 1, // [6]
	BFW_NETX_I2C_STAT_mfifo_full     = 1, // [7]
	BFW_NETX_I2C_STAT_mfifo_err_ovfl = 1, // [8]
	BFW_NETX_I2C_STAT_mfifo_err_undr = 1, // [9]
	BFW_NETX_I2C_STAT_sfifo_level    = 5, // [14:10]
	BFW_NETX_I2C_STAT_reserved2      = 1, // [15]
	BFW_NETX_I2C_STAT_sfifo_empty    = 1, // [16]
	BFW_NETX_I2C_STAT_sfifo_full     = 1, // [17]
	BFW_NETX_I2C_STAT_sfifo_err_ovfl = 1, // [18]
	BFW_NETX_I2C_STAT_sfifo_err_undr = 1, // [19]
	BFW_NETX_I2C_STAT_bus_master     = 1, // [20]
	BFW_NETX_I2C_STAT_nwr            = 1, // [21]
	BFW_NETX_I2C_STAT_started        = 1, // [22]
	BFW_NETX_I2C_STAT_slave_access   = 1, // [23]
	BFW_NETX_I2C_STAT_last_ac        = 1, // [24]
	BFW_NETX_I2C_STAT_nwr_aced       = 1, // [25]
	BFW_NETX_I2C_STAT_gcall_aced     = 1, // [26]
	BFW_NETX_I2C_STAT_sid10_aced     = 1, // [27]
	BFW_NETX_I2C_STAT_reserved3      = 2, // [29:28]
	BFW_NETX_I2C_STAT_scl_state      = 1, // [30]
	BFW_NETX_I2C_STAT_sda_state      = 1  // [31]
};

typedef struct I2C_SR_BIT_Ttag {
	unsigned int mfifo_level    : BFW_NETX_I2C_STAT_mfifo_level;    // master FIFO level
	unsigned int reserved1      : BFW_NETX_I2C_STAT_reserved1;      // reserved
	unsigned int mfifo_empty    : BFW_NETX_I2C_STAT_mfifo_empty;    // master FIFO is empty (1 if empty)
	unsigned int mfifo_full     : BFW_NETX_I2C_STAT_mfifo_full;     // master FIFO is full (1 if full)
	unsigned int mfifo_err_ovfl : BFW_NETX_I2C_STAT_mfifo_err_ovfl; // master FIFO overflow error occured, data is lost
	unsigned int mfifo_err_undr : BFW_NETX_I2C_STAT_mfifo_err_undr; // master FIFO underrun error occured, data is lost
	unsigned int sfifo_level    : BFW_NETX_I2C_STAT_sfifo_level;    // slave FIFO level
	unsigned int reserved2      : BFW_NETX_I2C_STAT_reserved2;      // reserved
	unsigned int sfifo_empty    : BFW_NETX_I2C_STAT_sfifo_empty;    // slave FIFO is empty (1 if empty)
	unsigned int sfifo_full     : BFW_NETX_I2C_STAT_sfifo_full;     // slave FIFO is full (1 if full)
	unsigned int sfifo_err_ovfl : BFW_NETX_I2C_STAT_sfifo_err_ovfl; // slave FIFO overflow error occured, data is lost
	unsigned int sfifo_err_undr : BFW_NETX_I2C_STAT_sfifo_err_undr; // slave FIFO underrun error occured, data is lost
	unsigned int bus_master     : BFW_NETX_I2C_STAT_bus_master;     // 1: master gains bus arbitration, 0: master lost bus arbitration
	unsigned int nwr            : BFW_NETX_I2C_STAT_nwr;            // Transfer direction detected during last (s)START (0: write; 1: read, reset to 0 during START)
	unsigned int started        : BFW_NETX_I2C_STAT_started;        // 1: (r)Start was detected on bus, 0: bus is idle (Stop was detected, not started)
	                                                        // This detection is also done, if device is not enabled to get current bus state after enable.
	unsigned int slave_access   : BFW_NETX_I2C_STAT_slave_access;   // 1: master accesses this slave device, 0: no slave access on this device
	unsigned int last_ac        : BFW_NETX_I2C_STAT_last_ac;        // last AC detected on bus
	unsigned int nwr_aced       : BFW_NETX_I2C_STAT_nwr_aced;       // last aced transfer direction to handle slave-FIFO(0: write; 1: read)
	                                                        // Slave FIFO-requests (IRQ and DMA) are generated depending this direction flag.
	unsigned int gcall_aced     : BFW_NETX_I2C_STAT_gcall_aced;     // received gcall was acknowledged
	unsigned int sid10_aced     : BFW_NETX_I2C_STAT_sid10_aced;     // master detected slaved 10bit- address AC -> master will generate only first START-byte during START
	unsigned int reserved3      : BFW_NETX_I2C_STAT_reserved3;      // reserved
	unsigned int scl_state      : BFW_NETX_I2C_STAT_scl_state;      // scl-state sampled and filtered from bus (to detect bus blockings)
	unsigned int sda_state      : BFW_NETX_I2C_STAT_sda_state;      // sda-state sampled and filtered from bus (to detect bus blockings)
} I2C_SR_BIT_T;

typedef union {
	unsigned int val;
	I2C_SR_BIT_T bf;
} I2C_SR_T;

// ---------------------------------------------------------------------
// Register i2c_irqmsk
// =>  i2c interrupt mask set or clear register
//     AND-mask
//     enabeling (writing '1' and prior mask was "0") will clear according IRQ
//     For detailed IRQ-descrition view i2c_irqraw.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_INT_MSK_SET_CLR 0x00000020U
#define NETX_I2C_INT_MSK_SET_CLR     0x1C000E20U

#define MSK_NETX_I2C_INT_MSK_SET_CLR_cmd_ok    0x00000001U // [0]
#define SRT_NETX_I2C_INT_MSK_SET_CLR_cmd_ok    0
#define MSK_NETX_I2C_INT_MSK_SET_CLR_cmd_err   0x00000002U // [1]
#define SRT_NETX_I2C_INT_MSK_SET_CLR_cmd_err   1
#define MSK_NETX_I2C_INT_MSK_SET_CLR_fifo_err  0x00000004U // [2]
#define SRT_NETX_I2C_INT_MSK_SET_CLR_fifo_err  2
#define MSK_NETX_I2C_INT_MSK_SET_CLR_bus_busy  0x00000008U // [3]
#define SRT_NETX_I2C_INT_MSK_SET_CLR_bus_busy  3
#define MSK_NETX_I2C_INT_MSK_SET_CLR_mfifo_req 0x00000010U // [4]
#define SRT_NETX_I2C_INT_MSK_SET_CLR_mfifo_req 4
#define MSK_NETX_I2C_INT_MSK_SET_CLR_sfifo_req 0x00000020U // [5]
#define SRT_NETX_I2C_INT_MSK_SET_CLR_sfifo_req 5
#define MSK_NETX_I2C_INT_MSK_SET_CLR_sreq      0x00000040U // [6]
#define SRT_NETX_I2C_INT_MSK_SET_CLR_sreq      6

enum {
	BFW_NETX_I2C_INT_MSK_SET_CLR_cmd_ok    = 1,  // [0]
	BFW_NETX_I2C_INT_MSK_SET_CLR_cmd_err   = 1,  // [1]
	BFW_NETX_I2C_INT_MSK_SET_CLR_fifo_err  = 1,  // [2]
	BFW_NETX_I2C_INT_MSK_SET_CLR_bus_busy  = 1,  // [3]
	BFW_NETX_I2C_INT_MSK_SET_CLR_mfifo_req = 1,  // [4]
	BFW_NETX_I2C_INT_MSK_SET_CLR_sfifo_req = 1,  // [5]
	BFW_NETX_I2C_INT_MSK_SET_CLR_sreq      = 1,  // [6]
	BFW_NETX_I2C_INT_MSK_SET_CLR_reserved1 = 25  // [31:7]
};

typedef struct I2C_IRQMSK_BIT_Ttag {
	unsigned int cmd_ok    : BFW_NETX_I2C_INT_MSK_SET_CLR_cmd_ok;    // command OK interrupt mask
	unsigned int cmd_err   : BFW_NETX_I2C_INT_MSK_SET_CLR_cmd_err;   // command error interrupt mask
	unsigned int fifo_err  : BFW_NETX_I2C_INT_MSK_SET_CLR_fifo_err;  // FIFO error interrupt mask
	unsigned int bus_busy  : BFW_NETX_I2C_INT_MSK_SET_CLR_bus_busy;  // external i2c-bus is busy interrupt mask
	unsigned int mfifo_req : BFW_NETX_I2C_INT_MSK_SET_CLR_mfifo_req; // master FIFO action request interrupt mask
	unsigned int sfifo_req : BFW_NETX_I2C_INT_MSK_SET_CLR_sfifo_req; // slave FIFO action request interrupt mask
	unsigned int sreq      : BFW_NETX_I2C_INT_MSK_SET_CLR_sreq;      // slave request interrupt mask
	unsigned int reserved1 : BFW_NETX_I2C_INT_MSK_SET_CLR_reserved1; // reserved
} I2C_IRQMSK_BIT_T;

typedef union {
	unsigned int     val;
	I2C_IRQMSK_BIT_T bf;
} I2C_IRQMSK_T;

// ---------------------------------------------------------------------
// Register i2c_irqsr
// =>  i2c interrupt state before masking register (raw interrupt)
//     writing '1' will clear according IRQ
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_I2C_RAW_INT_STAT 0x00000024U
#define NETX_I2C_RAW_INT_STAT     0x1C000E24U

#define MSK_NETX_I2C_RAW_INT_STAT_cmd_ok    0x00000001U // [0]
#define SRT_NETX_I2C_RAW_INT_STAT_cmd_ok    0
#define MSK_NETX_I2C_RAW_INT_STAT_cmd_err   0x00000002U // [1]
#define SRT_NETX_I2C_RAW_INT_STAT_cmd_err   1
#define MSK_NETX_I2C_RAW_INT_STAT_fifo_err  0x00000004U // [2]
#define SRT_NETX_I2C_RAW_INT_STAT_fifo_err  2
#define MSK_NETX_I2C_RAW_INT_STAT_bus_busy  0x00000008U // [3]
#define SRT_NETX_I2C_RAW_INT_STAT_bus_busy  3
#define MSK_NETX_I2C_RAW_INT_STAT_mfifo_req 0x00000010U // [4]
#define SRT_NETX_I2C_RAW_INT_STAT_mfifo_req 4
#define MSK_NETX_I2C_RAW_INT_STAT_sfifo_req 0x00000020U // [5]
#define SRT_NETX_I2C_RAW_INT_STAT_sfifo_req 5
#define MSK_NETX_I2C_RAW_INT_STAT_sreq      0x00000040U // [6]
#define SRT_NETX_I2C_RAW_INT_STAT_sreq      6

enum {
	BFW_NETX_I2C_RAW_INT_STAT_cmd_ok    = 1,  // [0]
	BFW_NETX_I2C_RAW_INT_STAT_cmd_err   = 1,  // [1]
	BFW_NETX_I2C_RAW_INT_STAT_fifo_err  = 1,  // [2]
	BFW_NETX_I2C_RAW_INT_STAT_bus_busy  = 1,  // [3]
	BFW_NETX_I2C_RAW_INT_STAT_mfifo_req = 1,  // [4]
	BFW_NETX_I2C_RAW_INT_STAT_sfifo_req = 1,  // [5]
	BFW_NETX_I2C_RAW_INT_STAT_sreq      = 1,  // [6]
	BFW_NETX_I2C_RAW_INT_STAT_reserved1 = 25  // [31:7]
};

typedef struct I2C_IRQSR_BIT_Ttag {
	unsigned int cmd_ok    : BFW_NETX_I2C_RAW_INT_STAT_cmd_ok;    // unmasked command OK interrupt state
	                                                        // purpose: check last command termination
	                                                        // 1: last command finisched successfully
	                                                        // 0: command not finished, no command or command finisched erronous
	unsigned int cmd_err   : BFW_NETX_I2C_RAW_INT_STAT_cmd_err;   // unmasked command error interrupt state
	                                                        // purpose: check last command termination
	                                                        // 1: last command finisched erronous
	                                                        // 0: command not finished, no command or command finisched successfully
	unsigned int fifo_err  : BFW_NETX_I2C_RAW_INT_STAT_fifo_err;  // unmasked FIFO error interrupt state
	                                                        // purpose: detect FIFO errors/transfer failures
	                                                        // 1: FIFO error occured, check i2c_sr for details
	                                                        // 0: FIFOs ok
	unsigned int bus_busy  : BFW_NETX_I2C_RAW_INT_STAT_bus_busy;  // unmasked external i2c-bus is busy interrupt state
	                                                        // purpose: detect blocked i2c-bus
	                                                        // 1: master did not gain requested bus access due to another master blocking the bus
	                                                        // 0: bus is idle or no transfer is requested by this master
	unsigned int mfifo_req : BFW_NETX_I2C_RAW_INT_STAT_mfifo_req; // unmasked master FIFO action request interrupt state
	                                                        // purpose: master FIFO should be updated
	                                                        // 1: If master is transmitter (i2c_cmd.nwr == 0), mfifo_req-IRQ is generated if mfifo_level < mfifo_wm.
	                                                        //    If master is receiver (i2c_cmd.nwr == 1), mfifo_req-IRQ is generated if mfifo_level > mfifo_wm.
	                                                        // 0: master FIFO state not critical
	unsigned int sfifo_req : BFW_NETX_I2C_RAW_INT_STAT_sfifo_req; // unmasked slave FIFO action request interrupt state
	                                                        // purpose: slave FIFO should be updated
	                                                        // 1: If slave is receiver (i2c_sr.nwr_aced == 0), sfifo_req-IRQ is generated if sfifo_level > sfifo_wm.
	                                                        //    If slave is transmitter (i2c_sr.nwr_aced == 1) and is selected (i2c_sr.slave_access == 1), sfifo_req-IRQ is generated if sfifo_level < sfifo_wm.
	                                                        // 0: slave FIFO state not critical
	unsigned int sreq      : BFW_NETX_I2C_RAW_INT_STAT_sreq;      // unmasked slave request interrupt state
	                                                        // purpose: set up slave FIFO
	                                                        // 1: external master was running START-sequence and requested this slave
	                                                        // 0: slave is not requested
	unsigned int reserved1 : BFW_NETX_I2C_RAW_INT_STAT_reserved1; // reserved
} I2C_IRQSR_BIT_T;

typedef union {
	unsigned int    val;
	I2C_IRQSR_BIT_T bf;
} I2C_IRQSR_T;

// ---------------------------------------------------------------------
// Register i2c_irqmsked
// =>  i2c masked interrupt state register
//     if one of these bits is set, the I2C-IRQ will be generated to the Interrupt-Controller
//     For detailed IRQ-descrition view i2c_irqraw.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_I2C_MSK_INT_STAT 0x00000028U
#define NETX_I2C_MSK_INT_STAT     0x1C000E28U

#define MSK_NETX_I2C_MSK_INT_STAT_cmd_ok    0x00000001U // [0]
#define SRT_NETX_I2C_MSK_INT_STAT_cmd_ok    0
#define MSK_NETX_I2C_MSK_INT_STAT_cmd_err   0x00000002U // [1]
#define SRT_NETX_I2C_MSK_INT_STAT_cmd_err   1
#define MSK_NETX_I2C_MSK_INT_STAT_fifo_err  0x00000004U // [2]
#define SRT_NETX_I2C_MSK_INT_STAT_fifo_err  2
#define MSK_NETX_I2C_MSK_INT_STAT_bus_busy  0x00000008U // [3]
#define SRT_NETX_I2C_MSK_INT_STAT_bus_busy  3
#define MSK_NETX_I2C_MSK_INT_STAT_mfifo_req 0x00000010U // [4]
#define SRT_NETX_I2C_MSK_INT_STAT_mfifo_req 4
#define MSK_NETX_I2C_MSK_INT_STAT_sfifo_req 0x00000020U // [5]
#define SRT_NETX_I2C_MSK_INT_STAT_sfifo_req 5
#define MSK_NETX_I2C_MSK_INT_STAT_sreq      0x00000040U // [6]
#define SRT_NETX_I2C_MSK_INT_STAT_sreq      6

enum {
	BFW_NETX_I2C_MSK_INT_STAT_cmd_ok    = 1,  // [0]
	BFW_NETX_I2C_MSK_INT_STAT_cmd_err   = 1,  // [1]
	BFW_NETX_I2C_MSK_INT_STAT_fifo_err  = 1,  // [2]
	BFW_NETX_I2C_MSK_INT_STAT_bus_busy  = 1,  // [3]
	BFW_NETX_I2C_MSK_INT_STAT_mfifo_req = 1,  // [4]
	BFW_NETX_I2C_MSK_INT_STAT_sfifo_req = 1,  // [5]
	BFW_NETX_I2C_MSK_INT_STAT_sreq      = 1,  // [6]
	BFW_NETX_I2C_MSK_INT_STAT_reserved1 = 25  // [31:7]
};

typedef struct I2C_IRQMSKED_BIT_Ttag {
	unsigned int cmd_ok    : BFW_NETX_I2C_MSK_INT_STAT_cmd_ok;    // masked command OK interrupt state
	unsigned int cmd_err   : BFW_NETX_I2C_MSK_INT_STAT_cmd_err;   // masked command error interrupt state
	unsigned int fifo_err  : BFW_NETX_I2C_MSK_INT_STAT_fifo_err;  // masked FIFO error interrupt state
	unsigned int bus_busy  : BFW_NETX_I2C_MSK_INT_STAT_bus_busy;  // masked external i2c-bus is busy interrupt state
	unsigned int mfifo_req : BFW_NETX_I2C_MSK_INT_STAT_mfifo_req; // masked master FIFO action request interrupt state
	unsigned int sfifo_req : BFW_NETX_I2C_MSK_INT_STAT_sfifo_req; // masked slave FIFO action request interrupt state
	unsigned int sreq      : BFW_NETX_I2C_MSK_INT_STAT_sreq;      // masked slave request interrupt state
	unsigned int reserved1 : BFW_NETX_I2C_MSK_INT_STAT_reserved1; // reserved
} I2C_IRQMSKED_BIT_T;

typedef union {
	unsigned int       val;
	I2C_IRQMSKED_BIT_T bf;
} I2C_IRQMSKED_T;

// ---------------------------------------------------------------------
// Register i2c_dmacr
// =>  i2c DMA control register
//     DMA-burst to/from I2C-module: transfer size: bytes, burst-length: 4
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_I2C_DMA_CTRL 0x0000002CU
#define NETX_I2C_DMA_CTRL     0x1C000E2CU

#define MSK_NETX_I2C_DMA_CTRL_mdmas_en 0x00000001U // [0]
#define SRT_NETX_I2C_DMA_CTRL_mdmas_en 0
#define MSK_NETX_I2C_DMA_CTRL_mdmab_en 0x00000002U // [1]
#define SRT_NETX_I2C_DMA_CTRL_mdmab_en 1
#define MSK_NETX_I2C_DMA_CTRL_sdmas_en 0x00000004U // [2]
#define SRT_NETX_I2C_DMA_CTRL_sdmas_en 2
#define MSK_NETX_I2C_DMA_CTRL_sdmab_en 0x00000008U // [3]
#define SRT_NETX_I2C_DMA_CTRL_sdmab_en 3

enum {
	BFW_NETX_I2C_DMA_CTRL_mdmas_en  = 1,  // [0]
	BFW_NETX_I2C_DMA_CTRL_mdmab_en  = 1,  // [1]
	BFW_NETX_I2C_DMA_CTRL_sdmas_en  = 1,  // [2]
	BFW_NETX_I2C_DMA_CTRL_sdmab_en  = 1,  // [3]
	BFW_NETX_I2C_DMA_CTRL_reserved1 = 28  // [31:4]
};

typedef struct I2C_DMACR_BIT_Ttag {
	unsigned int mdmas_en  : BFW_NETX_I2C_DMA_CTRL_mdmas_en;  // enable DMA single requests for I2C master data
	                                                        // Data direction: master is receiver, if i2c_cmd.cmd_nwr == 1, master is transmitter, if i2c_cmd.cmd_nwr == 0
	                                                        // Flowcontrolling may be done my DMA-Controller or by I2C-controller controlled by decrementing i2c_cmd.tsize
	                                                        // This bit will be clear if DMA-Controller flags transfer end by asserting DMACTC (terminal count)
	                                                        // If this bit is set to 0 by software and a dma-transfer was requested before, one last
	                                                        // transfer will be done by the DMA-Controller to reset DMA-request signals.
	                                                        // DMA single request for master data will be asserted if:
	                                                        // master receiver:    1 byte or more in master-FIFO.
	                                                        // master transmitter: 1 byte or more writable to master-FIFO and less than rest of transfer data in master FIFO (i2c_sr.mfifo_level <= i2c_cmd.tsize).
	                                                        // DMA last single request for master data will be asserted if:
	                                                        // master receiver:    1 byte in master-FIFO.
	                                                        // master transmitter: 1 byte or more writable to master-FIFO and 1 byte transfer data missing in master FIFO (i2c_sr.mfifo_level == i2c_cmd.tsize).
	unsigned int mdmab_en  : BFW_NETX_I2C_DMA_CTRL_mdmab_en;  // enable DMA burst requests for I2C master data
	                                                        // Data direction: master is receiver, if i2c_cmd.cmd_nwr == 1, master is transmitter, if i2c_cmd.cmd_nwr == 0
	                                                        // Flowcontrolling may be done my DMA-Controller or by I2C-controller controlled by decrementing i2c_cmd.tsize
	                                                        // This bit will be clear if DMA-Controller flags transfer end by asserting DMACTC (terminal count)
	                                                        // If this bit is set to 0 by software and a dma-transfer was requested before, one last
	                                                        // transfer will be done by the DMA-Controller to reset DMA-request signals.
	                                                        // DMA burst request for master data will be asserted if:
	                                                        // master receiver:    4 byte or more in master-FIFO.
	                                                        // master transmitter: 4 byte or more writable to master-FIFO and less than rest of transfer data in master FIFO (i2c_sr.mfifo_level+3 <= i2c_cmd.tsize).
	                                                        // DMA last burst request for master data will be asserted if:
	                                                        // master receiver:    4 bytes in master-FIFO.
	                                                        // master transmitter: 4 byte or more writable to master-FIFO and 4 bytes transfer data missing in master FIFO (i2c_sr.mfifo_level+3 == i2c_cmd.tsize).
	unsigned int sdmas_en  : BFW_NETX_I2C_DMA_CTRL_sdmas_en;  // enable DMA single requests for I2C slave data
	                                                        // Data direction: slave is receiver if i2c_sr.nwr_aced == 0, slave is transmitter if i2c_sr.nwr_aced == 1 and i2c_sr.slave_access == 1.
	                                                        // Flowcontrolling must be done my DMA-Controller.
	                                                        // This bit will be clear if DMA-Controller flags transfer end by asserting DMACTC (terminal count)
	                                                        // If this bit is set to 0 by software and a dma-transfer was requested before, one last
	                                                        // transfer will be done by the DMA-Controller to reset DMA-request signals.
	                                                        // DMA single request for slave data will be asserted if:
	                                                        // slave receiver   : 1 byte or more in slave-FIFO.
	                                                        // slave transmitter: 1 byte or more writable to slave-FIFO.
	unsigned int sdmab_en  : BFW_NETX_I2C_DMA_CTRL_sdmab_en;  // enable DMA burst requests for I2C slave data
	                                                        // Data direction: slave is receiver if i2c_sr.nwr_aced == 0, slave is transmitter if i2c_sr.nwr_aced == 1 and i2c_sr.slave_access == 1.
	                                                        // Flowcontrolling must be done my DMA-Controller.
	                                                        // This bit will be clear if DMA-Controller flags transfer end by asserting DMACTC (terminal count)
	                                                        // If this bit is set to 0 by software and a dma-transfer was requested before, one last
	                                                        // transfer will be done by the DMA-Controller to reset DMA-request signals.
	                                                        // DMA burst request for slave data will be asserted if:
	                                                        // slave receiver:    4 bytes or more in slave-FIFO.
	                                                        // slave transmitter: 4 bytes or more writable to slave-FIFO.
	unsigned int reserved1 : BFW_NETX_I2C_DMA_CTRL_reserved1; // reserved
} I2C_DMACR_BIT_T;

typedef union {
	unsigned int    val;
	I2C_DMACR_BIT_T bf;
} I2C_DMACR_T;


// =====================================================================
//
// Area of ccdc
//
// =====================================================================

#define NETX_CCDC_AREA	0x1C000F00U

// ---------------------------------------------------------------------
// Register ccdc_config
// =>  CCDC config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_CFG 0x00000000U
#define NETX_CCDC_CFG     0x1C000F00U

#define MSK_NETX_CCDC_CFG_enable      0x00000001U // [0]
#define SRT_NETX_CCDC_CFG_enable      0
#define MSK_NETX_CCDC_CFG_edge_mode   0x00000002U // [1]
#define SRT_NETX_CCDC_CFG_edge_mode   1
#define MSK_NETX_CCDC_CFG_bright_step 0x00000ff0U // [11:4]
#define SRT_NETX_CCDC_CFG_bright_step 4
#define MSK_NETX_CCDC_CFG_sample_time 0x0000f000U // [15:12]
#define SRT_NETX_CCDC_CFG_sample_time 12
#define MSK_NETX_CCDC_CFG_fifo_0_res  0x00010000U // [16]
#define SRT_NETX_CCDC_CFG_fifo_0_res  16
#define MSK_NETX_CCDC_CFG_fifo_0_ovfl 0x00020000U // [17]
#define SRT_NETX_CCDC_CFG_fifo_0_ovfl 17
#define MSK_NETX_CCDC_CFG_fifo_0_unfl 0x00040000U // [18]
#define SRT_NETX_CCDC_CFG_fifo_0_unfl 18
#define MSK_NETX_CCDC_CFG_fifo_0_nxt  0x00080000U // [19]
#define SRT_NETX_CCDC_CFG_fifo_0_nxt  19
#define MSK_NETX_CCDC_CFG_fifo_1_res  0x00100000U // [20]
#define SRT_NETX_CCDC_CFG_fifo_1_res  20
#define MSK_NETX_CCDC_CFG_fifo_1_ovfl 0x00200000U // [21]
#define SRT_NETX_CCDC_CFG_fifo_1_ovfl 21
#define MSK_NETX_CCDC_CFG_fifo_1_unfl 0x00400000U // [22]
#define SRT_NETX_CCDC_CFG_fifo_1_unfl 22
#define MSK_NETX_CCDC_CFG_fifo_1_nxt  0x00800000U // [23]
#define SRT_NETX_CCDC_CFG_fifo_1_nxt  23
#define MSK_NETX_CCDC_CFG_fifo_2_res  0x01000000U // [24]
#define SRT_NETX_CCDC_CFG_fifo_2_res  24
#define MSK_NETX_CCDC_CFG_fifo_2_ovfl 0x02000000U // [25]
#define SRT_NETX_CCDC_CFG_fifo_2_ovfl 25
#define MSK_NETX_CCDC_CFG_fifo_2_unfl 0x04000000U // [26]
#define SRT_NETX_CCDC_CFG_fifo_2_unfl 26
#define MSK_NETX_CCDC_CFG_fifo_2_nxt  0x08000000U // [27]
#define SRT_NETX_CCDC_CFG_fifo_2_nxt  27
#define MSK_NETX_CCDC_CFG_last_mode   0x10000000U // [28]
#define SRT_NETX_CCDC_CFG_last_mode   28

enum {
	BFW_NETX_CCDC_CFG_enable      = 1, // [0]
	BFW_NETX_CCDC_CFG_edge_mode   = 1, // [1]
	BFW_NETX_CCDC_CFG_reserved1   = 2, // [3:2]
	BFW_NETX_CCDC_CFG_bright_step = 8, // [11:4]
	BFW_NETX_CCDC_CFG_sample_time = 4, // [15:12]
	BFW_NETX_CCDC_CFG_fifo_0_res  = 1, // [16]
	BFW_NETX_CCDC_CFG_fifo_0_ovfl = 1, // [17]
	BFW_NETX_CCDC_CFG_fifo_0_unfl = 1, // [18]
	BFW_NETX_CCDC_CFG_fifo_0_nxt  = 1, // [19]
	BFW_NETX_CCDC_CFG_fifo_1_res  = 1, // [20]
	BFW_NETX_CCDC_CFG_fifo_1_ovfl = 1, // [21]
	BFW_NETX_CCDC_CFG_fifo_1_unfl = 1, // [22]
	BFW_NETX_CCDC_CFG_fifo_1_nxt  = 1, // [23]
	BFW_NETX_CCDC_CFG_fifo_2_res  = 1, // [24]
	BFW_NETX_CCDC_CFG_fifo_2_ovfl = 1, // [25]
	BFW_NETX_CCDC_CFG_fifo_2_unfl = 1, // [26]
	BFW_NETX_CCDC_CFG_fifo_2_nxt  = 1, // [27]
	BFW_NETX_CCDC_CFG_last_mode   = 1, // [28]
	BFW_NETX_CCDC_CFG_reserved2   = 3  // [31:29]
};

typedef struct CCDC_CONFIG_BIT_Ttag {
	unsigned int enable      : BFW_NETX_CCDC_CFG_enable;      // enable CCD - Controller
	unsigned int edge_mode   : BFW_NETX_CCDC_CFG_edge_mode;   // 0 :  posedge (pixclk), 1 :  negedge (pixclk)
	unsigned int reserved1   : BFW_NETX_CCDC_CFG_reserved1;   // reserved
	unsigned int bright_step : BFW_NETX_CCDC_CFG_bright_step; // add every n (bright_step) byte:
	                                                        //	                           0 no add
	                                                        //	                           1 - 255  every n byte add
	unsigned int sample_time : BFW_NETX_CCDC_CFG_sample_time; // simple_time 0 - 15 100Mhz clocks after pos/negedge
	                                                        //	                           0      : with edge
	                                                        //	                           1 - 14 : 100 Mhz clocks after edge
	                                                        //	                               15 : one 100Mhz befor edge
	unsigned int fifo_0_res  : BFW_NETX_CCDC_CFG_fifo_0_res;  // 1'b1 reset; 1'b0 release
	unsigned int fifo_0_ovfl : BFW_NETX_CCDC_CFG_fifo_0_ovfl; // overflow read only
	unsigned int fifo_0_unfl : BFW_NETX_CCDC_CFG_fifo_0_unfl; // underflow read only
	unsigned int fifo_0_nxt  : BFW_NETX_CCDC_CFG_fifo_0_nxt;  // value in fifo read only
	unsigned int fifo_1_res  : BFW_NETX_CCDC_CFG_fifo_1_res;  // 1'b1 reset; 1'b0 release
	unsigned int fifo_1_ovfl : BFW_NETX_CCDC_CFG_fifo_1_ovfl; // overflow read only
	unsigned int fifo_1_unfl : BFW_NETX_CCDC_CFG_fifo_1_unfl; // underflow read only
	unsigned int fifo_1_nxt  : BFW_NETX_CCDC_CFG_fifo_1_nxt;  // value in fifo read only
	unsigned int fifo_2_res  : BFW_NETX_CCDC_CFG_fifo_2_res;  // 1'b1 reset; 1'b0 release
	unsigned int fifo_2_ovfl : BFW_NETX_CCDC_CFG_fifo_2_ovfl; // overflow read only
	unsigned int fifo_2_unfl : BFW_NETX_CCDC_CFG_fifo_2_unfl; // underflow read only
	unsigned int fifo_2_nxt  : BFW_NETX_CCDC_CFG_fifo_2_nxt;  // value in fifo read only
	unsigned int last_mode   : BFW_NETX_CCDC_CFG_last_mode;   // reserved
	unsigned int reserved2   : BFW_NETX_CCDC_CFG_reserved2;   // reserved
} CCDC_CONFIG_BIT_T;

typedef union {
	unsigned int      val;
	CCDC_CONFIG_BIT_T bf;
} CCDC_CONFIG_T;

// ---------------------------------------------------------------------
// Register ccdc_horiz_start_stop
// =>  CCDC horizontal start/stop values
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_HORIZ_START_STOP 0x00000004U
#define NETX_CCDC_HORIZ_START_STOP     0x1C000F04U

#define MSK_NETX_CCDC_HORIZ_START_STOP_horiz_start 0x0000ffffU // [15:0]
#define SRT_NETX_CCDC_HORIZ_START_STOP_horiz_start 0
#define MSK_NETX_CCDC_HORIZ_START_STOP_horiz_stop  0xffff0000U // [31:16]
#define SRT_NETX_CCDC_HORIZ_START_STOP_horiz_stop  16

enum {
	BFW_NETX_CCDC_HORIZ_START_STOP_horiz_start = 16, // [15:0]
	BFW_NETX_CCDC_HORIZ_START_STOP_horiz_stop  = 16  // [31:16]
};

typedef struct CCDC_HORIZ_START_STOP_BIT_Ttag {
	unsigned int horiz_start : BFW_NETX_CCDC_HORIZ_START_STOP_horiz_start; // byte count start (inclusive), to cut picture
	unsigned int horiz_stop  : BFW_NETX_CCDC_HORIZ_START_STOP_horiz_stop;  // byte count stop (exclusive), to cut picture
} CCDC_HORIZ_START_STOP_BIT_T;

typedef union {
	unsigned int                val;
	CCDC_HORIZ_START_STOP_BIT_T bf;
} CCDC_HORIZ_START_STOP_T;

// ---------------------------------------------------------------------
// Register ccdc_verti_start_stop
// =>  CCDC vertical start/stop values
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_VERT_START_STOP 0x00000008U
#define NETX_CCDC_VERT_START_STOP     0x1C000F08U

#define MSK_NETX_CCDC_VERT_START_STOP_verti_start 0x0000ffffU // [15:0]
#define SRT_NETX_CCDC_VERT_START_STOP_verti_start 0
#define MSK_NETX_CCDC_VERT_START_STOP_verti_stop  0xffff0000U // [31:16]
#define SRT_NETX_CCDC_VERT_START_STOP_verti_stop  16

enum {
	BFW_NETX_CCDC_VERT_START_STOP_verti_start = 16, // [15:0]
	BFW_NETX_CCDC_VERT_START_STOP_verti_stop  = 16  // [31:16]
};

typedef struct CCDC_VERTI_START_STOP_BIT_Ttag {
	unsigned int verti_start : BFW_NETX_CCDC_VERT_START_STOP_verti_start; // line count start (inclusive), to cut picture
	unsigned int verti_stop  : BFW_NETX_CCDC_VERT_START_STOP_verti_stop;  // line count stop (exclusive), to cut picture
} CCDC_VERTI_START_STOP_BIT_T;

typedef union {
	unsigned int                val;
	CCDC_VERTI_START_STOP_BIT_T bf;
} CCDC_VERTI_START_STOP_T;

// ---------------------------------------------------------------------
// Register ccdc_horiz_verti_counter
// =>  CCDC horizontal/vertical counter
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_HORIZ_VERT_CNTR 0x0000000CU
#define NETX_CCDC_HORIZ_VERT_CNTR     0x1C000F0CU

#define MSK_NETX_CCDC_HORIZ_VERT_CNTR_horiz_counter 0x0000ffffU // [15:0]
#define SRT_NETX_CCDC_HORIZ_VERT_CNTR_horiz_counter 0
#define MSK_NETX_CCDC_HORIZ_VERT_CNTR_verti_counter 0xffff0000U // [31:16]
#define SRT_NETX_CCDC_HORIZ_VERT_CNTR_verti_counter 16

enum {
	BFW_NETX_CCDC_HORIZ_VERT_CNTR_horiz_counter = 16, // [15:0]
	BFW_NETX_CCDC_HORIZ_VERT_CNTR_verti_counter = 16  // [31:16]
};

typedef struct CCDC_HORIZ_VERTI_COUNTER_BIT_Ttag {
	unsigned int horiz_counter : BFW_NETX_CCDC_HORIZ_VERT_CNTR_horiz_counter; // byte count while line_valid, reset with posedge line_valid
	unsigned int verti_counter : BFW_NETX_CCDC_HORIZ_VERT_CNTR_verti_counter; // line count while frame_valid, reset with posedge frame_valid
} CCDC_HORIZ_VERTI_COUNTER_BIT_T;

typedef union {
	unsigned int                   val;
	CCDC_HORIZ_VERTI_COUNTER_BIT_T bf;
} CCDC_HORIZ_VERTI_COUNTER_T;

// ---------------------------------------------------------------------
// Register ccdc_brightness
// =>  CCDC brightness counter
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_BRIGHT 0x00000010U
#define NETX_CCDC_BRIGHT     0x1C000F10U

#define MSK_NETX_CCDC_BRIGHT_brightness 0xffffffffU // [31:0]
#define SRT_NETX_CCDC_BRIGHT_brightness 0

enum {
	BFW_NETX_CCDC_BRIGHT_brightness = 32  // [31:0]
};

typedef struct CCDC_BRIGHTNESS_BIT_Ttag {
	unsigned int brightness : BFW_NETX_CCDC_BRIGHT_brightness; // brightness adder, every bright_step byte, reset with posedge frame_valid
} CCDC_BRIGHTNESS_BIT_T;

typedef union {
	unsigned int          val;
	CCDC_BRIGHTNESS_BIT_T bf;
} CCDC_BRIGHTNESS_T;

// ---------------------------------------------------------------------
// Register ccdc_fifo_0
// =>  CCDC Fifo 0
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_FIFO0 0x00000014U
#define NETX_CCDC_FIFO0     0x1C000F14U

#define MSK_NETX_CCDC_FIFO0_fifo_0 0xffffffffU // [31:0]
#define SRT_NETX_CCDC_FIFO0_fifo_0 0

enum {
	BFW_NETX_CCDC_FIFO0_fifo_0 = 32  // [31:0]
};

typedef struct CCDC_FIFO_0_BIT_Ttag {
	unsigned int fifo_0 : BFW_NETX_CCDC_FIFO0_fifo_0; // 2*4 bytes depth
} CCDC_FIFO_0_BIT_T;

typedef union {
	unsigned int      val;
	CCDC_FIFO_0_BIT_T bf;
} CCDC_FIFO_0_T;

// ---------------------------------------------------------------------
// Register ccdc_fifo_1
// =>  CCDC Fifo 1
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_FIFO1 0x00000018U
#define NETX_CCDC_FIFO1     0x1C000F18U

#define MSK_NETX_CCDC_FIFO1_fifo_1 0xffffffffU // [31:0]
#define SRT_NETX_CCDC_FIFO1_fifo_1 0

enum {
	BFW_NETX_CCDC_FIFO1_fifo_1 = 32  // [31:0]
};

typedef struct CCDC_FIFO_1_BIT_Ttag {
	unsigned int fifo_1 : BFW_NETX_CCDC_FIFO1_fifo_1; // 2*4 bytes depth
} CCDC_FIFO_1_BIT_T;

typedef union {
	unsigned int      val;
	CCDC_FIFO_1_BIT_T bf;
} CCDC_FIFO_1_T;

// ---------------------------------------------------------------------
// Register ccdc_fifo_2
// =>  CCDC Fifo 2
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_FIFO2 0x0000001CU
#define NETX_CCDC_FIFO2     0x1C000F1CU

#define MSK_NETX_CCDC_FIFO2_fifo_2 0xffffffffU // [31:0]
#define SRT_NETX_CCDC_FIFO2_fifo_2 0

enum {
	BFW_NETX_CCDC_FIFO2_fifo_2 = 32  // [31:0]
};

typedef struct CCDC_FIFO_2_BIT_Ttag {
	unsigned int fifo_2 : BFW_NETX_CCDC_FIFO2_fifo_2; // 2*4 bytes depth
} CCDC_FIFO_2_BIT_T;

typedef union {
	unsigned int      val;
	CCDC_FIFO_2_BIT_T bf;
} CCDC_FIFO_2_T;

// ---------------------------------------------------------------------
// Register ccdc_byte_0_pos
// =>  CCDC Byte Position Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_BYTE0_POS 0x00000020U
#define NETX_CCDC_BYTE0_POS     0x1C000F20U

#define MSK_NETX_CCDC_BYTE0_POS_first_0_byte_start   0x0000001fU // [4:0]
#define SRT_NETX_CCDC_BYTE0_POS_first_0_byte_start   0
#define MSK_NETX_CCDC_BYTE0_POS_first_0_byte_enable  0x00000020U // [5]
#define SRT_NETX_CCDC_BYTE0_POS_first_0_byte_enable  5
#define MSK_NETX_CCDC_BYTE0_POS_second_0_byte_start  0x000007c0U // [10:6]
#define SRT_NETX_CCDC_BYTE0_POS_second_0_byte_start  6
#define MSK_NETX_CCDC_BYTE0_POS_second_0_byte_enable 0x00000800U // [11]
#define SRT_NETX_CCDC_BYTE0_POS_second_0_byte_enable 11
#define MSK_NETX_CCDC_BYTE0_POS_third_0_byte_start   0x0001f000U // [16:12]
#define SRT_NETX_CCDC_BYTE0_POS_third_0_byte_start   12
#define MSK_NETX_CCDC_BYTE0_POS_third_0_byte_enable  0x00020000U // [17]
#define SRT_NETX_CCDC_BYTE0_POS_third_0_byte_enable  17
#define MSK_NETX_CCDC_BYTE0_POS_fourth_0_byte_start  0x007c0000U // [22:18]
#define SRT_NETX_CCDC_BYTE0_POS_fourth_0_byte_start  18
#define MSK_NETX_CCDC_BYTE0_POS_fourth_0_byte_enable 0x00800000U // [23]
#define SRT_NETX_CCDC_BYTE0_POS_fourth_0_byte_enable 23
#define MSK_NETX_CCDC_BYTE0_POS_fifo_0_and_mask      0xff000000U // [31:24]
#define SRT_NETX_CCDC_BYTE0_POS_fifo_0_and_mask      24

enum {
	BFW_NETX_CCDC_BYTE0_POS_first_0_byte_start   = 5, // [4:0]
	BFW_NETX_CCDC_BYTE0_POS_first_0_byte_enable  = 1, // [5]
	BFW_NETX_CCDC_BYTE0_POS_second_0_byte_start  = 5, // [10:6]
	BFW_NETX_CCDC_BYTE0_POS_second_0_byte_enable = 1, // [11]
	BFW_NETX_CCDC_BYTE0_POS_third_0_byte_start   = 5, // [16:12]
	BFW_NETX_CCDC_BYTE0_POS_third_0_byte_enable  = 1, // [17]
	BFW_NETX_CCDC_BYTE0_POS_fourth_0_byte_start  = 5, // [22:18]
	BFW_NETX_CCDC_BYTE0_POS_fourth_0_byte_enable = 1, // [23]
	BFW_NETX_CCDC_BYTE0_POS_fifo_0_and_mask      = 8  // [31:24]
};

typedef struct CCDC_BYTE_0_POS_BIT_Ttag {
	unsigned int first_0_byte_start   : BFW_NETX_CCDC_BYTE0_POS_first_0_byte_start;   // first byte start position
	unsigned int first_0_byte_enable  : BFW_NETX_CCDC_BYTE0_POS_first_0_byte_enable;  //
	unsigned int second_0_byte_start  : BFW_NETX_CCDC_BYTE0_POS_second_0_byte_start;  // second byte start position
	unsigned int second_0_byte_enable : BFW_NETX_CCDC_BYTE0_POS_second_0_byte_enable; //
	unsigned int third_0_byte_start   : BFW_NETX_CCDC_BYTE0_POS_third_0_byte_start;   // third byte start position
	unsigned int third_0_byte_enable  : BFW_NETX_CCDC_BYTE0_POS_third_0_byte_enable;  //
	unsigned int fourth_0_byte_start  : BFW_NETX_CCDC_BYTE0_POS_fourth_0_byte_start;  // fourth byte start position
	unsigned int fourth_0_byte_enable : BFW_NETX_CCDC_BYTE0_POS_fourth_0_byte_enable; //
	unsigned int fifo_0_and_mask      : BFW_NETX_CCDC_BYTE0_POS_fifo_0_and_mask;      // and_mask
} CCDC_BYTE_0_POS_BIT_T;

typedef union {
	unsigned int          val;
	CCDC_BYTE_0_POS_BIT_T bf;
} CCDC_BYTE_0_POS_T;

// ---------------------------------------------------------------------
// Register ccdc_byte_1_pos
// =>  CCDC Byte Position Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_BYTE1_POS 0x00000024U
#define NETX_CCDC_BYTE1_POS     0x1C000F24U

#define MSK_NETX_CCDC_BYTE1_POS_first_1_byte_start   0x0000001fU // [4:0]
#define SRT_NETX_CCDC_BYTE1_POS_first_1_byte_start   0
#define MSK_NETX_CCDC_BYTE1_POS_first_1_byte_enable  0x00000020U // [5]
#define SRT_NETX_CCDC_BYTE1_POS_first_1_byte_enable  5
#define MSK_NETX_CCDC_BYTE1_POS_second_1_byte_start  0x000007c0U // [10:6]
#define SRT_NETX_CCDC_BYTE1_POS_second_1_byte_start  6
#define MSK_NETX_CCDC_BYTE1_POS_second_1_byte_enable 0x00000800U // [11]
#define SRT_NETX_CCDC_BYTE1_POS_second_1_byte_enable 11
#define MSK_NETX_CCDC_BYTE1_POS_third_1_byte_start   0x0001f000U // [16:12]
#define SRT_NETX_CCDC_BYTE1_POS_third_1_byte_start   12
#define MSK_NETX_CCDC_BYTE1_POS_third_1_byte_enable  0x00020000U // [17]
#define SRT_NETX_CCDC_BYTE1_POS_third_1_byte_enable  17
#define MSK_NETX_CCDC_BYTE1_POS_fourth_1_byte_start  0x007c0000U // [22:18]
#define SRT_NETX_CCDC_BYTE1_POS_fourth_1_byte_start  18
#define MSK_NETX_CCDC_BYTE1_POS_fourth_1_byte_enable 0x00800000U // [23]
#define SRT_NETX_CCDC_BYTE1_POS_fourth_1_byte_enable 23
#define MSK_NETX_CCDC_BYTE1_POS_fifo_1_and_mask      0xff000000U // [31:24]
#define SRT_NETX_CCDC_BYTE1_POS_fifo_1_and_mask      24

enum {
	BFW_NETX_CCDC_BYTE1_POS_first_1_byte_start   = 5, // [4:0]
	BFW_NETX_CCDC_BYTE1_POS_first_1_byte_enable  = 1, // [5]
	BFW_NETX_CCDC_BYTE1_POS_second_1_byte_start  = 5, // [10:6]
	BFW_NETX_CCDC_BYTE1_POS_second_1_byte_enable = 1, // [11]
	BFW_NETX_CCDC_BYTE1_POS_third_1_byte_start   = 5, // [16:12]
	BFW_NETX_CCDC_BYTE1_POS_third_1_byte_enable  = 1, // [17]
	BFW_NETX_CCDC_BYTE1_POS_fourth_1_byte_start  = 5, // [22:18]
	BFW_NETX_CCDC_BYTE1_POS_fourth_1_byte_enable = 1, // [23]
	BFW_NETX_CCDC_BYTE1_POS_fifo_1_and_mask      = 8  // [31:24]
};

typedef struct CCDC_BYTE_1_POS_BIT_Ttag {
	unsigned int first_1_byte_start   : BFW_NETX_CCDC_BYTE1_POS_first_1_byte_start;   // first byte start position
	unsigned int first_1_byte_enable  : BFW_NETX_CCDC_BYTE1_POS_first_1_byte_enable;  //
	unsigned int second_1_byte_start  : BFW_NETX_CCDC_BYTE1_POS_second_1_byte_start;  // second byte start position
	unsigned int second_1_byte_enable : BFW_NETX_CCDC_BYTE1_POS_second_1_byte_enable; //
	unsigned int third_1_byte_start   : BFW_NETX_CCDC_BYTE1_POS_third_1_byte_start;   // third byte start position
	unsigned int third_1_byte_enable  : BFW_NETX_CCDC_BYTE1_POS_third_1_byte_enable;  //
	unsigned int fourth_1_byte_start  : BFW_NETX_CCDC_BYTE1_POS_fourth_1_byte_start;  // fourth byte start position
	unsigned int fourth_1_byte_enable : BFW_NETX_CCDC_BYTE1_POS_fourth_1_byte_enable; //
	unsigned int fifo_1_and_mask      : BFW_NETX_CCDC_BYTE1_POS_fifo_1_and_mask;      // and_mask
} CCDC_BYTE_1_POS_BIT_T;

typedef union {
	unsigned int          val;
	CCDC_BYTE_1_POS_BIT_T bf;
} CCDC_BYTE_1_POS_T;

// ---------------------------------------------------------------------
// Register ccdc_byte_2_pos
// =>  CCDC Byte Position Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CCDC_BYTE2_POS 0x00000028U
#define NETX_CCDC_BYTE2_POS     0x1C000F28U

#define MSK_NETX_CCDC_BYTE2_POS_first_2_byte_start   0x0000001fU // [4:0]
#define SRT_NETX_CCDC_BYTE2_POS_first_2_byte_start   0
#define MSK_NETX_CCDC_BYTE2_POS_first_2_byte_enable  0x00000020U // [5]
#define SRT_NETX_CCDC_BYTE2_POS_first_2_byte_enable  5
#define MSK_NETX_CCDC_BYTE2_POS_second_2_byte_start  0x000007c0U // [10:6]
#define SRT_NETX_CCDC_BYTE2_POS_second_2_byte_start  6
#define MSK_NETX_CCDC_BYTE2_POS_second_2_byte_enable 0x00000800U // [11]
#define SRT_NETX_CCDC_BYTE2_POS_second_2_byte_enable 11
#define MSK_NETX_CCDC_BYTE2_POS_third_2_byte_start   0x0001f000U // [16:12]
#define SRT_NETX_CCDC_BYTE2_POS_third_2_byte_start   12
#define MSK_NETX_CCDC_BYTE2_POS_third_2_byte_enable  0x00020000U // [17]
#define SRT_NETX_CCDC_BYTE2_POS_third_2_byte_enable  17
#define MSK_NETX_CCDC_BYTE2_POS_fourth_2_byte_start  0x007c0000U // [22:18]
#define SRT_NETX_CCDC_BYTE2_POS_fourth_2_byte_start  18
#define MSK_NETX_CCDC_BYTE2_POS_fourth_2_byte_enable 0x00800000U // [23]
#define SRT_NETX_CCDC_BYTE2_POS_fourth_2_byte_enable 23
#define MSK_NETX_CCDC_BYTE2_POS_fifo_2_and_mask      0xff000000U // [31:24]
#define SRT_NETX_CCDC_BYTE2_POS_fifo_2_and_mask      24

enum {
	BFW_NETX_CCDC_BYTE2_POS_first_2_byte_start   = 5, // [4:0]
	BFW_NETX_CCDC_BYTE2_POS_first_2_byte_enable  = 1, // [5]
	BFW_NETX_CCDC_BYTE2_POS_second_2_byte_start  = 5, // [10:6]
	BFW_NETX_CCDC_BYTE2_POS_second_2_byte_enable = 1, // [11]
	BFW_NETX_CCDC_BYTE2_POS_third_2_byte_start   = 5, // [16:12]
	BFW_NETX_CCDC_BYTE2_POS_third_2_byte_enable  = 1, // [17]
	BFW_NETX_CCDC_BYTE2_POS_fourth_2_byte_start  = 5, // [22:18]
	BFW_NETX_CCDC_BYTE2_POS_fourth_2_byte_enable = 1, // [23]
	BFW_NETX_CCDC_BYTE2_POS_fifo_2_and_mask      = 8  // [31:24]
};

typedef struct CCDC_BYTE_2_POS_BIT_Ttag {
	unsigned int first_2_byte_start   : BFW_NETX_CCDC_BYTE2_POS_first_2_byte_start;   // first byte start position
	unsigned int first_2_byte_enable  : BFW_NETX_CCDC_BYTE2_POS_first_2_byte_enable;  //
	unsigned int second_2_byte_start  : BFW_NETX_CCDC_BYTE2_POS_second_2_byte_start;  // second byte start position
	unsigned int second_2_byte_enable : BFW_NETX_CCDC_BYTE2_POS_second_2_byte_enable; //
	unsigned int third_2_byte_start   : BFW_NETX_CCDC_BYTE2_POS_third_2_byte_start;   // third byte start position
	unsigned int third_2_byte_enable  : BFW_NETX_CCDC_BYTE2_POS_third_2_byte_enable;  //
	unsigned int fourth_2_byte_start  : BFW_NETX_CCDC_BYTE2_POS_fourth_2_byte_start;  // fourth byte start position
	unsigned int fourth_2_byte_enable : BFW_NETX_CCDC_BYTE2_POS_fourth_2_byte_enable; //
	unsigned int fifo_2_and_mask      : BFW_NETX_CCDC_BYTE2_POS_fifo_2_and_mask;      // and_mask
} CCDC_BYTE_2_POS_BIT_T;

typedef union {
	unsigned int          val;
	CCDC_BYTE_2_POS_BIT_T bf;
} CCDC_BYTE_2_POS_T;


// =====================================================================
//
// Area of crc
//
// =====================================================================

#define NETX_CRC_AREA	0x1C001000U

// ---------------------------------------------------------------------
// Register crc_crc
// =>  CRC Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CRC_VAL 0x00000000U
#define NETX_CRC_VAL     0x1C001000U

#define MSK_NETX_CRC_VAL_crc_val 0xffffffffU // [31:0]
#define SRT_NETX_CRC_VAL_crc_val 0

enum {
	BFW_NETX_CRC_VAL_crc_val = 32  // [31:0]
};

typedef struct CRC_CRC_BIT_Ttag {
	unsigned int crc_val : BFW_NETX_CRC_VAL_crc_val; // CRC value
	                                                        // Upper bits should be masked, if crc_len smaller 31
} CRC_CRC_BIT_T;

typedef union {
	unsigned int  val;
	CRC_CRC_BIT_T bf;
} CRC_CRC_T;

// ---------------------------------------------------------------------
// Register crc_data_in
// =>  CRC data in Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CRC_IN_DATA 0x00000004U
#define NETX_CRC_IN_DATA     0x1C001004U

#define MSK_NETX_CRC_IN_DATA_in 0x000000ffU // [7:0]
#define SRT_NETX_CRC_IN_DATA_in 0

enum {
	BFW_NETX_CRC_IN_DATA_in        = 8,  // [7:0]
	BFW_NETX_CRC_IN_DATA_reserved1 = 24  // [31:8]
};

typedef struct CRC_DATA_IN_BIT_Ttag {
	unsigned int in        : BFW_NETX_CRC_IN_DATA_in;        // CRC input bits
	unsigned int reserved1 : BFW_NETX_CRC_IN_DATA_reserved1; // reserved
} CRC_DATA_IN_BIT_T;

typedef union {
	unsigned int      val;
	CRC_DATA_IN_BIT_T bf;
} CRC_DATA_IN_T;

// ---------------------------------------------------------------------
// Register crc_polynomial
// =>  CRC Polynomial Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CRC_POLYNOMIAL 0x00000008U
#define NETX_CRC_POLYNOMIAL     0x1C001008U

#define MSK_NETX_CRC_POLYNOMIAL_crc_polynomial 0xffffffffU // [31:0]
#define SRT_NETX_CRC_POLYNOMIAL_crc_polynomial 0

enum {
	BFW_NETX_CRC_POLYNOMIAL_crc_polynomial = 32  // [31:0]
};

typedef struct CRC_POLYNOMIAL_BIT_Ttag {
	unsigned int crc_polynomial : BFW_NETX_CRC_POLYNOMIAL_crc_polynomial; // crc polynomial (default:Ethenet CRC32)
	                                                        // Most significant bit of polynome is always one, thus not considered.
} CRC_POLYNOMIAL_BIT_T;

typedef union {
	unsigned int         val;
	CRC_POLYNOMIAL_BIT_T bf;
} CRC_POLYNOMIAL_T;

// ---------------------------------------------------------------------
// Register crc_config
// =>  CRC config Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_CRC_CFG 0x0000000CU
#define NETX_CRC_CFG     0x1C00100CU

#define MSK_NETX_CRC_CFG_crc_len         0x0000003fU // [5:0]
#define SRT_NETX_CRC_CFG_crc_len         0
#define MSK_NETX_CRC_CFG_crc_shift_right 0x00000040U // [6]
#define SRT_NETX_CRC_CFG_crc_shift_right 6
#define MSK_NETX_CRC_CFG_crc_direct_div  0x00000080U // [7]
#define SRT_NETX_CRC_CFG_crc_direct_div  7
#define MSK_NETX_CRC_CFG_crc_nof_bits    0x00000300U // [9:8]
#define SRT_NETX_CRC_CFG_crc_nof_bits    8
#define MSK_NETX_CRC_CFG_crc_in_msb_low  0x00000400U // [10]
#define SRT_NETX_CRC_CFG_crc_in_msb_low  10

enum {
	BFW_NETX_CRC_CFG_crc_len         = 6,  // [5:0]
	BFW_NETX_CRC_CFG_crc_shift_right = 1,  // [6]
	BFW_NETX_CRC_CFG_crc_direct_div  = 1,  // [7]
	BFW_NETX_CRC_CFG_crc_nof_bits    = 2,  // [9:8]
	BFW_NETX_CRC_CFG_crc_in_msb_low  = 1,  // [10]
	BFW_NETX_CRC_CFG_reserved1       = 21  // [31:11]
};

typedef struct CRC_CONFIG_BIT_Ttag {
	unsigned int crc_len         : BFW_NETX_CRC_CFG_crc_len;         // Length of CRC - 1
	unsigned int crc_shift_right : BFW_NETX_CRC_CFG_crc_shift_right; // 1: shift crc right
	unsigned int crc_direct_div  : BFW_NETX_CRC_CFG_crc_direct_div;  // 1: calculate direct polynolial division without n zeros after frame, usefull for parity calculation
	unsigned int crc_nof_bits    : BFW_NETX_CRC_CFG_crc_nof_bits;    // number of bits to be calculated in parallel (00: 1, 01: 2, 10; 4, 11: 8)
	unsigned int crc_in_msb_low  : BFW_NETX_CRC_CFG_crc_in_msb_low;  // swap crc_data_in, only usefull when calculating multiple bits in parallel (crc_nof_bits > 0):
	                                                        // 1: msb of incoming bits is data_in[0],
	                                                        // 0: msb is data_in[crc_nof_bits_m1]
	                                                        // (msb=first bit in data-stream)
	unsigned int reserved1       : BFW_NETX_CRC_CFG_reserved1;       // reserved
} CRC_CONFIG_BIT_T;

typedef union {
	unsigned int     val;
	CRC_CONFIG_BIT_T bf;
} CRC_CONFIG_T;


// =====================================================================
//
// Area of systime
//
// =====================================================================

#define NETX_SYS_TIME_AREA	0x1C001100U

// ---------------------------------------------------------------------
// Register systime_ns
// =>  lower SYSTIME register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_TIME_NS 0x00000000U
#define NETX_SYS_TIME_NS     0x1C001100U

#define MSK_NETX_SYS_TIME_NS_systime_ns 0xffffffffU // [31:0]
#define SRT_NETX_SYS_TIME_NS_systime_ns 0

enum {
	BFW_NETX_SYS_TIME_NS_systime_ns = 32  // [31:0]
};

typedef struct SYSTIME_NS_BIT_Ttag {
	unsigned int systime_ns : BFW_NETX_SYS_TIME_NS_systime_ns; // Systime low (used for counting nanoseconds in IEEE15888)
} SYSTIME_NS_BIT_T;

typedef union {
	unsigned int     val;
	SYSTIME_NS_BIT_T bf;
} SYSTIME_NS_T;

// ---------------------------------------------------------------------
// Register systime_s
// =>  upper SYSTIME register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_TIME_S 0x00000004U
#define NETX_SYS_TIME_S     0x1C001104U

#define MSK_NETX_SYS_TIME_S_systime_s 0xffffffffU // [31:0]
#define SRT_NETX_SYS_TIME_S_systime_s 0

enum {
	BFW_NETX_SYS_TIME_S_systime_s = 32  // [31:0]
};

typedef struct SYSTIME_S_BIT_Ttag {
	unsigned int systime_s : BFW_NETX_SYS_TIME_S_systime_s; // systime high (used for counting seconds in IEEE 1588)
	                                                        // value is incremented, if systime_ns reaches systime_border
} SYSTIME_S_BIT_T;

typedef union {
	unsigned int    val;
	SYSTIME_S_BIT_T bf;
} SYSTIME_S_T;

// ---------------------------------------------------------------------
// Register systime_border
// =>  SYSTIME border register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_TIME_NS_BOR 0x00000008U
#define NETX_SYS_TIME_NS_BOR     0x1C001108U

#define MSK_NETX_SYS_TIME_NS_BOR_systime_border 0xffffffffU // [31:0]
#define SRT_NETX_SYS_TIME_NS_BOR_systime_border 0

enum {
	BFW_NETX_SYS_TIME_NS_BOR_systime_border = 32  // [31:0]
};

typedef struct SYSTIME_BORDER_BIT_Ttag {
	unsigned int systime_border : BFW_NETX_SYS_TIME_NS_BOR_systime_border; // Systime border for lower systime:
	                                                        // systime_ns counts from 0 to this value (inlcuded),
	                                                        // i.e. systime_ns counts modulo (systime_border + 1)
	                                                        // Attention: the border value Bit 3 to 1 must be b'1111 (hex f) for all netX systime - match functions
} SYSTIME_BORDER_BIT_T;

typedef union {
	unsigned int         val;
	SYSTIME_BORDER_BIT_T bf;
} SYSTIME_BORDER_T;

// ---------------------------------------------------------------------
// Register systime_count_value
// =>  SYSTIME count register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_TIME_NS_ADD_UP 0x0000000CU
#define NETX_SYS_TIME_NS_ADD_UP     0x1C00110CU

#define MSK_NETX_SYS_TIME_NS_ADD_UP_systime_count_value 0xffffffffU // [31:0]
#define SRT_NETX_SYS_TIME_NS_ADD_UP_systime_count_value 0

enum {
	BFW_NETX_SYS_TIME_NS_ADD_UP_systime_count_value = 32  // [31:0]
};

typedef struct SYSTIME_COUNT_VALUE_BIT_Ttag {
	unsigned int systime_count_value : BFW_NETX_SYS_TIME_NS_ADD_UP_systime_count_value; // Each clock cycle (systime_count_value >> 28)
	                                                        // will be added to systime (rate multiplier for IEEE1588).
	                                                        // Value 0x10000000 can be used for counting in 10ns (ethernet clock) steps.
} SYSTIME_COUNT_VALUE_BIT_T;

typedef union {
	unsigned int              val;
	SYSTIME_COUNT_VALUE_BIT_T bf;
} SYSTIME_COUNT_VALUE_T;

// ---------------------------------------------------------------------
// Register systime_s_compare_value
// =>  SYSTIME sec compare register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_TIME_S_CMP 0x00000010U
#define NETX_SYS_TIME_S_CMP     0x1C001110U

#define MSK_NETX_SYS_TIME_S_CMP_systime_s_compare_value 0xffffffffU // [31:0]
#define SRT_NETX_SYS_TIME_S_CMP_systime_s_compare_value 0

enum {
	BFW_NETX_SYS_TIME_S_CMP_systime_s_compare_value = 32  // [31:0]
};

typedef struct SYSTIME_S_COMPARE_VALUE_BIT_Ttag {
	unsigned int systime_s_compare_value : BFW_NETX_SYS_TIME_S_CMP_systime_s_compare_value; // compare value with systime_s (seconds)
	                                                        // set systime_s_compare_irq register if systime_s_compare_enable is set
} SYSTIME_S_COMPARE_VALUE_BIT_T;

typedef union {
	unsigned int                  val;
	SYSTIME_S_COMPARE_VALUE_BIT_T bf;
} SYSTIME_S_COMPARE_VALUE_T;

// ---------------------------------------------------------------------
// Register systime_s_compare_enable
// =>  SYSTIME sec compare enable register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_TIME_S_CMP_EN 0x00000014U
#define NETX_SYS_TIME_S_CMP_EN     0x1C001114U

#define MSK_NETX_SYS_TIME_S_CMP_EN_systime_s_compare_enable 0x00000001U // [0]
#define SRT_NETX_SYS_TIME_S_CMP_EN_systime_s_compare_enable 0

enum {
	BFW_NETX_SYS_TIME_S_CMP_EN_systime_s_compare_enable = 1,  // [0]
	BFW_NETX_SYS_TIME_S_CMP_EN_reserved1                = 31  // [31:1]
};

typedef struct SYSTIME_S_COMPARE_ENABLE_BIT_Ttag {
	unsigned int systime_s_compare_enable : BFW_NETX_SYS_TIME_S_CMP_EN_systime_s_compare_enable; // enable compare with systime_s (seconds)
	                                                        // automatic set with set systime_s_compare_value
	                                                        // automatic reset after irq
	unsigned int reserved1                : BFW_NETX_SYS_TIME_S_CMP_EN_reserved1;                // reserved
} SYSTIME_S_COMPARE_ENABLE_BIT_T;

typedef union {
	unsigned int                   val;
	SYSTIME_S_COMPARE_ENABLE_BIT_T bf;
} SYSTIME_S_COMPARE_ENABLE_T;

// ---------------------------------------------------------------------
// Register systime_s_compare_irq
// =>  SYSTIME sec compare irq register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_TIME_S_CMP_INT 0x00000018U
#define NETX_SYS_TIME_S_CMP_INT     0x1C001118U

#define MSK_NETX_SYS_TIME_S_CMP_INT_systime_s_compare_irq 0x00000001U // [0]
#define SRT_NETX_SYS_TIME_S_CMP_INT_systime_s_compare_irq 0

enum {
	BFW_NETX_SYS_TIME_S_CMP_INT_systime_s_compare_irq = 1,  // [0]
	BFW_NETX_SYS_TIME_S_CMP_INT_reserved1             = 31  // [31:1]
};

typedef struct SYSTIME_S_COMPARE_IRQ_BIT_Ttag {
	unsigned int systime_s_compare_irq : BFW_NETX_SYS_TIME_S_CMP_INT_systime_s_compare_irq; // compare with systime_s (seconds) irq
	                                                        // set if systime_s equal systime_s_compare_value
	                                                        // reset by arm (arm writes 1 to reset)
	unsigned int reserved1             : BFW_NETX_SYS_TIME_S_CMP_INT_reserved1;             // reserved
} SYSTIME_S_COMPARE_IRQ_BIT_T;

typedef union {
	unsigned int                val;
	SYSTIME_S_COMPARE_IRQ_BIT_T bf;
} SYSTIME_S_COMPARE_IRQ_T;


// =====================================================================
//
// Area of mmio_ctrl
//
// =====================================================================

#define NETX_MMIO_CTRL_AREA	0x1C001300U

// ---------------------------------------------------------------------
// Register mmio0_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio0
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     -------------------------------
//     mmio*_sel - coding:
//     0x00 : xm0_io0            (signal type: bidirectional core signal,         signal group: Fieldbus0)
//     0x01 : xm0_io1            (signal type: bidirectional core signal,         signal group: Fieldbus0)
//     0x02 : xm0_io2            (signal type: bidirectional core signal,         signal group: Fieldbus0)
//     0x03 : xm0_io3            (signal type: bidirectional core signal,         signal group: Fieldbus0)
//     0x04 : xm0_io4            (signal type: bidirectional core signal,         signal group: Fieldbus0)
//     0x05 : xm0_io5            (signal type: bidirectional core signal,         signal group: Fieldbus0)
//     0x06 : xm0_rx             (signal type: core input signal,                 signal group: Fieldbus0)
//     0x07 : xm0_tx_oe          (signal type: nontristatable core output signal, signal group: Fieldbus0)
//     0x08 : xm0_tx_out         (signal type: tristatable core output signal,    signal group: Fieldbus0)
//     0x09 : xm1_io0            (signal type: bidirectional core signal,         signal group: Fieldbus1)
//     0x0a : xm1_io1            (signal type: bidirectional core signal,         signal group: Fieldbus1)
//     0x0b : xm1_io2            (signal type: bidirectional core signal,         signal group: Fieldbus1)
//     0x0c : xm1_io3            (signal type: bidirectional core signal,         signal group: Fieldbus1)
//     0x0d : xm1_io4            (signal type: bidirectional core signal,         signal group: Fieldbus1)
//     0x0e : xm1_io5            (signal type: bidirectional core signal,         signal group: Fieldbus1)
//     0x0f : xm1_rx             (signal type: core input signal,                 signal group: Fieldbus1)
//     0x10 : xm1_tx_oe          (signal type: nontristatable core output signal, signal group: Fieldbus1)
//     0x11 : xm1_tx_out         (signal type: tristatable core output signal,    signal group: Fieldbus1)
//     0x12 : gpio0              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x13 : gpio1              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x14 : gpio2              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x15 : gpio3              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x16 : gpio4              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x17 : gpio5              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x18 : gpio6              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x19 : gpio7              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x1a : gpio8              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x1b : gpio9              (signal type: bidirectional core signal,         signal group: GPIO)
//     0x1c : gpio10             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x1d : gpio11             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x1e : gpio12             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x1f : gpio13             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x20 : gpio14             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x21 : gpio15             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x22 : gpio16             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x23 : gpio17             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x24 : gpio18             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x25 : gpio19             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x26 : gpio20             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x27 : gpio21             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x28 : gpio22             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x29 : gpio23             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x2a : gpio24             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x2b : gpio25             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x2c : gpio26             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x2d : gpio27             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x2e : gpio28             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x2f : gpio29             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x30 : gpio30             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x31 : gpio31             (signal type: bidirectional core signal,         signal group: GPIO)
//     0x32 : phy0_led0          (signal type: nontristatable core output signal, signal group: int PHY0 Status)
//     0x33 : phy0_led1          (signal type: nontristatable core output signal, signal group: int PHY0 Status)
//     0x34 : phy0_led2          (signal type: nontristatable core output signal, signal group: int PHY0 Status)
//     0x35 : phy0_led3          (signal type: nontristatable core output signal, signal group: int PHY0 Status)
//     0x36 : phy1_led0          (signal type: nontristatable core output signal, signal group: int PHY1 Status)
//     0x37 : phy1_led1          (signal type: nontristatable core output signal, signal group: int PHY1 Status)
//     0x38 : phy1_led2          (signal type: nontristatable core output signal, signal group: int PHY1 Status)
//     0x39 : phy1_led3          (signal type: nontristatable core output signal, signal group: int PHY1 Status)
//     0x3a : mii_mdc            (signal type: nontristatable core output signal, signal group: MDIO)
//     0x3b : mii_mdio           (signal type: bidirectional core signal,         signal group: MDIO)
//     0x3c : mii0_col           (signal type: core input signal,                 signal group: MII0)
//     0x3d : mii0_crs           (signal type: core input signal,                 signal group: MII0)
//     0x3e : mii0_led0          (signal type: core input signal,                 signal group: MII0)
//     0x3f : mii0_led1          (signal type: core input signal,                 signal group: MII0)
//     0x40 : mii0_led2          (signal type: core input signal,                 signal group: MII0)
//     0x41 : mii0_led3          (signal type: core input signal,                 signal group: MII0)
//     0x42 : mii0_rxclk         (signal type: core input signal,                 signal group: MII0)
//     0x43 : mii0_rxd0          (signal type: core input signal,                 signal group: MII0)
//     0x44 : mii0_rxd1          (signal type: core input signal,                 signal group: MII0)
//     0x45 : mii0_rxd2          (signal type: core input signal,                 signal group: MII0)
//     0x46 : mii0_rxd3          (signal type: core input signal,                 signal group: MII0)
//     0x47 : mii0_rxdv          (signal type: core input signal,                 signal group: MII0)
//     0x48 : mii0_rxer          (signal type: core input signal,                 signal group: MII0)
//     0x49 : mii0_txclk         (signal type: core input signal,                 signal group: MII0)
//     0x4a : mii0_txd0          (signal type: tristatable core output signal,    signal group: MII0)
//     0x4b : mii0_txd1          (signal type: tristatable core output signal,    signal group: MII0)
//     0x4c : mii0_txd2          (signal type: tristatable core output signal,    signal group: MII0)
//     0x4d : mii0_txd3          (signal type: tristatable core output signal,    signal group: MII0)
//     0x4e : mii0_txen          (signal type: nontristatable core output signal, signal group: MII0)
//     0x4f : mii0_txer          (signal type: nontristatable core output signal, signal group: MII0)
//     0x50 : mii1_col           (signal type: core input signal,                 signal group: MII1)
//     0x51 : mii1_crs           (signal type: core input signal,                 signal group: MII1)
//     0x52 : mii1_led0          (signal type: core input signal,                 signal group: MII1)
//     0x53 : mii1_led1          (signal type: core input signal,                 signal group: MII1)
//     0x54 : mii1_led2          (signal type: core input signal,                 signal group: MII1)
//     0x55 : mii1_led3          (signal type: core input signal,                 signal group: MII1)
//     0x56 : mii1_rxclk         (signal type: core input signal,                 signal group: MII1)
//     0x57 : mii1_rxd0          (signal type: core input signal,                 signal group: MII1)
//     0x58 : mii1_rxd1          (signal type: core input signal,                 signal group: MII1)
//     0x59 : mii1_rxd2          (signal type: core input signal,                 signal group: MII1)
//     0x5a : mii1_rxd3          (signal type: core input signal,                 signal group: MII1)
//     0x5b : mii1_rxdv          (signal type: core input signal,                 signal group: MII1)
//     0x5c : mii1_rxer          (signal type: core input signal,                 signal group: MII1)
//     0x5d : mii1_txclk         (signal type: core input signal,                 signal group: MII1)
//     0x5e : mii1_txd0          (signal type: tristatable core output signal,    signal group: MII1)
//     0x5f : mii1_txd1          (signal type: tristatable core output signal,    signal group: MII1)
//     0x60 : mii1_txd2          (signal type: tristatable core output signal,    signal group: MII1)
//     0x61 : mii1_txd3          (signal type: tristatable core output signal,    signal group: MII1)
//     0x62 : mii1_txen          (signal type: nontristatable core output signal, signal group: MII1)
//     0x63 : mii1_txer          (signal type: nontristatable core output signal, signal group: MII1)
//     0x64 : pio0               (signal type: bidirectional core signal,         signal group: PIO)
//     0x65 : pio1               (signal type: bidirectional core signal,         signal group: PIO)
//     0x66 : pio2               (signal type: bidirectional core signal,         signal group: PIO)
//     0x67 : pio3               (signal type: bidirectional core signal,         signal group: PIO)
//     0x68 : pio4               (signal type: bidirectional core signal,         signal group: PIO)
//     0x69 : pio5               (signal type: bidirectional core signal,         signal group: PIO)
//     0x6a : pio6               (signal type: bidirectional core signal,         signal group: PIO)
//     0x6b : pio7               (signal type: bidirectional core signal,         signal group: PIO)
//     0x6c : spi0_cs2n          (signal type: bidirectional core signal,         signal group: SPI0 3rd chip select)
//     0x6d : spi1_clk           (signal type: bidirectional core signal,         signal group: SPI1)
//     0x6e : spi1_cs0n          (signal type: bidirectional core signal,         signal group: SPI1)
//     0x6f : spi1_cs1n          (signal type: bidirectional core signal,         signal group: SPI1)
//     0x70 : spi1_cs2n          (signal type: bidirectional core signal,         signal group: SPI1)
//     0x71 : spi1_miso          (signal type: bidirectional core signal,         signal group: SPI1)
//     0x72 : spi1_mosi          (signal type: bidirectional core signal,         signal group: SPI1)
//     0x73 : i2c_scl_mmio       (signal type: bidirectional core signal,         signal group: I2C)
//     0x74 : i2c_sda_mmio       (signal type: bidirectional core signal,         signal group: I2C)
//     0x75 : xc_sample0         (signal type: core input signal,                 signal group: Trigger/Latch Unit)
//     0x76 : xc_sample1         (signal type: core input signal,                 signal group: Trigger/Latch Unit)
//     0x77 : xc_trigger0        (signal type: tristatable core output signal,    signal group: Trigger/Latch Unit)
//     0x78 : xc_trigger1        (signal type: tristatable core output signal,    signal group: Trigger/Latch Unit)
//     0x79 : uart0_cts          (signal type: core input signal,                 signal group: UART 0)
//     0x7a : uart0_rts          (signal type: tristatable core output signal,    signal group: UART 0)
//     0x7b : uart0_rxd          (signal type: core input signal,                 signal group: UART 0)
//     0x7c : uart0_txd          (signal type: tristatable core output signal,    signal group: UART 0)
//     0x7d : uart1_cts          (signal type: core input signal,                 signal group: UART 1)
//     0x7e : uart1_rts          (signal type: tristatable core output signal,    signal group: UART 1)
//     0x7f : uart1_rxd          (signal type: core input signal,                 signal group: UART 1)
//     0x80 : uart1_txd          (signal type: tristatable core output signal,    signal group: UART 1)
//     0x81 : uart2_cts          (signal type: core input signal,                 signal group: UART 2)
//     0x82 : uart2_rts          (signal type: tristatable core output signal,    signal group: UART 2)
//     0x83 : uart2_rxd          (signal type: core input signal,                 signal group: UART 2)
//     0x84 : uart2_txd          (signal type: tristatable core output signal,    signal group: UART 2)
//     0x85 : usb_id_dig         (signal type: core input signal,                 signal group: USB)
//     0x86 : usb_id_pullup_ctrl (signal type: nontristatable core output signal, signal group: USB)
//     0x87 : usb_rpd_ena        (signal type: nontristatable core output signal, signal group: USB)
//     0x88 : usb_rpu_ena        (signal type: nontristatable core output signal, signal group: USB)
//     0x89 : ccd_data0          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x8a : ccd_data1          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x8b : ccd_data2          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x8c : ccd_data3          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x8d : ccd_data4          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x8e : ccd_data5          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x8f : ccd_data6          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x90 : ccd_data7          (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x91 : ccd_pixclk         (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x92 : ccd_line_valid     (signal type: core input signal,                 signal group: CCD-Sensor)
//     0x93 : ccd_frame_valid    (signal type: core input signal,                 signal group: CCD-Sensor)
//     0xff : nc                 force input state if unused
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO0_CFG 0x00000000U
#define NETX_MMIO0_CFG     0x1C001300U

#define MSK_NETX_MMIO0_CFG_mmio0_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO0_CFG_mmio0_sel     0
#define MSK_NETX_MMIO0_CFG_mmio0_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO0_CFG_mmio0_out_inv 8
#define MSK_NETX_MMIO0_CFG_mmio0_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO0_CFG_mmio0_in_inv  9

enum {
	BFW_NETX_MMIO0_CFG_mmio0_sel     = 8,  // [7:0]
	BFW_NETX_MMIO0_CFG_mmio0_out_inv = 1,  // [8]
	BFW_NETX_MMIO0_CFG_mmio0_in_inv  = 1,  // [9]
	BFW_NETX_MMIO0_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO0_CFG_BIT_Ttag {
	unsigned int mmio0_sel     : BFW_NETX_MMIO0_CFG_mmio0_sel;     // mmio0 signal selection (default: gpio0)
	unsigned int mmio0_out_inv : BFW_NETX_MMIO0_CFG_mmio0_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio0_in_inv  : BFW_NETX_MMIO0_CFG_mmio0_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO0_CFG_reserved1;     // reserved
} MMIO0_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO0_CFG_BIT_T bf;
} MMIO0_CFG_T;

// ---------------------------------------------------------------------
// Register mmio1_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio1
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO1_CFG 0x00000004U
#define NETX_MMIO1_CFG     0x1C001304U

#define MSK_NETX_MMIO1_CFG_mmio1_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO1_CFG_mmio1_sel     0
#define MSK_NETX_MMIO1_CFG_mmio1_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO1_CFG_mmio1_out_inv 8
#define MSK_NETX_MMIO1_CFG_mmio1_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO1_CFG_mmio1_in_inv  9

enum {
	BFW_NETX_MMIO1_CFG_mmio1_sel     = 8,  // [7:0]
	BFW_NETX_MMIO1_CFG_mmio1_out_inv = 1,  // [8]
	BFW_NETX_MMIO1_CFG_mmio1_in_inv  = 1,  // [9]
	BFW_NETX_MMIO1_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO1_CFG_BIT_Ttag {
	unsigned int mmio1_sel     : BFW_NETX_MMIO1_CFG_mmio1_sel;     // mmio1 signal selection (default: gpio1)
	unsigned int mmio1_out_inv : BFW_NETX_MMIO1_CFG_mmio1_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio1_in_inv  : BFW_NETX_MMIO1_CFG_mmio1_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO1_CFG_reserved1;     // reserved
} MMIO1_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO1_CFG_BIT_T bf;
} MMIO1_CFG_T;

// ---------------------------------------------------------------------
// Register mmio2_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio2
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO2_CFG 0x00000008U
#define NETX_MMIO2_CFG     0x1C001308U

#define MSK_NETX_MMIO2_CFG_mmio2_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO2_CFG_mmio2_sel     0
#define MSK_NETX_MMIO2_CFG_mmio2_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO2_CFG_mmio2_out_inv 8
#define MSK_NETX_MMIO2_CFG_mmio2_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO2_CFG_mmio2_in_inv  9

enum {
	BFW_NETX_MMIO2_CFG_mmio2_sel     = 8,  // [7:0]
	BFW_NETX_MMIO2_CFG_mmio2_out_inv = 1,  // [8]
	BFW_NETX_MMIO2_CFG_mmio2_in_inv  = 1,  // [9]
	BFW_NETX_MMIO2_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO2_CFG_BIT_Ttag {
	unsigned int mmio2_sel     : BFW_NETX_MMIO2_CFG_mmio2_sel;     // mmio2 signal selection (default: gpio2)
	unsigned int mmio2_out_inv : BFW_NETX_MMIO2_CFG_mmio2_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio2_in_inv  : BFW_NETX_MMIO2_CFG_mmio2_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO2_CFG_reserved1;     // reserved
} MMIO2_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO2_CFG_BIT_T bf;
} MMIO2_CFG_T;

// ---------------------------------------------------------------------
// Register mmio3_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio3
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO3_CFG 0x0000000CU
#define NETX_MMIO3_CFG     0x1C00130CU

#define MSK_NETX_MMIO3_CFG_mmio3_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO3_CFG_mmio3_sel     0
#define MSK_NETX_MMIO3_CFG_mmio3_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO3_CFG_mmio3_out_inv 8
#define MSK_NETX_MMIO3_CFG_mmio3_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO3_CFG_mmio3_in_inv  9

enum {
	BFW_NETX_MMIO3_CFG_mmio3_sel     = 8,  // [7:0]
	BFW_NETX_MMIO3_CFG_mmio3_out_inv = 1,  // [8]
	BFW_NETX_MMIO3_CFG_mmio3_in_inv  = 1,  // [9]
	BFW_NETX_MMIO3_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO3_CFG_BIT_Ttag {
	unsigned int mmio3_sel     : BFW_NETX_MMIO3_CFG_mmio3_sel;     // mmio3 signal selection (default: gpio3)
	unsigned int mmio3_out_inv : BFW_NETX_MMIO3_CFG_mmio3_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio3_in_inv  : BFW_NETX_MMIO3_CFG_mmio3_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO3_CFG_reserved1;     // reserved
} MMIO3_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO3_CFG_BIT_T bf;
} MMIO3_CFG_T;

// ---------------------------------------------------------------------
// Register mmio4_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio4
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO4_CFG 0x00000010U
#define NETX_MMIO4_CFG     0x1C001310U

#define MSK_NETX_MMIO4_CFG_mmio4_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO4_CFG_mmio4_sel     0
#define MSK_NETX_MMIO4_CFG_mmio4_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO4_CFG_mmio4_out_inv 8
#define MSK_NETX_MMIO4_CFG_mmio4_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO4_CFG_mmio4_in_inv  9

enum {
	BFW_NETX_MMIO4_CFG_mmio4_sel     = 8,  // [7:0]
	BFW_NETX_MMIO4_CFG_mmio4_out_inv = 1,  // [8]
	BFW_NETX_MMIO4_CFG_mmio4_in_inv  = 1,  // [9]
	BFW_NETX_MMIO4_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO4_CFG_BIT_Ttag {
	unsigned int mmio4_sel     : BFW_NETX_MMIO4_CFG_mmio4_sel;     // mmio4 signal selection (default: gpio4)
	unsigned int mmio4_out_inv : BFW_NETX_MMIO4_CFG_mmio4_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio4_in_inv  : BFW_NETX_MMIO4_CFG_mmio4_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO4_CFG_reserved1;     // reserved
} MMIO4_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO4_CFG_BIT_T bf;
} MMIO4_CFG_T;

// ---------------------------------------------------------------------
// Register mmio5_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio5
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO5_CFG 0x00000014U
#define NETX_MMIO5_CFG     0x1C001314U

#define MSK_NETX_MMIO5_CFG_mmio5_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO5_CFG_mmio5_sel     0
#define MSK_NETX_MMIO5_CFG_mmio5_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO5_CFG_mmio5_out_inv 8
#define MSK_NETX_MMIO5_CFG_mmio5_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO5_CFG_mmio5_in_inv  9

enum {
	BFW_NETX_MMIO5_CFG_mmio5_sel     = 8,  // [7:0]
	BFW_NETX_MMIO5_CFG_mmio5_out_inv = 1,  // [8]
	BFW_NETX_MMIO5_CFG_mmio5_in_inv  = 1,  // [9]
	BFW_NETX_MMIO5_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO5_CFG_BIT_Ttag {
	unsigned int mmio5_sel     : BFW_NETX_MMIO5_CFG_mmio5_sel;     // mmio5 signal selection (default: gpio5)
	unsigned int mmio5_out_inv : BFW_NETX_MMIO5_CFG_mmio5_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio5_in_inv  : BFW_NETX_MMIO5_CFG_mmio5_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO5_CFG_reserved1;     // reserved
} MMIO5_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO5_CFG_BIT_T bf;
} MMIO5_CFG_T;

// ---------------------------------------------------------------------
// Register mmio6_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio6
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO6_CFG 0x00000018U
#define NETX_MMIO6_CFG     0x1C001318U

#define MSK_NETX_MMIO6_CFG_mmio6_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO6_CFG_mmio6_sel     0
#define MSK_NETX_MMIO6_CFG_mmio6_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO6_CFG_mmio6_out_inv 8
#define MSK_NETX_MMIO6_CFG_mmio6_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO6_CFG_mmio6_in_inv  9

enum {
	BFW_NETX_MMIO6_CFG_mmio6_sel     = 8,  // [7:0]
	BFW_NETX_MMIO6_CFG_mmio6_out_inv = 1,  // [8]
	BFW_NETX_MMIO6_CFG_mmio6_in_inv  = 1,  // [9]
	BFW_NETX_MMIO6_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO6_CFG_BIT_Ttag {
	unsigned int mmio6_sel     : BFW_NETX_MMIO6_CFG_mmio6_sel;     // mmio6 signal selection (default: gpio6)
	unsigned int mmio6_out_inv : BFW_NETX_MMIO6_CFG_mmio6_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio6_in_inv  : BFW_NETX_MMIO6_CFG_mmio6_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO6_CFG_reserved1;     // reserved
} MMIO6_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO6_CFG_BIT_T bf;
} MMIO6_CFG_T;

// ---------------------------------------------------------------------
// Register mmio7_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio7
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO7_CFG 0x0000001CU
#define NETX_MMIO7_CFG     0x1C00131CU

#define MSK_NETX_MMIO7_CFG_mmio7_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO7_CFG_mmio7_sel     0
#define MSK_NETX_MMIO7_CFG_mmio7_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO7_CFG_mmio7_out_inv 8
#define MSK_NETX_MMIO7_CFG_mmio7_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO7_CFG_mmio7_in_inv  9

enum {
	BFW_NETX_MMIO7_CFG_mmio7_sel     = 8,  // [7:0]
	BFW_NETX_MMIO7_CFG_mmio7_out_inv = 1,  // [8]
	BFW_NETX_MMIO7_CFG_mmio7_in_inv  = 1,  // [9]
	BFW_NETX_MMIO7_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO7_CFG_BIT_Ttag {
	unsigned int mmio7_sel     : BFW_NETX_MMIO7_CFG_mmio7_sel;     // mmio7 signal selection (default: gpio7)
	unsigned int mmio7_out_inv : BFW_NETX_MMIO7_CFG_mmio7_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio7_in_inv  : BFW_NETX_MMIO7_CFG_mmio7_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO7_CFG_reserved1;     // reserved
} MMIO7_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO7_CFG_BIT_T bf;
} MMIO7_CFG_T;

// ---------------------------------------------------------------------
// Register mmio8_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio8
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO8_CFG 0x00000020U
#define NETX_MMIO8_CFG     0x1C001320U

#define MSK_NETX_MMIO8_CFG_mmio8_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO8_CFG_mmio8_sel     0
#define MSK_NETX_MMIO8_CFG_mmio8_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO8_CFG_mmio8_out_inv 8
#define MSK_NETX_MMIO8_CFG_mmio8_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO8_CFG_mmio8_in_inv  9

enum {
	BFW_NETX_MMIO8_CFG_mmio8_sel     = 8,  // [7:0]
	BFW_NETX_MMIO8_CFG_mmio8_out_inv = 1,  // [8]
	BFW_NETX_MMIO8_CFG_mmio8_in_inv  = 1,  // [9]
	BFW_NETX_MMIO8_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO8_CFG_BIT_Ttag {
	unsigned int mmio8_sel     : BFW_NETX_MMIO8_CFG_mmio8_sel;     // mmio8 signal selection (default: gpio8)
	unsigned int mmio8_out_inv : BFW_NETX_MMIO8_CFG_mmio8_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio8_in_inv  : BFW_NETX_MMIO8_CFG_mmio8_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO8_CFG_reserved1;     // reserved
} MMIO8_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO8_CFG_BIT_T bf;
} MMIO8_CFG_T;

// ---------------------------------------------------------------------
// Register mmio9_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio9
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO9_CFG 0x00000024U
#define NETX_MMIO9_CFG     0x1C001324U

#define MSK_NETX_MMIO9_CFG_mmio9_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO9_CFG_mmio9_sel     0
#define MSK_NETX_MMIO9_CFG_mmio9_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO9_CFG_mmio9_out_inv 8
#define MSK_NETX_MMIO9_CFG_mmio9_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO9_CFG_mmio9_in_inv  9

enum {
	BFW_NETX_MMIO9_CFG_mmio9_sel     = 8,  // [7:0]
	BFW_NETX_MMIO9_CFG_mmio9_out_inv = 1,  // [8]
	BFW_NETX_MMIO9_CFG_mmio9_in_inv  = 1,  // [9]
	BFW_NETX_MMIO9_CFG_reserved1     = 22  // [31:10]
};

typedef struct MMIO9_CFG_BIT_Ttag {
	unsigned int mmio9_sel     : BFW_NETX_MMIO9_CFG_mmio9_sel;     // mmio9 signal selection (default: gpio9)
	unsigned int mmio9_out_inv : BFW_NETX_MMIO9_CFG_mmio9_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio9_in_inv  : BFW_NETX_MMIO9_CFG_mmio9_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1     : BFW_NETX_MMIO9_CFG_reserved1;     // reserved
} MMIO9_CFG_BIT_T;

typedef union {
	unsigned int    val;
	MMIO9_CFG_BIT_T bf;
} MMIO9_CFG_T;

// ---------------------------------------------------------------------
// Register mmio10_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio10
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO10_CFG 0x00000028U
#define NETX_MMIO10_CFG     0x1C001328U

#define MSK_NETX_MMIO10_CFG_mmio10_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO10_CFG_mmio10_sel     0
#define MSK_NETX_MMIO10_CFG_mmio10_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO10_CFG_mmio10_out_inv 8
#define MSK_NETX_MMIO10_CFG_mmio10_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO10_CFG_mmio10_in_inv  9

enum {
	BFW_NETX_MMIO10_CFG_mmio10_sel     = 8,  // [7:0]
	BFW_NETX_MMIO10_CFG_mmio10_out_inv = 1,  // [8]
	BFW_NETX_MMIO10_CFG_mmio10_in_inv  = 1,  // [9]
	BFW_NETX_MMIO10_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO10_CFG_BIT_Ttag {
	unsigned int mmio10_sel     : BFW_NETX_MMIO10_CFG_mmio10_sel;     // mmio10 signal selection (default: gpio10)
	unsigned int mmio10_out_inv : BFW_NETX_MMIO10_CFG_mmio10_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio10_in_inv  : BFW_NETX_MMIO10_CFG_mmio10_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO10_CFG_reserved1;      // reserved
} MMIO10_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO10_CFG_BIT_T bf;
} MMIO10_CFG_T;

// ---------------------------------------------------------------------
// Register mmio11_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio11
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO11_CFG 0x0000002CU
#define NETX_MMIO11_CFG     0x1C00132CU

#define MSK_NETX_MMIO11_CFG_mmio11_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO11_CFG_mmio11_sel     0
#define MSK_NETX_MMIO11_CFG_mmio11_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO11_CFG_mmio11_out_inv 8
#define MSK_NETX_MMIO11_CFG_mmio11_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO11_CFG_mmio11_in_inv  9

enum {
	BFW_NETX_MMIO11_CFG_mmio11_sel     = 8,  // [7:0]
	BFW_NETX_MMIO11_CFG_mmio11_out_inv = 1,  // [8]
	BFW_NETX_MMIO11_CFG_mmio11_in_inv  = 1,  // [9]
	BFW_NETX_MMIO11_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO11_CFG_BIT_Ttag {
	unsigned int mmio11_sel     : BFW_NETX_MMIO11_CFG_mmio11_sel;     // mmio11 signal selection (default: gpio11)
	unsigned int mmio11_out_inv : BFW_NETX_MMIO11_CFG_mmio11_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio11_in_inv  : BFW_NETX_MMIO11_CFG_mmio11_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO11_CFG_reserved1;      // reserved
} MMIO11_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO11_CFG_BIT_T bf;
} MMIO11_CFG_T;

// ---------------------------------------------------------------------
// Register mmio12_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio12
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO12_CFG 0x00000030U
#define NETX_MMIO12_CFG     0x1C001330U

#define MSK_NETX_MMIO12_CFG_mmio12_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO12_CFG_mmio12_sel     0
#define MSK_NETX_MMIO12_CFG_mmio12_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO12_CFG_mmio12_out_inv 8
#define MSK_NETX_MMIO12_CFG_mmio12_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO12_CFG_mmio12_in_inv  9

enum {
	BFW_NETX_MMIO12_CFG_mmio12_sel     = 8,  // [7:0]
	BFW_NETX_MMIO12_CFG_mmio12_out_inv = 1,  // [8]
	BFW_NETX_MMIO12_CFG_mmio12_in_inv  = 1,  // [9]
	BFW_NETX_MMIO12_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO12_CFG_BIT_Ttag {
	unsigned int mmio12_sel     : BFW_NETX_MMIO12_CFG_mmio12_sel;     // mmio12 signal selection (default: gpio12)
	unsigned int mmio12_out_inv : BFW_NETX_MMIO12_CFG_mmio12_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio12_in_inv  : BFW_NETX_MMIO12_CFG_mmio12_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO12_CFG_reserved1;      // reserved
} MMIO12_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO12_CFG_BIT_T bf;
} MMIO12_CFG_T;

// ---------------------------------------------------------------------
// Register mmio13_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio13
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO13_CFG 0x00000034U
#define NETX_MMIO13_CFG     0x1C001334U

#define MSK_NETX_MMIO13_CFG_mmio13_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO13_CFG_mmio13_sel     0
#define MSK_NETX_MMIO13_CFG_mmio13_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO13_CFG_mmio13_out_inv 8
#define MSK_NETX_MMIO13_CFG_mmio13_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO13_CFG_mmio13_in_inv  9

enum {
	BFW_NETX_MMIO13_CFG_mmio13_sel     = 8,  // [7:0]
	BFW_NETX_MMIO13_CFG_mmio13_out_inv = 1,  // [8]
	BFW_NETX_MMIO13_CFG_mmio13_in_inv  = 1,  // [9]
	BFW_NETX_MMIO13_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO13_CFG_BIT_Ttag {
	unsigned int mmio13_sel     : BFW_NETX_MMIO13_CFG_mmio13_sel;     // mmio13 signal selection (default: gpio13)
	unsigned int mmio13_out_inv : BFW_NETX_MMIO13_CFG_mmio13_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio13_in_inv  : BFW_NETX_MMIO13_CFG_mmio13_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO13_CFG_reserved1;      // reserved
} MMIO13_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO13_CFG_BIT_T bf;
} MMIO13_CFG_T;

// ---------------------------------------------------------------------
// Register mmio14_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio14
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO14_CFG 0x00000038U
#define NETX_MMIO14_CFG     0x1C001338U

#define MSK_NETX_MMIO14_CFG_mmio14_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO14_CFG_mmio14_sel     0
#define MSK_NETX_MMIO14_CFG_mmio14_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO14_CFG_mmio14_out_inv 8
#define MSK_NETX_MMIO14_CFG_mmio14_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO14_CFG_mmio14_in_inv  9

enum {
	BFW_NETX_MMIO14_CFG_mmio14_sel     = 8,  // [7:0]
	BFW_NETX_MMIO14_CFG_mmio14_out_inv = 1,  // [8]
	BFW_NETX_MMIO14_CFG_mmio14_in_inv  = 1,  // [9]
	BFW_NETX_MMIO14_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO14_CFG_BIT_Ttag {
	unsigned int mmio14_sel     : BFW_NETX_MMIO14_CFG_mmio14_sel;     // mmio14 signal selection (default: gpio14)
	unsigned int mmio14_out_inv : BFW_NETX_MMIO14_CFG_mmio14_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio14_in_inv  : BFW_NETX_MMIO14_CFG_mmio14_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO14_CFG_reserved1;      // reserved
} MMIO14_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO14_CFG_BIT_T bf;
} MMIO14_CFG_T;

// ---------------------------------------------------------------------
// Register mmio15_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio15
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO15_CFG 0x0000003CU
#define NETX_MMIO15_CFG     0x1C00133CU

#define MSK_NETX_MMIO15_CFG_mmio15_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO15_CFG_mmio15_sel     0
#define MSK_NETX_MMIO15_CFG_mmio15_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO15_CFG_mmio15_out_inv 8
#define MSK_NETX_MMIO15_CFG_mmio15_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO15_CFG_mmio15_in_inv  9

enum {
	BFW_NETX_MMIO15_CFG_mmio15_sel     = 8,  // [7:0]
	BFW_NETX_MMIO15_CFG_mmio15_out_inv = 1,  // [8]
	BFW_NETX_MMIO15_CFG_mmio15_in_inv  = 1,  // [9]
	BFW_NETX_MMIO15_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO15_CFG_BIT_Ttag {
	unsigned int mmio15_sel     : BFW_NETX_MMIO15_CFG_mmio15_sel;     // mmio15 signal selection (default: gpio15)
	unsigned int mmio15_out_inv : BFW_NETX_MMIO15_CFG_mmio15_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio15_in_inv  : BFW_NETX_MMIO15_CFG_mmio15_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO15_CFG_reserved1;      // reserved
} MMIO15_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO15_CFG_BIT_T bf;
} MMIO15_CFG_T;

// ---------------------------------------------------------------------
// Register mmio16_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio16
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO16_CFG 0x00000040U
#define NETX_MMIO16_CFG     0x1C001340U

#define MSK_NETX_MMIO16_CFG_mmio16_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO16_CFG_mmio16_sel     0
#define MSK_NETX_MMIO16_CFG_mmio16_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO16_CFG_mmio16_out_inv 8
#define MSK_NETX_MMIO16_CFG_mmio16_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO16_CFG_mmio16_in_inv  9

enum {
	BFW_NETX_MMIO16_CFG_mmio16_sel     = 8,  // [7:0]
	BFW_NETX_MMIO16_CFG_mmio16_out_inv = 1,  // [8]
	BFW_NETX_MMIO16_CFG_mmio16_in_inv  = 1,  // [9]
	BFW_NETX_MMIO16_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO16_CFG_BIT_Ttag {
	unsigned int mmio16_sel     : BFW_NETX_MMIO16_CFG_mmio16_sel;     // mmio16 signal selection (default: gpio16)
	unsigned int mmio16_out_inv : BFW_NETX_MMIO16_CFG_mmio16_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio16_in_inv  : BFW_NETX_MMIO16_CFG_mmio16_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO16_CFG_reserved1;      // reserved
} MMIO16_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO16_CFG_BIT_T bf;
} MMIO16_CFG_T;

// ---------------------------------------------------------------------
// Register mmio17_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio17
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO17_CFG 0x00000044U
#define NETX_MMIO17_CFG     0x1C001344U

#define MSK_NETX_MMIO17_CFG_mmio17_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO17_CFG_mmio17_sel     0
#define MSK_NETX_MMIO17_CFG_mmio17_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO17_CFG_mmio17_out_inv 8
#define MSK_NETX_MMIO17_CFG_mmio17_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO17_CFG_mmio17_in_inv  9

enum {
	BFW_NETX_MMIO17_CFG_mmio17_sel     = 8,  // [7:0]
	BFW_NETX_MMIO17_CFG_mmio17_out_inv = 1,  // [8]
	BFW_NETX_MMIO17_CFG_mmio17_in_inv  = 1,  // [9]
	BFW_NETX_MMIO17_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO17_CFG_BIT_Ttag {
	unsigned int mmio17_sel     : BFW_NETX_MMIO17_CFG_mmio17_sel;     // mmio17 signal selection (default: gpio17)
	unsigned int mmio17_out_inv : BFW_NETX_MMIO17_CFG_mmio17_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio17_in_inv  : BFW_NETX_MMIO17_CFG_mmio17_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO17_CFG_reserved1;      // reserved
} MMIO17_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO17_CFG_BIT_T bf;
} MMIO17_CFG_T;

// ---------------------------------------------------------------------
// Register mmio18_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio18
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO18_CFG 0x00000048U
#define NETX_MMIO18_CFG     0x1C001348U

#define MSK_NETX_MMIO18_CFG_mmio18_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO18_CFG_mmio18_sel     0
#define MSK_NETX_MMIO18_CFG_mmio18_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO18_CFG_mmio18_out_inv 8
#define MSK_NETX_MMIO18_CFG_mmio18_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO18_CFG_mmio18_in_inv  9

enum {
	BFW_NETX_MMIO18_CFG_mmio18_sel     = 8,  // [7:0]
	BFW_NETX_MMIO18_CFG_mmio18_out_inv = 1,  // [8]
	BFW_NETX_MMIO18_CFG_mmio18_in_inv  = 1,  // [9]
	BFW_NETX_MMIO18_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO18_CFG_BIT_Ttag {
	unsigned int mmio18_sel     : BFW_NETX_MMIO18_CFG_mmio18_sel;     // mmio18 signal selection (default: gpio18)
	unsigned int mmio18_out_inv : BFW_NETX_MMIO18_CFG_mmio18_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio18_in_inv  : BFW_NETX_MMIO18_CFG_mmio18_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO18_CFG_reserved1;      // reserved
} MMIO18_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO18_CFG_BIT_T bf;
} MMIO18_CFG_T;

// ---------------------------------------------------------------------
// Register mmio19_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio19
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO19_CFG 0x0000004CU
#define NETX_MMIO19_CFG     0x1C00134CU

#define MSK_NETX_MMIO19_CFG_mmio19_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO19_CFG_mmio19_sel     0
#define MSK_NETX_MMIO19_CFG_mmio19_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO19_CFG_mmio19_out_inv 8
#define MSK_NETX_MMIO19_CFG_mmio19_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO19_CFG_mmio19_in_inv  9

enum {
	BFW_NETX_MMIO19_CFG_mmio19_sel     = 8,  // [7:0]
	BFW_NETX_MMIO19_CFG_mmio19_out_inv = 1,  // [8]
	BFW_NETX_MMIO19_CFG_mmio19_in_inv  = 1,  // [9]
	BFW_NETX_MMIO19_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO19_CFG_BIT_Ttag {
	unsigned int mmio19_sel     : BFW_NETX_MMIO19_CFG_mmio19_sel;     // mmio19 signal selection (default: gpio19)
	unsigned int mmio19_out_inv : BFW_NETX_MMIO19_CFG_mmio19_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio19_in_inv  : BFW_NETX_MMIO19_CFG_mmio19_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO19_CFG_reserved1;      // reserved
} MMIO19_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO19_CFG_BIT_T bf;
} MMIO19_CFG_T;

// ---------------------------------------------------------------------
// Register mmio20_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio20
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO20_CFG 0x00000050U
#define NETX_MMIO20_CFG     0x1C001350U

#define MSK_NETX_MMIO20_CFG_mmio20_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO20_CFG_mmio20_sel     0
#define MSK_NETX_MMIO20_CFG_mmio20_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO20_CFG_mmio20_out_inv 8
#define MSK_NETX_MMIO20_CFG_mmio20_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO20_CFG_mmio20_in_inv  9

enum {
	BFW_NETX_MMIO20_CFG_mmio20_sel     = 8,  // [7:0]
	BFW_NETX_MMIO20_CFG_mmio20_out_inv = 1,  // [8]
	BFW_NETX_MMIO20_CFG_mmio20_in_inv  = 1,  // [9]
	BFW_NETX_MMIO20_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO20_CFG_BIT_Ttag {
	unsigned int mmio20_sel     : BFW_NETX_MMIO20_CFG_mmio20_sel;     // mmio20 signal selection (default: gpio20)
	unsigned int mmio20_out_inv : BFW_NETX_MMIO20_CFG_mmio20_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio20_in_inv  : BFW_NETX_MMIO20_CFG_mmio20_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO20_CFG_reserved1;      // reserved
} MMIO20_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO20_CFG_BIT_T bf;
} MMIO20_CFG_T;

// ---------------------------------------------------------------------
// Register mmio21_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio21
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO21_CFG 0x00000054U
#define NETX_MMIO21_CFG     0x1C001354U

#define MSK_NETX_MMIO21_CFG_mmio21_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO21_CFG_mmio21_sel     0
#define MSK_NETX_MMIO21_CFG_mmio21_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO21_CFG_mmio21_out_inv 8
#define MSK_NETX_MMIO21_CFG_mmio21_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO21_CFG_mmio21_in_inv  9

enum {
	BFW_NETX_MMIO21_CFG_mmio21_sel     = 8,  // [7:0]
	BFW_NETX_MMIO21_CFG_mmio21_out_inv = 1,  // [8]
	BFW_NETX_MMIO21_CFG_mmio21_in_inv  = 1,  // [9]
	BFW_NETX_MMIO21_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO21_CFG_BIT_Ttag {
	unsigned int mmio21_sel     : BFW_NETX_MMIO21_CFG_mmio21_sel;     // mmio21 signal selection (default: gpio21)
	unsigned int mmio21_out_inv : BFW_NETX_MMIO21_CFG_mmio21_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio21_in_inv  : BFW_NETX_MMIO21_CFG_mmio21_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO21_CFG_reserved1;      // reserved
} MMIO21_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO21_CFG_BIT_T bf;
} MMIO21_CFG_T;

// ---------------------------------------------------------------------
// Register mmio22_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio22
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO22_CFG 0x00000058U
#define NETX_MMIO22_CFG     0x1C001358U

#define MSK_NETX_MMIO22_CFG_mmio22_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO22_CFG_mmio22_sel     0
#define MSK_NETX_MMIO22_CFG_mmio22_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO22_CFG_mmio22_out_inv 8
#define MSK_NETX_MMIO22_CFG_mmio22_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO22_CFG_mmio22_in_inv  9

enum {
	BFW_NETX_MMIO22_CFG_mmio22_sel     = 8,  // [7:0]
	BFW_NETX_MMIO22_CFG_mmio22_out_inv = 1,  // [8]
	BFW_NETX_MMIO22_CFG_mmio22_in_inv  = 1,  // [9]
	BFW_NETX_MMIO22_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO22_CFG_BIT_Ttag {
	unsigned int mmio22_sel     : BFW_NETX_MMIO22_CFG_mmio22_sel;     // mmio22 signal selection (default: gpio22)
	unsigned int mmio22_out_inv : BFW_NETX_MMIO22_CFG_mmio22_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio22_in_inv  : BFW_NETX_MMIO22_CFG_mmio22_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO22_CFG_reserved1;      // reserved
} MMIO22_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO22_CFG_BIT_T bf;
} MMIO22_CFG_T;

// ---------------------------------------------------------------------
// Register mmio23_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio23
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO23_CFG 0x0000005CU
#define NETX_MMIO23_CFG     0x1C00135CU

#define MSK_NETX_MMIO23_CFG_mmio23_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO23_CFG_mmio23_sel     0
#define MSK_NETX_MMIO23_CFG_mmio23_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO23_CFG_mmio23_out_inv 8
#define MSK_NETX_MMIO23_CFG_mmio23_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO23_CFG_mmio23_in_inv  9

enum {
	BFW_NETX_MMIO23_CFG_mmio23_sel     = 8,  // [7:0]
	BFW_NETX_MMIO23_CFG_mmio23_out_inv = 1,  // [8]
	BFW_NETX_MMIO23_CFG_mmio23_in_inv  = 1,  // [9]
	BFW_NETX_MMIO23_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO23_CFG_BIT_Ttag {
	unsigned int mmio23_sel     : BFW_NETX_MMIO23_CFG_mmio23_sel;     // mmio23 signal selection (default: gpio23)
	unsigned int mmio23_out_inv : BFW_NETX_MMIO23_CFG_mmio23_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio23_in_inv  : BFW_NETX_MMIO23_CFG_mmio23_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO23_CFG_reserved1;      // reserved
} MMIO23_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO23_CFG_BIT_T bf;
} MMIO23_CFG_T;

// ---------------------------------------------------------------------
// Register mmio24_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio24
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO24_CFG 0x00000060U
#define NETX_MMIO24_CFG     0x1C001360U

#define MSK_NETX_MMIO24_CFG_mmio24_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO24_CFG_mmio24_sel     0
#define MSK_NETX_MMIO24_CFG_mmio24_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO24_CFG_mmio24_out_inv 8
#define MSK_NETX_MMIO24_CFG_mmio24_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO24_CFG_mmio24_in_inv  9

enum {
	BFW_NETX_MMIO24_CFG_mmio24_sel     = 8,  // [7:0]
	BFW_NETX_MMIO24_CFG_mmio24_out_inv = 1,  // [8]
	BFW_NETX_MMIO24_CFG_mmio24_in_inv  = 1,  // [9]
	BFW_NETX_MMIO24_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO24_CFG_BIT_Ttag {
	unsigned int mmio24_sel     : BFW_NETX_MMIO24_CFG_mmio24_sel;     // mmio24 signal selection (default: gpio24)
	unsigned int mmio24_out_inv : BFW_NETX_MMIO24_CFG_mmio24_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio24_in_inv  : BFW_NETX_MMIO24_CFG_mmio24_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO24_CFG_reserved1;      // reserved
} MMIO24_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO24_CFG_BIT_T bf;
} MMIO24_CFG_T;

// ---------------------------------------------------------------------
// Register mmio25_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio25
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO25_CFG 0x00000064U
#define NETX_MMIO25_CFG     0x1C001364U

#define MSK_NETX_MMIO25_CFG_mmio25_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO25_CFG_mmio25_sel     0
#define MSK_NETX_MMIO25_CFG_mmio25_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO25_CFG_mmio25_out_inv 8
#define MSK_NETX_MMIO25_CFG_mmio25_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO25_CFG_mmio25_in_inv  9

enum {
	BFW_NETX_MMIO25_CFG_mmio25_sel     = 8,  // [7:0]
	BFW_NETX_MMIO25_CFG_mmio25_out_inv = 1,  // [8]
	BFW_NETX_MMIO25_CFG_mmio25_in_inv  = 1,  // [9]
	BFW_NETX_MMIO25_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO25_CFG_BIT_Ttag {
	unsigned int mmio25_sel     : BFW_NETX_MMIO25_CFG_mmio25_sel;     // mmio25 signal selection (default: gpio25)
	unsigned int mmio25_out_inv : BFW_NETX_MMIO25_CFG_mmio25_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio25_in_inv  : BFW_NETX_MMIO25_CFG_mmio25_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO25_CFG_reserved1;      // reserved
} MMIO25_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO25_CFG_BIT_T bf;
} MMIO25_CFG_T;

// ---------------------------------------------------------------------
// Register mmio26_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio26
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO26_CFG 0x00000068U
#define NETX_MMIO26_CFG     0x1C001368U

#define MSK_NETX_MMIO26_CFG_mmio26_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO26_CFG_mmio26_sel     0
#define MSK_NETX_MMIO26_CFG_mmio26_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO26_CFG_mmio26_out_inv 8
#define MSK_NETX_MMIO26_CFG_mmio26_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO26_CFG_mmio26_in_inv  9

enum {
	BFW_NETX_MMIO26_CFG_mmio26_sel     = 8,  // [7:0]
	BFW_NETX_MMIO26_CFG_mmio26_out_inv = 1,  // [8]
	BFW_NETX_MMIO26_CFG_mmio26_in_inv  = 1,  // [9]
	BFW_NETX_MMIO26_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO26_CFG_BIT_Ttag {
	unsigned int mmio26_sel     : BFW_NETX_MMIO26_CFG_mmio26_sel;     // mmio26 signal selection (default: gpio26)
	unsigned int mmio26_out_inv : BFW_NETX_MMIO26_CFG_mmio26_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio26_in_inv  : BFW_NETX_MMIO26_CFG_mmio26_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO26_CFG_reserved1;      // reserved
} MMIO26_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO26_CFG_BIT_T bf;
} MMIO26_CFG_T;

// ---------------------------------------------------------------------
// Register mmio27_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio27
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO27_CFG 0x0000006CU
#define NETX_MMIO27_CFG     0x1C00136CU

#define MSK_NETX_MMIO27_CFG_mmio27_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO27_CFG_mmio27_sel     0
#define MSK_NETX_MMIO27_CFG_mmio27_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO27_CFG_mmio27_out_inv 8
#define MSK_NETX_MMIO27_CFG_mmio27_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO27_CFG_mmio27_in_inv  9

enum {
	BFW_NETX_MMIO27_CFG_mmio27_sel     = 8,  // [7:0]
	BFW_NETX_MMIO27_CFG_mmio27_out_inv = 1,  // [8]
	BFW_NETX_MMIO27_CFG_mmio27_in_inv  = 1,  // [9]
	BFW_NETX_MMIO27_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO27_CFG_BIT_Ttag {
	unsigned int mmio27_sel     : BFW_NETX_MMIO27_CFG_mmio27_sel;     // mmio27 signal selection (default: gpio27)
	unsigned int mmio27_out_inv : BFW_NETX_MMIO27_CFG_mmio27_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio27_in_inv  : BFW_NETX_MMIO27_CFG_mmio27_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO27_CFG_reserved1;      // reserved
} MMIO27_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO27_CFG_BIT_T bf;
} MMIO27_CFG_T;

// ---------------------------------------------------------------------
// Register mmio28_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio28
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO28_CFG 0x00000070U
#define NETX_MMIO28_CFG     0x1C001370U

#define MSK_NETX_MMIO28_CFG_mmio28_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO28_CFG_mmio28_sel     0
#define MSK_NETX_MMIO28_CFG_mmio28_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO28_CFG_mmio28_out_inv 8
#define MSK_NETX_MMIO28_CFG_mmio28_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO28_CFG_mmio28_in_inv  9

enum {
	BFW_NETX_MMIO28_CFG_mmio28_sel     = 8,  // [7:0]
	BFW_NETX_MMIO28_CFG_mmio28_out_inv = 1,  // [8]
	BFW_NETX_MMIO28_CFG_mmio28_in_inv  = 1,  // [9]
	BFW_NETX_MMIO28_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO28_CFG_BIT_Ttag {
	unsigned int mmio28_sel     : BFW_NETX_MMIO28_CFG_mmio28_sel;     // mmio28 signal selection (default: gpio28)
	unsigned int mmio28_out_inv : BFW_NETX_MMIO28_CFG_mmio28_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio28_in_inv  : BFW_NETX_MMIO28_CFG_mmio28_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO28_CFG_reserved1;      // reserved
} MMIO28_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO28_CFG_BIT_T bf;
} MMIO28_CFG_T;

// ---------------------------------------------------------------------
// Register mmio29_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio29
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO29_CFG 0x00000074U
#define NETX_MMIO29_CFG     0x1C001374U

#define MSK_NETX_MMIO29_CFG_mmio29_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO29_CFG_mmio29_sel     0
#define MSK_NETX_MMIO29_CFG_mmio29_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO29_CFG_mmio29_out_inv 8
#define MSK_NETX_MMIO29_CFG_mmio29_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO29_CFG_mmio29_in_inv  9

enum {
	BFW_NETX_MMIO29_CFG_mmio29_sel     = 8,  // [7:0]
	BFW_NETX_MMIO29_CFG_mmio29_out_inv = 1,  // [8]
	BFW_NETX_MMIO29_CFG_mmio29_in_inv  = 1,  // [9]
	BFW_NETX_MMIO29_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO29_CFG_BIT_Ttag {
	unsigned int mmio29_sel     : BFW_NETX_MMIO29_CFG_mmio29_sel;     // mmio29 signal selection (default: gpio29)
	unsigned int mmio29_out_inv : BFW_NETX_MMIO29_CFG_mmio29_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio29_in_inv  : BFW_NETX_MMIO29_CFG_mmio29_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO29_CFG_reserved1;      // reserved
} MMIO29_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO29_CFG_BIT_T bf;
} MMIO29_CFG_T;

// ---------------------------------------------------------------------
// Register mmio30_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio30
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO30_CFG 0x00000078U
#define NETX_MMIO30_CFG     0x1C001378U

#define MSK_NETX_MMIO30_CFG_mmio30_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO30_CFG_mmio30_sel     0
#define MSK_NETX_MMIO30_CFG_mmio30_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO30_CFG_mmio30_out_inv 8
#define MSK_NETX_MMIO30_CFG_mmio30_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO30_CFG_mmio30_in_inv  9

enum {
	BFW_NETX_MMIO30_CFG_mmio30_sel     = 8,  // [7:0]
	BFW_NETX_MMIO30_CFG_mmio30_out_inv = 1,  // [8]
	BFW_NETX_MMIO30_CFG_mmio30_in_inv  = 1,  // [9]
	BFW_NETX_MMIO30_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO30_CFG_BIT_Ttag {
	unsigned int mmio30_sel     : BFW_NETX_MMIO30_CFG_mmio30_sel;     // mmio30 signal selection (default: gpio30)
	unsigned int mmio30_out_inv : BFW_NETX_MMIO30_CFG_mmio30_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio30_in_inv  : BFW_NETX_MMIO30_CFG_mmio30_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO30_CFG_reserved1;      // reserved
} MMIO30_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO30_CFG_BIT_T bf;
} MMIO30_CFG_T;

// ---------------------------------------------------------------------
// Register mmio31_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio31
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO31_CFG 0x0000007CU
#define NETX_MMIO31_CFG     0x1C00137CU

#define MSK_NETX_MMIO31_CFG_mmio31_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO31_CFG_mmio31_sel     0
#define MSK_NETX_MMIO31_CFG_mmio31_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO31_CFG_mmio31_out_inv 8
#define MSK_NETX_MMIO31_CFG_mmio31_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO31_CFG_mmio31_in_inv  9

enum {
	BFW_NETX_MMIO31_CFG_mmio31_sel     = 8,  // [7:0]
	BFW_NETX_MMIO31_CFG_mmio31_out_inv = 1,  // [8]
	BFW_NETX_MMIO31_CFG_mmio31_in_inv  = 1,  // [9]
	BFW_NETX_MMIO31_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO31_CFG_BIT_Ttag {
	unsigned int mmio31_sel     : BFW_NETX_MMIO31_CFG_mmio31_sel;     // mmio31 signal selection (default: gpio31)
	unsigned int mmio31_out_inv : BFW_NETX_MMIO31_CFG_mmio31_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio31_in_inv  : BFW_NETX_MMIO31_CFG_mmio31_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO31_CFG_reserved1;      // reserved
} MMIO31_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO31_CFG_BIT_T bf;
} MMIO31_CFG_T;

// ---------------------------------------------------------------------
// Register mmio32_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio32
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO32_CFG 0x00000080U
#define NETX_MMIO32_CFG     0x1C001380U

#define MSK_NETX_MMIO32_CFG_mmio32_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO32_CFG_mmio32_sel     0
#define MSK_NETX_MMIO32_CFG_mmio32_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO32_CFG_mmio32_out_inv 8
#define MSK_NETX_MMIO32_CFG_mmio32_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO32_CFG_mmio32_in_inv  9

enum {
	BFW_NETX_MMIO32_CFG_mmio32_sel     = 8,  // [7:0]
	BFW_NETX_MMIO32_CFG_mmio32_out_inv = 1,  // [8]
	BFW_NETX_MMIO32_CFG_mmio32_in_inv  = 1,  // [9]
	BFW_NETX_MMIO32_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO32_CFG_BIT_Ttag {
	unsigned int mmio32_sel     : BFW_NETX_MMIO32_CFG_mmio32_sel;     // mmio32 signal selection (default: uart0_cts)
	unsigned int mmio32_out_inv : BFW_NETX_MMIO32_CFG_mmio32_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio32_in_inv  : BFW_NETX_MMIO32_CFG_mmio32_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO32_CFG_reserved1;      // reserved
} MMIO32_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO32_CFG_BIT_T bf;
} MMIO32_CFG_T;

// ---------------------------------------------------------------------
// Register mmio33_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio33
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO33_CFG 0x00000084U
#define NETX_MMIO33_CFG     0x1C001384U

#define MSK_NETX_MMIO33_CFG_mmio33_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO33_CFG_mmio33_sel     0
#define MSK_NETX_MMIO33_CFG_mmio33_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO33_CFG_mmio33_out_inv 8
#define MSK_NETX_MMIO33_CFG_mmio33_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO33_CFG_mmio33_in_inv  9

enum {
	BFW_NETX_MMIO33_CFG_mmio33_sel     = 8,  // [7:0]
	BFW_NETX_MMIO33_CFG_mmio33_out_inv = 1,  // [8]
	BFW_NETX_MMIO33_CFG_mmio33_in_inv  = 1,  // [9]
	BFW_NETX_MMIO33_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO33_CFG_BIT_Ttag {
	unsigned int mmio33_sel     : BFW_NETX_MMIO33_CFG_mmio33_sel;     // mmio33 signal selection (default: uart0_rts)
	unsigned int mmio33_out_inv : BFW_NETX_MMIO33_CFG_mmio33_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio33_in_inv  : BFW_NETX_MMIO33_CFG_mmio33_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO33_CFG_reserved1;      // reserved
} MMIO33_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO33_CFG_BIT_T bf;
} MMIO33_CFG_T;

// ---------------------------------------------------------------------
// Register mmio34_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio34
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO34_CFG 0x00000088U
#define NETX_MMIO34_CFG     0x1C001388U

#define MSK_NETX_MMIO34_CFG_mmio34_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO34_CFG_mmio34_sel     0
#define MSK_NETX_MMIO34_CFG_mmio34_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO34_CFG_mmio34_out_inv 8
#define MSK_NETX_MMIO34_CFG_mmio34_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO34_CFG_mmio34_in_inv  9

enum {
	BFW_NETX_MMIO34_CFG_mmio34_sel     = 8,  // [7:0]
	BFW_NETX_MMIO34_CFG_mmio34_out_inv = 1,  // [8]
	BFW_NETX_MMIO34_CFG_mmio34_in_inv  = 1,  // [9]
	BFW_NETX_MMIO34_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO34_CFG_BIT_Ttag {
	unsigned int mmio34_sel     : BFW_NETX_MMIO34_CFG_mmio34_sel;     // mmio34 signal selection (default: uart0_rxd)
	unsigned int mmio34_out_inv : BFW_NETX_MMIO34_CFG_mmio34_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio34_in_inv  : BFW_NETX_MMIO34_CFG_mmio34_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO34_CFG_reserved1;      // reserved
} MMIO34_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO34_CFG_BIT_T bf;
} MMIO34_CFG_T;

// ---------------------------------------------------------------------
// Register mmio35_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio35
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO35_CFG 0x0000008CU
#define NETX_MMIO35_CFG     0x1C00138CU

#define MSK_NETX_MMIO35_CFG_mmio35_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO35_CFG_mmio35_sel     0
#define MSK_NETX_MMIO35_CFG_mmio35_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO35_CFG_mmio35_out_inv 8
#define MSK_NETX_MMIO35_CFG_mmio35_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO35_CFG_mmio35_in_inv  9

enum {
	BFW_NETX_MMIO35_CFG_mmio35_sel     = 8,  // [7:0]
	BFW_NETX_MMIO35_CFG_mmio35_out_inv = 1,  // [8]
	BFW_NETX_MMIO35_CFG_mmio35_in_inv  = 1,  // [9]
	BFW_NETX_MMIO35_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO35_CFG_BIT_Ttag {
	unsigned int mmio35_sel     : BFW_NETX_MMIO35_CFG_mmio35_sel;     // mmio35 signal selection (default: uart0_txd)
	unsigned int mmio35_out_inv : BFW_NETX_MMIO35_CFG_mmio35_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio35_in_inv  : BFW_NETX_MMIO35_CFG_mmio35_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO35_CFG_reserved1;      // reserved
} MMIO35_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO35_CFG_BIT_T bf;
} MMIO35_CFG_T;

// ---------------------------------------------------------------------
// Register mmio36_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio36
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO36_CFG 0x00000090U
#define NETX_MMIO36_CFG     0x1C001390U

#define MSK_NETX_MMIO36_CFG_mmio36_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO36_CFG_mmio36_sel     0
#define MSK_NETX_MMIO36_CFG_mmio36_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO36_CFG_mmio36_out_inv 8
#define MSK_NETX_MMIO36_CFG_mmio36_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO36_CFG_mmio36_in_inv  9

enum {
	BFW_NETX_MMIO36_CFG_mmio36_sel     = 8,  // [7:0]
	BFW_NETX_MMIO36_CFG_mmio36_out_inv = 1,  // [8]
	BFW_NETX_MMIO36_CFG_mmio36_in_inv  = 1,  // [9]
	BFW_NETX_MMIO36_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO36_CFG_BIT_Ttag {
	unsigned int mmio36_sel     : BFW_NETX_MMIO36_CFG_mmio36_sel;     // mmio36 signal selection (default: usb_id_dig)
	unsigned int mmio36_out_inv : BFW_NETX_MMIO36_CFG_mmio36_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio36_in_inv  : BFW_NETX_MMIO36_CFG_mmio36_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO36_CFG_reserved1;      // reserved
} MMIO36_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO36_CFG_BIT_T bf;
} MMIO36_CFG_T;

// ---------------------------------------------------------------------
// Register mmio37_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio37
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO37_CFG 0x00000094U
#define NETX_MMIO37_CFG     0x1C001394U

#define MSK_NETX_MMIO37_CFG_mmio37_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO37_CFG_mmio37_sel     0
#define MSK_NETX_MMIO37_CFG_mmio37_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO37_CFG_mmio37_out_inv 8
#define MSK_NETX_MMIO37_CFG_mmio37_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO37_CFG_mmio37_in_inv  9

enum {
	BFW_NETX_MMIO37_CFG_mmio37_sel     = 8,  // [7:0]
	BFW_NETX_MMIO37_CFG_mmio37_out_inv = 1,  // [8]
	BFW_NETX_MMIO37_CFG_mmio37_in_inv  = 1,  // [9]
	BFW_NETX_MMIO37_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO37_CFG_BIT_Ttag {
	unsigned int mmio37_sel     : BFW_NETX_MMIO37_CFG_mmio37_sel;     // mmio37 signal selection (default: not connected)
	unsigned int mmio37_out_inv : BFW_NETX_MMIO37_CFG_mmio37_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio37_in_inv  : BFW_NETX_MMIO37_CFG_mmio37_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO37_CFG_reserved1;      // reserved
} MMIO37_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO37_CFG_BIT_T bf;
} MMIO37_CFG_T;

// ---------------------------------------------------------------------
// Register mmio38_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio38
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO38_CFG 0x00000098U
#define NETX_MMIO38_CFG     0x1C001398U

#define MSK_NETX_MMIO38_CFG_mmio38_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO38_CFG_mmio38_sel     0
#define MSK_NETX_MMIO38_CFG_mmio38_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO38_CFG_mmio38_out_inv 8
#define MSK_NETX_MMIO38_CFG_mmio38_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO38_CFG_mmio38_in_inv  9

enum {
	BFW_NETX_MMIO38_CFG_mmio38_sel     = 8,  // [7:0]
	BFW_NETX_MMIO38_CFG_mmio38_out_inv = 1,  // [8]
	BFW_NETX_MMIO38_CFG_mmio38_in_inv  = 1,  // [9]
	BFW_NETX_MMIO38_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO38_CFG_BIT_Ttag {
	unsigned int mmio38_sel     : BFW_NETX_MMIO38_CFG_mmio38_sel;     // mmio38 signal selection (default: not connected)
	unsigned int mmio38_out_inv : BFW_NETX_MMIO38_CFG_mmio38_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio38_in_inv  : BFW_NETX_MMIO38_CFG_mmio38_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO38_CFG_reserved1;      // reserved
} MMIO38_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO38_CFG_BIT_T bf;
} MMIO38_CFG_T;

// ---------------------------------------------------------------------
// Register mmio39_cfg
// =>  netX50 IO-Multiplexmatrix configuration register for signal mmio39
//     -------------------------------
//     THIS REGISTER IS netX50 ONLY!!!
//     -------------------------------
//     lockable by netX locking algorithm
//     1.: read out access key
//     2.: write back access key
//     3.: write desired value to this register
//     -------------------------------
//     Core-inputs not maped to any MMIO will be assigned to 0.
//     If one core-connection is maped to more than one MMIO, the core-input-state will be these ored MMIO-states.
//     For signal selection codings (mmio*_sel) look at header of register adr_mmio0.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_MMIO39_CFG 0x0000009CU
#define NETX_MMIO39_CFG     0x1C00139CU

#define MSK_NETX_MMIO39_CFG_mmio39_sel     0x000000ffU // [7:0]
#define SRT_NETX_MMIO39_CFG_mmio39_sel     0
#define MSK_NETX_MMIO39_CFG_mmio39_out_inv 0x00000100U // [8]
#define SRT_NETX_MMIO39_CFG_mmio39_out_inv 8
#define MSK_NETX_MMIO39_CFG_mmio39_in_inv  0x00000200U // [9]
#define SRT_NETX_MMIO39_CFG_mmio39_in_inv  9

enum {
	BFW_NETX_MMIO39_CFG_mmio39_sel     = 8,  // [7:0]
	BFW_NETX_MMIO39_CFG_mmio39_out_inv = 1,  // [8]
	BFW_NETX_MMIO39_CFG_mmio39_in_inv  = 1,  // [9]
	BFW_NETX_MMIO39_CFG_reserved1      = 22  // [31:10]
};

typedef struct MMIO39_CFG_BIT_Ttag {
	unsigned int mmio39_sel     : BFW_NETX_MMIO39_CFG_mmio39_sel;     // mmio39 signal selection (default: not connected)
	unsigned int mmio39_out_inv : BFW_NETX_MMIO39_CFG_mmio39_out_inv; // 1: invert output signal; 0: keep original signal polarity
	unsigned int mmio39_in_inv  : BFW_NETX_MMIO39_CFG_mmio39_in_inv;  // 1: invert input signal; 0: keep original signal polarity
	unsigned int reserved1      : BFW_NETX_MMIO39_CFG_reserved1;      // reserved
} MMIO39_CFG_BIT_T;

typedef union {
	unsigned int     val;
	MMIO39_CFG_BIT_T bf;
} MMIO39_CFG_T;


// =====================================================================
//
// Area of hif
//
// =====================================================================

#define NETX_HIF_AREA	0x1C003000U

// =====================================================================
//
// Area of host_controlled_dma_register_block
//
// =====================================================================

#define NETX_DPM_HOST_DMA_AREA	0x1C003000U

// ---------------------------------------------------------------------
// Register dpmhs_ch0_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_HOST_START 0x00000000U
#define NETX_DPM_HOST_CH0_HOST_START     0x1C003000U

#define MSK_NETX_DPM_HOST_CH0_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH0_HOST_START_BIT_T bf;
} DPMHS_CH0_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch0_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_NETX_START 0x00000004U
#define NETX_DPM_HOST_CH0_NETX_START     0x1C003004U

#define MSK_NETX_DPM_HOST_CH0_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH0_NETX_START_BIT_T bf;
} DPMHS_CH0_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch0_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_DMA_CTRL 0x00000008U
#define NETX_DPM_HOST_CH0_DMA_CTRL     0x1C003008U

#define MSK_NETX_DPM_HOST_CH0_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH0_DMA_CTRL_BIT_T bf;
} DPMHS_CH0_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch0_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_HOST_MBX_BASE 0x0000000CU
#define NETX_DPM_HOST_CH0_HOST_MBX_BASE     0x1C00300CU

#define MSK_NETX_DPM_HOST_CH0_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH0_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH0_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch0_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_BUF_CTRL 0x00000010U
#define NETX_DPM_HOST_CH0_BUF_CTRL     0x1C003010U

#define MSK_NETX_DPM_HOST_CH0_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH0_BUF_CTRL_BIT_T bf;
} DPMHS_CH0_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch0_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_HOST_BUF3_BASE 0x00000014U
#define NETX_DPM_HOST_CH0_HOST_BUF3_BASE     0x1C003014U

#define MSK_NETX_DPM_HOST_CH0_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH0_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH0_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch0_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_HOST_BUF2_BASE 0x00000018U
#define NETX_DPM_HOST_CH0_HOST_BUF2_BASE     0x1C003018U

#define MSK_NETX_DPM_HOST_CH0_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH0_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH0_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch0_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH0_HOST_BUF1_BASE 0x0000001CU
#define NETX_DPM_HOST_CH0_HOST_BUF1_BASE     0x1C00301CU

#define MSK_NETX_DPM_HOST_CH0_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH0_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH0_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH0_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH0_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH0_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH0_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH0_HOST_BUF1_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_HOST_START 0x00000020U
#define NETX_DPM_HOST_CH1_HOST_START     0x1C003020U

#define MSK_NETX_DPM_HOST_CH1_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH1_HOST_START_BIT_T bf;
} DPMHS_CH1_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_NETX_START 0x00000024U
#define NETX_DPM_HOST_CH1_NETX_START     0x1C003024U

#define MSK_NETX_DPM_HOST_CH1_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH1_NETX_START_BIT_T bf;
} DPMHS_CH1_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_DMA_CTRL 0x00000028U
#define NETX_DPM_HOST_CH1_DMA_CTRL     0x1C003028U

#define MSK_NETX_DPM_HOST_CH1_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH1_DMA_CTRL_BIT_T bf;
} DPMHS_CH1_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_HOST_MBX_BASE 0x0000002CU
#define NETX_DPM_HOST_CH1_HOST_MBX_BASE     0x1C00302CU

#define MSK_NETX_DPM_HOST_CH1_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH1_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH1_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_BUF_CTRL 0x00000030U
#define NETX_DPM_HOST_CH1_BUF_CTRL     0x1C003030U

#define MSK_NETX_DPM_HOST_CH1_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH1_BUF_CTRL_BIT_T bf;
} DPMHS_CH1_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_HOST_BUF3_BASE 0x00000034U
#define NETX_DPM_HOST_CH1_HOST_BUF3_BASE     0x1C003034U

#define MSK_NETX_DPM_HOST_CH1_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH1_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH1_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_HOST_BUF2_BASE 0x00000038U
#define NETX_DPM_HOST_CH1_HOST_BUF2_BASE     0x1C003038U

#define MSK_NETX_DPM_HOST_CH1_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH1_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH1_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch1_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH1_HOST_BUF1_BASE 0x0000003CU
#define NETX_DPM_HOST_CH1_HOST_BUF1_BASE     0x1C00303CU

#define MSK_NETX_DPM_HOST_CH1_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH1_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH1_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH1_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH1_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH1_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH1_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH1_HOST_BUF1_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_HOST_START 0x00000040U
#define NETX_DPM_HOST_CH2_HOST_START     0x1C003040U

#define MSK_NETX_DPM_HOST_CH2_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH2_HOST_START_BIT_T bf;
} DPMHS_CH2_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_NETX_START 0x00000044U
#define NETX_DPM_HOST_CH2_NETX_START     0x1C003044U

#define MSK_NETX_DPM_HOST_CH2_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH2_NETX_START_BIT_T bf;
} DPMHS_CH2_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_DMA_CTRL 0x00000048U
#define NETX_DPM_HOST_CH2_DMA_CTRL     0x1C003048U

#define MSK_NETX_DPM_HOST_CH2_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH2_DMA_CTRL_BIT_T bf;
} DPMHS_CH2_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_HOST_MBX_BASE 0x0000004CU
#define NETX_DPM_HOST_CH2_HOST_MBX_BASE     0x1C00304CU

#define MSK_NETX_DPM_HOST_CH2_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH2_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH2_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_BUF_CTRL 0x00000050U
#define NETX_DPM_HOST_CH2_BUF_CTRL     0x1C003050U

#define MSK_NETX_DPM_HOST_CH2_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH2_BUF_CTRL_BIT_T bf;
} DPMHS_CH2_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_HOST_BUF3_BASE 0x00000054U
#define NETX_DPM_HOST_CH2_HOST_BUF3_BASE     0x1C003054U

#define MSK_NETX_DPM_HOST_CH2_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH2_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH2_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_HOST_BUF2_BASE 0x00000058U
#define NETX_DPM_HOST_CH2_HOST_BUF2_BASE     0x1C003058U

#define MSK_NETX_DPM_HOST_CH2_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH2_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH2_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch2_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH2_HOST_BUF1_BASE 0x0000005CU
#define NETX_DPM_HOST_CH2_HOST_BUF1_BASE     0x1C00305CU

#define MSK_NETX_DPM_HOST_CH2_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH2_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH2_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH2_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH2_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH2_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH2_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH2_HOST_BUF1_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_HOST_START 0x00000060U
#define NETX_DPM_HOST_CH3_HOST_START     0x1C003060U

#define MSK_NETX_DPM_HOST_CH3_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH3_HOST_START_BIT_T bf;
} DPMHS_CH3_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_NETX_START 0x00000064U
#define NETX_DPM_HOST_CH3_NETX_START     0x1C003064U

#define MSK_NETX_DPM_HOST_CH3_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH3_NETX_START_BIT_T bf;
} DPMHS_CH3_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_DMA_CTRL 0x00000068U
#define NETX_DPM_HOST_CH3_DMA_CTRL     0x1C003068U

#define MSK_NETX_DPM_HOST_CH3_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH3_DMA_CTRL_BIT_T bf;
} DPMHS_CH3_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_HOST_MBX_BASE 0x0000006CU
#define NETX_DPM_HOST_CH3_HOST_MBX_BASE     0x1C00306CU

#define MSK_NETX_DPM_HOST_CH3_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH3_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH3_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_BUF_CTRL 0x00000070U
#define NETX_DPM_HOST_CH3_BUF_CTRL     0x1C003070U

#define MSK_NETX_DPM_HOST_CH3_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH3_BUF_CTRL_BIT_T bf;
} DPMHS_CH3_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_HOST_BUF3_BASE 0x00000074U
#define NETX_DPM_HOST_CH3_HOST_BUF3_BASE     0x1C003074U

#define MSK_NETX_DPM_HOST_CH3_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH3_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH3_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_HOST_BUF2_BASE 0x00000078U
#define NETX_DPM_HOST_CH3_HOST_BUF2_BASE     0x1C003078U

#define MSK_NETX_DPM_HOST_CH3_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH3_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH3_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch3_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH3_HOST_BUF1_BASE 0x0000007CU
#define NETX_DPM_HOST_CH3_HOST_BUF1_BASE     0x1C00307CU

#define MSK_NETX_DPM_HOST_CH3_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH3_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH3_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH3_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH3_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH3_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH3_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH3_HOST_BUF1_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_HOST_START 0x00000080U
#define NETX_DPM_HOST_CH4_HOST_START     0x1C003080U

#define MSK_NETX_DPM_HOST_CH4_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH4_HOST_START_BIT_T bf;
} DPMHS_CH4_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_NETX_START 0x00000084U
#define NETX_DPM_HOST_CH4_NETX_START     0x1C003084U

#define MSK_NETX_DPM_HOST_CH4_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH4_NETX_START_BIT_T bf;
} DPMHS_CH4_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_DMA_CTRL 0x00000088U
#define NETX_DPM_HOST_CH4_DMA_CTRL     0x1C003088U

#define MSK_NETX_DPM_HOST_CH4_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH4_DMA_CTRL_BIT_T bf;
} DPMHS_CH4_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_HOST_MBX_BASE 0x0000008CU
#define NETX_DPM_HOST_CH4_HOST_MBX_BASE     0x1C00308CU

#define MSK_NETX_DPM_HOST_CH4_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH4_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH4_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_BUF_CTRL 0x00000090U
#define NETX_DPM_HOST_CH4_BUF_CTRL     0x1C003090U

#define MSK_NETX_DPM_HOST_CH4_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH4_BUF_CTRL_BIT_T bf;
} DPMHS_CH4_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_HOST_BUF3_BASE 0x00000094U
#define NETX_DPM_HOST_CH4_HOST_BUF3_BASE     0x1C003094U

#define MSK_NETX_DPM_HOST_CH4_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH4_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH4_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_HOST_BUF2_BASE 0x00000098U
#define NETX_DPM_HOST_CH4_HOST_BUF2_BASE     0x1C003098U

#define MSK_NETX_DPM_HOST_CH4_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH4_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH4_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch4_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH4_HOST_BUF1_BASE 0x0000009CU
#define NETX_DPM_HOST_CH4_HOST_BUF1_BASE     0x1C00309CU

#define MSK_NETX_DPM_HOST_CH4_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH4_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH4_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH4_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH4_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH4_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH4_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH4_HOST_BUF1_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_HOST_START 0x000000A0U
#define NETX_DPM_HOST_CH5_HOST_START     0x1C0030A0U

#define MSK_NETX_DPM_HOST_CH5_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH5_HOST_START_BIT_T bf;
} DPMHS_CH5_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_NETX_START 0x000000A4U
#define NETX_DPM_HOST_CH5_NETX_START     0x1C0030A4U

#define MSK_NETX_DPM_HOST_CH5_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH5_NETX_START_BIT_T bf;
} DPMHS_CH5_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_DMA_CTRL 0x000000A8U
#define NETX_DPM_HOST_CH5_DMA_CTRL     0x1C0030A8U

#define MSK_NETX_DPM_HOST_CH5_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH5_DMA_CTRL_BIT_T bf;
} DPMHS_CH5_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_HOST_MBX_BASE 0x000000ACU
#define NETX_DPM_HOST_CH5_HOST_MBX_BASE     0x1C0030ACU

#define MSK_NETX_DPM_HOST_CH5_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH5_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH5_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_BUF_CTRL 0x000000B0U
#define NETX_DPM_HOST_CH5_BUF_CTRL     0x1C0030B0U

#define MSK_NETX_DPM_HOST_CH5_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH5_BUF_CTRL_BIT_T bf;
} DPMHS_CH5_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_HOST_BUF3_BASE 0x000000B4U
#define NETX_DPM_HOST_CH5_HOST_BUF3_BASE     0x1C0030B4U

#define MSK_NETX_DPM_HOST_CH5_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH5_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH5_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_HOST_BUF2_BASE 0x000000B8U
#define NETX_DPM_HOST_CH5_HOST_BUF2_BASE     0x1C0030B8U

#define MSK_NETX_DPM_HOST_CH5_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH5_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH5_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch5_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH5_HOST_BUF1_BASE 0x000000BCU
#define NETX_DPM_HOST_CH5_HOST_BUF1_BASE     0x1C0030BCU

#define MSK_NETX_DPM_HOST_CH5_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH5_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH5_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH5_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH5_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH5_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH5_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH5_HOST_BUF1_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_HOST_START 0x000000C0U
#define NETX_DPM_HOST_CH6_HOST_START     0x1C0030C0U

#define MSK_NETX_DPM_HOST_CH6_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH6_HOST_START_BIT_T bf;
} DPMHS_CH6_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_NETX_START 0x000000C4U
#define NETX_DPM_HOST_CH6_NETX_START     0x1C0030C4U

#define MSK_NETX_DPM_HOST_CH6_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH6_NETX_START_BIT_T bf;
} DPMHS_CH6_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_DMA_CTRL 0x000000C8U
#define NETX_DPM_HOST_CH6_DMA_CTRL     0x1C0030C8U

#define MSK_NETX_DPM_HOST_CH6_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH6_DMA_CTRL_BIT_T bf;
} DPMHS_CH6_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_HOST_MBX_BASE 0x000000CCU
#define NETX_DPM_HOST_CH6_HOST_MBX_BASE     0x1C0030CCU

#define MSK_NETX_DPM_HOST_CH6_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH6_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH6_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_BUF_CTRL 0x000000D0U
#define NETX_DPM_HOST_CH6_BUF_CTRL     0x1C0030D0U

#define MSK_NETX_DPM_HOST_CH6_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH6_BUF_CTRL_BIT_T bf;
} DPMHS_CH6_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_HOST_BUF3_BASE 0x000000D4U
#define NETX_DPM_HOST_CH6_HOST_BUF3_BASE     0x1C0030D4U

#define MSK_NETX_DPM_HOST_CH6_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH6_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH6_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_HOST_BUF2_BASE 0x000000D8U
#define NETX_DPM_HOST_CH6_HOST_BUF2_BASE     0x1C0030D8U

#define MSK_NETX_DPM_HOST_CH6_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH6_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH6_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch6_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH6_HOST_BUF1_BASE 0x000000DCU
#define NETX_DPM_HOST_CH6_HOST_BUF1_BASE     0x1C0030DCU

#define MSK_NETX_DPM_HOST_CH6_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH6_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH6_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH6_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH6_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH6_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH6_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH6_HOST_BUF1_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_HOST_START 0x000000E0U
#define NETX_DPM_HOST_CH7_HOST_START     0x1C0030E0U

#define MSK_NETX_DPM_HOST_CH7_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH7_HOST_START_BIT_T bf;
} DPMHS_CH7_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_NETX_START 0x000000E4U
#define NETX_DPM_HOST_CH7_NETX_START     0x1C0030E4U

#define MSK_NETX_DPM_HOST_CH7_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMHS_CH7_NETX_START_BIT_T bf;
} DPMHS_CH7_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_DMA_CTRL 0x000000E8U
#define NETX_DPM_HOST_CH7_DMA_CTRL     0x1C0030E8U

#define MSK_NETX_DPM_HOST_CH7_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH7_DMA_CTRL_BIT_T bf;
} DPMHS_CH7_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_host_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_HOST_MBX_BASE 0x000000ECU
#define NETX_DPM_HOST_CH7_HOST_MBX_BASE     0x1C0030ECU

#define MSK_NETX_DPM_HOST_CH7_HOST_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_HOST_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_HOST_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_HOST_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	DPMHS_CH7_HOST_MBX_BASE_BIT_T bf;
} DPMHS_CH7_HOST_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_BUF_CTRL 0x000000F0U
#define NETX_DPM_HOST_CH7_BUF_CTRL     0x1C0030F0U

#define MSK_NETX_DPM_HOST_CH7_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMHS_CH7_BUF_CTRL_BIT_T bf;
} DPMHS_CH7_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_host_buf3_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_HOST_BUF3_BASE 0x000000F4U
#define NETX_DPM_HOST_CH7_HOST_BUF3_BASE     0x1C0030F4U

#define MSK_NETX_DPM_HOST_CH7_HOST_BUF3_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_HOST_BUF3_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_HOST_BUF3_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_HOST_BUF3_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH7_HOST_BUF3_BASE_BIT_T bf;
} DPMHS_CH7_HOST_BUF3_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_host_buf2_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_HOST_BUF2_BASE 0x000000F8U
#define NETX_DPM_HOST_CH7_HOST_BUF2_BASE     0x1C0030F8U

#define MSK_NETX_DPM_HOST_CH7_HOST_BUF2_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_HOST_BUF2_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_HOST_BUF2_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_HOST_BUF2_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH7_HOST_BUF2_BASE_BIT_T bf;
} DPMHS_CH7_HOST_BUF2_BASE_T;

// ---------------------------------------------------------------------
// Register dpmhs_ch7_host_buf1_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_CH7_HOST_BUF1_BASE 0x000000FCU
#define NETX_DPM_HOST_CH7_HOST_BUF1_BASE     0x1C0030FCU

#define MSK_NETX_DPM_HOST_CH7_HOST_BUF1_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_CH7_HOST_BUF1_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_CH7_HOST_BUF1_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_CH7_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_CH7_HOST_BUF1_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_CH7_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                   val;
	DPMHS_CH7_HOST_BUF1_BASE_BIT_T bf;
} DPMHS_CH7_HOST_BUF1_BASE_T;


// =====================================================================
//
// Area of host_controlled_global_register_block
//
// =====================================================================

#define NETX_DPM_HOST_GLOB_AREA	0x1C003100U

// ---------------------------------------------------------------------
// Register pci_base
// =>  dpmhs_pci_targ2_mem_base
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_PCI_BASE 0x000000BCU
#define NETX_DPM_HOST_PCI_BASE     0x1C0031BCU

#define MSK_NETX_DPM_HOST_PCI_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_PCI_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_PCI_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_PCI_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_BASE_BIT_T;

typedef union {
	unsigned int   val;
	PCI_BASE_BIT_T bf;
} PCI_BASE_T;

// ---------------------------------------------------------------------
// Register wdg_host
// =>  dpmhs_wdg_host_timeout
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_WDG_HOST_TIMEOUT 0x000000C0U
#define NETX_DPM_HOST_WDG_HOST_TIMEOUT     0x1C0031C0U

#define MSK_NETX_DPM_HOST_WDG_HOST_TIMEOUT_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_WDG_HOST_TIMEOUT_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_WDG_HOST_TIMEOUT_keine_ahnung = 32  // [31:0]
};

typedef struct WDG_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_WDG_HOST_TIMEOUT_keine_ahnung; // HIF, ask Hilscher HIF specialists
} WDG_HOST_BIT_T;

typedef union {
	unsigned int   val;
	WDG_HOST_BIT_T bf;
} WDG_HOST_T;

// ---------------------------------------------------------------------
// Register dpmhs_wdg_host_trig
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_WDG_HOST_TRIG 0x000000C4U
#define NETX_DPM_HOST_WDG_HOST_TRIG     0x1C0031C4U

#define MSK_NETX_DPM_HOST_WDG_HOST_TRIG_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_WDG_HOST_TRIG_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_WDG_HOST_TRIG_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_WDG_HOST_TRIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_WDG_HOST_TRIG_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_WDG_HOST_TRIG_BIT_T;

typedef union {
	unsigned int              val;
	DPMHS_WDG_HOST_TRIG_BIT_T bf;
} DPMHS_WDG_HOST_TRIG_T;

// ---------------------------------------------------------------------
// Register dpmhs_wdg_arm_timeout
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_WDG_ARM_TIMEOUT 0x000000C8U
#define NETX_DPM_HOST_WDG_ARM_TIMEOUT     0x1C0031C8U

#define MSK_NETX_DPM_HOST_WDG_ARM_TIMEOUT_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_WDG_ARM_TIMEOUT_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_WDG_ARM_TIMEOUT_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_WDG_ARM_TIMEOUT_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_WDG_ARM_TIMEOUT_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_WDG_ARM_TIMEOUT_BIT_T;

typedef union {
	unsigned int                val;
	DPMHS_WDG_ARM_TIMEOUT_BIT_T bf;
} DPMHS_WDG_ARM_TIMEOUT_T;

// ---------------------------------------------------------------------
// Register cyclic_tmr_control
// =>  dpmhs_tmr_ctrl
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_TMR_CTRL 0x000000D0U
#define NETX_DPM_HOST_TMR_CTRL     0x1C0031D0U

#define MSK_NETX_DPM_HOST_TMR_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_TMR_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_TMR_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct CYCLIC_TMR_CONTROL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_TMR_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} CYCLIC_TMR_CONTROL_BIT_T;

typedef union {
	unsigned int             val;
	CYCLIC_TMR_CONTROL_BIT_T bf;
} CYCLIC_TMR_CONTROL_T;

// ---------------------------------------------------------------------
// Register cyclic_tmr_reload
// =>  dpmhs_tmr_start_value
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_TMR_START_VAL 0x000000D4U
#define NETX_DPM_HOST_TMR_START_VAL     0x1C0031D4U

#define MSK_NETX_DPM_HOST_TMR_START_VAL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_TMR_START_VAL_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_TMR_START_VAL_keine_ahnung = 32  // [31:0]
};

typedef struct CYCLIC_TMR_RELOAD_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_TMR_START_VAL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} CYCLIC_TMR_RELOAD_BIT_T;

typedef union {
	unsigned int            val;
	CYCLIC_TMR_RELOAD_BIT_T bf;
} CYCLIC_TMR_RELOAD_T;

// ---------------------------------------------------------------------
// Register sta_host
// =>  dpmhs_sys_sta
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_SYS_STAT 0x000000D8U
#define NETX_DPM_HOST_SYS_STAT     0x1C0031D8U

#define MSK_NETX_DPM_HOST_SYS_STAT_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_SYS_STAT_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_SYS_STAT_keine_ahnung = 32  // [31:0]
};

typedef struct STA_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_SYS_STAT_keine_ahnung; // HIF, ask Hilscher HIF specialists
} STA_HOST_BIT_T;

typedef union {
	unsigned int   val;
	STA_HOST_BIT_T bf;
} STA_HOST_T;

// ---------------------------------------------------------------------
// Register res_reg
// =>  dpmhs_res_req
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_RESET_REQ 0x000000DCU
#define NETX_DPM_HOST_RESET_REQ     0x1C0031DCU

#define MSK_NETX_DPM_HOST_RESET_REQ_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_RESET_REQ_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_RESET_REQ_keine_ahnung = 32  // [31:0]
};

typedef struct RES_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_RESET_REQ_keine_ahnung; // HIF, ask Hilscher HIF specialists
} RES_REG_BIT_T;

typedef union {
	unsigned int  val;
	RES_REG_BIT_T bf;
} RES_REG_T;

// ---------------------------------------------------------------------
// Register irq_reg_host
// =>  dpmhs_int_sta0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_STAT0 0x000000E0U
#define NETX_DPM_HOST_INT_STAT0     0x1C0031E0U

#define MSK_NETX_DPM_HOST_INT_STAT0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_INT_STAT0_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_INT_STAT0_keine_ahnung = 32  // [31:0]
};

typedef struct IRQ_REG_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_INT_STAT0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IRQ_REG_HOST_BIT_T;

typedef union {
	unsigned int       val;
	IRQ_REG_HOST_BIT_T bf;
} IRQ_REG_HOST_T;

// ---------------------------------------------------------------------
// Register irq_reg_host1
// =>  dpmhs_int_sta1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_STAT1 0x000000E4U
#define NETX_DPM_HOST_INT_STAT1     0x1C0031E4U

#define MSK_NETX_DPM_HOST_INT_STAT1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_INT_STAT1_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_INT_STAT1_keine_ahnung = 32  // [31:0]
};

typedef struct IRQ_REG_HOST1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_INT_STAT1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IRQ_REG_HOST1_BIT_T;

typedef union {
	unsigned int        val;
	IRQ_REG_HOST1_BIT_T bf;
} IRQ_REG_HOST1_T;

// ---------------------------------------------------------------------
// Register dpmhs_int_en0
// =>  adr_dpmhs_int_en0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_EN0 0x000000F0U
#define NETX_DPM_HOST_INT_EN0     0x1C0031F0U

#define MSK_NETX_DPM_HOST_INT_EN0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_INT_EN0_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_INT_EN0_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_INT_EN0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_INT_EN0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_INT_EN0_BIT_T;

typedef union {
	unsigned int        val;
	DPMHS_INT_EN0_BIT_T bf;
} DPMHS_INT_EN0_T;

// ---------------------------------------------------------------------
// Register adr_dpmhs_int_en1
// =>  adr_dpmhs_int_en1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_INT_EN1 0x000000F4U
#define NETX_DPM_HOST_INT_EN1     0x1C0031F4U

#define MSK_NETX_DPM_HOST_INT_EN1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_INT_EN1_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_INT_EN1_keine_ahnung = 32  // [31:0]
};

typedef struct ADR_DPMHS_INT_EN1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_INT_EN1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} ADR_DPMHS_INT_EN1_BIT_T;

typedef union {
	unsigned int            val;
	ADR_DPMHS_INT_EN1_BIT_T bf;
} ADR_DPMHS_INT_EN1_T;


// =====================================================================
//
// Area of host_controlled_handshake_register_block
//
// =====================================================================

#define NETX_DPM_HOST_HS_AREA	0x1C003200U

// ---------------------------------------------------------------------
// Register dpmhs_hs_data0
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA0 0x00000000U
#define NETX_DPM_HOST_HS_DATA0     0x1C003200U

#define MSK_NETX_DPM_HOST_HS_DATA0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA0_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA0_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA0_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA0_BIT_T bf;
} DPMHS_HS_DATA0_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA1 0x00000004U
#define NETX_DPM_HOST_HS_DATA1     0x1C003204U

#define MSK_NETX_DPM_HOST_HS_DATA1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA1_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA1_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA1_BIT_T bf;
} DPMHS_HS_DATA1_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA2 0x00000008U
#define NETX_DPM_HOST_HS_DATA2     0x1C003208U

#define MSK_NETX_DPM_HOST_HS_DATA2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA2_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA2_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA2_BIT_T bf;
} DPMHS_HS_DATA2_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA3 0x0000000CU
#define NETX_DPM_HOST_HS_DATA3     0x1C00320CU

#define MSK_NETX_DPM_HOST_HS_DATA3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA3_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA3_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA3_BIT_T bf;
} DPMHS_HS_DATA3_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data4
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA4 0x00000010U
#define NETX_DPM_HOST_HS_DATA4     0x1C003210U

#define MSK_NETX_DPM_HOST_HS_DATA4_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA4_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA4_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA4_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA4_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA4_BIT_T bf;
} DPMHS_HS_DATA4_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data5
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA5 0x00000014U
#define NETX_DPM_HOST_HS_DATA5     0x1C003214U

#define MSK_NETX_DPM_HOST_HS_DATA5_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA5_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA5_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA5_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA5_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA5_BIT_T bf;
} DPMHS_HS_DATA5_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data6
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA6 0x00000018U
#define NETX_DPM_HOST_HS_DATA6     0x1C003218U

#define MSK_NETX_DPM_HOST_HS_DATA6_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA6_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA6_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA6_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA6_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA6_BIT_T bf;
} DPMHS_HS_DATA6_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data7
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA7 0x0000001CU
#define NETX_DPM_HOST_HS_DATA7     0x1C00321CU

#define MSK_NETX_DPM_HOST_HS_DATA7_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA7_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA7_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA7_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA7_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA7_BIT_T bf;
} DPMHS_HS_DATA7_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data8
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA8 0x00000020U
#define NETX_DPM_HOST_HS_DATA8     0x1C003220U

#define MSK_NETX_DPM_HOST_HS_DATA8_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA8_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA8_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA8_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA8_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA8_BIT_T bf;
} DPMHS_HS_DATA8_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data9
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA9 0x00000024U
#define NETX_DPM_HOST_HS_DATA9     0x1C003224U

#define MSK_NETX_DPM_HOST_HS_DATA9_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA9_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA9_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA9_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA9_BIT_T;

typedef union {
	unsigned int         val;
	DPMHS_HS_DATA9_BIT_T bf;
} DPMHS_HS_DATA9_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data10
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA10 0x00000028U
#define NETX_DPM_HOST_HS_DATA10     0x1C003228U

#define MSK_NETX_DPM_HOST_HS_DATA10_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA10_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA10_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA10_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA10_BIT_T;

typedef union {
	unsigned int          val;
	DPMHS_HS_DATA10_BIT_T bf;
} DPMHS_HS_DATA10_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data11
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA11 0x0000002CU
#define NETX_DPM_HOST_HS_DATA11     0x1C00322CU

#define MSK_NETX_DPM_HOST_HS_DATA11_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA11_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA11_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA11_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA11_BIT_T;

typedef union {
	unsigned int          val;
	DPMHS_HS_DATA11_BIT_T bf;
} DPMHS_HS_DATA11_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data12
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA12 0x00000030U
#define NETX_DPM_HOST_HS_DATA12     0x1C003230U

#define MSK_NETX_DPM_HOST_HS_DATA12_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA12_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA12_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA12_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA12_BIT_T;

typedef union {
	unsigned int          val;
	DPMHS_HS_DATA12_BIT_T bf;
} DPMHS_HS_DATA12_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data13
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA13 0x00000034U
#define NETX_DPM_HOST_HS_DATA13     0x1C003234U

#define MSK_NETX_DPM_HOST_HS_DATA13_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA13_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA13_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA13_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA13_BIT_T;

typedef union {
	unsigned int          val;
	DPMHS_HS_DATA13_BIT_T bf;
} DPMHS_HS_DATA13_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data14
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA14 0x00000038U
#define NETX_DPM_HOST_HS_DATA14     0x1C003238U

#define MSK_NETX_DPM_HOST_HS_DATA14_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA14_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA14_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA14_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA14_BIT_T;

typedef union {
	unsigned int          val;
	DPMHS_HS_DATA14_BIT_T bf;
} DPMHS_HS_DATA14_T;

// ---------------------------------------------------------------------
// Register dpmhs_hs_data15
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_HOST_HS_DATA15 0x0000003CU
#define NETX_DPM_HOST_HS_DATA15     0x1C00323CU

#define MSK_NETX_DPM_HOST_HS_DATA15_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_HOST_HS_DATA15_keine_ahnung 0

enum {
	BFW_NETX_DPM_HOST_HS_DATA15_keine_ahnung = 32  // [31:0]
};

typedef struct DPMHS_HS_DATA15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_HOST_HS_DATA15_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMHS_HS_DATA15_BIT_T;

typedef union {
	unsigned int          val;
	DPMHS_HS_DATA15_BIT_T bf;
} DPMHS_HS_DATA15_T;


// =====================================================================
//
// Area of netx_controlled_dma_register_block
//
// =====================================================================

#define NETX_DPM_ARM_DMA_AREA	0x1C003300U

// ---------------------------------------------------------------------
// Register dpmas_ch0_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_HOST_START 0x00000000U
#define NETX_DPM_ARM_CH0_HOST_START     0x1C003300U

#define MSK_NETX_DPM_ARM_CH0_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH0_HOST_START_BIT_T bf;
} DPMAS_CH0_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch0_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_NETX_START 0x00000004U
#define NETX_DPM_ARM_CH0_NETX_START     0x1C003304U

#define MSK_NETX_DPM_ARM_CH0_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH0_NETX_START_BIT_T bf;
} DPMAS_CH0_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch0_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_DMA_CTRL 0x00000008U
#define NETX_DPM_ARM_CH0_DMA_CTRL     0x1C003308U

#define MSK_NETX_DPM_ARM_CH0_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH0_DMA_CTRL_BIT_T bf;
} DPMAS_CH0_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch0_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_MBX_BASE 0x0000000CU
#define NETX_DPM_ARM_CH0_MBX_BASE     0x1C00330CU

#define MSK_NETX_DPM_ARM_CH0_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH0_MBX_BASE_BIT_T bf;
} DPMAS_CH0_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch0_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_BUF_CTRL 0x00000010U
#define NETX_DPM_ARM_CH0_BUF_CTRL     0x1C003310U

#define MSK_NETX_DPM_ARM_CH0_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH0_BUF_CTRL_BIT_T bf;
} DPMAS_CH0_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch0_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_NETX_BUF_BASE3 0x00000014U
#define NETX_DPM_ARM_CH0_NETX_BUF_BASE3     0x1C003314U

#define MSK_NETX_DPM_ARM_CH0_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH0_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH0_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch0_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_NETX_BUF_BASE2 0x00000018U
#define NETX_DPM_ARM_CH0_NETX_BUF_BASE2     0x1C003318U

#define MSK_NETX_DPM_ARM_CH0_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH0_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH0_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch0_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH0_NETX_BUF_BASE1 0x0000001CU
#define NETX_DPM_ARM_CH0_NETX_BUF_BASE1     0x1C00331CU

#define MSK_NETX_DPM_ARM_CH0_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH0_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH0_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH0_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH0_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH0_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH0_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH0_NETX_BUF_BASE1_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_HOST_START 0x00000020U
#define NETX_DPM_ARM_CH1_HOST_START     0x1C003320U

#define MSK_NETX_DPM_ARM_CH1_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH1_HOST_START_BIT_T bf;
} DPMAS_CH1_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_NETX_START 0x00000024U
#define NETX_DPM_ARM_CH1_NETX_START     0x1C003324U

#define MSK_NETX_DPM_ARM_CH1_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH1_NETX_START_BIT_T bf;
} DPMAS_CH1_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_DMA_CTRL 0x00000028U
#define NETX_DPM_ARM_CH1_DMA_CTRL     0x1C003328U

#define MSK_NETX_DPM_ARM_CH1_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH1_DMA_CTRL_BIT_T bf;
} DPMAS_CH1_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_MBX_BASE 0x0000002CU
#define NETX_DPM_ARM_CH1_MBX_BASE     0x1C00332CU

#define MSK_NETX_DPM_ARM_CH1_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH1_MBX_BASE_BIT_T bf;
} DPMAS_CH1_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_BUF_CTRL 0x00000030U
#define NETX_DPM_ARM_CH1_BUF_CTRL     0x1C003330U

#define MSK_NETX_DPM_ARM_CH1_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH1_BUF_CTRL_BIT_T bf;
} DPMAS_CH1_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_NETX_BUF_BASE3 0x00000034U
#define NETX_DPM_ARM_CH1_NETX_BUF_BASE3     0x1C003334U

#define MSK_NETX_DPM_ARM_CH1_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH1_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH1_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_NETX_BUF_BASE2 0x00000038U
#define NETX_DPM_ARM_CH1_NETX_BUF_BASE2     0x1C003338U

#define MSK_NETX_DPM_ARM_CH1_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH1_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH1_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch1_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH1_NETX_BUF_BASE1 0x0000003CU
#define NETX_DPM_ARM_CH1_NETX_BUF_BASE1     0x1C00333CU

#define MSK_NETX_DPM_ARM_CH1_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH1_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH1_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH1_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH1_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH1_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH1_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH1_NETX_BUF_BASE1_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_HOST_START 0x00000040U
#define NETX_DPM_ARM_CH2_HOST_START     0x1C003340U

#define MSK_NETX_DPM_ARM_CH2_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH2_HOST_START_BIT_T bf;
} DPMAS_CH2_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_NETX_START 0x00000044U
#define NETX_DPM_ARM_CH2_NETX_START     0x1C003344U

#define MSK_NETX_DPM_ARM_CH2_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH2_NETX_START_BIT_T bf;
} DPMAS_CH2_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_DMA_CTRL 0x00000048U
#define NETX_DPM_ARM_CH2_DMA_CTRL     0x1C003348U

#define MSK_NETX_DPM_ARM_CH2_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH2_DMA_CTRL_BIT_T bf;
} DPMAS_CH2_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_MBX_BASE 0x0000004CU
#define NETX_DPM_ARM_CH2_MBX_BASE     0x1C00334CU

#define MSK_NETX_DPM_ARM_CH2_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH2_MBX_BASE_BIT_T bf;
} DPMAS_CH2_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_BUF_CTRL 0x00000050U
#define NETX_DPM_ARM_CH2_BUF_CTRL     0x1C003350U

#define MSK_NETX_DPM_ARM_CH2_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH2_BUF_CTRL_BIT_T bf;
} DPMAS_CH2_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_NETX_BUF_BASE3 0x00000054U
#define NETX_DPM_ARM_CH2_NETX_BUF_BASE3     0x1C003354U

#define MSK_NETX_DPM_ARM_CH2_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH2_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH2_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_NETX_BUF_BASE2 0x00000058U
#define NETX_DPM_ARM_CH2_NETX_BUF_BASE2     0x1C003358U

#define MSK_NETX_DPM_ARM_CH2_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH2_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH2_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch2_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH2_NETX_BUF_BASE1 0x0000005CU
#define NETX_DPM_ARM_CH2_NETX_BUF_BASE1     0x1C00335CU

#define MSK_NETX_DPM_ARM_CH2_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH2_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH2_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH2_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH2_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH2_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH2_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH2_NETX_BUF_BASE1_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_HOST_START 0x00000060U
#define NETX_DPM_ARM_CH3_HOST_START     0x1C003360U

#define MSK_NETX_DPM_ARM_CH3_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH3_HOST_START_BIT_T bf;
} DPMAS_CH3_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_NETX_START 0x00000064U
#define NETX_DPM_ARM_CH3_NETX_START     0x1C003364U

#define MSK_NETX_DPM_ARM_CH3_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH3_NETX_START_BIT_T bf;
} DPMAS_CH3_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_DMA_CTRL 0x00000068U
#define NETX_DPM_ARM_CH3_DMA_CTRL     0x1C003368U

#define MSK_NETX_DPM_ARM_CH3_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH3_DMA_CTRL_BIT_T bf;
} DPMAS_CH3_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_MBX_BASE 0x0000006CU
#define NETX_DPM_ARM_CH3_MBX_BASE     0x1C00336CU

#define MSK_NETX_DPM_ARM_CH3_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH3_MBX_BASE_BIT_T bf;
} DPMAS_CH3_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_BUF_CTRL 0x00000070U
#define NETX_DPM_ARM_CH3_BUF_CTRL     0x1C003370U

#define MSK_NETX_DPM_ARM_CH3_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH3_BUF_CTRL_BIT_T bf;
} DPMAS_CH3_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_NETX_BUF_BASE3 0x00000074U
#define NETX_DPM_ARM_CH3_NETX_BUF_BASE3     0x1C003374U

#define MSK_NETX_DPM_ARM_CH3_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH3_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH3_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_NETX_BUF_BASE2 0x00000078U
#define NETX_DPM_ARM_CH3_NETX_BUF_BASE2     0x1C003378U

#define MSK_NETX_DPM_ARM_CH3_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH3_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH3_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch3_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH3_NETX_BUF_BASE1 0x0000007CU
#define NETX_DPM_ARM_CH3_NETX_BUF_BASE1     0x1C00337CU

#define MSK_NETX_DPM_ARM_CH3_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH3_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH3_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH3_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH3_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH3_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH3_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH3_NETX_BUF_BASE1_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_HOST_START 0x00000080U
#define NETX_DPM_ARM_CH4_HOST_START     0x1C003380U

#define MSK_NETX_DPM_ARM_CH4_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH4_HOST_START_BIT_T bf;
} DPMAS_CH4_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_NETX_START 0x00000084U
#define NETX_DPM_ARM_CH4_NETX_START     0x1C003384U

#define MSK_NETX_DPM_ARM_CH4_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH4_NETX_START_BIT_T bf;
} DPMAS_CH4_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_DMA_CTRL 0x00000088U
#define NETX_DPM_ARM_CH4_DMA_CTRL     0x1C003388U

#define MSK_NETX_DPM_ARM_CH4_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH4_DMA_CTRL_BIT_T bf;
} DPMAS_CH4_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_MBX_BASE 0x0000008CU
#define NETX_DPM_ARM_CH4_MBX_BASE     0x1C00338CU

#define MSK_NETX_DPM_ARM_CH4_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH4_MBX_BASE_BIT_T bf;
} DPMAS_CH4_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_BUF_CTRL 0x00000090U
#define NETX_DPM_ARM_CH4_BUF_CTRL     0x1C003390U

#define MSK_NETX_DPM_ARM_CH4_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH4_BUF_CTRL_BIT_T bf;
} DPMAS_CH4_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_NETX_BUF_BASE3 0x00000094U
#define NETX_DPM_ARM_CH4_NETX_BUF_BASE3     0x1C003394U

#define MSK_NETX_DPM_ARM_CH4_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH4_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH4_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_NETX_BUF_BASE2 0x00000098U
#define NETX_DPM_ARM_CH4_NETX_BUF_BASE2     0x1C003398U

#define MSK_NETX_DPM_ARM_CH4_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH4_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH4_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch4_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH4_NETX_BUF_BASE1 0x0000009CU
#define NETX_DPM_ARM_CH4_NETX_BUF_BASE1     0x1C00339CU

#define MSK_NETX_DPM_ARM_CH4_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH4_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH4_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH4_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH4_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH4_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH4_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH4_NETX_BUF_BASE1_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_HOST_START 0x000000A0U
#define NETX_DPM_ARM_CH5_HOST_START     0x1C0033A0U

#define MSK_NETX_DPM_ARM_CH5_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH5_HOST_START_BIT_T bf;
} DPMAS_CH5_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_NETX_START 0x000000A4U
#define NETX_DPM_ARM_CH5_NETX_START     0x1C0033A4U

#define MSK_NETX_DPM_ARM_CH5_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH5_NETX_START_BIT_T bf;
} DPMAS_CH5_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_DMA_CTRL 0x000000A8U
#define NETX_DPM_ARM_CH5_DMA_CTRL     0x1C0033A8U

#define MSK_NETX_DPM_ARM_CH5_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH5_DMA_CTRL_BIT_T bf;
} DPMAS_CH5_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_MBX_BASE 0x000000ACU
#define NETX_DPM_ARM_CH5_MBX_BASE     0x1C0033ACU

#define MSK_NETX_DPM_ARM_CH5_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH5_MBX_BASE_BIT_T bf;
} DPMAS_CH5_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_BUF_CTRL 0x000000B0U
#define NETX_DPM_ARM_CH5_BUF_CTRL     0x1C0033B0U

#define MSK_NETX_DPM_ARM_CH5_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH5_BUF_CTRL_BIT_T bf;
} DPMAS_CH5_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_NETX_BUF_BASE3 0x000000B4U
#define NETX_DPM_ARM_CH5_NETX_BUF_BASE3     0x1C0033B4U

#define MSK_NETX_DPM_ARM_CH5_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH5_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH5_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_NETX_BUF_BASE2 0x000000B8U
#define NETX_DPM_ARM_CH5_NETX_BUF_BASE2     0x1C0033B8U

#define MSK_NETX_DPM_ARM_CH5_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH5_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH5_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch5_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH5_NETX_BUF_BASE1 0x000000BCU
#define NETX_DPM_ARM_CH5_NETX_BUF_BASE1     0x1C0033BCU

#define MSK_NETX_DPM_ARM_CH5_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH5_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH5_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH5_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH5_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH5_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH5_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH5_NETX_BUF_BASE1_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_HOST_START 0x000000C0U
#define NETX_DPM_ARM_CH6_HOST_START     0x1C0033C0U

#define MSK_NETX_DPM_ARM_CH6_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH6_HOST_START_BIT_T bf;
} DPMAS_CH6_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_NETX_START 0x000000C4U
#define NETX_DPM_ARM_CH6_NETX_START     0x1C0033C4U

#define MSK_NETX_DPM_ARM_CH6_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH6_NETX_START_BIT_T bf;
} DPMAS_CH6_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_DMA_CTRL 0x000000C8U
#define NETX_DPM_ARM_CH6_DMA_CTRL     0x1C0033C8U

#define MSK_NETX_DPM_ARM_CH6_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH6_DMA_CTRL_BIT_T bf;
} DPMAS_CH6_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_MBX_BASE 0x000000CCU
#define NETX_DPM_ARM_CH6_MBX_BASE     0x1C0033CCU

#define MSK_NETX_DPM_ARM_CH6_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH6_MBX_BASE_BIT_T bf;
} DPMAS_CH6_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_BUF_CTRL 0x000000D0U
#define NETX_DPM_ARM_CH6_BUF_CTRL     0x1C0033D0U

#define MSK_NETX_DPM_ARM_CH6_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH6_BUF_CTRL_BIT_T bf;
} DPMAS_CH6_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_NETX_BUF_BASE3 0x000000D4U
#define NETX_DPM_ARM_CH6_NETX_BUF_BASE3     0x1C0033D4U

#define MSK_NETX_DPM_ARM_CH6_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH6_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH6_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_NETX_BUF_BASE2 0x000000D8U
#define NETX_DPM_ARM_CH6_NETX_BUF_BASE2     0x1C0033D8U

#define MSK_NETX_DPM_ARM_CH6_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH6_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH6_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch6_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH6_NETX_BUF_BASE1 0x000000DCU
#define NETX_DPM_ARM_CH6_NETX_BUF_BASE1     0x1C0033DCU

#define MSK_NETX_DPM_ARM_CH6_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH6_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH6_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH6_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH6_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH6_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH6_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH6_NETX_BUF_BASE1_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_host_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_HOST_START 0x000000E0U
#define NETX_DPM_ARM_CH7_HOST_START     0x1C0033E0U

#define MSK_NETX_DPM_ARM_CH7_HOST_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_HOST_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_HOST_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_HOST_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_HOST_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH7_HOST_START_BIT_T bf;
} DPMAS_CH7_HOST_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_netx_start
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_NETX_START 0x000000E4U
#define NETX_DPM_ARM_CH7_NETX_START     0x1C0033E4U

#define MSK_NETX_DPM_ARM_CH7_NETX_START_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_NETX_START_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_NETX_START_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_NETX_START_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_NETX_START_BIT_T;

typedef union {
	unsigned int               val;
	DPMAS_CH7_NETX_START_BIT_T bf;
} DPMAS_CH7_NETX_START_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_dma_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_DMA_CTRL 0x000000E8U
#define NETX_DPM_ARM_CH7_DMA_CTRL     0x1C0033E8U

#define MSK_NETX_DPM_ARM_CH7_DMA_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_DMA_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_DMA_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_DMA_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_DMA_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH7_DMA_CTRL_BIT_T bf;
} DPMAS_CH7_DMA_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_mbx_base
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_MBX_BASE 0x000000ECU
#define NETX_DPM_ARM_CH7_MBX_BASE     0x1C0033ECU

#define MSK_NETX_DPM_ARM_CH7_MBX_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_MBX_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_MBX_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_MBX_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_MBX_BASE_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH7_MBX_BASE_BIT_T bf;
} DPMAS_CH7_MBX_BASE_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_buf_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_BUF_CTRL 0x000000F0U
#define NETX_DPM_ARM_CH7_BUF_CTRL     0x1C0033F0U

#define MSK_NETX_DPM_ARM_CH7_BUF_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_BUF_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_BUF_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_BUF_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_BUF_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_CH7_BUF_CTRL_BIT_T bf;
} DPMAS_CH7_BUF_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_netx_buf_base3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_NETX_BUF_BASE3 0x000000F4U
#define NETX_DPM_ARM_CH7_NETX_BUF_BASE3     0x1C0033F4U

#define MSK_NETX_DPM_ARM_CH7_NETX_BUF_BASE3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_NETX_BUF_BASE3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_NETX_BUF_BASE3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_NETX_BUF_BASE3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH7_NETX_BUF_BASE3_BIT_T bf;
} DPMAS_CH7_NETX_BUF_BASE3_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_netx_buf_base2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_NETX_BUF_BASE2 0x000000F8U
#define NETX_DPM_ARM_CH7_NETX_BUF_BASE2     0x1C0033F8U

#define MSK_NETX_DPM_ARM_CH7_NETX_BUF_BASE2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_NETX_BUF_BASE2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_NETX_BUF_BASE2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_NETX_BUF_BASE2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH7_NETX_BUF_BASE2_BIT_T bf;
} DPMAS_CH7_NETX_BUF_BASE2_T;

// ---------------------------------------------------------------------
// Register dpmas_ch7_netx_buf_base1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CH7_NETX_BUF_BASE1 0x000000FCU
#define NETX_DPM_ARM_CH7_NETX_BUF_BASE1     0x1C0033FCU

#define MSK_NETX_DPM_ARM_CH7_NETX_BUF_BASE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CH7_NETX_BUF_BASE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CH7_NETX_BUF_BASE1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_CH7_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CH7_NETX_BUF_BASE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_CH7_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                   val;
	DPMAS_CH7_NETX_BUF_BASE1_BIT_T bf;
} DPMAS_CH7_NETX_BUF_BASE1_T;


// =====================================================================
//
// Area of netx_controlled_global_register_block_1
//
// =====================================================================

#define NETX_DPM_ARM_GLOB_AREA1	0x1C003400U

// ---------------------------------------------------------------------
// Register pci_window_low0
// =>  dpmas_mem_win_start0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_LOW0 0x00000080U
#define NETX_DPM_ARM_PCI_WIN_LOW0     0x1C003480U

#define MSK_NETX_DPM_ARM_PCI_WIN_LOW0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_LOW0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_LOW0_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_LOW0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_LOW0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_LOW0_BIT_T;

typedef union {
	unsigned int          val;
	PCI_WINDOW_LOW0_BIT_T bf;
} PCI_WINDOW_LOW0_T;

// ---------------------------------------------------------------------
// Register pci_window_high0
// =>  dpmas_mem_win_end0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_HIGH0 0x00000084U
#define NETX_DPM_ARM_PCI_WIN_HIGH0     0x1C003484U

#define MSK_NETX_DPM_ARM_PCI_WIN_HIGH0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_HIGH0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_HIGH0_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_HIGH0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_HIGH0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_HIGH0_BIT_T;

typedef union {
	unsigned int           val;
	PCI_WINDOW_HIGH0_BIT_T bf;
} PCI_WINDOW_HIGH0_T;

// ---------------------------------------------------------------------
// Register pci_window_low1
// =>  dpmas_mem_win_start1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_LOW1 0x00000088U
#define NETX_DPM_ARM_PCI_WIN_LOW1     0x1C003488U

#define MSK_NETX_DPM_ARM_PCI_WIN_LOW1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_LOW1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_LOW1_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_LOW1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_LOW1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_LOW1_BIT_T;

typedef union {
	unsigned int          val;
	PCI_WINDOW_LOW1_BIT_T bf;
} PCI_WINDOW_LOW1_T;

// ---------------------------------------------------------------------
// Register pci_window_high1
// =>  dpmas_mem_win_end1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_HIGH1 0x0000008CU
#define NETX_DPM_ARM_PCI_WIN_HIGH1     0x1C00348CU

#define MSK_NETX_DPM_ARM_PCI_WIN_HIGH1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_HIGH1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_HIGH1_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_HIGH1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_HIGH1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_HIGH1_BIT_T;

typedef union {
	unsigned int           val;
	PCI_WINDOW_HIGH1_BIT_T bf;
} PCI_WINDOW_HIGH1_T;

// ---------------------------------------------------------------------
// Register pci_window_low2
// =>  dpmas_mem_win_start2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_LOW2 0x00000090U
#define NETX_DPM_ARM_PCI_WIN_LOW2     0x1C003490U

#define MSK_NETX_DPM_ARM_PCI_WIN_LOW2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_LOW2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_LOW2_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_LOW2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_LOW2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_LOW2_BIT_T;

typedef union {
	unsigned int          val;
	PCI_WINDOW_LOW2_BIT_T bf;
} PCI_WINDOW_LOW2_T;

// ---------------------------------------------------------------------
// Register pci_window_high2
// =>  dpmas_mem_win_end2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_HIGH2 0x00000094U
#define NETX_DPM_ARM_PCI_WIN_HIGH2     0x1C003494U

#define MSK_NETX_DPM_ARM_PCI_WIN_HIGH2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_HIGH2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_HIGH2_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_HIGH2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_HIGH2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_HIGH2_BIT_T;

typedef union {
	unsigned int           val;
	PCI_WINDOW_HIGH2_BIT_T bf;
} PCI_WINDOW_HIGH2_T;

// ---------------------------------------------------------------------
// Register pci_window_low3
// =>  dpmas_mem_win_start3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_LOW3 0x00000098U
#define NETX_DPM_ARM_PCI_WIN_LOW3     0x1C003498U

#define MSK_NETX_DPM_ARM_PCI_WIN_LOW3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_LOW3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_LOW3_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_LOW3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_LOW3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_LOW3_BIT_T;

typedef union {
	unsigned int          val;
	PCI_WINDOW_LOW3_BIT_T bf;
} PCI_WINDOW_LOW3_T;

// ---------------------------------------------------------------------
// Register pci_window_high3
// =>  dpmas_mem_win_end3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_WIN_HIGH3 0x0000009CU
#define NETX_DPM_ARM_PCI_WIN_HIGH3     0x1C00349CU

#define MSK_NETX_DPM_ARM_PCI_WIN_HIGH3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_WIN_HIGH3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_WIN_HIGH3_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_WINDOW_HIGH3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_WIN_HIGH3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_WINDOW_HIGH3_BIT_T;

typedef union {
	unsigned int           val;
	PCI_WINDOW_HIGH3_BIT_T bf;
} PCI_WINDOW_HIGH3_T;

// ---------------------------------------------------------------------
// Register pci_io_base
// =>  dpmas_pci_io_base
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_IO_BASE 0x000000A0U
#define NETX_DPM_ARM_PCI_IO_BASE     0x1C0034A0U

#define MSK_NETX_DPM_ARM_PCI_IO_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_IO_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_IO_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_IO_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_IO_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_IO_BASE_BIT_T;

typedef union {
	unsigned int      val;
	PCI_IO_BASE_BIT_T bf;
} PCI_IO_BASE_T;

// ---------------------------------------------------------------------
// Register pci_rom_base
// =>  dpmas_pci_rom_base
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_ROM_BASE 0x000000A4U
#define NETX_DPM_ARM_PCI_ROM_BASE     0x1C0034A4U

#define MSK_NETX_DPM_ARM_PCI_ROM_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_ROM_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_ROM_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_ROM_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_ROM_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_ROM_BASE_BIT_T;

typedef union {
	unsigned int       val;
	PCI_ROM_BASE_BIT_T bf;
} PCI_ROM_BASE_T;

// ---------------------------------------------------------------------
// Register arb_ctrl
// =>  dpmas_arb_ctrl
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_ARB_CTRL 0x000000A8U
#define NETX_DPM_ARM_ARB_CTRL     0x1C0034A8U

#define MSK_NETX_DPM_ARM_ARB_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_ARB_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_ARB_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct ARB_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_ARB_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} ARB_CTRL_BIT_T;

typedef union {
	unsigned int   val;
	ARB_CTRL_BIT_T bf;
} ARB_CTRL_T;

// ---------------------------------------------------------------------
// Register pci_config
// =>  dpmas_pci_cntrl
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_CFG 0x000000ACU
#define NETX_DPM_ARM_PCI_CFG     0x1C0034ACU

#define MSK_NETX_DPM_ARM_PCI_CFG_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_CFG_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_CFG_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_CONFIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_CFG_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_CONFIG_BIT_T;

typedef union {
	unsigned int     val;
	PCI_CONFIG_BIT_T bf;
} PCI_CONFIG_T;

// ---------------------------------------------------------------------
// Register sfr_base_addr
// =>  special frank register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_SFR_BASE 0x000000B8U
#define NETX_DPM_ARM_SFR_BASE     0x1C0034B8U

#define MSK_NETX_DPM_ARM_SFR_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_SFR_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_SFR_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct SFR_BASE_ADDR_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_SFR_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} SFR_BASE_ADDR_BIT_T;

typedef union {
	unsigned int        val;
	SFR_BASE_ADDR_BIT_T bf;
} SFR_BASE_ADDR_T;

// ---------------------------------------------------------------------
// Register cis_base
// =>  dpmas_cis_base
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CIS_MAP 0x000000BCU
#define NETX_DPM_ARM_CIS_MAP     0x1C0034BCU

#define MSK_NETX_DPM_ARM_CIS_MAP_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CIS_MAP_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CIS_MAP_keine_ahnung = 32  // [31:0]
};

typedef struct CIS_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CIS_MAP_keine_ahnung; // HIF, ask Hilscher HIF specialists
} CIS_BASE_BIT_T;

typedef union {
	unsigned int   val;
	CIS_BASE_BIT_T bf;
} CIS_BASE_T;

// ---------------------------------------------------------------------
// Register wdg_netx
// =>  dpmas_wdg_host_timeout
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_WDG_HOST_TIMEOUT 0x000000C0U
#define NETX_DPM_ARM_WDG_HOST_TIMEOUT     0x1C0034C0U

#define MSK_NETX_DPM_ARM_WDG_HOST_TIMEOUT_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_WDG_HOST_TIMEOUT_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_WDG_HOST_TIMEOUT_keine_ahnung = 32  // [31:0]
};

typedef struct WDG_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_WDG_HOST_TIMEOUT_keine_ahnung; // HIF, ask Hilscher HIF specialists
} WDG_NETX_BIT_T;

typedef union {
	unsigned int   val;
	WDG_NETX_BIT_T bf;
} WDG_NETX_T;

// ---------------------------------------------------------------------
// Register dpmas_wdg_arm_timeout
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_WDG_ARM_TIMEOUT 0x000000C8U
#define NETX_DPM_ARM_WDG_ARM_TIMEOUT     0x1C0034C8U

#define MSK_NETX_DPM_ARM_WDG_ARM_TIMEOUT_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_WDG_ARM_TIMEOUT_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_WDG_ARM_TIMEOUT_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_WDG_ARM_TIMEOUT_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_WDG_ARM_TIMEOUT_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_WDG_ARM_TIMEOUT_BIT_T;

typedef union {
	unsigned int                val;
	DPMAS_WDG_ARM_TIMEOUT_BIT_T bf;
} DPMAS_WDG_ARM_TIMEOUT_T;

// ---------------------------------------------------------------------
// Register dpmas_wdg_arm_trig
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_WDG_ARM_TRIG 0x000000CCU
#define NETX_DPM_ARM_WDG_ARM_TRIG     0x1C0034CCU

#define MSK_NETX_DPM_ARM_WDG_ARM_TRIG_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_WDG_ARM_TRIG_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_WDG_ARM_TRIG_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_WDG_ARM_TRIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_WDG_ARM_TRIG_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_WDG_ARM_TRIG_BIT_T;

typedef union {
	unsigned int             val;
	DPMAS_WDG_ARM_TRIG_BIT_T bf;
} DPMAS_WDG_ARM_TRIG_T;

// ---------------------------------------------------------------------
// Register sta_netx
// =>  dpmas_sys_sta
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_SYS_STAT 0x000000D8U
#define NETX_SYS_STAT     0x1C0034D8U

#define MSK_NETX_SYS_STAT_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_SYS_STAT_keine_ahnung 0

enum {
	BFW_NETX_SYS_STAT_keine_ahnung = 32  // [31:0]
};

typedef struct STA_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_SYS_STAT_keine_ahnung; // HIF, ask Hilscher HIF specialists
} STA_NETX_BIT_T;

typedef union {
	unsigned int   val;
	STA_NETX_BIT_T bf;
} STA_NETX_T;

// ---------------------------------------------------------------------
// Register irq_reg_netx
// =>  dpmas_int_sta0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT0 0x000000E0U
#define NETX_DPM_ARM_INT_STAT0     0x1C0034E0U

#define MSK_NETX_DPM_ARM_INT_STAT0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_STAT0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_STAT0_keine_ahnung = 32  // [31:0]
};

typedef struct IRQ_REG_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_STAT0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IRQ_REG_NETX_BIT_T;

typedef union {
	unsigned int       val;
	IRQ_REG_NETX_BIT_T bf;
} IRQ_REG_NETX_T;

// ---------------------------------------------------------------------
// Register irq_reg_netx1
// =>  dpmas_int_sta1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT1 0x000000E4U
#define NETX_DPM_ARM_INT_STAT1     0x1C0034E4U

#define MSK_NETX_DPM_ARM_INT_STAT1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_STAT1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_STAT1_keine_ahnung = 32  // [31:0]
};

typedef struct IRQ_REG_NETX1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_STAT1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IRQ_REG_NETX1_BIT_T;

typedef union {
	unsigned int        val;
	IRQ_REG_NETX1_BIT_T bf;
} IRQ_REG_NETX1_T;

// ---------------------------------------------------------------------
// Register irq_reg_netx2
// =>  dpmas_int_sta2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT2 0x000000E8U
#define NETX_DPM_ARM_INT_STAT2     0x1C0034E8U

#define MSK_NETX_DPM_ARM_INT_STAT2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_STAT2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_STAT2_keine_ahnung = 32  // [31:0]
};

typedef struct IRQ_REG_NETX2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_STAT2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IRQ_REG_NETX2_BIT_T;

typedef union {
	unsigned int        val;
	IRQ_REG_NETX2_BIT_T bf;
} IRQ_REG_NETX2_T;

// ---------------------------------------------------------------------
// Register irq_reg_netx3
// =>  dpmas_int_sta3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_STAT3 0x000000ECU
#define NETX_DPM_ARM_INT_STAT3     0x1C0034ECU

#define MSK_NETX_DPM_ARM_INT_STAT3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_STAT3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_STAT3_keine_ahnung = 32  // [31:0]
};

typedef struct IRQ_REG_NETX3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_STAT3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IRQ_REG_NETX3_BIT_T;

typedef union {
	unsigned int        val;
	IRQ_REG_NETX3_BIT_T bf;
} IRQ_REG_NETX3_T;

// ---------------------------------------------------------------------
// Register dpmas_int_en0
// =>  dpmas_int_en0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN0 0x000000F0U
#define NETX_DPM_ARM_INT_EN0     0x1C0034F0U

#define MSK_NETX_DPM_ARM_INT_EN0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_EN0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_EN0_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_INT_EN0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_EN0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_INT_EN0_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_INT_EN0_BIT_T bf;
} DPMAS_INT_EN0_T;

// ---------------------------------------------------------------------
// Register dpmas_int_en1
// =>  dpmas_int_en1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN1 0x000000F4U
#define NETX_DPM_ARM_INT_EN1     0x1C0034F4U

#define MSK_NETX_DPM_ARM_INT_EN1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_EN1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_EN1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_INT_EN1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_EN1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_INT_EN1_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_INT_EN1_BIT_T bf;
} DPMAS_INT_EN1_T;

// ---------------------------------------------------------------------
// Register dpmas_int_en2
// =>  dpmas_int_en2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN2 0x000000F8U
#define NETX_DPM_ARM_INT_EN2     0x1C0034F8U

#define MSK_NETX_DPM_ARM_INT_EN2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_EN2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_EN2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_INT_EN2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_EN2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_INT_EN2_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_INT_EN2_BIT_T bf;
} DPMAS_INT_EN2_T;

// ---------------------------------------------------------------------
// Register dpmas_int_en3
// =>  dpmas_int_en3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_INT_EN3 0x000000FCU
#define NETX_DPM_ARM_INT_EN3     0x1C0034FCU

#define MSK_NETX_DPM_ARM_INT_EN3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_INT_EN3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_INT_EN3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_INT_EN3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_INT_EN3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_INT_EN3_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_INT_EN3_BIT_T bf;
} DPMAS_INT_EN3_T;


// =====================================================================
//
// Area of netx_controlled_handshake_register_block
//
// =====================================================================

#define NETX_DPM_ARM_HS_AREA	0x1C003500U

// ---------------------------------------------------------------------
// Register handshake_ch0
// =>  dpmas_hs_data0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA0 0x00000000U
#define NETX_DPM_ARM_HS_DATA0     0x1C003500U

#define MSK_NETX_DPM_ARM_HS_DATA0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA0_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH0_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH0_BIT_T bf;
} HANDSHAKE_CH0_T;

// ---------------------------------------------------------------------
// Register handshake_ch1
// =>  dpmas_hs_data1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA1 0x00000004U
#define NETX_DPM_ARM_HS_DATA1     0x1C003504U

#define MSK_NETX_DPM_ARM_HS_DATA1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA1_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH1_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH1_BIT_T bf;
} HANDSHAKE_CH1_T;

// ---------------------------------------------------------------------
// Register handshake_ch2
// =>  dpmas_hs_data2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA2 0x00000008U
#define NETX_DPM_ARM_HS_DATA2     0x1C003508U

#define MSK_NETX_DPM_ARM_HS_DATA2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA2_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH2_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH2_BIT_T bf;
} HANDSHAKE_CH2_T;

// ---------------------------------------------------------------------
// Register handshake_ch3
// =>  dpmas_hs_data3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA3 0x0000000CU
#define NETX_DPM_ARM_HS_DATA3     0x1C00350CU

#define MSK_NETX_DPM_ARM_HS_DATA3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA3_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH3_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH3_BIT_T bf;
} HANDSHAKE_CH3_T;

// ---------------------------------------------------------------------
// Register handshake_ch4
// =>  dpmas_hs_data4
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA4 0x00000010U
#define NETX_DPM_ARM_HS_DATA4     0x1C003510U

#define MSK_NETX_DPM_ARM_HS_DATA4_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA4_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA4_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA4_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH4_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH4_BIT_T bf;
} HANDSHAKE_CH4_T;

// ---------------------------------------------------------------------
// Register handshake_ch5
// =>  dpmas_hs_data5
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA5 0x00000014U
#define NETX_DPM_ARM_HS_DATA5     0x1C003514U

#define MSK_NETX_DPM_ARM_HS_DATA5_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA5_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA5_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA5_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH5_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH5_BIT_T bf;
} HANDSHAKE_CH5_T;

// ---------------------------------------------------------------------
// Register handshake_ch6
// =>  dpmas_hs_data6
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA6 0x00000018U
#define NETX_DPM_ARM_HS_DATA6     0x1C003518U

#define MSK_NETX_DPM_ARM_HS_DATA6_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA6_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA6_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA6_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH6_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH6_BIT_T bf;
} HANDSHAKE_CH6_T;

// ---------------------------------------------------------------------
// Register handshake_ch7
// =>  dpmas_hs_data7
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA7 0x0000001CU
#define NETX_DPM_ARM_HS_DATA7     0x1C00351CU

#define MSK_NETX_DPM_ARM_HS_DATA7_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA7_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA7_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA7_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH7_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH7_BIT_T bf;
} HANDSHAKE_CH7_T;

// ---------------------------------------------------------------------
// Register handshake_ch8
// =>  dpmas_hs_data8
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA8 0x00000020U
#define NETX_DPM_ARM_HS_DATA8     0x1C003520U

#define MSK_NETX_DPM_ARM_HS_DATA8_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA8_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA8_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA8_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH8_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH8_BIT_T bf;
} HANDSHAKE_CH8_T;

// ---------------------------------------------------------------------
// Register handshake_ch9
// =>  dpmas_hs_data9
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA9 0x00000024U
#define NETX_DPM_ARM_HS_DATA9     0x1C003524U

#define MSK_NETX_DPM_ARM_HS_DATA9_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA9_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA9_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA9_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH9_BIT_T;

typedef union {
	unsigned int        val;
	HANDSHAKE_CH9_BIT_T bf;
} HANDSHAKE_CH9_T;

// ---------------------------------------------------------------------
// Register handshake_ch10
// =>  dpmas_hs_data10
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA10 0x00000028U
#define NETX_DPM_ARM_HS_DATA10     0x1C003528U

#define MSK_NETX_DPM_ARM_HS_DATA10_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA10_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA10_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA10_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH10_BIT_T;

typedef union {
	unsigned int         val;
	HANDSHAKE_CH10_BIT_T bf;
} HANDSHAKE_CH10_T;

// ---------------------------------------------------------------------
// Register handshake_ch11
// =>  dpmas_hs_data11
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA11 0x0000002CU
#define NETX_DPM_ARM_HS_DATA11     0x1C00352CU

#define MSK_NETX_DPM_ARM_HS_DATA11_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA11_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA11_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA11_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH11_BIT_T;

typedef union {
	unsigned int         val;
	HANDSHAKE_CH11_BIT_T bf;
} HANDSHAKE_CH11_T;

// ---------------------------------------------------------------------
// Register handshake_ch12
// =>  dpmas_hs_data12
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA12 0x00000030U
#define NETX_DPM_ARM_HS_DATA12     0x1C003530U

#define MSK_NETX_DPM_ARM_HS_DATA12_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA12_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA12_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA12_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH12_BIT_T;

typedef union {
	unsigned int         val;
	HANDSHAKE_CH12_BIT_T bf;
} HANDSHAKE_CH12_T;

// ---------------------------------------------------------------------
// Register handshake_ch13
// =>  dpmas_hs_data13
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA13 0x00000034U
#define NETX_DPM_ARM_HS_DATA13     0x1C003534U

#define MSK_NETX_DPM_ARM_HS_DATA13_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA13_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA13_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA13_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH13_BIT_T;

typedef union {
	unsigned int         val;
	HANDSHAKE_CH13_BIT_T bf;
} HANDSHAKE_CH13_T;

// ---------------------------------------------------------------------
// Register handshake_ch14
// =>  dpmas_hs_data14
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA14 0x00000038U
#define NETX_DPM_ARM_HS_DATA14     0x1C003538U

#define MSK_NETX_DPM_ARM_HS_DATA14_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA14_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA14_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA14_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH14_BIT_T;

typedef union {
	unsigned int         val;
	HANDSHAKE_CH14_BIT_T bf;
} HANDSHAKE_CH14_T;

// ---------------------------------------------------------------------
// Register handshake_ch15
// =>  dpmas_hs_data15
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_DATA15 0x0000003CU
#define NETX_DPM_ARM_HS_DATA15     0x1C00353CU

#define MSK_NETX_DPM_ARM_HS_DATA15_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_DATA15_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_DATA15_keine_ahnung = 32  // [31:0]
};

typedef struct HANDSHAKE_CH15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_DATA15_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HANDSHAKE_CH15_BIT_T;

typedef union {
	unsigned int         val;
	HANDSHAKE_CH15_BIT_T bf;
} HANDSHAKE_CH15_T;


// =====================================================================
//
// Area of netx_controlled_global_register_block_2
//
// =====================================================================

#define NETX_DPM_ARM_GLOB_AREA2	0x1C003600U

// ---------------------------------------------------------------------
// Register clk_reg
// =>  dpmas_clkout_conf
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_CLKOUT_CFG 0x00000004U
#define NETX_DPM_ARM_CLKOUT_CFG     0x1C003604U

#define MSK_NETX_DPM_ARM_CLKOUT_CFG_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_CLKOUT_CFG_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_CLKOUT_CFG_keine_ahnung = 32  // [31:0]
};

typedef struct CLK_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_CLKOUT_CFG_keine_ahnung; // HIF, ask Hilscher HIF specialists
} CLK_REG_BIT_T;

typedef union {
	unsigned int  val;
	CLK_REG_BIT_T bf;
} CLK_REG_T;

// ---------------------------------------------------------------------
// Register if_conf1
// =>  dpmas_if_conf0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IF_CFG0 0x00000008U
#define NETX_DPM_ARM_IF_CFG0     0x1C003608U

#define MSK_NETX_DPM_ARM_IF_CFG0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IF_CFG0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IF_CFG0_keine_ahnung = 32  // [31:0]
};

typedef struct IF_CONF1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IF_CFG0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IF_CONF1_BIT_T;

typedef union {
	unsigned int   val;
	IF_CONF1_BIT_T bf;
} IF_CONF1_T;

// ---------------------------------------------------------------------
// Register if_conf2
// =>  dpmas_if_conf1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IF_CFG1 0x0000000CU
#define NETX_DPM_ARM_IF_CFG1     0x1C00360CU

#define MSK_NETX_DPM_ARM_IF_CFG1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IF_CFG1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IF_CFG1_keine_ahnung = 32  // [31:0]
};

typedef struct IF_CONF2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IF_CFG1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IF_CONF2_BIT_T;

typedef union {
	unsigned int   val;
	IF_CONF2_BIT_T bf;
} IF_CONF2_T;

// ---------------------------------------------------------------------
// Register exp_bus_reg
// =>  dpmas_ext_config0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_EXT_CFG_CS0 0x00000010U
#define NETX_EXT_CFG_CS0     0x1C003610U

#define MSK_NETX_EXT_CFG_CS0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_EXT_CFG_CS0_keine_ahnung 0

enum {
	BFW_NETX_EXT_CFG_CS0_keine_ahnung = 32  // [31:0]
};

typedef struct EXP_BUS_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_EXT_CFG_CS0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} EXP_BUS_REG_BIT_T;

typedef union {
	unsigned int      val;
	EXP_BUS_REG_BIT_T bf;
} EXP_BUS_REG_T;

// ---------------------------------------------------------------------
// Register dpmas_ext_config1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_EXT_CFG_CS1 0x00000014U
#define NETX_EXT_CFG_CS1     0x1C003614U

#define MSK_NETX_EXT_CFG_CS1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_EXT_CFG_CS1_keine_ahnung 0

enum {
	BFW_NETX_EXT_CFG_CS1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_EXT_CONFIG1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_EXT_CFG_CS1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_EXT_CONFIG1_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_EXT_CONFIG1_BIT_T bf;
} DPMAS_EXT_CONFIG1_T;

// ---------------------------------------------------------------------
// Register dpmas_ext_config2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_EXT_CFG_CS2 0x00000018U
#define NETX_EXT_CFG_CS2     0x1C003618U

#define MSK_NETX_EXT_CFG_CS2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_EXT_CFG_CS2_keine_ahnung 0

enum {
	BFW_NETX_EXT_CFG_CS2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_EXT_CONFIG2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_EXT_CFG_CS2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_EXT_CONFIG2_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_EXT_CONFIG2_BIT_T bf;
} DPMAS_EXT_CONFIG2_T;

// ---------------------------------------------------------------------
// Register dpmas_ext_config3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_EXT_CFG_CS3 0x0000001CU
#define NETX_EXT_CFG_CS3     0x1C00361CU

#define MSK_NETX_EXT_CFG_CS3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_EXT_CFG_CS3_keine_ahnung 0

enum {
	BFW_NETX_EXT_CFG_CS3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_EXT_CONFIG3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_EXT_CFG_CS3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_EXT_CONFIG3_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_EXT_CONFIG3_BIT_T bf;
} DPMAS_EXT_CONFIG3_T;

// ---------------------------------------------------------------------
// Register io_reg_mode0
// =>  dpmas_io_mode0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_MODE0 0x00000020U
#define NETX_DPM_ARM_IO_MODE0     0x1C003620U

#define MSK_NETX_DPM_ARM_IO_MODE0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_MODE0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_MODE0_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_MODE0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_MODE0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_MODE0_BIT_T;

typedef union {
	unsigned int       val;
	IO_REG_MODE0_BIT_T bf;
} IO_REG_MODE0_T;

// ---------------------------------------------------------------------
// Register io_reg_drv_en0
// =>  dpmas_io_drv_en0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DRV_EN0 0x00000024U
#define NETX_DPM_ARM_IO_DRV_EN0     0x1C003624U

#define MSK_NETX_DPM_ARM_IO_DRV_EN0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_DRV_EN0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_DRV_EN0_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_DRV_EN0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_DRV_EN0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_DRV_EN0_BIT_T;

typedef union {
	unsigned int         val;
	IO_REG_DRV_EN0_BIT_T bf;
} IO_REG_DRV_EN0_T;

// ---------------------------------------------------------------------
// Register io_reg_data0
// =>  dpmas_io_data0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DATA0 0x00000028U
#define NETX_DPM_ARM_IO_DATA0     0x1C003628U

#define MSK_NETX_DPM_ARM_IO_DATA0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_DATA0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_DATA0_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_DATA0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_DATA0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_DATA0_BIT_T;

typedef union {
	unsigned int       val;
	IO_REG_DATA0_BIT_T bf;
} IO_REG_DATA0_T;

// ---------------------------------------------------------------------
// Register io_reg_reserved0
// =>  reserved
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_RESERVED0 0x0000002CU
#define NETX_DPM_ARM_IO_RESERVED0     0x1C00362CU

#define MSK_NETX_DPM_ARM_IO_RESERVED0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_RESERVED0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_RESERVED0_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_RESERVED0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_RESERVED0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_RESERVED0_BIT_T;

typedef union {
	unsigned int           val;
	IO_REG_RESERVED0_BIT_T bf;
} IO_REG_RESERVED0_T;

// ---------------------------------------------------------------------
// Register io_reg_mode1
// =>  dpmas_io_mode1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_MODE1 0x00000030U
#define NETX_DPM_ARM_IO_MODE1     0x1C003630U

#define MSK_NETX_DPM_ARM_IO_MODE1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_MODE1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_MODE1_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_MODE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_MODE1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_MODE1_BIT_T;

typedef union {
	unsigned int       val;
	IO_REG_MODE1_BIT_T bf;
} IO_REG_MODE1_T;

// ---------------------------------------------------------------------
// Register io_reg_drv_en1
// =>  dpmas_io_drv_en1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DRV_EN1 0x00000034U
#define NETX_DPM_ARM_IO_DRV_EN1     0x1C003634U

#define MSK_NETX_DPM_ARM_IO_DRV_EN1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_DRV_EN1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_DRV_EN1_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_DRV_EN1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_DRV_EN1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_DRV_EN1_BIT_T;

typedef union {
	unsigned int         val;
	IO_REG_DRV_EN1_BIT_T bf;
} IO_REG_DRV_EN1_T;

// ---------------------------------------------------------------------
// Register io_reg_data1
// =>  dpmas_io_data1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_DATA1 0x00000038U
#define NETX_DPM_ARM_IO_DATA1     0x1C003638U

#define MSK_NETX_DPM_ARM_IO_DATA1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_DATA1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_DATA1_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_DATA1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_DATA1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_DATA1_BIT_T;

typedef union {
	unsigned int       val;
	IO_REG_DATA1_BIT_T bf;
} IO_REG_DATA1_T;

// ---------------------------------------------------------------------
// Register io_reg_reserved1
// =>  reserved
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_IO_RESERVED1 0x0000003CU
#define NETX_DPM_ARM_IO_RESERVED1     0x1C00363CU

#define MSK_NETX_DPM_ARM_IO_RESERVED1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_IO_RESERVED1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_IO_RESERVED1_keine_ahnung = 32  // [31:0]
};

typedef struct IO_REG_RESERVED1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_IO_RESERVED1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} IO_REG_RESERVED1_BIT_T;

typedef union {
	unsigned int           val;
	IO_REG_RESERVED1_BIT_T bf;
} IO_REG_RESERVED1_T;

// ---------------------------------------------------------------------
// Register mb_ctrl
// =>  dpmas_db_end0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END0 0x00000040U
#define NETX_DPM_ARM_DB_END0     0x1C003640U

#define MSK_NETX_DPM_ARM_DB_END0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END0_keine_ahnung = 32  // [31:0]
};

typedef struct MB_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} MB_CTRL_BIT_T;

typedef union {
	unsigned int  val;
	MB_CTRL_BIT_T bf;
} MB_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping0
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP0 0x00000044U
#define NETX_DPM_ARM_DB_MAP0     0x1C003644U

#define MSK_NETX_DPM_ARM_DB_MAP0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP0_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING0_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING0_BIT_T bf;
} DPMAS_DB_MAPPING0_T;

// ---------------------------------------------------------------------
// Register dpmas_db_end1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END1 0x00000048U
#define NETX_DPM_ARM_DB_END1     0x1C003648U

#define MSK_NETX_DPM_ARM_DB_END1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_END1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_END1_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_DB_END1_BIT_T bf;
} DPMAS_DB_END1_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP1 0x0000004CU
#define NETX_DPM_ARM_DB_MAP1     0x1C00364CU

#define MSK_NETX_DPM_ARM_DB_MAP1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING1_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING1_BIT_T bf;
} DPMAS_DB_MAPPING1_T;

// ---------------------------------------------------------------------
// Register dpmas_db_end2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END2 0x00000050U
#define NETX_DPM_ARM_DB_END2     0x1C003650U

#define MSK_NETX_DPM_ARM_DB_END2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_END2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_END2_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_DB_END2_BIT_T bf;
} DPMAS_DB_END2_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP2 0x00000054U
#define NETX_DPM_ARM_DB_MAP2     0x1C003654U

#define MSK_NETX_DPM_ARM_DB_MAP2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING2_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING2_BIT_T bf;
} DPMAS_DB_MAPPING2_T;

// ---------------------------------------------------------------------
// Register dpmas_db_end3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END3 0x00000058U
#define NETX_DPM_ARM_DB_END3     0x1C003658U

#define MSK_NETX_DPM_ARM_DB_END3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_END3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_END3_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_DB_END3_BIT_T bf;
} DPMAS_DB_END3_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP3 0x0000005CU
#define NETX_DPM_ARM_DB_MAP3     0x1C00365CU

#define MSK_NETX_DPM_ARM_DB_MAP3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING3_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING3_BIT_T bf;
} DPMAS_DB_MAPPING3_T;

// ---------------------------------------------------------------------
// Register dpmas_db_end4
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END4 0x00000060U
#define NETX_DPM_ARM_DB_END4     0x1C003660U

#define MSK_NETX_DPM_ARM_DB_END4_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END4_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END4_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_END4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END4_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_END4_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_DB_END4_BIT_T bf;
} DPMAS_DB_END4_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping4
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP4 0x00000064U
#define NETX_DPM_ARM_DB_MAP4     0x1C003664U

#define MSK_NETX_DPM_ARM_DB_MAP4_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP4_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP4_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP4_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING4_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING4_BIT_T bf;
} DPMAS_DB_MAPPING4_T;

// ---------------------------------------------------------------------
// Register dpmas_db_end5
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END5 0x00000068U
#define NETX_DPM_ARM_DB_END5     0x1C003668U

#define MSK_NETX_DPM_ARM_DB_END5_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END5_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END5_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_END5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END5_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_END5_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_DB_END5_BIT_T bf;
} DPMAS_DB_END5_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping5
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP5 0x0000006CU
#define NETX_DPM_ARM_DB_MAP5     0x1C00366CU

#define MSK_NETX_DPM_ARM_DB_MAP5_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP5_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP5_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP5_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING5_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING5_BIT_T bf;
} DPMAS_DB_MAPPING5_T;

// ---------------------------------------------------------------------
// Register dpmas_db_end6
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END6 0x00000070U
#define NETX_DPM_ARM_DB_END6     0x1C003670U

#define MSK_NETX_DPM_ARM_DB_END6_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END6_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END6_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_END6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END6_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_END6_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_DB_END6_BIT_T bf;
} DPMAS_DB_END6_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping6
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP6 0x00000074U
#define NETX_DPM_ARM_DB_MAP6     0x1C003674U

#define MSK_NETX_DPM_ARM_DB_MAP6_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP6_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP6_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP6_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING6_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING6_BIT_T bf;
} DPMAS_DB_MAPPING6_T;

// ---------------------------------------------------------------------
// Register dpmas_db_end7
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_END7 0x00000078U
#define NETX_DPM_ARM_DB_END7     0x1C003678U

#define MSK_NETX_DPM_ARM_DB_END7_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_END7_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_END7_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_END7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_END7_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_END7_BIT_T;

typedef union {
	unsigned int        val;
	DPMAS_DB_END7_BIT_T bf;
} DPMAS_DB_END7_T;

// ---------------------------------------------------------------------
// Register dpmas_db_mapping7
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_DB_MAP7 0x0000007CU
#define NETX_DPM_ARM_DB_MAP7     0x1C00367CU

#define MSK_NETX_DPM_ARM_DB_MAP7_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_DB_MAP7_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_DB_MAP7_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_DB_MAPPING7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_DB_MAP7_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_DB_MAPPING7_BIT_T;

typedef union {
	unsigned int            val;
	DPMAS_DB_MAPPING7_BIT_T bf;
} DPMAS_DB_MAPPING7_T;

// ---------------------------------------------------------------------
// Register hs_ctrl
// =>  dpmas_hscr0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL0 0x00000080U
#define NETX_DPM_ARM_HS_CTRL0     0x1C003680U

#define MSK_NETX_DPM_ARM_HS_CTRL0_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL0_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL0_keine_ahnung = 32  // [31:0]
};

typedef struct HS_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL0_keine_ahnung; // HIF, ask Hilscher HIF specialists
} HS_CTRL_BIT_T;

typedef union {
	unsigned int  val;
	HS_CTRL_BIT_T bf;
} HS_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr1
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL1 0x00000084U
#define NETX_DPM_ARM_HS_CTRL1     0x1C003684U

#define MSK_NETX_DPM_ARM_HS_CTRL1_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL1_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL1_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL1_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR1_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR1_BIT_T bf;
} DPMAS_HSCR1_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr2
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL2 0x00000088U
#define NETX_DPM_ARM_HS_CTRL2     0x1C003688U

#define MSK_NETX_DPM_ARM_HS_CTRL2_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL2_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL2_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL2_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR2_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR2_BIT_T bf;
} DPMAS_HSCR2_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr3
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL3 0x0000008CU
#define NETX_DPM_ARM_HS_CTRL3     0x1C00368CU

#define MSK_NETX_DPM_ARM_HS_CTRL3_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL3_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL3_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL3_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR3_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR3_BIT_T bf;
} DPMAS_HSCR3_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr4
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL4 0x00000090U
#define NETX_DPM_ARM_HS_CTRL4     0x1C003690U

#define MSK_NETX_DPM_ARM_HS_CTRL4_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL4_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL4_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL4_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR4_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR4_BIT_T bf;
} DPMAS_HSCR4_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr5
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL5 0x00000094U
#define NETX_DPM_ARM_HS_CTRL5     0x1C003694U

#define MSK_NETX_DPM_ARM_HS_CTRL5_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL5_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL5_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL5_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR5_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR5_BIT_T bf;
} DPMAS_HSCR5_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr6
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL6 0x00000098U
#define NETX_DPM_ARM_HS_CTRL6     0x1C003698U

#define MSK_NETX_DPM_ARM_HS_CTRL6_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL6_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL6_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL6_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR6_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR6_BIT_T bf;
} DPMAS_HSCR6_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr7
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL7 0x0000009CU
#define NETX_DPM_ARM_HS_CTRL7     0x1C00369CU

#define MSK_NETX_DPM_ARM_HS_CTRL7_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL7_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL7_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL7_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR7_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR7_BIT_T bf;
} DPMAS_HSCR7_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr8
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL8 0x000000A0U
#define NETX_DPM_ARM_HS_CTRL8     0x1C0036A0U

#define MSK_NETX_DPM_ARM_HS_CTRL8_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL8_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL8_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL8_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR8_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR8_BIT_T bf;
} DPMAS_HSCR8_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr9
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL9 0x000000A4U
#define NETX_DPM_ARM_HS_CTRL9     0x1C0036A4U

#define MSK_NETX_DPM_ARM_HS_CTRL9_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL9_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL9_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL9_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR9_BIT_T;

typedef union {
	unsigned int      val;
	DPMAS_HSCR9_BIT_T bf;
} DPMAS_HSCR9_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr10
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL10 0x000000A8U
#define NETX_DPM_ARM_HS_CTRL10     0x1C0036A8U

#define MSK_NETX_DPM_ARM_HS_CTRL10_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL10_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL10_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL10_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR10_BIT_T;

typedef union {
	unsigned int       val;
	DPMAS_HSCR10_BIT_T bf;
} DPMAS_HSCR10_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr11
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL11 0x000000ACU
#define NETX_DPM_ARM_HS_CTRL11     0x1C0036ACU

#define MSK_NETX_DPM_ARM_HS_CTRL11_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL11_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL11_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL11_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR11_BIT_T;

typedef union {
	unsigned int       val;
	DPMAS_HSCR11_BIT_T bf;
} DPMAS_HSCR11_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr12
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL12 0x000000B0U
#define NETX_DPM_ARM_HS_CTRL12     0x1C0036B0U

#define MSK_NETX_DPM_ARM_HS_CTRL12_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL12_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL12_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL12_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR12_BIT_T;

typedef union {
	unsigned int       val;
	DPMAS_HSCR12_BIT_T bf;
} DPMAS_HSCR12_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr13
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL13 0x000000B4U
#define NETX_DPM_ARM_HS_CTRL13     0x1C0036B4U

#define MSK_NETX_DPM_ARM_HS_CTRL13_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL13_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL13_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL13_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR13_BIT_T;

typedef union {
	unsigned int       val;
	DPMAS_HSCR13_BIT_T bf;
} DPMAS_HSCR13_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr14
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL14 0x000000B8U
#define NETX_DPM_ARM_HS_CTRL14     0x1C0036B8U

#define MSK_NETX_DPM_ARM_HS_CTRL14_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL14_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL14_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL14_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR14_BIT_T;

typedef union {
	unsigned int       val;
	DPMAS_HSCR14_BIT_T bf;
} DPMAS_HSCR14_T;

// ---------------------------------------------------------------------
// Register dpmas_hscr15
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_HS_CTRL15 0x000000BCU
#define NETX_DPM_ARM_HS_CTRL15     0x1C0036BCU

#define MSK_NETX_DPM_ARM_HS_CTRL15_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_HS_CTRL15_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_HS_CTRL15_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_HSCR15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_HS_CTRL15_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_HSCR15_BIT_T;

typedef union {
	unsigned int       val;
	DPMAS_HSCR15_BIT_T bf;
} DPMAS_HSCR15_T;


// =====================================================================
//
// Area of netx_controlled_pci_configuration_shadow_register_block
//
// =====================================================================

#define NETX_DPM_ARM_PCI_CFG_SHADOW_AREA	0x1C003700U

// ---------------------------------------------------------------------
// Register pci_regs_addr
// =>  dpmas_pci_conf_rd_ctrl
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_BASE 0x00000000U
#define NETX_DPM_ARM_PCI_BASE     0x1C003700U

#define MSK_NETX_DPM_ARM_PCI_BASE_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_BASE_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_BASE_keine_ahnung = 32  // [31:0]
};

typedef struct PCI_REGS_ADDR_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_BASE_keine_ahnung; // HIF, ask Hilscher HIF specialists
} PCI_REGS_ADDR_BIT_T;

typedef union {
	unsigned int        val;
	PCI_REGS_ADDR_BIT_T bf;
} PCI_REGS_ADDR_T;

// ---------------------------------------------------------------------
// Register dpmas_pci_conf_rd_data
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_CFG_RD_DATA 0x00000004U
#define NETX_DPM_ARM_PCI_CFG_RD_DATA     0x1C003704U

#define MSK_NETX_DPM_ARM_PCI_CFG_RD_DATA_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_CFG_RD_DATA_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_CFG_RD_DATA_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_PCI_CONF_RD_DATA_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_CFG_RD_DATA_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_PCI_CONF_RD_DATA_BIT_T;

typedef union {
	unsigned int                 val;
	DPMAS_PCI_CONF_RD_DATA_BIT_T bf;
} DPMAS_PCI_CONF_RD_DATA_T;

// ---------------------------------------------------------------------
// Register dpmas_pci_conf_wr_ctrl
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_CFG_WR_CTRL 0x00000008U
#define NETX_DPM_ARM_PCI_CFG_WR_CTRL     0x1C003708U

#define MSK_NETX_DPM_ARM_PCI_CFG_WR_CTRL_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_CFG_WR_CTRL_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_CFG_WR_CTRL_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_PCI_CONF_WR_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_CFG_WR_CTRL_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_PCI_CONF_WR_CTRL_BIT_T;

typedef union {
	unsigned int                 val;
	DPMAS_PCI_CONF_WR_CTRL_BIT_T bf;
} DPMAS_PCI_CONF_WR_CTRL_T;

// ---------------------------------------------------------------------
// Register dpmas_pci_conf_wr_data
// => 
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DPM_ARM_PCI_CFG_WR_DATA 0x0000000CU
#define NETX_DPM_ARM_PCI_CFG_WR_DATA     0x1C00370CU

#define MSK_NETX_DPM_ARM_PCI_CFG_WR_DATA_keine_ahnung 0xffffffffU // [31:0]
#define SRT_NETX_DPM_ARM_PCI_CFG_WR_DATA_keine_ahnung 0

enum {
	BFW_NETX_DPM_ARM_PCI_CFG_WR_DATA_keine_ahnung = 32  // [31:0]
};

typedef struct DPMAS_PCI_CONF_WR_DATA_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NETX_DPM_ARM_PCI_CFG_WR_DATA_keine_ahnung; // HIF, ask Hilscher HIF specialists
} DPMAS_PCI_CONF_WR_DATA_BIT_T;

typedef union {
	unsigned int                 val;
	DPMAS_PCI_CONF_WR_DATA_BIT_T bf;
} DPMAS_PCI_CONF_WR_DATA_T;


// =====================================================================
//
// Area of dmac
//
// =====================================================================

#define NETX_DMAC_AREA	0x1C005000U

// =====================================================================
//
// Area of dmac_ch0, dmac_ch1, dmac_ch2, dmac_ch3
//
// =====================================================================

#define NETX_DMAC_CH0_AREA	0x1C005100U
#define NETX_DMAC_CH1_AREA	0x1C005120U
#define NETX_DMAC_CH2_AREA	0x1C005140U
#define NETX_DMAC_CH3_AREA	0x1C005160U

// ---------------------------------------------------------------------
// Register dmac_chsrc_ad
// =>  Channel source address registers
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_CH_SRC_ADDR      0x00000000U
#define NETX_DMAC_CH0_SRC_ADDR 0x1C005100U
#define NETX_DMAC_CH1_SRC_ADDR 0x1C005120U
#define NETX_DMAC_CH2_SRC_ADDR 0x1C005140U
#define NETX_DMAC_CH3_SRC_ADDR 0x1C005160U

#define MSK_NETX_DMAC_CH_SRC_ADDR_DMACCHSRCADDR 0xffffffffU // [31:0]
#define SRT_NETX_DMAC_CH_SRC_ADDR_DMACCHSRCADDR 0

enum {
	BFW_NETX_DMAC_CH_SRC_ADDR_DMACCHSRCADDR = 32  // [31:0]
};

typedef struct DMAC_CHSRC_AD_BIT_Ttag {
	unsigned int DMACCHSRCADDR : BFW_NETX_DMAC_CH_SRC_ADDR_DMACCHSRCADDR; // DMA source address
} DMAC_CHSRC_AD_BIT_T;

typedef union {
	unsigned int        val;
	DMAC_CHSRC_AD_BIT_T bf;
} DMAC_CHSRC_AD_T;

// ---------------------------------------------------------------------
// Register dmac_chdest_ad
// =>  Channel destination address registers
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_CH_DEST_ADDR      0x00000004U
#define NETX_DMAC_CH0_DEST_ADDR 0x1C005104U
#define NETX_DMAC_CH1_DEST_ADDR 0x1C005124U
#define NETX_DMAC_CH2_DEST_ADDR 0x1C005144U
#define NETX_DMAC_CH3_DEST_ADDR 0x1C005164U

#define MSK_NETX_DMAC_CH_DEST_ADDR_DMACCHDESTADDR 0xffffffffU // [31:0]
#define SRT_NETX_DMAC_CH_DEST_ADDR_DMACCHDESTADDR 0

enum {
	BFW_NETX_DMAC_CH_DEST_ADDR_DMACCHDESTADDR = 32  // [31:0]
};

typedef struct DMAC_CHDEST_AD_BIT_Ttag {
	unsigned int DMACCHDESTADDR : BFW_NETX_DMAC_CH_DEST_ADDR_DMACCHDESTADDR; // DMA destination address
} DMAC_CHDEST_AD_BIT_T;

typedef union {
	unsigned int         val;
	DMAC_CHDEST_AD_BIT_T bf;
} DMAC_CHDEST_AD_T;

// ---------------------------------------------------------------------
// Register dmac_chlink
// =>  Channel linked list item register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_CH_LINK      0x00000008U
#define NETX_DMAC_CH0_LINK 0x1C005108U
#define NETX_DMAC_CH1_LINK 0x1C005128U
#define NETX_DMAC_CH2_LINK 0x1C005148U
#define NETX_DMAC_CH3_LINK 0x1C005168U

#define MSK_NETX_DMAC_CH_LINK_LLIADDR 0xfffffffcU // [31:2]
#define SRT_NETX_DMAC_CH_LINK_LLIADDR 2

enum {
	BFW_NETX_DMAC_CH_LINK_reserved1 = 2,  // [1:0]
	BFW_NETX_DMAC_CH_LINK_LLIADDR   = 30  // [31:2]
};

typedef struct DMAC_CHLINK_BIT_Ttag {
	unsigned int reserved1 : BFW_NETX_DMAC_CH_LINK_reserved1; // reserved
	unsigned int LLIADDR   : BFW_NETX_DMAC_CH_LINK_LLIADDR;   // Linked list item. Bits [31:2] of the address for the next LLI. Address bits [1:0] are 0.
} DMAC_CHLINK_BIT_T;

typedef union {
	unsigned int      val;
	DMAC_CHLINK_BIT_T bf;
} DMAC_CHLINK_T;

// ---------------------------------------------------------------------
// Register dmac_chctrl
// =>  Channel control registers
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_CH_CTRL      0x0000000CU
#define NETX_DMAC_CH0_CTRL 0x1C00510CU
#define NETX_DMAC_CH1_CTRL 0x1C00512CU
#define NETX_DMAC_CH2_CTRL 0x1C00514CU
#define NETX_DMAC_CH3_CTRL 0x1C00516CU

#define MSK_NETX_DMAC_CH_CTRL_TransferSize 0x00000fffU // [11:0]
#define SRT_NETX_DMAC_CH_CTRL_TransferSize 0
#define MSK_NETX_DMAC_CH_CTRL_SBSize       0x00007000U // [14:12]
#define SRT_NETX_DMAC_CH_CTRL_SBSize       12
#define MSK_NETX_DMAC_CH_CTRL_DBSize       0x00038000U // [17:15]
#define SRT_NETX_DMAC_CH_CTRL_DBSize       15
#define MSK_NETX_DMAC_CH_CTRL_SWidth       0x001c0000U // [20:18]
#define SRT_NETX_DMAC_CH_CTRL_SWidth       18
#define MSK_NETX_DMAC_CH_CTRL_DWidth       0x00e00000U // [23:21]
#define SRT_NETX_DMAC_CH_CTRL_DWidth       21
#define MSK_NETX_DMAC_CH_CTRL_ARM_EQ       0x01000000U // [24]
#define SRT_NETX_DMAC_CH_CTRL_ARM_EQ       24
#define MSK_NETX_DMAC_CH_CTRL_SI           0x04000000U // [26]
#define SRT_NETX_DMAC_CH_CTRL_SI           26
#define MSK_NETX_DMAC_CH_CTRL_DI           0x08000000U // [27]
#define SRT_NETX_DMAC_CH_CTRL_DI           27
#define MSK_NETX_DMAC_CH_CTRL_Prot         0x70000000U // [30:28]
#define SRT_NETX_DMAC_CH_CTRL_Prot         28
#define MSK_NETX_DMAC_CH_CTRL_I            0x80000000U // [31]
#define SRT_NETX_DMAC_CH_CTRL_I            31

enum {
	BFW_NETX_DMAC_CH_CTRL_TransferSize = 12, // [11:0]
	BFW_NETX_DMAC_CH_CTRL_SBSize       = 3,  // [14:12]
	BFW_NETX_DMAC_CH_CTRL_DBSize       = 3,  // [17:15]
	BFW_NETX_DMAC_CH_CTRL_SWidth       = 3,  // [20:18]
	BFW_NETX_DMAC_CH_CTRL_DWidth       = 3,  // [23:21]
	BFW_NETX_DMAC_CH_CTRL_ARM_EQ       = 1,  // [24]
	BFW_NETX_DMAC_CH_CTRL_reserved1    = 1,  // [25]
	BFW_NETX_DMAC_CH_CTRL_SI           = 1,  // [26]
	BFW_NETX_DMAC_CH_CTRL_DI           = 1,  // [27]
	BFW_NETX_DMAC_CH_CTRL_Prot         = 3,  // [30:28]
	BFW_NETX_DMAC_CH_CTRL_I            = 1   // [31]
};

typedef struct DMAC_CHCTRL_BIT_Ttag {
	unsigned int TransferSize : BFW_NETX_DMAC_CH_CTRL_TransferSize; // Transfer size. For writes, this field indicates the number of (Source width) transfers to perform when the PrimeCell SMDMAC is the flow controller.
	                                                        // For reads, the transfer size indicates the number of transfers completed on the destination bus.
	                                                        // Reading the register when the channel is active does not give useful information,
	                                                        // as by the time that the software has processed the value read,
	                                                        // the channel might have progressed.
	                                                        // It is intended to be used only when a channel is enabled and then disabled.
	                                                        // If the PrimeCell DMAC controller is not the flow controller the transfer size value is not used.
	unsigned int SBSize       : BFW_NETX_DMAC_CH_CTRL_SBSize;       // Source burst size. Indicates the number of transfers which make up a source burst.
	                                                        // This value must be set to the burst size of the source peripheral, or if the source is memory, to the memory boundary size.
	                                                        // The burst size is the amount of data that is transferred when the DMACxBREQ signal goes active in the source peripheral.
	                                                        // The burst size is not related to the AHB HBURST signal.
	                                                        // ________________________________
	                                                        // bit_value    burst_transfer_size
	                                                        // --------------------------------
	                                                        //  000          1
	                                                        //  001          4
	                                                        //  010          8
	                                                        //  011          16
	                                                        //  100          32
	                                                        //  101          64
	                                                        //  110          128
	                                                        //  111          256
	                                                        // ================================
	unsigned int DBSize       : BFW_NETX_DMAC_CH_CTRL_DBSize;       // Destination burst size. Indicates the number of transfers which make up a destination burst transfer request.
	                                                        // This value must be set to the burst size of the destination peripheral, or if the destination is memory, to the memory boundary size.
	                                                        // The burst size is the amount of data that is transferred when the DMACxBREQ signal goes active in the destination peripheral.
	                                                        // The burst size is not related to the AHB HBURST signal.
	                                                        // ________________________________
	                                                        // bit_value    burst_transfer_size
	                                                        // --------------------------------
	                                                        //  000          1
	                                                        //  001          4
	                                                        //  010          8
	                                                        //  011          16
	                                                        //  100          32
	                                                        //  101          64
	                                                        //  110          128
	                                                        //  111          256
	                                                        // ================================
	unsigned int SWidth       : BFW_NETX_DMAC_CH_CTRL_SWidth;       // Source transfer width. Transfers wider than the AHB master bus width are illegal.
	                                                        // The source and destination widths can be different from each other.
	                                                        // The hardware automatically packs and unpacks the data as required.
	                                                        // _________________________
	                                                        // bit_value      data_width
	                                                        // -------------------------
	                                                        //  000             8-bit
	                                                        //  001            16-bit
	                                                        //  010            32-bit
	                                                        // =========================
	unsigned int DWidth       : BFW_NETX_DMAC_CH_CTRL_DWidth;       // Destination transfer width. Transfers wider than the AHB master bus width are illegal.
	                                                        // The source and destination widths can be different from each other.
	                                                        // The hardware automatically packs and unpacks the data as required.
	                                                        // _________________________
	                                                        // bit_value      data_width
	                                                        // -------------------------
	                                                        //  000             8-bit
	                                                        //  001            16-bit
	                                                        //  010            32-bit
	                                                        // =========================
	unsigned int ARM_EQ       : BFW_NETX_DMAC_CH_CTRL_ARM_EQ;       // set equal behavior to arm implementation
	unsigned int reserved1    : BFW_NETX_DMAC_CH_CTRL_reserved1;    // reserved
	unsigned int SI           : BFW_NETX_DMAC_CH_CTRL_SI;           // Source increment. When set the source address is incremented after each transfer.
	unsigned int DI           : BFW_NETX_DMAC_CH_CTRL_DI;           // Destination increment. When set the destination address is incremented after each transfer.
	unsigned int Prot         : BFW_NETX_DMAC_CH_CTRL_Prot;         // Protection.
	unsigned int I            : BFW_NETX_DMAC_CH_CTRL_I;            // Terminal count interrupt enable bit. It controls whether the current LLI is expected to trigger the terminal count interrupt.
} DMAC_CHCTRL_BIT_T;

typedef union {
	unsigned int      val;
	DMAC_CHCTRL_BIT_T bf;
} DMAC_CHCTRL_T;

// ---------------------------------------------------------------------
// Register dmac_chcfg
// =>  Channel configuration registers
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_CH_CFG      0x00000010U
#define NETX_DMAC_CH0_CFG 0x1C005110U
#define NETX_DMAC_CH1_CFG 0x1C005130U
#define NETX_DMAC_CH2_CFG 0x1C005150U
#define NETX_DMAC_CH3_CFG 0x1C005170U

#define MSK_NETX_DMAC_CH_CFG_E              0x00000001U // [0]
#define SRT_NETX_DMAC_CH_CFG_E              0
#define MSK_NETX_DMAC_CH_CFG_SrcPeripheral  0x0000001eU // [4:1]
#define SRT_NETX_DMAC_CH_CFG_SrcPeripheral  1
#define MSK_NETX_DMAC_CH_CFG_DestPeripheral 0x000003c0U // [9:6]
#define SRT_NETX_DMAC_CH_CFG_DestPeripheral 6
#define MSK_NETX_DMAC_CH_CFG_FlowCntrl      0x00003800U // [13:11]
#define SRT_NETX_DMAC_CH_CFG_FlowCntrl      11
#define MSK_NETX_DMAC_CH_CFG_IE             0x00004000U // [14]
#define SRT_NETX_DMAC_CH_CFG_IE             14
#define MSK_NETX_DMAC_CH_CFG_ITC            0x00008000U // [15]
#define SRT_NETX_DMAC_CH_CFG_ITC            15
#define MSK_NETX_DMAC_CH_CFG_L              0x00010000U // [16]
#define SRT_NETX_DMAC_CH_CFG_L              16
#define MSK_NETX_DMAC_CH_CFG_A              0x00020000U // [17]
#define SRT_NETX_DMAC_CH_CFG_A              17
#define MSK_NETX_DMAC_CH_CFG_H              0x00040000U // [18]
#define SRT_NETX_DMAC_CH_CFG_H              18

enum {
	BFW_NETX_DMAC_CH_CFG_E              = 1,  // [0]
	BFW_NETX_DMAC_CH_CFG_SrcPeripheral  = 4,  // [4:1]
	BFW_NETX_DMAC_CH_CFG_reserved1      = 1,  // [5]
	BFW_NETX_DMAC_CH_CFG_DestPeripheral = 4,  // [9:6]
	BFW_NETX_DMAC_CH_CFG_reserved2      = 1,  // [10]
	BFW_NETX_DMAC_CH_CFG_FlowCntrl      = 3,  // [13:11]
	BFW_NETX_DMAC_CH_CFG_IE             = 1,  // [14]
	BFW_NETX_DMAC_CH_CFG_ITC            = 1,  // [15]
	BFW_NETX_DMAC_CH_CFG_L              = 1,  // [16]
	BFW_NETX_DMAC_CH_CFG_A              = 1,  // [17]
	BFW_NETX_DMAC_CH_CFG_H              = 1,  // [18]
	BFW_NETX_DMAC_CH_CFG_reserved3      = 13  // [31:19]
};

typedef struct DMAC_CHCFG_BIT_Ttag {
	unsigned int E              : BFW_NETX_DMAC_CH_CFG_E;              // Channel enable. Reading this bit indicates whether a channel is currently enabled or disabled: 0 = channel disabled 1 = channel enabled.
	                                                        // The Channel Enable bit status can also be found by reading the DMACEnbldChns register.
	                                                        // A channel is enabled by setting this bit. A channel can be disabled by clearing the Enable bit.
	                                                        // This causes the current AHB transfer (if one is in progress) to complete and the channel is then disabled.
	                                                        // Any data in the channels FIFO is lost.
	                                                        // Restarting the channel by simply setting the Channel Enable bit has unpredictable effects and the channel must be fully re-initialized.
	                                                        // The channel is also disabled, and Channel Enable bit cleared, when the last LLI is reached or if a channel error is encountered.
	                                                        // If a channel has to be disabled without losing data in a channels FIFO the Halt bit must be set so that further DMA requests are ignored.
	                                                        // The Active bit must then be polled until it reaches 0, indicating that there is no data left in the channels FIFO.
	                                                        // Finally the Channel Enable bit can be cleared.
	unsigned int SrcPeripheral  : BFW_NETX_DMAC_CH_CFG_SrcPeripheral;  // Source peripheral. This value selects the DMA source request peripheral.
	                                                        // This field is ignored if the source of the transfer is from memory.
	                                                        // _____________________________
	                                                        // select_value  module
	                                                        // -----------------------------
	                                                        // 0            spi0_rx
	                                                        // 1            spi0_tx
	                                                        // 2            spi1_rx
	                                                        // 3            spi2_tx
	                                                        // 4            uart0_rx
	                                                        // 5            uart0_tx
	                                                        // 6            uart1_rx
	                                                        // 7            uart1_tx
	                                                        // 8            uart2_rx
	                                                        // 9            uart3_tx
	                                                        // 10           i2c_master_mode
	                                                        // 11           i2c_slave_mode
	                                                        // 12           ccdc_fifo_0
	                                                        // 13           ccdc_fifo_1
	                                                        // 14           ccdc_fifo_2
	                                                        // 12-15        not used
	                                                        // =============================
	unsigned int reserved1      : BFW_NETX_DMAC_CH_CFG_reserved1;      // reserved
	unsigned int DestPeripheral : BFW_NETX_DMAC_CH_CFG_DestPeripheral; // Destination peripheral. This value selects the DMA destination request peripheral.
	                                                        // This field is ignored if the destination of the transfer is to memory.
	                                                        // _____________________________
	                                                        // select_value    module
	                                                        // -----------------------------
	                                                        // 0            spi0_rx
	                                                        // 1            spi0_tx
	                                                        // 2            spi1_rx
	                                                        // 3            spi2_tx
	                                                        // 4            uart0_rx
	                                                        // 5            uart0_tx
	                                                        // 6            uart1_rx
	                                                        // 7            uart1_tx
	                                                        // 8            uart2_rx
	                                                        // 9            uart3_tx
	                                                        // 10           i2c_master_mode
	                                                        // 11           i2c_slave_mode
	                                                        // 12           ccdc_fifo_0
	                                                        // 13           ccdc_fifo_1
	                                                        // 14           ccdc_fifo_2
	                                                        // 12-15        not used
	                                                        // =============================
	unsigned int reserved2      : BFW_NETX_DMAC_CH_CFG_reserved2;      // reserved
	unsigned int FlowCntrl      : BFW_NETX_DMAC_CH_CFG_FlowCntrl;      // Flow control and transfer type. This value is used to indicate the flow controller and transfer type.
	                                                        // The flow controller can be the PrimeCell SMDMAC, the source peripheral, or the destination peripheral.
	                                                        // The transfer type can be either memory-to-memory, memory-to-peripheral, peripheral-to-memory, or peripheral-to-peripheral.
	                                                        // _______________________________________________________________________
	                                                        // bit_value     transfer_type                                  controller
	                                                        // -----------------------------------------------------------------------
	                                                        // 000           Memory-to-memory                                DMAC
	                                                        // 001           Memory-to-peripheral                            DMAC
	                                                        // 010           Peripheral-to-memorys                           DMAC
	                                                        // 011           Source peripheral-to-destination peripheral     DMAC
	                                                        // 100           Source peripheral-to-destination peripheral     peripheral
	                                                        // 101           Memory-to-peripheral Peripheral                 peripheral
	                                                        // 110           Peripheral-to-memory                            peripheral
	                                                        // 111           Source peripheral-to-destination peripheral     peripheral
	                                                        // ========================================================================
	unsigned int IE             : BFW_NETX_DMAC_CH_CFG_IE;             // Interrupt error mask. When cleared this bit masks out the error interrupt of the relevant channel.
	unsigned int ITC            : BFW_NETX_DMAC_CH_CFG_ITC;            // Terminal count interrupt mask. When cleared this bit masks out the terminal count interrupt of the relevant channel.
	unsigned int L              : BFW_NETX_DMAC_CH_CFG_L;              // Lock. When set this bit enables locked transfers.
	unsigned int A              : BFW_NETX_DMAC_CH_CFG_A;              // Active: 0 = there is no data in the FIFO of the channel 1 = the FIFO of the channel has data. (ro)
	                                                        // This value can be used with the Halt and Channel Enable bits to cleanly disable a DMA channel.
	unsigned int H              : BFW_NETX_DMAC_CH_CFG_H;              // Halt: 0 = allow DMA requests 1 = ignore further source DMA requests. The contents of the channels FIFO are drained.
	                                                        // This value can be used with the Active and Channel Enable bits to cleanly disable a DMA channel.
	unsigned int reserved3      : BFW_NETX_DMAC_CH_CFG_reserved3;      // reserved
} DMAC_CHCFG_BIT_T;

typedef union {
	unsigned int     val;
	DMAC_CHCFG_BIT_T bf;
} DMAC_CHCFG_T;


// =====================================================================
//
// Area of dmac_reg
//
// =====================================================================

#define NETX_DMAC_REG_AREA	0x1C005800U

// ---------------------------------------------------------------------
// Register dmac_int_status
// =>  Interrupt Status Register
//     reset value 0x0
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_INT_STAT 0x00000000U
#define NETX_DMAC_INT_STAT     0x1C005800U

#define MSK_NETX_DMAC_INT_STAT_DMACINT_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_INT_STAT_DMACINT_ch0 0
#define MSK_NETX_DMAC_INT_STAT_DMACINT_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_INT_STAT_DMACINT_ch1 1
#define MSK_NETX_DMAC_INT_STAT_DMACINT_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_INT_STAT_DMACINT_ch2 2
#define MSK_NETX_DMAC_INT_STAT_DMACINT_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_INT_STAT_DMACINT_ch3 3

enum {
	BFW_NETX_DMAC_INT_STAT_DMACINT_ch0 = 1,  // [0]
	BFW_NETX_DMAC_INT_STAT_DMACINT_ch1 = 1,  // [1]
	BFW_NETX_DMAC_INT_STAT_DMACINT_ch2 = 1,  // [2]
	BFW_NETX_DMAC_INT_STAT_DMACINT_ch3 = 1,  // [3]
	BFW_NETX_DMAC_INT_STAT_reserved1   = 28  // [31:4]
};

typedef struct DMAC_INT_STATUS_BIT_Ttag {
	unsigned int DMACINT_ch0 : BFW_NETX_DMAC_INT_STAT_DMACINT_ch0; // Status of DMA channel 0 - interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINT_ch1 : BFW_NETX_DMAC_INT_STAT_DMACINT_ch1; // Status of DMA channel 1 - interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINT_ch2 : BFW_NETX_DMAC_INT_STAT_DMACINT_ch2; // Status of DMA channel 2 - interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINT_ch3 : BFW_NETX_DMAC_INT_STAT_DMACINT_ch3; // Status of DMA channel 3 - interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int reserved1   : BFW_NETX_DMAC_INT_STAT_reserved1;   // reserved
} DMAC_INT_STATUS_BIT_T;

typedef union {
	unsigned int          val;
	DMAC_INT_STATUS_BIT_T bf;
} DMAC_INT_STATUS_T;

// ---------------------------------------------------------------------
// Register dmac_inttc_status
// =>  DMACIntTCStatus Register
//     reset value 0x0
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_INT_TC_STAT 0x00000004U
#define NETX_DMAC_INT_TC_STAT     0x1C005804U

#define MSK_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch0 0
#define MSK_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch1 1
#define MSK_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch2 2
#define MSK_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch3 3

enum {
	BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch0 = 1,  // [0]
	BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch1 = 1,  // [1]
	BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch2 = 1,  // [2]
	BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch3 = 1,  // [3]
	BFW_NETX_DMAC_INT_TC_STAT_reserved1     = 28  // [31:4]
};

typedef struct DMAC_INTTC_STATUS_BIT_Ttag {
	unsigned int DMACINTTC_ch0 : BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch0; // Status of DMA channel 0 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINTTC_ch1 : BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch1; // Status of DMA channel 1 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINTTC_ch2 : BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch2; // Status of DMA channel 2 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINTTC_ch3 : BFW_NETX_DMAC_INT_TC_STAT_DMACINTTC_ch3; // Status of DMA channel 3 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int reserved1     : BFW_NETX_DMAC_INT_TC_STAT_reserved1;     // reserved
} DMAC_INTTC_STATUS_BIT_T;

typedef union {
	unsigned int            val;
	DMAC_INTTC_STATUS_BIT_T bf;
} DMAC_INTTC_STATUS_T;

// ---------------------------------------------------------------------
// Register dmac_inttc_clear
// =>  DMACIntTCClear Register
//     reset value 0x0
// => Mode: W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_INT_TC_CLR 0x00000008U
#define NETX_DMAC_INT_TC_CLR     0x1C005808U

#define MSK_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch0 0
#define MSK_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch1 1
#define MSK_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch2 2
#define MSK_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch3 3

enum {
	BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch0 = 1,  // [0]
	BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch1 = 1,  // [1]
	BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch2 = 1,  // [2]
	BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch3 = 1,  // [3]
	BFW_NETX_DMAC_INT_TC_CLR_reserved1        = 28  // [31:4]
};

typedef struct DMAC_INTTC_CLEAR_BIT_Ttag {
	unsigned int DMACINTTCCLR_ch0 : BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch0; // Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 0 ,1'b0 have no effect.
	unsigned int DMACINTTCCLR_ch1 : BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch1; // Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 1 ,1'b0 have no effect.
	unsigned int DMACINTTCCLR_ch2 : BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch2; // Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 2 ,1'b0 have no effect.
	unsigned int DMACINTTCCLR_ch3 : BFW_NETX_DMAC_INT_TC_CLR_DMACINTTCCLR_ch3; // Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 3 ,1'b0 have no effect.
	unsigned int reserved1        : BFW_NETX_DMAC_INT_TC_CLR_reserved1;        // reserved
} DMAC_INTTC_CLEAR_BIT_T;

typedef union {
	unsigned int           val;
	DMAC_INTTC_CLEAR_BIT_T bf;
} DMAC_INTTC_CLEAR_T;

// ---------------------------------------------------------------------
// Register dmac_interr_status
// =>  DMACIntErrorStatus Register
//     reset value 0x0
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_INT_ERR_STAT 0x0000000CU
#define NETX_DMAC_INT_ERR_STAT     0x1C00580CU

#define MSK_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch0 0
#define MSK_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch1 1
#define MSK_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch2 2
#define MSK_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch3 3

enum {
	BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch0 = 1,  // [0]
	BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch1 = 1,  // [1]
	BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch2 = 1,  // [2]
	BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch3 = 1,  // [3]
	BFW_NETX_DMAC_INT_ERR_STAT_reserved1      = 28  // [31:4]
};

typedef struct DMAC_INTERR_STATUS_BIT_Ttag {
	unsigned int DMACINTERR_ch0 : BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch0; // Status of DMA channel 0 - error interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINTERR_ch1 : BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch1; // Status of DMA channel 1 - error interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINTERR_ch2 : BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch2; // Status of DMA channel 2 - error interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACINTERR_ch3 : BFW_NETX_DMAC_INT_ERR_STAT_DMACINTERR_ch3; // Status of DMA channel 3 - error interrupt after masking. 1'b1 indicates an active interrupt request.
	unsigned int reserved1      : BFW_NETX_DMAC_INT_ERR_STAT_reserved1;      // reserved
} DMAC_INTERR_STATUS_BIT_T;

typedef union {
	unsigned int             val;
	DMAC_INTERR_STATUS_BIT_T bf;
} DMAC_INTERR_STATUS_T;

// ---------------------------------------------------------------------
// Register dmac_interr_clear
// =>  DMACIntErrorClear Register
//     reset value 0x0
// => Mode: W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_INT_ERR_CLR 0x00000010U
#define NETX_DMAC_INT_ERR_CLR     0x1C005810U

#define MSK_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch0 0
#define MSK_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch1 1
#define MSK_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch2 2
#define MSK_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch3 3

enum {
	BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch0 = 1,  // [0]
	BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch1 = 1,  // [1]
	BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch2 = 1,  // [2]
	BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch3 = 1,  // [3]
	BFW_NETX_DMAC_INT_ERR_CLR_reserved1         = 28  // [31:4]
};

typedef struct DMAC_INTERR_CLEAR_BIT_Ttag {
	unsigned int DMACINTERRCLR_ch0 : BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch0; // Writing a 1'b1 Bit clears the error interrupt of the specific channel 0 ,1'b0 have no effect.
	unsigned int DMACINTERRCLR_ch1 : BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch1; // Writing a 1'b1 Bit clears the error interrupt of the specific channel 1 ,1'b0 have no effect.
	unsigned int DMACINTERRCLR_ch2 : BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch2; // Writing a 1'b1 Bit clears the error interrupt of the specific channel 2 ,1'b0 have no effect.
	unsigned int DMACINTERRCLR_ch3 : BFW_NETX_DMAC_INT_ERR_CLR_DMACINTERRCLR_ch3; // Writing a 1'b1 Bit clears the error interrupt of the specific channel 3 ,1'b0 have no effect.
	unsigned int reserved1         : BFW_NETX_DMAC_INT_ERR_CLR_reserved1;         // reserved
} DMAC_INTERR_CLEAR_BIT_T;

typedef union {
	unsigned int            val;
	DMAC_INTERR_CLEAR_BIT_T bf;
} DMAC_INTERR_CLEAR_T;

// ---------------------------------------------------------------------
// Register dmac_rawinttc_status
// =>  DMACRawIntTCStatus Register
//     reset value 0x0
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_RAW_INT_TC_STAT 0x00000014U
#define NETX_DMAC_RAW_INT_TC_STAT     0x1C005814U

#define MSK_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch0 0
#define MSK_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch1 1
#define MSK_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch2 2
#define MSK_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch3 3

enum {
	BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch0 = 1,  // [0]
	BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch1 = 1,  // [1]
	BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch2 = 1,  // [2]
	BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch3 = 1,  // [3]
	BFW_NETX_DMAC_RAW_INT_TC_STAT_reserved1        = 28  // [31:4]
};

typedef struct DMAC_RAWINTTC_STATUS_BIT_Ttag {
	unsigned int DMACRAWINTTC_ch0 : BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch0; // Status of DMA channel 0 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACRAWINTTC_ch1 : BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch1; // Status of DMA channel 1 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACRAWINTTC_ch2 : BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch2; // Status of DMA channel 2 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACRAWINTTC_ch3 : BFW_NETX_DMAC_RAW_INT_TC_STAT_DMACRAWINTTC_ch3; // Status of DMA channel 3 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int reserved1        : BFW_NETX_DMAC_RAW_INT_TC_STAT_reserved1;        // reserved
} DMAC_RAWINTTC_STATUS_BIT_T;

typedef union {
	unsigned int               val;
	DMAC_RAWINTTC_STATUS_BIT_T bf;
} DMAC_RAWINTTC_STATUS_T;

// ---------------------------------------------------------------------
// Register dmac_rawinterr_status
// =>  DMACRawIntErrorStatus Register
//     reset value 0x0
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_RAW_INT_ERR_STAT 0x00000018U
#define NETX_DMAC_RAW_INT_ERR_STAT     0x1C005818U

#define MSK_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch0 0
#define MSK_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch1 1
#define MSK_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch2 2
#define MSK_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch3 3

enum {
	BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch0 = 1,  // [0]
	BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch1 = 1,  // [1]
	BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch2 = 1,  // [2]
	BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch3 = 1,  // [3]
	BFW_NETX_DMAC_RAW_INT_ERR_STAT_reserved1         = 28  // [31:4]
};

typedef struct DMAC_RAWINTERR_STATUS_BIT_Ttag {
	unsigned int DMACRAWINTERR_ch0 : BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch0; // Status of DMA channel 0 - error interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACRAWINTERR_ch1 : BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch1; // Status of DMA channel 1 - error interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACRAWINTERR_ch2 : BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch2; // Status of DMA channel 2 - error interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int DMACRAWINTERR_ch3 : BFW_NETX_DMAC_RAW_INT_ERR_STAT_DMACRAWINTERR_ch3; // Status of DMA channel 3 - error interrupt prior to masking. 1'b1 indicates an active interrupt request.
	unsigned int reserved1         : BFW_NETX_DMAC_RAW_INT_ERR_STAT_reserved1;         // reserved
} DMAC_RAWINTERR_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	DMAC_RAWINTERR_STATUS_BIT_T bf;
} DMAC_RAWINTERR_STATUS_T;

// ---------------------------------------------------------------------
// Register dmac_enabled_channel
// =>  DMACEnbldChns Register
//     reset value 0x0
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_CH_EN 0x0000001CU
#define NETX_DMAC_CH_EN     0x1C00581CU

#define MSK_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch0 0x00000001U // [0]
#define SRT_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch0 0
#define MSK_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch1 0x00000002U // [1]
#define SRT_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch1 1
#define MSK_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch2 0x00000004U // [2]
#define SRT_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch2 2
#define MSK_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch3 0x00000008U // [3]
#define SRT_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch3 3

enum {
	BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch0 = 1,  // [0]
	BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch1 = 1,  // [1]
	BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch2 = 1,  // [2]
	BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch3 = 1,  // [3]
	BFW_NETX_DMAC_CH_EN_reserved1           = 28  // [31:4]
};

typedef struct DMAC_ENABLED_CHANNEL_BIT_Ttag {
	unsigned int DMACENABLEDCHNS_ch0 : BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch0; // Status DMA channel 0 enable
	unsigned int DMACENABLEDCHNS_ch1 : BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch1; // Status DMA channel 1 enable
	unsigned int DMACENABLEDCHNS_ch2 : BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch2; // Status DMA channel 2 enable
	unsigned int DMACENABLEDCHNS_ch3 : BFW_NETX_DMAC_CH_EN_DMACENABLEDCHNS_ch3; // Status DMA channel 3 enable
	unsigned int reserved1           : BFW_NETX_DMAC_CH_EN_reserved1;           // reserved
} DMAC_ENABLED_CHANNEL_BIT_T;

typedef union {
	unsigned int               val;
	DMAC_ENABLED_CHANNEL_BIT_T bf;
} DMAC_ENABLED_CHANNEL_T;

// ---------------------------------------------------------------------
// Register dmac_softb_req
// =>  DMACSoftBReq - Software burst request register
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_SW_BURST_REQ 0x00000020U
#define NETX_DMAC_SW_BURST_REQ     0x1C005820U

#define MSK_NETX_DMAC_SW_BURST_REQ_DMACSoftBReq 0x0000ffffU // [15:0]
#define SRT_NETX_DMAC_SW_BURST_REQ_DMACSoftBReq 0

enum {
	BFW_NETX_DMAC_SW_BURST_REQ_DMACSoftBReq = 16, // [15:0]
	BFW_NETX_DMAC_SW_BURST_REQ_reserved1    = 16  // [31:16]
};

typedef struct DMAC_SOFTB_REQ_BIT_Ttag {
	unsigned int DMACSoftBReq : BFW_NETX_DMAC_SW_BURST_REQ_DMACSoftBReq; // Software burst request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit.
	                                                        // Reading the register indicates which sources are requesting DMA burst transfers.
	unsigned int reserved1    : BFW_NETX_DMAC_SW_BURST_REQ_reserved1;    // reserved
} DMAC_SOFTB_REQ_BIT_T;

typedef union {
	unsigned int         val;
	DMAC_SOFTB_REQ_BIT_T bf;
} DMAC_SOFTB_REQ_T;

// ---------------------------------------------------------------------
// Register dmac_softs_req
// =>  DMACSoftSReq - Software single request register
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_SW_SINGLE_REQ 0x00000024U
#define NETX_DMAC_SW_SINGLE_REQ     0x1C005824U

#define MSK_NETX_DMAC_SW_SINGLE_REQ_DMACSoftSReq 0x0000ffffU // [15:0]
#define SRT_NETX_DMAC_SW_SINGLE_REQ_DMACSoftSReq 0

enum {
	BFW_NETX_DMAC_SW_SINGLE_REQ_DMACSoftSReq = 16, // [15:0]
	BFW_NETX_DMAC_SW_SINGLE_REQ_reserved1    = 16  // [31:16]
};

typedef struct DMAC_SOFTS_REQ_BIT_Ttag {
	unsigned int DMACSoftSReq : BFW_NETX_DMAC_SW_SINGLE_REQ_DMACSoftSReq; // Software single request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit.
	                                                        // Reading the register indicates which sources are requesting DMA single transfers.
	unsigned int reserved1    : BFW_NETX_DMAC_SW_SINGLE_REQ_reserved1;    // reserved
} DMAC_SOFTS_REQ_BIT_T;

typedef union {
	unsigned int         val;
	DMAC_SOFTS_REQ_BIT_T bf;
} DMAC_SOFTS_REQ_T;

// ---------------------------------------------------------------------
// Register dmac_softlb_req
// =>  DMACSoftLBReq - Software last burst request register
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_SW_LAST_BURST_REQ 0x00000028U
#define NETX_DMAC_SW_LAST_BURST_REQ     0x1C005828U

#define MSK_NETX_DMAC_SW_LAST_BURST_REQ_DMACSoftLBReq 0x0000ffffU // [15:0]
#define SRT_NETX_DMAC_SW_LAST_BURST_REQ_DMACSoftLBReq 0

enum {
	BFW_NETX_DMAC_SW_LAST_BURST_REQ_DMACSoftLBReq = 16, // [15:0]
	BFW_NETX_DMAC_SW_LAST_BURST_REQ_reserved1     = 16  // [31:16]
};

typedef struct DMAC_SOFTLB_REQ_BIT_Ttag {
	unsigned int DMACSoftLBReq : BFW_NETX_DMAC_SW_LAST_BURST_REQ_DMACSoftLBReq; // Software last burst request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit.
	                                                        // Reading the register indicates which sources are requesting DMA last burst transfers.
	unsigned int reserved1     : BFW_NETX_DMAC_SW_LAST_BURST_REQ_reserved1;     // reserved
} DMAC_SOFTLB_REQ_BIT_T;

typedef union {
	unsigned int          val;
	DMAC_SOFTLB_REQ_BIT_T bf;
} DMAC_SOFTLB_REQ_T;

// ---------------------------------------------------------------------
// Register dmac_softls_req
// =>  DMACSoftLSReq - Software last single request register
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_SW_LAST_SINGLE_REQ 0x0000002CU
#define NETX_DMAC_SW_LAST_SINGLE_REQ     0x1C00582CU

#define MSK_NETX_DMAC_SW_LAST_SINGLE_REQ_DMACSoftLSReq 0x0000ffffU // [15:0]
#define SRT_NETX_DMAC_SW_LAST_SINGLE_REQ_DMACSoftLSReq 0

enum {
	BFW_NETX_DMAC_SW_LAST_SINGLE_REQ_DMACSoftLSReq = 16, // [15:0]
	BFW_NETX_DMAC_SW_LAST_SINGLE_REQ_reserved1     = 16  // [31:16]
};

typedef struct DMAC_SOFTLS_REQ_BIT_Ttag {
	unsigned int DMACSoftLSReq : BFW_NETX_DMAC_SW_LAST_SINGLE_REQ_DMACSoftLSReq; // Software last single request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit.
	                                                        // Reading the register indicates which sources are requesting DMA last single transfers.
	unsigned int reserved1     : BFW_NETX_DMAC_SW_LAST_SINGLE_REQ_reserved1;     // reserved
} DMAC_SOFTLS_REQ_BIT_T;

typedef union {
	unsigned int          val;
	DMAC_SOFTLS_REQ_BIT_T bf;
} DMAC_SOFTLS_REQ_T;

// ---------------------------------------------------------------------
// Register dmac_config
// =>  DMACConfiguration Register
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_CFG 0x00000030U
#define NETX_DMAC_CFG     0x1C005830U

#define MSK_NETX_DMAC_CFG_DMACENABLE 0x00000001U // [0]
#define SRT_NETX_DMAC_CFG_DMACENABLE 0

enum {
	BFW_NETX_DMAC_CFG_DMACENABLE = 1,  // [0]
	BFW_NETX_DMAC_CFG_reserved1  = 31  // [31:1]
};

typedef struct DMAC_CONFIG_BIT_Ttag {
	unsigned int DMACENABLE : BFW_NETX_DMAC_CFG_DMACENABLE; // PrimeCell SMDMAC enable: 0 = disabled 1 = enabled. This bit is reset to 0. Disabling the PrimeCell SMDMAC reduces power consumption.
	unsigned int reserved1  : BFW_NETX_DMAC_CFG_reserved1;  // reserved
} DMAC_CONFIG_BIT_T;

typedef union {
	unsigned int      val;
	DMAC_CONFIG_BIT_T bf;
} DMAC_CONFIG_T;

// ---------------------------------------------------------------------
// Register dmac_sync
// =>  DMACSync Register
//     DMA synchronization logic for DMA request signals enabled or disabled
//     A 1'b0 bit indicates that the synchronization logic for
//     the DMACBREQ[15:0], DMACSREQ[15:0], DMACLBREQ[15:0], and DMACLSREQ[15:0] request signals is enabled.
//     A HIGH bit indicates that the synchronization logic is disabled.
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_SYNC 0x00000034U
#define NETX_DMAC_SYNC     0x1C005834U

#define MSK_NETX_DMAC_SYNC_DIS_SYNC_SPI0_RX  0x00000001U // [0]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_SPI0_RX  0
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_SPI0_TX  0x00000002U // [1]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_SPI0_TX  1
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_SPI1_RX  0x00000004U // [2]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_SPI1_RX  2
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_SPI1_TX  0x00000008U // [3]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_SPI1_TX  3
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_UART0_RX 0x00000010U // [4]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_UART0_RX 4
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_UART0_TX 0x00000020U // [5]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_UART0_TX 5
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_UART1_RX 0x00000040U // [6]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_UART1_RX 6
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_UART1_TX 0x00000080U // [7]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_UART1_TX 7
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_UART2_RX 0x00000100U // [8]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_UART2_RX 8
#define MSK_NETX_DMAC_SYNC_DIS_SYNC_UART2_TX 0x00000200U // [9]
#define SRT_NETX_DMAC_SYNC_DIS_SYNC_UART2_TX 9

enum {
	BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI0_RX  = 1,  // [0]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI0_TX  = 1,  // [1]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI1_RX  = 1,  // [2]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI1_TX  = 1,  // [3]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_UART0_RX = 1,  // [4]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_UART0_TX = 1,  // [5]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_UART1_RX = 1,  // [6]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_UART1_TX = 1,  // [7]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_UART2_RX = 1,  // [8]
	BFW_NETX_DMAC_SYNC_DIS_SYNC_UART2_TX = 1,  // [9]
	BFW_NETX_DMAC_SYNC_reserved1         = 22  // [31:10]
};

typedef struct DMAC_SYNC_BIT_Ttag {
	unsigned int DIS_SYNC_SPI0_RX  : BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI0_RX;  // disable sync register for SPI0 receive requests
	unsigned int DIS_SYNC_SPI0_TX  : BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI0_TX;  // disable sync register for SPI0 transmit requests
	unsigned int DIS_SYNC_SPI1_RX  : BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI1_RX;  // disable sync register for SPI1 receive requests
	unsigned int DIS_SYNC_SPI1_TX  : BFW_NETX_DMAC_SYNC_DIS_SYNC_SPI1_TX;  // disable sync register for SPI1 transmit requests
	unsigned int DIS_SYNC_UART0_RX : BFW_NETX_DMAC_SYNC_DIS_SYNC_UART0_RX; // disable sync register for UART0 receive requests
	unsigned int DIS_SYNC_UART0_TX : BFW_NETX_DMAC_SYNC_DIS_SYNC_UART0_TX; // disable sync register for UART0 transmit requests
	unsigned int DIS_SYNC_UART1_RX : BFW_NETX_DMAC_SYNC_DIS_SYNC_UART1_RX; // disable sync register for UART1 receive requests
	unsigned int DIS_SYNC_UART1_TX : BFW_NETX_DMAC_SYNC_DIS_SYNC_UART1_TX; // disable sync register for UART1 transmit requests
	unsigned int DIS_SYNC_UART2_RX : BFW_NETX_DMAC_SYNC_DIS_SYNC_UART2_RX; // disable sync register for UART2 receive requests
	unsigned int DIS_SYNC_UART2_TX : BFW_NETX_DMAC_SYNC_DIS_SYNC_UART2_TX; // disable sync register for UART2 transmit requests
	unsigned int reserved1         : BFW_NETX_DMAC_SYNC_reserved1;         // reserved
} DMAC_SYNC_BIT_T;

typedef union {
	unsigned int    val;
	DMAC_SYNC_BIT_T bf;
} DMAC_SYNC_T;

// ---------------------------------------------------------------------
// Register dmac_rng_ctrl
// =>  Test Control
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_RNG_CTRL 0x00000038U
#define NETX_DMAC_RNG_CTRL     0x1C005838U

#define MSK_NETX_DMAC_RNG_CTRL_LOAD_SEED 0x00000001U // [0]
#define SRT_NETX_DMAC_RNG_CTRL_LOAD_SEED 0

enum {
	BFW_NETX_DMAC_RNG_CTRL_LOAD_SEED = 1,  // [0]
	BFW_NETX_DMAC_RNG_CTRL_reserved1 = 31  // [31:1]
};

typedef struct DMAC_RNG_CTRL_BIT_Ttag {
	unsigned int LOAD_SEED : BFW_NETX_DMAC_RNG_CTRL_LOAD_SEED; // reserved
	unsigned int reserved1 : BFW_NETX_DMAC_RNG_CTRL_reserved1; // reserved
} DMAC_RNG_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	DMAC_RNG_CTRL_BIT_T bf;
} DMAC_RNG_CTRL_T;

// ---------------------------------------------------------------------
// Register dmac_rng_seed
// =>  Test Control
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_RNG_SEED 0x0000003CU
#define NETX_DMAC_RNG_SEED     0x1C00583CU

#define MSK_NETX_DMAC_RNG_SEED_SEED 0xffffffffU // [31:0]
#define SRT_NETX_DMAC_RNG_SEED_SEED 0

enum {
	BFW_NETX_DMAC_RNG_SEED_SEED = 32  // [31:0]
};

typedef struct DMAC_RNG_SEED_BIT_Ttag {
	unsigned int SEED : BFW_NETX_DMAC_RNG_SEED_SEED; // reserved
} DMAC_RNG_SEED_BIT_T;

typedef union {
	unsigned int        val;
	DMAC_RNG_SEED_BIT_T bf;
} DMAC_RNG_SEED_T;

// ---------------------------------------------------------------------
// Register dmac_rng_num
// =>  Test Control
//     reset value 0x0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_DMAC_RNG_NUM 0x00000040U
#define NETX_DMAC_RNG_NUM     0x1C005840U

#define MSK_NETX_DMAC_RNG_NUM_RNG_NUM 0xffffffffU // [31:0]
#define SRT_NETX_DMAC_RNG_NUM_RNG_NUM 0

enum {
	BFW_NETX_DMAC_RNG_NUM_RNG_NUM = 32  // [31:0]
};

typedef struct DMAC_RNG_NUM_BIT_Ttag {
	unsigned int RNG_NUM : BFW_NETX_DMAC_RNG_NUM_RNG_NUM; // reserved
} DMAC_RNG_NUM_BIT_T;

typedef union {
	unsigned int       val;
	DMAC_RNG_NUM_BIT_T bf;
} DMAC_RNG_NUM_T;


// =====================================================================
//
// Area of usb_core
//
// =====================================================================

#define NETX_USB_CORE_AREA	0x1C020000U

// ---------------------------------------------------------------------
// Register ID
// =>  ID Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_ID 0x00000000U
#define NETX_USB_ID     0x1C020000U

// ---------------------------------------------------------------------
// Register USB_CTRL
// =>  USB Control Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_CTRL 0x00000004U
#define NETX_USB_CTRL     0x1C020004U

// ---------------------------------------------------------------------
// Register FRM_TIMER
// =>  Frame Timer Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_FRM_TMR 0x00000008U
#define NETX_USB_FRM_TMR     0x1C020008U

// ---------------------------------------------------------------------
// Register MAIN_EV
// =>  Main Event Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_MAIN_EV 0x0000000CU
#define NETX_USB_MAIN_EV     0x1C02000CU

// ---------------------------------------------------------------------
// Register MAIN_EM
// =>  Main Event Mask Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_MAIN_EV_MSK 0x00000010U
#define NETX_USB_MAIN_EV_MSK     0x1C020010U

// ---------------------------------------------------------------------
// Register PIPE_EV
// =>  Pipe Event Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_EV 0x00000014U
#define NETX_USB_PIPE_EV     0x1C020014U

// ---------------------------------------------------------------------
// Register PIPE_EM
// =>  Pipe Event Mask Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_EV_MSK 0x00000018U
#define NETX_USB_PIPE_EV_MSK     0x1C020018U

// ---------------------------------------------------------------------
// Register PIPE_SEL
// =>  Pipe Select Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_SEL 0x00000024U
#define NETX_USB_PIPE_SEL     0x1C020024U

// ---------------------------------------------------------------------
// Register PORT_STAT
// =>  Port Statuus Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PORT_STAT 0x0000002CU
#define NETX_USB_PORT_STAT     0x1C02002CU

// ---------------------------------------------------------------------
// Register PORT_CTRL
// =>  Port Control Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PORT_CTRL 0x00000030U
#define NETX_USB_PORT_CTRL     0x1C020030U

// ---------------------------------------------------------------------
// Register PSC_EV
// =>  Port Status Change Event Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PORT_STAT_CHG_EV 0x00000034U
#define NETX_USB_PORT_STAT_CHG_EV     0x1C020034U

// ---------------------------------------------------------------------
// Register PSC_EM
// =>  Port Status Change Event Mask Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PORT_STAT_CHG_EV_MSK 0x00000038U
#define NETX_USB_PORT_STAT_CHG_EV_MSK     0x1C020038U

// ---------------------------------------------------------------------
// Register PIPE_CTRL
// =>  Pipe Control Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_CTRL 0x00000040U
#define NETX_USB_PIPE_CTRL     0x1C020040U

// ---------------------------------------------------------------------
// Register PIPE_CFG
// =>  Pipe Configuration Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_CFG 0x00000044U
#define NETX_USB_PIPE_CFG     0x1C020044U

// ---------------------------------------------------------------------
// Register PIPE_ADDR
// =>  Pipe Address Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_ADDR 0x00000048U
#define NETX_USB_PIPE_ADDR     0x1C020048U

// ---------------------------------------------------------------------
// Register PIPE_STAT
// =>  Pipe Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_STAT 0x0000004CU
#define NETX_USB_PIPE_STAT     0x1C02004CU

// ---------------------------------------------------------------------
// Register PIPE_DATA_PTR
// =>  Pipe Data Pointer Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_DATA_PTR 0x00000050U
#define NETX_USB_PIPE_DATA_PTR     0x1C020050U

// ---------------------------------------------------------------------
// Register PIPE_DATA_TBYTES
// =>  Pipe Total Bytes Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_DATA_TOT 0x00000054U
#define NETX_USB_PIPE_DATA_TOT     0x1C020054U

// ---------------------------------------------------------------------
// Register PIPE_ADATA_PTR
// =>  Pipe Alternative Data Pointer Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_ALT_DATA_PTR 0x00000058U
#define NETX_USB_PIPE_ALT_DATA_PTR     0x1C020058U

// ---------------------------------------------------------------------
// Register PIPE_ADATA_TBYTES
// =>  Pipe Altenative Data Total Bytes Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_PIPE_ALT_DATA_TOT 0x0000005CU
#define NETX_USB_PIPE_ALT_DATA_TOT     0x1C02005CU

// ---------------------------------------------------------------------
// Register DEBUG_CTRL
// =>  Debug Control Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_DBG_CTRL 0x00000060U
#define NETX_USB_DBG_CTRL     0x1C020060U

// ---------------------------------------------------------------------
// Register DEBUG_PID
// =>  Debug PID Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_DBG_PID 0x00000064U
#define NETX_USB_DBG_PID     0x1C020064U

// ---------------------------------------------------------------------
// Register DEBUG_STAT
// =>  Debug Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_DBG_STAT 0x00000068U
#define NETX_USB_DBG_STAT     0x1C020068U

// ---------------------------------------------------------------------
// Register TEST
// =>  Test Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_TEST 0x0000006CU
#define NETX_USB_TEST     0x1C02006CU

// ---------------------------------------------------------------------
// Register MAIN_CFG
// =>  Main Configuration Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_MAIN_CFG 0x00000080U
#define NETX_USB_MAIN_CFG     0x1C020080U

// ---------------------------------------------------------------------
// Register MODE_CFG
// =>  Mode Configuration Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_USB_MODE_CFG 0x00000084U
#define NETX_USB_MODE_CFG     0x1C020084U

// ---------------------------------------------------------------------
// Register usb_core_ctrl
// =>  USB core control and status register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_USB_CORE_CTRL 0x00000088U
#define NETX_USB_CORE_CTRL     0x1C020088U

#define MSK_NETX_USB_CORE_CTRL_reset              0x00000001U // [0]
#define SRT_NETX_USB_CORE_CTRL_reset              0
#define MSK_NETX_USB_CORE_CTRL_dbg_support        0x00000002U // [1]
#define SRT_NETX_USB_CORE_CTRL_dbg_support        1
#define MSK_NETX_USB_CORE_CTRL_xtd_dbg_support    0x00000004U // [2]
#define SRT_NETX_USB_CORE_CTRL_xtd_dbg_support    2
#define MSK_NETX_USB_CORE_CTRL_soft_id_dig        0x00000008U // [3]
#define SRT_NETX_USB_CORE_CTRL_soft_id_dig        3
#define MSK_NETX_USB_CORE_CTRL_alt_buffer_support 0x00000ff0U // [11:4]
#define SRT_NETX_USB_CORE_CTRL_alt_buffer_support 4
#define MSK_NETX_USB_CORE_CTRL_core_suspend_n     0x00001000U // [12]
#define SRT_NETX_USB_CORE_CTRL_core_suspend_n     12
#define MSK_NETX_USB_CORE_CTRL_xcvr_suspend_n     0x00002000U // [13]
#define SRT_NETX_USB_CORE_CTRL_xcvr_suspend_n     13
#define MSK_NETX_USB_CORE_CTRL_over_current       0x00004000U // [14]
#define SRT_NETX_USB_CORE_CTRL_over_current       14
#define MSK_NETX_USB_CORE_CTRL_va_sess_vld        0x00008000U // [15]
#define SRT_NETX_USB_CORE_CTRL_va_sess_vld        15
#define MSK_NETX_USB_CORE_CTRL_vb_sess_end        0x00010000U // [16]
#define SRT_NETX_USB_CORE_CTRL_vb_sess_end        16
#define MSK_NETX_USB_CORE_CTRL_vb_sess_vld        0x00020000U // [17]
#define SRT_NETX_USB_CORE_CTRL_vb_sess_vld        17
#define MSK_NETX_USB_CORE_CTRL_vbus_vld           0x00040000U // [18]
#define SRT_NETX_USB_CORE_CTRL_vbus_vld           18
#define MSK_NETX_USB_CORE_CTRL_chrg_vbus          0x00080000U // [19]
#define SRT_NETX_USB_CORE_CTRL_chrg_vbus          19
#define MSK_NETX_USB_CORE_CTRL_dlp_active         0x00100000U // [20]
#define SRT_NETX_USB_CORE_CTRL_dlp_active         20
#define MSK_NETX_USB_CORE_CTRL_vb_on              0x00200000U // [21]
#define SRT_NETX_USB_CORE_CTRL_vb_on              21
#define MSK_NETX_USB_CORE_CTRL_dischrg_vbus       0x00400000U // [22]
#define SRT_NETX_USB_CORE_CTRL_dischrg_vbus       22
#define MSK_NETX_USB_CORE_CTRL_ucif_rdy           0x00800000U // [23]
#define SRT_NETX_USB_CORE_CTRL_ucif_rdy           23
#define MSK_NETX_USB_CORE_CTRL_usb_irq            0x01000000U // [24]
#define SRT_NETX_USB_CORE_CTRL_usb_irq            24

enum {
	BFW_NETX_USB_CORE_CTRL_reset              = 1, // [0]
	BFW_NETX_USB_CORE_CTRL_dbg_support        = 1, // [1]
	BFW_NETX_USB_CORE_CTRL_xtd_dbg_support    = 1, // [2]
	BFW_NETX_USB_CORE_CTRL_soft_id_dig        = 1, // [3]
	BFW_NETX_USB_CORE_CTRL_alt_buffer_support = 8, // [11:4]
	BFW_NETX_USB_CORE_CTRL_core_suspend_n     = 1, // [12]
	BFW_NETX_USB_CORE_CTRL_xcvr_suspend_n     = 1, // [13]
	BFW_NETX_USB_CORE_CTRL_over_current       = 1, // [14]
	BFW_NETX_USB_CORE_CTRL_va_sess_vld        = 1, // [15]
	BFW_NETX_USB_CORE_CTRL_vb_sess_end        = 1, // [16]
	BFW_NETX_USB_CORE_CTRL_vb_sess_vld        = 1, // [17]
	BFW_NETX_USB_CORE_CTRL_vbus_vld           = 1, // [18]
	BFW_NETX_USB_CORE_CTRL_chrg_vbus          = 1, // [19]
	BFW_NETX_USB_CORE_CTRL_dlp_active         = 1, // [20]
	BFW_NETX_USB_CORE_CTRL_vb_on              = 1, // [21]
	BFW_NETX_USB_CORE_CTRL_dischrg_vbus       = 1, // [22]
	BFW_NETX_USB_CORE_CTRL_ucif_rdy           = 1, // [23]
	BFW_NETX_USB_CORE_CTRL_usb_irq            = 1, // [24]
	BFW_NETX_USB_CORE_CTRL_reserved1          = 7  // [31:25]
};

typedef struct USB_CORE_CTRL_BIT_Ttag {
	unsigned int reset              : BFW_NETX_USB_CORE_CTRL_reset;              // software reset (r/w)
	unsigned int dbg_support        : BFW_NETX_USB_CORE_CTRL_dbg_support;        // enables debug support (r/w)
	unsigned int xtd_dbg_support    : BFW_NETX_USB_CORE_CTRL_xtd_dbg_support;    // enables extended debug support (r/w)
	unsigned int soft_id_dig        : BFW_NETX_USB_CORE_CTRL_soft_id_dig;        // to set id_dig via software (r/w)
	unsigned int alt_buffer_support : BFW_NETX_USB_CORE_CTRL_alt_buffer_support; // alt buffer support (r/w)
	unsigned int core_suspend_n     : BFW_NETX_USB_CORE_CTRL_core_suspend_n;     // reflects core_suspend_n (ro)
	unsigned int xcvr_suspend_n     : BFW_NETX_USB_CORE_CTRL_xcvr_suspend_n;     // reflects xcvr_suspend_n (ro)
	unsigned int over_current       : BFW_NETX_USB_CORE_CTRL_over_current;       // reflects over_current (ro)
	unsigned int va_sess_vld        : BFW_NETX_USB_CORE_CTRL_va_sess_vld;        // reflects va_sess_vld (ro)
	unsigned int vb_sess_end        : BFW_NETX_USB_CORE_CTRL_vb_sess_end;        // reflects vb_sess_end (ro)
	unsigned int vb_sess_vld        : BFW_NETX_USB_CORE_CTRL_vb_sess_vld;        // reflects vb_sess_vld (ro)
	unsigned int vbus_vld           : BFW_NETX_USB_CORE_CTRL_vbus_vld;           // reflects vbus_vld (ro)
	unsigned int chrg_vbus          : BFW_NETX_USB_CORE_CTRL_chrg_vbus;          // reflects chrg_vbus (ro)
	unsigned int dlp_active         : BFW_NETX_USB_CORE_CTRL_dlp_active;         // reflects dlp_active (ro)
	unsigned int vb_on              : BFW_NETX_USB_CORE_CTRL_vb_on;              // reflects vb_on (ro)
	unsigned int dischrg_vbus       : BFW_NETX_USB_CORE_CTRL_dischrg_vbus;       // reflects dischrg_vbus (ro)
	unsigned int ucif_rdy           : BFW_NETX_USB_CORE_CTRL_ucif_rdy;           // reflects ucif_rdy (ro)
	unsigned int usb_irq            : BFW_NETX_USB_CORE_CTRL_usb_irq;            // reflects usb_irq (ro)
	unsigned int reserved1          : BFW_NETX_USB_CORE_CTRL_reserved1;          // reserved
} USB_CORE_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	USB_CORE_CTRL_BIT_T bf;
} USB_CORE_CTRL_T;


// =====================================================================
//
// Area of usb_fifo
//
// =====================================================================

#define NETX_USB_FIFO_AREA	0x1C030000U

// ---------------------------------------------------------------------
// Register USB_FIFO_BASE
// =>  USB End Point 0 (IN) Base Address
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_USB_FIFO 0x00000000U
#define NETX_USB_FIFO     0x1C030000U


// =====================================================================
//
// Area of xc
//
// =====================================================================

#define NETX_XC_AREA	0x1C040000U

// ---------------------------------------------------------------------
// Register xc_base
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_XC_BASE 0x00000000U
#define NETX_XC_BASE     0x1C040000U


// =====================================================================
//
// Area of xpec0, xpec1
//
// =====================================================================

#define NETX_XP0_BASE	0x1C040000U
#define NETX_XP1_BASE	0x1C048000U

// ---------------------------------------------------------------------
// Register xpec_r0
// =>  xPEC work register for indirect addressing
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R0   0x00000000U
#define NETX_XP0_R0 0x1C040000U
#define NETX_XP1_R0 0x1C048000U

#define MSK_NETX_XP_R0_r0 0xffffffffU // [31:0]
#define SRT_NETX_XP_R0_r0 0

enum {
	BFW_NETX_XP_R0_r0 = 32  // [31:0]
};

typedef struct XPEC_R0_BIT_Ttag {
	unsigned int r0 : BFW_NETX_XP_R0_r0; // Work Register 0
} XPEC_R0_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R0_BIT_T bf;
} XPEC_R0_T;

// ---------------------------------------------------------------------
// Register xpec_r1
// =>  xPEC work register for indirect addressing
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R1   0x00000004U
#define NETX_XP0_R1 0x1C040004U
#define NETX_XP1_R1 0x1C048004U

#define MSK_NETX_XP_R1_r1 0xffffffffU // [31:0]
#define SRT_NETX_XP_R1_r1 0

enum {
	BFW_NETX_XP_R1_r1 = 32  // [31:0]
};

typedef struct XPEC_R1_BIT_Ttag {
	unsigned int r1 : BFW_NETX_XP_R1_r1; // Work Register 1
} XPEC_R1_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R1_BIT_T bf;
} XPEC_R1_T;

// ---------------------------------------------------------------------
// Register xpec_r2
// =>  xPEC work register for indirect addressing
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R2   0x00000008U
#define NETX_XP0_R2 0x1C040008U
#define NETX_XP1_R2 0x1C048008U

#define MSK_NETX_XP_R2_r2 0xffffffffU // [31:0]
#define SRT_NETX_XP_R2_r2 0

enum {
	BFW_NETX_XP_R2_r2 = 32  // [31:0]
};

typedef struct XPEC_R2_BIT_Ttag {
	unsigned int r2 : BFW_NETX_XP_R2_r2; // Work Register 2
} XPEC_R2_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R2_BIT_T bf;
} XPEC_R2_T;

// ---------------------------------------------------------------------
// Register xpec_r3
// =>  xPEC work register for indirect addressing
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R3   0x0000000CU
#define NETX_XP0_R3 0x1C04000CU
#define NETX_XP1_R3 0x1C04800CU

#define MSK_NETX_XP_R3_r3 0xffffffffU // [31:0]
#define SRT_NETX_XP_R3_r3 0

enum {
	BFW_NETX_XP_R3_r3 = 32  // [31:0]
};

typedef struct XPEC_R3_BIT_Ttag {
	unsigned int r3 : BFW_NETX_XP_R3_r3; // Work Register 3
} XPEC_R3_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R3_BIT_T bf;
} XPEC_R3_T;

// ---------------------------------------------------------------------
// Register xpec_r4
// =>  xPEC work register for indirect addressing
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R4   0x00000010U
#define NETX_XP0_R4 0x1C040010U
#define NETX_XP1_R4 0x1C048010U

#define MSK_NETX_XP_R4_r4 0xffffffffU // [31:0]
#define SRT_NETX_XP_R4_r4 0

enum {
	BFW_NETX_XP_R4_r4 = 32  // [31:0]
};

typedef struct XPEC_R4_BIT_Ttag {
	unsigned int r4 : BFW_NETX_XP_R4_r4; // Work Register 4
} XPEC_R4_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R4_BIT_T bf;
} XPEC_R4_T;

// ---------------------------------------------------------------------
// Register xpec_r5
// =>  xPEC work register for indirect addressing
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R5   0x00000014U
#define NETX_XP0_R5 0x1C040014U
#define NETX_XP1_R5 0x1C048014U

#define MSK_NETX_XP_R5_r5 0xffffffffU // [31:0]
#define SRT_NETX_XP_R5_r5 0

enum {
	BFW_NETX_XP_R5_r5 = 32  // [31:0]
};

typedef struct XPEC_R5_BIT_Ttag {
	unsigned int r5 : BFW_NETX_XP_R5_r5; // Work Register 5
} XPEC_R5_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R5_BIT_T bf;
} XPEC_R5_T;

// ---------------------------------------------------------------------
// Register xpec_r6
// =>  xPEC work register for indirect addressing
//     Shared in xPEC fmmusm mode with fmmusm_read_addr_in (w mode).
//     Shared in xPEC fmmusm mode with sm_read_addr_out (r mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R6   0x00000018U
#define NETX_XP0_R6 0x1C040018U
#define NETX_XP1_R6 0x1C048018U

#define MSK_NETX_XP_R6_r6 0xffffffffU // [31:0]
#define SRT_NETX_XP_R6_r6 0

enum {
	BFW_NETX_XP_R6_r6 = 32  // [31:0]
};

typedef struct XPEC_R6_BIT_Ttag {
	unsigned int r6 : BFW_NETX_XP_R6_r6; // Work Register 6
} XPEC_R6_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R6_BIT_T bf;
} XPEC_R6_T;

// ---------------------------------------------------------------------
// Register xpec_r7
// =>  xPEC work register for indirect addressing
//     Shared in xPEC fmmusm mode with fmmusm_write_addr_in (w mode).
//     Shared in xPEC fmmusm mode with sm_write_addr_out (r mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_R7   0x0000001CU
#define NETX_XP0_R7 0x1C04001CU
#define NETX_XP1_R7 0x1C04801CU

#define MSK_NETX_XP_R7_r7 0xffffffffU // [31:0]
#define SRT_NETX_XP_R7_r7 0

enum {
	BFW_NETX_XP_R7_r7 = 32  // [31:0]
};

typedef struct XPEC_R7_BIT_Ttag {
	unsigned int r7 : BFW_NETX_XP_R7_r7; // Work Register 7
} XPEC_R7_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_R7_BIT_T bf;
} XPEC_R7_T;

// ---------------------------------------------------------------------
// Register range01
// =>  xPEC Overflow Underflow register to limit stack and fifo buffer.
//     Generates range bits inside xPEC status register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_RANGE_01   0x00000020U
#define NETX_XP0_RANGE_01 0x1C040020U
#define NETX_XP1_RANGE_01 0x1C048020U

#define MSK_NETX_XP_RANGE_01_range0  0x00001fffU // [12:0]
#define SRT_NETX_XP_RANGE_01_range0  0
#define MSK_NETX_XP_RANGE_01_bigger0 0x00002000U // [13]
#define SRT_NETX_XP_RANGE_01_bigger0 13
#define MSK_NETX_XP_RANGE_01_range1  0x1fff0000U // [28:16]
#define SRT_NETX_XP_RANGE_01_range1  16
#define MSK_NETX_XP_RANGE_01_bigger1 0x20000000U // [29]
#define SRT_NETX_XP_RANGE_01_bigger1 29

enum {
	BFW_NETX_XP_RANGE_01_range0    = 13, // [12:0]
	BFW_NETX_XP_RANGE_01_bigger0   = 1,  // [13]
	BFW_NETX_XP_RANGE_01_reserved1 = 2,  // [15:14]
	BFW_NETX_XP_RANGE_01_range1    = 13, // [28:16]
	BFW_NETX_XP_RANGE_01_bigger1   = 1,  // [29]
	BFW_NETX_XP_RANGE_01_reserved2 = 2   // [31:30]
};

typedef struct RANGE01_BIT_Ttag {
	unsigned int range0    : BFW_NETX_XP_RANGE_01_range0;    // border for xpec_r0
	unsigned int bigger0   : BFW_NETX_XP_RANGE_01_bigger0;   // 0: generate range status bit, if r0 < range0; 1: generate range status bit, if r0 >= range0
	unsigned int reserved1 : BFW_NETX_XP_RANGE_01_reserved1; // reserved
	unsigned int range1    : BFW_NETX_XP_RANGE_01_range1;    // border for xpec_r1
	unsigned int bigger1   : BFW_NETX_XP_RANGE_01_bigger1;   // 0: generate range status bit, if r1 < range1; 1: generate range status bit, if r1 >= range1
	unsigned int reserved2 : BFW_NETX_XP_RANGE_01_reserved2; // reserved
} RANGE01_BIT_T;

typedef union {
	unsigned int  val;
	RANGE01_BIT_T bf;
} RANGE01_T;

// ---------------------------------------------------------------------
// Register range23
// =>  xPEC Overflow Underflow register to limit stack and fifo buffer.
//     Generates range bits inside xPEC status register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_RANGE_23   0x00000024U
#define NETX_XP0_RANGE_23 0x1C040024U
#define NETX_XP1_RANGE_23 0x1C048024U

#define MSK_NETX_XP_RANGE_23_range2  0x00001fffU // [12:0]
#define SRT_NETX_XP_RANGE_23_range2  0
#define MSK_NETX_XP_RANGE_23_bigger2 0x00002000U // [13]
#define SRT_NETX_XP_RANGE_23_bigger2 13
#define MSK_NETX_XP_RANGE_23_range3  0x1fff0000U // [28:16]
#define SRT_NETX_XP_RANGE_23_range3  16
#define MSK_NETX_XP_RANGE_23_bigger3 0x20000000U // [29]
#define SRT_NETX_XP_RANGE_23_bigger3 29

enum {
	BFW_NETX_XP_RANGE_23_range2    = 13, // [12:0]
	BFW_NETX_XP_RANGE_23_bigger2   = 1,  // [13]
	BFW_NETX_XP_RANGE_23_reserved1 = 2,  // [15:14]
	BFW_NETX_XP_RANGE_23_range3    = 13, // [28:16]
	BFW_NETX_XP_RANGE_23_bigger3   = 1,  // [29]
	BFW_NETX_XP_RANGE_23_reserved2 = 2   // [31:30]
};

typedef struct RANGE23_BIT_Ttag {
	unsigned int range2    : BFW_NETX_XP_RANGE_23_range2;    // border for xpec_r2
	unsigned int bigger2   : BFW_NETX_XP_RANGE_23_bigger2;   // 0: generate range status bit, if r2 < range2; 1: generate range status bit, if r2 >= range2
	unsigned int reserved1 : BFW_NETX_XP_RANGE_23_reserved1; // reserved
	unsigned int range3    : BFW_NETX_XP_RANGE_23_range3;    // border for xpec_r3
	unsigned int bigger3   : BFW_NETX_XP_RANGE_23_bigger3;   // 0: generate range status bit, if r3 < range3; 1: generate range status bit, if r3 >= range3
	unsigned int reserved2 : BFW_NETX_XP_RANGE_23_reserved2; // reserved
} RANGE23_BIT_T;

typedef union {
	unsigned int  val;
	RANGE23_BIT_T bf;
} RANGE23_T;

// ---------------------------------------------------------------------
// Register range45
// =>  xPEC Overflow Underflow register to limit stack and fifo buffer.
//     Generates range bits inside xPEC status register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_RANGE_45   0x00000028U
#define NETX_XP0_RANGE_45 0x1C040028U
#define NETX_XP1_RANGE_45 0x1C048028U

#define MSK_NETX_XP_RANGE_45_range4  0x00001fffU // [12:0]
#define SRT_NETX_XP_RANGE_45_range4  0
#define MSK_NETX_XP_RANGE_45_bigger4 0x00002000U // [13]
#define SRT_NETX_XP_RANGE_45_bigger4 13
#define MSK_NETX_XP_RANGE_45_range5  0x1fff0000U // [28:16]
#define SRT_NETX_XP_RANGE_45_range5  16
#define MSK_NETX_XP_RANGE_45_bigger5 0x20000000U // [29]
#define SRT_NETX_XP_RANGE_45_bigger5 29

enum {
	BFW_NETX_XP_RANGE_45_range4    = 13, // [12:0]
	BFW_NETX_XP_RANGE_45_bigger4   = 1,  // [13]
	BFW_NETX_XP_RANGE_45_reserved1 = 2,  // [15:14]
	BFW_NETX_XP_RANGE_45_range5    = 13, // [28:16]
	BFW_NETX_XP_RANGE_45_bigger5   = 1,  // [29]
	BFW_NETX_XP_RANGE_45_reserved2 = 2   // [31:30]
};

typedef struct RANGE45_BIT_Ttag {
	unsigned int range4    : BFW_NETX_XP_RANGE_45_range4;    // border for xpec_r4
	unsigned int bigger4   : BFW_NETX_XP_RANGE_45_bigger4;   // 0: generate range status bit, if r4 < range4; 1: generate range status bit, if r4 >= range4
	unsigned int reserved1 : BFW_NETX_XP_RANGE_45_reserved1; // reserved
	unsigned int range5    : BFW_NETX_XP_RANGE_45_range5;    // border for xpec_r5
	unsigned int bigger5   : BFW_NETX_XP_RANGE_45_bigger5;   // 0: generate range status bit, if r5 < range5; 1: generate range status bit, if r5 >= range5
	unsigned int reserved2 : BFW_NETX_XP_RANGE_45_reserved2; // reserved
} RANGE45_BIT_T;

typedef union {
	unsigned int  val;
	RANGE45_BIT_T bf;
} RANGE45_T;

// ---------------------------------------------------------------------
// Register range67
// =>  xPEC Overflow Underflow register to limit stack and fifo buffer.
//     Generates range bits inside xPEC status register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_RANGE_67   0x0000002CU
#define NETX_XP0_RANGE_67 0x1C04002CU
#define NETX_XP1_RANGE_67 0x1C04802CU

#define MSK_NETX_XP_RANGE_67_range6  0x00001fffU // [12:0]
#define SRT_NETX_XP_RANGE_67_range6  0
#define MSK_NETX_XP_RANGE_67_bigger6 0x00002000U // [13]
#define SRT_NETX_XP_RANGE_67_bigger6 13
#define MSK_NETX_XP_RANGE_67_range7  0x1fff0000U // [28:16]
#define SRT_NETX_XP_RANGE_67_range7  16
#define MSK_NETX_XP_RANGE_67_bigger7 0x20000000U // [29]
#define SRT_NETX_XP_RANGE_67_bigger7 29

enum {
	BFW_NETX_XP_RANGE_67_range6    = 13, // [12:0]
	BFW_NETX_XP_RANGE_67_bigger6   = 1,  // [13]
	BFW_NETX_XP_RANGE_67_reserved1 = 2,  // [15:14]
	BFW_NETX_XP_RANGE_67_range7    = 13, // [28:16]
	BFW_NETX_XP_RANGE_67_bigger7   = 1,  // [29]
	BFW_NETX_XP_RANGE_67_reserved2 = 2   // [31:30]
};

typedef struct RANGE67_BIT_Ttag {
	unsigned int range6    : BFW_NETX_XP_RANGE_67_range6;    // border for xpec_r6
	unsigned int bigger6   : BFW_NETX_XP_RANGE_67_bigger6;   // 0: generate range status bit, if r6 < range6; 1: generate range status bit, if r6 >= range6
	unsigned int reserved1 : BFW_NETX_XP_RANGE_67_reserved1; // reserved
	unsigned int range7    : BFW_NETX_XP_RANGE_67_range7;    // border for xpec_r7
	unsigned int bigger7   : BFW_NETX_XP_RANGE_67_bigger7;   // 0: generate range status bit, if r7 < range7; 1: generate range status bit, if r7 >= range7
	unsigned int reserved2 : BFW_NETX_XP_RANGE_67_reserved2; // reserved
} RANGE67_BIT_T;

typedef union {
	unsigned int  val;
	RANGE67_BIT_T bf;
} RANGE67_T;

// ---------------------------------------------------------------------
// Register timer0
// =>  xPEC Timer 0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_TMR0   0x00000030U
#define NETX_XP0_TMR0 0x1C040030U
#define NETX_XP1_TMR0 0x1C048030U

#define MSK_NETX_XP_TMR0_preload0 0xffffffffU // [31:0]
#define SRT_NETX_XP_TMR0_preload0 0

enum {
	BFW_NETX_XP_TMR0_preload0 = 32  // [31:0]
};

typedef struct TIMER0_BIT_Ttag {
	unsigned int preload0 : BFW_NETX_XP_TMR0_preload0; // read: actual value of timer, write: timer and preload value
} TIMER0_BIT_T;

typedef union {
	unsigned int val;
	TIMER0_BIT_T bf;
} TIMER0_T;

// ---------------------------------------------------------------------
// Register timer1
// =>  xPEC Timer 1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_TMR1   0x00000034U
#define NETX_XP0_TMR1 0x1C040034U
#define NETX_XP1_TMR1 0x1C048034U

#define MSK_NETX_XP_TMR1_preload1 0xffffffffU // [31:0]
#define SRT_NETX_XP_TMR1_preload1 0

enum {
	BFW_NETX_XP_TMR1_preload1 = 32  // [31:0]
};

typedef struct TIMER1_BIT_Ttag {
	unsigned int preload1 : BFW_NETX_XP_TMR1_preload1; // read: actual value of timer, write: timer and preload value
} TIMER1_BIT_T;

typedef union {
	unsigned int val;
	TIMER1_BIT_T bf;
} TIMER1_T;

// ---------------------------------------------------------------------
// Register timer2
// =>  xPEC Timer 2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_TMR2   0x00000038U
#define NETX_XP0_TMR2 0x1C040038U
#define NETX_XP1_TMR2 0x1C048038U

#define MSK_NETX_XP_TMR2_preload2 0xffffffffU // [31:0]
#define SRT_NETX_XP_TMR2_preload2 0

enum {
	BFW_NETX_XP_TMR2_preload2 = 32  // [31:0]
};

typedef struct TIMER2_BIT_Ttag {
	unsigned int preload2 : BFW_NETX_XP_TMR2_preload2; // read: actual value of timer, write: timer and preload value
} TIMER2_BIT_T;

typedef union {
	unsigned int val;
	TIMER2_BIT_T bf;
} TIMER2_T;

// ---------------------------------------------------------------------
// Register timer3
// =>  xPEC Timer 3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_TMR3   0x0000003CU
#define NETX_XP0_TMR3 0x1C04003CU
#define NETX_XP1_TMR3 0x1C04803CU

#define MSK_NETX_XP_TMR3_preload3 0xffffffffU // [31:0]
#define SRT_NETX_XP_TMR3_preload3 0

enum {
	BFW_NETX_XP_TMR3_preload3 = 32  // [31:0]
};

typedef struct TIMER3_BIT_Ttag {
	unsigned int preload3 : BFW_NETX_XP_TMR3_preload3; // read: actual value of timer, write: timer and preload value
} TIMER3_BIT_T;

typedef union {
	unsigned int val;
	TIMER3_BIT_T bf;
} TIMER3_T;

// ---------------------------------------------------------------------
// Register urx_count
// =>  xPEC urx counter
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_URX_CNT   0x00000040U
#define NETX_XP0_URX_CNT 0x1C040040U
#define NETX_XP1_URX_CNT 0x1C048040U

#define MSK_NETX_XP_URX_CNT_urx_count 0xffffffffU // [31:0]
#define SRT_NETX_XP_URX_CNT_urx_count 0

enum {
	BFW_NETX_XP_URX_CNT_urx_count = 32  // [31:0]
};

typedef struct URX_COUNT_BIT_Ttag {
	unsigned int urx_count : BFW_NETX_XP_URX_CNT_urx_count; // counts up received bytes (accesses of xPEC to any URX FIFO)
} URX_COUNT_BIT_T;

typedef union {
	unsigned int    val;
	URX_COUNT_BIT_T bf;
} URX_COUNT_T;

// ---------------------------------------------------------------------
// Register utx_count
// =>  xPEC utx counter
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_UTX_CNT   0x00000044U
#define NETX_XP0_UTX_CNT 0x1C040044U
#define NETX_XP1_UTX_CNT 0x1C048044U

#define MSK_NETX_XP_UTX_CNT_utx_count 0xffffffffU // [31:0]
#define SRT_NETX_XP_UTX_CNT_utx_count 0

enum {
	BFW_NETX_XP_UTX_CNT_utx_count = 32  // [31:0]
};

typedef struct UTX_COUNT_BIT_Ttag {
	unsigned int utx_count : BFW_NETX_XP_UTX_CNT_utx_count; // counts up transmitted bytes (accesses of xPEC to any UTX FIFO)
} UTX_COUNT_BIT_T;

typedef union {
	unsigned int    val;
	UTX_COUNT_BIT_T bf;
} UTX_COUNT_T;

// ---------------------------------------------------------------------
// Register xpec_pc
// =>  xPEC Program Counter
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_PC   0x00000048U
#define NETX_XP0_PC 0x1C040048U
#define NETX_XP1_PC 0x1C048048U

#define MSK_NETX_XP_PC_pc 0x000007ffU // [10:0]
#define SRT_NETX_XP_PC_pc 0

enum {
	BFW_NETX_XP_PC_pc        = 11, // [10:0]
	BFW_NETX_XP_PC_reserved1 = 21  // [31:11]
};

typedef struct XPEC_PC_BIT_Ttag {
	unsigned int pc        : BFW_NETX_XP_PC_pc;        // Program Counter (dword address inside DPRAM)
	unsigned int reserved1 : BFW_NETX_XP_PC_reserved1; // reserved
} XPEC_PC_BIT_T;

typedef union {
	unsigned int  val;
	XPEC_PC_BIT_T bf;
} XPEC_PC_T;

// ---------------------------------------------------------------------
// Register zero
// =>  Zero Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_ZERO   0x0000004CU
#define NETX_XP0_ZERO 0x1C04004CU
#define NETX_XP1_ZERO 0x1C04804CU

#define MSK_NETX_XP_ZERO_zero 0xffffffffU // [31:0]
#define SRT_NETX_XP_ZERO_zero 0

enum {
	BFW_NETX_XP_ZERO_zero = 32  // [31:0]
};

typedef struct ZERO_BIT_Ttag {
	unsigned int zero : BFW_NETX_XP_ZERO_zero; // Always Zero
} ZERO_BIT_T;

typedef union {
	unsigned int val;
	ZERO_BIT_T   bf;
} ZERO_T;

// ---------------------------------------------------------------------
// Register xpec_statcfg
// =>  xPEC Config register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_STAT_CFG   0x00000050U
#define NETX_XP0_STAT_CFG 0x1C040050U
#define NETX_XP1_STAT_CFG 0x1C048050U

#define MSK_NETX_XP_STAT_CFG_timer0             0x00000003U // [1:0]
#define SRT_NETX_XP_STAT_CFG_timer0             0
#define MSK_NETX_XP_STAT_CFG_timer1             0x0000000cU // [3:2]
#define SRT_NETX_XP_STAT_CFG_timer1             2
#define MSK_NETX_XP_STAT_CFG_timer2             0x00000030U // [5:4]
#define SRT_NETX_XP_STAT_CFG_timer2             4
#define MSK_NETX_XP_STAT_CFG_timer3             0x000000c0U // [7:6]
#define SRT_NETX_XP_STAT_CFG_timer3             6
#define MSK_NETX_XP_STAT_CFG_timer4             0x00000300U // [9:8]
#define SRT_NETX_XP_STAT_CFG_timer4             8
#define MSK_NETX_XP_STAT_CFG_timer5             0x00000c00U // [11:10]
#define SRT_NETX_XP_STAT_CFG_timer5             10
#define MSK_NETX_XP_STAT_CFG_reset_req          0x00001000U // [12]
#define SRT_NETX_XP_STAT_CFG_reset_req          12
#define MSK_NETX_XP_STAT_CFG_reset_dis          0x00002000U // [13]
#define SRT_NETX_XP_STAT_CFG_reset_dis          13
#define MSK_NETX_XP_STAT_CFG_debug_mode         0x00004000U // [14]
#define SRT_NETX_XP_STAT_CFG_debug_mode         14
#define MSK_NETX_XP_STAT_CFG_register_mode      0x00030000U // [17:16]
#define SRT_NETX_XP_STAT_CFG_register_mode      16
#define MSK_NETX_XP_STAT_CFG_run_dma_controller 0x80000000U // [31]
#define SRT_NETX_XP_STAT_CFG_run_dma_controller 31

enum {
	BFW_NETX_XP_STAT_CFG_timer0             = 2,  // [1:0]
	BFW_NETX_XP_STAT_CFG_timer1             = 2,  // [3:2]
	BFW_NETX_XP_STAT_CFG_timer2             = 2,  // [5:4]
	BFW_NETX_XP_STAT_CFG_timer3             = 2,  // [7:6]
	BFW_NETX_XP_STAT_CFG_timer4             = 2,  // [9:8]
	BFW_NETX_XP_STAT_CFG_timer5             = 2,  // [11:10]
	BFW_NETX_XP_STAT_CFG_reset_req          = 1,  // [12]
	BFW_NETX_XP_STAT_CFG_reset_dis          = 1,  // [13]
	BFW_NETX_XP_STAT_CFG_debug_mode         = 1,  // [14]
	BFW_NETX_XP_STAT_CFG_reserved1          = 1,  // [15]
	BFW_NETX_XP_STAT_CFG_register_mode      = 2,  // [17:16]
	BFW_NETX_XP_STAT_CFG_reserved2          = 13, // [30:18]
	BFW_NETX_XP_STAT_CFG_run_dma_controller = 1   // [31]
};

typedef struct XPEC_STATCFG_BIT_Ttag {
	unsigned int timer0             : BFW_NETX_XP_STAT_CFG_timer0;             // Timer0
	                                                        //       2'b00 : Timer stops at 0
	                                                        //       2'b01 : Timer is preload with value from preload register at 0
	                                                        //       2'b10 : Timer (value) compare with systime
	                                                        //       2'b11 : Timer is workregister
	unsigned int timer1             : BFW_NETX_XP_STAT_CFG_timer1;             // Timer1
	unsigned int timer2             : BFW_NETX_XP_STAT_CFG_timer2;             // Timer2
	unsigned int timer3             : BFW_NETX_XP_STAT_CFG_timer3;             // Timer3
	unsigned int timer4             : BFW_NETX_XP_STAT_CFG_timer4;             // Timer4
	unsigned int timer5             : BFW_NETX_XP_STAT_CFG_timer5;             // Timer5
	unsigned int reset_req          : BFW_NETX_XP_STAT_CFG_reset_req;          // System Reset
	unsigned int reset_dis          : BFW_NETX_XP_STAT_CFG_reset_dis;          // disable own Reset
	unsigned int debug_mode         : BFW_NETX_XP_STAT_CFG_debug_mode;         // in this mode XPEC gets debug data form sr14 and sr15
	unsigned int reserved1          : BFW_NETX_XP_STAT_CFG_reserved1;          // reserved
	unsigned int register_mode      : BFW_NETX_XP_STAT_CFG_register_mode;      // Register Mode default 0
	                                                        //       2'b00 : normal mode (shared register and statcfg)
	                                                        //       2'b01 : fmmusm mode / handshake unit
	                                                        //       2'b10 : trigger_sample mode
	                                                        //       2'b11 : reserved
	unsigned int reserved2          : BFW_NETX_XP_STAT_CFG_reserved2;          // reserved
	unsigned int run_dma_controller : BFW_NETX_XP_STAT_CFG_run_dma_controller; // 0: stop dma_controller, 1: start dma_controller
	                                                        // stop / start the polling
} XPEC_STATCFG_BIT_T;

typedef union {
	unsigned int       val;
	XPEC_STATCFG_BIT_T bf;
} XPEC_STATCFG_T;

// ---------------------------------------------------------------------
// Register ec_maska
// =>  JMP-Mask a
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSKA   0x00000054U
#define NETX_XP0_EV_CTRL_MSKA 0x1C040054U
#define NETX_XP1_EV_CTRL_MSKA 0x1C048054U

#define MSK_NETX_XP_EV_CTRL_MSKA_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSKA_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSKA_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSKA_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSKA_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSKA_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSKA_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSKA_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSKA_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSKA_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSKA_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSKA_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSKA_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSKA_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSKA_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSKA_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSKA_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSKA_and_or            = 1   // [31]
};

typedef struct EC_MASKA_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSKA_sel0;              // Select of event 0:
	                                                        //     0-15    : XMAC status reg 0 (statcfg0 16:31)
	                                                        //     16-31   : XMAC status reg 1 (statcfg1 16:31)
	                                                        //     32-47   : reserved
	                                                        //     48-63   : reserved
	                                                        //     64-67   : Timer interrupt 0:3
	                                                        //     68-71   : Shared Register sr_0[12:15]
	                                                        //     72-75   : Shared Register sr_1[12:15]
	                                                        //     76-79   : Shared Register sr_2[12:15]
	                                                        //     80-83   : Shared Register sr_3[12:15]
	                                                        //     84-87   : Shared Register sr_4[12:15]
	                                                        //     88-91   : Shared Register sr_5[12:15]
	                                                        //     92-95   : Shared Register sr_6[12:15]
	                                                        //     96-99   : Shared Register sr_7[12:15]
	                                                        //     100-103 : Shared Register sr_8[12:15]
	                                                        //     104-107 : Shared Register sr_9[12:15]
	                                                        //     108-111 : Shared Register sr_10[12:15]
	                                                        //     112-115 : Shared Register sr_11[12:15]
	                                                        //     116-119 : Shared Register sr_12[12:15]
	                                                        //     120-123 : Shared Register sr_13[12:15]
	                                                        //     124-127 : Shared Register sr_14[12:15]
	                                                        //     128-131 : Shared Register sr_15[12:15]
	                                                        //     132-139 : xPEC_own(DMA_finish[0:7])
	                                                        //               132 : DMA_finish_0
	                                                        //               133 : DMA_finish_1
	                                                        //               134 : DMA_finish_2
	                                                        //               135 : DMA_finish_3
	                                                        //               136 : DMA_finish_4
	                                                        //               137 : DMA_finish_5
	                                                        //               138 : DMA_finish_6
	                                                        //               139 : DMA_finish_7
	                                                        //     140-143 : xPEC_other(DMA_finish[0:7])
	                                                        //               140 : DMA_finish_0
	                                                        //               141 : DMA_finish_1
	                                                        //               142 : DMA_finish_2
	                                                        //               143 : DMA_finish_3
	                                                        //     144-147 : reserved
	                                                        //               148 : reserved
	                                                        //               149 : reserved
	                                                        //               150 : reserved
	                                                        //               151 : reserved
	                                                        //     148-151 : reserved
	                                                        //               156 : reserved
	                                                        //               157 : reserved
	                                                        //               158 : reserved
	                                                        //               159 : reserved
	                                                        //     152-163 : FMMU_SM - Events
	                                                        //               152 : fmmu_bitwise_rd_or_wr
	                                                        //               153 : fmmu_bitwise_rd_and_wr
	                                                        //               154 : fmmu_bitwise_wr
	                                                        //               155 : fmmu_bitwise_rd
	                                                        //               156 : fmmu_rd_or_wr_match
	                                                        //               157 : fmmu_rd_and_wr_match
	                                                        //               158 : fmmu_wr_match
	                                                        //               159 : fmmu_rd_match
	                                                        //               160 : lba_match
	                                                        //               161 : fba_match
	                                                        //               162 : rd_or_wr_match
	                                                        //               163 : rd_and_wr_match
	                                                        //     164-165   : Timer interrupt 4:5
	                                                        //     166-173 : range_w0 - range_w7 smaller as w0 - w7
	                                                        //               166 : range_w0 < w0
	                                                        //               167 : range_w1 < w1
	                                                        //               168 : range_w2 < w2
	                                                        //               169 : range_w3 < w3
	                                                        //               170 : range_w4 < w4
	                                                        //               171 : range_w5 < w5
	                                                        //               172 : range_w6 < w6
	                                                        //               173 : range_w7 < w7
	                                                        //     174-181 : range_w0 - range_w7 2 smaller as w0 - w7
	                                                        //               174 : range_w0 2< w0
	                                                        //               175 : range_w1 2< w1
	                                                        //               176 : range_w2 2< w2
	                                                        //               177 : range_w3 2< w3
	                                                        //               178 : range_w4 2< w4
	                                                        //               179 : range_w5 2< w5
	                                                        //               180 : range_w6 2< w6
	                                                        //               181 : range_w7 2< w7
	                                                        //         182 : rx_rdy_asyn_xmac0
	                                                        //         183 : rx_rdy_asyn_xmac1
	                                                        //         184 : reserved
	                                                        //         185 : reserved
	                                                        //         186 : tx_nxt2_asyn_xmac0
	                                                        //         187 : tx_nxt2_asyn_xmac1
	                                                        //         188 : reserved
	                                                        //         189 : reserved
	                                                        //     190-221 : fifo_empty [0:31]
	                                                        //         222 : reserved (adc0_data_busy)
	                                                        //         223 : reserved (adc1_data_busy)
	                                                        //     224-239 : arm_irq [0:15] (from irq_reg[16:31])
	                                                        //         240 : debug_event
	                                                        //     241-242 : FMMU_SM - Events
	                                                        //               241 : wr_match
	                                                        //               242 : rd_match
	                                                        //     243-246 : SYNC_UNIT Events
	                                                        //               243 : xc_sample_in[1]
	                                                        //               244 : xc_sample_in[0]
	                                                        //               245 : xc_sync0_status
	                                                        //               246 : xc_sync1_status
	                                                        //         247 : systime_s count
	                                                        //         248 : fmmusm_status_ecat_fin
	                                                        //     249-253 : reserved
	                                                        //       254 : always zero
	                                                        //       255 : disable # default value
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSKA_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSKA_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSKA_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSKA_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSKA_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASKA_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASKA_BIT_T bf;
} EC_MASKA_T;

// ---------------------------------------------------------------------
// Register ec_maskb
// =>  JMP-Mask b
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSKB   0x00000058U
#define NETX_XP0_EV_CTRL_MSKB 0x1C040058U
#define NETX_XP1_EV_CTRL_MSKB 0x1C048058U

#define MSK_NETX_XP_EV_CTRL_MSKB_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSKB_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSKB_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSKB_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSKB_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSKB_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSKB_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSKB_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSKB_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSKB_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSKB_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSKB_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSKB_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSKB_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSKB_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSKB_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSKB_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSKB_and_or            = 1   // [31]
};

typedef struct EC_MASKB_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSKB_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSKB_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSKB_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSKB_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSKB_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSKB_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASKB_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASKB_BIT_T bf;
} EC_MASKB_T;

// ---------------------------------------------------------------------
// Register ec_mask0
// =>  JMP-Mask 0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK0   0x0000005CU
#define NETX_XP0_EV_CTRL_MSK0 0x1C04005CU
#define NETX_XP1_EV_CTRL_MSK0 0x1C04805CU

#define MSK_NETX_XP_EV_CTRL_MSK0_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK0_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK0_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK0_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK0_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK0_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK0_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK0_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK0_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK0_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK0_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK0_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK0_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK0_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK0_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK0_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK0_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK0_and_or            = 1   // [31]
};

typedef struct EC_MASK0_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK0_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK0_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK0_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK0_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK0_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK0_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK0_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK0_BIT_T bf;
} EC_MASK0_T;

// ---------------------------------------------------------------------
// Register ec_mask1
// =>  JMP-Mask 1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK1   0x00000060U
#define NETX_XP0_EV_CTRL_MSK1 0x1C040060U
#define NETX_XP1_EV_CTRL_MSK1 0x1C048060U

#define MSK_NETX_XP_EV_CTRL_MSK1_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK1_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK1_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK1_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK1_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK1_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK1_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK1_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK1_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK1_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK1_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK1_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK1_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK1_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK1_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK1_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK1_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK1_and_or            = 1   // [31]
};

typedef struct EC_MASK1_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK1_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK1_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK1_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK1_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK1_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK1_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK1_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK1_BIT_T bf;
} EC_MASK1_T;

// ---------------------------------------------------------------------
// Register ec_mask2
// =>  JMP-Mask 2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK2   0x00000064U
#define NETX_XP0_EV_CTRL_MSK2 0x1C040064U
#define NETX_XP1_EV_CTRL_MSK2 0x1C048064U

#define MSK_NETX_XP_EV_CTRL_MSK2_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK2_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK2_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK2_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK2_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK2_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK2_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK2_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK2_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK2_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK2_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK2_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK2_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK2_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK2_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK2_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK2_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK2_and_or            = 1   // [31]
};

typedef struct EC_MASK2_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK2_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK2_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK2_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK2_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK2_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK2_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK2_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK2_BIT_T bf;
} EC_MASK2_T;

// ---------------------------------------------------------------------
// Register ec_mask3
// =>  JMP-Mask 3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK3   0x00000068U
#define NETX_XP0_EV_CTRL_MSK3 0x1C040068U
#define NETX_XP1_EV_CTRL_MSK3 0x1C048068U

#define MSK_NETX_XP_EV_CTRL_MSK3_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK3_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK3_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK3_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK3_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK3_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK3_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK3_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK3_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK3_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK3_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK3_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK3_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK3_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK3_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK3_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK3_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK3_and_or            = 1   // [31]
};

typedef struct EC_MASK3_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK3_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK3_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK3_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK3_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK3_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK3_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK3_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK3_BIT_T bf;
} EC_MASK3_T;

// ---------------------------------------------------------------------
// Register ec_mask4
// =>  JMP-Mask 4
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK4   0x0000006CU
#define NETX_XP0_EV_CTRL_MSK4 0x1C04006CU
#define NETX_XP1_EV_CTRL_MSK4 0x1C04806CU

#define MSK_NETX_XP_EV_CTRL_MSK4_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK4_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK4_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK4_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK4_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK4_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK4_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK4_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK4_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK4_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK4_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK4_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK4_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK4_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK4_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK4_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK4_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK4_and_or            = 1   // [31]
};

typedef struct EC_MASK4_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK4_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK4_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK4_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK4_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK4_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK4_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK4_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK4_BIT_T bf;
} EC_MASK4_T;

// ---------------------------------------------------------------------
// Register ec_mask5
// =>  JMP-Mask 5
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK5   0x00000070U
#define NETX_XP0_EV_CTRL_MSK5 0x1C040070U
#define NETX_XP1_EV_CTRL_MSK5 0x1C048070U

#define MSK_NETX_XP_EV_CTRL_MSK5_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK5_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK5_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK5_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK5_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK5_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK5_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK5_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK5_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK5_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK5_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK5_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK5_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK5_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK5_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK5_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK5_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK5_and_or            = 1   // [31]
};

typedef struct EC_MASK5_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK5_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK5_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK5_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK5_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK5_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK5_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK5_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK5_BIT_T bf;
} EC_MASK5_T;

// ---------------------------------------------------------------------
// Register ec_mask6
// =>  JMP-Mask 6
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK6   0x00000074U
#define NETX_XP0_EV_CTRL_MSK6 0x1C040074U
#define NETX_XP1_EV_CTRL_MSK6 0x1C048074U

#define MSK_NETX_XP_EV_CTRL_MSK6_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK6_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK6_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK6_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK6_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK6_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK6_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK6_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK6_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK6_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK6_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK6_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK6_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK6_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK6_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK6_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK6_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK6_and_or            = 1   // [31]
};

typedef struct EC_MASK6_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK6_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK6_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK6_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK6_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK6_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK6_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK6_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK6_BIT_T bf;
} EC_MASK6_T;

// ---------------------------------------------------------------------
// Register ec_mask7
// =>  JMP-Mask 7
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK7   0x00000078U
#define NETX_XP0_EV_CTRL_MSK7 0x1C040078U
#define NETX_XP1_EV_CTRL_MSK7 0x1C048078U

#define MSK_NETX_XP_EV_CTRL_MSK7_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK7_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK7_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK7_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK7_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK7_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK7_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK7_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK7_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK7_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK7_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK7_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK7_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK7_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK7_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK7_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK7_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK7_and_or            = 1   // [31]
};

typedef struct EC_MASK7_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK7_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK7_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK7_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK7_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK7_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK7_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK7_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK7_BIT_T bf;
} EC_MASK7_T;

// ---------------------------------------------------------------------
// Register ec_mask8
// =>  JMP-Mask 8
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK8   0x0000007CU
#define NETX_XP0_EV_CTRL_MSK8 0x1C04007CU
#define NETX_XP1_EV_CTRL_MSK8 0x1C04807CU

#define MSK_NETX_XP_EV_CTRL_MSK8_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK8_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK8_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK8_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK8_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK8_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK8_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK8_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK8_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK8_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK8_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK8_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK8_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK8_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK8_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK8_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK8_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK8_and_or            = 1   // [31]
};

typedef struct EC_MASK8_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK8_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK8_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK8_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK8_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK8_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK8_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK8_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK8_BIT_T bf;
} EC_MASK8_T;

// ---------------------------------------------------------------------
// Register ec_mask9
// =>  JMP-Mask 9
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_EV_CTRL_MSK9   0x00000080U
#define NETX_XP0_EV_CTRL_MSK9 0x1C040080U
#define NETX_XP1_EV_CTRL_MSK9 0x1C048080U

#define MSK_NETX_XP_EV_CTRL_MSK9_sel0              0x000000ffU // [7:0]
#define SRT_NETX_XP_EV_CTRL_MSK9_sel0              0
#define MSK_NETX_XP_EV_CTRL_MSK9_sel1              0x0000ff00U // [15:8]
#define SRT_NETX_XP_EV_CTRL_MSK9_sel1              8
#define MSK_NETX_XP_EV_CTRL_MSK9_jmp_adr           0x07ff0000U // [26:16]
#define SRT_NETX_XP_EV_CTRL_MSK9_jmp_adr           16
#define MSK_NETX_XP_EV_CTRL_MSK9_level_edge_event0 0x18000000U // [28:27]
#define SRT_NETX_XP_EV_CTRL_MSK9_level_edge_event0 27
#define MSK_NETX_XP_EV_CTRL_MSK9_level_edge_event1 0x60000000U // [30:29]
#define SRT_NETX_XP_EV_CTRL_MSK9_level_edge_event1 29
#define MSK_NETX_XP_EV_CTRL_MSK9_and_or            0x80000000U // [31]
#define SRT_NETX_XP_EV_CTRL_MSK9_and_or            31

enum {
	BFW_NETX_XP_EV_CTRL_MSK9_sel0              = 8,  // [7:0]
	BFW_NETX_XP_EV_CTRL_MSK9_sel1              = 8,  // [15:8]
	BFW_NETX_XP_EV_CTRL_MSK9_jmp_adr           = 11, // [26:16]
	BFW_NETX_XP_EV_CTRL_MSK9_level_edge_event0 = 2,  // [28:27]
	BFW_NETX_XP_EV_CTRL_MSK9_level_edge_event1 = 2,  // [30:29]
	BFW_NETX_XP_EV_CTRL_MSK9_and_or            = 1   // [31]
};

typedef struct EC_MASK9_BIT_Ttag {
	unsigned int sel0              : BFW_NETX_XP_EV_CTRL_MSK9_sel0;              // Select of event 0
	unsigned int sel1              : BFW_NETX_XP_EV_CTRL_MSK9_sel1;              // Select of event 1
	unsigned int jmp_adr           : BFW_NETX_XP_EV_CTRL_MSK9_jmp_adr;           // jmp address (0-2047)
	unsigned int level_edge_event0 : BFW_NETX_XP_EV_CTRL_MSK9_level_edge_event0; // for event 0 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int level_edge_event1 : BFW_NETX_XP_EV_CTRL_MSK9_level_edge_event1; // for event 1 : level / edge sensitive:
	                                                        //               2'b00 sensitve to 1 level
	                                                        //               2'b01 sensitve to 0 level
	                                                        //               2'b10 sensitve to positive edge (low to high)
	                                                        //               2'b11 sensitve to negative edge (high to low)
	unsigned int and_or            : BFW_NETX_XP_EV_CTRL_MSK9_and_or;            // and/or bit:
	                                                        // 0 - All bits of mask must fit with events,
	                                                        // 1 - Only one bit of mask must fit with events # default 0
} EC_MASK9_BIT_T;

typedef union {
	unsigned int   val;
	EC_MASK9_BIT_T bf;
} EC_MASK9_T;

// ---------------------------------------------------------------------
// Register timer4
// =>  xPEC Timer 4
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_TMR4   0x00000084U
#define NETX_XP0_TMR4 0x1C040084U
#define NETX_XP1_TMR4 0x1C048084U

#define MSK_NETX_XP_TMR4_preload2 0xffffffffU // [31:0]
#define SRT_NETX_XP_TMR4_preload2 0

enum {
	BFW_NETX_XP_TMR4_preload2 = 32  // [31:0]
};

typedef struct TIMER4_BIT_Ttag {
	unsigned int preload2 : BFW_NETX_XP_TMR4_preload2; // read: actual value of timer, write: timer and preload value
} TIMER4_BIT_T;

typedef union {
	unsigned int val;
	TIMER4_BIT_T bf;
} TIMER4_T;

// ---------------------------------------------------------------------
// Register timer5
// =>  xPEC Timer 5
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_TMR5   0x00000088U
#define NETX_XP0_TMR5 0x1C040088U
#define NETX_XP1_TMR5 0x1C048088U

#define MSK_NETX_XP_TMR5_preload3 0xffffffffU // [31:0]
#define SRT_NETX_XP_TMR5_preload3 0

enum {
	BFW_NETX_XP_TMR5_preload3 = 32  // [31:0]
};

typedef struct TIMER5_BIT_Ttag {
	unsigned int preload3 : BFW_NETX_XP_TMR5_preload3; // read: actual value of timer, write: timer and preload value
} TIMER5_BIT_T;

typedef union {
	unsigned int val;
	TIMER5_BIT_T bf;
} TIMER5_T;

// ---------------------------------------------------------------------
// Register irq
// =>  xPEC IRQ Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_IRQ   0x0000008CU
#define NETX_XP0_IRQ 0x1C04008CU
#define NETX_XP1_IRQ 0x1C04808CU

#define MSK_NETX_XP_IRQ_xpec_irq 0x0000ffffU // [15:0]
#define SRT_NETX_XP_IRQ_xpec_irq 0
#define MSK_NETX_XP_IRQ_arm_irq  0xffff0000U // [31:16]
#define SRT_NETX_XP_IRQ_arm_irq  16

enum {
	BFW_NETX_XP_IRQ_xpec_irq = 16, // [15:0]
	BFW_NETX_XP_IRQ_arm_irq  = 16  // [31:16]
};

typedef struct IRQ_BIT_Ttag {
	unsigned int xpec_irq : BFW_NETX_XP_IRQ_xpec_irq; // set by xpec ; reset by arm
	unsigned int arm_irq  : BFW_NETX_XP_IRQ_arm_irq;  // set by arm  ; reset by xpec
} IRQ_BIT_T;

typedef union {
	unsigned int val;
	IRQ_BIT_T    bf;
} IRQ_T;

// ---------------------------------------------------------------------
// Register xpec_systime_ns
// =>  xPEC System time
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XP_SYS_TIME_NS   0x00000090U
#define NETX_XP0_SYS_TIME_NS 0x1C040090U
#define NETX_XP1_SYS_TIME_NS 0x1C048090U

#define MSK_NETX_XP_SYS_TIME_NS_systime_ns 0xffffffffU // [31:0]
#define SRT_NETX_XP_SYS_TIME_NS_systime_ns 0

enum {
	BFW_NETX_XP_SYS_TIME_NS_systime_ns = 32  // [31:0]
};

typedef struct XPEC_SYSTIME_NS_BIT_Ttag {
	unsigned int systime_ns : BFW_NETX_XP_SYS_TIME_NS_systime_ns; // read: 32 - Bit System Time (ns)
} XPEC_SYSTIME_NS_BIT_T;

typedef union {
	unsigned int          val;
	XPEC_SYSTIME_NS_BIT_T bf;
} XPEC_SYSTIME_NS_T;

// ---------------------------------------------------------------------
// Register fifo_data
// =>  xPEC fifo_data
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_FIFO_DATA   0x00000094U
#define NETX_XP0_FIFO_DATA 0x1C040094U
#define NETX_XP1_FIFO_DATA 0x1C048094U

#define MSK_NETX_XP_FIFO_DATA_fifo_data 0xffffffffU // [31:0]
#define SRT_NETX_XP_FIFO_DATA_fifo_data 0

enum {
	BFW_NETX_XP_FIFO_DATA_fifo_data = 32  // [31:0]
};

typedef struct FIFO_DATA_BIT_Ttag {
	unsigned int fifo_data : BFW_NETX_XP_FIFO_DATA_fifo_data; // default 0x0000
} FIFO_DATA_BIT_T;

typedef union {
	unsigned int    val;
	FIFO_DATA_BIT_T bf;
} FIFO_DATA_T;

// ---------------------------------------------------------------------
// Register xpec_systime_s
// =>  xPEC System time
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XP_SYS_TIME_S   0x00000098U
#define NETX_XP0_SYS_TIME_S 0x1C040098U
#define NETX_XP1_SYS_TIME_S 0x1C048098U

#define MSK_NETX_XP_SYS_TIME_S_systime_s 0xffffffffU // [31:0]
#define SRT_NETX_XP_SYS_TIME_S_systime_s 0

enum {
	BFW_NETX_XP_SYS_TIME_S_systime_s = 32  // [31:0]
};

typedef struct XPEC_SYSTIME_S_BIT_Ttag {
	unsigned int systime_s : BFW_NETX_XP_SYS_TIME_S_systime_s; // read: 32 - Bit System Time (s)
} XPEC_SYSTIME_S_BIT_T;

typedef union {
	unsigned int         val;
	XPEC_SYSTIME_S_BIT_T bf;
} XPEC_SYSTIME_S_T;

// ---------------------------------------------------------------------
// Register xpec_adc
// =>  Shared in xPEC fmmusm mode with buf_man (r/w mode).
//     reserved for ADC Register in future netX-versions.
//     becomes adr_buf_man of BUF_MAN
//     Buffer manager address for master xPEC:
//     16 buffer manager modules can be accessed, where each one handles buffer numbers between up to 4 procesors.
//     Each read request of a master will be answered by the most actual buffer number,
//     each write request of a master will be answered by the lowest free buffer number.
//     The buffer managers can be accessed in 2 different modes: 'normal mode' and 'parallel mode' (also known as EtherCAT mode):
//     In normal mode getting a new buffer happens with 2 command accesses:
//     1st: Write access: Tell the buf_manager channel (0..15) and wether you want read or write buffer.
//          Wait for 2 clockcycles, until new buffer number is calculated after any write access.
//     2nd: Read access: Read the buffer number (0..4).
//     In parallel mode all buffers are accessed in parallel but some functionality is limited.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_ADC   0x0000009CU
#define NETX_XP0_ADC 0x1C04009CU
#define NETX_XP1_ADC 0x1C04809CU

#define MSK_NETX_XP_ADC_buf_nr         0x0000000fU // [3:0]
#define SRT_NETX_XP_ADC_buf_nr         0
#define MSK_NETX_XP_ADC_req_type       0x00000060U // [6:5]
#define SRT_NETX_XP_ADC_req_type       5
#define MSK_NETX_XP_ADC_semaphore_mode 0x00000080U // [7]
#define SRT_NETX_XP_ADC_semaphore_mode 7
#define MSK_NETX_XP_ADC_parallel_mode  0x00000100U // [8]
#define SRT_NETX_XP_ADC_parallel_mode  8
#define MSK_NETX_XP_ADC_reset          0x00000200U // [9]
#define SRT_NETX_XP_ADC_reset          9
#define MSK_NETX_XP_ADC_sm_update_en   0x00000400U // [10]
#define SRT_NETX_XP_ADC_sm_update_en   10
#define MSK_NETX_XP_ADC_sm_update_dis  0x00000800U // [11]
#define SRT_NETX_XP_ADC_sm_update_dis  11

enum {
	BFW_NETX_XP_ADC_buf_nr         = 4,  // [3:0]
	BFW_NETX_XP_ADC_reserved1      = 1,  // [4]
	BFW_NETX_XP_ADC_req_type       = 2,  // [6:5]
	BFW_NETX_XP_ADC_semaphore_mode = 1,  // [7]
	BFW_NETX_XP_ADC_parallel_mode  = 1,  // [8]
	BFW_NETX_XP_ADC_reset          = 1,  // [9]
	BFW_NETX_XP_ADC_sm_update_en   = 1,  // [10]
	BFW_NETX_XP_ADC_sm_update_dis  = 1,  // [11]
	BFW_NETX_XP_ADC_reserved2      = 20  // [31:12]
};

typedef struct XPEC_ADC_BIT_Ttag {
	unsigned int buf_nr         : BFW_NETX_XP_ADC_buf_nr;         // write access: number of buf_manager channel (0..15)
	                                                        // read access: number of buffer (0..m+1), where m ist the number of masters using this buf_manager
	unsigned int reserved1      : BFW_NETX_XP_ADC_reserved1;      // reserved
	unsigned int req_type       : BFW_NETX_XP_ADC_req_type;       // Request type bits are write-only
	                                                        // 00: request read buffer (or semaphore)
	                                                        // 01: request write buffer (or release semaphore)
	                                                        // 10: release write buffer (or release semaphore)
	                                                        // 11: do not request new buffer or semaphore (used to only change channel)
	unsigned int semaphore_mode : BFW_NETX_XP_ADC_semaphore_mode; // Activate 'semaphore mode' for this buf_nr by writing 1 to this bit.
	                                                        // To return from semaphore-mode reset this channel
	                                                        // In semaphore mode only buf_nr=0 (this master gets the semaphore)
	                                                        // or buf_nr=7 (master does not get semphore) are returned.
	                                                        // Requesting or releasing a semaphore (by req_type) is allowed while switching to semaphore mode
	unsigned int parallel_mode  : BFW_NETX_XP_ADC_parallel_mode;  // activate parallel mode by writing 1 to this bit (other bits are ignored):
	                                                        // In parallel mode, the behavior of all bits of this register changes completely.
	                                                        // To return to normal mode, write 0xffff0000 to this register.
	                                                        // parallel mode write access:
	                                                        //   15.. 0: Request bits of all 16 channels (1: request new buffer, 0: dont request buffer)
	                                                        //   31..16: wr bits of all 16 channels:
	                                                        //           0: request read buffer or request semaphore
	                                                        //           1: request write buffer or release semaphore
	                                                        // parallel mode read access:
	                                                        //   1,0: Actual buffer number of channel 0.
	                                                        //   ...
	                                                        //   31,30: Actual buffer number of channel 15.
	                                                        // In parallel mode the number of masters is limited to 2, resulting in 3 buffers per channel.
	                                                        // In parallel mode buffers cannot be released without requesting new buffer numbers.
	unsigned int reset          : BFW_NETX_XP_ADC_reset;          // reset channel
	unsigned int sm_update_en   : BFW_NETX_XP_ADC_sm_update_en;   // activate SM_auto_update mode by writing 1 to this bit:
	                                                        // In SM_auto_update mode the requested buffer numbers of buffer managers 0..7 will automatically
	                                                        // be programmed to the FMMU_SM unit.
	unsigned int sm_update_dis  : BFW_NETX_XP_ADC_sm_update_dis;  // de-activate SM_auto_update mode by writing 1 to this bit:
	unsigned int reserved2      : BFW_NETX_XP_ADC_reserved2;      // reserved
} XPEC_ADC_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_ADC_BIT_T bf;
} XPEC_ADC_T;

// ---------------------------------------------------------------------
// Register xpec_sr0
// =>  Shared Work Register 0 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK0   0x000000A0U
#define NETX_XP0_SHAR_WRK0 0x1C0400A0U
#define NETX_XP1_SHAR_WRK0 0x1C0480A0U

#define MSK_NETX_XP_SHAR_WRK0_SR0    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK0_SR0    0
#define MSK_NETX_XP_SHAR_WRK0_SR0_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK0_SR0_15 16

enum {
	BFW_NETX_XP_SHAR_WRK0_SR0    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK0_SR0_15 = 16  // [31:16]
};

typedef struct XPEC_SR0_BIT_Ttag {
	unsigned int SR0    : BFW_NETX_XP_SHAR_WRK0_SR0;    // Shared Register
	unsigned int SR0_15 : BFW_NETX_XP_SHAR_WRK0_SR0_15; // Sign extension
} XPEC_SR0_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR0_BIT_T bf;
} XPEC_SR0_T;

// ---------------------------------------------------------------------
// Register xpec_sr1
// =>  Shared Work Register 1 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK1   0x000000A4U
#define NETX_XP0_SHAR_WRK1 0x1C0400A4U
#define NETX_XP1_SHAR_WRK1 0x1C0480A4U

#define MSK_NETX_XP_SHAR_WRK1_SR1    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK1_SR1    0
#define MSK_NETX_XP_SHAR_WRK1_SR1_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK1_SR1_15 16

enum {
	BFW_NETX_XP_SHAR_WRK1_SR1    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK1_SR1_15 = 16  // [31:16]
};

typedef struct XPEC_SR1_BIT_Ttag {
	unsigned int SR1    : BFW_NETX_XP_SHAR_WRK1_SR1;    // Shared Register
	unsigned int SR1_15 : BFW_NETX_XP_SHAR_WRK1_SR1_15; // Sign extension
} XPEC_SR1_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR1_BIT_T bf;
} XPEC_SR1_T;

// ---------------------------------------------------------------------
// Register xpec_sr2
// =>  Shared Work Register 2 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK2   0x000000A8U
#define NETX_XP0_SHAR_WRK2 0x1C0400A8U
#define NETX_XP1_SHAR_WRK2 0x1C0480A8U

#define MSK_NETX_XP_SHAR_WRK2_SR2    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK2_SR2    0
#define MSK_NETX_XP_SHAR_WRK2_SR2_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK2_SR2_15 16

enum {
	BFW_NETX_XP_SHAR_WRK2_SR2    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK2_SR2_15 = 16  // [31:16]
};

typedef struct XPEC_SR2_BIT_Ttag {
	unsigned int SR2    : BFW_NETX_XP_SHAR_WRK2_SR2;    // Shared Register
	unsigned int SR2_15 : BFW_NETX_XP_SHAR_WRK2_SR2_15; // Sign extension
} XPEC_SR2_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR2_BIT_T bf;
} XPEC_SR2_T;

// ---------------------------------------------------------------------
// Register xpec_sr3
// =>  Shared Work Register 3 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK3   0x000000ACU
#define NETX_XP0_SHAR_WRK3 0x1C0400ACU
#define NETX_XP1_SHAR_WRK3 0x1C0480ACU

#define MSK_NETX_XP_SHAR_WRK3_SR3    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK3_SR3    0
#define MSK_NETX_XP_SHAR_WRK3_SR3_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK3_SR3_15 16

enum {
	BFW_NETX_XP_SHAR_WRK3_SR3    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK3_SR3_15 = 16  // [31:16]
};

typedef struct XPEC_SR3_BIT_Ttag {
	unsigned int SR3    : BFW_NETX_XP_SHAR_WRK3_SR3;    // Shared Register
	unsigned int SR3_15 : BFW_NETX_XP_SHAR_WRK3_SR3_15; // Sign extension
} XPEC_SR3_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR3_BIT_T bf;
} XPEC_SR3_T;

// ---------------------------------------------------------------------
// Register xpec_sr4
// =>  Shared Work Register 4 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK4   0x000000B0U
#define NETX_XP0_SHAR_WRK4 0x1C0400B0U
#define NETX_XP1_SHAR_WRK4 0x1C0480B0U

#define MSK_NETX_XP_SHAR_WRK4_SR4    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK4_SR4    0
#define MSK_NETX_XP_SHAR_WRK4_SR4_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK4_SR4_15 16

enum {
	BFW_NETX_XP_SHAR_WRK4_SR4    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK4_SR4_15 = 16  // [31:16]
};

typedef struct XPEC_SR4_BIT_Ttag {
	unsigned int SR4    : BFW_NETX_XP_SHAR_WRK4_SR4;    // Shared Register
	unsigned int SR4_15 : BFW_NETX_XP_SHAR_WRK4_SR4_15; // Sign extension
} XPEC_SR4_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR4_BIT_T bf;
} XPEC_SR4_T;

// ---------------------------------------------------------------------
// Register xpec_sr5
// =>  Shared Work Register 5 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK5   0x000000B4U
#define NETX_XP0_SHAR_WRK5 0x1C0400B4U
#define NETX_XP1_SHAR_WRK5 0x1C0480B4U

#define MSK_NETX_XP_SHAR_WRK5_SR5    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK5_SR5    0
#define MSK_NETX_XP_SHAR_WRK5_SR5_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK5_SR5_15 16

enum {
	BFW_NETX_XP_SHAR_WRK5_SR5    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK5_SR5_15 = 16  // [31:16]
};

typedef struct XPEC_SR5_BIT_Ttag {
	unsigned int SR5    : BFW_NETX_XP_SHAR_WRK5_SR5;    // Shared Register
	unsigned int SR5_15 : BFW_NETX_XP_SHAR_WRK5_SR5_15; // Sign extension
} XPEC_SR5_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR5_BIT_T bf;
} XPEC_SR5_T;

// ---------------------------------------------------------------------
// Register xpec_sr6
// =>  Shared Work Register 6 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK6   0x000000B8U
#define NETX_XP0_SHAR_WRK6 0x1C0400B8U
#define NETX_XP1_SHAR_WRK6 0x1C0480B8U

#define MSK_NETX_XP_SHAR_WRK6_SR6    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK6_SR6    0
#define MSK_NETX_XP_SHAR_WRK6_SR6_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK6_SR6_15 16

enum {
	BFW_NETX_XP_SHAR_WRK6_SR6    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK6_SR6_15 = 16  // [31:16]
};

typedef struct XPEC_SR6_BIT_Ttag {
	unsigned int SR6    : BFW_NETX_XP_SHAR_WRK6_SR6;    // Shared Register
	unsigned int SR6_15 : BFW_NETX_XP_SHAR_WRK6_SR6_15; // Sign extension
} XPEC_SR6_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR6_BIT_T bf;
} XPEC_SR6_T;

// ---------------------------------------------------------------------
// Register xpec_sr7
// =>  Shared Work Register 7 accessed by all xPECs and all xMACs.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK7   0x000000BCU
#define NETX_XP0_SHAR_WRK7 0x1C0400BCU
#define NETX_XP1_SHAR_WRK7 0x1C0480BCU

#define MSK_NETX_XP_SHAR_WRK7_SR7    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK7_SR7    0
#define MSK_NETX_XP_SHAR_WRK7_SR7_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK7_SR7_15 16

enum {
	BFW_NETX_XP_SHAR_WRK7_SR7    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK7_SR7_15 = 16  // [31:16]
};

typedef struct XPEC_SR7_BIT_Ttag {
	unsigned int SR7    : BFW_NETX_XP_SHAR_WRK7_SR7;    // Shared Register
	unsigned int SR7_15 : BFW_NETX_XP_SHAR_WRK7_SR7_15; // Sign extension
} XPEC_SR7_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR7_BIT_T bf;
} XPEC_SR7_T;

// ---------------------------------------------------------------------
// Register xpec_sr8
// =>  Shared Work Register 8 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_trigger_sample_irq (r/w mode).
//     Shared in xPEC fmmusm mode with fmmusm_len_en (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK8   0x000000C0U
#define NETX_XP0_SHAR_WRK8 0x1C0400C0U
#define NETX_XP1_SHAR_WRK8 0x1C0480C0U

#define MSK_NETX_XP_SHAR_WRK8_SR8    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK8_SR8    0
#define MSK_NETX_XP_SHAR_WRK8_SR8_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK8_SR8_15 16

enum {
	BFW_NETX_XP_SHAR_WRK8_SR8    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK8_SR8_15 = 16  // [31:16]
};

typedef struct XPEC_SR8_BIT_Ttag {
	unsigned int SR8    : BFW_NETX_XP_SHAR_WRK8_SR8;    // Shared Register
	unsigned int SR8_15 : BFW_NETX_XP_SHAR_WRK8_SR8_15; // Sign extension
} XPEC_SR8_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR8_BIT_T bf;
} XPEC_SR8_T;

// ---------------------------------------------------------------------
// Register xpec_sr9
// =>  Shared Work Register 9 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_trigger_activate (r/w mode).
//     Shared in xPEC fmmusm mode with fmmusm_status_out (r mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK9   0x000000C4U
#define NETX_XP0_SHAR_WRK9 0x1C0400C4U
#define NETX_XP1_SHAR_WRK9 0x1C0480C4U

#define MSK_NETX_XP_SHAR_WRK9_SR9    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK9_SR9    0
#define MSK_NETX_XP_SHAR_WRK9_SR9_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK9_SR9_15 16

enum {
	BFW_NETX_XP_SHAR_WRK9_SR9    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK9_SR9_15 = 16  // [31:16]
};

typedef struct XPEC_SR9_BIT_Ttag {
	unsigned int SR9    : BFW_NETX_XP_SHAR_WRK9_SR9;    // Shared Register
	unsigned int SR9_15 : BFW_NETX_XP_SHAR_WRK9_SR9_15; // Sign extension
} XPEC_SR9_BIT_T;

typedef union {
	unsigned int   val;
	XPEC_SR9_BIT_T bf;
} XPEC_SR9_T;

// ---------------------------------------------------------------------
// Register xpec_sr10
// =>  Shared Work Register 10 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_trigger_impulse_length (r/w mode).
//     Shared in xPEC fmmusm mode with sm_buf_statcfg (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK10   0x000000C8U
#define NETX_XP0_SHAR_WRK10 0x1C0400C8U
#define NETX_XP1_SHAR_WRK10 0x1C0480C8U

#define MSK_NETX_XP_SHAR_WRK10_SR10    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK10_SR10    0
#define MSK_NETX_XP_SHAR_WRK10_SR10_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK10_SR10_15 16

enum {
	BFW_NETX_XP_SHAR_WRK10_SR10    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK10_SR10_15 = 16  // [31:16]
};

typedef struct XPEC_SR10_BIT_Ttag {
	unsigned int SR10    : BFW_NETX_XP_SHAR_WRK10_SR10;    // Shared Register
	unsigned int SR10_15 : BFW_NETX_XP_SHAR_WRK10_SR10_15; // Sign extension
} XPEC_SR10_BIT_T;

typedef union {
	unsigned int    val;
	XPEC_SR10_BIT_T bf;
} XPEC_SR10_T;

// ---------------------------------------------------------------------
// Register xpec_sr11
// =>  Shared Work Register 11 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_trigger_0_starttime_ns (r/w mode).
//     Shared in xPEC fmmusm mode with sm_read_event (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK11   0x000000CCU
#define NETX_XP0_SHAR_WRK11 0x1C0400CCU
#define NETX_XP1_SHAR_WRK11 0x1C0480CCU

#define MSK_NETX_XP_SHAR_WRK11_SR11    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK11_SR11    0
#define MSK_NETX_XP_SHAR_WRK11_SR11_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK11_SR11_15 16

enum {
	BFW_NETX_XP_SHAR_WRK11_SR11    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK11_SR11_15 = 16  // [31:16]
};

typedef struct XPEC_SR11_BIT_Ttag {
	unsigned int SR11    : BFW_NETX_XP_SHAR_WRK11_SR11;    // Shared Register
	unsigned int SR11_15 : BFW_NETX_XP_SHAR_WRK11_SR11_15; // Sign extension
} XPEC_SR11_BIT_T;

typedef union {
	unsigned int    val;
	XPEC_SR11_BIT_T bf;
} XPEC_SR11_T;

// ---------------------------------------------------------------------
// Register xpec_sr12
// =>  Shared Work Register 12 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_trigger_1_starttime_ns (r/w mode).
//     Shared in xPEC fmmusm mode with sm_write_event (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK12   0x000000D0U
#define NETX_XP0_SHAR_WRK12 0x1C0400D0U
#define NETX_XP1_SHAR_WRK12 0x1C0480D0U

#define MSK_NETX_XP_SHAR_WRK12_SR12    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK12_SR12    0
#define MSK_NETX_XP_SHAR_WRK12_SR12_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK12_SR12_15 16

enum {
	BFW_NETX_XP_SHAR_WRK12_SR12    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK12_SR12_15 = 16  // [31:16]
};

typedef struct XPEC_SR12_BIT_Ttag {
	unsigned int SR12    : BFW_NETX_XP_SHAR_WRK12_SR12;    // Shared Register
	unsigned int SR12_15 : BFW_NETX_XP_SHAR_WRK12_SR12_15; // Sign extension
} XPEC_SR12_BIT_T;

typedef union {
	unsigned int    val;
	XPEC_SR12_BIT_T bf;
} XPEC_SR12_T;

// ---------------------------------------------------------------------
// Register xpec_sr13
// =>  Shared Work Register 13 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_trigger_0_cyc_time (r/w mode).
//     Shared in xPEC fmmusm mode with sm_first_byte_addressed (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK13   0x000000D4U
#define NETX_XP0_SHAR_WRK13 0x1C0400D4U
#define NETX_XP1_SHAR_WRK13 0x1C0480D4U

#define MSK_NETX_XP_SHAR_WRK13_SR13    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK13_SR13    0
#define MSK_NETX_XP_SHAR_WRK13_SR13_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK13_SR13_15 16

enum {
	BFW_NETX_XP_SHAR_WRK13_SR13    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK13_SR13_15 = 16  // [31:16]
};

typedef struct XPEC_SR13_BIT_Ttag {
	unsigned int SR13    : BFW_NETX_XP_SHAR_WRK13_SR13;    // Shared Register
	unsigned int SR13_15 : BFW_NETX_XP_SHAR_WRK13_SR13_15; // Sign extension
} XPEC_SR13_BIT_T;

typedef union {
	unsigned int    val;
	XPEC_SR13_BIT_T bf;
} XPEC_SR13_T;

// ---------------------------------------------------------------------
// Register xpec_sr14
// =>  Shared Work Register 14 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_trigger_1_cyc_time (r/w mode).
//     Shared in xPEC fmmusm mode with sm_last_byte_addressed (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK14   0x000000D8U
#define NETX_XP0_SHAR_WRK14 0x1C0400D8U
#define NETX_XP1_SHAR_WRK14 0x1C0480D8U

#define MSK_NETX_XP_SHAR_WRK14_SR14    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK14_SR14    0
#define MSK_NETX_XP_SHAR_WRK14_SR14_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK14_SR14_15 16

enum {
	BFW_NETX_XP_SHAR_WRK14_SR14    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK14_SR14_15 = 16  // [31:16]
};

typedef struct XPEC_SR14_BIT_Ttag {
	unsigned int SR14    : BFW_NETX_XP_SHAR_WRK14_SR14;    // Shared Register -- in debug mode (statcfg[14]) read 32 Bit xpec_debug_code
	unsigned int SR14_15 : BFW_NETX_XP_SHAR_WRK14_SR14_15; // Sign extension
} XPEC_SR14_BIT_T;

typedef union {
	unsigned int    val;
	XPEC_SR14_BIT_T bf;
} XPEC_SR14_T;

// ---------------------------------------------------------------------
// Register xpec_sr15
// =>  Shared Work Register 15 accessed by all xPECs and all xMACs.
//     Shared in xPEC trigger_sample mode with adr_sample_mode (r/w mode).
//     Shared in xPEC fmmusm mode with sm_served (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_WRK15   0x000000DCU
#define NETX_XP0_SHAR_WRK15 0x1C0400DCU
#define NETX_XP1_SHAR_WRK15 0x1C0480DCU

#define MSK_NETX_XP_SHAR_WRK15_SR15    0x0000ffffU // [15:0]
#define SRT_NETX_XP_SHAR_WRK15_SR15    0
#define MSK_NETX_XP_SHAR_WRK15_SR15_15 0xffff0000U // [31:16]
#define SRT_NETX_XP_SHAR_WRK15_SR15_15 16

enum {
	BFW_NETX_XP_SHAR_WRK15_SR15    = 16, // [15:0]
	BFW_NETX_XP_SHAR_WRK15_SR15_15 = 16  // [31:16]
};

typedef struct XPEC_SR15_BIT_Ttag {
	unsigned int SR15    : BFW_NETX_XP_SHAR_WRK15_SR15;    // Shared Register -- in debug mode (statcfg[14]) read 11 Bit xpec_debug_pc
	unsigned int SR15_15 : BFW_NETX_XP_SHAR_WRK15_SR15_15; // Sign extension
} XPEC_SR15_BIT_T;

typedef union {
	unsigned int    val;
	XPEC_SR15_BIT_T bf;
} XPEC_SR15_T;

// ---------------------------------------------------------------------
// Register statcfg0
// =>  xMAC0 Shared Config/Status Register
//     Shared in xPEC trigger_sample mode with adr_sample_0_pos_systime_ns (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_XM_STAT_CFG0   0x000000E0U
#define NETX_XP0_SHAR_XM_STAT_CFG0 0x1C0400E0U
#define NETX_XP1_SHAR_XM_STAT_CFG0 0x1C0480E0U

#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_out         0x00000001U // [0]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_out         0
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_oe          0x00000002U // [1]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_oe          1
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_out         0x00000004U // [2]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_out         2
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_oe          0x00000008U // [3]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_oe          3
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_out         0x00000010U // [4]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_out         4
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_oe          0x00000020U // [5]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_oe          5
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_out         0x00000040U // [6]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_out         6
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_oe          0x00000080U // [7]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_oe          7
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_rx_shift_lr       0x00000100U // [8]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_rx_shift_lr       8
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_tx_shift_lr       0x00000200U // [9]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_tx_shift_lr       9
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_reset_rx_fifo     0x00000400U // [10]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_reset_rx_fifo     10
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_reset_tx_fifo     0x00000800U // [11]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_reset_tx_fifo     11
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_out         0x00001000U // [12]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_out         12
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_oe          0x00002000U // [13]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_oe          13
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_out         0x00004000U // [14]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_out         14
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_oe          0x00008000U // [15]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_oe          15
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_in          0x00010000U // [16]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_in          16
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_in          0x00020000U // [17]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_in          17
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_rx_rdy            0x00040000U // [18]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_rx_rdy            18
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_rx_ovf            0x00080000U // [19]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_rx_ovf            19
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_tx_nxt            0x00100000U // [20]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_tx_nxt            20
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_tx_ufl            0x00200000U // [21]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_tx_ufl            21
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_utx_empty         0x00400000U // [22]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_utx_empty         22
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_brec              0x00800000U // [23]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_brec              23
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_btran             0x01000000U // [24]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_btran             24
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_stat_rpu          0x02000000U // [25]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_stat_rpu          25
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_stat_tpu          0x04000000U // [26]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_stat_tpu          26
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_phy_led_en        0x08000000U // [27]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_phy_led_en        27
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_in_phy_led0 0x10000000U // [28]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_in_phy_led0 28
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_in_phy_led1 0x20000000U // [29]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_in_phy_led1 29
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_in_phy_led2 0x40000000U // [30]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_in_phy_led2 30
#define MSK_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_in_phy_led3 0x80000000U // [31]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_in_phy_led3 31

enum {
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_out         = 1, // [0]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_oe          = 1, // [1]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_out         = 1, // [2]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_oe          = 1, // [3]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_out         = 1, // [4]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_oe          = 1, // [5]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_out         = 1, // [6]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_oe          = 1, // [7]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_rx_shift_lr       = 1, // [8]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_tx_shift_lr       = 1, // [9]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_reset_rx_fifo     = 1, // [10]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_reset_tx_fifo     = 1, // [11]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_out         = 1, // [12]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_oe          = 1, // [13]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_out         = 1, // [14]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_oe          = 1, // [15]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_in          = 1, // [16]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_in          = 1, // [17]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_rx_rdy            = 1, // [18]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_rx_ovf            = 1, // [19]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_tx_nxt            = 1, // [20]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_tx_ufl            = 1, // [21]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_utx_empty         = 1, // [22]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_brec              = 1, // [23]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_btran             = 1, // [24]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_stat_rpu          = 1, // [25]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_stat_tpu          = 1, // [26]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_phy_led_en        = 1, // [27]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_in_phy_led0 = 1, // [28]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_in_phy_led1 = 1, // [29]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_in_phy_led2 = 1, // [30]
	BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_in_phy_led3 = 1  // [31]
};

typedef struct STATCFG0_BIT_Ttag {
	unsigned int gpio2_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_out;         // General Purpose IO 2 output
	unsigned int gpio2_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_oe;          // General Purpose IO 2 output enable
	unsigned int gpio3_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_out;         // General Purpose IO 3 output
	unsigned int gpio3_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_oe;          // General Purpose IO 3 output enable
	unsigned int gpio4_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_out;         // General Purpose IO 4 output
	unsigned int gpio4_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_oe;          // General Purpose IO 4 output enable
	unsigned int gpio5_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_out;         // General Purpose IO 5 output
	unsigned int gpio5_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_oe;          // General Purpose IO 5 output enable
	unsigned int rx_shift_lr       : BFW_NETX_XP_SHAR_XM_STAT_CFG0_rx_shift_lr;       // 1: SBU reads incoming bits to position 0 of register rx and shifts rx left,
	                                                        // 0: SBU reads incoming bits to position 15 of register rx and shifts rx right
	unsigned int tx_shift_lr       : BFW_NETX_XP_SHAR_XM_STAT_CFG0_tx_shift_lr;       // 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left,
	                                                        // 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right
	unsigned int reset_rx_fifo     : BFW_NETX_XP_SHAR_XM_STAT_CFG0_reset_rx_fifo;     // reset URX_FIFO and rx_ovf bit inside status_shared register
	unsigned int reset_tx_fifo     : BFW_NETX_XP_SHAR_XM_STAT_CFG0_reset_tx_fifo;     // reset UTX_FIFO and tx_ufl bit inside status_shared register
	unsigned int gpio0_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_out;         // General Purpose IO 0 output
	unsigned int gpio0_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_oe;          // General Purpose IO 0 output enable
	unsigned int gpio1_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_out;         // General Purpose IO 1 output
	unsigned int gpio1_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_oe;          // General Purpose IO 1 output enable
	unsigned int gpio0_in          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio0_in;          // value at external gpio pin
	unsigned int gpio1_in          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio1_in;          // value at external gpio pin
	unsigned int rx_rdy            : BFW_NETX_XP_SHAR_XM_STAT_CFG0_rx_rdy;            // received bytes are valid at output of URX_FIFO
	unsigned int rx_ovf            : BFW_NETX_XP_SHAR_XM_STAT_CFG0_rx_ovf;            // receive overflow (too much data in URX_FIFO)
	unsigned int tx_nxt            : BFW_NETX_XP_SHAR_XM_STAT_CFG0_tx_nxt;            // put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty
	unsigned int tx_ufl            : BFW_NETX_XP_SHAR_XM_STAT_CFG0_tx_ufl;            // transmit underflow (not enough data in UTX_FIFO)
	unsigned int utx_empty         : BFW_NETX_XP_SHAR_XM_STAT_CFG0_utx_empty;         // UTX_FIFO is empty
	unsigned int brec              : BFW_NETX_XP_SHAR_XM_STAT_CFG0_brec;              // bit_received (active for 1 cc)
	unsigned int btran             : BFW_NETX_XP_SHAR_XM_STAT_CFG0_btran;             // bit_transmitted (active for 1 cc)
	unsigned int stat_rpu          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_stat_rpu;          // set and reset by RPU command bits
	unsigned int stat_tpu          : BFW_NETX_XP_SHAR_XM_STAT_CFG0_stat_tpu;          // set and reset by TPU command bits
	unsigned int phy_led_en        : BFW_NETX_XP_SHAR_XM_STAT_CFG0_phy_led_en;        // -> read only version of xmac_config_sbu-phy_led_en (visible to xPECs)
	unsigned int gpio2_in_phy_led0 : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio2_in_phy_led0; // IF phy_led_en:
	                                                        // 1: gpio2_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED0, usually link_status
	unsigned int gpio3_in_phy_led1 : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio3_in_phy_led1; // IF phy_led_en:
	                                                        // 1: gpio3_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED1, usually activity
	unsigned int gpio4_in_phy_led2 : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio4_in_phy_led2; // IF phy_led_en:
	                                                        // 1: gpio4_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED2, usually speed100
	unsigned int gpio5_in_phy_led3 : BFW_NETX_XP_SHAR_XM_STAT_CFG0_gpio5_in_phy_led3; // IF phy_led_en:
	                                                        // 1: gpio5_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED3, usually full_duplex
} STATCFG0_BIT_T;

typedef union {
	unsigned int   val;
	STATCFG0_BIT_T bf;
} STATCFG0_T;

// ---------------------------------------------------------------------
// Register statcfg1
// =>  xMAC1 Shared Config/Status Register
//     Shared in xPEC trigger_sample mode with adr_sample_0_neg_systime_ns (r/w mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_XM_STAT_CFG1   0x000000E4U
#define NETX_XP0_SHAR_XM_STAT_CFG1 0x1C0400E4U
#define NETX_XP1_SHAR_XM_STAT_CFG1 0x1C0480E4U

#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_out         0x00000001U // [0]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_out         0
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_oe          0x00000002U // [1]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_oe          1
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_out         0x00000004U // [2]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_out         2
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_oe          0x00000008U // [3]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_oe          3
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_out         0x00000010U // [4]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_out         4
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_oe          0x00000020U // [5]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_oe          5
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_out         0x00000040U // [6]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_out         6
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_oe          0x00000080U // [7]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_oe          7
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_rx_shift_lr       0x00000100U // [8]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_rx_shift_lr       8
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_tx_shift_lr       0x00000200U // [9]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_tx_shift_lr       9
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_reset_rx_fifo     0x00000400U // [10]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_reset_rx_fifo     10
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_reset_tx_fifo     0x00000800U // [11]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_reset_tx_fifo     11
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_out         0x00001000U // [12]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_out         12
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_oe          0x00002000U // [13]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_oe          13
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_out         0x00004000U // [14]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_out         14
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_oe          0x00008000U // [15]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_oe          15
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_in          0x00010000U // [16]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_in          16
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_in          0x00020000U // [17]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_in          17
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_rx_rdy            0x00040000U // [18]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_rx_rdy            18
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_rx_ovf            0x00080000U // [19]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_rx_ovf            19
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_tx_nxt            0x00100000U // [20]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_tx_nxt            20
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_tx_ufl            0x00200000U // [21]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_tx_ufl            21
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_utx_empty         0x00400000U // [22]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_utx_empty         22
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_brec              0x00800000U // [23]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_brec              23
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_btran             0x01000000U // [24]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_btran             24
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_stat_rpu          0x02000000U // [25]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_stat_rpu          25
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_stat_tpu          0x04000000U // [26]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_stat_tpu          26
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_phy_led_en        0x08000000U // [27]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_phy_led_en        27
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_in_phy_led0 0x10000000U // [28]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_in_phy_led0 28
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_in_phy_led1 0x20000000U // [29]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_in_phy_led1 29
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_in_phy_led2 0x40000000U // [30]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_in_phy_led2 30
#define MSK_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_in_phy_led3 0x80000000U // [31]
#define SRT_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_in_phy_led3 31

enum {
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_out         = 1, // [0]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_oe          = 1, // [1]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_out         = 1, // [2]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_oe          = 1, // [3]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_out         = 1, // [4]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_oe          = 1, // [5]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_out         = 1, // [6]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_oe          = 1, // [7]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_rx_shift_lr       = 1, // [8]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_tx_shift_lr       = 1, // [9]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_reset_rx_fifo     = 1, // [10]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_reset_tx_fifo     = 1, // [11]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_out         = 1, // [12]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_oe          = 1, // [13]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_out         = 1, // [14]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_oe          = 1, // [15]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_in          = 1, // [16]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_in          = 1, // [17]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_rx_rdy            = 1, // [18]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_rx_ovf            = 1, // [19]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_tx_nxt            = 1, // [20]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_tx_ufl            = 1, // [21]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_utx_empty         = 1, // [22]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_brec              = 1, // [23]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_btran             = 1, // [24]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_stat_rpu          = 1, // [25]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_stat_tpu          = 1, // [26]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_phy_led_en        = 1, // [27]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_in_phy_led0 = 1, // [28]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_in_phy_led1 = 1, // [29]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_in_phy_led2 = 1, // [30]
	BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_in_phy_led3 = 1  // [31]
};

typedef struct STATCFG1_BIT_Ttag {
	unsigned int gpio2_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_out;         // General Purpose IO 2 output
	unsigned int gpio2_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_oe;          // General Purpose IO 2 output enable
	unsigned int gpio3_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_out;         // General Purpose IO 3 output
	unsigned int gpio3_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_oe;          // General Purpose IO 3 output enable
	unsigned int gpio4_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_out;         // General Purpose IO 4 output
	unsigned int gpio4_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_oe;          // General Purpose IO 4 output enable
	unsigned int gpio5_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_out;         // General Purpose IO 5 output
	unsigned int gpio5_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_oe;          // General Purpose IO 5 output enable
	unsigned int rx_shift_lr       : BFW_NETX_XP_SHAR_XM_STAT_CFG1_rx_shift_lr;       // 1: SBU reads incoming bits to position 0 of register rx and shifts rx left,
	                                                        // 0: SBU reads incoming bits to position 15 of register rx and shifts rx right
	unsigned int tx_shift_lr       : BFW_NETX_XP_SHAR_XM_STAT_CFG1_tx_shift_lr;       // 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left,
	                                                        // 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right
	unsigned int reset_rx_fifo     : BFW_NETX_XP_SHAR_XM_STAT_CFG1_reset_rx_fifo;     // reset URX_FIFO and rx_ovf bit inside status_shared register
	unsigned int reset_tx_fifo     : BFW_NETX_XP_SHAR_XM_STAT_CFG1_reset_tx_fifo;     // reset UTX_FIFO and tx_ufl bit inside status_shared register
	unsigned int gpio0_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_out;         // General Purpose IO 0 output
	unsigned int gpio0_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_oe;          // General Purpose IO 0 output enable
	unsigned int gpio1_out         : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_out;         // General Purpose IO 1 output
	unsigned int gpio1_oe          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_oe;          // General Purpose IO 1 output enable
	unsigned int gpio0_in          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio0_in;          // value at external gpio pin
	unsigned int gpio1_in          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio1_in;          // value at external gpio pin
	unsigned int rx_rdy            : BFW_NETX_XP_SHAR_XM_STAT_CFG1_rx_rdy;            // received bytes are valid at output of URX_FIFO
	unsigned int rx_ovf            : BFW_NETX_XP_SHAR_XM_STAT_CFG1_rx_ovf;            // receive overflow (too much data in URX_FIFO)
	unsigned int tx_nxt            : BFW_NETX_XP_SHAR_XM_STAT_CFG1_tx_nxt;            // put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty
	unsigned int tx_ufl            : BFW_NETX_XP_SHAR_XM_STAT_CFG1_tx_ufl;            // transmit underflow (not enough data in UTX_FIFO)
	unsigned int utx_empty         : BFW_NETX_XP_SHAR_XM_STAT_CFG1_utx_empty;         // UTX_FIFO is empty
	unsigned int brec              : BFW_NETX_XP_SHAR_XM_STAT_CFG1_brec;              // bit_received (active for 1 cc)
	unsigned int btran             : BFW_NETX_XP_SHAR_XM_STAT_CFG1_btran;             // bit_transmitted (active for 1 cc)
	unsigned int stat_rpu          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_stat_rpu;          // set and reset by RPU command bits
	unsigned int stat_tpu          : BFW_NETX_XP_SHAR_XM_STAT_CFG1_stat_tpu;          // set and reset by TPU command bits
	unsigned int phy_led_en        : BFW_NETX_XP_SHAR_XM_STAT_CFG1_phy_led_en;        // -> read only version of xmac_config_sbu-phy_led_en (visible to xPECs)
	unsigned int gpio2_in_phy_led0 : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio2_in_phy_led0; // IF phy_led_en:
	                                                        // 1: gpio2_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED0, usually link_status
	unsigned int gpio3_in_phy_led1 : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio3_in_phy_led1; // IF phy_led_en:
	                                                        // 1: gpio3_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED1, usually activity
	unsigned int gpio4_in_phy_led2 : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio4_in_phy_led2; // IF phy_led_en:
	                                                        // 1: gpio4_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED2, usually speed100
	unsigned int gpio5_in_phy_led3 : BFW_NETX_XP_SHAR_XM_STAT_CFG1_gpio5_in_phy_led3; // IF phy_led_en:
	                                                        // 1: gpio5_in # value at external gpio pin
	                                                        // 0: Internal Phy0 LED3, usually full_duplex
} STATCFG1_BIT_T;

typedef union {
	unsigned int   val;
	STATCFG1_BIT_T bf;
} STATCFG1_T;

// ---------------------------------------------------------------------
// Register statcfg2
// =>  reserved address in net50
//     Shared in xPEC trigger_sample mode with adr_sample_1_pos_systime_ns (r/w mode).
//     Shared in xPEC fmmusm mode with fmmu_read_bit_rol_pos (r mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_XM_STAT_CFG2   0x000000E8U
#define NETX_XP0_SHAR_XM_STAT_CFG2 0x1C0400E8U
#define NETX_XP1_SHAR_XM_STAT_CFG2 0x1C0480E8U

// ---------------------------------------------------------------------
// Register statcfg3
// =>  reserved address in net50
//     Shared in xPEC trigger_sample mode with adr_sample_1_neg_systime_ns (r/w mode).
//     Shared in xPEC fmmusm mode with fmmu_write_bit_rol_pos (r mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_SHAR_XM_STAT_CFG3   0x000000ECU
#define NETX_XP0_SHAR_XM_STAT_CFG3 0x1C0400ECU
#define NETX_XP1_SHAR_XM_STAT_CFG3 0x1C0480ECU

// ---------------------------------------------------------------------
// Register urtx0
// =>  xMAC0 URX Shared Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_URTX0   0x000000F0U
#define NETX_XP0_URTX0 0x1C0400F0U
#define NETX_XP1_URTX0 0x1C0480F0U

#define MSK_NETX_XP_URTX0_urtx_xmac0 0x0000ffffU // [15:0]
#define SRT_NETX_XP_URTX0_urtx_xmac0 0

enum {
	BFW_NETX_XP_URTX0_urtx_xmac0 = 16, // [15:0]
	BFW_NETX_XP_URTX0_reserved1  = 16  // [31:16]
};

typedef struct URTX0_BIT_Ttag {
	unsigned int urtx_xmac0 : BFW_NETX_XP_URTX0_urtx_xmac0; // read access:  Lastly received bits (output of URX_FIFO)
	                                                        // write access: Bits to be transmitted next (input of UTX_FIFO)
	unsigned int reserved1  : BFW_NETX_XP_URTX0_reserved1;  // reserved
} URTX0_BIT_T;

typedef union {
	unsigned int val;
	URTX0_BIT_T  bf;
} URTX0_T;

// ---------------------------------------------------------------------
// Register urtx1
// =>  xMAC1 URX Shared Register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_URTX1   0x000000F4U
#define NETX_XP0_URTX1 0x1C0400F4U
#define NETX_XP1_URTX1 0x1C0480F4U

#define MSK_NETX_XP_URTX1_urtx_xmac1 0x0000ffffU // [15:0]
#define SRT_NETX_XP_URTX1_urtx_xmac1 0

enum {
	BFW_NETX_XP_URTX1_urtx_xmac1 = 16, // [15:0]
	BFW_NETX_XP_URTX1_reserved1  = 16  // [31:16]
};

typedef struct URTX1_BIT_Ttag {
	unsigned int urtx_xmac1 : BFW_NETX_XP_URTX1_urtx_xmac1; // read access:  Lastly received bits (output of URX_FIFO)
	                                                        // write access: Bits to be transmitted next (input of UTX_FIFO)
	unsigned int reserved1  : BFW_NETX_XP_URTX1_reserved1;  // reserved
} URTX1_BIT_T;

typedef union {
	unsigned int val;
	URTX1_BIT_T  bf;
} URTX1_T;

// ---------------------------------------------------------------------
// Register urtx2
// =>  reserved address in net50
//     Shared in xPEC trigger_sample mode with adr_trigger_sample_config (r/w mode).
//     Shared in xPEC fmmusm mode with fmmu_read_bit_mask (r mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_URTX2   0x000000F8U
#define NETX_XP0_URTX2 0x1C0400F8U
#define NETX_XP1_URTX2 0x1C0480F8U

// ---------------------------------------------------------------------
// Register urtx3
// =>  reserved address in net50
//     Shared in xPEC trigger_sample mode with adr_trigger_sample_status (r/w mode).
//     Shared in xPEC fmmusm mode with fmmu_write_bit_mask (r mode).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_URTX3   0x000000FCU
#define NETX_XP0_URTX3 0x1C0400FCU
#define NETX_XP1_URTX3 0x1C0480FCU

// ---------------------------------------------------------------------
// Register xpu_hold_pc
// =>  xPEC hold_pc register
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XP_HOLD_PC   0x00000100U
#define NETX_XP0_HOLD_PC 0x1C040100U
#define NETX_XP1_HOLD_PC 0x1C048100U

#define MSK_NETX_XP_HOLD_PC_hold 0x00000001U // [0]
#define SRT_NETX_XP_HOLD_PC_hold 0

enum {
	BFW_NETX_XP_HOLD_PC_hold      = 1,  // [0]
	BFW_NETX_XP_HOLD_PC_reserved1 = 31  // [31:1]
};

typedef struct XPU_HOLD_PC_BIT_Ttag {
	unsigned int hold      : BFW_NETX_XP_HOLD_PC_hold;      // 0: start XPU, 1: hold XPU
	                                                        // only accessible by the ARM
	unsigned int reserved1 : BFW_NETX_XP_HOLD_PC_reserved1; // reserved
} XPU_HOLD_PC_BIT_T;

typedef union {
	unsigned int      val;
	XPU_HOLD_PC_BIT_T bf;
} XPU_HOLD_PC_T;

// ---------------------------------------------------------------------
// Register pram_start
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_XP_PRAM_START   0x00004000U
#define NETX_XP0_PRAM_START 0x1C044000U
#define NETX_XP1_PRAM_START 0x1C04C000U

// ---------------------------------------------------------------------
// Register dram_start
// => 
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_XP_DRAM_START   0x00006000U
#define NETX_XP0_DRAM_START 0x1C046000U
#define NETX_XP1_DRAM_START 0x1C04E000U


// =====================================================================
//
// Area of xmac0, xmac1
//
// =====================================================================

#define NETX_XM0_BASE	0x1C060000U
#define NETX_XM1_BASE	0x1C061000U

// ---------------------------------------------------------------------
// Register xmac_rpu_program_start
// =>  xMAC RPU program-RAM start address.
//     The Program-RAM is not addressable for xMAC RPU and TPU !
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_XM_RPU_PROG_START   0x00000000U
#define NETX_XM0_RPU_PROG_START 0x1C060000U
#define NETX_XM1_RPU_PROG_START 0x1C061000U

// ---------------------------------------------------------------------
// Register xmac_rpu_program_end
// =>  xMAC RPU program-RAM end address.
//     This value is not used by design flow, only for documentation
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_XM_RPU_PROG_END   0x000003FFU
#define NETX_XM0_RPU_PROG_END 0x1C0603FFU
#define NETX_XM1_RPU_PROG_END 0x1C0613FFU

// ---------------------------------------------------------------------
// Register xmac_tpu_program_start
// =>  xMAC TPU program-RAM start address.
//     The Program-RAM is not addressable for xMAC RPU and TPU !
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_XM_TPU_PROG_START   0x00000400U
#define NETX_XM0_TPU_PROG_START 0x1C060400U
#define NETX_XM1_TPU_PROG_START 0x1C061400U

// ---------------------------------------------------------------------
// Register xmac_tpu_program_end
// =>  xMAC TPU program-RAM end address.
//     This value is not used by design flow, only for documentation
// => Mode: 
// ---------------------------------------------------------------------

#define REL_NETX_XM_TPU_PROG_END   0x000007FFU
#define NETX_XM0_TPU_PROG_END 0x1C0607FFU
#define NETX_XM1_TPU_PROG_END 0x1C0617FFU

// ---------------------------------------------------------------------
// Register xmac_sr0
// =>  Shared Work Register 0 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK0   0x00000800U
#define NETX_XM0_SHAR_WRK0 0x1C060800U
#define NETX_XM1_SHAR_WRK0 0x1C061800U

#define MSK_NETX_XM_SHAR_WRK0_SR0 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK0_SR0 0

enum {
	BFW_NETX_XM_SHAR_WRK0_SR0       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK0_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR0_BIT_Ttag {
	unsigned int SR0       : BFW_NETX_XM_SHAR_WRK0_SR0;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK0_reserved1; // reserved
} XMAC_SR0_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR0_BIT_T bf;
} XMAC_SR0_T;

// ---------------------------------------------------------------------
// Register xmac_sr1
// =>  Shared Work Register 1 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK1   0x00000804U
#define NETX_XM0_SHAR_WRK1 0x1C060804U
#define NETX_XM1_SHAR_WRK1 0x1C061804U

#define MSK_NETX_XM_SHAR_WRK1_SR1 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK1_SR1 0

enum {
	BFW_NETX_XM_SHAR_WRK1_SR1       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK1_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR1_BIT_Ttag {
	unsigned int SR1       : BFW_NETX_XM_SHAR_WRK1_SR1;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK1_reserved1; // reserved
} XMAC_SR1_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR1_BIT_T bf;
} XMAC_SR1_T;

// ---------------------------------------------------------------------
// Register xmac_sr2
// =>  Shared Work Register 2 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK2   0x00000808U
#define NETX_XM0_SHAR_WRK2 0x1C060808U
#define NETX_XM1_SHAR_WRK2 0x1C061808U

#define MSK_NETX_XM_SHAR_WRK2_SR2 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK2_SR2 0

enum {
	BFW_NETX_XM_SHAR_WRK2_SR2       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK2_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR2_BIT_Ttag {
	unsigned int SR2       : BFW_NETX_XM_SHAR_WRK2_SR2;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK2_reserved1; // reserved
} XMAC_SR2_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR2_BIT_T bf;
} XMAC_SR2_T;

// ---------------------------------------------------------------------
// Register xmac_sr3
// =>  Shared Work Register 3 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK3   0x0000080CU
#define NETX_XM0_SHAR_WRK3 0x1C06080CU
#define NETX_XM1_SHAR_WRK3 0x1C06180CU

#define MSK_NETX_XM_SHAR_WRK3_SR3 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK3_SR3 0

enum {
	BFW_NETX_XM_SHAR_WRK3_SR3       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK3_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR3_BIT_Ttag {
	unsigned int SR3       : BFW_NETX_XM_SHAR_WRK3_SR3;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK3_reserved1; // reserved
} XMAC_SR3_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR3_BIT_T bf;
} XMAC_SR3_T;

// ---------------------------------------------------------------------
// Register xmac_sr4
// =>  Shared Work Register 4 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK4   0x00000810U
#define NETX_XM0_SHAR_WRK4 0x1C060810U
#define NETX_XM1_SHAR_WRK4 0x1C061810U

#define MSK_NETX_XM_SHAR_WRK4_SR4 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK4_SR4 0

enum {
	BFW_NETX_XM_SHAR_WRK4_SR4       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK4_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR4_BIT_Ttag {
	unsigned int SR4       : BFW_NETX_XM_SHAR_WRK4_SR4;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK4_reserved1; // reserved
} XMAC_SR4_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR4_BIT_T bf;
} XMAC_SR4_T;

// ---------------------------------------------------------------------
// Register xmac_sr5
// =>  Shared Work Register 5 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK5   0x00000814U
#define NETX_XM0_SHAR_WRK5 0x1C060814U
#define NETX_XM1_SHAR_WRK5 0x1C061814U

#define MSK_NETX_XM_SHAR_WRK5_SR5 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK5_SR5 0

enum {
	BFW_NETX_XM_SHAR_WRK5_SR5       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK5_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR5_BIT_Ttag {
	unsigned int SR5       : BFW_NETX_XM_SHAR_WRK5_SR5;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK5_reserved1; // reserved
} XMAC_SR5_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR5_BIT_T bf;
} XMAC_SR5_T;

// ---------------------------------------------------------------------
// Register xmac_sr6
// =>  Shared Work Register 6 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK6   0x00000818U
#define NETX_XM0_SHAR_WRK6 0x1C060818U
#define NETX_XM1_SHAR_WRK6 0x1C061818U

#define MSK_NETX_XM_SHAR_WRK6_SR6 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK6_SR6 0

enum {
	BFW_NETX_XM_SHAR_WRK6_SR6       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK6_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR6_BIT_Ttag {
	unsigned int SR6       : BFW_NETX_XM_SHAR_WRK6_SR6;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK6_reserved1; // reserved
} XMAC_SR6_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR6_BIT_T bf;
} XMAC_SR6_T;

// ---------------------------------------------------------------------
// Register xmac_sr7
// =>  Shared Work Register 7 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK7   0x0000081CU
#define NETX_XM0_SHAR_WRK7 0x1C06081CU
#define NETX_XM1_SHAR_WRK7 0x1C06181CU

#define MSK_NETX_XM_SHAR_WRK7_SR7 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK7_SR7 0

enum {
	BFW_NETX_XM_SHAR_WRK7_SR7       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK7_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR7_BIT_Ttag {
	unsigned int SR7       : BFW_NETX_XM_SHAR_WRK7_SR7;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK7_reserved1; // reserved
} XMAC_SR7_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR7_BIT_T bf;
} XMAC_SR7_T;

// ---------------------------------------------------------------------
// Register xmac_sr8
// =>  Shared Work Register 8 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK8   0x00000820U
#define NETX_XM0_SHAR_WRK8 0x1C060820U
#define NETX_XM1_SHAR_WRK8 0x1C061820U

#define MSK_NETX_XM_SHAR_WRK8_SR8 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK8_SR8 0

enum {
	BFW_NETX_XM_SHAR_WRK8_SR8       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK8_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR8_BIT_Ttag {
	unsigned int SR8       : BFW_NETX_XM_SHAR_WRK8_SR8;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK8_reserved1; // reserved
} XMAC_SR8_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR8_BIT_T bf;
} XMAC_SR8_T;

// ---------------------------------------------------------------------
// Register xmac_sr9
// =>  Shared Work Register 9 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK9   0x00000824U
#define NETX_XM0_SHAR_WRK9 0x1C060824U
#define NETX_XM1_SHAR_WRK9 0x1C061824U

#define MSK_NETX_XM_SHAR_WRK9_SR9 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK9_SR9 0

enum {
	BFW_NETX_XM_SHAR_WRK9_SR9       = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK9_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR9_BIT_Ttag {
	unsigned int SR9       : BFW_NETX_XM_SHAR_WRK9_SR9;       // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK9_reserved1; // reserved
} XMAC_SR9_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_SR9_BIT_T bf;
} XMAC_SR9_T;

// ---------------------------------------------------------------------
// Register xmac_sr10
// =>  Shared Work Register 10 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK10   0x00000828U
#define NETX_XM0_SHAR_WRK10 0x1C060828U
#define NETX_XM1_SHAR_WRK10 0x1C061828U

#define MSK_NETX_XM_SHAR_WRK10_SR10 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK10_SR10 0

enum {
	BFW_NETX_XM_SHAR_WRK10_SR10      = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK10_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR10_BIT_Ttag {
	unsigned int SR10      : BFW_NETX_XM_SHAR_WRK10_SR10;      // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK10_reserved1; // reserved
} XMAC_SR10_BIT_T;

typedef union {
	unsigned int    val;
	XMAC_SR10_BIT_T bf;
} XMAC_SR10_T;

// ---------------------------------------------------------------------
// Register xmac_sr11
// =>  Shared Work Register 11 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK11   0x0000082CU
#define NETX_XM0_SHAR_WRK11 0x1C06082CU
#define NETX_XM1_SHAR_WRK11 0x1C06182CU

#define MSK_NETX_XM_SHAR_WRK11_SR11 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK11_SR11 0

enum {
	BFW_NETX_XM_SHAR_WRK11_SR11      = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK11_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR11_BIT_Ttag {
	unsigned int SR11      : BFW_NETX_XM_SHAR_WRK11_SR11;      // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK11_reserved1; // reserved
} XMAC_SR11_BIT_T;

typedef union {
	unsigned int    val;
	XMAC_SR11_BIT_T bf;
} XMAC_SR11_T;

// ---------------------------------------------------------------------
// Register xmac_sr12
// =>  Shared Work Register 12 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK12   0x00000830U
#define NETX_XM0_SHAR_WRK12 0x1C060830U
#define NETX_XM1_SHAR_WRK12 0x1C061830U

#define MSK_NETX_XM_SHAR_WRK12_SR12 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK12_SR12 0

enum {
	BFW_NETX_XM_SHAR_WRK12_SR12      = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK12_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR12_BIT_Ttag {
	unsigned int SR12      : BFW_NETX_XM_SHAR_WRK12_SR12;      // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK12_reserved1; // reserved
} XMAC_SR12_BIT_T;

typedef union {
	unsigned int    val;
	XMAC_SR12_BIT_T bf;
} XMAC_SR12_T;

// ---------------------------------------------------------------------
// Register xmac_sr13
// =>  Shared Work Register 13 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK13   0x00000834U
#define NETX_XM0_SHAR_WRK13 0x1C060834U
#define NETX_XM1_SHAR_WRK13 0x1C061834U

#define MSK_NETX_XM_SHAR_WRK13_SR13 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK13_SR13 0

enum {
	BFW_NETX_XM_SHAR_WRK13_SR13      = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK13_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR13_BIT_Ttag {
	unsigned int SR13      : BFW_NETX_XM_SHAR_WRK13_SR13;      // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK13_reserved1; // reserved
} XMAC_SR13_BIT_T;

typedef union {
	unsigned int    val;
	XMAC_SR13_BIT_T bf;
} XMAC_SR13_T;

// ---------------------------------------------------------------------
// Register xmac_sr14
// =>  Shared Work Register 14 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK14   0x00000838U
#define NETX_XM0_SHAR_WRK14 0x1C060838U
#define NETX_XM1_SHAR_WRK14 0x1C061838U

#define MSK_NETX_XM_SHAR_WRK14_SR14 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK14_SR14 0

enum {
	BFW_NETX_XM_SHAR_WRK14_SR14      = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK14_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR14_BIT_Ttag {
	unsigned int SR14      : BFW_NETX_XM_SHAR_WRK14_SR14;      // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK14_reserved1; // reserved
} XMAC_SR14_BIT_T;

typedef union {
	unsigned int    val;
	XMAC_SR14_BIT_T bf;
} XMAC_SR14_T;

// ---------------------------------------------------------------------
// Register xmac_sr15
// =>  Shared Work Register 15 accessible by all xMACs and xPECs
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_SHAR_WRK15   0x0000083CU
#define NETX_XM0_SHAR_WRK15 0x1C06083CU
#define NETX_XM1_SHAR_WRK15 0x1C06183CU

#define MSK_NETX_XM_SHAR_WRK15_SR15 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SHAR_WRK15_SR15 0

enum {
	BFW_NETX_XM_SHAR_WRK15_SR15      = 16, // [15:0]
	BFW_NETX_XM_SHAR_WRK15_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SR15_BIT_Ttag {
	unsigned int SR15      : BFW_NETX_XM_SHAR_WRK15_SR15;      // Shared Register
	unsigned int reserved1 : BFW_NETX_XM_SHAR_WRK15_reserved1; // reserved
} XMAC_SR15_BIT_T;

typedef union {
	unsigned int    val;
	XMAC_SR15_BIT_T bf;
} XMAC_SR15_T;

// ---------------------------------------------------------------------
// Register xmac_status_shared0
// =>  xMAC0 Shared Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_STAT_SHAR0   0x00000840U
#define NETX_XM0_STAT_SHAR0 0x1C060840U
#define NETX_XM1_STAT_SHAR0 0x1C061840U

#define MSK_NETX_XM_STAT_SHAR0_gpio0_in          0x00000001U // [0]
#define SRT_NETX_XM_STAT_SHAR0_gpio0_in          0
#define MSK_NETX_XM_STAT_SHAR0_gpio1_in          0x00000002U // [1]
#define SRT_NETX_XM_STAT_SHAR0_gpio1_in          1
#define MSK_NETX_XM_STAT_SHAR0_rx_rdy            0x00000004U // [2]
#define SRT_NETX_XM_STAT_SHAR0_rx_rdy            2
#define MSK_NETX_XM_STAT_SHAR0_rx_ovf            0x00000008U // [3]
#define SRT_NETX_XM_STAT_SHAR0_rx_ovf            3
#define MSK_NETX_XM_STAT_SHAR0_tx_nxt            0x00000010U // [4]
#define SRT_NETX_XM_STAT_SHAR0_tx_nxt            4
#define MSK_NETX_XM_STAT_SHAR0_tx_ufl            0x00000020U // [5]
#define SRT_NETX_XM_STAT_SHAR0_tx_ufl            5
#define MSK_NETX_XM_STAT_SHAR0_utx_empty         0x00000040U // [6]
#define SRT_NETX_XM_STAT_SHAR0_utx_empty         6
#define MSK_NETX_XM_STAT_SHAR0_brec              0x00000080U // [7]
#define SRT_NETX_XM_STAT_SHAR0_brec              7
#define MSK_NETX_XM_STAT_SHAR0_btran             0x00000100U // [8]
#define SRT_NETX_XM_STAT_SHAR0_btran             8
#define MSK_NETX_XM_STAT_SHAR0_stat_rpu          0x00000200U // [9]
#define SRT_NETX_XM_STAT_SHAR0_stat_rpu          9
#define MSK_NETX_XM_STAT_SHAR0_stat_tpu          0x00000400U // [10]
#define SRT_NETX_XM_STAT_SHAR0_stat_tpu          10
#define MSK_NETX_XM_STAT_SHAR0_phy_led_en        0x00000800U // [11]
#define SRT_NETX_XM_STAT_SHAR0_phy_led_en        11
#define MSK_NETX_XM_STAT_SHAR0_gpio2_in_phy_led0 0x00001000U // [12]
#define SRT_NETX_XM_STAT_SHAR0_gpio2_in_phy_led0 12
#define MSK_NETX_XM_STAT_SHAR0_gpio3_in_phy_led1 0x00002000U // [13]
#define SRT_NETX_XM_STAT_SHAR0_gpio3_in_phy_led1 13
#define MSK_NETX_XM_STAT_SHAR0_gpio4_in_phy_led2 0x00004000U // [14]
#define SRT_NETX_XM_STAT_SHAR0_gpio4_in_phy_led2 14
#define MSK_NETX_XM_STAT_SHAR0_gpio5_in_phy_led3 0x00008000U // [15]
#define SRT_NETX_XM_STAT_SHAR0_gpio5_in_phy_led3 15

enum {
	BFW_NETX_XM_STAT_SHAR0_gpio0_in          = 1,  // [0]
	BFW_NETX_XM_STAT_SHAR0_gpio1_in          = 1,  // [1]
	BFW_NETX_XM_STAT_SHAR0_rx_rdy            = 1,  // [2]
	BFW_NETX_XM_STAT_SHAR0_rx_ovf            = 1,  // [3]
	BFW_NETX_XM_STAT_SHAR0_tx_nxt            = 1,  // [4]
	BFW_NETX_XM_STAT_SHAR0_tx_ufl            = 1,  // [5]
	BFW_NETX_XM_STAT_SHAR0_utx_empty         = 1,  // [6]
	BFW_NETX_XM_STAT_SHAR0_brec              = 1,  // [7]
	BFW_NETX_XM_STAT_SHAR0_btran             = 1,  // [8]
	BFW_NETX_XM_STAT_SHAR0_stat_rpu          = 1,  // [9]
	BFW_NETX_XM_STAT_SHAR0_stat_tpu          = 1,  // [10]
	BFW_NETX_XM_STAT_SHAR0_phy_led_en        = 1,  // [11]
	BFW_NETX_XM_STAT_SHAR0_gpio2_in_phy_led0 = 1,  // [12]
	BFW_NETX_XM_STAT_SHAR0_gpio3_in_phy_led1 = 1,  // [13]
	BFW_NETX_XM_STAT_SHAR0_gpio4_in_phy_led2 = 1,  // [14]
	BFW_NETX_XM_STAT_SHAR0_gpio5_in_phy_led3 = 1,  // [15]
	BFW_NETX_XM_STAT_SHAR0_reserved1         = 16  // [31:16]
};

typedef struct XMAC_STATUS_SHARED0_BIT_Ttag {
	unsigned int gpio0_in          : BFW_NETX_XM_STAT_SHAR0_gpio0_in;          // value at external gpio pin
	unsigned int gpio1_in          : BFW_NETX_XM_STAT_SHAR0_gpio1_in;          // value at external gpio pin
	unsigned int rx_rdy            : BFW_NETX_XM_STAT_SHAR0_rx_rdy;            // received bytes are valid at output of URX_FIFO
	unsigned int rx_ovf            : BFW_NETX_XM_STAT_SHAR0_rx_ovf;            // receive overflow (too much data in URX_FIFO)
	unsigned int tx_nxt            : BFW_NETX_XM_STAT_SHAR0_tx_nxt;            // put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty
	unsigned int tx_ufl            : BFW_NETX_XM_STAT_SHAR0_tx_ufl;            // transmit underflow (not enough data in UTX_FIFO)
	unsigned int utx_empty         : BFW_NETX_XM_STAT_SHAR0_utx_empty;         // UTX_FIFO is empty
	unsigned int brec              : BFW_NETX_XM_STAT_SHAR0_brec;              // bit_received (active for 1 cc)
	unsigned int btran             : BFW_NETX_XM_STAT_SHAR0_btran;             // bit_transmitted (active for 1 cc)
	unsigned int stat_rpu          : BFW_NETX_XM_STAT_SHAR0_stat_rpu;          // set and reset by RPU command bits
	unsigned int stat_tpu          : BFW_NETX_XM_STAT_SHAR0_stat_tpu;          // set and reset by TPU command bits
	unsigned int phy_led_en        : BFW_NETX_XM_STAT_SHAR0_phy_led_en;        // -> read only version of xmac_config_sbu-phy_led_en (visible to xPECs)
	unsigned int gpio2_in_phy_led0 : BFW_NETX_XM_STAT_SHAR0_gpio2_in_phy_led0; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED0, usually link_status
	                                                        // 0: gpio2_in # value at external gpio pin
	unsigned int gpio3_in_phy_led1 : BFW_NETX_XM_STAT_SHAR0_gpio3_in_phy_led1; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED1, usually activity
	                                                        // 0: gpio3_in # value at external gpio pin
	unsigned int gpio4_in_phy_led2 : BFW_NETX_XM_STAT_SHAR0_gpio4_in_phy_led2; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED2, usually speed100
	                                                        // 0: gpio4_in # value at external gpio pin
	unsigned int gpio5_in_phy_led3 : BFW_NETX_XM_STAT_SHAR0_gpio5_in_phy_led3; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED3, usually full_duplex
	                                                        // 0: gpio5_in # value at external gpio pin
	unsigned int reserved1         : BFW_NETX_XM_STAT_SHAR0_reserved1;         // reserved
} XMAC_STATUS_SHARED0_BIT_T;

typedef union {
	unsigned int              val;
	XMAC_STATUS_SHARED0_BIT_T bf;
} XMAC_STATUS_SHARED0_T;

// ---------------------------------------------------------------------
// Register xmac_config_shared0
// =>  xMAC0 Shared Config Register
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_CFG_SHAR0   0x00000844U
#define NETX_XM0_CFG_SHAR0 0x1C060844U
#define NETX_XM1_CFG_SHAR0 0x1C061844U

#define MSK_NETX_XM_CFG_SHAR0_gpio2_out     0x00000001U // [0]
#define SRT_NETX_XM_CFG_SHAR0_gpio2_out     0
#define MSK_NETX_XM_CFG_SHAR0_gpio2_oe      0x00000002U // [1]
#define SRT_NETX_XM_CFG_SHAR0_gpio2_oe      1
#define MSK_NETX_XM_CFG_SHAR0_gpio3_out     0x00000004U // [2]
#define SRT_NETX_XM_CFG_SHAR0_gpio3_out     2
#define MSK_NETX_XM_CFG_SHAR0_gpio3_oe      0x00000008U // [3]
#define SRT_NETX_XM_CFG_SHAR0_gpio3_oe      3
#define MSK_NETX_XM_CFG_SHAR0_gpio4_out     0x00000010U // [4]
#define SRT_NETX_XM_CFG_SHAR0_gpio4_out     4
#define MSK_NETX_XM_CFG_SHAR0_gpio4_oe      0x00000020U // [5]
#define SRT_NETX_XM_CFG_SHAR0_gpio4_oe      5
#define MSK_NETX_XM_CFG_SHAR0_gpio5_out     0x00000040U // [6]
#define SRT_NETX_XM_CFG_SHAR0_gpio5_out     6
#define MSK_NETX_XM_CFG_SHAR0_gpio5_oe      0x00000080U // [7]
#define SRT_NETX_XM_CFG_SHAR0_gpio5_oe      7
#define MSK_NETX_XM_CFG_SHAR0_rx_shift_lr   0x00000100U // [8]
#define SRT_NETX_XM_CFG_SHAR0_rx_shift_lr   8
#define MSK_NETX_XM_CFG_SHAR0_tx_shift_lr   0x00000200U // [9]
#define SRT_NETX_XM_CFG_SHAR0_tx_shift_lr   9
#define MSK_NETX_XM_CFG_SHAR0_reset_rx_fifo 0x00000400U // [10]
#define SRT_NETX_XM_CFG_SHAR0_reset_rx_fifo 10
#define MSK_NETX_XM_CFG_SHAR0_reset_tx_fifo 0x00000800U // [11]
#define SRT_NETX_XM_CFG_SHAR0_reset_tx_fifo 11
#define MSK_NETX_XM_CFG_SHAR0_gpio0_out     0x00001000U // [12]
#define SRT_NETX_XM_CFG_SHAR0_gpio0_out     12
#define MSK_NETX_XM_CFG_SHAR0_gpio0_oe      0x00002000U // [13]
#define SRT_NETX_XM_CFG_SHAR0_gpio0_oe      13
#define MSK_NETX_XM_CFG_SHAR0_gpio1_out     0x00004000U // [14]
#define SRT_NETX_XM_CFG_SHAR0_gpio1_out     14
#define MSK_NETX_XM_CFG_SHAR0_gpio1_oe      0x00008000U // [15]
#define SRT_NETX_XM_CFG_SHAR0_gpio1_oe      15

enum {
	BFW_NETX_XM_CFG_SHAR0_gpio2_out     = 1,  // [0]
	BFW_NETX_XM_CFG_SHAR0_gpio2_oe      = 1,  // [1]
	BFW_NETX_XM_CFG_SHAR0_gpio3_out     = 1,  // [2]
	BFW_NETX_XM_CFG_SHAR0_gpio3_oe      = 1,  // [3]
	BFW_NETX_XM_CFG_SHAR0_gpio4_out     = 1,  // [4]
	BFW_NETX_XM_CFG_SHAR0_gpio4_oe      = 1,  // [5]
	BFW_NETX_XM_CFG_SHAR0_gpio5_out     = 1,  // [6]
	BFW_NETX_XM_CFG_SHAR0_gpio5_oe      = 1,  // [7]
	BFW_NETX_XM_CFG_SHAR0_rx_shift_lr   = 1,  // [8]
	BFW_NETX_XM_CFG_SHAR0_tx_shift_lr   = 1,  // [9]
	BFW_NETX_XM_CFG_SHAR0_reset_rx_fifo = 1,  // [10]
	BFW_NETX_XM_CFG_SHAR0_reset_tx_fifo = 1,  // [11]
	BFW_NETX_XM_CFG_SHAR0_gpio0_out     = 1,  // [12]
	BFW_NETX_XM_CFG_SHAR0_gpio0_oe      = 1,  // [13]
	BFW_NETX_XM_CFG_SHAR0_gpio1_out     = 1,  // [14]
	BFW_NETX_XM_CFG_SHAR0_gpio1_oe      = 1,  // [15]
	BFW_NETX_XM_CFG_SHAR0_reserved1     = 16  // [31:16]
};

typedef struct XMAC_CONFIG_SHARED0_BIT_Ttag {
	unsigned int gpio2_out     : BFW_NETX_XM_CFG_SHAR0_gpio2_out;     // General Purpose IO 2 output
	unsigned int gpio2_oe      : BFW_NETX_XM_CFG_SHAR0_gpio2_oe;      // General Purpose IO 2 output enable
	unsigned int gpio3_out     : BFW_NETX_XM_CFG_SHAR0_gpio3_out;     // General Purpose IO 3 output
	unsigned int gpio3_oe      : BFW_NETX_XM_CFG_SHAR0_gpio3_oe;      // General Purpose IO 3 output enable
	unsigned int gpio4_out     : BFW_NETX_XM_CFG_SHAR0_gpio4_out;     // General Purpose IO 4 output
	unsigned int gpio4_oe      : BFW_NETX_XM_CFG_SHAR0_gpio4_oe;      // General Purpose IO 4 output enable
	unsigned int gpio5_out     : BFW_NETX_XM_CFG_SHAR0_gpio5_out;     // General Purpose IO 5 output
	unsigned int gpio5_oe      : BFW_NETX_XM_CFG_SHAR0_gpio5_oe;      // General Purpose IO 5 output enable
	unsigned int rx_shift_lr   : BFW_NETX_XM_CFG_SHAR0_rx_shift_lr;   // 1: SBU reads incoming bits to position 0 of register rx and shifts rx left,
	                                                        // 0: SBU reads incoming bits to position 15 of register rx and shifts rx right
	unsigned int tx_shift_lr   : BFW_NETX_XM_CFG_SHAR0_tx_shift_lr;   // 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left,
	                                                        // 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right
	unsigned int reset_rx_fifo : BFW_NETX_XM_CFG_SHAR0_reset_rx_fifo; // reset URX_FIFO and rx_ovf bit inside status_shared register
	unsigned int reset_tx_fifo : BFW_NETX_XM_CFG_SHAR0_reset_tx_fifo; // reset UTX_FIFO and tx_ufl bit inside status_shared register
	unsigned int gpio0_out     : BFW_NETX_XM_CFG_SHAR0_gpio0_out;     // General Purpose IO 0 output
	unsigned int gpio0_oe      : BFW_NETX_XM_CFG_SHAR0_gpio0_oe;      // General Purpose IO 0 output enable
	unsigned int gpio1_out     : BFW_NETX_XM_CFG_SHAR0_gpio1_out;     // General Purpose IO 1 output
	unsigned int gpio1_oe      : BFW_NETX_XM_CFG_SHAR0_gpio1_oe;      // General Purpose IO 1 output enable
	unsigned int reserved1     : BFW_NETX_XM_CFG_SHAR0_reserved1;     // reserved
} XMAC_CONFIG_SHARED0_BIT_T;

typedef union {
	unsigned int              val;
	XMAC_CONFIG_SHARED0_BIT_T bf;
} XMAC_CONFIG_SHARED0_T;

// ---------------------------------------------------------------------
// Register xmac_status_shared1
// =>  xMAC1 Shared Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_STAT_SHAR1   0x00000848U
#define NETX_XM0_STAT_SHAR1 0x1C060848U
#define NETX_XM1_STAT_SHAR1 0x1C061848U

#define MSK_NETX_XM_STAT_SHAR1_gpio0_in          0x00000001U // [0]
#define SRT_NETX_XM_STAT_SHAR1_gpio0_in          0
#define MSK_NETX_XM_STAT_SHAR1_gpio1_in          0x00000002U // [1]
#define SRT_NETX_XM_STAT_SHAR1_gpio1_in          1
#define MSK_NETX_XM_STAT_SHAR1_rx_rdy            0x00000004U // [2]
#define SRT_NETX_XM_STAT_SHAR1_rx_rdy            2
#define MSK_NETX_XM_STAT_SHAR1_rx_ovf            0x00000008U // [3]
#define SRT_NETX_XM_STAT_SHAR1_rx_ovf            3
#define MSK_NETX_XM_STAT_SHAR1_tx_nxt            0x00000010U // [4]
#define SRT_NETX_XM_STAT_SHAR1_tx_nxt            4
#define MSK_NETX_XM_STAT_SHAR1_tx_ufl            0x00000020U // [5]
#define SRT_NETX_XM_STAT_SHAR1_tx_ufl            5
#define MSK_NETX_XM_STAT_SHAR1_utx_empty         0x00000040U // [6]
#define SRT_NETX_XM_STAT_SHAR1_utx_empty         6
#define MSK_NETX_XM_STAT_SHAR1_brec              0x00000080U // [7]
#define SRT_NETX_XM_STAT_SHAR1_brec              7
#define MSK_NETX_XM_STAT_SHAR1_btran             0x00000100U // [8]
#define SRT_NETX_XM_STAT_SHAR1_btran             8
#define MSK_NETX_XM_STAT_SHAR1_stat_rpu          0x00000200U // [9]
#define SRT_NETX_XM_STAT_SHAR1_stat_rpu          9
#define MSK_NETX_XM_STAT_SHAR1_stat_tpu          0x00000400U // [10]
#define SRT_NETX_XM_STAT_SHAR1_stat_tpu          10
#define MSK_NETX_XM_STAT_SHAR1_phy_led_en        0x00000800U // [11]
#define SRT_NETX_XM_STAT_SHAR1_phy_led_en        11
#define MSK_NETX_XM_STAT_SHAR1_gpio2_in_phy_led0 0x00001000U // [12]
#define SRT_NETX_XM_STAT_SHAR1_gpio2_in_phy_led0 12
#define MSK_NETX_XM_STAT_SHAR1_gpio3_in_phy_led1 0x00002000U // [13]
#define SRT_NETX_XM_STAT_SHAR1_gpio3_in_phy_led1 13
#define MSK_NETX_XM_STAT_SHAR1_gpio4_in_phy_led2 0x00004000U // [14]
#define SRT_NETX_XM_STAT_SHAR1_gpio4_in_phy_led2 14
#define MSK_NETX_XM_STAT_SHAR1_gpio5_in_phy_led3 0x00008000U // [15]
#define SRT_NETX_XM_STAT_SHAR1_gpio5_in_phy_led3 15

enum {
	BFW_NETX_XM_STAT_SHAR1_gpio0_in          = 1,  // [0]
	BFW_NETX_XM_STAT_SHAR1_gpio1_in          = 1,  // [1]
	BFW_NETX_XM_STAT_SHAR1_rx_rdy            = 1,  // [2]
	BFW_NETX_XM_STAT_SHAR1_rx_ovf            = 1,  // [3]
	BFW_NETX_XM_STAT_SHAR1_tx_nxt            = 1,  // [4]
	BFW_NETX_XM_STAT_SHAR1_tx_ufl            = 1,  // [5]
	BFW_NETX_XM_STAT_SHAR1_utx_empty         = 1,  // [6]
	BFW_NETX_XM_STAT_SHAR1_brec              = 1,  // [7]
	BFW_NETX_XM_STAT_SHAR1_btran             = 1,  // [8]
	BFW_NETX_XM_STAT_SHAR1_stat_rpu          = 1,  // [9]
	BFW_NETX_XM_STAT_SHAR1_stat_tpu          = 1,  // [10]
	BFW_NETX_XM_STAT_SHAR1_phy_led_en        = 1,  // [11]
	BFW_NETX_XM_STAT_SHAR1_gpio2_in_phy_led0 = 1,  // [12]
	BFW_NETX_XM_STAT_SHAR1_gpio3_in_phy_led1 = 1,  // [13]
	BFW_NETX_XM_STAT_SHAR1_gpio4_in_phy_led2 = 1,  // [14]
	BFW_NETX_XM_STAT_SHAR1_gpio5_in_phy_led3 = 1,  // [15]
	BFW_NETX_XM_STAT_SHAR1_reserved1         = 16  // [31:16]
};

typedef struct XMAC_STATUS_SHARED1_BIT_Ttag {
	unsigned int gpio0_in          : BFW_NETX_XM_STAT_SHAR1_gpio0_in;          // value at external gpio pin
	unsigned int gpio1_in          : BFW_NETX_XM_STAT_SHAR1_gpio1_in;          // value at external gpio pin
	unsigned int rx_rdy            : BFW_NETX_XM_STAT_SHAR1_rx_rdy;            // received bytes are valid at output of URX_FIFO
	unsigned int rx_ovf            : BFW_NETX_XM_STAT_SHAR1_rx_ovf;            // receive overflow (too much data in URX_FIFO)
	unsigned int tx_nxt            : BFW_NETX_XM_STAT_SHAR1_tx_nxt;            // put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty
	unsigned int tx_ufl            : BFW_NETX_XM_STAT_SHAR1_tx_ufl;            // transmit underflow (not enough data in UTX_FIFO)
	unsigned int utx_empty         : BFW_NETX_XM_STAT_SHAR1_utx_empty;         // UTX_FIFO is empty
	unsigned int brec              : BFW_NETX_XM_STAT_SHAR1_brec;              // bit_received (active for 1 cc)
	unsigned int btran             : BFW_NETX_XM_STAT_SHAR1_btran;             // bit_transmitted (active for 1 cc)
	unsigned int stat_rpu          : BFW_NETX_XM_STAT_SHAR1_stat_rpu;          // set and reset by RPU command bits
	unsigned int stat_tpu          : BFW_NETX_XM_STAT_SHAR1_stat_tpu;          // set and reset by TPU command bits
	unsigned int phy_led_en        : BFW_NETX_XM_STAT_SHAR1_phy_led_en;        // -> read only version of xmac_config_sbu-phy_led_en (visible to xPECs)
	unsigned int gpio2_in_phy_led0 : BFW_NETX_XM_STAT_SHAR1_gpio2_in_phy_led0; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED0, usually link_status
	                                                        // 0: gpio2_in # value at external gpio pin
	unsigned int gpio3_in_phy_led1 : BFW_NETX_XM_STAT_SHAR1_gpio3_in_phy_led1; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED1, usually activity
	                                                        // 0: gpio3_in # value at external gpio pin
	unsigned int gpio4_in_phy_led2 : BFW_NETX_XM_STAT_SHAR1_gpio4_in_phy_led2; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED2, usually speed100
	                                                        // 0: gpio4_in # value at external gpio pin
	unsigned int gpio5_in_phy_led3 : BFW_NETX_XM_STAT_SHAR1_gpio5_in_phy_led3; // IF phy_led_en:
	                                                        // 1: Internal Phy0 LED3, usually full_duplex
	                                                        // 0: gpio5_in # value at external gpio pin
	unsigned int reserved1         : BFW_NETX_XM_STAT_SHAR1_reserved1;         // reserved
} XMAC_STATUS_SHARED1_BIT_T;

typedef union {
	unsigned int              val;
	XMAC_STATUS_SHARED1_BIT_T bf;
} XMAC_STATUS_SHARED1_T;

// ---------------------------------------------------------------------
// Register xmac_config_shared1
// =>  xMAC1 Shared Config Register
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_CFG_SHAR1   0x0000084CU
#define NETX_XM0_CFG_SHAR1 0x1C06084CU
#define NETX_XM1_CFG_SHAR1 0x1C06184CU

#define MSK_NETX_XM_CFG_SHAR1_gpio2_out     0x00000001U // [0]
#define SRT_NETX_XM_CFG_SHAR1_gpio2_out     0
#define MSK_NETX_XM_CFG_SHAR1_gpio2_oe      0x00000002U // [1]
#define SRT_NETX_XM_CFG_SHAR1_gpio2_oe      1
#define MSK_NETX_XM_CFG_SHAR1_gpio3_out     0x00000004U // [2]
#define SRT_NETX_XM_CFG_SHAR1_gpio3_out     2
#define MSK_NETX_XM_CFG_SHAR1_gpio3_oe      0x00000008U // [3]
#define SRT_NETX_XM_CFG_SHAR1_gpio3_oe      3
#define MSK_NETX_XM_CFG_SHAR1_gpio4_out     0x00000010U // [4]
#define SRT_NETX_XM_CFG_SHAR1_gpio4_out     4
#define MSK_NETX_XM_CFG_SHAR1_gpio4_oe      0x00000020U // [5]
#define SRT_NETX_XM_CFG_SHAR1_gpio4_oe      5
#define MSK_NETX_XM_CFG_SHAR1_gpio5_out     0x00000040U // [6]
#define SRT_NETX_XM_CFG_SHAR1_gpio5_out     6
#define MSK_NETX_XM_CFG_SHAR1_gpio5_oe      0x00000080U // [7]
#define SRT_NETX_XM_CFG_SHAR1_gpio5_oe      7
#define MSK_NETX_XM_CFG_SHAR1_rx_shift_lr   0x00000100U // [8]
#define SRT_NETX_XM_CFG_SHAR1_rx_shift_lr   8
#define MSK_NETX_XM_CFG_SHAR1_tx_shift_lr   0x00000200U // [9]
#define SRT_NETX_XM_CFG_SHAR1_tx_shift_lr   9
#define MSK_NETX_XM_CFG_SHAR1_reset_rx_fifo 0x00000400U // [10]
#define SRT_NETX_XM_CFG_SHAR1_reset_rx_fifo 10
#define MSK_NETX_XM_CFG_SHAR1_reset_tx_fifo 0x00000800U // [11]
#define SRT_NETX_XM_CFG_SHAR1_reset_tx_fifo 11
#define MSK_NETX_XM_CFG_SHAR1_gpio0_out     0x00001000U // [12]
#define SRT_NETX_XM_CFG_SHAR1_gpio0_out     12
#define MSK_NETX_XM_CFG_SHAR1_gpio0_oe      0x00002000U // [13]
#define SRT_NETX_XM_CFG_SHAR1_gpio0_oe      13
#define MSK_NETX_XM_CFG_SHAR1_gpio1_out     0x00004000U // [14]
#define SRT_NETX_XM_CFG_SHAR1_gpio1_out     14
#define MSK_NETX_XM_CFG_SHAR1_gpio1_oe      0x00008000U // [15]
#define SRT_NETX_XM_CFG_SHAR1_gpio1_oe      15

enum {
	BFW_NETX_XM_CFG_SHAR1_gpio2_out     = 1,  // [0]
	BFW_NETX_XM_CFG_SHAR1_gpio2_oe      = 1,  // [1]
	BFW_NETX_XM_CFG_SHAR1_gpio3_out     = 1,  // [2]
	BFW_NETX_XM_CFG_SHAR1_gpio3_oe      = 1,  // [3]
	BFW_NETX_XM_CFG_SHAR1_gpio4_out     = 1,  // [4]
	BFW_NETX_XM_CFG_SHAR1_gpio4_oe      = 1,  // [5]
	BFW_NETX_XM_CFG_SHAR1_gpio5_out     = 1,  // [6]
	BFW_NETX_XM_CFG_SHAR1_gpio5_oe      = 1,  // [7]
	BFW_NETX_XM_CFG_SHAR1_rx_shift_lr   = 1,  // [8]
	BFW_NETX_XM_CFG_SHAR1_tx_shift_lr   = 1,  // [9]
	BFW_NETX_XM_CFG_SHAR1_reset_rx_fifo = 1,  // [10]
	BFW_NETX_XM_CFG_SHAR1_reset_tx_fifo = 1,  // [11]
	BFW_NETX_XM_CFG_SHAR1_gpio0_out     = 1,  // [12]
	BFW_NETX_XM_CFG_SHAR1_gpio0_oe      = 1,  // [13]
	BFW_NETX_XM_CFG_SHAR1_gpio1_out     = 1,  // [14]
	BFW_NETX_XM_CFG_SHAR1_gpio1_oe      = 1,  // [15]
	BFW_NETX_XM_CFG_SHAR1_reserved1     = 16  // [31:16]
};

typedef struct XMAC_CONFIG_SHARED1_BIT_Ttag {
	unsigned int gpio2_out     : BFW_NETX_XM_CFG_SHAR1_gpio2_out;     // General Purpose IO 2 output
	unsigned int gpio2_oe      : BFW_NETX_XM_CFG_SHAR1_gpio2_oe;      // General Purpose IO 2 output enable
	unsigned int gpio3_out     : BFW_NETX_XM_CFG_SHAR1_gpio3_out;     // General Purpose IO 3 output
	unsigned int gpio3_oe      : BFW_NETX_XM_CFG_SHAR1_gpio3_oe;      // General Purpose IO 3 output enable
	unsigned int gpio4_out     : BFW_NETX_XM_CFG_SHAR1_gpio4_out;     // General Purpose IO 4 output
	unsigned int gpio4_oe      : BFW_NETX_XM_CFG_SHAR1_gpio4_oe;      // General Purpose IO 4 output enable
	unsigned int gpio5_out     : BFW_NETX_XM_CFG_SHAR1_gpio5_out;     // General Purpose IO 5 output
	unsigned int gpio5_oe      : BFW_NETX_XM_CFG_SHAR1_gpio5_oe;      // General Purpose IO 5 output enable
	unsigned int rx_shift_lr   : BFW_NETX_XM_CFG_SHAR1_rx_shift_lr;   // 1: SBU reads incoming bits to position 0 of register rx and shifts rx left,
	                                                        // 0: SBU reads incoming bits to position 15 of register rx and shifts rx right
	unsigned int tx_shift_lr   : BFW_NETX_XM_CFG_SHAR1_tx_shift_lr;   // 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left,
	                                                        // 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right
	unsigned int reset_rx_fifo : BFW_NETX_XM_CFG_SHAR1_reset_rx_fifo; // reset URX_FIFO and rx_ovf bit inside status_shared register
	unsigned int reset_tx_fifo : BFW_NETX_XM_CFG_SHAR1_reset_tx_fifo; // reset UTX_FIFO and tx_ufl bit inside status_shared register
	unsigned int gpio0_out     : BFW_NETX_XM_CFG_SHAR1_gpio0_out;     // General Purpose IO 0 output
	unsigned int gpio0_oe      : BFW_NETX_XM_CFG_SHAR1_gpio0_oe;      // General Purpose IO 0 output enable
	unsigned int gpio1_out     : BFW_NETX_XM_CFG_SHAR1_gpio1_out;     // General Purpose IO 1 output
	unsigned int gpio1_oe      : BFW_NETX_XM_CFG_SHAR1_gpio1_oe;      // General Purpose IO 1 output enable
	unsigned int reserved1     : BFW_NETX_XM_CFG_SHAR1_reserved1;     // reserved
} XMAC_CONFIG_SHARED1_BIT_T;

typedef union {
	unsigned int              val;
	XMAC_CONFIG_SHARED1_BIT_T bf;
} XMAC_CONFIG_SHARED1_T;

// ---------------------------------------------------------------------
// Register xmac_urx_utx0
// =>  xMAC0 URX/UTX Shared Register FIFO
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_URX_UTX0   0x00000860U
#define NETX_XM0_URX_UTX0 0x1C060860U
#define NETX_XM1_URX_UTX0 0x1C061860U

#define MSK_NETX_XM_URX_UTX0_UTX_XMAC0 0x0000ffffU // [15:0]
#define SRT_NETX_XM_URX_UTX0_UTX_XMAC0 0

enum {
	BFW_NETX_XM_URX_UTX0_UTX_XMAC0 = 16, // [15:0]
	BFW_NETX_XM_URX_UTX0_reserved1 = 16  // [31:16]
};

typedef struct XMAC_URX_UTX0_BIT_Ttag {
	unsigned int UTX_XMAC0 : BFW_NETX_XM_URX_UTX0_UTX_XMAC0; // read access:  Lastly received bits (output of URX_FIFO)
	                                                        // write access: Bits to be transmitted next (input of UTX_FIFO)
	unsigned int reserved1 : BFW_NETX_XM_URX_UTX0_reserved1; // reserved
} XMAC_URX_UTX0_BIT_T;

typedef union {
	unsigned int        val;
	XMAC_URX_UTX0_BIT_T bf;
} XMAC_URX_UTX0_T;

// ---------------------------------------------------------------------
// Register xmac_urx_utx1
// =>  xMAC1 URX/UTX Shared Register FIFO
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_URX_UTX1   0x00000864U
#define NETX_XM0_URX_UTX1 0x1C060864U
#define NETX_XM1_URX_UTX1 0x1C061864U

#define MSK_NETX_XM_URX_UTX1_UTX_XMAC1 0x0000ffffU // [15:0]
#define SRT_NETX_XM_URX_UTX1_UTX_XMAC1 0

enum {
	BFW_NETX_XM_URX_UTX1_UTX_XMAC1 = 16, // [15:0]
	BFW_NETX_XM_URX_UTX1_reserved1 = 16  // [31:16]
};

typedef struct XMAC_URX_UTX1_BIT_Ttag {
	unsigned int UTX_XMAC1 : BFW_NETX_XM_URX_UTX1_UTX_XMAC1; // read access:  Lastly received bits (output of URX_FIFO)
	                                                        // write access: Bits to be transmitted next (input of UTX_FIFO)
	unsigned int reserved1 : BFW_NETX_XM_URX_UTX1_reserved1; // reserved
} XMAC_URX_UTX1_BIT_T;

typedef union {
	unsigned int        val;
	XMAC_URX_UTX1_BIT_T bf;
} XMAC_URX_UTX1_T;

// ---------------------------------------------------------------------
// Register xmac_urx
// =>  xMAC URX FIFO input
//     URX FIFO is part of xMAC. It can be read (output) by all xMACs and xPECs, but only written (input) by the xMAC it belongs to.
//     This register has a write pipeline delay of 1 clock cycle
// => Mode: W
// ---------------------------------------------------------------------

#define REL_NETX_XM_URX   0x00000870U
#define NETX_XM0_URX 0x1C060870U
#define NETX_XM1_URX 0x1C061870U

#define MSK_NETX_XM_URX_urx 0x0000ffffU // [15:0]
#define SRT_NETX_XM_URX_urx 0

enum {
	BFW_NETX_XM_URX_urx       = 16, // [15:0]
	BFW_NETX_XM_URX_reserved1 = 16  // [31:16]
};

typedef struct XMAC_URX_BIT_Ttag {
	unsigned int urx       : BFW_NETX_XM_URX_urx;       // Lastly received bits to be transmitted to xPEC (input of URX_FIFO)
	unsigned int reserved1 : BFW_NETX_XM_URX_reserved1; // reserved
} XMAC_URX_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_URX_BIT_T bf;
} XMAC_URX_T;

// ---------------------------------------------------------------------
// Register xmac_utx
// =>  xMAC UTX FIFO output
//     UTX FIFO is part of xMAC. It can be written (input) by all xMACs and xPECs, but only read (output) by the xMAC it belongs to.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_UTX   0x00000874U
#define NETX_XM0_UTX 0x1C060874U
#define NETX_XM1_UTX 0x1C061874U

#define MSK_NETX_XM_UTX_utx 0x0000ffffU // [15:0]
#define SRT_NETX_XM_UTX_utx 0

enum {
	BFW_NETX_XM_UTX_utx       = 16, // [15:0]
	BFW_NETX_XM_UTX_reserved1 = 16  // [31:16]
};

typedef struct XMAC_UTX_BIT_Ttag {
	unsigned int utx       : BFW_NETX_XM_UTX_utx;       // Bits to be transmitted next (output of UTX_FIFO)
	                                                        // read as src2 allows multiple reads, only read as src1 will change FIFO state
	unsigned int reserved1 : BFW_NETX_XM_UTX_reserved1; // reserved
} XMAC_UTX_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_UTX_BIT_T bf;
} XMAC_UTX_T;

// ---------------------------------------------------------------------
// Register xmac_rx
// =>  xMAC RX Register
//     Sampled bits from SBU are collected in this register,
//     i.e. if a new bit arrives from SBU (sync), other bits are shifted (direction programmable).
//     Same behavior in MII-Modes (4 bits arrive in parallel and the other bits are shifted by 4).
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_RX   0x00000878U
#define NETX_XM0_RX 0x1C060878U
#define NETX_XM1_RX 0x1C061878U

#define MSK_NETX_XM_RX_rx 0x0000ffffU // [15:0]
#define SRT_NETX_XM_RX_rx 0

enum {
	BFW_NETX_XM_RX_rx        = 16, // [15:0]
	BFW_NETX_XM_RX_reserved1 = 16  // [31:16]
};

typedef struct XMAC_RX_BIT_Ttag {
	unsigned int rx        : BFW_NETX_XM_RX_rx;        // 16 previously received bits
	unsigned int reserved1 : BFW_NETX_XM_RX_reserved1; // reserved
} XMAC_RX_BIT_T;

typedef union {
	unsigned int  val;
	XMAC_RX_BIT_T bf;
} XMAC_RX_T;

// ---------------------------------------------------------------------
// Register xmac_rx_hw
// =>  xMAC RX_HW Register
//     rx_hw bit in RPU-code writes actually received bit from rx to this register.
//     Useful in case of bitwise format, to collect source bits from raw input bitstream (e.g. in HDLC-coding).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_RX_HW   0x0000087CU
#define NETX_XM0_RX_HW 0x1C06087CU
#define NETX_XM1_RX_HW 0x1C06187CU

#define MSK_NETX_XM_RX_HW_rx_hw 0x0000ffffU // [15:0]
#define SRT_NETX_XM_RX_HW_rx_hw 0

enum {
	BFW_NETX_XM_RX_HW_rx_hw     = 16, // [15:0]
	BFW_NETX_XM_RX_HW_reserved1 = 16  // [31:16]
};

typedef struct XMAC_RX_HW_BIT_Ttag {
	unsigned int rx_hw     : BFW_NETX_XM_RX_HW_rx_hw;     // collected source bits from raw input bitstream
	                                                        // same orientation of bits as in rx register (depending on rx_shift_lr)
	unsigned int reserved1 : BFW_NETX_XM_RX_HW_reserved1; // reserved
} XMAC_RX_HW_BIT_T;

typedef union {
	unsigned int     val;
	XMAC_RX_HW_BIT_T bf;
} XMAC_RX_HW_T;

// ---------------------------------------------------------------------
// Register xmac_rx_hw_count
// =>  xMAC RX_HW_COUNT Register
//     Counts bits collected by rx_hw bit RPU-code.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_RX_HW_CNT   0x00000880U
#define NETX_XM0_RX_HW_CNT 0x1C060880U
#define NETX_XM1_RX_HW_CNT 0x1C061880U

#define MSK_NETX_XM_RX_HW_CNT_rx_hw_count 0x0000ffffU // [15:0]
#define SRT_NETX_XM_RX_HW_CNT_rx_hw_count 0

enum {
	BFW_NETX_XM_RX_HW_CNT_rx_hw_count = 16, // [15:0]
	BFW_NETX_XM_RX_HW_CNT_reserved1   = 16  // [31:16]
};

typedef struct XMAC_RX_HW_COUNT_BIT_Ttag {
	unsigned int rx_hw_count : BFW_NETX_XM_RX_HW_CNT_rx_hw_count; // counts down with rx_hw in RPU-code
	                                                        // (from rx_nof_bits-1 to 0, 16-bit downcounter if rx_nof_bits = 0)
	unsigned int reserved1   : BFW_NETX_XM_RX_HW_CNT_reserved1;   // reserved
} XMAC_RX_HW_COUNT_BIT_T;

typedef union {
	unsigned int           val;
	XMAC_RX_HW_COUNT_BIT_T bf;
} XMAC_RX_HW_COUNT_T;

// ---------------------------------------------------------------------
// Register xmac_tx
// =>  xMAC TX Register
//     Transmitted bits read automatically by OBU from this register,
//     i.e. if a bit is send (sync), other bits are rotated accordingly (direction programmable).
//     Same behavior in MII-Modes (4 bits arrive in parallel and the other bits are rotated by 4).
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_TX   0x00000884U
#define NETX_XM0_TX 0x1C060884U
#define NETX_XM1_TX 0x1C061884U

#define MSK_NETX_XM_TX_tx0  0x00000001U // [0]
#define SRT_NETX_XM_TX_tx0  0
#define MSK_NETX_XM_TX_tx   0x00007ffeU // [14:1]
#define SRT_NETX_XM_TX_tx   1
#define MSK_NETX_XM_TX_tx15 0x00008000U // [15]
#define SRT_NETX_XM_TX_tx15 15

enum {
	BFW_NETX_XM_TX_tx0       = 1,  // [0]
	BFW_NETX_XM_TX_tx        = 14, // [14:1]
	BFW_NETX_XM_TX_tx15      = 1,  // [15]
	BFW_NETX_XM_TX_reserved1 = 16  // [31:16]
};

typedef struct XMAC_TX_BIT_Ttag {
	unsigned int tx0       : BFW_NETX_XM_TX_tx0;       // bit to be transmitted next in case of tx_shift_lr = 0
	unsigned int tx        : BFW_NETX_XM_TX_tx;        // to be transmitted bits
	unsigned int tx15      : BFW_NETX_XM_TX_tx15;      // bit to be transmitted next in case of tx_shift_lr = 1
	unsigned int reserved1 : BFW_NETX_XM_TX_reserved1; // reserved
} XMAC_TX_BIT_T;

typedef union {
	unsigned int  val;
	XMAC_TX_BIT_T bf;
} XMAC_TX_T;

// ---------------------------------------------------------------------
// Register xmac_tx_hw
// =>  xMAC TX_HW Register
//     tx_hw bit in TPU-code writes to be transmitted bit in tx register from this register
//     Useful in case of bitwise format, to insert source bits into output bitstream.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_TX_HW   0x00000888U
#define NETX_XM0_TX_HW 0x1C060888U
#define NETX_XM1_TX_HW 0x1C061888U

#define MSK_NETX_XM_TX_HW_tx_hw 0x0000ffffU // [15:0]
#define SRT_NETX_XM_TX_HW_tx_hw 0

enum {
	BFW_NETX_XM_TX_HW_tx_hw     = 16, // [15:0]
	BFW_NETX_XM_TX_HW_reserved1 = 16  // [31:16]
};

typedef struct XMAC_TX_HW_BIT_Ttag {
	unsigned int tx_hw     : BFW_NETX_XM_TX_HW_tx_hw;     // bits to be inserted into output bitstream
	                                                        // same orientation of bits as in tx register (depending on tx_shift_lr)
	unsigned int reserved1 : BFW_NETX_XM_TX_HW_reserved1; // reserved
} XMAC_TX_HW_BIT_T;

typedef union {
	unsigned int     val;
	XMAC_TX_HW_BIT_T bf;
} XMAC_TX_HW_T;

// ---------------------------------------------------------------------
// Register xmac_tx_hw_count
// =>  xMAC TX_HW_COUNT Register
//     Counts bits collected by tx_hw bit TPU-code.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_TX_HW_CNT   0x0000088CU
#define NETX_XM0_TX_HW_CNT 0x1C06088CU
#define NETX_XM1_TX_HW_CNT 0x1C06188CU

#define MSK_NETX_XM_TX_HW_CNT_tx_hw_count 0x0000ffffU // [15:0]
#define SRT_NETX_XM_TX_HW_CNT_tx_hw_count 0

enum {
	BFW_NETX_XM_TX_HW_CNT_tx_hw_count = 16, // [15:0]
	BFW_NETX_XM_TX_HW_CNT_reserved1   = 16  // [31:16]
};

typedef struct XMAC_TX_HW_COUNT_BIT_Ttag {
	unsigned int tx_hw_count : BFW_NETX_XM_TX_HW_CNT_tx_hw_count; // counts down with tx_hw in TPU-code
	                                                        // (from tx_nof_bits-1 to 0, 16-bit downcounter if tx_nof_bits = 0)
	unsigned int reserved1   : BFW_NETX_XM_TX_HW_CNT_reserved1;   // reserved
} XMAC_TX_HW_COUNT_BIT_T;

typedef union {
	unsigned int           val;
	XMAC_TX_HW_COUNT_BIT_T bf;
} XMAC_TX_HW_COUNT_T;

// ---------------------------------------------------------------------
// Register xmac_tx_sent
// =>  xMAC TX Sent Register
//     Collects already transmitted bits.
//     Useful for pattern match.
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_TX_SENT   0x00000890U
#define NETX_XM0_TX_SENT 0x1C060890U
#define NETX_XM1_TX_SENT 0x1C061890U

#define MSK_NETX_XM_TX_SENT_tx_sent 0x0000ffffU // [15:0]
#define SRT_NETX_XM_TX_SENT_tx_sent 0

enum {
	BFW_NETX_XM_TX_SENT_tx_sent   = 16, // [15:0]
	BFW_NETX_XM_TX_SENT_reserved1 = 16  // [31:16]
};

typedef struct XMAC_TX_SENT_BIT_Ttag {
	unsigned int tx_sent   : BFW_NETX_XM_TX_SENT_tx_sent;   // already transmitted bits,
	                                                        // bit 15 is always the oldest bit (shift direction not programmable)
	unsigned int reserved1 : BFW_NETX_XM_TX_SENT_reserved1; // reserved
} XMAC_TX_SENT_BIT_T;

typedef union {
	unsigned int       val;
	XMAC_TX_SENT_BIT_T bf;
} XMAC_TX_SENT_T;

// ---------------------------------------------------------------------
// Register xmac_rpu_pc
// =>  RPU Progamm counter
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_RPU_PC   0x00000894U
#define NETX_XM0_RPU_PC 0x1C060894U
#define NETX_XM1_RPU_PC 0x1C061894U

#define MSK_NETX_XM_RPU_PC_rpu_pc 0x0000007fU // [6:0]
#define SRT_NETX_XM_RPU_PC_rpu_pc 0

enum {
	BFW_NETX_XM_RPU_PC_rpu_pc    = 7,  // [6:0]
	BFW_NETX_XM_RPU_PC_reserved1 = 25  // [31:7]
};

typedef struct XMAC_RPU_PC_BIT_Ttag {
	unsigned int rpu_pc    : BFW_NETX_XM_RPU_PC_rpu_pc;    // Program Counter of RPU
	unsigned int reserved1 : BFW_NETX_XM_RPU_PC_reserved1; // reserved
} XMAC_RPU_PC_BIT_T;

typedef union {
	unsigned int      val;
	XMAC_RPU_PC_BIT_T bf;
} XMAC_RPU_PC_T;

// ---------------------------------------------------------------------
// Register xmac_tpu_pc
// =>  TPU Progamm counter
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_TPU_PC   0x00000898U
#define NETX_XM0_TPU_PC 0x1C060898U
#define NETX_XM1_TPU_PC 0x1C061898U

#define MSK_NETX_XM_TPU_PC_tpu_pc 0x0000007fU // [6:0]
#define SRT_NETX_XM_TPU_PC_tpu_pc 0

enum {
	BFW_NETX_XM_TPU_PC_tpu_pc    = 7,  // [6:0]
	BFW_NETX_XM_TPU_PC_reserved1 = 25  // [31:7]
};

typedef struct XMAC_TPU_PC_BIT_Ttag {
	unsigned int tpu_pc    : BFW_NETX_XM_TPU_PC_tpu_pc;    // Program Counter of TPU
	unsigned int reserved1 : BFW_NETX_XM_TPU_PC_reserved1; // reserved
} XMAC_TPU_PC_BIT_T;

typedef union {
	unsigned int      val;
	XMAC_TPU_PC_BIT_T bf;
} XMAC_TPU_PC_T;

// ---------------------------------------------------------------------
// Register xmac_wr0
// =>  xMAC internal Work Register 0
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK0   0x0000089CU
#define NETX_XM0_WRK0 0x1C06089CU
#define NETX_XM1_WRK0 0x1C06189CU

#define MSK_NETX_XM_WRK0_WR0 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK0_WR0 0

enum {
	BFW_NETX_XM_WRK0_WR0       = 16, // [15:0]
	BFW_NETX_XM_WRK0_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR0_BIT_Ttag {
	unsigned int WR0       : BFW_NETX_XM_WRK0_WR0;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK0_reserved1; // reserved
} XMAC_WR0_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR0_BIT_T bf;
} XMAC_WR0_T;

// ---------------------------------------------------------------------
// Register xmac_wr1
// =>  xMAC internal Work Register 1
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK1   0x000008A0U
#define NETX_XM0_WRK1 0x1C0608A0U
#define NETX_XM1_WRK1 0x1C0618A0U

#define MSK_NETX_XM_WRK1_WR1 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK1_WR1 0

enum {
	BFW_NETX_XM_WRK1_WR1       = 16, // [15:0]
	BFW_NETX_XM_WRK1_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR1_BIT_Ttag {
	unsigned int WR1       : BFW_NETX_XM_WRK1_WR1;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK1_reserved1; // reserved
} XMAC_WR1_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR1_BIT_T bf;
} XMAC_WR1_T;

// ---------------------------------------------------------------------
// Register xmac_wr2
// =>  xMAC internal Work Register 2
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK2   0x000008A4U
#define NETX_XM0_WRK2 0x1C0608A4U
#define NETX_XM1_WRK2 0x1C0618A4U

#define MSK_NETX_XM_WRK2_WR2 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK2_WR2 0

enum {
	BFW_NETX_XM_WRK2_WR2       = 16, // [15:0]
	BFW_NETX_XM_WRK2_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR2_BIT_Ttag {
	unsigned int WR2       : BFW_NETX_XM_WRK2_WR2;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK2_reserved1; // reserved
} XMAC_WR2_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR2_BIT_T bf;
} XMAC_WR2_T;

// ---------------------------------------------------------------------
// Register xmac_wr3
// =>  xMAC internal Work Register 3
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK3   0x000008A8U
#define NETX_XM0_WRK3 0x1C0608A8U
#define NETX_XM1_WRK3 0x1C0618A8U

#define MSK_NETX_XM_WRK3_WR3 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK3_WR3 0

enum {
	BFW_NETX_XM_WRK3_WR3       = 16, // [15:0]
	BFW_NETX_XM_WRK3_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR3_BIT_Ttag {
	unsigned int WR3       : BFW_NETX_XM_WRK3_WR3;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK3_reserved1; // reserved
} XMAC_WR3_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR3_BIT_T bf;
} XMAC_WR3_T;

// ---------------------------------------------------------------------
// Register xmac_wr4
// =>  xMAC internal Work Register 4
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK4   0x000008ACU
#define NETX_XM0_WRK4 0x1C0608ACU
#define NETX_XM1_WRK4 0x1C0618ACU

#define MSK_NETX_XM_WRK4_WR4 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK4_WR4 0

enum {
	BFW_NETX_XM_WRK4_WR4       = 16, // [15:0]
	BFW_NETX_XM_WRK4_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR4_BIT_Ttag {
	unsigned int WR4       : BFW_NETX_XM_WRK4_WR4;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK4_reserved1; // reserved
} XMAC_WR4_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR4_BIT_T bf;
} XMAC_WR4_T;

// ---------------------------------------------------------------------
// Register xmac_wr5
// =>  xMAC internal Work Register 5
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK5   0x000008B0U
#define NETX_XM0_WRK5 0x1C0608B0U
#define NETX_XM1_WRK5 0x1C0618B0U

#define MSK_NETX_XM_WRK5_WR5 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK5_WR5 0

enum {
	BFW_NETX_XM_WRK5_WR5       = 16, // [15:0]
	BFW_NETX_XM_WRK5_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR5_BIT_Ttag {
	unsigned int WR5       : BFW_NETX_XM_WRK5_WR5;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK5_reserved1; // reserved
} XMAC_WR5_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR5_BIT_T bf;
} XMAC_WR5_T;

// ---------------------------------------------------------------------
// Register xmac_wr6
// =>  xMAC internal Work Register 6
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK6   0x000008B4U
#define NETX_XM0_WRK6 0x1C0608B4U
#define NETX_XM1_WRK6 0x1C0618B4U

#define MSK_NETX_XM_WRK6_WR6 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK6_WR6 0

enum {
	BFW_NETX_XM_WRK6_WR6       = 16, // [15:0]
	BFW_NETX_XM_WRK6_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR6_BIT_Ttag {
	unsigned int WR6       : BFW_NETX_XM_WRK6_WR6;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK6_reserved1; // reserved
} XMAC_WR6_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR6_BIT_T bf;
} XMAC_WR6_T;

// ---------------------------------------------------------------------
// Register xmac_wr7
// =>  xMAC internal Work Register 7
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK7   0x000008B8U
#define NETX_XM0_WRK7 0x1C0608B8U
#define NETX_XM1_WRK7 0x1C0618B8U

#define MSK_NETX_XM_WRK7_WR7 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK7_WR7 0

enum {
	BFW_NETX_XM_WRK7_WR7       = 16, // [15:0]
	BFW_NETX_XM_WRK7_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR7_BIT_Ttag {
	unsigned int WR7       : BFW_NETX_XM_WRK7_WR7;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK7_reserved1; // reserved
} XMAC_WR7_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR7_BIT_T bf;
} XMAC_WR7_T;

// ---------------------------------------------------------------------
// Register xmac_wr8
// =>  xMAC internal Work Register 7
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK8   0x000008BCU
#define NETX_XM0_WRK8 0x1C0608BCU
#define NETX_XM1_WRK8 0x1C0618BCU

#define MSK_NETX_XM_WRK8_WR7 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK8_WR7 0

enum {
	BFW_NETX_XM_WRK8_WR7       = 16, // [15:0]
	BFW_NETX_XM_WRK8_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR8_BIT_Ttag {
	unsigned int WR7       : BFW_NETX_XM_WRK8_WR7;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK8_reserved1; // reserved
} XMAC_WR8_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR8_BIT_T bf;
} XMAC_WR8_T;

// ---------------------------------------------------------------------
// Register xmac_wr9
// =>  xMAC internal Work Register 7
// => Mode: R/W
// ---------------------------------------------------------------------

#define REL_NETX_XM_WRK9   0x000008C0U
#define NETX_XM0_WRK9 0x1C0608C0U
#define NETX_XM1_WRK9 0x1C0618C0U

#define MSK_NETX_XM_WRK9_WR7 0x0000ffffU // [15:0]
#define SRT_NETX_XM_WRK9_WR7 0

enum {
	BFW_NETX_XM_WRK9_WR7       = 16, // [15:0]
	BFW_NETX_XM_WRK9_reserved1 = 16  // [31:16]
};

typedef struct XMAC_WR9_BIT_Ttag {
	unsigned int WR7       : BFW_NETX_XM_WRK9_WR7;       // Work Register
	unsigned int reserved1 : BFW_NETX_XM_WRK9_reserved1; // reserved
} XMAC_WR9_BIT_T;

typedef union {
	unsigned int   val;
	XMAC_WR9_BIT_T bf;
} XMAC_WR9_T;

// ---------------------------------------------------------------------
// Register xmac_sys_time
// =>  xMAC System Time
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_SYS_TIME   0x000008C4U
#define NETX_XM0_SYS_TIME 0x1C0608C4U
#define NETX_XM1_SYS_TIME 0x1C0618C4U

#define MSK_NETX_XM_SYS_TIME_sys_time 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SYS_TIME_sys_time 0

enum {
	BFW_NETX_XM_SYS_TIME_sys_time  = 16, // [15:0]
	BFW_NETX_XM_SYS_TIME_reserved1 = 16  // [31:16]
};

typedef struct XMAC_SYS_TIME_BIT_Ttag {
	unsigned int sys_time  : BFW_NETX_XM_SYS_TIME_sys_time;  // 16 lower bits of 32 bit systime_ns
	unsigned int reserved1 : BFW_NETX_XM_SYS_TIME_reserved1; // reserved
} XMAC_SYS_TIME_BIT_T;

typedef union {
	unsigned int        val;
	XMAC_SYS_TIME_BIT_T bf;
} XMAC_SYS_TIME_T;

// ---------------------------------------------------------------------
// Register xmac_sys_time_upper
// =>  xMAC System Time uppler bits,
//     latched at read access of xmac_sys_time
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_SYS_TIME_UP   0x000008C8U
#define NETX_XM0_SYS_TIME_UP 0x1C0608C8U
#define NETX_XM1_SYS_TIME_UP 0x1C0618C8U

#define MSK_NETX_XM_SYS_TIME_UP_sys_time_upper 0x0000ffffU // [15:0]
#define SRT_NETX_XM_SYS_TIME_UP_sys_time_upper 0

enum {
	BFW_NETX_XM_SYS_TIME_UP_sys_time_upper = 16, // [15:0]
	BFW_NETX_XM_SYS_TIME_UP_reserved1      = 16  // [31:16]
};

typedef struct XMAC_SYS_TIME_UPPER_BIT_Ttag {
	unsigned int sys_time_upper : BFW_NETX_XM_SYS_TIME_UP_sys_time_upper; // 16 upper bits of 32 bit systime_ns,
	                                                        // latched at read access of xmac_sys_time (lower),
	                                                        // different latch registers for RPU and TPU access.
	unsigned int reserved1      : BFW_NETX_XM_SYS_TIME_UP_reserved1;      // reserved
} XMAC_SYS_TIME_UPPER_BIT_T;

typedef union {
	unsigned int              val;
	XMAC_SYS_TIME_UPPER_BIT_T bf;
} XMAC_SYS_TIME_UPPER_T;

// ---------------------------------------------------------------------
// Register xmac_cmp0_status
// =>  xMAC Compare0 Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_CMP0_STAT   0x000008CCU
#define NETX_XM0_CMP0_STAT 0x1C0608CCU
#define NETX_XM1_CMP0_STAT 0x1C0618CCU

#define MSK_NETX_XM_CMP0_STAT_sr0_z       0x00000001U // [0]
#define SRT_NETX_XM_CMP0_STAT_sr0_z       0
#define MSK_NETX_XM_CMP0_STAT_sr1_z       0x00000002U // [1]
#define SRT_NETX_XM_CMP0_STAT_sr1_z       1
#define MSK_NETX_XM_CMP0_STAT_sr2_z       0x00000004U // [2]
#define SRT_NETX_XM_CMP0_STAT_sr2_z       2
#define MSK_NETX_XM_CMP0_STAT_sr3_z       0x00000008U // [3]
#define SRT_NETX_XM_CMP0_STAT_sr3_z       3
#define MSK_NETX_XM_CMP0_STAT_sr4_z       0x00000010U // [4]
#define SRT_NETX_XM_CMP0_STAT_sr4_z       4
#define MSK_NETX_XM_CMP0_STAT_sr5_z       0x00000020U // [5]
#define SRT_NETX_XM_CMP0_STAT_sr5_z       5
#define MSK_NETX_XM_CMP0_STAT_sr6_z       0x00000040U // [6]
#define SRT_NETX_XM_CMP0_STAT_sr6_z       6
#define MSK_NETX_XM_CMP0_STAT_sr7_z       0x00000080U // [7]
#define SRT_NETX_XM_CMP0_STAT_sr7_z       7
#define MSK_NETX_XM_CMP0_STAT_cnt_rx_z    0x00000100U // [8]
#define SRT_NETX_XM_CMP0_STAT_cnt_rx_z    8
#define MSK_NETX_XM_CMP0_STAT_cnt_tx_z    0x00000200U // [9]
#define SRT_NETX_XM_CMP0_STAT_cnt_tx_z    9
#define MSK_NETX_XM_CMP0_STAT_cnt_rx_hw_z 0x00000400U // [10]
#define SRT_NETX_XM_CMP0_STAT_cnt_rx_hw_z 10
#define MSK_NETX_XM_CMP0_STAT_cnt_tx_hw_z 0x00000800U // [11]
#define SRT_NETX_XM_CMP0_STAT_cnt_tx_hw_z 11
#define MSK_NETX_XM_CMP0_STAT_cnt1_rpu_z  0x00001000U // [12]
#define SRT_NETX_XM_CMP0_STAT_cnt1_rpu_z  12
#define MSK_NETX_XM_CMP0_STAT_cnt2_rpu_z  0x00002000U // [13]
#define SRT_NETX_XM_CMP0_STAT_cnt2_rpu_z  13
#define MSK_NETX_XM_CMP0_STAT_cnt1_tpu_z  0x00004000U // [14]
#define SRT_NETX_XM_CMP0_STAT_cnt1_tpu_z  14
#define MSK_NETX_XM_CMP0_STAT_cnt2_tpu_z  0x00008000U // [15]
#define SRT_NETX_XM_CMP0_STAT_cnt2_tpu_z  15

enum {
	BFW_NETX_XM_CMP0_STAT_sr0_z       = 1,  // [0]
	BFW_NETX_XM_CMP0_STAT_sr1_z       = 1,  // [1]
	BFW_NETX_XM_CMP0_STAT_sr2_z       = 1,  // [2]
	BFW_NETX_XM_CMP0_STAT_sr3_z       = 1,  // [3]
	BFW_NETX_XM_CMP0_STAT_sr4_z       = 1,  // [4]
	BFW_NETX_XM_CMP0_STAT_sr5_z       = 1,  // [5]
	BFW_NETX_XM_CMP0_STAT_sr6_z       = 1,  // [6]
	BFW_NETX_XM_CMP0_STAT_sr7_z       = 1,  // [7]
	BFW_NETX_XM_CMP0_STAT_cnt_rx_z    = 1,  // [8]
	BFW_NETX_XM_CMP0_STAT_cnt_tx_z    = 1,  // [9]
	BFW_NETX_XM_CMP0_STAT_cnt_rx_hw_z = 1,  // [10]
	BFW_NETX_XM_CMP0_STAT_cnt_tx_hw_z = 1,  // [11]
	BFW_NETX_XM_CMP0_STAT_cnt1_rpu_z  = 1,  // [12]
	BFW_NETX_XM_CMP0_STAT_cnt2_rpu_z  = 1,  // [13]
	BFW_NETX_XM_CMP0_STAT_cnt1_tpu_z  = 1,  // [14]
	BFW_NETX_XM_CMP0_STAT_cnt2_tpu_z  = 1,  // [15]
	BFW_NETX_XM_CMP0_STAT_reserved1   = 16  // [31:16]
};

typedef struct XMAC_CMP0_STATUS_BIT_Ttag {
	unsigned int sr0_z       : BFW_NETX_XM_CMP0_STAT_sr0_z;       // sr0 = 0
	unsigned int sr1_z       : BFW_NETX_XM_CMP0_STAT_sr1_z;       // sr1 = 0
	unsigned int sr2_z       : BFW_NETX_XM_CMP0_STAT_sr2_z;       // sr2 = 0
	unsigned int sr3_z       : BFW_NETX_XM_CMP0_STAT_sr3_z;       // sr3 = 0
	unsigned int sr4_z       : BFW_NETX_XM_CMP0_STAT_sr4_z;       // sr4 = 0
	unsigned int sr5_z       : BFW_NETX_XM_CMP0_STAT_sr5_z;       // sr5 = 0
	unsigned int sr6_z       : BFW_NETX_XM_CMP0_STAT_sr6_z;       // sr6 = 0
	unsigned int sr7_z       : BFW_NETX_XM_CMP0_STAT_sr7_z;       // sr7 = 0
	unsigned int cnt_rx_z    : BFW_NETX_XM_CMP0_STAT_cnt_rx_z;    // count_rx = 0
	unsigned int cnt_tx_z    : BFW_NETX_XM_CMP0_STAT_cnt_tx_z;    // count_tx = 0
	unsigned int cnt_rx_hw_z : BFW_NETX_XM_CMP0_STAT_cnt_rx_hw_z; // rx_hw_count = 0
	unsigned int cnt_tx_hw_z : BFW_NETX_XM_CMP0_STAT_cnt_tx_hw_z; // tx_hw_count = 0
	unsigned int cnt1_rpu_z  : BFW_NETX_XM_CMP0_STAT_cnt1_rpu_z;  // rpu_count1 = 0
	unsigned int cnt2_rpu_z  : BFW_NETX_XM_CMP0_STAT_cnt2_rpu_z;  // rpu_count2 = 0
	unsigned int cnt1_tpu_z  : BFW_NETX_XM_CMP0_STAT_cnt1_tpu_z;  // tpu_count1 = 0
	unsigned int cnt2_tpu_z  : BFW_NETX_XM_CMP0_STAT_cnt2_tpu_z;  // tpu_count2 = 0
	unsigned int reserved1   : BFW_NETX_XM_CMP0_STAT_reserved1;   // reserved
} XMAC_CMP0_STATUS_BIT_T;

typedef union {
	unsigned int           val;
	XMAC_CMP0_STATUS_BIT_T bf;
} XMAC_CMP0_STATUS_T;

// ---------------------------------------------------------------------
// Register xmac_cmp1_status
// =>  xMAC Compare1 Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_CMP1_STAT   0x000008D0U
#define NETX_XM0_CMP1_STAT 0x1C0608D0U
#define NETX_XM1_CMP1_STAT 0x1C0618D0U

#define MSK_NETX_XM_CMP1_STAT_wr0_z    0x00000001U // [0]
#define SRT_NETX_XM_CMP1_STAT_wr0_z    0
#define MSK_NETX_XM_CMP1_STAT_wr1_z    0x00000002U // [1]
#define SRT_NETX_XM_CMP1_STAT_wr1_z    1
#define MSK_NETX_XM_CMP1_STAT_wr2_z    0x00000004U // [2]
#define SRT_NETX_XM_CMP1_STAT_wr2_z    2
#define MSK_NETX_XM_CMP1_STAT_wr3_z    0x00000008U // [3]
#define SRT_NETX_XM_CMP1_STAT_wr3_z    3
#define MSK_NETX_XM_CMP1_STAT_wr4_z    0x00000010U // [4]
#define SRT_NETX_XM_CMP1_STAT_wr4_z    4
#define MSK_NETX_XM_CMP1_STAT_wr5_z    0x00000020U // [5]
#define SRT_NETX_XM_CMP1_STAT_wr5_z    5
#define MSK_NETX_XM_CMP1_STAT_wr6_z    0x00000040U // [6]
#define SRT_NETX_XM_CMP1_STAT_wr6_z    6
#define MSK_NETX_XM_CMP1_STAT_wr7_z    0x00000080U // [7]
#define SRT_NETX_XM_CMP1_STAT_wr7_z    7
#define MSK_NETX_XM_CMP1_STAT_wr8_z    0x00000100U // [8]
#define SRT_NETX_XM_CMP1_STAT_wr8_z    8
#define MSK_NETX_XM_CMP1_STAT_wr9_z    0x00000200U // [9]
#define SRT_NETX_XM_CMP1_STAT_wr9_z    9
#define MSK_NETX_XM_CMP1_STAT_wr0_wr1  0x00000400U // [10]
#define SRT_NETX_XM_CMP1_STAT_wr0_wr1  10
#define MSK_NETX_XM_CMP1_STAT_wr2_wr3  0x00000800U // [11]
#define SRT_NETX_XM_CMP1_STAT_wr2_wr3  11
#define MSK_NETX_XM_CMP1_STAT_wr4_wr5  0x00001000U // [12]
#define SRT_NETX_XM_CMP1_STAT_wr4_wr5  12
#define MSK_NETX_XM_CMP1_STAT_wr6_wr7  0x00002000U // [13]
#define SRT_NETX_XM_CMP1_STAT_wr6_wr7  13
#define MSK_NETX_XM_CMP1_STAT_wr8_wr9  0x00004000U // [14]
#define SRT_NETX_XM_CMP1_STAT_wr8_wr9  14
#define MSK_NETX_XM_CMP1_STAT_sys_time 0x00008000U // [15]
#define SRT_NETX_XM_CMP1_STAT_sys_time 15

enum {
	BFW_NETX_XM_CMP1_STAT_wr0_z     = 1,  // [0]
	BFW_NETX_XM_CMP1_STAT_wr1_z     = 1,  // [1]
	BFW_NETX_XM_CMP1_STAT_wr2_z     = 1,  // [2]
	BFW_NETX_XM_CMP1_STAT_wr3_z     = 1,  // [3]
	BFW_NETX_XM_CMP1_STAT_wr4_z     = 1,  // [4]
	BFW_NETX_XM_CMP1_STAT_wr5_z     = 1,  // [5]
	BFW_NETX_XM_CMP1_STAT_wr6_z     = 1,  // [6]
	BFW_NETX_XM_CMP1_STAT_wr7_z     = 1,  // [7]
	BFW_NETX_XM_CMP1_STAT_wr8_z     = 1,  // [8]
	BFW_NETX_XM_CMP1_STAT_wr9_z     = 1,  // [9]
	BFW_NETX_XM_CMP1_STAT_wr0_wr1   = 1,  // [10]
	BFW_NETX_XM_CMP1_STAT_wr2_wr3   = 1,  // [11]
	BFW_NETX_XM_CMP1_STAT_wr4_wr5   = 1,  // [12]
	BFW_NETX_XM_CMP1_STAT_wr6_wr7   = 1,  // [13]
	BFW_NETX_XM_CMP1_STAT_wr8_wr9   = 1,  // [14]
	BFW_NETX_XM_CMP1_STAT_sys_time  = 1,  // [15]
	BFW_NETX_XM_CMP1_STAT_reserved1 = 16  // [31:16]
};

typedef struct XMAC_CMP1_STATUS_BIT_Ttag {
	unsigned int wr0_z     : BFW_NETX_XM_CMP1_STAT_wr0_z;     // 1: work register 0 equals 0
	unsigned int wr1_z     : BFW_NETX_XM_CMP1_STAT_wr1_z;     // 1: work register 1 equals 0
	unsigned int wr2_z     : BFW_NETX_XM_CMP1_STAT_wr2_z;     // 1: work register 2 equals 0
	unsigned int wr3_z     : BFW_NETX_XM_CMP1_STAT_wr3_z;     // 1: work register 3 equals 0
	unsigned int wr4_z     : BFW_NETX_XM_CMP1_STAT_wr4_z;     // 1: work register 4 equals 0
	unsigned int wr5_z     : BFW_NETX_XM_CMP1_STAT_wr5_z;     // 1: work register 5 equals 0
	unsigned int wr6_z     : BFW_NETX_XM_CMP1_STAT_wr6_z;     // 1: work register 6 equals 0
	unsigned int wr7_z     : BFW_NETX_XM_CMP1_STAT_wr7_z;     // 1: work register 7 equals 0
	unsigned int wr8_z     : BFW_NETX_XM_CMP1_STAT_wr8_z;     // 1: work register 8 equals 0
	unsigned int wr9_z     : BFW_NETX_XM_CMP1_STAT_wr9_z;     // 1: work register 9 equals 0
	unsigned int wr0_wr1   : BFW_NETX_XM_CMP1_STAT_wr0_wr1;   // 1: wr0 equals wr1
	unsigned int wr2_wr3   : BFW_NETX_XM_CMP1_STAT_wr2_wr3;   // 1: wr2 equals wr3
	unsigned int wr4_wr5   : BFW_NETX_XM_CMP1_STAT_wr4_wr5;   // 1: wr4 equals wr5
	unsigned int wr6_wr7   : BFW_NETX_XM_CMP1_STAT_wr6_wr7;   // 1: wr6 equals wr7
	unsigned int wr8_wr9   : BFW_NETX_XM_CMP1_STAT_wr8_wr9;   // 1: wr8 equals wr9
	unsigned int sys_time  : BFW_NETX_XM_CMP1_STAT_sys_time;  // compare of sys_time with wr6,wr2(value) and wr7,wr3(mask):
	                                                        // {wr7,wr3} define, which bits of sys_time and {wr6,wr2} are to be compared
	                                                        // (1: compare this bit position, 0: ignore this bit position)
	unsigned int reserved1 : BFW_NETX_XM_CMP1_STAT_reserved1; // reserved
} XMAC_CMP1_STATUS_BIT_T;

typedef union {
	unsigned int           val;
	XMAC_CMP1_STATUS_BIT_T bf;
} XMAC_CMP1_STATUS_T;

// ---------------------------------------------------------------------
// Register xmac_cmp2_status
// =>  xMAC Compare2 Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_CMP2_STAT   0x000008D4U
#define NETX_XM0_CMP2_STAT 0x1C0608D4U
#define NETX_XM1_CMP2_STAT 0x1C0618D4U

#define MSK_NETX_XM_CMP2_STAT_wr0_sr0  0x00000001U // [0]
#define SRT_NETX_XM_CMP2_STAT_wr0_sr0  0
#define MSK_NETX_XM_CMP2_STAT_wr1_sr1  0x00000002U // [1]
#define SRT_NETX_XM_CMP2_STAT_wr1_sr1  1
#define MSK_NETX_XM_CMP2_STAT_wr2_sr2  0x00000004U // [2]
#define SRT_NETX_XM_CMP2_STAT_wr2_sr2  2
#define MSK_NETX_XM_CMP2_STAT_wr3_sr3  0x00000008U // [3]
#define SRT_NETX_XM_CMP2_STAT_wr3_sr3  3
#define MSK_NETX_XM_CMP2_STAT_wr4_sr4  0x00000010U // [4]
#define SRT_NETX_XM_CMP2_STAT_wr4_sr4  4
#define MSK_NETX_XM_CMP2_STAT_wr5_sr5  0x00000020U // [5]
#define SRT_NETX_XM_CMP2_STAT_wr5_sr5  5
#define MSK_NETX_XM_CMP2_STAT_wr6_sr6  0x00000040U // [6]
#define SRT_NETX_XM_CMP2_STAT_wr6_sr6  6
#define MSK_NETX_XM_CMP2_STAT_wr7_sr7  0x00000080U // [7]
#define SRT_NETX_XM_CMP2_STAT_wr7_sr7  7
#define MSK_NETX_XM_CMP2_STAT_wr8_sr8  0x00000100U // [8]
#define SRT_NETX_XM_CMP2_STAT_wr8_sr8  8
#define MSK_NETX_XM_CMP2_STAT_wr9_sr9  0x00000200U // [9]
#define SRT_NETX_XM_CMP2_STAT_wr9_sr9  9
#define MSK_NETX_XM_CMP2_STAT_wr5_sr10 0x00000400U // [10]
#define SRT_NETX_XM_CMP2_STAT_wr5_sr10 10
#define MSK_NETX_XM_CMP2_STAT_wr6_sr11 0x00000800U // [11]
#define SRT_NETX_XM_CMP2_STAT_wr6_sr11 11
#define MSK_NETX_XM_CMP2_STAT_wr5_sr12 0x00001000U // [12]
#define SRT_NETX_XM_CMP2_STAT_wr5_sr12 12
#define MSK_NETX_XM_CMP2_STAT_wr6_sr13 0x00002000U // [13]
#define SRT_NETX_XM_CMP2_STAT_wr6_sr13 13
#define MSK_NETX_XM_CMP2_STAT_wr5_sr14 0x00004000U // [14]
#define SRT_NETX_XM_CMP2_STAT_wr5_sr14 14
#define MSK_NETX_XM_CMP2_STAT_wr6_sr15 0x00008000U // [15]
#define SRT_NETX_XM_CMP2_STAT_wr6_sr15 15

enum {
	BFW_NETX_XM_CMP2_STAT_wr0_sr0   = 1,  // [0]
	BFW_NETX_XM_CMP2_STAT_wr1_sr1   = 1,  // [1]
	BFW_NETX_XM_CMP2_STAT_wr2_sr2   = 1,  // [2]
	BFW_NETX_XM_CMP2_STAT_wr3_sr3   = 1,  // [3]
	BFW_NETX_XM_CMP2_STAT_wr4_sr4   = 1,  // [4]
	BFW_NETX_XM_CMP2_STAT_wr5_sr5   = 1,  // [5]
	BFW_NETX_XM_CMP2_STAT_wr6_sr6   = 1,  // [6]
	BFW_NETX_XM_CMP2_STAT_wr7_sr7   = 1,  // [7]
	BFW_NETX_XM_CMP2_STAT_wr8_sr8   = 1,  // [8]
	BFW_NETX_XM_CMP2_STAT_wr9_sr9   = 1,  // [9]
	BFW_NETX_XM_CMP2_STAT_wr5_sr10  = 1,  // [10]
	BFW_NETX_XM_CMP2_STAT_wr6_sr11  = 1,  // [11]
	BFW_NETX_XM_CMP2_STAT_wr5_sr12  = 1,  // [12]
	BFW_NETX_XM_CMP2_STAT_wr6_sr13  = 1,  // [13]
	BFW_NETX_XM_CMP2_STAT_wr5_sr14  = 1,  // [14]
	BFW_NETX_XM_CMP2_STAT_wr6_sr15  = 1,  // [15]
	BFW_NETX_XM_CMP2_STAT_reserved1 = 16  // [31:16]
};

typedef struct XMAC_CMP2_STATUS_BIT_Ttag {
	unsigned int wr0_sr0   : BFW_NETX_XM_CMP2_STAT_wr0_sr0;   // 1: wr0 equals sr0
	unsigned int wr1_sr1   : BFW_NETX_XM_CMP2_STAT_wr1_sr1;   // 1: wr1 equals sr1
	unsigned int wr2_sr2   : BFW_NETX_XM_CMP2_STAT_wr2_sr2;   // 1: wr2 equals sr2
	unsigned int wr3_sr3   : BFW_NETX_XM_CMP2_STAT_wr3_sr3;   // 1: wr3 equals sr3
	unsigned int wr4_sr4   : BFW_NETX_XM_CMP2_STAT_wr4_sr4;   // 1: wr4 equals sr4
	unsigned int wr5_sr5   : BFW_NETX_XM_CMP2_STAT_wr5_sr5;   // 1: wr5 equals sr5
	unsigned int wr6_sr6   : BFW_NETX_XM_CMP2_STAT_wr6_sr6;   // 1: wr6 equals sr6
	unsigned int wr7_sr7   : BFW_NETX_XM_CMP2_STAT_wr7_sr7;   // 1: wr7 equals sr7
	unsigned int wr8_sr8   : BFW_NETX_XM_CMP2_STAT_wr8_sr8;   // 1: wr8 equals sr8
	unsigned int wr9_sr9   : BFW_NETX_XM_CMP2_STAT_wr9_sr9;   // 1: wr9 equals sr9
	unsigned int wr5_sr10  : BFW_NETX_XM_CMP2_STAT_wr5_sr10;  // 1: wr5 equals sr10
	unsigned int wr6_sr11  : BFW_NETX_XM_CMP2_STAT_wr6_sr11;  // 1: wr6 equals sr11
	unsigned int wr5_sr12  : BFW_NETX_XM_CMP2_STAT_wr5_sr12;  // 1: wr5 equals sr12
	unsigned int wr6_sr13  : BFW_NETX_XM_CMP2_STAT_wr6_sr13;  // 1: wr6 equals sr13
	unsigned int wr5_sr14  : BFW_NETX_XM_CMP2_STAT_wr5_sr14;  // 1: wr5 equals sr14
	unsigned int wr6_sr15  : BFW_NETX_XM_CMP2_STAT_wr6_sr15;  // 1: wr6 equals sr15
	unsigned int reserved1 : BFW_NETX_XM_CMP2_STAT_reserved1; // reserved
} XMAC_CMP2_STATUS_BIT_T;

typedef union {
	unsigned int           val;
	XMAC_CMP2_STATUS_BIT_T bf;
} XMAC_CMP2_STATUS_T;

// ---------------------------------------------------------------------
// Register xmac_cmp3_status
// =>  xMAC Compare3 Status Register
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_CMP3_STAT   0x000008D8U
#define NETX_XM0_CMP3_STAT 0x1C0608D8U
#define NETX_XM1_CMP3_STAT 0x1C0618D8U

#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr0 0x00000001U // [0]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr0 0
#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr1 0x00000002U // [1]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr1 1
#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr2 0x00000004U // [2]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr2 2
#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr3 0x00000008U // [3]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr3 3
#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr4 0x00000010U // [4]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr4 4
#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr5 0x00000020U // [5]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr5 5
#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr6 0x00000040U // [6]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr6 6
#define MSK_NETX_XM_CMP3_STAT_rpucnt1_wr7 0x00000080U // [7]
#define SRT_NETX_XM_CMP3_STAT_rpucnt1_wr7 7
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr0 0x00000100U // [8]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr0 8
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr1 0x00000200U // [9]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr1 9
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr2 0x00000400U // [10]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr2 10
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr3 0x00000800U // [11]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr3 11
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr4 0x00001000U // [12]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr4 12
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr5 0x00002000U // [13]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr5 13
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr6 0x00004000U // [14]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr6 14
#define MSK_NETX_XM_CMP3_STAT_tpucnt1_wr7 0x00008000U // [15]
#define SRT_NETX_XM_CMP3_STAT_tpucnt1_wr7 15

enum {
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr0 = 1,  // [0]
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr1 = 1,  // [1]
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr2 = 1,  // [2]
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr3 = 1,  // [3]
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr4 = 1,  // [4]
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr5 = 1,  // [5]
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr6 = 1,  // [6]
	BFW_NETX_XM_CMP3_STAT_rpucnt1_wr7 = 1,  // [7]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr0 = 1,  // [8]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr1 = 1,  // [9]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr2 = 1,  // [10]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr3 = 1,  // [11]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr4 = 1,  // [12]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr5 = 1,  // [13]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr6 = 1,  // [14]
	BFW_NETX_XM_CMP3_STAT_tpucnt1_wr7 = 1,  // [15]
	BFW_NETX_XM_CMP3_STAT_reserved1   = 16  // [31:16]
};

typedef struct XMAC_CMP3_STATUS_BIT_Ttag {
	unsigned int rpucnt1_wr0 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr0; // 1: rpu_count1 equals wr0
	unsigned int rpucnt1_wr1 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr1; // 1: rpu_count1 equals wr1
	unsigned int rpucnt1_wr2 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr2; // 1: rpu_count1 equals wr2
	unsigned int rpucnt1_wr3 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr3; // 1: rpu_count1 equals wr3
	unsigned int rpucnt1_wr4 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr4; // 1: rpu_count1 equals wr4
	unsigned int rpucnt1_wr5 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr5; // 1: rpu_count1 equals wr5
	unsigned int rpucnt1_wr6 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr6; // 1: rpu_count1 equals wr6
	unsigned int rpucnt1_wr7 : BFW_NETX_XM_CMP3_STAT_rpucnt1_wr7; // 1: rpu_count1 equals wr7
	unsigned int tpucnt1_wr0 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr0; // 1: tpu_count1 equals wr0
	unsigned int tpucnt1_wr1 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr1; // 1: tpu_count1 equals wr1
	unsigned int tpucnt1_wr2 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr2; // 1: tpu_count1 equals wr2
	unsigned int tpucnt1_wr3 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr3; // 1: tpu_count1 equals wr3
	unsigned int tpucnt1_wr4 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr4; // 1: tpu_count1 equals wr4
	unsigned int tpucnt1_wr5 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr5; // 1: tpu_count1 equals wr5
	unsigned int tpucnt1_wr6 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr6; // 1: tpu_count1 equals wr6
	unsigned int tpucnt1_wr7 : BFW_NETX_XM_CMP3_STAT_tpucnt1_wr7; // 1: tpu_count1 equals wr7
	unsigned int reserved1   : BFW_NETX_XM_CMP3_STAT_reserved1;   // reserved
} XMAC_CMP3_STATUS_BIT_T;

typedef union {
	unsigned int           val;
	XMAC_CMP3_STATUS_BIT_T bf;
} XMAC_CMP3_STATUS_T;

// ---------------------------------------------------------------------
// Register xmac_alu_flags
// =>  xMAC RPU and TPU ALU Flags:
//     ALU Flags are only influenced by combinatonal commands like add, sub, rotate, shift.
//     Bitwise commands (e.g. and, or, ...) do not influence ALU-Flags.
//     In case of bitwise commands, ALU-Flags keep their old value.
// => Mode: R
// ---------------------------------------------------------------------

#define REL_NETX_XM_ALU_FLAG   0x000008DCU
#define NETX_XM0_ALU_FLAG 0x1C0608DCU
#define NETX_XM1_ALU_FLAG 0x1C0618DCU

#define MSK_NETX_XM_ALU_FLAG_rpu_carry 0x00000001U // [0]
#define SRT_NETX_XM_ALU_FLAG_rpu_carry 0
#define MSK_NETX_XM_ALU_FLAG_rpu_zero  0x00000002U // [1]
#define SRT_NETX_XM_ALU_FLAG_rpu_zero  1
#define MSK_NETX_XM_ALU_FLAG_rpu_neg   0x00000004U // [2]
#define SRT_NETX_XM_ALU_FLAG_rpu_neg   2
#define MSK_NETX_XM_ALU_FLAG_rpu_ovf   0x00000008U // [3]
#define SRT_NETX_XM_ALU_FLAG_rpu_ovf   3
#define MSK_NETX_XM_ALU_FLAG_tpu_carry 0x00000010U // [4]
#define SRT_NETX_XM_ALU_FLAG_tpu_carry 4
#define MSK_NETX_XM_ALU_FLAG_tpu_zero  0x00000020U // [5]
#define SRT_NETX_XM_ALU_FLAG_tpu_zero  5
#define MSK_NETX_XM_ALU_FLAG_tpu_neg   0x00000040U // [6]
#define SRT_NETX_XM_ALU_FLAG_tpu_neg   6
#define MSK_NETX_XM_ALU_FLAG_tpu_ovf   0x00000080U // [7]
#define SRT_NETX_XM_ALU_FLAG_tpu_ovf   7
#define MSK_NETX_XM_ALU_FLAG_rxcnt_wr2 0x00004000U // [14]
#define SRT_NETX_XM_ALU_FLAG_rxcnt_wr2 14
#define MSK_NETX_XM_ALU_FLAG_txcnt_wr7 0x00008000U // [15]
#define SRT_NETX_XM_ALU_FLAG_txcnt_wr7 15

enum {
	BFW_NETX_XM_ALU_FLAG_rpu_carry = 1,  // [0]
	BFW_NETX_XM_ALU_FLAG_rpu_zero  = 1,  // [1]
	BFW_NETX_XM_ALU_FLAG_rpu_neg   = 1,  // [2]
	BFW_NETX_XM_ALU_FLAG_rpu_ovf   = 1,  // [3]
	BFW_NETX_XM_ALU_FLAG_tpu_carry = 1,  // [4]
	BFW_NETX_XM_ALU_FLAG_tpu_zero  = 1,  // [5]
	BFW_NETX_XM_ALU_FLAG_tpu_neg   = 1,  // [6]
	BFW_NETX_XM_ALU_FLAG_tpu_ovf   = 1,  // [7]
	BFW_NETX_XM_ALU_FLAG_reserved1 = 6,  // [13:8]
	BFW_NETX_XM_ALU_FLAG_rxcnt_wr2 = 1,  // [14]
	BFW_NETX_XM_ALU_FLAG_txcnt_wr7 = 1,  // [15]
	BFW_NETX_XM_ALU_FLAG_reserved2 = 16  // [31:16]
};

typedef struct XMAC_ALU_FLAGS_BIT_Ttag {
	unsigned int rpu_carry : BFW_NETX_XM_ALU_FLAG_rpu_carry; // RPU carry flag
	unsigned int rpu_zero  : BFW_NETX_XM_ALU_FLAG_rpu_zero;  // RPU zero flag
	unsigned int rpu_neg   : BFW_NETX_XM_ALU_FLAG_rpu_neg;   // RPU neg flag
	unsigned int rpu_ovf   : BFW_NETX_XM_ALU_FLAG_rpu_ovf;   // RPU ovf flag
	unsigned int tpu_carry : 